﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/directory-service-data/DirectoryServiceData_EXPORTS.h>
#include <aws/directory-service-data/model/Member.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace DirectoryServiceData {
namespace Model {
class ListGroupMembersResult {
 public:
  AWS_DIRECTORYSERVICEDATA_API ListGroupMembersResult() = default;
  AWS_DIRECTORYSERVICEDATA_API ListGroupMembersResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_DIRECTORYSERVICEDATA_API ListGroupMembersResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>Identifier (ID) of the directory associated with the group.</p>
   */
  inline const Aws::String& GetDirectoryId() const { return m_directoryId; }
  template <typename DirectoryIdT = Aws::String>
  void SetDirectoryId(DirectoryIdT&& value) {
    m_directoryIdHasBeenSet = true;
    m_directoryId = std::forward<DirectoryIdT>(value);
  }
  template <typename DirectoryIdT = Aws::String>
  ListGroupMembersResult& WithDirectoryId(DirectoryIdT&& value) {
    SetDirectoryId(std::forward<DirectoryIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The domain name that's associated with the member. </p>
   */
  inline const Aws::String& GetMemberRealm() const { return m_memberRealm; }
  template <typename MemberRealmT = Aws::String>
  void SetMemberRealm(MemberRealmT&& value) {
    m_memberRealmHasBeenSet = true;
    m_memberRealm = std::forward<MemberRealmT>(value);
  }
  template <typename MemberRealmT = Aws::String>
  ListGroupMembersResult& WithMemberRealm(MemberRealmT&& value) {
    SetMemberRealm(std::forward<MemberRealmT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The member information that the request returns. </p>
   */
  inline const Aws::Vector<Member>& GetMembers() const { return m_members; }
  template <typename MembersT = Aws::Vector<Member>>
  void SetMembers(MembersT&& value) {
    m_membersHasBeenSet = true;
    m_members = std::forward<MembersT>(value);
  }
  template <typename MembersT = Aws::Vector<Member>>
  ListGroupMembersResult& WithMembers(MembersT&& value) {
    SetMembers(std::forward<MembersT>(value));
    return *this;
  }
  template <typename MembersT = Member>
  ListGroupMembersResult& AddMembers(MembersT&& value) {
    m_membersHasBeenSet = true;
    m_members.emplace_back(std::forward<MembersT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> An encoded paging token for paginated calls that can be passed back to
   * retrieve the next page. </p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListGroupMembersResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The domain name that's associated with the group. </p>
   */
  inline const Aws::String& GetRealm() const { return m_realm; }
  template <typename RealmT = Aws::String>
  void SetRealm(RealmT&& value) {
    m_realmHasBeenSet = true;
    m_realm = std::forward<RealmT>(value);
  }
  template <typename RealmT = Aws::String>
  ListGroupMembersResult& WithRealm(RealmT&& value) {
    SetRealm(std::forward<RealmT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListGroupMembersResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_directoryId;

  Aws::String m_memberRealm;

  Aws::Vector<Member> m_members;

  Aws::String m_nextToken;

  Aws::String m_realm;

  Aws::String m_requestId;
  bool m_directoryIdHasBeenSet = false;
  bool m_memberRealmHasBeenSet = false;
  bool m_membersHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_realmHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace DirectoryServiceData
}  // namespace Aws
