/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.asta;

import java.util.ArrayList;

class RowHeader {
    private String m_id;
    private int m_sequence;
    private Integer m_type;
    private int m_subtype;

    public RowHeader(String header) {
        this.parse(header);
    }

    private void parse(String header) {
        ArrayList<String> list = new ArrayList<String>(4);
        StringBuilder sb = new StringBuilder();
        int index = 1;
        while (index < header.length()) {
            char c;
            if (Character.isDigit(c = header.charAt(index++))) {
                sb.append(c);
                continue;
            }
            if (sb.length() == 0) continue;
            list.add(sb.toString());
            sb.setLength(0);
        }
        if (sb.length() != 0) {
            list.add(sb.toString());
        }
        this.m_id = (String)list.get(0);
        this.m_sequence = Integer.parseInt((String)list.get(1));
        this.m_type = Integer.valueOf((String)list.get(2));
        if (list.size() > 3) {
            this.m_subtype = Integer.parseInt((String)list.get(3));
        }
    }

    public String getID() {
        return this.m_id;
    }

    public int getSequence() {
        return this.m_sequence;
    }

    public Integer getType() {
        return this.m_type;
    }

    public int getSubtype() {
        return this.m_subtype;
    }

    public String toString() {
        return "[RowHeader id=" + this.m_id + " sequence=" + this.m_sequence + " type=" + this.m_type + " subtype=" + this.m_subtype + "]";
    }
}

