/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.parser.rules;

import org.eclipse.core.runtime.Assert;
import org.jkiss.dbeaver.model.text.parser.TPCharacterScanner;
import org.jkiss.dbeaver.model.text.parser.TPRule;
import org.jkiss.dbeaver.model.text.parser.TPToken;
import org.jkiss.dbeaver.model.text.parser.TPTokenAbstract;

public class SQLMultiWordRule
implements TPRule {
    private final String[] parts;
    private final TPToken token;

    public SQLMultiWordRule(String[] parts, TPToken token) {
        this.parts = parts;
        this.token = token;
        Assert.isLegal((parts.length > 1 ? 1 : 0) != 0, (String)"Multi-word rule should consist of two or more parts");
    }

    @Override
    public TPToken evaluate(TPCharacterScanner scanner) {
        int ch = scanner.read();
        int read = 1;
        block0: for (int partIndex = 0; partIndex < this.parts.length && ch != -1 && Character.isUnicodeIdentifierStart(ch); ++partIndex) {
            for (char partCh : this.parts[partIndex].toCharArray()) {
                if (ch == -1 || !Character.isUnicodeIdentifierPart(ch) || Character.toUpperCase(partCh) != Character.toUpperCase(ch)) break block0;
                ch = scanner.read();
                ++read;
            }
            if (partIndex == this.parts.length - 1 && !Character.isUnicodeIdentifierPart(ch)) {
                scanner.unread();
                return this.token;
            }
            if (ch == -1 || !Character.isWhitespace(ch)) break;
            while (ch != -1 && Character.isWhitespace(ch)) {
                ch = scanner.read();
                ++read;
            }
        }
        while (read > 0) {
            scanner.unread();
            --read;
        }
        return TPTokenAbstract.UNDEFINED;
    }
}

