/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.net.ssh;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.ssh.AbstractSessionController;
import org.jkiss.dbeaver.model.net.ssh.JSCHSession;
import org.jkiss.dbeaver.model.net.ssh.JSCHUIMessages;
import org.jkiss.dbeaver.model.net.ssh.JSCHUserInfoPromptProvider;
import org.jkiss.dbeaver.model.net.ssh.SSHUtils;
import org.jkiss.dbeaver.model.net.ssh.config.SSHAuthConfiguration;
import org.jkiss.dbeaver.model.net.ssh.config.SSHHostConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.SecurityUtils;

public class JSCHSessionController
extends AbstractSessionController<JSCHSession> {
    private static final Log log = Log.getLog(JSCHSessionController.class);

    public JSCHSessionController() {
        JSch.setLogger((Logger)new JschLogger());
    }

    @NotNull
    protected JSCHSession createSession() {
        return new JSCHSession(this);
    }

    @NotNull
    protected Session createNewSession(@NotNull DBRProgressMonitor monitor, @NotNull DBWHandlerConfiguration configuration, @NotNull SSHHostConfiguration destination) throws DBException {
        JSch jsch = new JSch();
        SSHAuthConfiguration auth = destination.auth();
        if (auth instanceof SSHAuthConfiguration.Password) {
            log.debug((Object)"SSHSessionController: Using password authentication");
        } else if (auth instanceof SSHAuthConfiguration.KeyFile) {
            SSHAuthConfiguration.KeyFile key = (SSHAuthConfiguration.KeyFile)auth;
            log.debug((Object)"SSHSessionController: Using public key authentication");
            try {
                this.addIdentityKeyFile(jsch, monitor, configuration.getDataSource(), Path.of(key.path(), new String[0]), key.password());
            }
            catch (Exception e) {
                throw new DBException("Error adding identity key", (Throwable)e);
            }
        } else if (auth instanceof SSHAuthConfiguration.KeyData) {
            SSHAuthConfiguration.KeyData key = (SSHAuthConfiguration.KeyData)auth;
            log.debug((Object)"SSHSessionController: Using public key authentication");
            try {
                this.addIdentityKeyValue(jsch, key.data(), key.password());
            }
            catch (Exception e) {
                throw new DBException("Error adding identity key", (Throwable)e);
            }
        } else if (auth instanceof SSHAuthConfiguration.Agent) {
            log.debug((Object)"SSHSessionController: Using agent authentication");
            jsch.setIdentityRepository(this.createAgentIdentityRepository());
        }
        try {
            Session session = jsch.getSession(destination.username(), destination.hostname(), destination.port());
            UserInfo userInfo = null;
            JSCHUserInfoPromptProvider userInfoPromptProvider = (JSCHUserInfoPromptProvider)GeneralUtils.adapt((Object)((Object)this), JSCHUserInfoPromptProvider.class);
            if (userInfoPromptProvider != null) {
                userInfo = userInfoPromptProvider.createUserInfoPrompt(destination, session);
            }
            if (userInfo == null) {
                userInfo = new JschUserInfo(auth);
            }
            session.setUserInfo(userInfo);
            session.setHostKeyAlias(destination.hostname());
            session.setServerAliveInterval(configuration.getIntProperty("aliveInterval"));
            session.setTimeout(configuration.getIntProperty("sshConnectTimeout", 10000));
            this.setupHostKeyVerification(jsch, session, configuration);
            if (auth instanceof SSHAuthConfiguration.Password) {
                session.setConfig("PreferredAuthentications", "password,keyboard-interactive");
            } else {
                session.setConfig("PreferredAuthentications", "publickey,keyboard-interactive,password");
            }
            session.connect();
            return session;
        }
        catch (JSchException e) {
            throw new DBException("Failed to open JSch tunnel", (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setupHostKeyVerification(@NotNull JSch jsch, @NotNull Session session, @NotNull DBWHandlerConfiguration configuration) throws JSchException {
        if (DBWorkbench.getPlatform().getApplication().isHeadlessMode() || configuration.getBooleanProperty("bypassHostVerification")) {
            session.setConfig("StrictHostKeyChecking", "no");
            return;
        } else {
            File knownHosts = SSHUtils.getKnownSshHostsFileOrNull();
            if (knownHosts != null) {
                try {
                    jsch.setKnownHosts(knownHosts.getAbsolutePath());
                    session.setConfig("StrictHostKeyChecking", "ask");
                    return;
                }
                catch (JSchException e) {
                    if (!(e.getCause() instanceof ArrayIndexOutOfBoundsException)) return;
                    if (!DBWorkbench.getPlatformUI().confirmAction(JSCHUIMessages.ssh_file_corrupted_dialog_title, JSCHUIMessages.ssh_file_corrupted_dialog_message, true)) throw e;
                    session.setConfig("StrictHostKeyChecking", "no");
                    return;
                }
            } else {
                session.setConfig("StrictHostKeyChecking", "ask");
            }
        }
    }

    private void addIdentityKeyValue(@NotNull JSch jsch, String keyValue, String password) throws JSchException {
        byte[] keyBinary = keyValue.getBytes(StandardCharsets.UTF_8);
        if (!CommonUtils.isEmpty((String)password)) {
            jsch.addIdentity("key", keyBinary, null, password.getBytes());
        } else {
            jsch.addIdentity("key", keyBinary, null, null);
        }
    }

    private void addIdentityKeyFile(@NotNull JSch jsch, @NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer dataSource, @NotNull Path key, @Nullable String password) throws IOException, JSchException {
        String header;
        try (BufferedReader reader = Files.newBufferedReader(key);){
            header = reader.readLine();
        }
        if (header.equals("-----BEGIN OPENSSH PRIVATE KEY-----")) {
            log.debug((Object)"Attempting to convert an unsupported key into suitable format");
            Path dir = DBWorkbench.getPlatform().getTempFolder(monitor, "openssh-pkey");
            Path tmp = dir.resolve(dataSource.getId() + ".pem");
            Files.copy(key, tmp, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
            password = CommonUtils.notEmpty((String)password);
            if (RuntimeUtils.isWindows()) {
                password = "\"" + (String)password + "\"";
            }
            Process process = new ProcessBuilder(new String[0]).command(new String[]{"ssh-keygen", "-p", "-P", password, "-N", password, "-m", "PEM", "-f", tmp.toAbsolutePath().toString(), "-q"}).start();
            try {
                int status;
                if (!process.waitFor(5000L, TimeUnit.MILLISECONDS)) {
                    process.destroyForcibly();
                }
                if ((status = process.exitValue()) != 0) {
                    String message;
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));){
                        message = reader.lines().collect(Collectors.joining("\n"));
                    }
                    log.error((Object)("Specified private key cannot be converted: " + message));
                    this.addIdentityKey0(jsch, key, (String)password);
                    return;
                }
                this.addIdentityKey0(jsch, tmp, (String)password);
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
            finally {
                try {
                    Files.delete(tmp);
                }
                catch (IOException e) {
                    log.debug((Object)"Failed to delete private key file", (Throwable)e);
                }
            }
        }
        this.addIdentityKey0(jsch, key, (String)password);
    }

    private void addIdentityKey0(@NotNull JSch jsch, Path key, String password) throws JSchException {
        if (!CommonUtils.isEmpty((String)password)) {
            jsch.addIdentity(key.toAbsolutePath().toString(), password);
        } else {
            jsch.addIdentity(key.toAbsolutePath().toString());
        }
    }

    private static class JschLogger
    implements Logger {
        private static final Pattern[] SENSITIVE_DATA_PATTERNS = new Pattern[]{Pattern.compile("^Connecting to (.*?) port"), Pattern.compile("^Disconnecting from (.*?) port"), Pattern.compile("^Host '(.*?)'"), Pattern.compile("^Permanently added '(.*?)'")};

        private JschLogger() {
        }

        public boolean isEnabled(int level) {
            return true;
        }

        public void log(int level, String message) {
            String levelStr = switch (level) {
                case 1 -> "INFO";
                case 2 -> "WARN";
                case 3 -> "ERROR";
                case 4 -> "FATAL";
                default -> "DEBUG";
            };
            for (Pattern pattern : SENSITIVE_DATA_PATTERNS) {
                message = CommonUtils.replaceFirstGroup((String)message, (Pattern)pattern, (int)1, SecurityUtils::mask);
            }
            log.debug((Object)("SSH: " + levelStr + ": " + message));
        }
    }

    private record JschUserInfo(@NotNull SSHAuthConfiguration configuration) implements UserInfo,
    UIKeyboardInteractive
    {
        public String getPassphrase() {
            return ((SSHAuthConfiguration.WithPassword)this.configuration).password();
        }

        public String getPassword() {
            return this.getPassphrase();
        }

        public boolean promptPassword(String message) {
            return true;
        }

        public boolean promptPassphrase(String message) {
            return true;
        }

        public boolean promptYesNo(String message) {
            return false;
        }

        public void showMessage(String message) {
            log.info((Object)message);
        }

        public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
            log.debug((Object)"JSCH keyboard interactive auth");
            return new String[]{this.getPassphrase()};
        }
    }
}

