/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.hana.model;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBDatabaseException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericExecutionContext;
import org.jkiss.dbeaver.ext.generic.model.GenericObjectContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericProcedure;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericTable;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.ext.hana.model.HANADataSource;
import org.jkiss.dbeaver.ext.hana.model.HANAObjectType;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCStructureAssistant;
import org.jkiss.dbeaver.model.impl.struct.AbstractObjectReference;
import org.jkiss.dbeaver.model.impl.struct.RelationalObjectType;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectReference;
import org.jkiss.dbeaver.model.struct.DBSObjectType;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;
import org.jkiss.utils.ArrayUtils;

public class HANAStructureAssistant
extends JDBCStructureAssistant<JDBCExecutionContext> {
    private final HANADataSource dataSource;

    public HANAStructureAssistant(HANADataSource dataSource) {
        this.dataSource = dataSource;
    }

    protected JDBCDataSource getDataSource() {
        return this.dataSource;
    }

    @NotNull
    public DBSObjectType[] getSupportedObjectTypes() {
        return new DBSObjectType[]{HANAObjectType.TABLE, HANAObjectType.VIEW, HANAObjectType.PROCEDURE, HANAObjectType.SYNONYM, HANAObjectType.SCHEMA, RelationalObjectType.TYPE_TABLE_COLUMN, RelationalObjectType.TYPE_VIEW_COLUMN};
    }

    @NotNull
    public DBSObjectType[] getAutoCompleteObjectTypes() {
        return new DBSObjectType[]{HANAObjectType.TABLE, HANAObjectType.VIEW, HANAObjectType.PROCEDURE, HANAObjectType.SYNONYM};
    }

    @NotNull
    public DBSObjectType[] getHyperlinkObjectTypes() {
        return new DBSObjectType[]{HANAObjectType.TABLE, HANAObjectType.VIEW, HANAObjectType.SYNONYM};
    }

    protected void findObjectsByMask(@NotNull JDBCExecutionContext executionContext, @NotNull JDBCSession session, @NotNull DBSObjectType objectType, @NotNull DBSStructureAssistant.ObjectsSearchParams params, @NotNull List<DBSObjectReference> references) throws SQLException {
        GenericSchema parentSchema;
        GenericSchema genericSchema = parentSchema = params.getParentObject() instanceof GenericSchema ? (GenericSchema)params.getParentObject() : null;
        if (objectType == RelationalObjectType.TYPE_TABLE) {
            this.findTablesByMask(session, parentSchema, params, references);
        }
        if (objectType == RelationalObjectType.TYPE_VIEW) {
            this.findViewsByMask(session, parentSchema, params, references);
        }
        if (objectType == RelationalObjectType.TYPE_PROCEDURE) {
            this.findProceduresByMask(session, parentSchema, params, references);
        }
        if (objectType == RelationalObjectType.TYPE_TABLE_COLUMN) {
            this.findTableColumnsByMask(session, parentSchema, params, references);
        }
        if (objectType == RelationalObjectType.TYPE_VIEW_COLUMN) {
            this.findViewColumnsByMask(session, parentSchema, params, references);
        }
    }

    @NotNull
    public List<DBSObjectReference> findObjectsByMask(@NotNull DBRProgressMonitor monitor, @NotNull JDBCExecutionContext executionContext, @NotNull DBSStructureAssistant.ObjectsSearchParams params) throws DBException {
        ArrayList<DBSObjectReference> result = new ArrayList<DBSObjectReference>();
        Object[] objectTypes = params.getObjectTypes();
        StringBuilder objectTypeClause = new StringBuilder(100);
        GenericSchema parentSchema = params.getParentObject() instanceof GenericSchema ? (GenericSchema)params.getParentObject() : (params.isGlobalSearch() || !(executionContext instanceof GenericExecutionContext) ? null : ((GenericExecutionContext)executionContext).getDefaultSchema());
        try (JDBCSession session = executionContext.openSession(monitor, DBCExecutionPurpose.META, "Find objects by mask");){
            if (ArrayUtils.containsAny((Object[])objectTypes, (Object[])new DBSObjectType[]{HANAObjectType.TABLE, HANAObjectType.VIEW, HANAObjectType.PROCEDURE, HANAObjectType.SYNONYM, HANAObjectType.SCHEMA})) {
                for (Object objectType : objectTypes) {
                    if (objectTypeClause.length() > 0) {
                        objectTypeClause.append(",");
                    }
                    objectTypeClause.append("'").append(objectType.getTypeName()).append("'");
                }
                if (objectTypeClause.length() == 0) {
                    objectTypeClause.append("'TABLE', 'VIEW', 'SYNONYM', 'PROCEDURE'");
                }
                this.searchNotColumnObjects(session, parentSchema, params, result, objectTypeClause.toString());
            }
            if (ArrayUtils.contains((Object[])objectTypes, (Object)RelationalObjectType.TYPE_TABLE_COLUMN)) {
                this.findTableColumnsByMask(session, parentSchema, params, result);
            }
            if (ArrayUtils.contains((Object[])objectTypes, (Object)RelationalObjectType.TYPE_VIEW_COLUMN)) {
                this.findViewColumnsByMask(session, parentSchema, params, result);
            }
        }
        catch (SQLException ex) {
            throw new DBDatabaseException((Throwable)ex, (DBPDataSource)this.dataSource);
        }
        return result;
    }

    private void searchNotColumnObjects(final JDBCSession session, GenericSchema parentSchema, @NotNull DBSStructureAssistant.ObjectsSearchParams params, List<DBSObjectReference> result, String objectTypeClause) throws SQLException {
        boolean isNeedSearchSchemas = Set.of(params.getObjectTypes()).contains((Object)HANAObjectType.SCHEMA);
        Object stmt = "SELECT SCHEMA_NAME, OBJECT_NAME, OBJECT_TYPE FROM SYS.OBJECTS WHERE";
        stmt = (String)stmt + (isNeedSearchSchemas ? "(" : "");
        stmt = (String)stmt + (params.isCaseSensitive() ? " OBJECT_NAME LIKE ?" : " UPPER(OBJECT_NAME) LIKE ?");
        if (parentSchema != null) {
            stmt = (String)stmt + " AND SCHEMA_NAME = ?";
        }
        stmt = (String)stmt + " AND OBJECT_TYPE IN (" + objectTypeClause + ")";
        stmt = (String)stmt + (isNeedSearchSchemas ? ")" : "");
        if (isNeedSearchSchemas) {
            stmt = (String)stmt + "OR (OBJECT_TYPE = 'SCHEMA' AND ";
            stmt = (String)stmt + (params.isCaseSensitive() ? "UPPER(SCHEMA_NAME)" : "SCHEMA_NAME LIKE ? )");
        }
        stmt = (String)stmt + " ORDER BY SCHEMA_NAME, OBJECT_NAME LIMIT " + (params.getMaxResults() - result.size());
        DBRProgressMonitor monitor = session.getProgressMonitor();
        try (JDBCPreparedStatement dbStat = session.prepareStatement((String)stmt);){
            int paramIndex = 1;
            String searchString = params.isCaseSensitive() ? params.getMask() : params.getMask().toUpperCase();
            dbStat.setString(paramIndex++, searchString);
            if (parentSchema != null) {
                dbStat.setString(paramIndex++, parentSchema.getName());
            }
            if (isNeedSearchSchemas) {
                dbStat.setString(paramIndex, searchString);
            }
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                while (!monitor.isCanceled() && dbResult.next()) {
                    GenericSchema schema;
                    final String schemaName = dbResult.getString(1);
                    final String objectName = dbResult.getString(2);
                    final String objectTypeName = dbResult.getString(3);
                    final HANAObjectType objectType = HANAObjectType.valueOf(objectTypeName);
                    if (HANAObjectType.SCHEMA.equals((Object)objectType)) {
                        this.addSchemaToResult(schemaName, result);
                        continue;
                    }
                    GenericSchema genericSchema = schema = parentSchema != null ? parentSchema : this.dataSource.getSchema(schemaName);
                    if (schema == null) {
                        log.trace((Object)("Schema '" + schemaName + "' not found. Probably was filtered"));
                        continue;
                    }
                    result.add((DBSObjectReference)new AbstractObjectReference<DBSObject>(this, objectName, (DBSObject)schema, null, objectType.getTypeClass(), (DBSObjectType)objectType){
                        final /* synthetic */ HANAStructureAssistant this$0;
                        {
                            this.this$0 = this$0;
                            super(arg0, arg1, arg2, arg3, arg4);
                        }

                        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                            DBSObject object = objectType.findObject(session.getProgressMonitor(), (GenericObjectContainer)schema, objectName);
                            if (object == null) {
                                throw new DBException(objectTypeName + " '" + objectName + "' not found in schema '" + schema.getName() + "'");
                            }
                            return object;
                        }

                        @NotNull
                        public String getFullyQualifiedName(@NotNull DBPEvaluationContext context) {
                            if (objectType == HANAObjectType.SYNONYM && "PUBLIC".equals(schemaName)) {
                                return DBUtils.getQuotedIdentifier((DBPDataSource)this.this$0.dataSource, (String)objectName);
                            }
                            return super.getFullyQualifiedName(context);
                        }
                    });
                }
            }
        }
    }

    private void addSchemaToResult(String schemaName, List<DBSObjectReference> result) {
        GenericSchema schema = this.dataSource.getSchema(schemaName);
        if (schema == null) {
            log.warn((Object)(String.valueOf((Object)HANAObjectType.SCHEMA) + " '" + schemaName + "' is not found"));
            return;
        }
        result.add((DBSObjectReference)new AbstractObjectReference<DBSObject>(this, schemaName, schema.getParentObject(), null, HANAObjectType.SCHEMA.getTypeClass(), (DBSObjectType)HANAObjectType.SCHEMA, (DBSObject)schema){
            final /* synthetic */ DBSObject val$schema;
            {
                this.val$schema = dBSObject;
                super(arg0, arg1, arg2, arg3, arg4);
            }

            public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                return this.val$schema;
            }

            @NotNull
            public String getFullyQualifiedName(@NotNull DBPEvaluationContext context) {
                return super.getFullyQualifiedName(context);
            }
        });
    }

    private void findTablesByMask(JDBCSession session, GenericSchema parentSchema, @NotNull DBSStructureAssistant.ObjectsSearchParams params, List<DBSObjectReference> result) throws SQLException {
        Object stmt = "SELECT SCHEMA_NAME, TABLE_NAME, COMMENTS FROM SYS.TABLES WHERE";
        stmt = (String)stmt + (params.isCaseSensitive() ? " TABLE_NAME LIKE ?" : " UPPER(TABLE_NAME) LIKE ?");
        if (parentSchema != null) {
            stmt = (String)stmt + " AND SCHEMA_NAME = ?";
        }
        stmt = (String)stmt + " ORDER BY SCHEMA_NAME, TABLE_NAME LIMIT " + (params.getMaxResults() - result.size());
        DBRProgressMonitor monitor = session.getProgressMonitor();
        try (JDBCPreparedStatement dbStat = session.prepareStatement((String)stmt);){
            dbStat.setString(1, params.isCaseSensitive() ? params.getMask() : params.getMask().toUpperCase());
            if (parentSchema != null) {
                dbStat.setString(2, parentSchema.getName());
            }
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                while (!monitor.isCanceled() && dbResult.next()) {
                    GenericSchema schema;
                    String schemaName = dbResult.getString(1);
                    String objectName = dbResult.getString(2);
                    String description = dbResult.getString(3);
                    GenericSchema genericSchema = schema = parentSchema != null ? parentSchema : this.dataSource.getSchema(schemaName);
                    if (schema == null) continue;
                    result.add((DBSObjectReference)new AbstractObjectReference<DBSObject>(objectName, (DBSObject)schema, description, GenericTable.class, RelationalObjectType.TYPE_TABLE){

                        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                            GenericTableBase object = ((GenericObjectContainer)this.getContainer()).getTable(monitor, this.getName());
                            if (object == null) {
                                throw new DBException("Can't find object '" + this.getName() + "' in '" + DBUtils.getFullQualifiedName((DBPDataSource)HANAStructureAssistant.this.dataSource, (DBPNamedObject[])new DBPNamedObject[]{this.getContainer()}) + "'");
                            }
                            return object;
                        }
                    });
                }
            }
        }
    }

    private void findViewsByMask(JDBCSession session, GenericSchema parentSchema, @NotNull DBSStructureAssistant.ObjectsSearchParams params, List<DBSObjectReference> result) throws SQLException {
        Object stmt = "SELECT SCHEMA_NAME, VIEW_NAME, COMMENTS FROM SYS.VIEWS WHERE";
        stmt = (String)stmt + (params.isCaseSensitive() ? " VIEW_NAME LIKE ?" : " UPPER(VIEW_NAME) LIKE ?");
        if (parentSchema != null) {
            stmt = (String)stmt + " AND SCHEMA_NAME = ?";
        }
        stmt = (String)stmt + " ORDER BY SCHEMA_NAME, VIEW_NAME LIMIT " + (params.getMaxResults() - result.size());
        DBRProgressMonitor monitor = session.getProgressMonitor();
        try (JDBCPreparedStatement dbStat = session.prepareStatement((String)stmt);){
            dbStat.setString(1, params.isCaseSensitive() ? params.getMask() : params.getMask().toUpperCase());
            if (parentSchema != null) {
                dbStat.setString(2, parentSchema.getName());
            }
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                while (!monitor.isCanceled() && dbResult.next()) {
                    GenericSchema schema;
                    String schemaName = dbResult.getString(1);
                    String objectName = dbResult.getString(2);
                    String description = dbResult.getString(3);
                    GenericSchema genericSchema = schema = parentSchema != null ? parentSchema : this.dataSource.getSchema(schemaName);
                    if (schema == null) continue;
                    result.add((DBSObjectReference)new AbstractObjectReference<GenericObjectContainer>(objectName, (GenericObjectContainer)schema, description, GenericTable.class, RelationalObjectType.TYPE_VIEW){

                        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                            GenericTableBase object = ((GenericObjectContainer)this.getContainer()).getTable(monitor, this.getName());
                            if (object == null) {
                                throw new DBException("Can't find object '" + this.getName() + "' in '" + DBUtils.getFullQualifiedName((DBPDataSource)HANAStructureAssistant.this.dataSource, (DBPNamedObject[])new DBPNamedObject[]{this.getContainer()}) + "'");
                            }
                            return object;
                        }
                    });
                }
            }
        }
    }

    private void findProceduresByMask(JDBCSession session, GenericSchema parentSchema, @NotNull DBSStructureAssistant.ObjectsSearchParams params, List<DBSObjectReference> result) throws SQLException {
        Object stmt = "SELECT SCHEMA_NAME, PROCEDURE_NAME FROM SYS.PROCEDURES WHERE";
        stmt = (String)stmt + (params.isCaseSensitive() ? " PROCEDURE_NAME LIKE ?" : " UPPER(PROCEDURE_NAME) LIKE ?");
        if (parentSchema != null) {
            stmt = (String)stmt + " AND SCHEMA_NAME = ?";
        }
        stmt = (String)stmt + " ORDER BY SCHEMA_NAME, PROCEDURE_NAME LIMIT " + (params.getMaxResults() - result.size());
        DBRProgressMonitor monitor = session.getProgressMonitor();
        try (JDBCPreparedStatement dbStat = session.prepareStatement((String)stmt);){
            dbStat.setString(1, params.isCaseSensitive() ? params.getMask() : params.getMask().toUpperCase());
            if (parentSchema != null) {
                dbStat.setString(2, parentSchema.getName());
            }
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                while (!monitor.isCanceled() && dbResult.next()) {
                    GenericSchema schema;
                    String schemaName = dbResult.getString(1);
                    String objectName = dbResult.getString(2);
                    String description = null;
                    GenericSchema genericSchema = schema = parentSchema != null ? parentSchema : this.dataSource.getSchema(schemaName);
                    if (schema == null) continue;
                    result.add((DBSObjectReference)new AbstractObjectReference<DBSObject>(objectName, (DBSObject)schema, description, GenericProcedure.class, RelationalObjectType.TYPE_PROCEDURE){

                        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                            GenericProcedure object = ((GenericObjectContainer)this.getContainer()).getProcedure(monitor, this.getName());
                            if (object == null) {
                                throw new DBException("Can't find object '" + this.getName() + "' in '" + DBUtils.getFullQualifiedName((DBPDataSource)HANAStructureAssistant.this.dataSource, (DBPNamedObject[])new DBPNamedObject[]{this.getContainer()}) + "'");
                            }
                            return object;
                        }
                    });
                }
            }
        }
    }

    private void findTableColumnsByMask(JDBCSession session, GenericSchema parentSchema, @NotNull DBSStructureAssistant.ObjectsSearchParams params, List<DBSObjectReference> result) throws SQLException {
        Object stmt = "SELECT SCHEMA_NAME, TABLE_NAME, COLUMN_NAME, COMMENTS FROM SYS.TABLE_COLUMNS WHERE";
        stmt = (String)stmt + (params.isCaseSensitive() ? " COLUMN_NAME LIKE ?" : " UPPER(COLUMN_NAME) LIKE ?");
        if (parentSchema != null) {
            stmt = (String)stmt + " AND SCHEMA_NAME = ?";
        }
        stmt = (String)stmt + " ORDER BY SCHEMA_NAME, TABLE_NAME, COLUMN_NAME LIMIT " + (params.getMaxResults() - result.size());
        DBRProgressMonitor monitor = session.getProgressMonitor();
        try (JDBCPreparedStatement dbStat = session.prepareStatement((String)stmt);){
            dbStat.setString(1, params.isCaseSensitive() ? params.getMask() : params.getMask().toUpperCase());
            if (parentSchema != null) {
                dbStat.setString(2, parentSchema.getName());
            }
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                while (!monitor.isCanceled() && dbResult.next()) {
                    GenericSchema schema;
                    String schemaName = dbResult.getString(1);
                    String objectName = dbResult.getString(2);
                    final String columnName = dbResult.getString(3);
                    String description = dbResult.getString(4);
                    GenericSchema genericSchema = schema = parentSchema != null ? parentSchema : this.dataSource.getSchema(schemaName);
                    if (schema == null) continue;
                    result.add((DBSObjectReference)new AbstractObjectReference<DBSObject>(this, objectName, (DBSObject)schema, description, GenericTableColumn.class, RelationalObjectType.TYPE_TABLE_COLUMN){
                        final /* synthetic */ HANAStructureAssistant this$0;
                        {
                            this.this$0 = this$0;
                            super(arg0, arg1, arg2, arg3, arg4);
                        }

                        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                            GenericTableBase object = ((GenericObjectContainer)this.getContainer()).getTable(monitor, this.getName());
                            if (object == null) {
                                throw new DBException("Can't find object '" + this.getName() + "' in '" + DBUtils.getFullQualifiedName((DBPDataSource)this.this$0.dataSource, (DBPNamedObject[])new DBPNamedObject[]{this.getContainer()}) + "'");
                            }
                            GenericTableColumn column = object.getAttribute(monitor, columnName);
                            if (column == null) {
                                throw new DBException("Column '" + columnName + "' not found in table '" + object.getFullyQualifiedName(DBPEvaluationContext.DDL) + "'");
                            }
                            return column;
                        }
                    });
                }
            }
        }
    }

    private void findViewColumnsByMask(JDBCSession session, GenericSchema parentSchema, @NotNull DBSStructureAssistant.ObjectsSearchParams params, List<DBSObjectReference> result) throws SQLException {
        Object stmt = "SELECT SCHEMA_NAME, VIEW_NAME, COLUMN_NAME, COMMENTS FROM SYS.VIEW_COLUMNS WHERE";
        stmt = (String)stmt + (params.isCaseSensitive() ? " COLUMN_NAME LIKE ?" : " UPPER(COLUMN_NAME) LIKE ?");
        if (parentSchema != null) {
            stmt = (String)stmt + " AND SCHEMA_NAME = ?";
        }
        stmt = (String)stmt + " ORDER BY SCHEMA_NAME, VIEW_NAME, COLUMN_NAME LIMIT " + (params.getMaxResults() - result.size());
        DBRProgressMonitor monitor = session.getProgressMonitor();
        try (JDBCPreparedStatement dbStat = session.prepareStatement((String)stmt);){
            dbStat.setString(1, params.isCaseSensitive() ? params.getMask() : params.getMask().toUpperCase());
            if (parentSchema != null) {
                dbStat.setString(2, parentSchema.getName());
            }
            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                while (!monitor.isCanceled() && dbResult.next()) {
                    GenericSchema schema;
                    String schemaName = dbResult.getString(1);
                    String objectName = dbResult.getString(2);
                    final String columnName = dbResult.getString(3);
                    String description = dbResult.getString(4);
                    GenericSchema genericSchema = schema = parentSchema != null ? parentSchema : this.dataSource.getSchema(schemaName);
                    if (schema == null) continue;
                    result.add((DBSObjectReference)new AbstractObjectReference<DBSObject>(this, objectName, (DBSObject)schema, description, GenericTableColumn.class, RelationalObjectType.TYPE_TABLE_COLUMN){
                        final /* synthetic */ HANAStructureAssistant this$0;
                        {
                            this.this$0 = this$0;
                            super(arg0, arg1, arg2, arg3, arg4);
                        }

                        public DBSObject resolveObject(DBRProgressMonitor monitor) throws DBException {
                            GenericTableBase object = ((GenericObjectContainer)this.getContainer()).getTable(monitor, this.getName());
                            if (object == null) {
                                throw new DBException("Can't find object '" + this.getName() + "' in '" + DBUtils.getFullQualifiedName((DBPDataSource)this.this$0.dataSource, (DBPNamedObject[])new DBPNamedObject[]{this.getContainer()}) + "'");
                            }
                            GenericTableColumn column = object.getAttribute(monitor, columnName);
                            if (column == null) {
                                throw new DBException("Column '" + columnName + "' not found in table '" + object.getFullyQualifiedName(DBPEvaluationContext.DDL) + "'");
                            }
                            return column;
                        }
                    });
                }
            }
        }
    }
}

