/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.file;

import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBPPlatformDesktop;
import org.jkiss.dbeaver.model.app.DBPResourceHandler;
import org.jkiss.dbeaver.model.file.FileOpenHandler;
import org.jkiss.dbeaver.model.file.FileTypeAction;
import org.jkiss.dbeaver.model.navigator.fs.DBNPathBase;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.utils.IOUtils;

public class AbstractFileHandler
implements FileOpenHandler {
    private static final Log log = Log.getLog(AbstractFileHandler.class);
    protected DBNPathBase sourceNode;

    public void setSourceNode(@Nullable DBNPathBase sourceNode) {
        this.sourceNode = sourceNode;
    }

    public void openFiles(@NotNull List<Path> fileList, @Nullable DBPDataSourceContainer dataSource, @NotNull FileTypeAction action) throws DBException {
        switch (action) {
            case EXTERNAL_EDITOR: {
                for (Path path : fileList) {
                    if (!IOUtils.isLocalPath((Path)path)) {
                        path = EditorUtils.copyRemoteFileToTempDir(path);
                    }
                    ShellUtils.openExternalFile((Path)path);
                }
                break;
            }
            case INTERNAL_EDITOR: {
                for (Path path : fileList) {
                    if (!IOUtils.isLocalPath((Path)path)) {
                        path = EditorUtils.copyRemoteFileToTempDir(path);
                    }
                    EditorUtils.openExternalFileEditor(path, UIUtils.getActiveWorkbenchWindow());
                }
                break;
            }
            case DATABASE: {
                throw new DBException("Unsupported file action: " + String.valueOf(action));
            }
        }
    }

    @NotNull
    public Set<FileTypeAction> supportedActions() {
        return Set.of(FileTypeAction.EXTERNAL_EDITOR, FileTypeAction.INTERNAL_EDITOR);
    }

    protected boolean tryOpenViaResourceAdapter(@NotNull Path path, @NotNull DBNPathBase sourceNode) {
        try {
            IResource resource = (IResource)sourceNode.getAdapter(IResource.class);
            if (resource instanceof IFile) {
                IFile file = (IFile)resource;
                DBPResourceHandler handler = DBPPlatformDesktop.getInstance().getWorkspace().getResourceHandler((IResource)file);
                if (handler != null) {
                    handler.openResource((IResource)file);
                    return true;
                }
            }
        }
        catch (Exception e) {
            log.debug((Object)("Failed to open file via resource adapter: " + String.valueOf(path)), (Throwable)e);
        }
        return false;
    }
}

