/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.docstring;

import io.cucumber.docstring.CucumberDocStringException;
import io.cucumber.docstring.DocString;
import java.lang.reflect.Type;
import java.util.Objects;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE)
public final class DocStringType {
    private final Type type;
    private final String contentType;
    private final Transformer<?> transformer;

    public <T> DocStringType(Type type, String contentType, Transformer<T> transformer) {
        this.type = Objects.requireNonNull(type);
        this.contentType = Objects.requireNonNull(contentType);
        this.transformer = Objects.requireNonNull(transformer);
    }

    String getContentType() {
        return this.contentType;
    }

    Type getType() {
        return this.type;
    }

    Object transform(String content) {
        try {
            return this.transformer.transform(content);
        }
        catch (Throwable throwable) {
            throw new CucumberDocStringException(String.format("'%s' could not transform%n%s", this.contentType, DocString.create(content, this.contentType)), throwable);
        }
    }

    @FunctionalInterface
    public static interface Transformer<T> {
        public T transform(String var1) throws Throwable;
    }
}

