/*
 * Decompiled with CFR 0.152.
 */
package io.sf.jclf.text.format;

import io.sf.jclf.text.format.NumberFormat;
import io.sf.jclf.text.format.SpecParsingException;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Random;

public class FloatFormat
extends NumberFormat {
    protected boolean numpre = false;
    private DecimalFormatSymbols symbols;

    public FloatFormat() {
        this.precision = 6;
        this.symbols = new DecimalFormatSymbols();
    }

    public static FloatFormat create(String format, Locale locale) throws SpecParsingException {
        return FloatFormat.create(format, new DecimalFormatSymbols(locale));
    }

    public static FloatFormat create(String format, DecimalFormatSymbols symbols) throws SpecParsingException {
        FloatFormat fmt = (FloatFormat)FloatFormat.create(format);
        fmt.setDecimalFormatSymbols(symbols);
        return fmt;
    }

    @Override
    protected boolean setFlag(char flag, int i) {
        if (!super.setFlag(flag, i)) {
            switch (flag) {
                case '#': {
                    this.numpre = true;
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public String format(Object o) {
        if (!(o instanceof Double) && !(o instanceof Float)) {
            throw new IllegalArgumentException("Object must be a Double or a Float");
        }
        return this.roundFixedPointNumber((Number)o);
    }

    private String roundFixedPointNumber(Number num) {
        StringBuilder numbuf;
        block41: {
            char decimalPoint;
            int hasSign;
            int negative;
            int rlen;
            String strRounded;
            block40: {
                int i;
                double dnumero = num.doubleValue();
                long rounded = Math.round(dnumero * (double)this.getRoundingFactor());
                strRounded = Long.toString(rounded).trim();
                rlen = strRounded.length();
                if (rounded == 0L && this.precision == 0) {
                    StringBuilder numbuf2 = new StringBuilder(this.width);
                    for (int i2 = 0; i2 < this.width; ++i2) {
                        numbuf2.append(' ');
                    }
                    return numbuf2.toString();
                }
                negative = strRounded.charAt(0) == '-' ? 1 : 0;
                hasSign = 0;
                if (this.signpre || negative == 1) {
                    hasSign = 1;
                }
                decimalPoint = this.symbols.getDecimalSeparator();
                numbuf = new StringBuilder(rlen >= this.width ? rlen + 1 : this.width + 1);
                if (rlen - negative > this.precision) break block40;
                if (this.ralign) {
                    if (this.zeropadding) {
                        if (negative == 1) {
                            numbuf.append('-');
                        } else if (this.signpre) {
                            numbuf.append('+');
                        }
                        for (i = this.precision + hasSign + 2; i < this.width; ++i) {
                            numbuf.append('0');
                        }
                    } else {
                        for (i = this.precision + hasSign + 2; i < this.width; ++i) {
                            numbuf.append(' ');
                        }
                        if (negative == 1) {
                            numbuf.append('-');
                        } else if (this.signpre) {
                            numbuf.append('+');
                        }
                    }
                } else if (negative == 1) {
                    numbuf.append('-');
                } else if (this.signpre) {
                    numbuf.append('+');
                }
                numbuf.append('0').append(decimalPoint);
                for (i = rlen - negative; i < this.precision; ++i) {
                    numbuf.append('0');
                }
                numbuf.append(strRounded.subSequence(negative, rlen));
                if (this.ralign) break block41;
                for (i = rlen + this.precision + 1; i < this.width; ++i) {
                    numbuf.append(' ');
                }
                break block41;
            }
            CharSequence intPart = strRounded.subSequence(negative, rlen - this.precision);
            CharSequence fractPart = strRounded.subSequence(rlen - this.precision, rlen);
            int nwsChars = intPart.length() + fractPart.length() + 1;
            if (this.ralign) {
                if (fractPart.length() > 0) {
                    this.leftPadding(negative, hasSign, nwsChars, numbuf);
                    numbuf.append(intPart).append(decimalPoint).append(fractPart);
                } else if (this.numpre) {
                    this.leftPadding(negative, hasSign, nwsChars, numbuf);
                    numbuf.append(intPart).append(decimalPoint);
                } else {
                    this.leftPadding(negative, hasSign, nwsChars - 1, numbuf);
                    numbuf.append(intPart);
                }
            } else {
                if (fractPart.length() > 0) {
                    if (negative == 1) {
                        numbuf.append('-');
                    } else if (this.signpre) {
                        numbuf.append('+');
                    }
                    numbuf.append(intPart).append(decimalPoint).append(fractPart);
                } else if (this.numpre) {
                    if (negative == 1) {
                        numbuf.append('-');
                    } else if (this.signpre) {
                        numbuf.append('+');
                    }
                    numbuf.append(intPart).append(decimalPoint);
                } else {
                    numbuf.append(' ');
                    if (negative == 1) {
                        numbuf.append('-');
                    } else if (this.signpre) {
                        numbuf.append('+');
                    }
                    numbuf.append(intPart);
                }
                for (int i = nwsChars; i < this.width; ++i) {
                    numbuf.append(' ');
                }
            }
        }
        return numbuf.toString();
    }

    private void leftPadding(int negative, int hasSign, int nwsChars, StringBuilder numbuf) {
        if (this.zeropadding) {
            if (negative == 1) {
                numbuf.append('-');
            } else if (this.signpre) {
                numbuf.append('+');
            }
            for (int i = nwsChars + hasSign; i < this.width; ++i) {
                numbuf.append('0');
            }
        } else {
            for (int i = nwsChars + hasSign; i < this.width; ++i) {
                numbuf.append(' ');
            }
            if (negative == 1) {
                numbuf.append('-');
            } else if (this.signpre) {
                numbuf.append('+');
            }
        }
    }

    public void setDecimalFormatSymbols(DecimalFormatSymbols symbols) {
        this.symbols = symbols;
    }

    public DecimalFormatSymbols getDecimalFormatSymbols() {
        return this.symbols;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.ralign) {
            sb.append('-');
        }
        if (this.numpre) {
            sb.append('#');
        }
        if (this.zeropadding) {
            sb.append('0');
        }
        if (this.width != 0) {
            sb.append(this.width);
        }
        if (this.precision >= 0) {
            sb.append('.').append(this.precision);
        }
        sb.append('f');
        return sb.toString();
    }

    @Override
    public Object sample() {
        return new Random().nextDouble() * 10.0;
    }
}

