/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.preview.plugin.renderers;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.apache.pdfbox.pdmodel.graphics.state.RenderingMode;
import org.gephi.graph.api.Node;
import org.gephi.preview.api.CanvasSize;
import org.gephi.preview.api.G2DTarget;
import org.gephi.preview.api.Item;
import org.gephi.preview.api.PDFTarget;
import org.gephi.preview.api.PreviewModel;
import org.gephi.preview.api.PreviewProperties;
import org.gephi.preview.api.PreviewProperty;
import org.gephi.preview.api.RenderTarget;
import org.gephi.preview.api.SVGTarget;
import org.gephi.preview.plugin.builders.NodeBuilder;
import org.gephi.preview.plugin.builders.NodeLabelBuilder;
import org.gephi.preview.plugin.items.NodeLabelItem;
import org.gephi.preview.plugin.renderers.PDFUtils;
import org.gephi.preview.plugin.renderers.SVGUtils;
import org.gephi.preview.spi.ItemBuilder;
import org.gephi.preview.spi.Renderer;
import org.gephi.preview.types.DependantColor;
import org.gephi.preview.types.DependantOriginalColor;
import org.openide.util.NbBundle;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.w3c.dom.svg.SVGLocatable;
import org.w3c.dom.svg.SVGRect;

public class NodeLabelRenderer
implements Renderer {
    public static final String NODE_COLOR = "node.label.nodeColor";
    public static final String NODE_SIZE = "node.label.nodeSize";
    public static final String NODE_X = "node.x";
    public static final String NODE_Y = "node.y";
    public static final String FONT_SIZE = "node.label.fontSize";
    protected final boolean defaultShowLabels = true;
    protected final Font defaultFont = new Font("Arial", 0, 12);
    protected final boolean defaultShorten = false;
    protected final DependantOriginalColor defaultColor = new DependantOriginalColor(DependantOriginalColor.Mode.ORIGINAL);
    protected final int defaultMaxChar = 30;
    protected final boolean defaultProportinalSize = true;
    protected final float defaultOutlineSize = 4.0f;
    protected final DependantColor defaultOutlineColor = new DependantColor(Color.WHITE);
    protected final int defaultOutlineOpacity = 40;
    protected final boolean defaultShowBox = false;
    protected final DependantColor defaultBoxColor = new DependantColor(DependantColor.Mode.PARENT);
    protected final int defaultBoxOpacity = 100;
    protected Map<Integer, Font> fontCache;

    public void preProcess(PreviewModel previewModel) {
        PreviewProperties properties = previewModel.getProperties();
        if (properties.getBooleanValue("node.label.shorten")) {
            Item[] nodeLabelsItems = previewModel.getItems("node_label");
            int maxChars = properties.getIntValue("node.label.max-char");
            Item[] itemArray = nodeLabelsItems;
            int n = itemArray.length;
            for (int i = 0; i < n; ++i) {
                Item item = itemArray[i];
                Object label = (String)item.getData("label");
                if (((String)label).length() < maxChars + 3) continue;
                label = ((String)label).substring(0, maxChars) + "...";
                item.setData("label", label);
            }
        }
        for (Item item : previewModel.getItems("node_label")) {
            Node node = (Node)item.getSource();
            Item nodeItem = previewModel.getItem("node", (Object)node);
            item.setData(NODE_COLOR, nodeItem.getData("color"));
            item.setData(NODE_SIZE, nodeItem.getData("size"));
            item.setData(NODE_X, nodeItem.getData("x"));
            item.setData(NODE_Y, nodeItem.getData("y"));
        }
        this.fontCache = new HashMap<Integer, Font>();
        Font font = properties.getFontValue("node.label.font");
        for (Item item : previewModel.getItems("node_label")) {
            Float nodeSize = (Float)item.getData(NODE_SIZE);
            Float fontSize = Float.valueOf(1.0f);
            if (item.getData("size") != null) {
                fontSize = (Float)item.getData("size");
            }
            if (properties.getBooleanValue("node.label.proportinalSize")) {
                fontSize = Float.valueOf(fontSize.floatValue() * (nodeSize.floatValue() / 10.0f));
            }
            fontSize = Float.valueOf(fontSize.floatValue() * (float)font.getSize());
            Font labelFont = font.deriveFont(fontSize.floatValue());
            this.fontCache.put(labelFont.getSize(), labelFont);
            item.setData(FONT_SIZE, (Object)labelFont.getSize());
        }
    }

    public void render(Item item, RenderTarget target, PreviewProperties properties) {
        Node node = (Node)item.getSource();
        Color nodeColor = (Color)item.getData(NODE_COLOR);
        Color color = (Color)item.getData("color");
        DependantOriginalColor propColor = (DependantOriginalColor)properties.getValue("node.label.color");
        color = propColor.getColor(nodeColor, color);
        String label = (String)item.getData("label");
        Integer fontSize = (Integer)item.getData(FONT_SIZE);
        Float x = (Float)item.getData(NODE_X);
        Float y = (Float)item.getData(NODE_Y);
        if (label == null || label.trim().isEmpty()) {
            return;
        }
        DependantColor outlineDependantColor = (DependantColor)properties.getValue("node.label.outline.color");
        Float outlineSize = Float.valueOf(properties.getFloatValue("node.label.outline.size"));
        outlineSize = Float.valueOf(outlineSize.floatValue() * ((float)fontSize.intValue() / 32.0f));
        int outlineAlpha = (int)(properties.getFloatValue("node.label.outline.opacity") / 100.0f * 255.0f);
        if (outlineAlpha < 0) {
            outlineAlpha = 0;
        }
        if (outlineAlpha > 255) {
            outlineAlpha = 255;
        }
        Color outlineColor = outlineDependantColor.getColor(nodeColor);
        outlineColor = new Color(outlineColor.getRed(), outlineColor.getGreen(), outlineColor.getBlue(), outlineAlpha);
        Boolean showBox = (Boolean)properties.getValue("node.label.box");
        DependantColor boxDependantColor = (DependantColor)properties.getValue("node.label.box.color");
        Color boxColor = boxDependantColor.getColor(nodeColor);
        int boxAlpha = (int)(properties.getFloatValue("node.label.box.opacity") / 100.0f * 255.0f);
        if (boxAlpha < 0) {
            boxAlpha = 0;
        }
        if (boxAlpha > 255) {
            boxAlpha = 255;
        }
        boxColor = new Color(boxColor.getRed(), boxColor.getGreen(), boxColor.getBlue(), boxAlpha);
        if (target instanceof G2DTarget) {
            this.renderG2D((G2DTarget)target, label, x.floatValue(), y.floatValue(), fontSize, color, outlineSize.floatValue(), outlineColor, showBox, boxColor);
        } else if (target instanceof SVGTarget) {
            this.renderSVG((SVGTarget)target, node, label, x.floatValue(), y.floatValue(), fontSize, color, outlineSize.floatValue(), outlineColor, showBox, boxColor);
        } else if (target instanceof PDFTarget) {
            this.renderPDF((PDFTarget)target, node, label, x.floatValue(), y.floatValue(), fontSize, color, outlineSize.floatValue(), outlineColor, showBox, boxColor);
        }
    }

    public void postProcess(PreviewModel previewModel, RenderTarget renderTarget, PreviewProperties properties) {
    }

    public CanvasSize getCanvasSize(Item item, PreviewProperties properties) {
        float x = ((Float)item.getData(NODE_X)).floatValue();
        float y = ((Float)item.getData(NODE_Y)).floatValue();
        Integer fontSize = (Integer)item.getData(FONT_SIZE);
        Font font = this.fontCache.get(fontSize);
        AffineTransform affinetransform = new AffineTransform();
        FontRenderContext frc = new FontRenderContext(affinetransform, true, true);
        String label = (String)item.getData("label");
        float textWidth = (float)font.getStringBounds(label, frc).getWidth();
        float textHeight = (float)font.getStringBounds(label, frc).getHeight();
        return new CanvasSize(x - textWidth / 2.0f, y - textHeight / 2.0f, textWidth, textHeight);
    }

    public void renderG2D(G2DTarget target, String label, float x, float y, int fontSize, Color color, float outlineSize, Color outlineColor, boolean showBox, Color boxColor) {
        Graphics2D graphics = target.getGraphics();
        Font font = this.fontCache.get(fontSize);
        graphics.setFont(font);
        FontMetrics fm = graphics.getFontMetrics();
        float posX = x - (float)fm.stringWidth(label) / 2.0f;
        float posY = y + (float)fm.getDescent();
        Shape outlineGlyph = null;
        if (showBox) {
            graphics.setColor(boxColor);
            Rectangle2D.Float rect = new Rectangle2D.Float();
            rect.setFrame(posX - outlineSize / 2.0f, y - (float)(fm.getAscent() + fm.getDescent()) / 2.0f - outlineSize / 2.0f, (float)fm.stringWidth(label) + outlineSize, (float)(fm.getAscent() + fm.getDescent()) + outlineSize);
            graphics.draw(rect);
        }
        if (outlineSize > 0.0f) {
            FontRenderContext frc = graphics.getFontRenderContext();
            GlyphVector gv = font.createGlyphVector(frc, label);
            outlineGlyph = gv.getOutline(posX, posY);
            graphics.setColor(outlineColor);
            graphics.setStroke(new BasicStroke(outlineSize, 1, 1));
            graphics.draw(outlineGlyph);
        }
        graphics.setColor(color);
        if (null == outlineGlyph) {
            graphics.drawString(label, posX, posY);
        } else {
            graphics.fill(outlineGlyph);
        }
    }

    public void renderSVG(SVGTarget target, Node node, String label, float x, float y, int fontSize, Color color, float outlineSize, Color outlineColor, boolean showBox, Color boxColor) {
        Text labelText = target.createTextNode(label);
        Font font = this.fontCache.get(fontSize);
        if (outlineSize > 0.0f) {
            Text labelTextOutline = target.createTextNode(label);
            Element outlineElem = target.createElement("text");
            outlineElem.setAttribute("class", SVGUtils.idAsClassAttribute(node.getId()));
            outlineElem.setAttribute("x", String.valueOf(x));
            outlineElem.setAttribute("y", String.valueOf(y));
            outlineElem.setAttribute("style", "text-anchor: middle; dominant-baseline: central;");
            outlineElem.setAttribute("fill", target.toHexString(color));
            outlineElem.setAttribute("font-family", font.getFamily());
            outlineElem.setAttribute("font-size", String.valueOf(fontSize));
            outlineElem.setAttribute("stroke", target.toHexString(outlineColor));
            outlineElem.setAttribute("stroke-width", outlineSize * target.getScaleRatio() + "px");
            outlineElem.setAttribute("stroke-linecap", "round");
            outlineElem.setAttribute("stroke-linejoin", "round");
            outlineElem.setAttribute("stroke-opacity", String.valueOf((float)outlineColor.getAlpha() / 255.0f));
            outlineElem.appendChild(labelTextOutline);
            target.getTopElement("node-labels-outline").appendChild(outlineElem);
            SVGRect rect = ((SVGLocatable)outlineElem).getBBox();
            outlineElem.setAttribute("y", String.valueOf(y + (rect != null ? rect.getHeight() / 4.0f : 0.0f)));
        }
        Element labelElem = target.createElement("text");
        labelElem.setAttribute("class", SVGUtils.idAsClassAttribute(node.getId()));
        labelElem.setAttribute("x", String.valueOf(x));
        labelElem.setAttribute("y", String.valueOf(y));
        labelElem.setAttribute("style", "text-anchor: middle; dominant-baseline: central;");
        labelElem.setAttribute("fill", target.toHexString(color));
        labelElem.setAttribute("font-family", font.getFamily());
        labelElem.setAttribute("font-size", String.valueOf(fontSize));
        labelElem.appendChild(labelText);
        target.getTopElement("node-labels").appendChild(labelElem);
        SVGRect rect = ((SVGLocatable)labelElem).getBBox();
        labelElem.setAttribute("y", String.valueOf(y + (rect != null ? rect.getHeight() / 4.0f : 0.0f)));
        if (showBox) {
            rect = ((SVGLocatable)labelElem).getBBox();
            Element boxElem = target.createElement("rect");
            boxElem.setAttribute("x", Float.toString(rect.getX() - outlineSize / 2.0f));
            boxElem.setAttribute("y", Float.toString(rect.getY() - outlineSize / 2.0f));
            boxElem.setAttribute("width", Float.toString(rect.getWidth() + outlineSize));
            boxElem.setAttribute("height", Float.toString(rect.getHeight() + outlineSize));
            boxElem.setAttribute("fill", target.toHexString(boxColor));
            boxElem.setAttribute("opacity", String.valueOf((float)boxColor.getAlpha() / 255.0f));
            target.getTopElement("node-labels").insertBefore(boxElem, labelElem);
        }
    }

    public void renderPDF(PDFTarget target, Node node, String label, float x, float y, int fontSize, Color color, float outlineSize, Color outlineColor, boolean showBox, Color boxColor) {
        PDPageContentStream contentStream = target.getContentStream();
        Font font = this.fontCache.get(fontSize);
        PDFont pdFont = target.getPDFont(font);
        try {
            PDExtendedGraphicsState graphicsState;
            float textHeight = PDFUtils.getTextHeight(pdFont, fontSize);
            float textWidth = PDFUtils.getTextWidth(pdFont, fontSize, label);
            if (showBox) {
                contentStream.setNonStrokingColor(boxColor);
                if (boxColor.getAlpha() < 255) {
                    graphicsState = new PDExtendedGraphicsState();
                    graphicsState.setNonStrokingAlphaConstant(Float.valueOf((float)boxColor.getAlpha() / 255.0f));
                    contentStream.saveGraphicsState();
                    contentStream.setGraphicsStateParameters(graphicsState);
                }
                contentStream.addRect(x - textWidth / 2.0f - outlineSize / 2.0f, -y - textHeight / 2.0f - outlineSize / 2.0f, textWidth + outlineSize, textHeight + outlineSize);
                contentStream.fill();
                if (boxColor.getAlpha() < 255) {
                    contentStream.restoreGraphicsState();
                }
            }
            if (outlineSize > 0.0f) {
                contentStream.setRenderingMode(RenderingMode.STROKE);
                contentStream.setStrokingColor(outlineColor);
                contentStream.setLineWidth(outlineSize);
                contentStream.setLineJoinStyle(1);
                contentStream.setLineCapStyle(1);
                if (outlineColor.getAlpha() < 255) {
                    graphicsState = new PDExtendedGraphicsState();
                    graphicsState.setStrokingAlphaConstant(Float.valueOf((float)outlineColor.getAlpha() / 255.0f));
                    contentStream.saveGraphicsState();
                    contentStream.setGraphicsStateParameters(graphicsState);
                }
                contentStream.beginText();
                contentStream.setFont(pdFont, (float)fontSize);
                contentStream.newLineAtOffset(x - textWidth / 2.0f, -y - textHeight / 2.0f);
                contentStream.showText(label);
                contentStream.endText();
                if (outlineColor.getAlpha() < 255) {
                    contentStream.restoreGraphicsState();
                }
            }
            if (color.getAlpha() < 255) {
                graphicsState = new PDExtendedGraphicsState();
                graphicsState.setNonStrokingAlphaConstant(Float.valueOf((float)color.getAlpha() / 255.0f));
                contentStream.saveGraphicsState();
                contentStream.setGraphicsStateParameters(graphicsState);
            }
            contentStream.beginText();
            contentStream.setFont(pdFont, (float)fontSize);
            contentStream.setNonStrokingColor(color);
            contentStream.setRenderingMode(RenderingMode.FILL);
            contentStream.newLineAtOffset(x - textWidth / 2.0f, -y - textHeight / 2.0f);
            contentStream.showText(label);
            contentStream.endText();
            if (color.getAlpha() < 255) {
                contentStream.restoreGraphicsState();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public PreviewProperty[] getProperties() {
        return new PreviewProperty[]{PreviewProperty.createProperty((Object)this, (String)"node.label.show", Boolean.class, (String)NbBundle.getMessage(NodeLabelRenderer.class, (String)"NodeLabelRenderer.property.display.displayName"), (String)NbBundle.getMessage(NodeLabelRenderer.class, (String)"NodeLabelRenderer.property.display.description"), (String)PreviewProperty.CATEGORY_NODE_LABELS).setValue((Object)true), PreviewProperty.createProperty((Object)this, (String)"node.label.font", Font.class, (String)NbBundle.getMessage(NodeLabelRenderer.class, (String)"NodeLabelRenderer.property.font.displayName"), (String)NbBundle.getMessage(NodeLabelRenderer.class, (String)"NodeLabelRenderer.property.font.description"), (String)PreviewProperty.CATEGORY_NODE_LABELS, (String[])new String[]{"node.label.show"}).setValue((Object)this.defaultFont), PreviewProperty.createProperty((Object)this, (String)"node.label.proportinalSize", Boolean.class, (String)NbBundle.getMessage(NodeLabelRenderer.class, (String)"NodeLabelRenderer.property.proportionalSize.displayName"), (String)NbBundle.getMessage(NodeLabelRenderer.class, (String)"NodeLabelRenderer.property.proportionalSize.description"), (String)PreviewProperty.CATEGORY_NODE_LABELS, (String[])new String[]{"node.label.show"}).setValue((Object)true), PreviewProperty.createProperty((Object)this, (String)"node.label.color", DependantOriginalColor.class, (String)NbBundle.getMessage(NodeLabelRenderer.class, (String)"NodeLabelRenderer.property.color.displayName"), (String)NbBundle.getMessage(NodeLabelRenderer.class, (String)"NodeLabelRenderer.property.color.description"), (String)PreviewProperty.CATEGORY_NODE_LABELS, (String[])new String[]{"node.label.show"}).setValue((Object)this.defaultColor), PreviewProperty.createProperty((Object)this, (String)"node.label.shorten", Boolean.class, (String)NbBundle.getMessage(NodeLabelRenderer.class, (String)"NodeLabelRenderer.property.shorten.displayName"), (String)NbBundle.getMessage(NodeLabelRenderer.class, (String)"NodeLabelRenderer.property.shorten.description"), (String)PreviewProperty.CATEGORY_NODE_LABELS, (String[])new String[]{"node.label.show"}).setValue((Object)false), PreviewProperty.createProperty((Object)this, (String)"node.label.max-char", Integer.class, (String)NbBundle.getMessage(NodeLabelRenderer.class, (String)"NodeLabelRenderer.property.maxchar.displayName"), (String)NbBundle.getMessage(NodeLabelRenderer.class, (String)"NodeLabelRenderer.property.maxchar.description"), (String)PreviewProperty.CATEGORY_NODE_LABELS, (String[])new String[]{"node.label.show"}).setValue((Object)30), PreviewProperty.createProperty((Object)this, (String)"node.label.outline.size", Float.class, (String)NbBundle.getMessage(NodeLabelRenderer.class, (String)"NodeLabelRenderer.property.outlineSize.displayName"), (String)NbBundle.getMessage(NodeLabelRenderer.class, (String)"NodeLabelRenderer.property.outlineSize.description"), (String)PreviewProperty.CATEGORY_NODE_LABELS, (String[])new String[]{"node.label.show"}).setValue((Object)Float.valueOf(4.0f)), PreviewProperty.createProperty((Object)this, (String)"node.label.outline.color", DependantColor.class, (String)NbBundle.getMessage(NodeLabelRenderer.class, (String)"NodeLabelRenderer.property.outlineColor.displayName"), (String)NbBundle.getMessage(NodeLabelRenderer.class, (String)"NodeLabelRenderer.property.outlineColor.description"), (String)PreviewProperty.CATEGORY_NODE_LABELS, (String[])new String[]{"node.label.show"}).setValue((Object)this.defaultOutlineColor), PreviewProperty.createProperty((Object)this, (String)"node.label.outline.opacity", Float.class, (String)NbBundle.getMessage(NodeLabelRenderer.class, (String)"NodeLabelRenderer.property.outlineOpacity.displayName"), (String)NbBundle.getMessage(NodeLabelRenderer.class, (String)"NodeLabelRenderer.property.outlineOpacity.description"), (String)PreviewProperty.CATEGORY_NODE_LABELS, (String[])new String[]{"node.label.show"}).setValue((Object)40), PreviewProperty.createProperty((Object)this, (String)"node.label.box", Boolean.class, (String)NbBundle.getMessage(NodeLabelRenderer.class, (String)"NodeLabelRenderer.property.box.displayName"), (String)NbBundle.getMessage(NodeLabelRenderer.class, (String)"NodeLabelRenderer.property.box.description"), (String)PreviewProperty.CATEGORY_NODE_LABELS, (String[])new String[]{"node.label.show"}).setValue((Object)false), PreviewProperty.createProperty((Object)this, (String)"node.label.box.color", DependantColor.class, (String)NbBundle.getMessage(NodeLabelRenderer.class, (String)"NodeLabelRenderer.property.box.color.displayName"), (String)NbBundle.getMessage(NodeLabelRenderer.class, (String)"NodeLabelRenderer.property.box.color.description"), (String)PreviewProperty.CATEGORY_NODE_LABELS, (String[])new String[]{"node.label.box", "node.label.show"}).setValue((Object)this.defaultBoxColor), PreviewProperty.createProperty((Object)this, (String)"node.label.box.opacity", Float.class, (String)NbBundle.getMessage(NodeLabelRenderer.class, (String)"NodeLabelRenderer.property.box.opacity.displayName"), (String)NbBundle.getMessage(NodeLabelRenderer.class, (String)"NodeLabelRenderer.property.box.opacity.description"), (String)PreviewProperty.CATEGORY_NODE_LABELS, (String[])new String[]{"node.label.box", "node.label.show"}).setValue((Object)100)};
    }

    private boolean showNodeLabels(PreviewProperties properties) {
        return properties.getBooleanValue("node.label.show") && !properties.getBooleanValue("canvas.moving");
    }

    public boolean isRendererForitem(Item item, PreviewProperties properties) {
        return item instanceof NodeLabelItem && this.showNodeLabels(properties);
    }

    public boolean needsItemBuilder(ItemBuilder itemBuilder, PreviewProperties properties) {
        return (itemBuilder instanceof NodeLabelBuilder || itemBuilder instanceof NodeBuilder) && this.showNodeLabels(properties);
    }

    public String getDisplayName() {
        return NbBundle.getMessage(NodeLabelRenderer.class, (String)"NodeLabelRenderer.name");
    }
}

