/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.branding.desktop.reporter;

import java.awt.Dimension;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Report {
    private final Date date;
    private Throwable throwable;
    private String summary = "";
    private String userDescription = "";
    private String userEmail = "";
    private String log = "";
    private String version = "";
    private Dimension screenSize;
    private int screenDevices;
    private int numberOfProcessors;
    private String os = "";
    private String heapMemoryUsage = "";
    private String nonHeapMemoryUsage = "";
    private String vm = "";
    private String glVendor = "";
    private String glRenderer = "";
    private String glVersion = "";
    private final List<String> enabledModules = new ArrayList<String>();
    private final List<String> disabledModules = new ArrayList<String>();

    public Report() {
        Calendar cal = Calendar.getInstance();
        this.date = cal.getTime();
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public void setThrowable(Throwable throwable) {
        this.throwable = throwable;
    }

    public String getUserEmail() {
        return this.userEmail;
    }

    public void setUserEmail(String userEmail) {
        this.userEmail = userEmail;
    }

    public String getUserDescription() {
        return this.userDescription;
    }

    public void setUserDescription(String userDescription) {
        this.userDescription = userDescription;
    }

    public int getNumberOfProcessors() {
        return this.numberOfProcessors;
    }

    public void setNumberOfProcessors(int numberOfProcessors) {
        this.numberOfProcessors = numberOfProcessors;
    }

    public int getScreenDevices() {
        return this.screenDevices;
    }

    public void setScreenDevices(int screenDevices) {
        this.screenDevices = screenDevices;
    }

    public Dimension getScreenSize() {
        return this.screenSize;
    }

    public void setScreenSize(Dimension screenSize) {
        this.screenSize = screenSize;
    }

    public String getOs() {
        return this.os;
    }

    public void setOs(String os) {
        this.os = os;
    }

    public String getHeapMemoryUsage() {
        return this.heapMemoryUsage;
    }

    public void setHeapMemoryUsage(String heapMemoryUsage) {
        this.heapMemoryUsage = heapMemoryUsage;
    }

    public String getNonHeapMemoryUsage() {
        return this.nonHeapMemoryUsage;
    }

    public void setNonHeapMemoryUsage(String nonHeapMemoryUsage) {
        this.nonHeapMemoryUsage = nonHeapMemoryUsage;
    }

    public String getVm() {
        return this.vm;
    }

    public void setVm(String vm) {
        this.vm = vm;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getGlRenderer() {
        return this.glRenderer;
    }

    public void setGlRenderer(String glRenderer) {
        this.glRenderer = glRenderer;
    }

    public String getGlVendor() {
        return this.glVendor;
    }

    public void setGlVendor(String glVendor) {
        this.glVendor = glVendor;
    }

    public String getGlVersion() {
        return this.glVersion;
    }

    public void setGlVersion(String glVersion) {
        this.glVersion = glVersion;
    }

    public void addEnabledModule(String str) {
        this.enabledModules.add(str);
    }

    public void addDisabledModule(String str) {
        this.disabledModules.add(str);
    }

    public String getLog() {
        return this.log;
    }

    public void setLog(String log) {
        this.log = log;
    }

    public Element writeXml(Document document) {
        String gephiVersion = System.getProperty("netbeans.productversion");
        Element reportE = document.createElement("report");
        reportE.setAttribute("version", gephiVersion);
        Element dateE = document.createElement("date");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dateE.setTextContent(sdf.format(this.date));
        dateE.appendChild(document.createComment("yyyy-MM-dd HH:mm:ss"));
        reportE.appendChild(dateE);
        Element exceptionsE = document.createElement("exceptions");
        Element exceptionE = document.createElement("exception");
        Element titleE = document.createElement("title");
        titleE.setTextContent(this.summary);
        exceptionE.appendChild(titleE);
        Element throwableE = document.createElement("throwable");
        if (this.throwable != null) {
            StringWriter wr = new StringWriter();
            this.throwable.printStackTrace(new PrintWriter((Writer)wr, true));
            throwableE.setTextContent(wr.toString());
        }
        exceptionE.appendChild(throwableE);
        exceptionsE.appendChild(exceptionE);
        reportE.appendChild(exceptionsE);
        Element userDescriptionE = document.createElement("description");
        userDescriptionE.setTextContent(this.userDescription);
        reportE.appendChild(userDescriptionE);
        Element userEmailE = document.createElement("email");
        userEmailE.setTextContent(this.userEmail);
        reportE.appendChild(userEmailE);
        Element versionE = document.createElement("version");
        versionE.setTextContent(this.version);
        reportE.appendChild(versionE);
        Element vmE = document.createElement("vm");
        vmE.setTextContent(this.vm);
        reportE.appendChild(vmE);
        Element osE = document.createElement("os");
        osE.setTextContent(this.os);
        reportE.appendChild(osE);
        Element cpuE = document.createElement("cpucount");
        cpuE.setTextContent(String.valueOf(this.numberOfProcessors));
        reportE.appendChild(cpuE);
        Element glVendorE = document.createElement("glVendor");
        glVendorE.setTextContent(this.glVendor);
        reportE.appendChild(glVendorE);
        Element glRendererE = document.createElement("glRenderer");
        glRendererE.setTextContent(this.glRenderer);
        reportE.appendChild(glRendererE);
        Element glVersionE = document.createElement("glVersion");
        glVersionE.setTextContent(this.glVersion);
        reportE.appendChild(glVersionE);
        Element heapE = document.createElement("heapmemory");
        heapE.setTextContent(this.heapMemoryUsage);
        reportE.appendChild(heapE);
        Element nonHeapE = document.createElement("nonheapmemory");
        nonHeapE.setTextContent(this.nonHeapMemoryUsage);
        reportE.appendChild(nonHeapE);
        Element screenSizeE = document.createElement("screensize");
        screenSizeE.setTextContent("width=" + this.screenSize.width + " height=" + this.screenSize.height);
        reportE.appendChild(screenSizeE);
        Element devicesE = document.createElement("screendevices");
        devicesE.setTextContent(String.valueOf(this.screenDevices));
        reportE.appendChild(devicesE);
        Element modulesE = document.createElement("modules");
        for (String m : this.enabledModules) {
            Element enabledModuleE = document.createElement("enabledmodule");
            enabledModuleE.setTextContent(m);
            modulesE.appendChild(enabledModuleE);
        }
        for (String m : this.disabledModules) {
            Element disabledModuleE = document.createElement("disabledmodule");
            disabledModuleE.setTextContent(m);
            modulesE.appendChild(disabledModuleE);
        }
        reportE.appendChild(modulesE);
        Element logE = document.createElement("log");
        logE.setTextContent(this.log);
        reportE.appendChild(logE);
        document.appendChild(reportE);
        return reportE;
    }
}

