/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp;

import java.applet.Applet;
import java.applet.AppletStub;
import java.awt.Container;
import java.awt.SplashScreen;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.text.html.parser.ParserDelegator;
import net.sourceforge.jnlp.AppletDesc;
import net.sourceforge.jnlp.ApplicationDesc;
import net.sourceforge.jnlp.JARDesc;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.LaunchException;
import net.sourceforge.jnlp.LaunchHandler;
import net.sourceforge.jnlp.ParserSettings;
import net.sourceforge.jnlp.PluginBridge;
import net.sourceforge.jnlp.PropertyDesc;
import net.sourceforge.jnlp.ResourcesDesc;
import net.sourceforge.jnlp.cache.CacheUtil;
import net.sourceforge.jnlp.cache.UpdatePolicy;
import net.sourceforge.jnlp.runtime.AppletInstance;
import net.sourceforge.jnlp.runtime.ApplicationInstance;
import net.sourceforge.jnlp.runtime.JNLPClassLoader;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.services.InstanceExistsException;
import net.sourceforge.jnlp.services.ServiceUtil;
import net.sourceforge.jnlp.splashscreen.SplashUtils;
import net.sourceforge.jnlp.util.JarFile;
import net.sourceforge.jnlp.util.StreamUtils;
import net.sourceforge.jnlp.util.logging.OutputController;
import net.sourceforge.swing.SwingUtils;
import sun.awt.SunToolkit;

public class Launcher {
    static final ThreadGroup mainGroup = new ThreadGroup(Translator.R("LAllThreadGroup"));
    private LaunchHandler handler = null;
    private UpdatePolicy updatePolicy = JNLPRuntime.getDefaultUpdatePolicy();
    private boolean context = true;
    private boolean exitOnFailure = true;
    private ParserSettings parserSettings = new ParserSettings();
    private Map<String, List<String>> extra = null;
    public static final String KEY_JAVAWS_LOCATION = "icedtea-web.bin.location";

    private Launcher() {
        this(null, null);
        if (this.handler == null) {
            this.handler = JNLPRuntime.getDefaultLaunchHandler();
        }
    }

    public Launcher(boolean exitOnFailure) {
        this(null, null);
        if (this.handler == null) {
            this.handler = JNLPRuntime.getDefaultLaunchHandler();
        }
        this.exitOnFailure = exitOnFailure;
    }

    private Launcher(LaunchHandler handler) {
        this(handler, null);
    }

    private Launcher(LaunchHandler handler, UpdatePolicy policy) {
        if (policy == null) {
            policy = JNLPRuntime.getDefaultUpdatePolicy();
        }
        this.handler = handler;
        this.updatePolicy = policy;
    }

    public void setUpdatePolicy(UpdatePolicy policy) {
        if (policy == null) {
            throw new IllegalArgumentException(Translator.R("LNullUpdatePolicy"));
        }
        this.updatePolicy = policy;
    }

    public UpdatePolicy getUpdatePolicy() {
        return this.updatePolicy;
    }

    public void setCreateAppContext(boolean context) {
        this.context = context;
    }

    public boolean isCreateAppContext() {
        return this.context;
    }

    public void setParserSettings(ParserSettings settings) {
        this.parserSettings = settings;
    }

    public void setInformationToMerge(Map<String, List<String>> input) {
        this.extra = input;
    }

    public ApplicationInstance launch(JNLPFile file) throws LaunchException {
        return this.launch(file, null);
    }

    public ApplicationInstance launch(JNLPFile file, Container cont) throws LaunchException {
        this.mergeExtraInformation(file, this.extra);
        JNLPRuntime.markNetxRunning();
        if (!JNLPRuntime.isOfflineForced()) {
            if (!file.getInformation().isOfflineAllowed() && !JNLPRuntime.isOnlineDetected()) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, "Remote systems unreachable, and client application is not able to run offline. Exiting.");
                return null;
            }
        } else if (!file.getInformation().isOfflineAllowed() && !JNLPRuntime.isOnlineDetected()) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, "Remote systems unreachable, and client application is not able to run offline. However, you specified -Xoffline argument. Attmpting to run.");
        }
        TgThread tg = file instanceof PluginBridge && cont != null ? new TgThread(file, cont, true) : (cont == null ? new TgThread(file) : new TgThread(file, cont));
        tg.start();
        try {
            tg.join();
        }
        catch (InterruptedException ex) {
            throw this.launchWarning(new LaunchException(file, ex, Translator.R("LSMinor"), Translator.R("LCSystem"), Translator.R("LThreadInterrupted"), Translator.R("LThreadInterruptedInfo")));
        }
        if (tg.getException() != null) {
            throw tg.getException();
        }
        if (this.handler != null) {
            this.handler.launchCompleted(tg.getApplication());
        }
        return tg.getApplication();
    }

    public ApplicationInstance launch(URL location) throws LaunchException {
        JNLPRuntime.saveHistory(location.toExternalForm());
        return this.launch(this.fromUrl(location));
    }

    private void mergeExtraInformation(JNLPFile file, Map<String, List<String>> extra) throws LaunchException {
        List<String> parameters;
        List<String> arguments;
        if (extra == null) {
            return;
        }
        List<String> properties = extra.get("properties");
        if (properties != null) {
            this.addProperties(file, properties);
        }
        if ((arguments = extra.get("arguments")) != null && file.isApplication()) {
            this.addArguments(file, arguments);
        }
        if ((parameters = extra.get("parameters")) != null && file.isApplet()) {
            this.addParameters(file, parameters);
        }
    }

    private void addProperties(JNLPFile file, List<String> props) throws LaunchException {
        ResourcesDesc resources = file.getResources();
        for (String input : props) {
            try {
                resources.addResource(PropertyDesc.fromString(input));
            }
            catch (LaunchException ex) {
                throw this.launchError(ex);
            }
        }
    }

    private void addParameters(JNLPFile file, List<String> params) throws LaunchException {
        AppletDesc applet = file.getApplet();
        for (String input : params) {
            int equals = input.indexOf("=");
            if (equals == -1) {
                throw this.launchError(new LaunchException(Translator.R("BBadParam", input)));
            }
            String name = input.substring(0, equals);
            String value = input.substring(equals + 1, input.length());
            applet.addParameter(name, value);
        }
    }

    private void addArguments(JNLPFile file, List<String> args) {
        ApplicationDesc app = file.getApplication();
        for (String input : args) {
            app.addArgument(input);
        }
    }

    public void launchExternal(List<String> vmArgs, JNLPFile file, List<String> javawsArgs) throws LaunchException {
        LinkedList<String> updatedArgs = new LinkedList<String>(javawsArgs);
        if (file.getFileLocation() != null) {
            updatedArgs.add(file.getFileLocation().toString());
        } else if (file.getSourceLocation() != null) {
            updatedArgs.add(file.getFileLocation().toString());
        } else {
            this.launchError(new LaunchException(file, null, Translator.R("LSFatal"), Translator.R("LCExternalLaunch"), Translator.R("LNullLocation"), Translator.R("LNullLocationInfo")));
        }
        this.launchExternal(vmArgs, updatedArgs);
    }

    public void launchExternal(URL url) throws LaunchException {
        LinkedList<String> javawsArgs = new LinkedList<String>();
        javawsArgs.add(url.toString());
        this.launchExternal(new LinkedList<String>(), javawsArgs);
    }

    public void launchExternal(List<String> vmArgs, List<String> javawsArgs) throws LaunchException {
        try {
            LinkedList<String> commands = new LinkedList<String>();
            String pathToWebstartBinary = System.getProperty(KEY_JAVAWS_LOCATION);
            commands.add(pathToWebstartBinary);
            for (String arg : vmArgs) {
                commands.add("-J" + arg);
            }
            commands.addAll(javawsArgs);
            String[] command = commands.toArray(new String[0]);
            ProcessBuilder pb = new ProcessBuilder(command);
            pb.inheritIO();
            Process p = pb.start();
            StreamUtils.waitForSafely(p);
        }
        catch (NullPointerException ex) {
            throw this.launchError(new LaunchException(null, null, Translator.R("LSFatal"), Translator.R("LCExternalLaunch"), Translator.R("LNetxJarMissing"), Translator.R("LNetxJarMissingInfo")));
        }
        catch (Exception ex) {
            throw this.launchError(new LaunchException(null, ex, Translator.R("LSFatal"), Translator.R("LCExternalLaunch"), Translator.R("LCouldNotLaunch"), Translator.R("LCouldNotLaunchInfo")));
        }
    }

    private JNLPFile fromUrl(URL location) throws LaunchException {
        try {
            JNLPFile file = new JNLPFile(location, this.parserSettings);
            boolean isLocal = false;
            boolean haveHref = false;
            if ("file".equalsIgnoreCase(location.getProtocol()) && new File(location.getFile()).exists()) {
                isLocal = true;
            }
            if (file.getSourceLocation() != null) {
                haveHref = true;
            }
            if (!isLocal && haveHref && !location.equals(file.getSourceLocation())) {
                isLocal = true;
            }
            if (isLocal && haveHref) {
                JNLPFile fileFromHref = new JNLPFile(file.getSourceLocation(), this.parserSettings);
                if (fileFromHref.getCodeBase() == null) {
                    fileFromHref.codeBase = file.getCodeBase();
                }
                file = fileFromHref;
            }
            return file;
        }
        catch (Exception ex) {
            if (ex instanceof LaunchException) {
                throw (LaunchException)ex;
            }
            throw this.launchError(new LaunchException(null, ex, Translator.R("LSFatal"), Translator.R("LCReadError"), Translator.R("LCantRead"), Translator.R("LCantReadInfo")));
        }
    }

    protected ApplicationInstance launchApplication(JNLPFile file) throws LaunchException {
        if (!file.isApplication()) {
            throw this.launchError(new LaunchException(file, null, Translator.R("LSFatal"), Translator.R("LCClient"), Translator.R("LNotApplication"), Translator.R("LNotApplicationInfo")));
        }
        try {
            JARDesc mainJarDesc;
            File f;
            try {
                ServiceUtil.checkExistingSingleInstance(file);
            }
            catch (InstanceExistsException e) {
                OutputController.getLogger().log("Single instance application is already running.");
                return null;
            }
            if (JNLPRuntime.getForksAllowed() && file.needsNewVM()) {
                SplashScreen sp;
                if (!JNLPRuntime.isHeadless() && (sp = SplashScreen.getSplashScreen()) != null) {
                    sp.close();
                }
                LinkedList<String> netxArguments = new LinkedList<String>();
                netxArguments.add("-Xnofork");
                netxArguments.addAll(JNLPRuntime.getInitialArguments());
                this.launchExternal(file.getNewVMArgs(), netxArguments);
                return null;
            }
            this.handler.launchInitialized(file);
            ApplicationInstance app = this.createApplication(file);
            app.initialize();
            String mainName = file.getApplication().getMainClass();
            if (mainName == null && (f = CacheUtil.getCacheFile((mainJarDesc = file.getResources().getMainJAR()).getLocation(), null)) != null) {
                JarFile mainJar = new JarFile(f);
                mainName = mainJar.getManifest().getMainAttributes().getValue("Main-Class");
            }
            if (mainName == null) {
                throw this.launchError(new LaunchException(file, null, Translator.R("LSFatal"), Translator.R("LCClient"), Translator.R("LCantDetermineMainClass"), Translator.R("LCantDetermineMainClassInfo")));
            }
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, "Starting application [" + mainName + "] ...");
            Class<?> mainClass = app.getClassLoader().loadClass(mainName);
            Method main = mainClass.getMethod("main", String[].class);
            Object[] args = file.getApplication().getArguments();
            SwingUtils.callOnAppContext(new Runnable(){

                @Override
                public void run() {
                }
            });
            this.setContextClassLoaderForAllThreads(app.getThreadGroup(), app.getClassLoader());
            this.handler.launchStarting(app);
            main.setAccessible(true);
            JNLPRuntime.addStartupTrackingEntry("invoking main()");
            OutputController.getLogger().log("Invoking main() with args: " + Arrays.toString(args));
            main.invoke(null, new Object[]{args});
            return app;
        }
        catch (LaunchException lex) {
            throw this.launchError(lex);
        }
        catch (Exception ex) {
            throw this.launchError(new LaunchException(file, ex, Translator.R("LSFatal"), Translator.R("LCLaunching"), Translator.R("LCouldNotLaunch"), Translator.R("LCouldNotLaunchInfo")));
        }
    }

    private void setContextClassLoaderForAllThreads(ThreadGroup tg, ClassLoader classLoader) {
        Thread[] threads;
        int threadCountGuess = tg.activeCount();
        do {
            threads = new Thread[threadCountGuess *= 2];
            tg.enumerate(threads, true);
        } while (threads[threadCountGuess - 1] != null);
        for (Thread thread : threads) {
            if (thread == null) continue;
            OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Setting " + classLoader + " as the classloader for thread " + thread.getName());
            thread.setContextClassLoader(classLoader);
        }
    }

    protected ApplicationInstance launchApplet(JNLPFile file, boolean enableCodeBase, Container cont) throws LaunchException {
        SplashScreen sp;
        if (!file.isApplet()) {
            throw this.launchError(new LaunchException(file, null, Translator.R("LSFatal"), Translator.R("LCClient"), Translator.R("LNotApplet"), Translator.R("LNotAppletInfo")));
        }
        if (JNLPRuntime.getForksAllowed() && file.needsNewVM() && !JNLPRuntime.isHeadless() && (sp = SplashScreen.getSplashScreen()) != null) {
            sp.close();
        }
        if (this.handler != null) {
            this.handler.launchInitialized(file);
        }
        AppletInstance applet = null;
        try {
            ServiceUtil.checkExistingSingleInstance(file);
            applet = this.createApplet(file, enableCodeBase, cont);
            applet.initialize();
            applet.getAppletEnvironment().startApplet();
            AppletInstance appletInstance = applet;
            return appletInstance;
        }
        catch (InstanceExistsException ieex) {
            OutputController.getLogger().log("Single instance applet is already running.");
            throw this.launchError(new LaunchException(file, ieex, Translator.R("LSFatal"), Translator.R("LCLaunching"), Translator.R("LCouldNotLaunch"), Translator.R("LSingleInstanceExists")), applet);
        }
        catch (LaunchException lex) {
            throw this.launchError(lex, applet);
        }
        catch (Exception ex) {
            throw this.launchError(new LaunchException(file, ex, Translator.R("LSFatal"), Translator.R("LCLaunching"), Translator.R("LCouldNotLaunch"), Translator.R("LCouldNotLaunchInfo")), applet);
        }
        finally {
            if (this.handler != null) {
                this.handler.launchStarting(applet);
            }
        }
    }

    protected ApplicationInstance getApplet(JNLPFile file, boolean enableCodeBase, Container cont) throws LaunchException {
        if (!file.isApplet()) {
            throw this.launchError(new LaunchException(file, null, Translator.R("LSFatal"), Translator.R("LCClient"), Translator.R("LNotApplet"), Translator.R("LNotAppletInfo")));
        }
        AppletInstance applet = null;
        try {
            ServiceUtil.checkExistingSingleInstance(file);
            applet = this.createApplet(file, enableCodeBase, cont);
            applet.initialize();
            return applet;
        }
        catch (InstanceExistsException ieex) {
            OutputController.getLogger().log("Single instance applet is already running.");
            throw this.launchError(new LaunchException(file, ieex, Translator.R("LSFatal"), Translator.R("LCLaunching"), Translator.R("LCouldNotLaunch"), Translator.R("LSingleInstanceExists")), applet);
        }
        catch (LaunchException lex) {
            throw this.launchError(lex, applet);
        }
        catch (Exception ex) {
            throw this.launchError(new LaunchException(file, ex, Translator.R("LSFatal"), Translator.R("LCLaunching"), Translator.R("LCouldNotLaunch"), Translator.R("LCouldNotLaunchInfo")), applet);
        }
    }

    protected ApplicationInstance launchInstaller(JNLPFile file) throws LaunchException {
        throw this.launchError(new LaunchException(file, null, Translator.R("LSFatal"), Translator.R("LCNotSupported"), Translator.R("LNoInstallers"), Translator.R("LNoInstallersInfo")));
    }

    protected AppletInstance createApplet(JNLPFile file, boolean enableCodeBase, Container cont) throws LaunchException {
        AppletInstance appletInstance = null;
        try {
            JNLPClassLoader loader = JNLPClassLoader.getInstance(file, this.updatePolicy, enableCodeBase);
            if (enableCodeBase) {
                loader.enableCodeBase();
            } else if (file.getResources().getJARs().length == 0) {
                throw new ClassNotFoundException("Can't do a codebase look up and there are no jars. Failing sooner rather than later");
            }
            ThreadGroup group = Thread.currentThread().getThreadGroup();
            appletInstance = cont == null ? new AppletInstance(file, group, loader, null) : new AppletInstance(file, group, loader, null, cont);
            this.setContextClassLoaderForAllThreads(appletInstance.getThreadGroup(), appletInstance.getClassLoader());
            loader.setApplication(appletInstance);
            String appletName = file.getApplet().getMainClass();
            Class<?> appletClass = loader.loadClass(appletName);
            Applet applet = (Applet)appletClass.newInstance();
            applet.setStub((AppletStub)((Object)cont));
            appletInstance.setApplet(applet);
            appletInstance.getAppletEnvironment().setApplet(applet);
            return appletInstance;
        }
        catch (Exception ex) {
            throw this.launchError(new LaunchException(file, ex, Translator.R("LSFatal"), Translator.R("LCInit"), Translator.R("LInitApplet"), Translator.R("LInitAppletInfo")), appletInstance);
        }
    }

    protected Applet createAppletObject(JNLPFile file, boolean enableCodeBase, Container cont) throws LaunchException {
        try {
            JNLPClassLoader loader = JNLPClassLoader.getInstance(file, this.updatePolicy, enableCodeBase);
            if (enableCodeBase) {
                loader.enableCodeBase();
            } else if (file.getResources().getJARs().length == 0) {
                throw new ClassNotFoundException("Can't do a codebase look up and there are no jars. Failing sooner rather than later");
            }
            String appletName = file.getApplet().getMainClass();
            Class<?> appletClass = loader.loadClass(appletName);
            Applet applet = (Applet)appletClass.newInstance();
            return applet;
        }
        catch (Exception ex) {
            throw this.launchError(new LaunchException(file, ex, Translator.R("LSFatal"), Translator.R("LCInit"), Translator.R("LInitApplet"), Translator.R("LInitAppletInfo")));
        }
    }

    protected ApplicationInstance createApplication(JNLPFile file) throws LaunchException {
        try {
            JNLPClassLoader loader = JNLPClassLoader.getInstance(file, this.updatePolicy, false);
            ThreadGroup group = Thread.currentThread().getThreadGroup();
            ApplicationInstance app = new ApplicationInstance(file, group, loader);
            loader.setApplication(app);
            return app;
        }
        catch (Exception ex) {
            throw new LaunchException(file, ex, Translator.R("LSFatal"), Translator.R("LCInit"), Translator.R("LInitApplication"), Translator.R("LInitApplicationInfo"));
        }
    }

    protected ThreadGroup createThreadGroup(JNLPFile file) {
        ThreadGroup tg = file instanceof PluginBridge ? Thread.currentThread().getThreadGroup() : new ThreadGroup(mainGroup, file.getTitle());
        return tg;
    }

    private LaunchException launchError(LaunchException ex) {
        return this.launchError(ex, null);
    }

    private LaunchException launchError(LaunchException ex, AppletInstance applet) {
        if (applet != null) {
            SplashUtils.showErrorCaught(ex, applet);
        }
        if (this.handler != null) {
            this.handler.launchError(ex);
        }
        return ex;
    }

    private LaunchException launchWarning(LaunchException ex) {
        if (this.handler != null && !this.handler.launchWarning(ex)) {
            return ex;
        }
        return null;
    }

    private static void doPerApplicationAppContextHacks() {
        new ParserDelegator();
    }

    private class TgThread
    extends Thread {
        private JNLPFile file;
        private ApplicationInstance application;
        private LaunchException exception;
        private Container cont;
        private boolean isPlugin;

        TgThread(JNLPFile file) {
            this(file, null);
        }

        TgThread(JNLPFile file, Container cont) {
            super(Launcher.this.createThreadGroup(file), file.getTitle());
            this.isPlugin = false;
            this.file = file;
            this.cont = cont;
        }

        TgThread(JNLPFile file, Container cont, boolean isPlugin) {
            super(Launcher.this.createThreadGroup(file), file.getTitle());
            this.isPlugin = false;
            this.file = file;
            this.cont = cont;
            this.isPlugin = isPlugin;
        }

        @Override
        public void run() {
            block9: {
                try {
                    if (Launcher.this.context && !this.isPlugin) {
                        SunToolkit.createNewAppContext();
                    }
                    Launcher.doPerApplicationAppContextHacks();
                    if (this.isPlugin) {
                        JNLPRuntime.setDefaultDownloadIndicator(null);
                        this.application = Launcher.this.getApplet(this.file, ((PluginBridge)this.file).codeBaseLookup(), this.cont);
                        break block9;
                    }
                    if (this.file.isApplication()) {
                        this.application = Launcher.this.launchApplication(this.file);
                        break block9;
                    }
                    if (this.file.isApplet()) {
                        this.application = Launcher.this.launchApplet(this.file, true, this.cont);
                        break block9;
                    }
                    if (this.file.isInstaller()) {
                        this.application = Launcher.this.launchInstaller(this.file);
                        break block9;
                    }
                    throw Launcher.this.launchError(new LaunchException(this.file, null, Translator.R("LSFatal"), Translator.R("LCClient"), Translator.R("LNotLaunchable"), Translator.R("LNotLaunchableInfo")));
                }
                catch (LaunchException ex) {
                    OutputController.getLogger().log(OutputController.Level.ERROR_ALL, ex);
                    this.exception = ex;
                    if (Launcher.this.exitOnFailure) {
                        JNLPRuntime.exit(1);
                    }
                }
                catch (Throwable ex) {
                    OutputController.getLogger().log(OutputController.Level.ERROR_ALL, ex);
                    throw new RuntimeException(ex);
                }
            }
        }

        public LaunchException getException() {
            return this.exception;
        }

        public ApplicationInstance getApplication() {
            return this.application;
        }
    }
}

