/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security.appletextendedsecurity;

import java.util.regex.Pattern;

public class UrlRegEx {
    private final String regEx;

    private static String quoteString(String s) {
        return Pattern.quote(s);
    }

    public static UrlRegEx quote(String s) {
        return new UrlRegEx(UrlRegEx.quoteString(s));
    }

    public static UrlRegEx quoteAndStar(String s) {
        return new UrlRegEx(UrlRegEx.quoteString(s) + ".*");
    }

    public static UrlRegEx exact(String s) {
        return new UrlRegEx(s);
    }

    private UrlRegEx(String s) {
        this.regEx = s;
    }

    public String toString() {
        return this.getRegEx();
    }

    public String getRegEx() {
        return this.regEx;
    }

    public String getFilteredRegEx() {
        try {
            return UrlRegEx.simpleUnquote(this.regEx);
        }
        catch (Exception ex) {
            return this.regEx;
        }
    }

    static String replaceLast(String where, String what, String by) {
        if (!where.contains(what)) {
            return where;
        }
        StringBuilder b = new StringBuilder(where);
        b.replace(where.lastIndexOf(what), where.lastIndexOf(what) + what.length(), by);
        return b.toString();
    }

    static String simpleUnquote(String s) {
        if (s.length() <= 1) {
            return s;
        }
        boolean in = false;
        for (int i = 1; i < s.length(); ++i) {
            String s2;
            String s1;
            if (i == 0) continue;
            if (!in && s.charAt(i) == 'Q' && s.charAt(i - 1) == '\\') {
                in = true;
                s1 = s.substring(0, i - 1);
                s2 = s.substring(i + 1);
                s = s1 + s2;
                i -= 2;
                continue;
            }
            if (!in || s.charAt(i) != 'E' || s.charAt(i - 1) != '\\') continue;
            s1 = s.substring(0, i - 1);
            s2 = s.substring(i + 1);
            s = s1 + s2;
            i -= 2;
            in = false;
        }
        return s.replace("\\\\E", "\\E");
    }
}

