/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util.logging;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import net.sourceforge.jnlp.util.docprovider.formatters.formatters.PlainTextFormatter;
import net.sourceforge.jnlp.util.logging.OutputController;
import net.sourceforge.jnlp.util.logging.SingleStreamLogger;
import net.sourceforge.jnlp.util.logging.headers.Header;
import net.sourceforge.jnlp.util.logging.headers.JavaMessage;

public final class TeeOutputStream
extends PrintStream
implements SingleStreamLogger {
    private final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
    private final boolean isError;

    public TeeOutputStream(PrintStream stdStream, boolean isError) {
        super(stdStream);
        this.isError = isError;
    }

    @Override
    public void close() {
        this.flushLog();
        super.close();
    }

    @Override
    public void flush() {
        this.flushLog();
        super.flush();
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) {
        if (len == 0) {
            return;
        }
        this.appendByteArray(b, off, len);
        super.write(b, off, len);
    }

    @Override
    public synchronized void write(int b) {
        this.appendByte(b);
        super.write(b);
    }

    private void flushLog() {
        String s = this.byteArrayOutputStream.toString();
        if (s.length() > 0) {
            this.log(s);
            this.byteArrayOutputStream.reset();
        }
    }

    @Override
    public void log(String s) {
        JavaMessage jm = new JavaMessage(new Header(this.getlevel(), false), s);
        jm.getHeader().isClientApp = true;
        OutputController.getLogger().log(jm);
    }

    public boolean isError() {
        return this.isError;
    }

    private void appendByte(int b) {
        this.byteArrayOutputStream.write(b);
        String s = this.byteArrayOutputStream.toString();
        if (s.endsWith(PlainTextFormatter.getLineSeparator())) {
            this.flushLog();
        }
    }

    private void appendByteArray(byte[] b, int off, int len) {
        this.byteArrayOutputStream.write(b, off, len);
        String s = new String(b, off, len);
        if (s.endsWith(PlainTextFormatter.getLineSeparator())) {
            this.flushLog();
        }
    }

    private OutputController.Level getlevel() {
        if (this.isError()) {
            return OutputController.Level.ERROR_ALL;
        }
        return OutputController.Level.MESSAGE_ALL;
    }

    protected ByteArrayOutputStream getByteArrayOutputStream() throws IOException {
        ByteArrayOutputStream copy = new ByteArrayOutputStream();
        copy.write(this.byteArrayOutputStream.toByteArray());
        return copy;
    }
}

