/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.smiles;

import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.PT;
import org.jmol.api.SmilesMatcherInterface;
import org.jmol.modelset.Atom;
import org.jmol.smiles.InvalidSmilesException;
import org.jmol.smiles.SmilesAtom;
import org.jmol.smiles.SmilesBond;
import org.jmol.smiles.SmilesGenerator;
import org.jmol.smiles.SmilesParser;
import org.jmol.smiles.SmilesSearch;
import org.jmol.util.BSUtil;
import org.jmol.util.Elements;
import org.jmol.util.Logger;
import org.jmol.util.Node;
import org.jmol.util.Point3fi;

public class SmilesMatcher
implements SmilesMatcherInterface {
    public static boolean j2sHeadless = true;
    private static final int MODE_BITSET = 1;
    private static final int MODE_ARRAY = 2;
    private static final int MODE_MAP = 3;
    private static final int MODE_ATROP = 4;
    private static final int MODE_BOOLEAN = 5;
    private boolean okMF = true;

    @Override
    public String getLastException() {
        return this.okMF ? InvalidSmilesException.getLastError() : "MF_FAILED";
    }

    @Override
    public String getMolecularFormula(Object pattern, boolean isSmarts, boolean isEmpirical) throws Exception {
        this.clearExceptions();
        SmilesSearch search = SmilesParser.newSearch("/nostereo/" + pattern.toString(), isSmarts, true);
        search.createTopoMap(null);
        search.nodes = search.target.nodes;
        return search.getMolecularFormula(!isSmarts, null, isEmpirical);
    }

    private void clearExceptions() {
        InvalidSmilesException.clear();
    }

    @Override
    public String getSmiles(Node[] atoms, int ac, BS bsSelected, String bioComment, int flags) throws Exception {
        this.clearExceptions();
        return new SmilesGenerator().getSmiles(this, atoms, ac, bsSelected, bioComment, flags);
    }

    @Override
    public int areEqual(Object smiles1, Object smiles2) throws Exception {
        this.clearExceptions();
        if (smiles1 == null != (smiles2 == null)) {
            return 0;
        }
        if (smiles1 == null) {
            return 1;
        }
        boolean isWild = false;
        if (smiles1 instanceof String && smiles2 instanceof String) {
            boolean bl = isWild = ((String)smiles1).indexOf("*") >= 0;
            if (!isWild && smiles1.equals(smiles2)) {
                return 1;
            }
        }
        int flags = (isWild ? 2 : 1) | 8;
        BS[] result = (BS[])this.matchPriv(smiles1, null, 0, null, null, false, flags, 2, this.newSearch(smiles2));
        return result == null ? -1 : result.length;
    }

    public boolean areEqualTest(String smiles, SmilesSearch search) throws Exception {
        search.set();
        BS[] ret = (BS[])this.matchPriv(smiles, null, 0, null, null, false, 9, 2, search);
        return ret != null && ret.length == 1;
    }

    @Override
    public int[][] find(Object pattern, Object target, int flags) throws Exception {
        this.clearExceptions();
        if (target instanceof String) {
            target = SmilesParser.cleanPattern((String)target);
        }
        if (pattern instanceof String) {
            pattern = SmilesParser.cleanPattern((String)pattern);
        }
        SmilesSearch search = this.newSearch(target);
        int[][] array = (int[][])this.matchPriv(pattern, null, 0, null, null, false, flags, 3, search);
        int i = array.length;
        while (--i >= 0) {
            int[] a = array[i];
            int j = a.length;
            while (--j >= 0) {
                a[j] = ((SmilesAtom)search.target.nodes[a[j]]).mapIndex;
            }
        }
        return array;
    }

    @Override
    public Node[] getAtoms(Object target) throws Exception {
        this.clearExceptions();
        SmilesSearch search = this.newSearch(target);
        search.createTopoMap(new BS());
        return search.target.nodes;
    }

    private SmilesSearch newSearch(Object s) throws Exception {
        return s == null ? null : (s instanceof SmilesSearch ? (SmilesSearch)s : SmilesParser.newSearch(SmilesParser.cleanPattern(s.toString()), false, true));
    }

    @Override
    public String getRelationship(String smiles1, String smiles2) throws Exception {
        int n2;
        boolean check;
        String mf2;
        if (smiles1 == null || smiles2 == null || smiles1.length() == 0 || smiles2.length() == 0) {
            return "";
        }
        String mf1 = this.getMolecularFormula(smiles1, false, false);
        if (!mf1.equals(mf2 = this.getMolecularFormula(smiles2, false, false))) {
            return "none";
        }
        int n1 = PT.countChar(PT.rep(smiles1, "@@", "@"), '@');
        boolean bl = check = n1 == (n2 = PT.countChar(PT.rep(smiles2, "@@", "@"), '@')) && this.areEqual(smiles2, smiles1) > 0;
        if (!check) {
            String s = smiles1 + smiles2;
            if (s.indexOf("/") >= 0 || s.indexOf("\\") >= 0 || s.indexOf("@") >= 0) {
                if (n1 == n2 && n1 > 0 && s.indexOf("@SP") < 0) {
                    boolean bl2 = check = this.areEqual("/invertstereo/" + smiles2, smiles1) > 0;
                    if (check) {
                        return "enantiomers";
                    }
                }
                boolean bl3 = check = this.areEqual("/nostereo/" + smiles2, smiles1) > 0;
                if (check) {
                    return n1 == n2 ? "diastereomers" : "ambiguous stereochemistry!";
                }
            }
            return "constitutional isomers";
        }
        return "identical";
    }

    @Override
    public String reverseChirality(String smiles) {
        smiles = PT.rep(smiles, "@@", "!@");
        smiles = PT.rep(smiles, "@", "@@");
        smiles = PT.rep(smiles, "!@@", "@");
        return smiles;
    }

    @Override
    public BS getSubstructureSet(Object pattern, Object target, int ac, BS bsSelected, int flags) throws Exception {
        Node[] atoms = target instanceof SmilesSearch ? null : (Node[])target;
        return (BS)this.matchPriv(pattern, atoms, ac, bsSelected, null, true, flags | (pattern instanceof String ? SmilesParser.getFlags(pattern.toString()) : 0), 1, atoms == null ? (SmilesSearch)target : null);
    }

    @Override
    public void getMMFF94AtomTypes(String[] smarts, Node[] atoms, int ac, BS bsSelected, Lst<BS> ret, Lst<BS>[] vRings) throws Exception {
        this.clearExceptions();
        SmilesParser sp = new SmilesParser(true, true);
        SmilesSearch search = null;
        int flags = 770;
        search = sp.parse("");
        search.exitFirstMatch = false;
        search.target.setAtoms(atoms, Math.abs(ac), bsSelected);
        search.flags = flags;
        search.getRingData(vRings, true, true);
        search.asVector = false;
        search.subSearches = new SmilesSearch[1];
        search.getSelections();
        BS bsDone = new BS();
        for (int i = 0; i < smarts.length; ++i) {
            if (smarts[i] == null || smarts[i].length() == 0 || smarts[i].startsWith("#")) {
                ret.addLast(null);
                continue;
            }
            search.clear();
            search.subSearches[0] = sp.getSubsearch(search, SmilesParser.cleanPattern(smarts[i]), flags);
            BS bs = BSUtil.copy((BS)search.search());
            ret.addLast(bs);
            bsDone.or(bs);
            if (bsDone.cardinality() != ac) continue;
            return;
        }
    }

    @Override
    public BS[] getSubstructureSetArray(Object pattern, Node[] atoms, int ac, BS bsSelected, BS bsAromatic, int flags) throws Exception {
        return (BS[])this.matchPriv(pattern, atoms, ac, bsSelected, bsAromatic, true, flags, 2, null);
    }

    public String getAtropisomerKeys(String pattern, Node[] atoms, int ac, BS bsSelected, BS bsAromatic, int flags) throws Exception {
        return (String)this.matchPriv(pattern, atoms, ac, bsSelected, bsAromatic, false, flags, 4, null);
    }

    @Override
    public String polyhedronToSmiles(Node center, int[][] faces, int atomCount, P3[] points, int flags, String details) throws Exception {
        Node[] atoms = new SmilesAtom[atomCount];
        for (int i = 0; i < atomCount; ++i) {
            P3 pt;
            atoms[i] = new SmilesAtom();
            P3 p3 = pt = points == null ? null : points[i];
            if (pt instanceof Node) {
                atoms[i].elementNumber = ((Node)((Object)pt)).getElementNumber();
                atoms[i].bioAtomName = ((Node)((Object)pt)).getAtomName();
                atoms[i].atomNumber = ((Node)((Object)pt)).getAtomNumber();
                atoms[i].setT(pt);
            } else {
                int n = atoms[i].elementNumber = pt instanceof Point3fi ? ((Point3fi)pt).sD : -2;
                if (pt != null) {
                    atoms[i].setT(pt);
                }
            }
            atoms[i].index = i;
        }
        int nBonds = 0;
        int i = faces.length;
        while (--i >= 0) {
            int n;
            int[] face = faces[i];
            int j = n = face.length;
            while (--j >= 0) {
                int iatom2;
                int iatom = face[j];
                if (iatom >= atomCount || (iatom2 = face[(j + 1) % n]) >= atomCount || ((SmilesAtom)atoms[iatom]).getBondTo((SmilesAtom)atoms[iatom2]) != null) continue;
                SmilesBond b = new SmilesBond((SmilesAtom)atoms[iatom], (SmilesAtom)atoms[iatom2], 1, false);
                b.index = nBonds++;
            }
        }
        for (i = 0; i < atomCount; ++i) {
            int n = atoms[i].bondCount;
            if (n != 0 && n == atoms[i].bonds.length) continue;
            atoms[i].bonds = (SmilesBond[])AU.arrayCopyObject(atoms[i].bonds, n);
        }
        String s = null;
        SmilesGenerator g = new SmilesGenerator();
        if (points != null) {
            g.polySmilesCenter = (P3)((Object)center);
        }
        this.clearExceptions();
        s = g.getSmiles(this, atoms, atomCount, BSUtil.newBitSet2(0, atomCount), null, flags | 0x1000 | 0x10 | 0x20);
        if ((flags & 0x10000) == 65536) {
            s = ((flags & 0x20000) == 0 ? "" : "//* " + center + " *//\t") + "[" + Elements.elementSymbolFromNumber(center.getElementNumber()) + "@PH" + atomCount + (details == null ? "" : "/" + details + "/") + "]." + s;
        }
        return s;
    }

    @Override
    public int[][] getCorrelationMaps(Object pattern, Node[] atoms, int atomCount, BS bsSelected, int flags) throws Exception {
        return (int[][])this.matchPriv(pattern, atoms, atomCount, bsSelected, null, true, flags, 3, null);
    }

    private Object matchPriv(Object pattern, Node[] atoms, int ac, BS bsSelected, BS bsAromatic, boolean doTestAromatic, int flags, int mode, SmilesSearch searchTarget) throws Exception {
        this.clearExceptions();
        try {
            SmilesSearch searchPattern;
            boolean isSmarts;
            boolean isCompiled = pattern instanceof SmilesSearch;
            if (isCompiled) {
                flags |= 2;
                ((SmilesSearch)pattern).reset();
            }
            boolean bl = isSmarts = (flags & 2) == 2;
            SmilesSearch smilesSearch = isCompiled ? (SmilesSearch)pattern : (searchPattern = SmilesParser.newSearch(pattern == null ? null : pattern.toString(), isSmarts, false));
            if (searchTarget != null) {
                searchTarget.setFlags(flags | searchTarget.flags | (isCompiled ? 0 : SmilesParser.getFlags(pattern.toString())));
            }
            return this.matchPattern(searchPattern, atoms, ac, bsSelected, bsAromatic, doTestAromatic, flags, mode, searchTarget);
        }
        catch (Exception e) {
            if (Logger.debugging) {
                e.printStackTrace();
            }
            if (InvalidSmilesException.getLastError() == null) {
                this.clearExceptions();
            }
            throw new InvalidSmilesException(InvalidSmilesException.getLastError());
        }
    }

    private Object matchPattern(SmilesSearch search, Node[] atoms, int ac, BS bsSelected, BS bsAromatic, boolean doTestAromatic, int flags, int mode, SmilesSearch searchTarget) throws InvalidSmilesException {
        boolean isSmarts = (flags & 2) == 2;
        this.okMF = true;
        if (searchTarget != null) {
            if (searchTarget.targetSet) {
                search.setTarget(searchTarget);
            } else {
                search.haveSmilesTarget = true;
                bsAromatic = new BS();
                searchTarget.createTopoMap(bsAromatic);
                atoms = searchTarget.target.nodes;
                ac = searchTarget.target.nodes.length;
                if (isSmarts) {
                    int[] a1 = searchTarget.elementCounts;
                    int[] a2 = search.elementCounts;
                    int n = search.elementNumberMax;
                    if (n <= searchTarget.elementNumberMax) {
                        for (int i = 1; i <= n; ++i) {
                            if (a1[i] >= a2[i]) continue;
                            this.okMF = false;
                            break;
                        }
                    } else {
                        this.okMF = false;
                    }
                } else {
                    int[] mf = search.getMFArray(true, null, false);
                    int[] mft = searchTarget.getMFArray(true, null, false);
                    int n = searchTarget.elementNumberMax;
                    if (n == search.elementNumberMax) {
                        for (int i = 2; i <= n; ++i) {
                            if (mf[i] == mft[i]) continue;
                            this.okMF = false;
                            break;
                        }
                    } else {
                        this.okMF = false;
                    }
                }
            }
        }
        if (this.okMF) {
            if (!isSmarts && !search.patternAromatic) {
                if (bsAromatic == null) {
                    bsAromatic = new BS();
                }
                search.normalizeAromaticity(bsAromatic);
                search.isNormalized = true;
            }
            if (!search.targetSet) {
                search.target.setAtoms(atoms, ac, bsSelected);
            }
            if (search.targetSet || ac != 0 && (bsSelected == null || !bsSelected.isEmpty())) {
                boolean is3D = search.targetSet || !(atoms[0] instanceof SmilesAtom);
                search.getSelections();
                if (!doTestAromatic) {
                    search.target.bsAromatic = bsAromatic;
                }
                if (!search.target.hasRingData(flags)) {
                    search.setRingData(null, null, is3D || doTestAromatic || search.patternAromatic);
                }
                search.exitFirstMatch = (flags & 8) == 8;
                search.mapUnique = (flags & 0x80) == 128;
            }
        }
        switch (mode) {
            case 1: {
                search.asVector = false;
                return this.okMF ? search.search() : new BS();
            }
            case 2: {
                if (!this.okMF) {
                    return new BS[0];
                }
                search.asVector = true;
                Lst vb = (Lst)search.search();
                return vb.toArray(new BS[vb.size()]);
            }
            case 4: {
                if (!this.okMF) {
                    return "";
                }
                search.exitFirstMatch = true;
                search.setAtropicity = true;
                search.search();
                return search.atropKeys;
            }
            case 3: {
                if (!this.okMF) {
                    return new int[0][0];
                }
                search.getMaps = true;
                search.setFlags(flags | search.flags);
                Lst vl = (Lst)search.search();
                return vl.toArray((T[])AU.newInt2(vl.size()));
            }
            case 5: {
                if (!this.okMF) {
                    return Boolean.FALSE;
                }
                search.retBoolean = true;
                search.setFlags(flags | search.flags);
                return search.search();
            }
        }
        return null;
    }

    @Override
    public String cleanSmiles(String smiles) {
        return SmilesParser.cleanPattern(smiles);
    }

    @Override
    public int[][] getMapForJME(String jme, Atom[] at, BS bsAtoms) {
        try {
            SmilesSearch molecule = SmilesMatcher.jmeToMolecule(jme);
            BS bs = BSUtil.newBitSet2(0, molecule.ac);
            String s = this.getSmiles(molecule.patternAtoms, molecule.ac, bs, null, 34);
            int[][] map = this.getCorrelationMaps(s, molecule.patternAtoms, molecule.ac, bs, 42);
            int[][] map2 = this.getCorrelationMaps(s, at, bsAtoms.cardinality(), bsAtoms, 42);
            return new int[][]{map[0], map2[0]};
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static SmilesSearch jmeToMolecule(String jme) throws InvalidSmilesException {
        SmilesSearch molecule = new SmilesSearch();
        String[] tokens = PT.getTokens(jme);
        int nAtoms = PT.parseInt(tokens[0]);
        int nBonds = PT.parseInt(tokens[1]);
        int pt = 2;
        int i = 0;
        while (i < nAtoms) {
            String sa = tokens[pt];
            SmilesAtom a = molecule.addAtom();
            int ic = sa.indexOf("+");
            int charge = 0;
            if (ic >= 0) {
                charge = ic == sa.length() - 1 ? 1 : PT.parseInt(sa.substring(ic + 1));
            } else {
                ic = sa.indexOf("-");
                if (ic >= 0) {
                    charge = PT.parseInt(sa.substring(ic));
                }
            }
            a.setCharge(charge);
            a.setSymbol(ic < 0 ? sa : sa.substring(0, ic));
            ++i;
            pt += 3;
        }
        i = 0;
        while (i < nBonds) {
            int ia = PT.parseInt(tokens[pt++]) - 1;
            int ib = PT.parseInt(tokens[pt++]) - 1;
            int iorder = PT.parseInt(tokens[pt++]);
            SmilesAtom a1 = molecule.patternAtoms[ia];
            SmilesAtom a2 = molecule.patternAtoms[ib];
            int order = 1;
            switch (iorder) {
                default: {
                    break;
                }
                case 2: {
                    order = 2;
                    break;
                }
                case 3: {
                    order = 3;
                }
            }
            new SmilesBond((SmilesAtom)a1, (SmilesAtom)a2, (int)order, (boolean)false).index = i++;
        }
        molecule.isSmarts = true;
        molecule.set();
        return molecule;
    }

    @Override
    public String getSmilesFromJME(String jme) {
        try {
            SmilesSearch molecule = SmilesMatcher.jmeToMolecule(jme);
            BS bs = BSUtil.newBitSet2(0, molecule.ac);
            return this.getSmiles(molecule.patternAtoms, molecule.ac, bs, null, 1);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Object compileSmartsPattern(String pattern) throws Exception {
        pattern = SmilesParser.cleanPattern(pattern);
        return SmilesParser.newSearch(pattern, true, false);
    }

    @Override
    public Object compileSearchTarget(Node[] atoms, int atomCount, BS bsSelected) {
        SmilesSearch ss = new SmilesSearch();
        ss.target.setAtoms(atoms, atomCount, bsSelected);
        ss.targetSet = true;
        return ss;
    }

    @Override
    public int[] hasStructure(Object pattern, Object[] smilesSet, int flags) throws Exception {
        int[] ret = new int[smilesSet.length];
        if ((flags & 1) != 1) {
            flags |= 2;
        }
        this.clearExceptions();
        if (pattern instanceof String) {
            pattern = SmilesParser.cleanPattern((String)pattern);
        }
        try {
            SmilesSearch search = pattern instanceof String ? SmilesParser.newSearch((String)pattern, true, false) : (SmilesSearch)pattern;
            for (int i = 0; i < smilesSet.length; ++i) {
                SmilesSearch searchTarget;
                Object smiles = smilesSet[i];
                if (smiles instanceof String) {
                    searchTarget = this.newSearch(smiles);
                    searchTarget.setFlags(searchTarget.flags | (pattern instanceof String ? SmilesParser.getFlags((String)pattern) : 0));
                } else {
                    searchTarget = (SmilesSearch)smiles;
                }
                try {
                    this.clearExceptions();
                    ret[i] = this.matchPattern(search, null, 0, null, null, false, flags | 8, 5, searchTarget) == Boolean.TRUE ? 1 : 0;
                    continue;
                }
                catch (Exception e) {
                    ret[i] = -1;
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            if (Logger.debugging) {
                e.printStackTrace();
            }
            if (InvalidSmilesException.getLastError() == null) {
                this.clearExceptions();
            }
            throw new InvalidSmilesException(InvalidSmilesException.getLastError());
        }
        return ret;
    }
}

