/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Color;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.gui.history.DiffTableModel;
import org.openstreetmap.josm.gui.history.TwoColumnDiff;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class NodeListTableCellRenderer
extends JLabel
implements TableCellRenderer {
    public static final Color BGCOLOR_SELECTED = new Color(143, 170, 255);
    private final ImageIcon nodeIcon;

    public NodeListTableCellRenderer() {
        this.setOpaque(true);
        this.nodeIcon = ImageProvider.get("data", "node");
        this.setIcon(this.nodeIcon);
    }

    protected void renderIndex(DiffTableModel model, int row) {
        int rowNumber = model.getRowNumber(row);
        this.setText(rowNumber > 0 ? Integer.toString(rowNumber) : "");
        this.setToolTipText(null);
        this.setHorizontalAlignment(0);
        this.setIcon(null);
    }

    protected void renderNode(TwoColumnDiff.Item item) {
        String text = "";
        this.setIcon(this.nodeIcon);
        if (item.value != null) {
            text = I18n.tr("Node {0}", item.value.toString());
        }
        if (item.state == TwoColumnDiff.Item.DiffItemType.EMPTY) {
            text = "";
            this.setIcon(null);
        }
        this.setText(text);
        this.setHorizontalAlignment(10);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value == null) {
            return this;
        }
        TwoColumnDiff.Item item = (TwoColumnDiff.Item)value;
        GuiHelper.setBackgroundReadable(this, item.state.getColor(isSelected, hasFocus));
        if (column == 0) {
            this.renderIndex((DiffTableModel)table.getModel(), row);
        } else if (column == 1) {
            this.renderNode(item);
        }
        return this;
    }
}

