/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import sun.misc.Unsafe;

public class AtomicMarkableReference<V> {
    private volatile Pair<V> pair;
    private static final Unsafe UNSAFE = Unsafe.getUnsafe();
    private static final long pairOffset = AtomicMarkableReference.objectFieldOffset(UNSAFE, "pair", AtomicMarkableReference.class);

    public AtomicMarkableReference(V v, boolean bl) {
        this.pair = Pair.of(v, bl);
    }

    public V getReference() {
        return (V)this.pair.reference;
    }

    public boolean isMarked() {
        return this.pair.mark;
    }

    public V get(boolean[] blArray) {
        Pair<V> pair = this.pair;
        blArray[0] = pair.mark;
        return (V)pair.reference;
    }

    public boolean weakCompareAndSet(V v, V v2, boolean bl, boolean bl2) {
        return this.compareAndSet(v, v2, bl, bl2);
    }

    public boolean compareAndSet(V v, V v2, boolean bl, boolean bl2) {
        Pair<V> pair = this.pair;
        return v == pair.reference && bl == pair.mark && (v2 == pair.reference && bl2 == pair.mark || this.casPair(pair, Pair.of(v2, bl2)));
    }

    public void set(V v, boolean bl) {
        Pair<V> pair = this.pair;
        if (v != pair.reference || bl != pair.mark) {
            this.pair = Pair.of(v, bl);
        }
    }

    public boolean attemptMark(V v, boolean bl) {
        Pair<V> pair = this.pair;
        return v == pair.reference && (bl == pair.mark || this.casPair(pair, Pair.of(v, bl)));
    }

    private boolean casPair(Pair<V> pair, Pair<V> pair2) {
        return UNSAFE.compareAndSwapObject(this, pairOffset, pair, pair2);
    }

    static long objectFieldOffset(Unsafe unsafe, String string, Class<?> clazz) {
        try {
            return unsafe.objectFieldOffset(clazz.getDeclaredField(string));
        }
        catch (NoSuchFieldException noSuchFieldException) {
            NoSuchFieldError noSuchFieldError = new NoSuchFieldError(string);
            noSuchFieldError.initCause(noSuchFieldException);
            throw noSuchFieldError;
        }
    }

    private static class Pair<T> {
        final T reference;
        final boolean mark;

        private Pair(T t, boolean bl) {
            this.reference = t;
            this.mark = bl;
        }

        static <T> Pair<T> of(T t, boolean bl) {
            return new Pair<T>(t, bl);
        }
    }
}

