/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler;

import org.jsampler.CC;
import org.jsampler.DOMUtils;
import org.jsampler.Resource;
import org.linuxsampler.lscp.Instrument;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OrchestraInstrument
extends Resource
implements Instrument {
    private String path = null;
    private int instrumentIndex = 0;
    private String engine = "GIG";
    private final StringBuffer sb = new StringBuffer();

    @Override
    public String getFilePath() {
        return this.path;
    }

    @Override
    public void setFilePath(String string) {
        this.path = string;
        this.fireChangeEvent();
    }

    @Override
    public int getInstrumentIndex() {
        return this.instrumentIndex;
    }

    @Override
    public void setInstrumentIndex(int n) {
        this.instrumentIndex = n;
        this.fireChangeEvent();
    }

    @Override
    public String getEngine() {
        return this.engine;
    }

    public void setEngine(String string) {
        this.engine = string;
    }

    @Override
    public String getFormatFamily() {
        return null;
    }

    @Override
    public String getFormatVersion() {
        return null;
    }

    @Override
    public Integer[] getKeyMapping() {
        return null;
    }

    @Override
    public Integer[] getKeyswitchMapping() {
        return null;
    }

    public String toString() {
        return this.getName();
    }

    public String getDnDString() {
        this.sb.setLength(0);
        this.sb.append("[Instrument Definition]\n");
        this.sb.append(this.getName()).append("\n");
        this.sb.append("\n");
        this.sb.append(this.getDescription()).append("\n");
        this.sb.append(this.getFilePath()).append("\n");
        this.sb.append(this.getInstrumentIndex()).append("\n");
        return this.sb.toString();
    }

    public void setDnDString(String string) {
        if (!OrchestraInstrument.isDnDString(string)) {
            throw new IllegalArgumentException("Not a DnD string");
        }
        String[] stringArray = string.split("\n");
        if (stringArray.length < 6) {
            throw new IllegalArgumentException("Not a DnD string");
        }
        this.setName(stringArray[1]);
        this.setDescription(stringArray[3]);
        this.setFilePath(stringArray[4]);
        try {
            this.setInstrumentIndex(Integer.parseInt(stringArray[5]));
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Not a DnD string", exception);
        }
    }

    public static boolean isDnDString(String string) {
        if (string == null) {
            return false;
        }
        return string.startsWith("[Instrument Definition]\n");
    }

    public void readObject(Node node) {
        if (node.getNodeType() != 1 || !node.getNodeName().equals("instrument")) {
            throw new IllegalArgumentException("Not an instrument node!");
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("name");
        if (node2 == null) {
            throw new IllegalArgumentException("The instrument name is undefined!");
        }
        DOMUtils.validateTextContent(node2);
        this.setName(node2.getFirstChild().getNodeValue());
        String string = null;
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            string = node.getNodeName();
            if (string.equals("description")) {
                if (!node.hasChildNodes()) continue;
                DOMUtils.validateTextContent(node);
                this.setDescription(node.getFirstChild().getNodeValue());
                continue;
            }
            if (string.equals("path")) {
                DOMUtils.validateTextContent(node);
                this.setFilePath(node.getFirstChild().getNodeValue());
                continue;
            }
            if (string.equals("instrument-index")) {
                DOMUtils.validateTextContent(node);
                try {
                    int n = Integer.parseInt(node.getFirstChild().getNodeValue());
                    this.setInstrumentIndex(n);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Not a number");
                }
            }
            CC.getLogger().info("Unknown field: " + string);
        }
    }

    public void writeObject(Document document, Node node) {
        Element element = document.createElement("instrument");
        element.setAttribute("name", this.getName());
        node.appendChild(element);
        node = element;
        element = document.createElement("description");
        element.appendChild(document.createTextNode(this.getDescription()));
        node.appendChild(element);
        element = document.createElement("path");
        element.appendChild(document.createTextNode(this.getFilePath()));
        node.appendChild(element);
        element = document.createElement("instrument-index");
        element.appendChild(document.createTextNode(String.valueOf(this.getInstrumentIndex())));
        node.appendChild(element);
    }
}

