/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.std;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.sf.juife.OkCancelDialog;
import net.sf.juife.Task;
import net.sf.juife.event.TaskEvent;
import net.sf.juife.event.TaskListener;
import org.jsampler.CC;
import org.jsampler.JSPrefs;
import org.jsampler.task.InstrumentsDb;
import org.jsampler.view.std.JSAddDbInstrumentsProgressDlg;
import org.jsampler.view.std.JSDbDirectoryChooser;
import org.jsampler.view.std.StdI18n;
import org.jsampler.view.std.StdUtils;
import org.linuxsampler.lscp.Parser;

public class JSAddDbInstrumentsFromDirDlg
extends OkCancelDialog {
    private final JComboBox cbSource = StdUtils.createPathComboBox();
    private JButton btnBrowse;
    private final JCheckBox checkScanSubdirs = new JCheckBox(StdI18n.i18n.getLabel("JSAddDbInstrumentsFromDirDlg.checkScanSubdirs"));
    private final JCheckBox checkFlat = new JCheckBox(StdI18n.i18n.getLabel("JSAddDbInstrumentsFromDirDlg.checkFlat"));
    private final JCheckBox checkInstrDirs = new JCheckBox(StdI18n.i18n.getLabel("JSAddDbInstrumentsFromDirDlg.checkInstrDirs"));
    private final JComboBox cbDest = StdUtils.createPathComboBox();
    private JButton btnBrowseDb;
    private final Handler eventHandler = new Handler();

    public JSAddDbInstrumentsFromDirDlg(Frame frame, String string, Icon icon) {
        super(frame, StdI18n.i18n.getLabel("JSAddDbInstrumentsFromDirDlg.title"));
        this.initAddDbInstrumentsFromDirDlg(string, icon);
    }

    public JSAddDbInstrumentsFromDirDlg(Dialog dialog, String string, Icon icon) {
        super(dialog, StdI18n.i18n.getLabel("JSAddDbInstrumentsFromDirDlg.title"));
        this.initAddDbInstrumentsFromDirDlg(string, icon);
    }

    private void initAddDbInstrumentsFromDirDlg(String string, Icon icon) {
        String[] stringArray;
        this.btnBrowse = new JButton(icon);
        this.btnBrowseDb = new JButton(icon);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(this.cbSource);
        jPanel2.add(Box.createRigidArea(new Dimension(6, 0)));
        this.btnBrowse.setToolTipText(StdI18n.i18n.getButtonLabel("browse"));
        this.btnBrowse.setMargin(new Insets(0, 0, 0, 0));
        jPanel2.add(this.btnBrowse);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        jPanel2.setMaximumSize(new Dimension(Short.MAX_VALUE, jPanel2.getPreferredSize().height));
        jPanel2.setAlignmentX(0.0f);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(this.checkScanSubdirs);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        jPanel2.setAlignmentX(0.0f);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(this.checkFlat);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 15, 3, 3));
        jPanel2.setAlignmentX(0.0f);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(this.checkInstrDirs);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        jPanel2.setAlignmentX(0.0f);
        jPanel.add(jPanel2);
        String string2 = StdI18n.i18n.getLabel("JSAddDbInstrumentsFromDirDlg.source");
        jPanel.setBorder(BorderFactory.createTitledBorder(string2));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.add(jPanel);
        jPanel3.add(Box.createRigidArea(new Dimension(0, 6)));
        jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(this.cbDest);
        jPanel2.add(Box.createRigidArea(new Dimension(6, 0)));
        this.btnBrowseDb.setToolTipText(StdI18n.i18n.getButtonLabel("browse"));
        this.btnBrowseDb.setMargin(new Insets(0, 0, 0, 0));
        jPanel2.add(this.btnBrowseDb);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 3, 3, 3));
        jPanel2.setMaximumSize(new Dimension(Short.MAX_VALUE, jPanel2.getPreferredSize().height));
        jPanel2.setAlignmentX(0.0f);
        jPanel.add(jPanel2);
        string2 = StdI18n.i18n.getLabel("JSAddDbInstrumentsFromDirDlg.dest");
        jPanel.setBorder(BorderFactory.createTitledBorder(string2));
        jPanel3.add(jPanel);
        Dimension dimension = jPanel3.getPreferredSize();
        jPanel3.setPreferredSize(new Dimension(dimension.width > 300 ? dimension.width : 300, dimension.height));
        this.setMainPane(jPanel3);
        this.setMinimumSize(this.getPreferredSize());
        this.setResizable(true);
        this.btnOk.setEnabled(false);
        this.checkScanSubdirs.doClick(0);
        this.checkFlat.doClick(0);
        for (String string3 : stringArray = this.preferences().getStringListProperty("recentDirectories")) {
            this.cbSource.addItem(string3);
        }
        this.cbSource.setSelectedItem(null);
        this.cbSource.setPreferredSize(new Dimension(200, this.cbSource.getPreferredSize().height));
        this.cbSource.addActionListener(this.getHandler());
        for (String string3 : stringArray = this.preferences().getStringListProperty("recentDbDirectories")) {
            this.cbDest.addItem(string3);
        }
        this.cbDest.setSelectedItem(string);
        this.cbDest.setPreferredSize(new Dimension(200, this.cbDest.getPreferredSize().height));
        this.cbDest.addActionListener(this.getHandler());
        this.btnBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JSAddDbInstrumentsFromDirDlg.this.onBrowse();
            }
        });
        this.checkScanSubdirs.addItemListener(this.getHandler());
        this.btnBrowseDb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JSAddDbInstrumentsFromDirDlg.this.onBrowseDb();
            }
        });
    }

    protected JComboBox createComboBox() {
        return new JComboBox();
    }

    protected JSPrefs preferences() {
        return CC.getViewConfig().preferences();
    }

    private void onBrowse() {
        File file = StdUtils.showOpenDirectoryChooser(this, "lastInstrumentLocation");
        if (file == null) {
            return;
        }
        String string = file.getAbsolutePath();
        if (File.separatorChar == '\\') {
            string = string.replace('\\', '/');
        }
        string = Parser.toEscapedString(string);
        this.cbSource.setSelectedItem(string);
    }

    private void onBrowseDb() {
        JSDbDirectoryChooser jSDbDirectoryChooser = new JSDbDirectoryChooser(this);
        Object object = this.cbDest.getSelectedItem();
        if (object != null && object.toString().length() > 0) {
            jSDbDirectoryChooser.setSelectedDirectory(object.toString());
        }
        jSDbDirectoryChooser.setVisible(true);
        if (jSDbDirectoryChooser.isCancelled()) {
            return;
        }
        this.cbDest.setSelectedItem(jSDbDirectoryChooser.getSelectedDirectory());
    }

    private void updateState() {
        Object object = this.cbSource.getSelectedItem();
        Object object2 = this.cbDest.getSelectedItem();
        boolean bl = object != null && object.toString().length() > 0;
        bl = bl && object2 != null && object2.toString().length() > 0;
        this.btnOk.setEnabled(bl);
    }

    @Override
    protected void onOk() {
        if (!this.btnOk.isEnabled()) {
            return;
        }
        this.btnOk.setEnabled(false);
        String string = this.cbDest.getSelectedItem().toString();
        String string2 = this.cbSource.getSelectedItem().toString();
        boolean bl = this.checkScanSubdirs.isSelected();
        boolean bl2 = !this.checkFlat.isSelected();
        boolean bl3 = this.checkInstrDirs.isSelected();
        if (bl) {
            this.runTask(new InstrumentsDb.AddInstruments(string, string2, bl2, bl3));
        } else {
            this.runTask(new InstrumentsDb.AddInstrumentsNonrecursive(string, string2, bl3));
        }
        StdUtils.updateRecentElements("recentDirectories", string2);
        StdUtils.updateRecentElements("recentDbDirectories", string);
    }

    @Override
    protected void onCancel() {
        this.setVisible(false);
    }

    private void runTask(final Task<Integer> task) {
        task.addTaskListener(new TaskListener(){

            @Override
            public void taskPerformed(TaskEvent taskEvent) {
                JSAddDbInstrumentsFromDirDlg.this.updateState();
                if (task.doneWithErrors()) {
                    return;
                }
                JSAddDbInstrumentsFromDirDlg.this.showProgress((Integer)task.getResult());
            }
        });
        CC.getTaskQueue().add(task);
    }

    private void showProgress(int n) {
        final JSAddDbInstrumentsProgressDlg jSAddDbInstrumentsProgressDlg = new JSAddDbInstrumentsProgressDlg((Dialog)this, n);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                jSAddDbInstrumentsProgressDlg.setVisible(true);
                jSAddDbInstrumentsProgressDlg.updateStatus();
            }
        });
    }

    private Handler getHandler() {
        return this.eventHandler;
    }

    private class Handler
    implements DocumentListener,
    ActionListener,
    ItemListener {
        private Handler() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            JSAddDbInstrumentsFromDirDlg.this.updateState();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            JSAddDbInstrumentsFromDirDlg.this.updateState();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            JSAddDbInstrumentsFromDirDlg.this.updateState();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JSAddDbInstrumentsFromDirDlg.this.updateState();
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            JSAddDbInstrumentsFromDirDlg.this.checkFlat.setEnabled(JSAddDbInstrumentsFromDirDlg.this.checkScanSubdirs.isSelected());
        }
    }
}

