/*
 * Decompiled with CFR 0.152.
 */
package org.linuxsampler.lscp;

import org.linuxsampler.lscp.Client;
import org.linuxsampler.lscp.LscpException;
import org.linuxsampler.lscp.LscpI18n;
import org.linuxsampler.lscp.Parameter;
import org.linuxsampler.lscp.ParameterType;
import org.linuxsampler.lscp.Parseable;
import org.linuxsampler.lscp.Parser;

public abstract class AbstractParameter<T>
implements Parameter<T>,
Parseable {
    private String name = null;
    private ParameterType type = null;
    private String desc = null;
    private boolean fix = true;
    private boolean multiplicity = true;
    private boolean mandatory = false;
    private String[] depends = null;
    private T val = null;
    private T dflt = null;
    private Number rangeMin = null;
    private Number rangeMax = null;
    private T[] possibilities = null;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public String getDescription() {
        return this.desc;
    }

    public void setDescription(String string) {
        this.desc = string;
    }

    @Override
    public ParameterType getType() {
        return this.type;
    }

    public void setType(ParameterType parameterType) {
        this.type = parameterType;
    }

    @Override
    public T getValue() {
        return this.val;
    }

    @Override
    public void setValue(T t) {
        this.val = t;
    }

    public boolean isBoolean() {
        return this.type == ParameterType.BOOL;
    }

    public boolean isInteger() {
        return this.type == ParameterType.INT;
    }

    public boolean isFloat() {
        return this.type == ParameterType.FLOAT;
    }

    public boolean isString() {
        return this.type == ParameterType.STRING;
    }

    public boolean isBooleanList() {
        return this.type == ParameterType.BOOL_LIST;
    }

    public boolean isIntegerList() {
        return this.type == ParameterType.INT_LIST;
    }

    public boolean isFloatList() {
        return this.type == ParameterType.FLOAT_LIST;
    }

    public boolean isStringList() {
        return this.type == ParameterType.STRING_LIST;
    }

    @Override
    public boolean isFixed() {
        return this.fix;
    }

    @Override
    public boolean isMultiplicity() {
        return this.multiplicity;
    }

    public void setMultiplicity(boolean bl) {
        this.multiplicity = bl;
    }

    @Override
    public boolean isMandatory() {
        return this.mandatory;
    }

    @Override
    public String[] getDependances() {
        return this.depends;
    }

    @Override
    public boolean hasDependances() {
        return this.depends != null;
    }

    @Override
    public boolean parse(String string) throws LscpException {
        if (string.startsWith("DESCRIPTION: ")) {
            this.desc = string.substring("DESCRIPTION: ".length(), string.length());
            return true;
        }
        if (string.startsWith("FIX: ")) {
            this.fix = Boolean.parseBoolean(string.substring("FIX: ".length(), string.length()));
            return true;
        }
        if (string.startsWith("MANDATORY: ")) {
            this.mandatory = Boolean.parseBoolean(string.substring("MANDATORY: ".length(), string.length()));
            return true;
        }
        if (string.startsWith("DEPENDS: ")) {
            string = string.substring("DEPENDS: ".length(), string.length());
            this.depends = Parser.parseList(string);
            return true;
        }
        if (string.startsWith("TYPE: ")) {
            return true;
        }
        return string.startsWith("MULTIPLICITY: ");
    }

    protected void parseLines(String[] stringArray) throws LscpException {
        for (String string : stringArray) {
            if (this.parse(string)) continue;
            Client.getLogger().info(LscpI18n.getLogMsg("unknownLine", string));
        }
    }

    @Override
    public T getDefault() {
        return this.dflt;
    }

    public T setDefault(T t) {
        this.dflt = t;
        return this.dflt;
    }

    @Override
    public Number getRangeMin() {
        return this.rangeMin;
    }

    public void setRangeMin(Number number) {
        this.rangeMin = number;
    }

    @Override
    public Number getRangeMax() {
        return this.rangeMax;
    }

    public void setRangeMax(Number number) {
        this.rangeMax = number;
    }

    @Override
    public T[] getPossibilities() {
        return this.possibilities;
    }

    public void setPossibilities(T[] TArray) {
        this.possibilities = TArray;
    }

    @Override
    public boolean hasRangeMin() {
        return this.rangeMin != null;
    }

    @Override
    public boolean hasRangeMax() {
        return this.rangeMax != null;
    }

    @Override
    public boolean hasPossibilities() {
        return this.possibilities != null;
    }

    public String toString() {
        return this.getName();
    }
}

