/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal;

import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.SQLException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.model.domain.BasicDomainType;
import org.hibernate.query.sqm.tree.domain.SqmDomainType;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public class BasicTypeImpl<J>
implements BasicDomainType<J>,
SqmDomainType<J>,
JdbcMapping,
Serializable {
    private final JavaType<J> javaType;
    private final JdbcType jdbcType;

    public BasicTypeImpl(JavaType<J> javaType, JdbcType jdbcType) {
        this.javaType = javaType;
        this.jdbcType = jdbcType;
    }

    @Override
    public Class<J> getJavaType() {
        return BasicDomainType.super.getJavaType();
    }

    @Override
    public String getTypeName() {
        return this.javaType.getTypeName();
    }

    @Override
    public SqmDomainType<J> getSqmType() {
        return this;
    }

    @Override
    public JavaType<J> getExpressibleJavaType() {
        return this.javaType;
    }

    @Override
    public boolean canDoExtraction() {
        return true;
    }

    @Override
    public JdbcType getJdbcType() {
        return this.jdbcType;
    }

    @Override
    public J extract(CallableStatement statement, int paramIndex, SharedSessionContractImplementor session) throws SQLException {
        return this.jdbcType.getExtractor(this.javaType).extract(statement, paramIndex, (WrapperOptions)session);
    }

    @Override
    public J extract(CallableStatement statement, String paramName, SharedSessionContractImplementor session) throws SQLException {
        return this.jdbcType.getExtractor(this.javaType).extract(statement, paramName, (WrapperOptions)session);
    }

    @Override
    public JavaType<?> getJavaTypeDescriptor() {
        throw new UnsupportedOperationException();
    }

    public ValueExtractor<J> getJdbcValueExtractor() {
        return this.jdbcType.getExtractor(this.javaType);
    }

    @Override
    public ValueBinder<J> getJdbcValueBinder() {
        return this.jdbcType.getBinder(this.javaType);
    }
}

