/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.temptable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.dialect.temptable.TemporaryTable;
import org.hibernate.dialect.temptable.TemporaryTableSessionUidColumn;
import org.hibernate.dialect.temptable.TemporaryTableStrategy;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.MutableObject;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.SoftDeleteMapping;
import org.hibernate.metamodel.spi.MappingMetamodelImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.SemanticException;
import org.hibernate.query.results.internal.TableGroupImpl;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.query.sqm.internal.CacheableSqmInterpretation;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SqmJdbcExecutionContextAdapter;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.mutation.internal.AbstractMutationHandler;
import org.hibernate.query.sqm.mutation.internal.MultiTableSqmMutationConverter;
import org.hibernate.query.sqm.mutation.internal.TableKeyExpressionCollector;
import org.hibernate.query.sqm.mutation.internal.UpdateHandler;
import org.hibernate.query.sqm.mutation.internal.temptable.ExecuteWithTemporaryTableHelper;
import org.hibernate.query.sqm.mutation.spi.AfterUseAction;
import org.hibernate.query.sqm.spi.SqmParameterMappingModelResolutionAccess;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.update.SqmUpdateStatement;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.expression.QueryLiteral;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;
import org.hibernate.sql.ast.tree.from.UnionTableReference;
import org.hibernate.sql.ast.tree.insert.InsertSelectStatement;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.ExistsPredicate;
import org.hibernate.sql.ast.tree.predicate.InSubQueryPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.predicate.PredicateCollector;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectClause;
import org.hibernate.sql.ast.tree.update.Assignment;
import org.hibernate.sql.ast.tree.update.UpdateStatement;
import org.hibernate.sql.exec.internal.JdbcParameterBindingImpl;
import org.hibernate.sql.exec.internal.SqlTypedMappingJdbcParameter;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcOperationQueryMutation;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcParametersList;
import org.hibernate.sql.results.internal.SqlSelectionImpl;
import org.jboss.logging.Logger;

public class TableBasedUpdateHandler
extends AbstractMutationHandler
implements UpdateHandler {
    private static final Logger log = Logger.getLogger(TableBasedUpdateHandler.class);
    private final TemporaryTable idTable;
    private final TemporaryTableStrategy temporaryTableStrategy;
    private final boolean forceDropAfterUse;
    private final Function<SharedSessionContractImplementor, String> sessionUidAccess;
    private final DomainParameterXref domainParameterXref;
    private final Map<QueryParameterImplementor<?>, Map<SqmParameter<?>, List<JdbcParametersList>>> jdbcParamsXref;
    private final Map<SqmParameter<?>, MappingModelExpressible<?>> resolvedParameterMappingModelTypes;
    private final @Nullable JdbcParameter sessionUidParameter;
    private final CacheableSqmInterpretation<InsertSelectStatement, JdbcOperationQueryMutation> matchingIdsIntoIdTableInsert;
    private final List<TableUpdater> tableUpdaters;

    public TableBasedUpdateHandler(SqmUpdateStatement<?> sqmUpdate, DomainParameterXref domainParameterXref, TemporaryTable idTable, TemporaryTableStrategy temporaryTableStrategy, boolean forceDropAfterUse, Function<SharedSessionContractImplementor, String> sessionUidAccess, DomainQueryExecutionContext context, MutableObject<JdbcParameterBindings> firstJdbcParameterBindingsConsumer) {
        super(sqmUpdate, context.getSession().getSessionFactory());
        Predicate suppliedPredicate;
        this.idTable = idTable;
        this.temporaryTableStrategy = temporaryTableStrategy;
        this.forceDropAfterUse = forceDropAfterUse;
        this.sessionUidAccess = sessionUidAccess;
        TemporaryTableSessionUidColumn sessionUidColumn = idTable.getSessionUidColumn();
        this.sessionUidParameter = sessionUidColumn == null ? null : new SqlTypedMappingJdbcParameter(sessionUidColumn);
        SessionFactoryImplementor sessionFactory = this.getSessionFactory();
        MappingMetamodelImplementor domainModel = sessionFactory.getMappingMetamodel();
        EntityPersister entityDescriptor = domainModel.getEntityDescriptor(((SqmRoot)sqmUpdate.getTarget()).getEntityName());
        String rootEntityName = entityDescriptor.getRootEntityName();
        EntityPersister rootEntityDescriptor = domainModel.getEntityDescriptor(rootEntityName);
        String hierarchyRootTableName = rootEntityDescriptor.getTableName();
        MultiTableSqmMutationConverter converterDelegate = new MultiTableSqmMutationConverter(entityDescriptor, (SqmStatement<?>)sqmUpdate, (SqmRoot<?>)sqmUpdate.getTarget(), domainParameterXref, context.getQueryOptions(), context.getSession().getLoadQueryInfluencers(), context.getQueryParameterBindings(), sessionFactory.getSqlTranslationEngine());
        TableGroup updatingTableGroup = converterDelegate.getMutatingTableGroup();
        TableReference hierarchyRootTableReference = updatingTableGroup.resolveTableReference(updatingTableGroup.getNavigablePath(), hierarchyRootTableName);
        assert (hierarchyRootTableReference != null);
        Object assignments = converterDelegate.visitSetClause(sqmUpdate.getSetClause());
        converterDelegate.addVersionedAssignment(((List)assignments)::add, sqmUpdate);
        PredicateCollector predicateCollector = new PredicateCollector(converterDelegate.visitWhereClause(sqmUpdate.getWhereClause()));
        entityDescriptor.applyBaseRestrictions(predicateCollector::applyPredicate, updatingTableGroup, true, context.getSession().getLoadQueryInfluencers().getEnabledFilters(), false, null, converterDelegate);
        converterDelegate.pruneTableGroupJoins();
        HashMap<String, TableReference> tableReferenceByAlias = CollectionHelper.mapOfSize(updatingTableGroup.getTableReferenceJoins().size() + 1);
        this.collectTableReference(updatingTableGroup.getPrimaryTableReference(), tableReferenceByAlias::put);
        for (int i = 0; i < updatingTableGroup.getTableReferenceJoins().size(); ++i) {
            this.collectTableReference(updatingTableGroup.getTableReferenceJoins().get(i), tableReferenceByAlias::put);
        }
        SoftDeleteMapping softDeleteMapping = entityDescriptor.getSoftDeleteMapping();
        if (softDeleteMapping != null) {
            NamedTableReference rootTableReference = (NamedTableReference)updatingTableGroup.resolveTableReference(updatingTableGroup.getNavigablePath(), entityDescriptor.getIdentifierTableDetails().getTableName());
            suppliedPredicate = Predicate.combinePredicates(predicateCollector.getPredicate(), softDeleteMapping.createNonDeletedRestriction(rootTableReference));
        } else {
            suppliedPredicate = predicateCollector.getPredicate();
        }
        HashMap assignmentsByTable = CollectionHelper.mapOfSize(updatingTableGroup.getTableReferenceJoins().size() + 1);
        this.domainParameterXref = domainParameterXref;
        this.jdbcParamsXref = SqmUtil.generateJdbcParamsXref(domainParameterXref, converterDelegate);
        this.resolvedParameterMappingModelTypes = converterDelegate.getSqmParameterMappingModelExpressibleResolutions();
        JdbcParameterBindings jdbcParameterBindings = SqmUtil.createJdbcParameterBindings(context.getQueryParameterBindings(), domainParameterXref, this.jdbcParamsXref, new SqmParameterMappingModelResolutionAccess(){

            @Override
            public <T> MappingModelExpressible<T> getResolvedMappingModelType(SqmParameter<T> parameter) {
                return TableBasedUpdateHandler.this.resolvedParameterMappingModelTypes.get(parameter);
            }
        }, context.getSession());
        if (this.sessionUidParameter != null) {
            jdbcParameterBindings.addBinding(this.sessionUidParameter, new JdbcParameterBindingImpl(idTable.getSessionUidColumn().getJdbcMapping(), UUID.fromString(sessionUidAccess.apply(context.getSession()))));
        }
        for (int i = 0; i < assignments.size(); ++i) {
            Assignment assignment = (Assignment)assignments.get(i);
            List<ColumnReference> assignmentColumnRefs = assignment.getAssignable().getColumnReferences();
            TableReference assignmentTableReference = null;
            for (int c = 0; c < assignmentColumnRefs.size(); ++c) {
                ColumnReference columnReference = assignmentColumnRefs.get(c);
                TableReference tableReference = this.resolveTableReference(columnReference, tableReferenceByAlias);
                if (assignmentTableReference != null && assignmentTableReference != tableReference) {
                    throw new SemanticException("Assignment referred to columns from multiple tables: " + String.valueOf(assignment.getAssignable()));
                }
                assignmentTableReference = tableReference;
            }
            ArrayList<Assignment> assignmentsForTable = (ArrayList<Assignment>)assignmentsByTable.get(assignmentTableReference);
            if (assignmentsForTable == null) {
                assignmentsForTable = new ArrayList<Assignment>();
                assignmentsByTable.put(assignmentTableReference, assignmentsForTable);
            }
            assignmentsForTable.add(assignment);
        }
        SqmJdbcExecutionContextAdapter executionContext = SqmJdbcExecutionContextAdapter.omittingLockingAndPaging(context);
        this.matchingIdsIntoIdTableInsert = ExecuteWithTemporaryTableHelper.createMatchingIdsIntoIdTableInsert(converterDelegate, suppliedPredicate, idTable, this.sessionUidParameter, jdbcParameterBindings, executionContext);
        QuerySpec idTableSubQuery = ExecuteWithTemporaryTableHelper.createIdTableSelectQuerySpec(idTable, this.sessionUidParameter, entityDescriptor, executionContext);
        ArrayList<TableUpdater> tableUpdaters = new ArrayList<TableUpdater>();
        entityDescriptor.visitConstraintOrderedTables((tableExpression, tableKeyColumnVisitationSupplier) -> tableUpdaters.add(this.createTableUpdater(updatingTableGroup, tableExpression, tableKeyColumnVisitationSupplier, assignmentsByTable, idTableSubQuery, jdbcParameterBindings, executionContext)));
        this.tableUpdaters = tableUpdaters;
        firstJdbcParameterBindingsConsumer.set(jdbcParameterBindings);
    }

    @Override
    public JdbcParameterBindings createJdbcParameterBindings(DomainQueryExecutionContext context) {
        JdbcParameterBindings jdbcParameterBindings = SqmUtil.createJdbcParameterBindings(context.getQueryParameterBindings(), this.domainParameterXref, this.jdbcParamsXref, new SqmParameterMappingModelResolutionAccess(){

            @Override
            public <T> MappingModelExpressible<T> getResolvedMappingModelType(SqmParameter<T> parameter) {
                return TableBasedUpdateHandler.this.resolvedParameterMappingModelTypes.get(parameter);
            }
        }, context.getSession());
        if (this.sessionUidParameter != null) {
            jdbcParameterBindings.addBinding(this.sessionUidParameter, new JdbcParameterBindingImpl(this.idTable.getSessionUidColumn().getJdbcMapping(), UUID.fromString(this.sessionUidAccess.apply(context.getSession()))));
        }
        return jdbcParameterBindings;
    }

    @Override
    public boolean dependsOnParameterBindings() {
        if (this.matchingIdsIntoIdTableInsert.jdbcOperation().dependsOnParameterBindings()) {
            return true;
        }
        for (TableUpdater updater : this.tableUpdaters) {
            if (updater.jdbcUpdate.dependsOnParameterBindings()) {
                return true;
            }
            if (updater.jdbcInsert == null || !updater.jdbcInsert.dependsOnParameterBindings()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isCompatibleWith(JdbcParameterBindings jdbcParameterBindings, QueryOptions queryOptions) {
        if (!this.matchingIdsIntoIdTableInsert.jdbcOperation().isCompatibleWith(jdbcParameterBindings, queryOptions)) {
            return false;
        }
        for (TableUpdater updater : this.tableUpdaters) {
            if (!updater.jdbcUpdate.isCompatibleWith(jdbcParameterBindings, queryOptions)) {
                return false;
            }
            if (updater.jdbcInsert == null || updater.jdbcInsert.isCompatibleWith(jdbcParameterBindings, queryOptions)) continue;
            return false;
        }
        return true;
    }

    protected TableReference resolveTableReference(ColumnReference columnReference, Map<String, TableReference> tableReferenceByAlias) {
        TableReference tableReferenceByQualifier = tableReferenceByAlias.get(columnReference.getQualifier());
        if (tableReferenceByQualifier != null) {
            return tableReferenceByQualifier;
        }
        throw new SemanticException("Assignment referred to column of a joined association: " + String.valueOf(columnReference));
    }

    protected NamedTableReference resolveUnionTableReference(TableReference tableReference, String tableExpression) {
        if (tableReference instanceof UnionTableReference) {
            return new NamedTableReference(tableExpression, tableReference.getIdentificationVariable(), tableReference.isOptional());
        }
        return (NamedTableReference)tableReference;
    }

    private TableUpdater createTableUpdater(TableGroup updatingTableGroup, String tableExpression, Supplier<Consumer<SelectableConsumer>> tableKeyColumnVisitationSupplier, Map<TableReference, List<Assignment>> assignmentsByTable, QuerySpec idTableSubQuery, JdbcParameterBindings firstJdbcParameterBindings, ExecutionContext executionContext) {
        TableReference updatingTableReference = updatingTableGroup.getTableReference(updatingTableGroup.getNavigablePath(), tableExpression, true);
        List<Assignment> assignments = assignmentsByTable.get(updatingTableReference);
        if (assignments == null || assignments.isEmpty()) {
            return null;
        }
        NamedTableReference dmlTableReference = this.resolveUnionTableReference(updatingTableReference, tableExpression);
        JdbcServices jdbcServices = executionContext.getSession().getFactory().getJdbcServices();
        SqlAstTranslatorFactory sqlAstTranslatorFactory = jdbcServices.getJdbcEnvironment().getSqlAstTranslatorFactory();
        Expression keyExpression = this.resolveMutatingTableKeyExpression(tableExpression, tableKeyColumnVisitationSupplier);
        return new TableUpdater(this.createTableUpdate(idTableSubQuery, executionContext, assignments, dmlTableReference, sqlAstTranslatorFactory, firstJdbcParameterBindings, keyExpression), this.isTableOptional(tableExpression) ? this.createTableInsert(tableExpression, dmlTableReference, keyExpression, tableKeyColumnVisitationSupplier, idTableSubQuery, assignments, sqlAstTranslatorFactory, firstJdbcParameterBindings, executionContext) : null);
    }

    protected boolean isTableOptional(String tableExpression) {
        EntityPersister entityPersister = this.getEntityDescriptor().getEntityPersister();
        for (int i = 0; i < entityPersister.getTableSpan(); ++i) {
            if (!tableExpression.equals(entityPersister.getTableName(i)) || !entityPersister.isNullableTable(i)) continue;
            return true;
        }
        return false;
    }

    private JdbcOperationQueryMutation createTableInsert(String targetTableExpression, NamedTableReference targetTableReference, Expression targetTableKeyExpression, Supplier<Consumer<SelectableConsumer>> tableKeyColumnVisitationSupplier, QuerySpec idTableSubQuery, List<Assignment> assignments, SqlAstTranslatorFactory sqlAstTranslatorFactory, JdbcParameterBindings firstJdbcParameterBindings, ExecutionContext executionContext) {
        SessionFactoryImplementor sessionFactory = executionContext.getSession().getFactory();
        QuerySpec insertSourceSelectQuerySpec = TableBasedUpdateHandler.makeInsertSourceSelectQuerySpec(idTableSubQuery);
        QuerySpec existsSubQuerySpec = this.createExistsSubQuerySpec(targetTableExpression, tableKeyColumnVisitationSupplier, idTableSubQuery, sessionFactory);
        insertSourceSelectQuerySpec.applyPredicate(new ExistsPredicate(existsSubQuerySpec, true, sessionFactory.getTypeConfiguration().getBasicTypeForJavaType(Boolean.class)));
        ArrayList<? extends Expression> targetColumnReferences = new ArrayList<Expression>();
        if (targetTableKeyExpression instanceof SqlTuple) {
            targetColumnReferences.addAll(((SqlTuple)targetTableKeyExpression).getExpressions());
        } else {
            targetColumnReferences.add((ColumnReference)targetTableKeyExpression);
        }
        for (Assignment assignment : assignments) {
            targetColumnReferences.addAll(assignment.getAssignable().getColumnReferences());
            insertSourceSelectQuerySpec.getSelectClause().addSqlSelection(new SqlSelectionImpl(assignment.getAssignedValue()));
        }
        InsertSelectStatement insertSqlAst = new InsertSelectStatement(targetTableReference);
        insertSqlAst.addTargetColumnReferences(targetColumnReferences.toArray(new ColumnReference[0]));
        insertSqlAst.setSourceSelectStatement(insertSourceSelectQuerySpec);
        return sqlAstTranslatorFactory.buildMutationTranslator(sessionFactory, insertSqlAst).translate(firstJdbcParameterBindings, executionContext.getQueryOptions());
    }

    protected QuerySpec createExistsSubQuerySpec(String targetTableExpression, Supplier<Consumer<SelectableConsumer>> tableKeyColumnVisitationSupplier, QuerySpec idTableSubQuery, SessionFactoryImplementor sessionFactory) {
        NamedTableReference existsTableReference = new NamedTableReference(targetTableExpression, "dml_");
        QuerySpec existsSubQuerySpec = new QuerySpec(false);
        existsSubQuerySpec.getSelectClause().addSqlSelection(new SqlSelectionImpl(new QueryLiteral<Integer>(1, sessionFactory.getTypeConfiguration().getBasicTypeForJavaType(Integer.class))));
        existsSubQuerySpec.getFromClause().addRoot(new TableGroupImpl(null, null, existsTableReference, this.getEntityDescriptor()));
        TableKeyExpressionCollector existsKeyColumnCollector = new TableKeyExpressionCollector(this.getEntityDescriptor());
        tableKeyColumnVisitationSupplier.get().accept((columnIndex, selection) -> {
            assert (selection.getContainingTableExpression().equals(targetTableExpression));
            existsKeyColumnCollector.apply(new ColumnReference(existsTableReference, selection));
        });
        existsSubQuerySpec.applyPredicate(new ComparisonPredicate(existsKeyColumnCollector.buildKeyExpression(), ComparisonOperator.EQUAL, this.asExpression(idTableSubQuery.getSelectClause())));
        return existsSubQuerySpec;
    }

    protected static QuerySpec makeInsertSourceSelectQuerySpec(QuerySpec idTableSubQuery) {
        QuerySpec idTableQuerySpec = new QuerySpec(true);
        for (TableGroup root : idTableSubQuery.getFromClause().getRoots()) {
            idTableQuerySpec.getFromClause().addRoot(root);
        }
        for (SqlSelection sqlSelection : idTableSubQuery.getSelectClause().getSqlSelections()) {
            idTableQuerySpec.getSelectClause().addSqlSelection(sqlSelection);
        }
        idTableQuerySpec.applyPredicate(idTableSubQuery.getWhereClauseRestrictions());
        return idTableQuerySpec;
    }

    private JdbcOperationQueryMutation createTableUpdate(QuerySpec idTableSubQuery, ExecutionContext executionContext, List<Assignment> assignments, NamedTableReference dmlTableReference, SqlAstTranslatorFactory sqlAstTranslatorFactory, JdbcParameterBindings firstJdbcParameterBindings, Expression keyExpression) {
        UpdateStatement sqlAst = new UpdateStatement(dmlTableReference, assignments, (Predicate)new InSubQueryPredicate(keyExpression, idTableSubQuery, false));
        return sqlAstTranslatorFactory.buildMutationTranslator(executionContext.getSession().getFactory(), sqlAst).translate(firstJdbcParameterBindings, executionContext.getQueryOptions());
    }

    protected Expression resolveMutatingTableKeyExpression(String tableExpression, Supplier<Consumer<SelectableConsumer>> tableKeyColumnVisitationSupplier) {
        TableKeyExpressionCollector keyColumnCollector = new TableKeyExpressionCollector(this.getEntityDescriptor());
        tableKeyColumnVisitationSupplier.get().accept((columnIndex, selection) -> {
            assert (selection.getContainingTableExpression().equals(tableExpression));
            keyColumnCollector.apply(new ColumnReference((String)null, selection));
        });
        return keyColumnCollector.buildKeyExpression();
    }

    protected Expression asExpression(SelectClause selectClause) {
        List<SqlSelection> sqlSelections = selectClause.getSqlSelections();
        if (sqlSelections.size() == 1) {
            return sqlSelections.get(0).getExpression();
        }
        ArrayList<Expression> expressions = new ArrayList<Expression>(sqlSelections.size());
        for (SqlSelection sqlSelection : sqlSelections) {
            expressions.add(sqlSelection.getExpression());
        }
        return new SqlTuple(expressions, null);
    }

    protected void collectTableReference(TableReference tableReference, BiConsumer<String, TableReference> consumer) {
        consumer.accept(tableReference.getIdentificationVariable(), tableReference);
    }

    protected void collectTableReference(TableReferenceJoin tableReferenceJoin, BiConsumer<String, TableReference> consumer) {
        this.collectTableReference(tableReferenceJoin.getJoinedTableReference(), consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int execute(JdbcParameterBindings jdbcParameterBindings, DomainQueryExecutionContext context) {
        if (log.isTraceEnabled()) {
            log.tracef("Starting multi-table update execution - %s", (Object)((SqmRoot)this.getSqmStatement().getTarget()).getModel().getName());
        }
        SqmJdbcExecutionContextAdapter executionContext = SqmJdbcExecutionContextAdapter.omittingLockingAndPaging(context);
        ExecuteWithTemporaryTableHelper.performBeforeTemporaryTableUseActions(this.idTable, this.temporaryTableStrategy, (ExecutionContext)executionContext);
        try {
            int rows = ExecuteWithTemporaryTableHelper.saveIntoTemporaryTable(this.matchingIdsIntoIdTableInsert.jdbcOperation(), jdbcParameterBindings, (ExecutionContext)executionContext);
            for (TableUpdater tableUpdater : this.tableUpdaters) {
                this.updateTable(tableUpdater, rows, jdbcParameterBindings, executionContext);
            }
            int n = rows;
            return n;
        }
        finally {
            ExecuteWithTemporaryTableHelper.performAfterTemporaryTableUseActions(this.idTable, this.sessionUidAccess, this.getAfterUseAction(), executionContext);
        }
    }

    private void updateTable(TableUpdater tableUpdater, int expectedUpdateCount, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext) {
        if (tableUpdater == null) {
            return;
        }
        int updateCount = this.executeMutation(tableUpdater.jdbcUpdate, jdbcParameterBindings, executionContext);
        if (updateCount == expectedUpdateCount) {
            return;
        }
        if (tableUpdater.jdbcInsert != null) {
            int insertCount = this.executeMutation(tableUpdater.jdbcInsert, jdbcParameterBindings, executionContext);
            assert (insertCount + updateCount == expectedUpdateCount);
        }
    }

    private int executeMutation(JdbcOperationQueryMutation jdbcUpdate, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext) {
        return executionContext.getSession().getFactory().getJdbcServices().getJdbcMutationExecutor().execute(jdbcUpdate, jdbcParameterBindings, sql -> executionContext.getSession().getJdbcCoordinator().getStatementPreparer().prepareStatement((String)sql), (integer, preparedStatement) -> {}, executionContext);
    }

    protected List<TableUpdater> getTableUpdaters() {
        return this.tableUpdaters;
    }

    protected AfterUseAction getAfterUseAction() {
        return this.forceDropAfterUse ? AfterUseAction.DROP : this.temporaryTableStrategy.getTemporaryTableAfterUseAction();
    }

    protected TemporaryTable getIdTable() {
        return this.idTable;
    }

    protected TemporaryTableStrategy getTemporaryTableStrategy() {
        return this.temporaryTableStrategy;
    }

    protected CacheableSqmInterpretation<InsertSelectStatement, JdbcOperationQueryMutation> getMatchingIdsIntoIdTableInsert() {
        return this.matchingIdsIntoIdTableInsert;
    }

    protected Function<SharedSessionContractImplementor, String> getSessionUidAccess() {
        return this.sessionUidAccess;
    }

    protected @Nullable JdbcParameter getSessionUidParameter() {
        return this.sessionUidParameter;
    }

    protected record TableUpdater(JdbcOperationQueryMutation jdbcUpdate, @Nullable JdbcOperationQueryMutation jdbcInsert) {
    }
}

