/*
 * Decompiled with CFR 0.152.
 */
package com.github.lgooddatepicker.tableeditors;

import com.github.lgooddatepicker.components.DatePickerSettings;
import com.github.lgooddatepicker.components.DateTimePicker;
import com.github.lgooddatepicker.components.TimePickerSettings;
import com.github.lgooddatepicker.zinternaltools.InternalUtilities;
import com.privatejgoodies.forms.layout.ConstantSize;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.time.LocalDateTime;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class DateTimeTableEditor
extends AbstractCellEditor
implements TableCellEditor,
TableCellRenderer {
    private boolean autoAdjustMinimumTableRowHeight = true;
    public int clickCountToEdit = 1;
    private boolean matchTableBackgroundColor = true;
    private boolean matchTableSelectionBackgroundColor = true;
    private Border borderFocusedCell;
    private Border borderUnfocusedCell;
    private DateTimePicker dateTimePicker;
    private int minimumRowHeightInPixels;

    public DateTimeTableEditor() {
        this(true, true, true);
    }

    public DateTimeTableEditor(boolean autoAdjustMinimumTableRowHeight, boolean matchTableBackgroundColor, boolean matchTableSelectionBackgroundColor) {
        this.autoAdjustMinimumTableRowHeight = autoAdjustMinimumTableRowHeight;
        this.matchTableBackgroundColor = matchTableBackgroundColor;
        this.matchTableSelectionBackgroundColor = matchTableSelectionBackgroundColor;
        JLabel exampleDefaultRenderer = (JLabel)new DefaultTableCellRenderer().getTableCellRendererComponent(new JTable(), "", true, true, 0, 0);
        this.borderFocusedCell = exampleDefaultRenderer.getBorder();
        this.borderUnfocusedCell = new EmptyBorder(1, 1, 1, 1);
        this.dateTimePicker = new DateTimePicker();
        this.dateTimePicker.timePicker.setEnableArrowKeys(false);
        this.dateTimePicker.setBorder(this.borderUnfocusedCell);
        this.dateTimePicker.setGapSize(2, ConstantSize.PIXEL);
        this.dateTimePicker.setBackground(Color.white);
        this.dateTimePicker.datePicker.setBackground(Color.white);
        this.dateTimePicker.timePicker.setBackground(Color.white);
        this.dateTimePicker.datePicker.getComponentDateTextField().setBorder(null);
        this.dateTimePicker.timePicker.getComponentTimeTextField().setBorder(null);
        DatePickerSettings dateSettings = this.dateTimePicker.datePicker.getSettings();
        dateSettings.setGapBeforeButtonPixels(0);
        dateSettings.setSizeTextFieldMinimumWidthDefaultOverride(false);
        dateSettings.setSizeTextFieldMinimumWidth(20);
        TimePickerSettings timeSettings = this.dateTimePicker.timePicker.getSettings();
        timeSettings.setGapBeforeButtonPixels(0);
        timeSettings.setSizeTextFieldMinimumWidthDefaultOverride(false);
        timeSettings.setSizeTextFieldMinimumWidth(20);
        this.minimumRowHeightInPixels = this.dateTimePicker.getPreferredSize().height + 1;
    }

    @Override
    public Object getCellEditorValue() {
        return this.dateTimePicker.getDateTimePermissive();
    }

    public DateTimePicker getDateTimePicker() {
        return this.dateTimePicker;
    }

    public DatePickerSettings getDatePickerSettings() {
        return this.dateTimePicker.datePicker.getSettings();
    }

    public TimePickerSettings getTimePickerSettings() {
        return this.dateTimePicker.timePicker.getSettings();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.setCellEditorValue(value);
        this.zAdjustTableRowHeightIfNeeded(table);
        this.dateTimePicker.datePicker.getComponentDateTextField().setScrollOffset(0);
        this.dateTimePicker.timePicker.getComponentTimeTextField().setScrollOffset(0);
        return this.dateTimePicker;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setCellEditorValue(value);
        if (isSelected) {
            if (this.matchTableSelectionBackgroundColor) {
                Color selectionBackground = table.getSelectionBackground();
                this.dateTimePicker.setBackground(selectionBackground);
                this.dateTimePicker.datePicker.setBackground(selectionBackground);
                this.dateTimePicker.timePicker.setBackground(selectionBackground);
                this.dateTimePicker.datePicker.getComponentDateTextField().setBackground(selectionBackground);
                this.dateTimePicker.timePicker.getComponentTimeTextField().setBackground(selectionBackground);
            } else {
                this.dateTimePicker.datePicker.zDrawTextFieldIndicators();
                this.dateTimePicker.timePicker.zDrawTextFieldIndicators();
            }
        }
        if (!isSelected) {
            if (this.matchTableBackgroundColor) {
                Color tableBackground = table.getBackground();
                this.dateTimePicker.setBackground(tableBackground);
                this.dateTimePicker.datePicker.setBackground(tableBackground);
                this.dateTimePicker.timePicker.setBackground(tableBackground);
                this.dateTimePicker.datePicker.getComponentDateTextField().setBackground(tableBackground);
                this.dateTimePicker.timePicker.getComponentTimeTextField().setBackground(tableBackground);
            } else {
                this.dateTimePicker.datePicker.zDrawTextFieldIndicators();
                this.dateTimePicker.timePicker.zDrawTextFieldIndicators();
            }
        }
        if (hasFocus) {
            this.dateTimePicker.setBorder(this.borderFocusedCell);
        } else {
            this.dateTimePicker.setBorder(this.borderUnfocusedCell);
        }
        this.zAdjustTableRowHeightIfNeeded(table);
        this.dateTimePicker.datePicker.getComponentDateTextField().setScrollOffset(0);
        this.dateTimePicker.timePicker.getComponentTimeTextField().setScrollOffset(0);
        return this.dateTimePicker;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        if (anEvent instanceof MouseEvent) {
            return ((MouseEvent)anEvent).getClickCount() >= this.clickCountToEdit;
        }
        return true;
    }

    public void setCellEditorValue(Object value) {
        this.dateTimePicker.clear();
        if (value == null) {
            return;
        }
        if (value instanceof LocalDateTime) {
            LocalDateTime nativeValue = (LocalDateTime)value;
            this.dateTimePicker.setDateTimePermissive(nativeValue);
        } else {
            String text = value.toString();
            String shorterText = InternalUtilities.safeSubstring(text, 0, 100);
            this.dateTimePicker.datePicker.setText(shorterText);
        }
    }

    private void zAdjustTableRowHeightIfNeeded(JTable table) {
        if (!this.autoAdjustMinimumTableRowHeight) {
            return;
        }
        if (table.getRowHeight() < this.minimumRowHeightInPixels) {
            table.setRowHeight(this.minimumRowHeightInPixels);
        }
    }
}

