/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.bookmark.renderer;

import java.awt.Color;
import java.awt.Component;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import javax.swing.JTable;
import mediathek.gui.bookmark.renderer.CenteredCellRenderer;
import mediathek.tool.datum.DateUtil;
import org.jetbrains.annotations.NotNull;

public class AvailableUntilCellRenderer
extends CenteredCellRenderer {
    private static final long DAYS_UNTIL_END = 5L;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        LocalDate date = (LocalDate)value;
        if (date != null) {
            if (!this.entryHasExpired(date)) {
                this.setTextForeground(table, isSelected);
            }
            this.setText(date.format(DateUtil.FORMATTER));
        }
        return this;
    }

    private boolean entryHasExpired(LocalDate date) {
        boolean result2 = false;
        LocalDate today = LocalDate.now();
        if (date.isBefore(today)) {
            this.setForeground(Color.red);
            result2 = true;
        } else if (Math.abs(ChronoUnit.DAYS.between(today, date)) < 5L) {
            this.setForeground(Color.orange);
            result2 = true;
        }
        return result2;
    }

    private void setTextForeground(@NotNull JTable table, boolean isSelected) {
        if (isSelected) {
            this.setForeground(table.getSelectionForeground());
        } else {
            this.setForeground(table.getForeground());
        }
    }
}

