/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IntroSelector;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.lease.Releasables;
import org.opensearch.common.util.IntArray;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.BucketOrder;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.InternalMultiBucketAggregation;
import org.opensearch.search.aggregations.InternalOrder;
import org.opensearch.search.aggregations.LeafBucketCollector;
import org.opensearch.search.aggregations.LeafBucketCollectorBase;
import org.opensearch.search.aggregations.bucket.LocalBucketCountThresholds;
import org.opensearch.search.aggregations.bucket.terms.AbstractStringTermsAggregator;
import org.opensearch.search.aggregations.bucket.terms.StringTerms;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregator;
import org.opensearch.search.aggregations.support.ValuesSource;
import org.opensearch.search.internal.SearchContext;

public class StreamStringTermsAggregator
extends AbstractStringTermsAggregator {
    private static final Logger logger = LogManager.getLogger(StreamStringTermsAggregator.class);
    private SortedSetDocValues sortedDocValuesPerBatch;
    private long valueCount;
    private final ValuesSource.Bytes.WithOrdinals valuesSource;
    protected int segmentsWithSingleValuedOrds = 0;
    protected int segmentsWithMultiValuedOrds = 0;
    protected final ResultStrategy<?, ?> resultStrategy;
    private boolean leafCollectorCreated = false;
    private final int segmentTopN;
    private Aggregator.BucketComparator ordinalComparator;
    private StringTerms.Bucket tempBucket1;
    private StringTerms.Bucket tempBucket2;

    public StreamStringTermsAggregator(String name, AggregatorFactories factories, Function<StreamStringTermsAggregator, ResultStrategy<?, ?>> resultStrategy, ValuesSource.Bytes.WithOrdinals valuesSource, BucketOrder order, DocValueFormat format, TermsAggregator.BucketCountThresholds bucketCountThresholds, SearchContext context, Aggregator parent, Aggregator.SubAggCollectionMode collectionMode, boolean showTermDocCountError, int segmentTopN, Map<String, Object> metadata) throws IOException {
        super(name, factories, context, parent, order, format, bucketCountThresholds, collectionMode, showTermDocCountError, metadata);
        this.valuesSource = valuesSource;
        this.resultStrategy = resultStrategy.apply(this);
        this.segmentTopN = segmentTopN;
    }

    @Override
    public void doReset() {
        super.doReset();
        this.valueCount = 0L;
        this.sortedDocValuesPerBatch = null;
        this.leafCollectorCreated = false;
        this.ordinalComparator = null;
        this.tempBucket1 = null;
        this.tempBucket2 = null;
    }

    private void ensureOrdinalComparator() {
        if (this.ordinalComparator == null) {
            if (InternalOrder.isKeyOrder(this.order)) {
                boolean ascending = InternalOrder.isKeyAsc(this.order);
                this.ordinalComparator = (leftOrd, rightOrd) -> ascending ? Long.compare(leftOrd, rightOrd) : Long.compare(rightOrd, leftOrd);
            } else if (this.partiallyBuiltBucketComparator != null) {
                this.tempBucket1 = new StringTerms.Bucket(this, null, 0L, null, false, 0L, this.format){

                    @Override
                    public int compareKey(StringTerms.Bucket other) {
                        return Long.compare(this.bucketOrd, other.bucketOrd);
                    }
                };
                this.tempBucket2 = new StringTerms.Bucket(this, null, 0L, null, false, 0L, this.format){

                    @Override
                    public int compareKey(StringTerms.Bucket other) {
                        return Long.compare(this.bucketOrd, other.bucketOrd);
                    }
                };
                this.ordinalComparator = (leftOrd, rightOrd) -> {
                    this.tempBucket1.bucketOrd = leftOrd;
                    this.tempBucket1.docCount = this.bucketDocCount(leftOrd);
                    this.tempBucket2.bucketOrd = rightOrd;
                    this.tempBucket2.docCount = this.bucketDocCount(rightOrd);
                    return this.partiallyBuiltBucketComparator.compare(this.tempBucket1, this.tempBucket2);
                };
            }
        }
    }

    @Override
    public InternalAggregation[] buildAggregations(long[] owningBucketOrds) throws IOException {
        return this.resultStrategy.buildAggregationsBatch(owningBucketOrds);
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return this.resultStrategy.buildEmptyResult();
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
        if (this.leafCollectorCreated) {
            throw new IllegalStateException("Calling " + StreamStringTermsAggregator.class.getSimpleName() + " for the second segment: " + String.valueOf(ctx));
        }
        this.leafCollectorCreated = true;
        this.sortedDocValuesPerBatch = this.valuesSource.ordinalsValues(ctx);
        this.valueCount = this.sortedDocValuesPerBatch.getValueCount();
        this.docCounts = this.docCounts == null ? this.context.bigArrays().newLongArray(this.valueCount, true) : this.context.bigArrays().grow(this.docCounts, this.valueCount);
        final SortedDocValues singleValues = DocValues.unwrapSingleton((SortedSetDocValues)this.sortedDocValuesPerBatch);
        if (singleValues != null) {
            ++this.segmentsWithSingleValuedOrds;
            return this.resultStrategy.wrapCollector(new LeafBucketCollectorBase(sub, this.sortedDocValuesPerBatch){

                @Override
                public void collect(int doc, long owningBucketOrd) throws IOException {
                    if (!singleValues.advanceExact(doc)) {
                        return;
                    }
                    int ordinal = singleValues.ordValue();
                    StreamStringTermsAggregator.this.collectExistingBucket(sub, doc, ordinal);
                }
            });
        }
        ++this.segmentsWithMultiValuedOrds;
        return this.resultStrategy.wrapCollector(new LeafBucketCollectorBase(sub, this.sortedDocValuesPerBatch){

            @Override
            public void collect(int doc, long owningBucketOrd) throws IOException {
                long ordinal;
                if (!StreamStringTermsAggregator.this.sortedDocValuesPerBatch.advanceExact(doc)) {
                    return;
                }
                int count = StreamStringTermsAggregator.this.sortedDocValuesPerBatch.docValueCount();
                while (count-- > 0 && (ordinal = StreamStringTermsAggregator.this.sortedDocValuesPerBatch.nextOrd()) != Integer.MAX_VALUE) {
                    StreamStringTermsAggregator.this.collectExistingBucket(sub, doc, ordinal);
                }
            }
        });
    }

    @Override
    public void collectDebugInfo(BiConsumer<String, Object> add) {
        super.collectDebugInfo(add);
        add.accept("result_strategy", this.resultStrategy.describe());
        add.accept("segments_with_single_valued_ords", this.segmentsWithSingleValuedOrds);
        add.accept("segments_with_multi_valued_ords", this.segmentsWithMultiValuedOrds);
    }

    @Override
    public void doClose() {
        Releasables.close(this.resultStrategy);
    }

    public abstract class ResultStrategy<R extends InternalAggregation, B extends InternalMultiBucketAggregation.InternalBucket>
    implements Releasable {
        protected IntArray reusableIndices;

        protected ResultStrategy() {
        }

        void prepareIndicesArray(long valueCount) {
            this.reusableIndices = this.reusableIndices == null ? StreamStringTermsAggregator.this.context.bigArrays().newIntArray(valueCount, false) : StreamStringTermsAggregator.this.context.bigArrays().grow(this.reusableIndices, valueCount);
        }

        InternalAggregation[] buildAggregationsBatch(long[] owningBucketOrds) throws IOException {
            LocalBucketCountThresholds localBucketCountThresholds = StreamStringTermsAggregator.this.context.asLocalBucketCountThresholds(StreamStringTermsAggregator.this.bucketCountThresholds);
            if (StreamStringTermsAggregator.this.valueCount == 0L) {
                InternalAggregation[] results = new InternalAggregation[owningBucketOrds.length];
                for (int ordIdx = 0; ordIdx < owningBucketOrds.length; ++ordIdx) {
                    results[ordIdx] = this.buildNoValuesResult(owningBucketOrds[ordIdx]);
                }
                return results;
            }
            InternalMultiBucketAggregation.InternalBucket[][] topBucketsPerOwningOrd = this.buildTopBucketsPerOrd(owningBucketOrds.length);
            long[] otherDocCount = new long[owningBucketOrds.length];
            for (int ordIdx = 0; ordIdx < owningBucketOrds.length; ++ordIdx) {
                StreamStringTermsAggregator.this.checkCancelled();
                logger.debug("Cardinality post collection for ordIdx {}: {}", (Object)ordIdx, (Object)StreamStringTermsAggregator.this.valueCount);
                SelectionResult<B> selectionResult = this.selectTopBuckets(StreamStringTermsAggregator.this.segmentTopN, StreamStringTermsAggregator.this.bucketCountThresholds);
                topBucketsPerOwningOrd[ordIdx] = this.buildBuckets(selectionResult.buckets.size());
                for (int i = 0; i < topBucketsPerOwningOrd[ordIdx].length; ++i) {
                    topBucketsPerOwningOrd[ordIdx][i] = (InternalMultiBucketAggregation.InternalBucket)selectionResult.buckets.get(i);
                }
                otherDocCount[ordIdx] = selectionResult.otherDocCount;
            }
            this.buildSubAggs(topBucketsPerOwningOrd);
            InternalAggregation[] results = new InternalAggregation[owningBucketOrds.length];
            for (int ordIdx = 0; ordIdx < owningBucketOrds.length; ++ordIdx) {
                results[ordIdx] = this.buildResult(owningBucketOrds[ordIdx], otherDocCount[ordIdx], topBucketsPerOwningOrd[ordIdx]);
            }
            return results;
        }

        private SelectionResult<B> selectTopBuckets(int segmentSize, TermsAggregator.BucketCountThresholds thresholds) throws IOException {
            int i;
            this.prepareIndicesArray(StreamStringTermsAggregator.this.valueCount);
            int cnt = 0;
            long totalDocCount = 0L;
            int i2 = 0;
            while ((long)i2 < StreamStringTermsAggregator.this.valueCount) {
                long docCount = StreamStringTermsAggregator.this.bucketDocCount(i2);
                totalDocCount += docCount;
                if (docCount >= thresholds.getMinDocCount()) {
                    this.reusableIndices.set(cnt++, i2);
                }
                ++i2;
            }
            if (cnt <= (segmentSize = Math.min(segmentSize, cnt))) {
                ArrayList<B> result = new ArrayList<B>();
                long selectedDocCount = 0L;
                for (int i3 = 0; i3 < cnt; ++i3) {
                    long docCount = StreamStringTermsAggregator.this.bucketDocCount(this.reusableIndices.get(i3));
                    result.add(this.buildFinalBucket(this.reusableIndices.get(i3), docCount));
                    selectedDocCount += docCount;
                }
                return new SelectionResult(result, totalDocCount - selectedDocCount);
            }
            IntroSelector selector = new IntroSelector(){
                int pivotOrdinal;

                protected void swap(int i, int j) {
                    int temp = ResultStrategy.this.reusableIndices.get(i);
                    ResultStrategy.this.reusableIndices.set(i, ResultStrategy.this.reusableIndices.get(j));
                    ResultStrategy.this.reusableIndices.set(j, temp);
                }

                protected void setPivot(int i) {
                    this.pivotOrdinal = ResultStrategy.this.reusableIndices.get(i);
                }

                protected int comparePivot(int j) {
                    long leftOrd = ResultStrategy.this.reusableIndices.get(j);
                    long rightOrd = this.pivotOrdinal;
                    if (StreamStringTermsAggregator.this.ordinalComparator != null) {
                        return -StreamStringTermsAggregator.this.ordinalComparator.compare(leftOrd, rightOrd);
                    }
                    long leftDocCount = StreamStringTermsAggregator.this.bucketDocCount(leftOrd);
                    long rightDocCount = StreamStringTermsAggregator.this.bucketDocCount(rightOrd);
                    return Long.compare(leftDocCount, rightDocCount);
                }
            };
            StreamStringTermsAggregator.this.ensureOrdinalComparator();
            selector.select(0, cnt, segmentSize);
            int[] selected = new int[segmentSize];
            for (i = 0; i < segmentSize; ++i) {
                selected[i] = this.reusableIndices.get(i);
            }
            this.reusableIndices.fill(0L, StreamStringTermsAggregator.this.valueCount, 0);
            for (i = 0; i < segmentSize; ++i) {
                this.reusableIndices.set(selected[i], 1);
            }
            ArrayList<B> result = new ArrayList<B>(segmentSize);
            long selectedDocCount = 0L;
            int ordinal = 0;
            while ((long)ordinal < StreamStringTermsAggregator.this.valueCount) {
                if (this.reusableIndices.get(ordinal) == 1) {
                    long docCount = StreamStringTermsAggregator.this.bucketDocCount(ordinal);
                    result.add(this.buildFinalBucket(ordinal, docCount));
                    selectedDocCount += docCount;
                }
                ++ordinal;
            }
            return new SelectionResult(result, totalDocCount - selectedDocCount);
        }

        public void close() {
            Releasables.close((Releasable)this.reusableIndices);
            this.reusableIndices = null;
        }

        abstract String describe();

        abstract LeafBucketCollector wrapCollector(LeafBucketCollector var1);

        abstract B[][] buildTopBucketsPerOrd(int var1);

        abstract B[] buildBuckets(int var1);

        abstract void buildSubAggs(B[][] var1) throws IOException;

        abstract R buildResult(long var1, long var3, B[] var5);

        abstract R buildEmptyResult();

        abstract R buildNoValuesResult(long var1);

        abstract B buildFinalBucket(long var1, long var3) throws IOException;

        private static class SelectionResult<B> {
            final List<B> buckets;
            final long otherDocCount;

            SelectionResult(List<B> buckets, long otherDocCount) {
                this.buckets = buckets;
                this.otherDocCount = otherDocCount;
            }
        }
    }

    public class StandardTermsResults
    extends ResultStrategy<StringTerms, StringTerms.Bucket> {
        @Override
        String describe() {
            return "streaming_terms";
        }

        @Override
        LeafBucketCollector wrapCollector(LeafBucketCollector primary) {
            return primary;
        }

        StringTerms.Bucket[][] buildTopBucketsPerOrd(int size) {
            return new StringTerms.Bucket[size][];
        }

        StringTerms.Bucket[] buildBuckets(int size) {
            return new StringTerms.Bucket[size];
        }

        void buildSubAggs(StringTerms.Bucket[][] topBucketsPerOrd) throws IOException {
            StreamStringTermsAggregator.this.buildSubAggsForAllBuckets(topBucketsPerOrd, b -> b.bucketOrd, (b, aggs) -> {
                b.aggregations = aggs;
            });
        }

        StringTerms buildResult(long owningBucketOrd, long otherDocCount, StringTerms.Bucket[] topBuckets) {
            BucketOrder reduceOrder;
            if (!InternalOrder.isKeyOrder(StreamStringTermsAggregator.this.order)) {
                reduceOrder = InternalOrder.key(true);
                Arrays.sort(topBuckets, reduceOrder.comparator());
            } else {
                reduceOrder = StreamStringTermsAggregator.this.order;
            }
            return new StringTerms(StreamStringTermsAggregator.this.name, reduceOrder, StreamStringTermsAggregator.this.order, StreamStringTermsAggregator.this.metadata(), StreamStringTermsAggregator.this.format, StreamStringTermsAggregator.this.bucketCountThresholds.getShardSize(), StreamStringTermsAggregator.this.showTermDocCountError, otherDocCount, Arrays.asList(topBuckets), 0L, StreamStringTermsAggregator.this.bucketCountThresholds);
        }

        @Override
        StringTerms buildEmptyResult() {
            return StreamStringTermsAggregator.this.buildEmptyTermsAggregation();
        }

        @Override
        StringTerms buildNoValuesResult(long owningBucketOrdinal) {
            return this.buildEmptyResult();
        }

        @Override
        StringTerms.Bucket buildFinalBucket(long ordinal, long docCount) throws IOException {
            BytesRef term = BytesRef.deepCopyOf((BytesRef)StreamStringTermsAggregator.this.sortedDocValuesPerBatch.lookupOrd(ordinal));
            StringTerms.Bucket result = new StringTerms.Bucket(term, docCount, null, StreamStringTermsAggregator.this.showTermDocCountError, 0L, StreamStringTermsAggregator.this.format);
            result.bucketOrd = ordinal;
            result.setDocCountError(0L);
            return result;
        }
    }
}

