/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.transport.contextmanagement;

import java.io.IOException;
import lombok.Generated;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.ml.common.contextmanager.ContextManagementTemplate;

public class MLCreateContextManagementTemplateRequest
extends ActionRequest {
    private final String templateName;
    private final ContextManagementTemplate template;

    public MLCreateContextManagementTemplateRequest(String templateName, ContextManagementTemplate template) {
        this.templateName = templateName;
        this.template = template;
    }

    public MLCreateContextManagementTemplateRequest(StreamInput in) throws IOException {
        super(in);
        this.templateName = in.readString();
        this.template = new ContextManagementTemplate(in);
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException exception = null;
        if (this.templateName == null || this.templateName.trim().isEmpty()) {
            exception = ValidateActions.addValidationError((String)"Template name cannot be null or empty", exception);
        }
        if (this.template == null) {
            exception = ValidateActions.addValidationError((String)"Context management template cannot be null", (ActionRequestValidationException)exception);
        } else {
            if (this.template.getName() == null || this.template.getName().trim().isEmpty()) {
                exception = ValidateActions.addValidationError((String)"Template name in body cannot be null or empty", (ActionRequestValidationException)exception);
            }
            if (this.template.getHooks() == null || this.template.getHooks().isEmpty()) {
                exception = ValidateActions.addValidationError((String)"Template must define at least one hook", (ActionRequestValidationException)exception);
            }
        }
        return exception;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.templateName);
        this.template.writeTo(out);
    }

    /*
     * Exception decompiling
     */
    public static MLCreateContextManagementTemplateRequest fromActionRequest(ActionRequest actionRequest) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Generated
    public static MLCreateContextManagementTemplateRequestBuilder builder() {
        return new MLCreateContextManagementTemplateRequestBuilder();
    }

    @Generated
    public String getTemplateName() {
        return this.templateName;
    }

    @Generated
    public ContextManagementTemplate getTemplate() {
        return this.template;
    }

    @Generated
    public String toString() {
        return "MLCreateContextManagementTemplateRequest(templateName=" + this.getTemplateName() + ", template=" + String.valueOf(this.getTemplate()) + ")";
    }

    @Generated
    public static class MLCreateContextManagementTemplateRequestBuilder {
        @Generated
        private String templateName;
        @Generated
        private ContextManagementTemplate template;

        @Generated
        MLCreateContextManagementTemplateRequestBuilder() {
        }

        @Generated
        public MLCreateContextManagementTemplateRequestBuilder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        @Generated
        public MLCreateContextManagementTemplateRequestBuilder template(ContextManagementTemplate template) {
            this.template = template;
            return this;
        }

        @Generated
        public MLCreateContextManagementTemplateRequest build() {
            return new MLCreateContextManagementTemplateRequest(this.templateName, this.template);
        }

        @Generated
        public String toString() {
            return "MLCreateContextManagementTemplateRequest.MLCreateContextManagementTemplateRequestBuilder(templateName=" + this.templateName + ", template=" + String.valueOf(this.template) + ")";
        }
    }
}

