/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.model;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import software.amazon.cryptography.materialproviders.model.AlgorithmSuiteId;

public class InitializeDecryptionMaterialsInput {
    private final AlgorithmSuiteId algorithmSuiteId;
    private final Map<String, String> encryptionContext;
    private final List<String> requiredEncryptionContextKeys;

    protected InitializeDecryptionMaterialsInput(BuilderImpl builder) {
        this.algorithmSuiteId = builder.algorithmSuiteId();
        this.encryptionContext = builder.encryptionContext();
        this.requiredEncryptionContextKeys = builder.requiredEncryptionContextKeys();
    }

    public AlgorithmSuiteId algorithmSuiteId() {
        return this.algorithmSuiteId;
    }

    public Map<String, String> encryptionContext() {
        return this.encryptionContext;
    }

    public List<String> requiredEncryptionContextKeys() {
        return this.requiredEncryptionContextKeys;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected AlgorithmSuiteId algorithmSuiteId;
        protected Map<String, String> encryptionContext;
        protected List<String> requiredEncryptionContextKeys;

        protected BuilderImpl() {
        }

        protected BuilderImpl(InitializeDecryptionMaterialsInput model) {
            this.algorithmSuiteId = model.algorithmSuiteId();
            this.encryptionContext = model.encryptionContext();
            this.requiredEncryptionContextKeys = model.requiredEncryptionContextKeys();
        }

        @Override
        public Builder algorithmSuiteId(AlgorithmSuiteId algorithmSuiteId) {
            this.algorithmSuiteId = algorithmSuiteId;
            return this;
        }

        @Override
        public AlgorithmSuiteId algorithmSuiteId() {
            return this.algorithmSuiteId;
        }

        @Override
        public Builder encryptionContext(Map<String, String> encryptionContext) {
            this.encryptionContext = encryptionContext;
            return this;
        }

        @Override
        public Map<String, String> encryptionContext() {
            return this.encryptionContext;
        }

        @Override
        public Builder requiredEncryptionContextKeys(List<String> requiredEncryptionContextKeys) {
            this.requiredEncryptionContextKeys = requiredEncryptionContextKeys;
            return this;
        }

        @Override
        public List<String> requiredEncryptionContextKeys() {
            return this.requiredEncryptionContextKeys;
        }

        @Override
        public InitializeDecryptionMaterialsInput build() {
            if (Objects.isNull(this.algorithmSuiteId())) {
                throw new IllegalArgumentException("Missing value for required field `algorithmSuiteId`");
            }
            if (Objects.isNull(this.encryptionContext())) {
                throw new IllegalArgumentException("Missing value for required field `encryptionContext`");
            }
            if (Objects.isNull(this.requiredEncryptionContextKeys())) {
                throw new IllegalArgumentException("Missing value for required field `requiredEncryptionContextKeys`");
            }
            return new InitializeDecryptionMaterialsInput(this);
        }
    }

    public static interface Builder {
        public Builder algorithmSuiteId(AlgorithmSuiteId var1);

        public AlgorithmSuiteId algorithmSuiteId();

        public Builder encryptionContext(Map<String, String> var1);

        public Map<String, String> encryptionContext();

        public Builder requiredEncryptionContextKeys(List<String> var1);

        public List<String> requiredEncryptionContextKeys();

        public InitializeDecryptionMaterialsInput build();
    }
}

