/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SaslPropertiesResolver;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.util.KerberosName;
import org.apache.hadoop.security.authentication.util.KerberosUtil;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.shaded.org.apache.commons.io.IOUtils;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.keytab.Keytab;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.keytab.KeytabEntry;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.EncryptionKey;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.type.base.PrincipalName;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KDiag
extends Configured
implements Tool,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(KDiag.class);
    public static final String KRB5_CCNAME = "KRB5CCNAME";
    public static final String KRB5_CONFIG = "KRB5_CONFIG";
    public static final String JAVA_SECURITY_KRB5_CONF = "java.security.krb5.conf";
    public static final String JAVA_SECURITY_KRB5_REALM = "java.security.krb5.realm";
    public static final String JAVA_SECURITY_KRB5_KDC_ADDRESS = "java.security.krb5.kdc";
    public static final String SUN_SECURITY_KRB5_DEBUG = "sun.security.krb5.debug";
    public static final String SUN_SECURITY_SPNEGO_DEBUG = "sun.security.spnego.debug";
    public static final String SUN_SECURITY_JAAS_FILE = "java.security.auth.login.config";
    public static final String KERBEROS_KINIT_COMMAND = "hadoop.kerberos.kinit.command";
    public static final String HADOOP_AUTHENTICATION_IS_DISABLED = "Hadoop authentication is disabled";
    public static final String UNSET = "(unset)";
    public static final String NO_DEFAULT_REALM = "Cannot locate default realm";
    public static final int KDIAG_FAILURE = 41;
    public static final String DFS_DATA_TRANSFER_SASLPROPERTIES_RESOLVER_CLASS = "dfs.data.transfer.saslproperties.resolver.class";
    public static final String DFS_DATA_TRANSFER_PROTECTION = "dfs.data.transfer.protection";
    public static final String ETC_KRB5_CONF = "/etc/krb5.conf";
    public static final String ETC_NTP = "/etc/ntp.conf";
    public static final String HADOOP_JAAS_DEBUG = "HADOOP_JAAS_DEBUG";
    private PrintWriter out;
    private File keytab;
    private String principal;
    private long minKeyLength = 256L;
    private boolean securityRequired;
    private boolean nofail = false;
    private boolean nologin = false;
    private boolean jaas = false;
    private boolean checkShortName = false;
    private static final Pattern nonSimplePattern = Pattern.compile("[/@]");
    private boolean probeHasFailed = false;
    public static final String CAT_CONFIG = "CONFIG";
    public static final String CAT_JAAS = "JAAS";
    public static final String CAT_JVM = "JVM";
    public static final String CAT_KERBEROS = "KERBEROS";
    public static final String CAT_LOGIN = "LOGIN";
    public static final String CAT_OS = "JAAS";
    public static final String CAT_SASL = "SASL";
    public static final String CAT_UGI = "UGI";
    public static final String CAT_TOKEN = "TOKEN";
    public static final String ARG_KEYLEN = "--keylen";
    public static final String ARG_KEYTAB = "--keytab";
    public static final String ARG_JAAS = "--jaas";
    public static final String ARG_NOFAIL = "--nofail";
    public static final String ARG_NOLOGIN = "--nologin";
    public static final String ARG_OUTPUT = "--out";
    public static final String ARG_PRINCIPAL = "--principal";
    public static final String ARG_RESOURCE = "--resource";
    public static final String ARG_SECURE = "--secure";
    public static final String ARG_VERIFYSHORTNAME = "--verifyshortname";

    public KDiag(Configuration conf, PrintWriter out, File keytab, String principal, long minKeyLength, boolean securityRequired) {
        super(conf);
        this.keytab = keytab;
        this.principal = principal;
        this.out = out;
        this.minKeyLength = minKeyLength;
        this.securityRequired = securityRequired;
    }

    public KDiag() {
    }

    @Override
    public void close() throws IOException {
        this.flush();
        if (this.out != null) {
            this.out.close();
        }
    }

    @Override
    public int run(String[] argv) throws Exception {
        String resource;
        LinkedList<String> args = new LinkedList<String>(Arrays.asList(argv));
        String keytabName = StringUtils.popOptionWithArgument(ARG_KEYTAB, args);
        if (keytabName != null) {
            this.keytab = new File(keytabName);
        }
        this.principal = StringUtils.popOptionWithArgument(ARG_PRINCIPAL, args);
        String outf = StringUtils.popOptionWithArgument(ARG_OUTPUT, args);
        String mkl = StringUtils.popOptionWithArgument(ARG_KEYLEN, args);
        if (mkl != null) {
            this.minKeyLength = Integer.parseInt(mkl);
        }
        this.securityRequired = StringUtils.popOption(ARG_SECURE, args);
        this.nofail = StringUtils.popOption(ARG_NOFAIL, args);
        this.jaas = StringUtils.popOption(ARG_JAAS, args);
        this.nologin = StringUtils.popOption(ARG_NOLOGIN, args);
        this.checkShortName = StringUtils.popOption(ARG_VERIFYSHORTNAME, args);
        while (null != (resource = StringUtils.popOptionWithArgument(ARG_RESOURCE, args))) {
            LOG.info("Loading resource {}", (Object)resource);
            InputStream in = this.getClass().getClassLoader().getResourceAsStream(resource);
            Throwable throwable = null;
            try {
                if (!this.verify(in != null, CAT_CONFIG, "No resource %s", resource)) continue;
                Configuration.addDefaultResource(resource);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (in == null) continue;
                if (throwable != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                in.close();
            }
        }
        if (!args.isEmpty()) {
            this.println("Unknown arguments in command:", new Object[0]);
            for (String s : args) {
                this.println("  \"%s\"", s);
            }
            this.println();
            this.println(this.usage(), new Object[0]);
            return -1;
        }
        if (outf != null) {
            this.println("Printing output to %s", outf);
            this.out = new PrintWriter(new File(outf), "UTF-8");
        }
        this.execute();
        return this.probeHasFailed ? 41 : 0;
    }

    private String usage() {
        return "KDiag: Diagnose Kerberos Problems\n" + this.arg("-D", "key=value", "Define a configuration option") + this.arg(ARG_JAAS, "", "Require a JAAS file to be defined in java.security.auth.login.config") + this.arg(ARG_KEYLEN, "<keylen>", "Require a minimum size for encryption keys supported by the JVM. Default value : " + this.minKeyLength) + this.arg(ARG_KEYTAB, "<keytab> --principal <principal>", "Login from a keytab as a specific principal") + this.arg(ARG_NOFAIL, "", "Do not fail on the first problem") + this.arg(ARG_NOLOGIN, "", "Do not attempt to log in") + this.arg(ARG_OUTPUT, "<file>", "Write output to a file") + this.arg(ARG_RESOURCE, "<resource>", "Load an XML configuration resource") + this.arg(ARG_SECURE, "", "Require the hadoop configuration to be secure") + this.arg(ARG_VERIFYSHORTNAME, "--principal <principal>", "Verify the short name of the specific principal does not contain '@' or '/'");
    }

    private String arg(String name, String params, String meaning) {
        return String.format("  [%s%s%s] : %s", name, !params.isEmpty() ? " " : "", params, meaning) + ".\n";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() throws Exception {
        this.title("Kerberos Diagnostics scan at %s", new Date(System.currentTimeMillis()));
        this.println("Hostname = %s", InetAddress.getLocalHost().getCanonicalHostName());
        this.println("%s = %d", ARG_KEYLEN, this.minKeyLength);
        this.println("%s = %s", ARG_KEYTAB, this.keytab);
        this.println("%s = %s", ARG_PRINCIPAL, this.principal);
        this.println("%s = %s", ARG_VERIFYSHORTNAME, this.checkShortName);
        this.validateKeyLength();
        this.println("JVM Kerberos Login Module = %s", KerberosUtil.getKrb5LoginModuleName());
        this.title("Core System Properties", new Object[0]);
        for (String prop : new String[]{"user.name", "java.version", "java.vendor", JAVA_SECURITY_KRB5_CONF, JAVA_SECURITY_KRB5_REALM, JAVA_SECURITY_KRB5_KDC_ADDRESS, SUN_SECURITY_KRB5_DEBUG, SUN_SECURITY_SPNEGO_DEBUG, SUN_SECURITY_JAAS_FILE}) {
            this.printSysprop(prop);
        }
        this.endln();
        this.title("All System Properties", new Object[0]);
        ArrayList<String> propList = new ArrayList<String>(System.getProperties().stringPropertyNames());
        Collections.sort(propList, String.CASE_INSENSITIVE_ORDER);
        for (String s : propList) {
            this.printSysprop(s);
        }
        this.endln();
        this.title("Environment Variables", new Object[0]);
        for (String env : new String[]{HADOOP_JAAS_DEBUG, KRB5_CCNAME, KRB5_CONFIG, "HADOOP_USER_NAME", "HADOOP_PROXY_USER", "HADOOP_TOKEN_FILE_LOCATION", "HADOOP_SECURE_LOG", "HADOOP_OPTS", "HADOOP_CLIENT_OPTS"}) {
            this.printEnv(env);
        }
        this.endln();
        this.title("Configuration Options", new Object[0]);
        for (String prop : new String[]{KERBEROS_KINIT_COMMAND, "hadoop.security.authentication", "hadoop.security.authorization", "hadoop.kerberos.min.seconds.before.relogin", "hadoop.security.dns.interface", "hadoop.security.dns.nameserver", "hadoop.rpc.protection", "hadoop.security.saslproperties.resolver.class", "hadoop.security.crypto.codec.classes", "hadoop.security.group.mapping", "hadoop.security.impersonation.provider.class", DFS_DATA_TRANSFER_PROTECTION, DFS_DATA_TRANSFER_SASLPROPERTIES_RESOLVER_CLASS}) {
            this.printConfOpt(prop);
        }
        Configuration conf = this.getConf();
        if (this.isSimpleAuthentication(conf)) {
            this.println(HADOOP_AUTHENTICATION_IS_DISABLED, new Object[0]);
            this.failif(this.securityRequired, CAT_CONFIG, HADOOP_AUTHENTICATION_IS_DISABLED, new Object[0]);
            LOG.warn("Security is not enabled for the Hadoop cluster");
        } else if (this.isSimpleAuthentication(new Configuration())) {
            LOG.warn("The default cluster security is insecure");
            this.failif(this.securityRequired, CAT_CONFIG, HADOOP_AUTHENTICATION_IS_DISABLED, new Object[0]);
        }
        boolean krb5Debug = this.getAndSet(SUN_SECURITY_KRB5_DEBUG);
        boolean spnegoDebug = this.getAndSet(SUN_SECURITY_SPNEGO_DEBUG);
        try {
            UserGroupInformation.setConfiguration(conf);
            this.validateHadoopTokenFiles(conf);
            this.validateKrb5File();
            this.printDefaultRealm();
            this.validateSasl("hadoop.security.saslproperties.resolver.class");
            if (conf.get(DFS_DATA_TRANSFER_SASLPROPERTIES_RESOLVER_CLASS) != null) {
                this.validateSasl(DFS_DATA_TRANSFER_SASLPROPERTIES_RESOLVER_CLASS);
            }
            this.validateKinitExecutable();
            this.validateJAAS(this.jaas);
            this.validateNTPConf();
            if (this.checkShortName) {
                this.validateShortName();
            }
            if (!this.nologin) {
                this.title("Logging in", new Object[0]);
                if (this.keytab != null) {
                    this.dumpKeytab(this.keytab);
                    this.loginFromKeytab();
                } else {
                    UserGroupInformation loginUser = UserGroupInformation.getLoginUser();
                    this.dumpUGI("Log in user", loginUser);
                    this.validateUGI("Login user", loginUser);
                    this.println("Ticket based login: %b", UserGroupInformation.isLoginTicketBased());
                    this.println("Keytab based login: %b", UserGroupInformation.isLoginKeytabBased());
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            System.setProperty(SUN_SECURITY_KRB5_DEBUG, Boolean.toString(krb5Debug));
            System.setProperty(SUN_SECURITY_SPNEGO_DEBUG, Boolean.toString(spnegoDebug));
        }
    }

    protected boolean isSimpleAuthentication(Configuration conf) {
        return SecurityUtil.getAuthenticationMethod(conf).equals((Object)UserGroupInformation.AuthenticationMethod.SIMPLE);
    }

    protected void validateKeyLength() throws NoSuchAlgorithmException {
        int aesLen = Cipher.getMaxAllowedKeyLength("AES");
        this.println("Maximum AES encryption key length %d bits", aesLen);
        this.verify(this.minKeyLength <= (long)aesLen, CAT_JVM, "Java Cryptography Extensions are not installed on this JVM. Maximum supported key length %s - minimum required %d", aesLen, this.minKeyLength);
    }

    protected void validateShortName() {
        this.failif(this.principal == null, CAT_KERBEROS, "No principal defined", new Object[0]);
        try {
            KerberosName kn = new KerberosName(this.principal);
            String result = kn.getShortName();
            if (nonSimplePattern.matcher(result).find()) {
                this.warn(CAT_KERBEROS, this.principal + " short name: " + result + " still contains @ or /", new Object[0]);
            }
        }
        catch (IOException e) {
            throw new KerberosDiagsFailure(CAT_KERBEROS, (Throwable)e, "Failed to get short name for " + this.principal, e);
        }
        catch (IllegalArgumentException e) {
            this.error(CAT_KERBEROS, "KerberosName(" + this.principal + ") failed: %s\n%s", e, StringUtils.stringifyException(e));
        }
    }

    protected void printDefaultRealm() {
        try {
            String defaultRealm = KerberosUtil.getDefaultRealm();
            this.println("Default Realm = %s", defaultRealm);
            if (defaultRealm == null) {
                this.warn(CAT_KERBEROS, "Host has no default realm", new Object[0]);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
            throw new KerberosDiagsFailure(CAT_JVM, (Throwable)e, "Failed to invoke krb5.Config.getDefaultRealm: %s: " + e, e);
        }
        catch (InvocationTargetException e) {
            Throwable cause;
            Throwable throwable = cause = e.getCause() != null ? e.getCause() : e;
            if (cause.toString().contains(NO_DEFAULT_REALM)) {
                this.warn(CAT_KERBEROS, "Host has no default realm", new Object[0]);
                LOG.debug(cause.toString(), cause);
            }
            this.error(CAT_KERBEROS, "Kerberos.getDefaultRealm() failed: %s\n%s", cause, StringUtils.stringifyException(cause));
        }
    }

    private void validateHadoopTokenFiles(Configuration conf) throws ClassNotFoundException, KerberosDiagsFailure, NoSuchMethodException, SecurityException {
        this.title("Locating Hadoop token files", new Object[0]);
        String tokenFileLocation = System.getProperty("hadoop.token.files");
        if (tokenFileLocation != null) {
            this.println("Found hadoop.token.files in system properties : " + tokenFileLocation, new Object[0]);
        }
        if (conf.get("hadoop.token.files") != null) {
            this.println("Found hadoop.token.files in hadoop configuration : " + conf.get("hadoop.token.files"), new Object[0]);
            if (System.getProperty("hadoop.token.files") != null) {
                this.println("hadoop.token.files in the system properties overrides the one specified in hadoop configuration", new Object[0]);
            } else {
                tokenFileLocation = conf.get("hadoop.token.files");
            }
        }
        if (tokenFileLocation != null) {
            for (String tokenFileName : StringUtils.getTrimmedStrings(tokenFileLocation)) {
                if (tokenFileName.length() <= 0) continue;
                File tokenFile = new File(tokenFileName);
                this.verifyFileIsValid(tokenFile, CAT_TOKEN, "token");
                this.verify(tokenFile, conf, CAT_TOKEN, "token");
            }
        }
    }

    private void validateKrb5File() throws IOException {
        if (!Shell.WINDOWS) {
            String krb5name;
            this.title("Locating Kerberos configuration file", new Object[0]);
            String krbPath = ETC_KRB5_CONF;
            String jvmKrbPath = System.getProperty(JAVA_SECURITY_KRB5_CONF);
            if (jvmKrbPath != null && !jvmKrbPath.isEmpty()) {
                this.println("Setting kerberos path from sysprop %s: \"%s\"", JAVA_SECURITY_KRB5_CONF, jvmKrbPath);
                krbPath = jvmKrbPath;
            }
            if ((krb5name = System.getenv(KRB5_CONFIG)) != null) {
                this.println("Setting kerberos path from environment variable %s: \"%s\"", KRB5_CONFIG, krb5name);
                krbPath = krb5name;
                if (jvmKrbPath != null) {
                    this.println("Warning - both %s and %s were set - %s takes priority", JAVA_SECURITY_KRB5_CONF, KRB5_CONFIG, KRB5_CONFIG);
                }
            }
            File krbFile = new File(krbPath);
            this.println("Kerberos configuration file = %s", krbFile);
            this.dump(krbFile);
            this.endln();
        }
    }

    private void dumpKeytab(File keytabFile) throws IOException {
        this.title("Examining keytab %s", keytabFile);
        File kt = keytabFile.getCanonicalFile();
        this.verifyFileIsValid(kt, CAT_KERBEROS, "keytab");
        Keytab loadKeytab = Keytab.loadKeytab((File)kt);
        List principals = loadKeytab.getPrincipals();
        this.println("keytab principal count: %d", principals.size());
        int entrySize = 0;
        for (PrincipalName princ : principals) {
            List entries = loadKeytab.getKeytabEntries(princ);
            entrySize += entries.size();
            for (KeytabEntry entry : entries) {
                EncryptionKey key = entry.getKey();
                this.println(" %s: version=%d expires=%s encryption=%s", entry.getPrincipal(), entry.getKvno(), entry.getTimestamp(), key.getKeyType());
            }
        }
        this.println("keytab entry count: %d", entrySize);
        this.endln();
    }

    private void loginFromKeytab() throws IOException {
        if (this.keytab != null) {
            File kt = this.keytab.getCanonicalFile();
            this.println("Using keytab %s principal %s", kt, this.principal);
            String identity = this.principal;
            this.failif(this.principal == null, CAT_KERBEROS, "No principal defined", new Object[0]);
            UserGroupInformation ugi = UserGroupInformation.loginUserFromKeytabAndReturnUGI(this.principal, kt.getPath());
            this.dumpUGI(identity, ugi);
            this.validateUGI(this.principal, ugi);
            this.title("Attempting to relogin", new Object[0]);
            try {
                UserGroupInformation.setShouldRenewImmediatelyForTests(true);
                ugi.reloginFromKeytab();
            }
            catch (IllegalAccessError e) {
                this.warn(CAT_UGI, "Failed to reset UGI -and so could not try to relogin", new Object[0]);
                LOG.debug("Failed to reset UGI: {}", (Object)e, (Object)e);
            }
        } else {
            this.println("No keytab: attempting to log in is as current user", new Object[0]);
        }
    }

    private void dumpUGI(String title, UserGroupInformation ugi) throws IOException {
        this.title(title, new Object[0]);
        this.println("UGI instance = %s", ugi);
        this.println("Has kerberos credentials: %b", ugi.hasKerberosCredentials());
        this.println("Authentication method: %s", new Object[]{ugi.getAuthenticationMethod()});
        this.println("Real Authentication method: %s", new Object[]{ugi.getRealAuthenticationMethod()});
        this.title("Group names", new Object[0]);
        for (String name : ugi.getGroupNames()) {
            this.println(name, new Object[0]);
        }
        this.title("Credentials", new Object[0]);
        List<Text> secretKeys = ugi.getCredentials().getAllSecretKeys();
        this.title("Secret keys", new Object[0]);
        if (!secretKeys.isEmpty()) {
            for (Text secret : secretKeys) {
                this.println("%s", secret);
            }
        } else {
            this.println("(none)", new Object[0]);
        }
        this.dumpTokens(ugi);
    }

    private void validateUGI(String messagePrefix, UserGroupInformation user) {
        if (this.verify(user.getAuthenticationMethod() == UserGroupInformation.AuthenticationMethod.KERBEROS, CAT_LOGIN, "User %s is not authenticated by Kerberos", user)) {
            this.verify(user.hasKerberosCredentials(), CAT_LOGIN, "%s: No kerberos credentials for %s", messagePrefix, user);
            this.verify(user.getAuthenticationMethod() != null, CAT_LOGIN, "%s: Null AuthenticationMethod for %s", messagePrefix, user);
        }
    }

    private void validateKinitExecutable() {
        String kinit = this.getConf().getTrimmed(KERBEROS_KINIT_COMMAND, "");
        if (!kinit.isEmpty()) {
            File kinitPath = new File(kinit);
            this.println("%s = %s", KERBEROS_KINIT_COMMAND, kinitPath);
            if (kinitPath.isAbsolute()) {
                this.verifyFileIsValid(kinitPath, CAT_KERBEROS, KERBEROS_KINIT_COMMAND);
            } else {
                this.println("Executable %s is relative -must be on the PATH", kinit);
                this.printEnv("PATH");
            }
        }
    }

    private void validateSasl(String saslPropsResolverKey) {
        this.title("Resolving SASL property %s", saslPropsResolverKey);
        String saslPropsResolver = this.getConf().getTrimmed(saslPropsResolverKey);
        try {
            Class<SaslPropertiesResolver> resolverClass = this.getConf().getClass(saslPropsResolverKey, SaslPropertiesResolver.class, SaslPropertiesResolver.class);
            this.println("Resolver is %s", resolverClass);
        }
        catch (RuntimeException e) {
            throw new KerberosDiagsFailure(CAT_SASL, (Throwable)e, "Failed to load %s class %s", saslPropsResolverKey, saslPropsResolver);
        }
    }

    private void validateJAAS(boolean jaasRequired) throws IOException {
        String jaasFilename = System.getProperty(SUN_SECURITY_JAAS_FILE);
        if (jaasRequired) {
            this.verify(jaasFilename != null, "JAAS", "No JAAS file specified in java.security.auth.login.config", new Object[0]);
        }
        if (jaasFilename != null) {
            this.title("JAAS", new Object[0]);
            File jaasFile = new File(jaasFilename);
            this.println("JAAS file is defined in %s: %s", SUN_SECURITY_JAAS_FILE, jaasFile);
            this.verifyFileIsValid(jaasFile, "JAAS", "JAAS file defined in java.security.auth.login.config");
            this.dump(jaasFile);
            this.endln();
        }
    }

    private void validateNTPConf() throws IOException {
        File ntpfile;
        if (!Shell.WINDOWS && (ntpfile = new File(ETC_NTP)).exists() && this.verifyFileIsValid(ntpfile, "JAAS", "NTP file: " + ntpfile)) {
            this.title("NTP", new Object[0]);
            this.dump(ntpfile);
            this.endln();
        }
    }

    private boolean verifyFileIsValid(File file, String category, String text) {
        return this.verify(file.exists(), category, "%s file does not exist: %s", text, file) && this.verify(file.isFile(), category, "%s path does not refer to a file: %s", text, file) && this.verify(file.length() != 0L, category, "%s file is empty: %s", text, file) && this.verify(file.canRead(), category, "%s file is not readable: %s", text, file);
    }

    public void dumpTokens(UserGroupInformation ugi) {
        Collection<Token<? extends TokenIdentifier>> tokens = ugi.getCredentials().getAllTokens();
        this.title("Token Count: %d", tokens.size());
        for (Token<? extends TokenIdentifier> token : tokens) {
            this.println("Token %s", token.getKind());
        }
        this.endln();
    }

    private boolean getAndSet(String sysprop) {
        boolean old = Boolean.getBoolean(sysprop);
        System.setProperty(sysprop, "true");
        return old;
    }

    private void flush() {
        if (this.out != null) {
            this.out.flush();
        } else {
            System.out.flush();
        }
        System.err.flush();
    }

    private void println(String format, Object ... args) {
        this.flush();
        String msg = String.format(format, args);
        if (this.out != null) {
            this.out.println(msg);
        } else {
            System.out.println(msg);
        }
        this.flush();
    }

    private void println() {
        this.println("", new Object[0]);
    }

    private void endln() {
        this.println();
        this.println("-----", new Object[0]);
    }

    private void title(String format, Object ... args) {
        this.println();
        this.println();
        this.println("== " + String.format(format, args) + " ==", new Object[0]);
        this.println();
    }

    private void printSysprop(String property) {
        this.println("%s = \"%s\"", property, System.getProperty(property, UNSET));
    }

    private void printConfOpt(String option) {
        this.println("%s = \"%s\"", option, this.getConf().get(option, UNSET));
    }

    private void printEnv(String variable) {
        String env = System.getenv(variable);
        this.println("%s = \"%s\"", variable, env != null ? env : UNSET);
    }

    private void dump(File file) throws IOException {
        try (InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            for (String line : IOUtils.readLines((InputStream)in, (Charset)StandardCharsets.UTF_8)) {
                this.println("%s", line);
            }
        }
    }

    private void fail(String category, String message, Object ... args) throws KerberosDiagsFailure {
        this.error(category, message, args);
        throw new KerberosDiagsFailure(category, message, args);
    }

    private boolean verify(boolean condition, String category, String message, Object ... args) throws KerberosDiagsFailure {
        if (!condition) {
            this.probeHasFailed = true;
            if (!this.nofail) {
                this.fail(category, message, args);
            } else {
                this.error(category, message, args);
            }
            return false;
        }
        return true;
    }

    private boolean verify(File tokenFile, Configuration conf, String category, String message) throws KerberosDiagsFailure {
        try {
            Credentials.readTokenStorageFile(tokenFile, conf);
        }
        catch (Exception e) {
            if (!this.nofail) {
                this.fail(category, message, new Object[0]);
            } else {
                this.error(category, message, new Object[0]);
            }
            return false;
        }
        return true;
    }

    private void error(String category, String message, Object ... args) {
        this.println("ERROR: %s: %s", category, String.format(message, args));
    }

    private void warn(String category, String message, Object ... args) {
        this.println("WARNING: %s: %s", category, String.format(message, args));
    }

    private void failif(boolean condition, String category, String message, Object ... args) throws KerberosDiagsFailure {
        if (condition) {
            this.fail(category, message, args);
        }
    }

    public static int exec(Configuration conf, String ... argv) throws Exception {
        try (KDiag kdiag = new KDiag();){
            int n = ToolRunner.run(conf, kdiag, argv);
            return n;
        }
    }

    public static void main(String[] argv) {
        try {
            ExitUtil.terminate(KDiag.exec(new Configuration(), argv));
        }
        catch (ExitUtil.ExitException e) {
            LOG.error(e.toString());
            System.exit(e.status);
        }
        catch (Exception e) {
            LOG.error(e.toString(), (Throwable)e);
            ExitUtil.halt(-1, e);
        }
    }

    public static class KerberosDiagsFailure
    extends ExitUtil.ExitException {
        private final String category;

        public KerberosDiagsFailure(String category, String message) {
            super(41, category + ": " + message);
            this.category = category;
        }

        public KerberosDiagsFailure(String category, String message, Object ... args) {
            this(category, String.format(message, args));
        }

        public KerberosDiagsFailure(String category, Throwable throwable, String message, Object ... args) {
            this(category, message, args);
            this.initCause(throwable);
        }

        public String getCategory() {
            return this.category;
        }
    }
}

