/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.transport.controller;

import java.io.IOException;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.support.nodes.BaseNodeResponse;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;

public class MLUndeployControllerNodeResponse
extends BaseNodeResponse
implements ToXContentFragment {
    @Generated
    private static final Logger log = LogManager.getLogger(MLUndeployControllerNodeResponse.class);
    private Map<String, String> controllerUndeployStatus;

    public MLUndeployControllerNodeResponse(DiscoveryNode node, Map<String, String> controllerUndeployStatus) {
        super(node);
        this.controllerUndeployStatus = controllerUndeployStatus;
    }

    public MLUndeployControllerNodeResponse(StreamInput in) throws IOException {
        super(in);
        if (in.readBoolean()) {
            this.controllerUndeployStatus = in.readMap(StreamInput::readString, StreamInput::readString);
        }
    }

    public static MLUndeployControllerNodeResponse readStats(StreamInput in) throws IOException {
        return new MLUndeployControllerNodeResponse(in);
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (!this.isControllerUndeployStatusEmpty()) {
            out.writeBoolean(true);
            out.writeMap(this.controllerUndeployStatus, StreamOutput::writeString, StreamOutput::writeString);
        } else {
            out.writeBoolean(false);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("stats");
        if (!this.isControllerUndeployStatusEmpty()) {
            for (Map.Entry<String, String> stat : this.controllerUndeployStatus.entrySet()) {
                builder.field(stat.getKey(), stat.getValue());
            }
        }
        builder.endObject();
        return builder;
    }

    public boolean isControllerUndeployStatusEmpty() {
        return this.controllerUndeployStatus == null || this.controllerUndeployStatus.isEmpty();
    }

    @Generated
    public Map<String, String> getControllerUndeployStatus() {
        return this.controllerUndeployStatus;
    }
}

