/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.deprecation;

import com.google.common.base.Preconditions;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.deprecation.DeprecationProfile;
import org.protege.editor.owl.model.util.OboUtilities;
import org.protege.editor.owl.ui.AbstractOWLWizardPanel;
import org.protege.editor.owl.ui.deprecation.DeprecateEntityWizardState;
import org.protege.editor.owl.ui.find.EntityFinderField;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;

public class DeprecationReplacementEntityPage
extends AbstractOWLWizardPanel {
    public static final String ID = "DeprecationReplacementEntityPage";
    @Nonnull
    private final DeprecateEntityWizardState wizardState;
    private Optional<OWLEntity> selectedEntity = Optional.empty();
    private JLabel chosenReplacementLabel = new JLabel();
    private final EntityFinderField entityFinderField;

    public DeprecationReplacementEntityPage(@Nonnull OWLEditorKit editorKit, @Nonnull DeprecateEntityWizardState wizardState) {
        super(ID, "Direct replacement entity", editorKit);
        this.wizardState = (DeprecateEntityWizardState)Preconditions.checkNotNull((Object)wizardState);
        this.setInstructions("<b>Please specify an entity that should be used as a direct replacement for the deprecated entity.</b>\n\nSpecifying a replacement entity will replace usages of the deprecated entity with the replacement entity. An annotation will also be added to \"point\" to this replacement entity.\n\nUse the search field below to search for a replacement entity.  If you do not want to specify a replacement entity leave the field empty and press Continue.");
        JPanel content = new JPanel(new BorderLayout(7, 7));
        this.entityFinderField = new EntityFinderField(content, editorKit);
        this.entityFinderField.setEntityFoundHandler(this::setReplacementEntity);
        this.entityFinderField.setSearchStartedHandler(this::clearReplacementEntity);
        content.add((Component)((Object)this.entityFinderField), "North");
        content.add((Component)this.chosenReplacementLabel, "South");
        JPanel contentHolder = new JPanel(new BorderLayout());
        contentHolder.add((Component)content, "North");
        this.setContent(contentHolder);
    }

    private void clearReplacementEntity() {
        this.selectedEntity = Optional.empty();
        this.chosenReplacementLabel.setText("");
    }

    private void setReplacementEntity(@Nonnull OWLEntity entity) {
        OWLEditorKit editorKit = this.getOWLEditorKit();
        String rendering = editorKit.getModelManager().getRendering((OWLObject)entity);
        this.entityFinderField.setText(rendering);
        this.selectedEntity = Optional.of(entity);
        this.chosenReplacementLabel.setText("<html><body>The deprecated entity will be replaced with <span style=\"font-weight: bold;\">" + rendering + "</span>" + OboUtilities.getOboIdFromIri(entity.getIRI()).map(id -> " (" + id + ")").orElse(""));
    }

    public Optional<OWLEntity> getReplacementEntity() {
        return this.selectedEntity;
    }

    public void aboutToHidePanel() {
        this.wizardState.setReplacementEntity(this.selectedEntity.orElse(null));
    }

    @Nullable
    public Object getBackPanelDescriptor() {
        if (this.wizardState.getDeprecationProfile().map(profile -> profile.getDeprecationCode().isPresent()).orElse(false).booleanValue()) {
            return "DeprecationCodePage";
        }
        return "DeprecationReason";
    }

    @Nullable
    public Object getNextPanelDescriptor() {
        Optional<DeprecationProfile> profile = this.wizardState.getDeprecationProfile();
        if (profile.isPresent() && profile.get().getAlternateEntityAnnotationPropertyIri().isPresent() && !this.selectedEntity.isPresent()) {
            return "AlternateEntitiesPage";
        }
        return "DeprecationSummaryPage";
    }

    public void displayingPanel() {
        super.displayingPanel();
        this.entityFinderField.requestFocus();
    }
}

