from chardet.enums import CharacterCategory, SequenceLikelihood
from chardet.sbcharsetprober import SingleByteCharSetModel

ROMANIAN_LANG_MODEL = {
    25: {  # 'A'
        25: SequenceLikelihood.LIKELY,  # 'A'
        39: SequenceLikelihood.LIKELY,  # 'B'
        26: SequenceLikelihood.LIKELY,  # 'C'
        30: SequenceLikelihood.LIKELY,  # 'D'
        34: SequenceLikelihood.LIKELY,  # 'E'
        43: SequenceLikelihood.LIKELY,  # 'F'
        45: SequenceLikelihood.LIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.LIKELY,  # 'I'
        51: SequenceLikelihood.LIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.POSITIVE,  # 'L'
        32: SequenceLikelihood.LIKELY,  # 'M'
        38: SequenceLikelihood.POSITIVE,  # 'N'
        41: SequenceLikelihood.UNLIKELY,  # 'O'
        29: SequenceLikelihood.LIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.POSITIVE,  # 'R'
        28: SequenceLikelihood.LIKELY,  # 'S'
        37: SequenceLikelihood.POSITIVE,  # 'T'
        42: SequenceLikelihood.LIKELY,  # 'U'
        44: SequenceLikelihood.LIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.LIKELY,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.LIKELY,  # 'b'
        8: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.LIKELY,  # 'e'
        17: SequenceLikelihood.LIKELY,  # 'f'
        19: SequenceLikelihood.LIKELY,  # 'g'
        24: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.LIKELY,  # 'i'
        33: SequenceLikelihood.LIKELY,  # 'j'
        46: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        6: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.POSITIVE,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        4: SequenceLikelihood.POSITIVE,  # 'r'
        11: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        48: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.LIKELY,  # 'z'
        62: SequenceLikelihood.NEGATIVE,  # 'Â'
        47: SequenceLikelihood.UNLIKELY,  # 'Î'
        27: SequenceLikelihood.NEGATIVE,  # 'â'
        21: SequenceLikelihood.UNLIKELY,  # 'î'
        57: SequenceLikelihood.UNLIKELY,  # 'Ă'
        15: SequenceLikelihood.UNLIKELY,  # 'ă'
        55: SequenceLikelihood.UNLIKELY,  # 'Ș'
        23: SequenceLikelihood.LIKELY,  # 'ș'
        59: SequenceLikelihood.LIKELY,  # 'Ț'
        22: SequenceLikelihood.UNLIKELY,  # 'ț'
    },
    39: {  # 'B'
        25: SequenceLikelihood.LIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.LIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.LIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.LIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.LIKELY,  # 'L'
        32: SequenceLikelihood.LIKELY,  # 'M'
        38: SequenceLikelihood.LIKELY,  # 'N'
        41: SequenceLikelihood.LIKELY,  # 'O'
        29: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.LIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.LIKELY,  # 'U'
        44: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        8: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        19: SequenceLikelihood.UNLIKELY,  # 'g'
        24: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        33: SequenceLikelihood.UNLIKELY,  # 'j'
        46: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        4: SequenceLikelihood.POSITIVE,  # 'r'
        11: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        48: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        62: SequenceLikelihood.UNLIKELY,  # 'Â'
        47: SequenceLikelihood.UNLIKELY,  # 'Î'
        27: SequenceLikelihood.UNLIKELY,  # 'â'
        21: SequenceLikelihood.UNLIKELY,  # 'î'
        57: SequenceLikelihood.UNLIKELY,  # 'Ă'
        15: SequenceLikelihood.LIKELY,  # 'ă'
        55: SequenceLikelihood.NEGATIVE,  # 'Ș'
        23: SequenceLikelihood.NEGATIVE,  # 'ș'
        59: SequenceLikelihood.UNLIKELY,  # 'Ț'
        22: SequenceLikelihood.NEGATIVE,  # 'ț'
    },
    26: {  # 'C'
        25: SequenceLikelihood.POSITIVE,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.LIKELY,  # 'C'
        30: SequenceLikelihood.LIKELY,  # 'D'
        34: SequenceLikelihood.POSITIVE,  # 'E'
        43: SequenceLikelihood.LIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.LIKELY,  # 'H'
        31: SequenceLikelihood.LIKELY,  # 'I'
        51: SequenceLikelihood.LIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.LIKELY,  # 'L'
        32: SequenceLikelihood.LIKELY,  # 'M'
        38: SequenceLikelihood.LIKELY,  # 'N'
        41: SequenceLikelihood.POSITIVE,  # 'O'
        29: SequenceLikelihood.LIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.LIKELY,  # 'R'
        28: SequenceLikelihood.LIKELY,  # 'S'
        37: SequenceLikelihood.LIKELY,  # 'T'
        42: SequenceLikelihood.LIKELY,  # 'U'
        44: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        8: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        19: SequenceLikelihood.UNLIKELY,  # 'g'
        24: SequenceLikelihood.POSITIVE,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        33: SequenceLikelihood.UNLIKELY,  # 'j'
        46: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        4: SequenceLikelihood.POSITIVE,  # 'r'
        11: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        48: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        62: SequenceLikelihood.UNLIKELY,  # 'Â'
        47: SequenceLikelihood.UNLIKELY,  # 'Î'
        27: SequenceLikelihood.POSITIVE,  # 'â'
        21: SequenceLikelihood.LIKELY,  # 'î'
        57: SequenceLikelihood.LIKELY,  # 'Ă'
        15: SequenceLikelihood.POSITIVE,  # 'ă'
        55: SequenceLikelihood.UNLIKELY,  # 'Ș'
        23: SequenceLikelihood.UNLIKELY,  # 'ș'
        59: SequenceLikelihood.UNLIKELY,  # 'Ț'
        22: SequenceLikelihood.UNLIKELY,  # 'ț'
    },
    30: {  # 'D'
        25: SequenceLikelihood.LIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.LIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.POSITIVE,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.LIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.LIKELY,  # 'L'
        32: SequenceLikelihood.LIKELY,  # 'M'
        38: SequenceLikelihood.LIKELY,  # 'N'
        41: SequenceLikelihood.LIKELY,  # 'O'
        29: SequenceLikelihood.LIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.LIKELY,  # 'R'
        28: SequenceLikelihood.LIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.LIKELY,  # 'U'
        44: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        8: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        19: SequenceLikelihood.UNLIKELY,  # 'g'
        24: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        33: SequenceLikelihood.UNLIKELY,  # 'j'
        46: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        4: SequenceLikelihood.POSITIVE,  # 'r'
        11: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        48: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        62: SequenceLikelihood.UNLIKELY,  # 'Â'
        47: SequenceLikelihood.UNLIKELY,  # 'Î'
        27: SequenceLikelihood.UNLIKELY,  # 'â'
        21: SequenceLikelihood.UNLIKELY,  # 'î'
        57: SequenceLikelihood.UNLIKELY,  # 'Ă'
        15: SequenceLikelihood.LIKELY,  # 'ă'
        55: SequenceLikelihood.UNLIKELY,  # 'Ș'
        23: SequenceLikelihood.NEGATIVE,  # 'ș'
        59: SequenceLikelihood.NEGATIVE,  # 'Ț'
        22: SequenceLikelihood.NEGATIVE,  # 'ț'
    },
    34: {  # 'E'
        25: SequenceLikelihood.LIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.LIKELY,  # 'C'
        30: SequenceLikelihood.LIKELY,  # 'D'
        34: SequenceLikelihood.LIKELY,  # 'E'
        43: SequenceLikelihood.LIKELY,  # 'F'
        45: SequenceLikelihood.LIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.LIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.LIKELY,  # 'L'
        32: SequenceLikelihood.LIKELY,  # 'M'
        38: SequenceLikelihood.POSITIVE,  # 'N'
        41: SequenceLikelihood.LIKELY,  # 'O'
        29: SequenceLikelihood.LIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.POSITIVE,  # 'R'
        28: SequenceLikelihood.LIKELY,  # 'S'
        37: SequenceLikelihood.LIKELY,  # 'T'
        42: SequenceLikelihood.LIKELY,  # 'U'
        44: SequenceLikelihood.LIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.LIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.LIKELY,  # 'Z'
        3: SequenceLikelihood.LIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        8: SequenceLikelihood.LIKELY,  # 'c'
        12: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        17: SequenceLikelihood.LIKELY,  # 'f'
        19: SequenceLikelihood.LIKELY,  # 'g'
        24: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.LIKELY,  # 'i'
        33: SequenceLikelihood.UNLIKELY,  # 'j'
        46: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        6: SequenceLikelihood.LIKELY,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.LIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        4: SequenceLikelihood.LIKELY,  # 'r'
        11: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.LIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.LIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        36: SequenceLikelihood.POSITIVE,  # 'x'
        48: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        62: SequenceLikelihood.UNLIKELY,  # 'Â'
        47: SequenceLikelihood.UNLIKELY,  # 'Î'
        27: SequenceLikelihood.NEGATIVE,  # 'â'
        21: SequenceLikelihood.UNLIKELY,  # 'î'
        57: SequenceLikelihood.UNLIKELY,  # 'Ă'
        15: SequenceLikelihood.NEGATIVE,  # 'ă'
        55: SequenceLikelihood.UNLIKELY,  # 'Ș'
        23: SequenceLikelihood.UNLIKELY,  # 'ș'
        59: SequenceLikelihood.UNLIKELY,  # 'Ț'
        22: SequenceLikelihood.UNLIKELY,  # 'ț'
    },
    43: {  # 'F'
        25: SequenceLikelihood.LIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.LIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.LIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.LIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.LIKELY,  # 'M'
        38: SequenceLikelihood.UNLIKELY,  # 'N'
        41: SequenceLikelihood.LIKELY,  # 'O'
        29: SequenceLikelihood.LIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.LIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        44: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        8: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        19: SequenceLikelihood.UNLIKELY,  # 'g'
        24: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        33: SequenceLikelihood.UNLIKELY,  # 'j'
        46: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        4: SequenceLikelihood.POSITIVE,  # 'r'
        11: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        48: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        62: SequenceLikelihood.UNLIKELY,  # 'Â'
        47: SequenceLikelihood.UNLIKELY,  # 'Î'
        27: SequenceLikelihood.UNLIKELY,  # 'â'
        21: SequenceLikelihood.UNLIKELY,  # 'î'
        57: SequenceLikelihood.UNLIKELY,  # 'Ă'
        15: SequenceLikelihood.LIKELY,  # 'ă'
        55: SequenceLikelihood.UNLIKELY,  # 'Ș'
        23: SequenceLikelihood.NEGATIVE,  # 'ș'
        59: SequenceLikelihood.UNLIKELY,  # 'Ț'
        22: SequenceLikelihood.NEGATIVE,  # 'ț'
    },
    45: {  # 'G'
        25: SequenceLikelihood.LIKELY,  # 'A'
        39: SequenceLikelihood.LIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.LIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.LIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        38: SequenceLikelihood.UNLIKELY,  # 'N'
        41: SequenceLikelihood.LIKELY,  # 'O'
        29: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.LIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        44: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        8: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        19: SequenceLikelihood.UNLIKELY,  # 'g'
        24: SequenceLikelihood.POSITIVE,  # 'h'
        2: SequenceLikelihood.LIKELY,  # 'i'
        33: SequenceLikelihood.UNLIKELY,  # 'j'
        46: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        4: SequenceLikelihood.POSITIVE,  # 'r'
        11: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        48: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        62: SequenceLikelihood.UNLIKELY,  # 'Â'
        47: SequenceLikelihood.UNLIKELY,  # 'Î'
        27: SequenceLikelihood.LIKELY,  # 'â'
        21: SequenceLikelihood.UNLIKELY,  # 'î'
        57: SequenceLikelihood.UNLIKELY,  # 'Ă'
        15: SequenceLikelihood.LIKELY,  # 'ă'
        55: SequenceLikelihood.NEGATIVE,  # 'Ș'
        23: SequenceLikelihood.NEGATIVE,  # 'ș'
        59: SequenceLikelihood.UNLIKELY,  # 'Ț'
        22: SequenceLikelihood.UNLIKELY,  # 'ț'
    },
    50: {  # 'H'
        25: SequenceLikelihood.LIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.LIKELY,  # 'D'
        34: SequenceLikelihood.LIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.LIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        38: SequenceLikelihood.UNLIKELY,  # 'N'
        41: SequenceLikelihood.LIKELY,  # 'O'
        29: SequenceLikelihood.LIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        44: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        8: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.LIKELY,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        19: SequenceLikelihood.UNLIKELY,  # 'g'
        24: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.LIKELY,  # 'i'
        33: SequenceLikelihood.UNLIKELY,  # 'j'
        46: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        4: SequenceLikelihood.LIKELY,  # 'r'
        11: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        48: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        62: SequenceLikelihood.UNLIKELY,  # 'Â'
        47: SequenceLikelihood.UNLIKELY,  # 'Î'
        27: SequenceLikelihood.UNLIKELY,  # 'â'
        21: SequenceLikelihood.UNLIKELY,  # 'î'
        57: SequenceLikelihood.UNLIKELY,  # 'Ă'
        15: SequenceLikelihood.UNLIKELY,  # 'ă'
        55: SequenceLikelihood.UNLIKELY,  # 'Ș'
        23: SequenceLikelihood.NEGATIVE,  # 'ș'
        59: SequenceLikelihood.NEGATIVE,  # 'Ț'
        22: SequenceLikelihood.NEGATIVE,  # 'ț'
    },
    31: {  # 'I'
        25: SequenceLikelihood.POSITIVE,  # 'A'
        39: SequenceLikelihood.LIKELY,  # 'B'
        26: SequenceLikelihood.POSITIVE,  # 'C'
        30: SequenceLikelihood.POSITIVE,  # 'D'
        34: SequenceLikelihood.LIKELY,  # 'E'
        43: SequenceLikelihood.LIKELY,  # 'F'
        45: SequenceLikelihood.LIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.POSITIVE,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.LIKELY,  # 'L'
        32: SequenceLikelihood.LIKELY,  # 'M'
        38: SequenceLikelihood.POSITIVE,  # 'N'
        41: SequenceLikelihood.LIKELY,  # 'O'
        29: SequenceLikelihood.LIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.LIKELY,  # 'R'
        28: SequenceLikelihood.LIKELY,  # 'S'
        37: SequenceLikelihood.POSITIVE,  # 'T'
        42: SequenceLikelihood.LIKELY,  # 'U'
        44: SequenceLikelihood.LIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.LIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.LIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        8: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.LIKELY,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        19: SequenceLikelihood.LIKELY,  # 'g'
        24: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.LIKELY,  # 'i'
        33: SequenceLikelihood.UNLIKELY,  # 'j'
        46: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        6: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        4: SequenceLikelihood.LIKELY,  # 'r'
        11: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.LIKELY,  # 't'
        7: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.LIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        48: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        62: SequenceLikelihood.UNLIKELY,  # 'Â'
        47: SequenceLikelihood.UNLIKELY,  # 'Î'
        27: SequenceLikelihood.UNLIKELY,  # 'â'
        21: SequenceLikelihood.UNLIKELY,  # 'î'
        57: SequenceLikelihood.UNLIKELY,  # 'Ă'
        15: SequenceLikelihood.UNLIKELY,  # 'ă'
        55: SequenceLikelihood.UNLIKELY,  # 'Ș'
        23: SequenceLikelihood.UNLIKELY,  # 'ș'
        59: SequenceLikelihood.UNLIKELY,  # 'Ț'
        22: SequenceLikelihood.UNLIKELY,  # 'ț'
    },
    51: {  # 'J'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        38: SequenceLikelihood.UNLIKELY,  # 'N'
        41: SequenceLikelihood.UNLIKELY,  # 'O'
        29: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.LIKELY,  # 'U'
        44: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.LIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        8: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.LIKELY,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        19: SequenceLikelihood.UNLIKELY,  # 'g'
        24: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.LIKELY,  # 'i'
        33: SequenceLikelihood.UNLIKELY,  # 'j'
        46: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        4: SequenceLikelihood.UNLIKELY,  # 'r'
        11: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        48: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        62: SequenceLikelihood.NEGATIVE,  # 'Â'
        47: SequenceLikelihood.NEGATIVE,  # 'Î'
        27: SequenceLikelihood.NEGATIVE,  # 'â'
        21: SequenceLikelihood.UNLIKELY,  # 'î'
        57: SequenceLikelihood.UNLIKELY,  # 'Ă'
        15: SequenceLikelihood.UNLIKELY,  # 'ă'
        55: SequenceLikelihood.NEGATIVE,  # 'Ș'
        23: SequenceLikelihood.NEGATIVE,  # 'ș'
        59: SequenceLikelihood.NEGATIVE,  # 'Ț'
        22: SequenceLikelihood.NEGATIVE,  # 'ț'
    },
    52: {  # 'K'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        38: SequenceLikelihood.UNLIKELY,  # 'N'
        41: SequenceLikelihood.UNLIKELY,  # 'O'
        29: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        44: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.LIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        8: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.LIKELY,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        19: SequenceLikelihood.UNLIKELY,  # 'g'
        24: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.LIKELY,  # 'i'
        33: SequenceLikelihood.UNLIKELY,  # 'j'
        46: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.LIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        4: SequenceLikelihood.LIKELY,  # 'r'
        11: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        48: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        62: SequenceLikelihood.NEGATIVE,  # 'Â'
        47: SequenceLikelihood.NEGATIVE,  # 'Î'
        27: SequenceLikelihood.UNLIKELY,  # 'â'
        21: SequenceLikelihood.UNLIKELY,  # 'î'
        57: SequenceLikelihood.NEGATIVE,  # 'Ă'
        15: SequenceLikelihood.UNLIKELY,  # 'ă'
        55: SequenceLikelihood.UNLIKELY,  # 'Ș'
        23: SequenceLikelihood.NEGATIVE,  # 'ș'
        59: SequenceLikelihood.NEGATIVE,  # 'Ț'
        22: SequenceLikelihood.UNLIKELY,  # 'ț'
    },
    40: {  # 'L'
        25: SequenceLikelihood.LIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.LIKELY,  # 'D'
        34: SequenceLikelihood.POSITIVE,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.POSITIVE,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        38: SequenceLikelihood.UNLIKELY,  # 'N'
        41: SequenceLikelihood.LIKELY,  # 'O'
        29: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.LIKELY,  # 'T'
        42: SequenceLikelihood.LIKELY,  # 'U'
        44: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        8: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        19: SequenceLikelihood.UNLIKELY,  # 'g'
        24: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        33: SequenceLikelihood.UNLIKELY,  # 'j'
        46: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        4: SequenceLikelihood.UNLIKELY,  # 'r'
        11: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        48: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        62: SequenceLikelihood.UNLIKELY,  # 'Â'
        47: SequenceLikelihood.UNLIKELY,  # 'Î'
        27: SequenceLikelihood.UNLIKELY,  # 'â'
        21: SequenceLikelihood.UNLIKELY,  # 'î'
        57: SequenceLikelihood.LIKELY,  # 'Ă'
        15: SequenceLikelihood.LIKELY,  # 'ă'
        55: SequenceLikelihood.UNLIKELY,  # 'Ș'
        23: SequenceLikelihood.NEGATIVE,  # 'ș'
        59: SequenceLikelihood.UNLIKELY,  # 'Ț'
        22: SequenceLikelihood.NEGATIVE,  # 'ț'
    },
    32: {  # 'M'
        25: SequenceLikelihood.POSITIVE,  # 'A'
        39: SequenceLikelihood.LIKELY,  # 'B'
        26: SequenceLikelihood.LIKELY,  # 'C'
        30: SequenceLikelihood.LIKELY,  # 'D'
        34: SequenceLikelihood.LIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.LIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.LIKELY,  # 'M'
        38: SequenceLikelihood.LIKELY,  # 'N'
        41: SequenceLikelihood.LIKELY,  # 'O'
        29: SequenceLikelihood.LIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.LIKELY,  # 'R'
        28: SequenceLikelihood.LIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.LIKELY,  # 'U'
        44: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.LIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        8: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        19: SequenceLikelihood.UNLIKELY,  # 'g'
        24: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        33: SequenceLikelihood.UNLIKELY,  # 'j'
        46: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        4: SequenceLikelihood.UNLIKELY,  # 'r'
        11: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        48: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        62: SequenceLikelihood.LIKELY,  # 'Â'
        47: SequenceLikelihood.UNLIKELY,  # 'Î'
        27: SequenceLikelihood.LIKELY,  # 'â'
        21: SequenceLikelihood.UNLIKELY,  # 'î'
        57: SequenceLikelihood.UNLIKELY,  # 'Ă'
        15: SequenceLikelihood.LIKELY,  # 'ă'
        55: SequenceLikelihood.UNLIKELY,  # 'Ș'
        23: SequenceLikelihood.NEGATIVE,  # 'ș'
        59: SequenceLikelihood.UNLIKELY,  # 'Ț'
        22: SequenceLikelihood.NEGATIVE,  # 'ț'
    },
    38: {  # 'N'
        25: SequenceLikelihood.POSITIVE,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.LIKELY,  # 'C'
        30: SequenceLikelihood.LIKELY,  # 'D'
        34: SequenceLikelihood.LIKELY,  # 'E'
        43: SequenceLikelihood.LIKELY,  # 'F'
        45: SequenceLikelihood.LIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.POSITIVE,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.LIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        38: SequenceLikelihood.UNLIKELY,  # 'N'
        41: SequenceLikelihood.LIKELY,  # 'O'
        29: SequenceLikelihood.LIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.LIKELY,  # 'R'
        28: SequenceLikelihood.LIKELY,  # 'S'
        37: SequenceLikelihood.POSITIVE,  # 'T'
        42: SequenceLikelihood.LIKELY,  # 'U'
        44: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        8: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        19: SequenceLikelihood.UNLIKELY,  # 'g'
        24: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        33: SequenceLikelihood.UNLIKELY,  # 'j'
        46: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        4: SequenceLikelihood.LIKELY,  # 'r'
        11: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        48: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        62: SequenceLikelihood.UNLIKELY,  # 'Â'
        47: SequenceLikelihood.UNLIKELY,  # 'Î'
        27: SequenceLikelihood.UNLIKELY,  # 'â'
        21: SequenceLikelihood.UNLIKELY,  # 'î'
        57: SequenceLikelihood.UNLIKELY,  # 'Ă'
        15: SequenceLikelihood.LIKELY,  # 'ă'
        55: SequenceLikelihood.UNLIKELY,  # 'Ș'
        23: SequenceLikelihood.UNLIKELY,  # 'ș'
        59: SequenceLikelihood.UNLIKELY,  # 'Ț'
        22: SequenceLikelihood.UNLIKELY,  # 'ț'
    },
    41: {  # 'O'
        25: SequenceLikelihood.LIKELY,  # 'A'
        39: SequenceLikelihood.LIKELY,  # 'B'
        26: SequenceLikelihood.LIKELY,  # 'C'
        30: SequenceLikelihood.LIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.LIKELY,  # 'F'
        45: SequenceLikelihood.LIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.LIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.LIKELY,  # 'L'
        32: SequenceLikelihood.LIKELY,  # 'M'
        38: SequenceLikelihood.POSITIVE,  # 'N'
        41: SequenceLikelihood.UNLIKELY,  # 'O'
        29: SequenceLikelihood.LIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.POSITIVE,  # 'R'
        28: SequenceLikelihood.LIKELY,  # 'S'
        37: SequenceLikelihood.LIKELY,  # 'T'
        42: SequenceLikelihood.LIKELY,  # 'U'
        44: SequenceLikelihood.LIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.LIKELY,  # 'a'
        18: SequenceLikelihood.LIKELY,  # 'b'
        8: SequenceLikelihood.LIKELY,  # 'c'
        12: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        17: SequenceLikelihood.LIKELY,  # 'f'
        19: SequenceLikelihood.UNLIKELY,  # 'g'
        24: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.UNLIKELY,  # 'i'
        33: SequenceLikelihood.UNLIKELY,  # 'j'
        46: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        6: SequenceLikelihood.LIKELY,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.LIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        4: SequenceLikelihood.POSITIVE,  # 'r'
        11: SequenceLikelihood.LIKELY,  # 's'
        5: SequenceLikelihood.LIKELY,  # 't'
        7: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.LIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        48: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        62: SequenceLikelihood.UNLIKELY,  # 'Â'
        47: SequenceLikelihood.UNLIKELY,  # 'Î'
        27: SequenceLikelihood.NEGATIVE,  # 'â'
        21: SequenceLikelihood.UNLIKELY,  # 'î'
        57: SequenceLikelihood.UNLIKELY,  # 'Ă'
        15: SequenceLikelihood.NEGATIVE,  # 'ă'
        55: SequenceLikelihood.UNLIKELY,  # 'Ș'
        23: SequenceLikelihood.UNLIKELY,  # 'ș'
        59: SequenceLikelihood.UNLIKELY,  # 'Ț'
        22: SequenceLikelihood.UNLIKELY,  # 'ț'
    },
    29: {  # 'P'
        25: SequenceLikelihood.LIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.LIKELY,  # 'C'
        30: SequenceLikelihood.LIKELY,  # 'D'
        34: SequenceLikelihood.LIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.LIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.LIKELY,  # 'L'
        32: SequenceLikelihood.LIKELY,  # 'M'
        38: SequenceLikelihood.LIKELY,  # 'N'
        41: SequenceLikelihood.LIKELY,  # 'O'
        29: SequenceLikelihood.LIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.LIKELY,  # 'R'
        28: SequenceLikelihood.POSITIVE,  # 'S'
        37: SequenceLikelihood.LIKELY,  # 'T'
        42: SequenceLikelihood.LIKELY,  # 'U'
        44: SequenceLikelihood.LIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        8: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        19: SequenceLikelihood.UNLIKELY,  # 'g'
        24: SequenceLikelihood.LIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        33: SequenceLikelihood.UNLIKELY,  # 'j'
        46: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        4: SequenceLikelihood.POSITIVE,  # 'r'
        11: SequenceLikelihood.LIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        48: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        62: SequenceLikelihood.UNLIKELY,  # 'Â'
        47: SequenceLikelihood.UNLIKELY,  # 'Î'
        27: SequenceLikelihood.LIKELY,  # 'â'
        21: SequenceLikelihood.UNLIKELY,  # 'î'
        57: SequenceLikelihood.UNLIKELY,  # 'Ă'
        15: SequenceLikelihood.LIKELY,  # 'ă'
        55: SequenceLikelihood.UNLIKELY,  # 'Ș'
        23: SequenceLikelihood.NEGATIVE,  # 'ș'
        59: SequenceLikelihood.UNLIKELY,  # 'Ț'
        22: SequenceLikelihood.UNLIKELY,  # 'ț'
    },
    61: {  # 'Q'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        38: SequenceLikelihood.UNLIKELY,  # 'N'
        41: SequenceLikelihood.UNLIKELY,  # 'O'
        29: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        44: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        8: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        19: SequenceLikelihood.UNLIKELY,  # 'g'
        24: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.UNLIKELY,  # 'i'
        33: SequenceLikelihood.UNLIKELY,  # 'j'
        46: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        4: SequenceLikelihood.UNLIKELY,  # 'r'
        11: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        48: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        62: SequenceLikelihood.NEGATIVE,  # 'Â'
        47: SequenceLikelihood.NEGATIVE,  # 'Î'
        27: SequenceLikelihood.NEGATIVE,  # 'â'
        21: SequenceLikelihood.NEGATIVE,  # 'î'
        57: SequenceLikelihood.NEGATIVE,  # 'Ă'
        15: SequenceLikelihood.NEGATIVE,  # 'ă'
        55: SequenceLikelihood.UNLIKELY,  # 'Ș'
        23: SequenceLikelihood.NEGATIVE,  # 'ș'
        59: SequenceLikelihood.NEGATIVE,  # 'Ț'
        22: SequenceLikelihood.NEGATIVE,  # 'ț'
    },
    35: {  # 'R'
        25: SequenceLikelihood.POSITIVE,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.LIKELY,  # 'C'
        30: SequenceLikelihood.LIKELY,  # 'D'
        34: SequenceLikelihood.POSITIVE,  # 'E'
        43: SequenceLikelihood.LIKELY,  # 'F'
        45: SequenceLikelihood.LIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.POSITIVE,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.LIKELY,  # 'L'
        32: SequenceLikelihood.LIKELY,  # 'M'
        38: SequenceLikelihood.LIKELY,  # 'N'
        41: SequenceLikelihood.POSITIVE,  # 'O'
        29: SequenceLikelihood.LIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.LIKELY,  # 'S'
        37: SequenceLikelihood.LIKELY,  # 'T'
        42: SequenceLikelihood.LIKELY,  # 'U'
        44: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        8: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        19: SequenceLikelihood.UNLIKELY,  # 'g'
        24: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.LIKELY,  # 'i'
        33: SequenceLikelihood.UNLIKELY,  # 'j'
        46: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        4: SequenceLikelihood.UNLIKELY,  # 'r'
        11: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        48: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        62: SequenceLikelihood.UNLIKELY,  # 'Â'
        47: SequenceLikelihood.UNLIKELY,  # 'Î'
        27: SequenceLikelihood.LIKELY,  # 'â'
        21: SequenceLikelihood.UNLIKELY,  # 'î'
        57: SequenceLikelihood.LIKELY,  # 'Ă'
        15: SequenceLikelihood.LIKELY,  # 'ă'
        55: SequenceLikelihood.UNLIKELY,  # 'Ș'
        23: SequenceLikelihood.UNLIKELY,  # 'ș'
        59: SequenceLikelihood.UNLIKELY,  # 'Ț'
        22: SequenceLikelihood.NEGATIVE,  # 'ț'
    },
    28: {  # 'S'
        25: SequenceLikelihood.LIKELY,  # 'A'
        39: SequenceLikelihood.LIKELY,  # 'B'
        26: SequenceLikelihood.LIKELY,  # 'C'
        30: SequenceLikelihood.POSITIVE,  # 'D'
        34: SequenceLikelihood.LIKELY,  # 'E'
        43: SequenceLikelihood.LIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.LIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.LIKELY,  # 'L'
        32: SequenceLikelihood.LIKELY,  # 'M'
        38: SequenceLikelihood.UNLIKELY,  # 'N'
        41: SequenceLikelihood.LIKELY,  # 'O'
        29: SequenceLikelihood.LIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.LIKELY,  # 'R'
        28: SequenceLikelihood.LIKELY,  # 'S'
        37: SequenceLikelihood.POSITIVE,  # 'T'
        42: SequenceLikelihood.POSITIVE,  # 'U'
        44: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        8: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.POSITIVE,  # 'f'
        19: SequenceLikelihood.UNLIKELY,  # 'g'
        24: SequenceLikelihood.LIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        33: SequenceLikelihood.UNLIKELY,  # 'j'
        46: SequenceLikelihood.LIKELY,  # 'k'
        9: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.POSITIVE,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        4: SequenceLikelihood.UNLIKELY,  # 'r'
        11: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        48: SequenceLikelihood.LIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        62: SequenceLikelihood.UNLIKELY,  # 'Â'
        47: SequenceLikelihood.UNLIKELY,  # 'Î'
        27: SequenceLikelihood.LIKELY,  # 'â'
        21: SequenceLikelihood.UNLIKELY,  # 'î'
        57: SequenceLikelihood.LIKELY,  # 'Ă'
        15: SequenceLikelihood.POSITIVE,  # 'ă'
        55: SequenceLikelihood.UNLIKELY,  # 'Ș'
        23: SequenceLikelihood.NEGATIVE,  # 'ș'
        59: SequenceLikelihood.UNLIKELY,  # 'Ț'
        22: SequenceLikelihood.UNLIKELY,  # 'ț'
    },
    37: {  # 'T'
        25: SequenceLikelihood.POSITIVE,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.LIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.POSITIVE,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.POSITIVE,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        38: SequenceLikelihood.UNLIKELY,  # 'N'
        41: SequenceLikelihood.POSITIVE,  # 'O'
        29: SequenceLikelihood.LIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.LIKELY,  # 'R'
        28: SequenceLikelihood.LIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.LIKELY,  # 'U'
        44: SequenceLikelihood.LIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        8: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        19: SequenceLikelihood.UNLIKELY,  # 'g'
        24: SequenceLikelihood.POSITIVE,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        33: SequenceLikelihood.UNLIKELY,  # 'j'
        46: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        4: SequenceLikelihood.POSITIVE,  # 'r'
        11: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.LIKELY,  # 'w'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        48: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        62: SequenceLikelihood.UNLIKELY,  # 'Â'
        47: SequenceLikelihood.UNLIKELY,  # 'Î'
        27: SequenceLikelihood.LIKELY,  # 'â'
        21: SequenceLikelihood.UNLIKELY,  # 'î'
        57: SequenceLikelihood.LIKELY,  # 'Ă'
        15: SequenceLikelihood.LIKELY,  # 'ă'
        55: SequenceLikelihood.UNLIKELY,  # 'Ș'
        23: SequenceLikelihood.NEGATIVE,  # 'ș'
        59: SequenceLikelihood.NEGATIVE,  # 'Ț'
        22: SequenceLikelihood.NEGATIVE,  # 'ț'
    },
    42: {  # 'U'
        25: SequenceLikelihood.LIKELY,  # 'A'
        39: SequenceLikelihood.LIKELY,  # 'B'
        26: SequenceLikelihood.LIKELY,  # 'C'
        30: SequenceLikelihood.LIKELY,  # 'D'
        34: SequenceLikelihood.LIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.LIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.LIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.POSITIVE,  # 'L'
        32: SequenceLikelihood.LIKELY,  # 'M'
        38: SequenceLikelihood.LIKELY,  # 'N'
        41: SequenceLikelihood.UNLIKELY,  # 'O'
        29: SequenceLikelihood.LIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.POSITIVE,  # 'R'
        28: SequenceLikelihood.LIKELY,  # 'S'
        37: SequenceLikelihood.LIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        44: SequenceLikelihood.LIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        8: SequenceLikelihood.LIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        19: SequenceLikelihood.UNLIKELY,  # 'g'
        24: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.LIKELY,  # 'i'
        33: SequenceLikelihood.UNLIKELY,  # 'j'
        46: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        6: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        4: SequenceLikelihood.LIKELY,  # 'r'
        11: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.LIKELY,  # 't'
        7: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        48: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        62: SequenceLikelihood.UNLIKELY,  # 'Â'
        47: SequenceLikelihood.NEGATIVE,  # 'Î'
        27: SequenceLikelihood.NEGATIVE,  # 'â'
        21: SequenceLikelihood.NEGATIVE,  # 'î'
        57: SequenceLikelihood.UNLIKELY,  # 'Ă'
        15: SequenceLikelihood.UNLIKELY,  # 'ă'
        55: SequenceLikelihood.UNLIKELY,  # 'Ș'
        23: SequenceLikelihood.UNLIKELY,  # 'ș'
        59: SequenceLikelihood.UNLIKELY,  # 'Ț'
        22: SequenceLikelihood.UNLIKELY,  # 'ț'
    },
    44: {  # 'V'
        25: SequenceLikelihood.LIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.LIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.POSITIVE,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        38: SequenceLikelihood.UNLIKELY,  # 'N'
        41: SequenceLikelihood.LIKELY,  # 'O'
        29: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.LIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        44: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        8: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        19: SequenceLikelihood.UNLIKELY,  # 'g'
        24: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        33: SequenceLikelihood.UNLIKELY,  # 'j'
        46: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        4: SequenceLikelihood.LIKELY,  # 'r'
        11: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        48: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        62: SequenceLikelihood.UNLIKELY,  # 'Â'
        47: SequenceLikelihood.UNLIKELY,  # 'Î'
        27: SequenceLikelihood.LIKELY,  # 'â'
        21: SequenceLikelihood.UNLIKELY,  # 'î'
        57: SequenceLikelihood.UNLIKELY,  # 'Ă'
        15: SequenceLikelihood.LIKELY,  # 'ă'
        55: SequenceLikelihood.NEGATIVE,  # 'Ș'
        23: SequenceLikelihood.NEGATIVE,  # 'ș'
        59: SequenceLikelihood.NEGATIVE,  # 'Ț'
        22: SequenceLikelihood.NEGATIVE,  # 'ț'
    },
    54: {  # 'W'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        38: SequenceLikelihood.UNLIKELY,  # 'N'
        41: SequenceLikelihood.UNLIKELY,  # 'O'
        29: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        44: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.LIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        8: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.LIKELY,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        19: SequenceLikelihood.UNLIKELY,  # 'g'
        24: SequenceLikelihood.LIKELY,  # 'h'
        2: SequenceLikelihood.LIKELY,  # 'i'
        33: SequenceLikelihood.UNLIKELY,  # 'j'
        46: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.LIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        4: SequenceLikelihood.UNLIKELY,  # 'r'
        11: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        48: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        62: SequenceLikelihood.NEGATIVE,  # 'Â'
        47: SequenceLikelihood.NEGATIVE,  # 'Î'
        27: SequenceLikelihood.NEGATIVE,  # 'â'
        21: SequenceLikelihood.NEGATIVE,  # 'î'
        57: SequenceLikelihood.UNLIKELY,  # 'Ă'
        15: SequenceLikelihood.NEGATIVE,  # 'ă'
        55: SequenceLikelihood.NEGATIVE,  # 'Ș'
        23: SequenceLikelihood.UNLIKELY,  # 'ș'
        59: SequenceLikelihood.UNLIKELY,  # 'Ț'
        22: SequenceLikelihood.NEGATIVE,  # 'ț'
    },
    56: {  # 'X'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.LIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        38: SequenceLikelihood.UNLIKELY,  # 'N'
        41: SequenceLikelihood.UNLIKELY,  # 'O'
        29: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        44: SequenceLikelihood.LIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.LIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        8: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        19: SequenceLikelihood.UNLIKELY,  # 'g'
        24: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.UNLIKELY,  # 'i'
        33: SequenceLikelihood.UNLIKELY,  # 'j'
        46: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        4: SequenceLikelihood.UNLIKELY,  # 'r'
        11: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        48: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        62: SequenceLikelihood.NEGATIVE,  # 'Â'
        47: SequenceLikelihood.NEGATIVE,  # 'Î'
        27: SequenceLikelihood.NEGATIVE,  # 'â'
        21: SequenceLikelihood.NEGATIVE,  # 'î'
        57: SequenceLikelihood.UNLIKELY,  # 'Ă'
        15: SequenceLikelihood.NEGATIVE,  # 'ă'
        55: SequenceLikelihood.NEGATIVE,  # 'Ș'
        23: SequenceLikelihood.NEGATIVE,  # 'ș'
        59: SequenceLikelihood.NEGATIVE,  # 'Ț'
        22: SequenceLikelihood.NEGATIVE,  # 'ț'
    },
    58: {  # 'Y'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        38: SequenceLikelihood.UNLIKELY,  # 'N'
        41: SequenceLikelihood.UNLIKELY,  # 'O'
        29: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        44: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.LIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        8: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        19: SequenceLikelihood.UNLIKELY,  # 'g'
        24: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.UNLIKELY,  # 'i'
        33: SequenceLikelihood.UNLIKELY,  # 'j'
        46: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.LIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        4: SequenceLikelihood.UNLIKELY,  # 'r'
        11: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        48: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        62: SequenceLikelihood.NEGATIVE,  # 'Â'
        47: SequenceLikelihood.NEGATIVE,  # 'Î'
        27: SequenceLikelihood.NEGATIVE,  # 'â'
        21: SequenceLikelihood.NEGATIVE,  # 'î'
        57: SequenceLikelihood.NEGATIVE,  # 'Ă'
        15: SequenceLikelihood.NEGATIVE,  # 'ă'
        55: SequenceLikelihood.NEGATIVE,  # 'Ș'
        23: SequenceLikelihood.NEGATIVE,  # 'ș'
        59: SequenceLikelihood.NEGATIVE,  # 'Ț'
        22: SequenceLikelihood.NEGATIVE,  # 'ț'
    },
    53: {  # 'Z'
        25: SequenceLikelihood.LIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.LIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.LIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        38: SequenceLikelihood.UNLIKELY,  # 'N'
        41: SequenceLikelihood.UNLIKELY,  # 'O'
        29: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        44: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.LIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        8: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.LIKELY,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        19: SequenceLikelihood.UNLIKELY,  # 'g'
        24: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        33: SequenceLikelihood.UNLIKELY,  # 'j'
        46: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.LIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        4: SequenceLikelihood.UNLIKELY,  # 'r'
        11: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        48: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        62: SequenceLikelihood.UNLIKELY,  # 'Â'
        47: SequenceLikelihood.UNLIKELY,  # 'Î'
        27: SequenceLikelihood.UNLIKELY,  # 'â'
        21: SequenceLikelihood.UNLIKELY,  # 'î'
        57: SequenceLikelihood.UNLIKELY,  # 'Ă'
        15: SequenceLikelihood.UNLIKELY,  # 'ă'
        55: SequenceLikelihood.NEGATIVE,  # 'Ș'
        23: SequenceLikelihood.NEGATIVE,  # 'ș'
        59: SequenceLikelihood.NEGATIVE,  # 'Ț'
        22: SequenceLikelihood.NEGATIVE,  # 'ț'
    },
    3: {  # 'a'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        38: SequenceLikelihood.UNLIKELY,  # 'N'
        41: SequenceLikelihood.UNLIKELY,  # 'O'
        29: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        44: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.LIKELY,  # 'a'
        18: SequenceLikelihood.POSITIVE,  # 'b'
        8: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.POSITIVE,  # 'f'
        19: SequenceLikelihood.POSITIVE,  # 'g'
        24: SequenceLikelihood.POSITIVE,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        33: SequenceLikelihood.POSITIVE,  # 'j'
        46: SequenceLikelihood.POSITIVE,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        6: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.LIKELY,  # 'o'
        13: SequenceLikelihood.POSITIVE,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        4: SequenceLikelihood.POSITIVE,  # 'r'
        11: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        49: SequenceLikelihood.LIKELY,  # 'w'
        36: SequenceLikelihood.POSITIVE,  # 'x'
        48: SequenceLikelihood.POSITIVE,  # 'y'
        20: SequenceLikelihood.POSITIVE,  # 'z'
        62: SequenceLikelihood.UNLIKELY,  # 'Â'
        47: SequenceLikelihood.UNLIKELY,  # 'Î'
        27: SequenceLikelihood.UNLIKELY,  # 'â'
        21: SequenceLikelihood.UNLIKELY,  # 'î'
        57: SequenceLikelihood.UNLIKELY,  # 'Ă'
        15: SequenceLikelihood.UNLIKELY,  # 'ă'
        55: SequenceLikelihood.UNLIKELY,  # 'Ș'
        23: SequenceLikelihood.POSITIVE,  # 'ș'
        59: SequenceLikelihood.UNLIKELY,  # 'Ț'
        22: SequenceLikelihood.POSITIVE,  # 'ț'
    },
    18: {  # 'b'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        38: SequenceLikelihood.UNLIKELY,  # 'N'
        41: SequenceLikelihood.UNLIKELY,  # 'O'
        29: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        44: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.LIKELY,  # 'b'
        8: SequenceLikelihood.LIKELY,  # 'c'
        12: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        19: SequenceLikelihood.UNLIKELY,  # 'g'
        24: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        33: SequenceLikelihood.UNLIKELY,  # 'j'
        46: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        4: SequenceLikelihood.POSITIVE,  # 'r'
        11: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.LIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.LIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        48: SequenceLikelihood.LIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        62: SequenceLikelihood.NEGATIVE,  # 'Â'
        47: SequenceLikelihood.NEGATIVE,  # 'Î'
        27: SequenceLikelihood.LIKELY,  # 'â'
        21: SequenceLikelihood.UNLIKELY,  # 'î'
        57: SequenceLikelihood.UNLIKELY,  # 'Ă'
        15: SequenceLikelihood.POSITIVE,  # 'ă'
        55: SequenceLikelihood.NEGATIVE,  # 'Ș'
        23: SequenceLikelihood.UNLIKELY,  # 'ș'
        59: SequenceLikelihood.NEGATIVE,  # 'Ț'
        22: SequenceLikelihood.LIKELY,  # 'ț'
    },
    8: {  # 'c'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        38: SequenceLikelihood.UNLIKELY,  # 'N'
        41: SequenceLikelihood.UNLIKELY,  # 'O'
        29: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        44: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        8: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        19: SequenceLikelihood.UNLIKELY,  # 'g'
        24: SequenceLikelihood.POSITIVE,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        33: SequenceLikelihood.UNLIKELY,  # 'j'
        46: SequenceLikelihood.POSITIVE,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        6: SequenceLikelihood.LIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        4: SequenceLikelihood.POSITIVE,  # 'r'
        11: SequenceLikelihood.LIKELY,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        48: SequenceLikelihood.LIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        62: SequenceLikelihood.UNLIKELY,  # 'Â'
        47: SequenceLikelihood.UNLIKELY,  # 'Î'
        27: SequenceLikelihood.POSITIVE,  # 'â'
        21: SequenceLikelihood.LIKELY,  # 'î'
        57: SequenceLikelihood.UNLIKELY,  # 'Ă'
        15: SequenceLikelihood.POSITIVE,  # 'ă'
        55: SequenceLikelihood.NEGATIVE,  # 'Ș'
        23: SequenceLikelihood.UNLIKELY,  # 'ș'
        59: SequenceLikelihood.NEGATIVE,  # 'Ț'
        22: SequenceLikelihood.POSITIVE,  # 'ț'
    },
    12: {  # 'd'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        38: SequenceLikelihood.UNLIKELY,  # 'N'
        41: SequenceLikelihood.UNLIKELY,  # 'O'
        29: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        44: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.LIKELY,  # 'b'
        8: SequenceLikelihood.LIKELY,  # 'c'
        12: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        19: SequenceLikelihood.LIKELY,  # 'g'
        24: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        33: SequenceLikelihood.LIKELY,  # 'j'
        46: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        6: SequenceLikelihood.LIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        4: SequenceLikelihood.POSITIVE,  # 'r'
        11: SequenceLikelihood.LIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        49: SequenceLikelihood.LIKELY,  # 'w'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        48: SequenceLikelihood.LIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        62: SequenceLikelihood.NEGATIVE,  # 'Â'
        47: SequenceLikelihood.UNLIKELY,  # 'Î'
        27: SequenceLikelihood.LIKELY,  # 'â'
        21: SequenceLikelihood.UNLIKELY,  # 'î'
        57: SequenceLikelihood.UNLIKELY,  # 'Ă'
        15: SequenceLikelihood.POSITIVE,  # 'ă'
        55: SequenceLikelihood.NEGATIVE,  # 'Ș'
        23: SequenceLikelihood.UNLIKELY,  # 'ș'
        59: SequenceLikelihood.UNLIKELY,  # 'Ț'
        22: SequenceLikelihood.UNLIKELY,  # 'ț'
    },
    1: {  # 'e'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        38: SequenceLikelihood.UNLIKELY,  # 'N'
        41: SequenceLikelihood.UNLIKELY,  # 'O'
        29: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        44: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.POSITIVE,  # 'b'
        8: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.POSITIVE,  # 'f'
        19: SequenceLikelihood.POSITIVE,  # 'g'
        24: SequenceLikelihood.POSITIVE,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        33: SequenceLikelihood.POSITIVE,  # 'j'
        46: SequenceLikelihood.LIKELY,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        6: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.POSITIVE,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        4: SequenceLikelihood.POSITIVE,  # 'r'
        11: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        49: SequenceLikelihood.POSITIVE,  # 'w'
        36: SequenceLikelihood.POSITIVE,  # 'x'
        48: SequenceLikelihood.LIKELY,  # 'y'
        20: SequenceLikelihood.POSITIVE,  # 'z'
        62: SequenceLikelihood.UNLIKELY,  # 'Â'
        47: SequenceLikelihood.UNLIKELY,  # 'Î'
        27: SequenceLikelihood.UNLIKELY,  # 'â'
        21: SequenceLikelihood.LIKELY,  # 'î'
        57: SequenceLikelihood.NEGATIVE,  # 'Ă'
        15: SequenceLikelihood.UNLIKELY,  # 'ă'
        55: SequenceLikelihood.UNLIKELY,  # 'Ș'
        23: SequenceLikelihood.POSITIVE,  # 'ș'
        59: SequenceLikelihood.UNLIKELY,  # 'Ț'
        22: SequenceLikelihood.POSITIVE,  # 'ț'
    },
    17: {  # 'f'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        38: SequenceLikelihood.UNLIKELY,  # 'N'
        41: SequenceLikelihood.UNLIKELY,  # 'O'
        29: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        44: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        8: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.LIKELY,  # 'f'
        19: SequenceLikelihood.UNLIKELY,  # 'g'
        24: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        33: SequenceLikelihood.UNLIKELY,  # 'j'
        46: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        4: SequenceLikelihood.POSITIVE,  # 'r'
        11: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        48: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        62: SequenceLikelihood.UNLIKELY,  # 'Â'
        47: SequenceLikelihood.NEGATIVE,  # 'Î'
        27: SequenceLikelihood.POSITIVE,  # 'â'
        21: SequenceLikelihood.UNLIKELY,  # 'î'
        57: SequenceLikelihood.UNLIKELY,  # 'Ă'
        15: SequenceLikelihood.POSITIVE,  # 'ă'
        55: SequenceLikelihood.NEGATIVE,  # 'Ș'
        23: SequenceLikelihood.UNLIKELY,  # 'ș'
        59: SequenceLikelihood.NEGATIVE,  # 'Ț'
        22: SequenceLikelihood.UNLIKELY,  # 'ț'
    },
    19: {  # 'g'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        38: SequenceLikelihood.UNLIKELY,  # 'N'
        41: SequenceLikelihood.UNLIKELY,  # 'O'
        29: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        44: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        8: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        19: SequenceLikelihood.LIKELY,  # 'g'
        24: SequenceLikelihood.POSITIVE,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        33: SequenceLikelihood.UNLIKELY,  # 'j'
        46: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        6: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        4: SequenceLikelihood.POSITIVE,  # 'r'
        11: SequenceLikelihood.LIKELY,  # 's'
        5: SequenceLikelihood.LIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.LIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        48: SequenceLikelihood.LIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        62: SequenceLikelihood.NEGATIVE,  # 'Â'
        47: SequenceLikelihood.NEGATIVE,  # 'Î'
        27: SequenceLikelihood.POSITIVE,  # 'â'
        21: SequenceLikelihood.UNLIKELY,  # 'î'
        57: SequenceLikelihood.UNLIKELY,  # 'Ă'
        15: SequenceLikelihood.POSITIVE,  # 'ă'
        55: SequenceLikelihood.NEGATIVE,  # 'Ș'
        23: SequenceLikelihood.UNLIKELY,  # 'ș'
        59: SequenceLikelihood.NEGATIVE,  # 'Ț'
        22: SequenceLikelihood.UNLIKELY,  # 'ț'
    },
    24: {  # 'h'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        38: SequenceLikelihood.UNLIKELY,  # 'N'
        41: SequenceLikelihood.UNLIKELY,  # 'O'
        29: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        44: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        8: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        19: SequenceLikelihood.UNLIKELY,  # 'g'
        24: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        33: SequenceLikelihood.UNLIKELY,  # 'j'
        46: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        6: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.LIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        4: SequenceLikelihood.LIKELY,  # 'r'
        11: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        48: SequenceLikelihood.LIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        62: SequenceLikelihood.NEGATIVE,  # 'Â'
        47: SequenceLikelihood.NEGATIVE,  # 'Î'
        27: SequenceLikelihood.LIKELY,  # 'â'
        21: SequenceLikelihood.UNLIKELY,  # 'î'
        57: SequenceLikelihood.UNLIKELY,  # 'Ă'
        15: SequenceLikelihood.LIKELY,  # 'ă'
        55: SequenceLikelihood.NEGATIVE,  # 'Ș'
        23: SequenceLikelihood.UNLIKELY,  # 'ș'
        59: SequenceLikelihood.NEGATIVE,  # 'Ț'
        22: SequenceLikelihood.UNLIKELY,  # 'ț'
    },
    2: {  # 'i'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        38: SequenceLikelihood.UNLIKELY,  # 'N'
        41: SequenceLikelihood.UNLIKELY,  # 'O'
        29: SequenceLikelihood.LIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        44: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.POSITIVE,  # 'b'
        8: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.POSITIVE,  # 'f'
        19: SequenceLikelihood.POSITIVE,  # 'g'
        24: SequenceLikelihood.POSITIVE,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        33: SequenceLikelihood.POSITIVE,  # 'j'
        46: SequenceLikelihood.LIKELY,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        6: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.POSITIVE,  # 'p'
        60: SequenceLikelihood.LIKELY,  # 'q'
        4: SequenceLikelihood.POSITIVE,  # 'r'
        11: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        36: SequenceLikelihood.LIKELY,  # 'x'
        48: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.POSITIVE,  # 'z'
        62: SequenceLikelihood.NEGATIVE,  # 'Â'
        47: SequenceLikelihood.UNLIKELY,  # 'Î'
        27: SequenceLikelihood.UNLIKELY,  # 'â'
        21: SequenceLikelihood.UNLIKELY,  # 'î'
        57: SequenceLikelihood.NEGATIVE,  # 'Ă'
        15: SequenceLikelihood.UNLIKELY,  # 'ă'
        55: SequenceLikelihood.UNLIKELY,  # 'Ș'
        23: SequenceLikelihood.POSITIVE,  # 'ș'
        59: SequenceLikelihood.UNLIKELY,  # 'Ț'
        22: SequenceLikelihood.POSITIVE,  # 'ț'
    },
    33: {  # 'j'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        38: SequenceLikelihood.UNLIKELY,  # 'N'
        41: SequenceLikelihood.UNLIKELY,  # 'O'
        29: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        44: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.LIKELY,  # 'b'
        8: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        19: SequenceLikelihood.UNLIKELY,  # 'g'
        24: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        33: SequenceLikelihood.UNLIKELY,  # 'j'
        46: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        4: SequenceLikelihood.UNLIKELY,  # 'r'
        11: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        48: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        62: SequenceLikelihood.NEGATIVE,  # 'Â'
        47: SequenceLikelihood.NEGATIVE,  # 'Î'
        27: SequenceLikelihood.UNLIKELY,  # 'â'
        21: SequenceLikelihood.UNLIKELY,  # 'î'
        57: SequenceLikelihood.NEGATIVE,  # 'Ă'
        15: SequenceLikelihood.LIKELY,  # 'ă'
        55: SequenceLikelihood.NEGATIVE,  # 'Ș'
        23: SequenceLikelihood.UNLIKELY,  # 'ș'
        59: SequenceLikelihood.NEGATIVE,  # 'Ț'
        22: SequenceLikelihood.UNLIKELY,  # 'ț'
    },
    46: {  # 'k'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        38: SequenceLikelihood.UNLIKELY,  # 'N'
        41: SequenceLikelihood.UNLIKELY,  # 'O'
        29: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        44: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.LIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        8: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        19: SequenceLikelihood.LIKELY,  # 'g'
        24: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        33: SequenceLikelihood.UNLIKELY,  # 'j'
        46: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.LIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        4: SequenceLikelihood.LIKELY,  # 'r'
        11: SequenceLikelihood.LIKELY,  # 's'
        5: SequenceLikelihood.LIKELY,  # 't'
        7: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        48: SequenceLikelihood.LIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        62: SequenceLikelihood.NEGATIVE,  # 'Â'
        47: SequenceLikelihood.UNLIKELY,  # 'Î'
        27: SequenceLikelihood.UNLIKELY,  # 'â'
        21: SequenceLikelihood.UNLIKELY,  # 'î'
        57: SequenceLikelihood.NEGATIVE,  # 'Ă'
        15: SequenceLikelihood.UNLIKELY,  # 'ă'
        55: SequenceLikelihood.UNLIKELY,  # 'Ș'
        23: SequenceLikelihood.UNLIKELY,  # 'ș'
        59: SequenceLikelihood.NEGATIVE,  # 'Ț'
        22: SequenceLikelihood.UNLIKELY,  # 'ț'
    },
    9: {  # 'l'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        38: SequenceLikelihood.UNLIKELY,  # 'N'
        41: SequenceLikelihood.UNLIKELY,  # 'O'
        29: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        44: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.POSITIVE,  # 'b'
        8: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.LIKELY,  # 'f'
        19: SequenceLikelihood.POSITIVE,  # 'g'
        24: SequenceLikelihood.LIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        33: SequenceLikelihood.UNLIKELY,  # 'j'
        46: SequenceLikelihood.LIKELY,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        6: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.LIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        4: SequenceLikelihood.UNLIKELY,  # 'r'
        11: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        48: SequenceLikelihood.POSITIVE,  # 'y'
        20: SequenceLikelihood.LIKELY,  # 'z'
        62: SequenceLikelihood.NEGATIVE,  # 'Â'
        47: SequenceLikelihood.UNLIKELY,  # 'Î'
        27: SequenceLikelihood.POSITIVE,  # 'â'
        21: SequenceLikelihood.UNLIKELY,  # 'î'
        57: SequenceLikelihood.UNLIKELY,  # 'Ă'
        15: SequenceLikelihood.POSITIVE,  # 'ă'
        55: SequenceLikelihood.UNLIKELY,  # 'Ș'
        23: SequenceLikelihood.UNLIKELY,  # 'ș'
        59: SequenceLikelihood.UNLIKELY,  # 'Ț'
        22: SequenceLikelihood.POSITIVE,  # 'ț'
    },
    14: {  # 'm'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        38: SequenceLikelihood.UNLIKELY,  # 'N'
        41: SequenceLikelihood.UNLIKELY,  # 'O'
        29: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        44: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.POSITIVE,  # 'b'
        8: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.LIKELY,  # 'f'
        19: SequenceLikelihood.LIKELY,  # 'g'
        24: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        33: SequenceLikelihood.UNLIKELY,  # 'j'
        46: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        6: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.POSITIVE,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        4: SequenceLikelihood.UNLIKELY,  # 'r'
        11: SequenceLikelihood.LIKELY,  # 's'
        5: SequenceLikelihood.LIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.LIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        48: SequenceLikelihood.LIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        62: SequenceLikelihood.UNLIKELY,  # 'Â'
        47: SequenceLikelihood.UNLIKELY,  # 'Î'
        27: SequenceLikelihood.POSITIVE,  # 'â'
        21: SequenceLikelihood.LIKELY,  # 'î'
        57: SequenceLikelihood.UNLIKELY,  # 'Ă'
        15: SequenceLikelihood.POSITIVE,  # 'ă'
        55: SequenceLikelihood.NEGATIVE,  # 'Ș'
        23: SequenceLikelihood.UNLIKELY,  # 'ș'
        59: SequenceLikelihood.UNLIKELY,  # 'Ț'
        22: SequenceLikelihood.LIKELY,  # 'ț'
    },
    6: {  # 'n'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        38: SequenceLikelihood.UNLIKELY,  # 'N'
        41: SequenceLikelihood.UNLIKELY,  # 'O'
        29: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        44: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.LIKELY,  # 'b'
        8: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.POSITIVE,  # 'f'
        19: SequenceLikelihood.POSITIVE,  # 'g'
        24: SequenceLikelihood.LIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        33: SequenceLikelihood.POSITIVE,  # 'j'
        46: SequenceLikelihood.POSITIVE,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        6: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.LIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        4: SequenceLikelihood.POSITIVE,  # 'r'
        11: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        36: SequenceLikelihood.LIKELY,  # 'x'
        48: SequenceLikelihood.LIKELY,  # 'y'
        20: SequenceLikelihood.POSITIVE,  # 'z'
        62: SequenceLikelihood.UNLIKELY,  # 'Â'
        47: SequenceLikelihood.UNLIKELY,  # 'Î'
        27: SequenceLikelihood.LIKELY,  # 'â'
        21: SequenceLikelihood.UNLIKELY,  # 'î'
        57: SequenceLikelihood.UNLIKELY,  # 'Ă'
        15: SequenceLikelihood.POSITIVE,  # 'ă'
        55: SequenceLikelihood.UNLIKELY,  # 'Ș'
        23: SequenceLikelihood.LIKELY,  # 'ș'
        59: SequenceLikelihood.UNLIKELY,  # 'Ț'
        22: SequenceLikelihood.POSITIVE,  # 'ț'
    },
    10: {  # 'o'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        38: SequenceLikelihood.UNLIKELY,  # 'N'
        41: SequenceLikelihood.UNLIKELY,  # 'O'
        29: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        44: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.POSITIVE,  # 'b'
        8: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.POSITIVE,  # 'f'
        19: SequenceLikelihood.POSITIVE,  # 'g'
        24: SequenceLikelihood.POSITIVE,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        33: SequenceLikelihood.LIKELY,  # 'j'
        46: SequenceLikelihood.POSITIVE,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        6: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.POSITIVE,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        4: SequenceLikelihood.POSITIVE,  # 'r'
        11: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        49: SequenceLikelihood.POSITIVE,  # 'w'
        36: SequenceLikelihood.POSITIVE,  # 'x'
        48: SequenceLikelihood.LIKELY,  # 'y'
        20: SequenceLikelihood.POSITIVE,  # 'z'
        62: SequenceLikelihood.UNLIKELY,  # 'Â'
        47: SequenceLikelihood.UNLIKELY,  # 'Î'
        27: SequenceLikelihood.UNLIKELY,  # 'â'
        21: SequenceLikelihood.UNLIKELY,  # 'î'
        57: SequenceLikelihood.UNLIKELY,  # 'Ă'
        15: SequenceLikelihood.UNLIKELY,  # 'ă'
        55: SequenceLikelihood.UNLIKELY,  # 'Ș'
        23: SequenceLikelihood.POSITIVE,  # 'ș'
        59: SequenceLikelihood.NEGATIVE,  # 'Ț'
        22: SequenceLikelihood.POSITIVE,  # 'ț'
    },
    13: {  # 'p'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        38: SequenceLikelihood.UNLIKELY,  # 'N'
        41: SequenceLikelihood.UNLIKELY,  # 'O'
        29: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        44: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        8: SequenceLikelihood.LIKELY,  # 'c'
        12: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        19: SequenceLikelihood.UNLIKELY,  # 'g'
        24: SequenceLikelihood.LIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        33: SequenceLikelihood.UNLIKELY,  # 'j'
        46: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        6: SequenceLikelihood.LIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.LIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        4: SequenceLikelihood.POSITIVE,  # 'r'
        11: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        48: SequenceLikelihood.LIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        62: SequenceLikelihood.UNLIKELY,  # 'Â'
        47: SequenceLikelihood.UNLIKELY,  # 'Î'
        27: SequenceLikelihood.POSITIVE,  # 'â'
        21: SequenceLikelihood.LIKELY,  # 'î'
        57: SequenceLikelihood.UNLIKELY,  # 'Ă'
        15: SequenceLikelihood.POSITIVE,  # 'ă'
        55: SequenceLikelihood.UNLIKELY,  # 'Ș'
        23: SequenceLikelihood.UNLIKELY,  # 'ș'
        59: SequenceLikelihood.NEGATIVE,  # 'Ț'
        22: SequenceLikelihood.POSITIVE,  # 'ț'
    },
    60: {  # 'q'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        38: SequenceLikelihood.UNLIKELY,  # 'N'
        41: SequenceLikelihood.UNLIKELY,  # 'O'
        29: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        44: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        8: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        19: SequenceLikelihood.UNLIKELY,  # 'g'
        24: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.UNLIKELY,  # 'i'
        33: SequenceLikelihood.UNLIKELY,  # 'j'
        46: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        4: SequenceLikelihood.UNLIKELY,  # 'r'
        11: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        48: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        62: SequenceLikelihood.NEGATIVE,  # 'Â'
        47: SequenceLikelihood.NEGATIVE,  # 'Î'
        27: SequenceLikelihood.NEGATIVE,  # 'â'
        21: SequenceLikelihood.UNLIKELY,  # 'î'
        57: SequenceLikelihood.NEGATIVE,  # 'Ă'
        15: SequenceLikelihood.UNLIKELY,  # 'ă'
        55: SequenceLikelihood.NEGATIVE,  # 'Ș'
        23: SequenceLikelihood.NEGATIVE,  # 'ș'
        59: SequenceLikelihood.NEGATIVE,  # 'Ț'
        22: SequenceLikelihood.NEGATIVE,  # 'ț'
    },
    4: {  # 'r'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        38: SequenceLikelihood.UNLIKELY,  # 'N'
        41: SequenceLikelihood.UNLIKELY,  # 'O'
        29: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        44: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.POSITIVE,  # 'b'
        8: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.POSITIVE,  # 'f'
        19: SequenceLikelihood.POSITIVE,  # 'g'
        24: SequenceLikelihood.POSITIVE,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        33: SequenceLikelihood.LIKELY,  # 'j'
        46: SequenceLikelihood.POSITIVE,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        6: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.POSITIVE,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        4: SequenceLikelihood.LIKELY,  # 'r'
        11: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        48: SequenceLikelihood.POSITIVE,  # 'y'
        20: SequenceLikelihood.POSITIVE,  # 'z'
        62: SequenceLikelihood.NEGATIVE,  # 'Â'
        47: SequenceLikelihood.UNLIKELY,  # 'Î'
        27: SequenceLikelihood.POSITIVE,  # 'â'
        21: SequenceLikelihood.LIKELY,  # 'î'
        57: SequenceLikelihood.UNLIKELY,  # 'Ă'
        15: SequenceLikelihood.POSITIVE,  # 'ă'
        55: SequenceLikelihood.UNLIKELY,  # 'Ș'
        23: SequenceLikelihood.LIKELY,  # 'ș'
        59: SequenceLikelihood.UNLIKELY,  # 'Ț'
        22: SequenceLikelihood.POSITIVE,  # 'ț'
    },
    11: {  # 's'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        38: SequenceLikelihood.UNLIKELY,  # 'N'
        41: SequenceLikelihood.UNLIKELY,  # 'O'
        29: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        44: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.LIKELY,  # 'b'
        8: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.POSITIVE,  # 'f'
        19: SequenceLikelihood.UNLIKELY,  # 'g'
        24: SequenceLikelihood.POSITIVE,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        33: SequenceLikelihood.UNLIKELY,  # 'j'
        46: SequenceLikelihood.LIKELY,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        6: SequenceLikelihood.LIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.POSITIVE,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        4: SequenceLikelihood.LIKELY,  # 'r'
        11: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.LIKELY,  # 'w'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        48: SequenceLikelihood.LIKELY,  # 'y'
        20: SequenceLikelihood.LIKELY,  # 'z'
        62: SequenceLikelihood.UNLIKELY,  # 'Â'
        47: SequenceLikelihood.UNLIKELY,  # 'Î'
        27: SequenceLikelihood.POSITIVE,  # 'â'
        21: SequenceLikelihood.LIKELY,  # 'î'
        57: SequenceLikelihood.UNLIKELY,  # 'Ă'
        15: SequenceLikelihood.POSITIVE,  # 'ă'
        55: SequenceLikelihood.UNLIKELY,  # 'Ș'
        23: SequenceLikelihood.UNLIKELY,  # 'ș'
        59: SequenceLikelihood.NEGATIVE,  # 'Ț'
        22: SequenceLikelihood.LIKELY,  # 'ț'
    },
    5: {  # 't'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        38: SequenceLikelihood.UNLIKELY,  # 'N'
        41: SequenceLikelihood.UNLIKELY,  # 'O'
        29: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        44: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.LIKELY,  # 'b'
        8: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.POSITIVE,  # 'f'
        19: SequenceLikelihood.UNLIKELY,  # 'g'
        24: SequenceLikelihood.POSITIVE,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        33: SequenceLikelihood.UNLIKELY,  # 'j'
        46: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        6: SequenceLikelihood.LIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.LIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        4: SequenceLikelihood.POSITIVE,  # 'r'
        11: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.LIKELY,  # 'v'
        49: SequenceLikelihood.LIKELY,  # 'w'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        48: SequenceLikelihood.LIKELY,  # 'y'
        20: SequenceLikelihood.LIKELY,  # 'z'
        62: SequenceLikelihood.UNLIKELY,  # 'Â'
        47: SequenceLikelihood.UNLIKELY,  # 'Î'
        27: SequenceLikelihood.POSITIVE,  # 'â'
        21: SequenceLikelihood.LIKELY,  # 'î'
        57: SequenceLikelihood.UNLIKELY,  # 'Ă'
        15: SequenceLikelihood.POSITIVE,  # 'ă'
        55: SequenceLikelihood.UNLIKELY,  # 'Ș'
        23: SequenceLikelihood.UNLIKELY,  # 'ș'
        59: SequenceLikelihood.UNLIKELY,  # 'Ț'
        22: SequenceLikelihood.UNLIKELY,  # 'ț'
    },
    7: {  # 'u'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        38: SequenceLikelihood.UNLIKELY,  # 'N'
        41: SequenceLikelihood.UNLIKELY,  # 'O'
        29: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        44: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.POSITIVE,  # 'b'
        8: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.POSITIVE,  # 'f'
        19: SequenceLikelihood.POSITIVE,  # 'g'
        24: SequenceLikelihood.LIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        33: SequenceLikelihood.POSITIVE,  # 'j'
        46: SequenceLikelihood.LIKELY,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        6: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.LIKELY,  # 'o'
        13: SequenceLikelihood.POSITIVE,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        4: SequenceLikelihood.POSITIVE,  # 'r'
        11: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        36: SequenceLikelihood.LIKELY,  # 'x'
        48: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.POSITIVE,  # 'z'
        62: SequenceLikelihood.UNLIKELY,  # 'Â'
        47: SequenceLikelihood.UNLIKELY,  # 'Î'
        27: SequenceLikelihood.LIKELY,  # 'â'
        21: SequenceLikelihood.UNLIKELY,  # 'î'
        57: SequenceLikelihood.UNLIKELY,  # 'Ă'
        15: SequenceLikelihood.POSITIVE,  # 'ă'
        55: SequenceLikelihood.UNLIKELY,  # 'Ș'
        23: SequenceLikelihood.POSITIVE,  # 'ș'
        59: SequenceLikelihood.UNLIKELY,  # 'Ț'
        22: SequenceLikelihood.POSITIVE,  # 'ț'
    },
    16: {  # 'v'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        38: SequenceLikelihood.UNLIKELY,  # 'N'
        41: SequenceLikelihood.UNLIKELY,  # 'O'
        29: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        44: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        8: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        19: SequenceLikelihood.UNLIKELY,  # 'g'
        24: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        33: SequenceLikelihood.UNLIKELY,  # 'j'
        46: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.LIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        4: SequenceLikelihood.POSITIVE,  # 'r'
        11: SequenceLikelihood.LIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        48: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        62: SequenceLikelihood.UNLIKELY,  # 'Â'
        47: SequenceLikelihood.UNLIKELY,  # 'Î'
        27: SequenceLikelihood.POSITIVE,  # 'â'
        21: SequenceLikelihood.LIKELY,  # 'î'
        57: SequenceLikelihood.UNLIKELY,  # 'Ă'
        15: SequenceLikelihood.POSITIVE,  # 'ă'
        55: SequenceLikelihood.UNLIKELY,  # 'Ș'
        23: SequenceLikelihood.UNLIKELY,  # 'ș'
        59: SequenceLikelihood.NEGATIVE,  # 'Ț'
        22: SequenceLikelihood.UNLIKELY,  # 'ț'
    },
    49: {  # 'w'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        38: SequenceLikelihood.UNLIKELY,  # 'N'
        41: SequenceLikelihood.UNLIKELY,  # 'O'
        29: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        44: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        8: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        19: SequenceLikelihood.UNLIKELY,  # 'g'
        24: SequenceLikelihood.LIKELY,  # 'h'
        2: SequenceLikelihood.LIKELY,  # 'i'
        33: SequenceLikelihood.UNLIKELY,  # 'j'
        46: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.LIKELY,  # 'n'
        10: SequenceLikelihood.LIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        4: SequenceLikelihood.UNLIKELY,  # 'r'
        11: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.POSITIVE,  # 'w'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        48: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        62: SequenceLikelihood.NEGATIVE,  # 'Â'
        47: SequenceLikelihood.NEGATIVE,  # 'Î'
        27: SequenceLikelihood.UNLIKELY,  # 'â'
        21: SequenceLikelihood.UNLIKELY,  # 'î'
        57: SequenceLikelihood.NEGATIVE,  # 'Ă'
        15: SequenceLikelihood.NEGATIVE,  # 'ă'
        55: SequenceLikelihood.UNLIKELY,  # 'Ș'
        23: SequenceLikelihood.NEGATIVE,  # 'ș'
        59: SequenceLikelihood.NEGATIVE,  # 'Ț'
        22: SequenceLikelihood.NEGATIVE,  # 'ț'
    },
    36: {  # 'x'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        38: SequenceLikelihood.UNLIKELY,  # 'N'
        41: SequenceLikelihood.UNLIKELY,  # 'O'
        29: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        44: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        8: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        19: SequenceLikelihood.UNLIKELY,  # 'g'
        24: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        33: SequenceLikelihood.UNLIKELY,  # 'j'
        46: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.LIKELY,  # 'o'
        13: SequenceLikelihood.POSITIVE,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        4: SequenceLikelihood.UNLIKELY,  # 'r'
        11: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        48: SequenceLikelihood.LIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        62: SequenceLikelihood.NEGATIVE,  # 'Â'
        47: SequenceLikelihood.UNLIKELY,  # 'Î'
        27: SequenceLikelihood.UNLIKELY,  # 'â'
        21: SequenceLikelihood.UNLIKELY,  # 'î'
        57: SequenceLikelihood.NEGATIVE,  # 'Ă'
        15: SequenceLikelihood.LIKELY,  # 'ă'
        55: SequenceLikelihood.NEGATIVE,  # 'Ș'
        23: SequenceLikelihood.UNLIKELY,  # 'ș'
        59: SequenceLikelihood.NEGATIVE,  # 'Ț'
        22: SequenceLikelihood.NEGATIVE,  # 'ț'
    },
    48: {  # 'y'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        38: SequenceLikelihood.UNLIKELY,  # 'N'
        41: SequenceLikelihood.UNLIKELY,  # 'O'
        29: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        44: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.LIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        8: SequenceLikelihood.LIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.LIKELY,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        19: SequenceLikelihood.UNLIKELY,  # 'g'
        24: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.LIKELY,  # 'i'
        33: SequenceLikelihood.UNLIKELY,  # 'j'
        46: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        6: SequenceLikelihood.LIKELY,  # 'n'
        10: SequenceLikelihood.LIKELY,  # 'o'
        13: SequenceLikelihood.LIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        4: SequenceLikelihood.LIKELY,  # 'r'
        11: SequenceLikelihood.LIKELY,  # 's'
        5: SequenceLikelihood.LIKELY,  # 't'
        7: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        48: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        62: SequenceLikelihood.NEGATIVE,  # 'Â'
        47: SequenceLikelihood.UNLIKELY,  # 'Î'
        27: SequenceLikelihood.UNLIKELY,  # 'â'
        21: SequenceLikelihood.UNLIKELY,  # 'î'
        57: SequenceLikelihood.NEGATIVE,  # 'Ă'
        15: SequenceLikelihood.UNLIKELY,  # 'ă'
        55: SequenceLikelihood.NEGATIVE,  # 'Ș'
        23: SequenceLikelihood.UNLIKELY,  # 'ș'
        59: SequenceLikelihood.NEGATIVE,  # 'Ț'
        22: SequenceLikelihood.NEGATIVE,  # 'ț'
    },
    20: {  # 'z'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        38: SequenceLikelihood.UNLIKELY,  # 'N'
        41: SequenceLikelihood.UNLIKELY,  # 'O'
        29: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        44: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.POSITIVE,  # 'b'
        8: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        19: SequenceLikelihood.LIKELY,  # 'g'
        24: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        33: SequenceLikelihood.UNLIKELY,  # 'j'
        46: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        6: SequenceLikelihood.LIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        4: SequenceLikelihood.UNLIKELY,  # 'r'
        11: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        48: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.LIKELY,  # 'z'
        62: SequenceLikelihood.NEGATIVE,  # 'Â'
        47: SequenceLikelihood.NEGATIVE,  # 'Î'
        27: SequenceLikelihood.LIKELY,  # 'â'
        21: SequenceLikelihood.UNLIKELY,  # 'î'
        57: SequenceLikelihood.UNLIKELY,  # 'Ă'
        15: SequenceLikelihood.POSITIVE,  # 'ă'
        55: SequenceLikelihood.NEGATIVE,  # 'Ș'
        23: SequenceLikelihood.UNLIKELY,  # 'ș'
        59: SequenceLikelihood.NEGATIVE,  # 'Ț'
        22: SequenceLikelihood.UNLIKELY,  # 'ț'
    },
    62: {  # 'Â'
        25: SequenceLikelihood.NEGATIVE,  # 'A'
        39: SequenceLikelihood.NEGATIVE,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.NEGATIVE,  # 'E'
        43: SequenceLikelihood.NEGATIVE,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.NEGATIVE,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.NEGATIVE,  # 'J'
        52: SequenceLikelihood.NEGATIVE,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        38: SequenceLikelihood.LIKELY,  # 'N'
        41: SequenceLikelihood.NEGATIVE,  # 'O'
        29: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.NEGATIVE,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        44: SequenceLikelihood.NEGATIVE,  # 'V'
        54: SequenceLikelihood.NEGATIVE,  # 'W'
        56: SequenceLikelihood.NEGATIVE,  # 'X'
        58: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.NEGATIVE,  # 'a'
        18: SequenceLikelihood.NEGATIVE,  # 'b'
        8: SequenceLikelihood.NEGATIVE,  # 'c'
        12: SequenceLikelihood.NEGATIVE,  # 'd'
        1: SequenceLikelihood.NEGATIVE,  # 'e'
        17: SequenceLikelihood.NEGATIVE,  # 'f'
        19: SequenceLikelihood.NEGATIVE,  # 'g'
        24: SequenceLikelihood.NEGATIVE,  # 'h'
        2: SequenceLikelihood.UNLIKELY,  # 'i'
        33: SequenceLikelihood.NEGATIVE,  # 'j'
        46: SequenceLikelihood.NEGATIVE,  # 'k'
        9: SequenceLikelihood.NEGATIVE,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.NEGATIVE,  # 'o'
        13: SequenceLikelihood.NEGATIVE,  # 'p'
        60: SequenceLikelihood.NEGATIVE,  # 'q'
        4: SequenceLikelihood.UNLIKELY,  # 'r'
        11: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.NEGATIVE,  # 'u'
        16: SequenceLikelihood.NEGATIVE,  # 'v'
        49: SequenceLikelihood.NEGATIVE,  # 'w'
        36: SequenceLikelihood.NEGATIVE,  # 'x'
        48: SequenceLikelihood.NEGATIVE,  # 'y'
        20: SequenceLikelihood.NEGATIVE,  # 'z'
        62: SequenceLikelihood.UNLIKELY,  # 'Â'
        47: SequenceLikelihood.UNLIKELY,  # 'Î'
        27: SequenceLikelihood.NEGATIVE,  # 'â'
        21: SequenceLikelihood.NEGATIVE,  # 'î'
        57: SequenceLikelihood.NEGATIVE,  # 'Ă'
        15: SequenceLikelihood.NEGATIVE,  # 'ă'
        55: SequenceLikelihood.UNLIKELY,  # 'Ș'
        23: SequenceLikelihood.NEGATIVE,  # 'ș'
        59: SequenceLikelihood.UNLIKELY,  # 'Ț'
        22: SequenceLikelihood.NEGATIVE,  # 'ț'
    },
    47: {  # 'Î'
        25: SequenceLikelihood.NEGATIVE,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        38: SequenceLikelihood.LIKELY,  # 'N'
        41: SequenceLikelihood.NEGATIVE,  # 'O'
        29: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        44: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.NEGATIVE,  # 'W'
        56: SequenceLikelihood.NEGATIVE,  # 'X'
        58: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.NEGATIVE,  # 'b'
        8: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.NEGATIVE,  # 'e'
        17: SequenceLikelihood.NEGATIVE,  # 'f'
        19: SequenceLikelihood.UNLIKELY,  # 'g'
        24: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.UNLIKELY,  # 'i'
        33: SequenceLikelihood.NEGATIVE,  # 'j'
        46: SequenceLikelihood.NEGATIVE,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        6: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.NEGATIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.NEGATIVE,  # 'q'
        4: SequenceLikelihood.UNLIKELY,  # 'r'
        11: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.NEGATIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.NEGATIVE,  # 'w'
        36: SequenceLikelihood.NEGATIVE,  # 'x'
        48: SequenceLikelihood.NEGATIVE,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        62: SequenceLikelihood.NEGATIVE,  # 'Â'
        47: SequenceLikelihood.UNLIKELY,  # 'Î'
        27: SequenceLikelihood.NEGATIVE,  # 'â'
        21: SequenceLikelihood.UNLIKELY,  # 'î'
        57: SequenceLikelihood.NEGATIVE,  # 'Ă'
        15: SequenceLikelihood.UNLIKELY,  # 'ă'
        55: SequenceLikelihood.UNLIKELY,  # 'Ș'
        23: SequenceLikelihood.UNLIKELY,  # 'ș'
        59: SequenceLikelihood.UNLIKELY,  # 'Ț'
        22: SequenceLikelihood.UNLIKELY,  # 'ț'
    },
    27: {  # 'â'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.NEGATIVE,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.NEGATIVE,  # 'D'
        34: SequenceLikelihood.NEGATIVE,  # 'E'
        43: SequenceLikelihood.NEGATIVE,  # 'F'
        45: SequenceLikelihood.NEGATIVE,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.NEGATIVE,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        38: SequenceLikelihood.UNLIKELY,  # 'N'
        41: SequenceLikelihood.NEGATIVE,  # 'O'
        29: SequenceLikelihood.NEGATIVE,  # 'P'
        61: SequenceLikelihood.NEGATIVE,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.NEGATIVE,  # 'S'
        37: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        44: SequenceLikelihood.NEGATIVE,  # 'V'
        54: SequenceLikelihood.NEGATIVE,  # 'W'
        56: SequenceLikelihood.NEGATIVE,  # 'X'
        58: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        8: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        19: SequenceLikelihood.UNLIKELY,  # 'g'
        24: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        33: SequenceLikelihood.UNLIKELY,  # 'j'
        46: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        6: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        4: SequenceLikelihood.POSITIVE,  # 'r'
        11: SequenceLikelihood.LIKELY,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.NEGATIVE,  # 'w'
        36: SequenceLikelihood.NEGATIVE,  # 'x'
        48: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        62: SequenceLikelihood.NEGATIVE,  # 'Â'
        47: SequenceLikelihood.NEGATIVE,  # 'Î'
        27: SequenceLikelihood.UNLIKELY,  # 'â'
        21: SequenceLikelihood.UNLIKELY,  # 'î'
        57: SequenceLikelihood.NEGATIVE,  # 'Ă'
        15: SequenceLikelihood.UNLIKELY,  # 'ă'
        55: SequenceLikelihood.NEGATIVE,  # 'Ș'
        23: SequenceLikelihood.LIKELY,  # 'ș'
        59: SequenceLikelihood.NEGATIVE,  # 'Ț'
        22: SequenceLikelihood.LIKELY,  # 'ț'
    },
    21: {  # 'î'
        25: SequenceLikelihood.NEGATIVE,  # 'A'
        39: SequenceLikelihood.NEGATIVE,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.NEGATIVE,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.NEGATIVE,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.NEGATIVE,  # 'J'
        52: SequenceLikelihood.NEGATIVE,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.NEGATIVE,  # 'M'
        38: SequenceLikelihood.UNLIKELY,  # 'N'
        41: SequenceLikelihood.NEGATIVE,  # 'O'
        29: SequenceLikelihood.NEGATIVE,  # 'P'
        61: SequenceLikelihood.NEGATIVE,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.NEGATIVE,  # 'S'
        37: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        44: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.NEGATIVE,  # 'W'
        56: SequenceLikelihood.NEGATIVE,  # 'X'
        58: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        8: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        19: SequenceLikelihood.UNLIKELY,  # 'g'
        24: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        33: SequenceLikelihood.UNLIKELY,  # 'j'
        46: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        6: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.UNLIKELY,  # 'q'
        4: SequenceLikelihood.LIKELY,  # 'r'
        11: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.LIKELY,  # 't'
        7: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        36: SequenceLikelihood.NEGATIVE,  # 'x'
        48: SequenceLikelihood.NEGATIVE,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        62: SequenceLikelihood.NEGATIVE,  # 'Â'
        47: SequenceLikelihood.UNLIKELY,  # 'Î'
        27: SequenceLikelihood.UNLIKELY,  # 'â'
        21: SequenceLikelihood.UNLIKELY,  # 'î'
        57: SequenceLikelihood.NEGATIVE,  # 'Ă'
        15: SequenceLikelihood.UNLIKELY,  # 'ă'
        55: SequenceLikelihood.NEGATIVE,  # 'Ș'
        23: SequenceLikelihood.POSITIVE,  # 'ș'
        59: SequenceLikelihood.UNLIKELY,  # 'Ț'
        22: SequenceLikelihood.LIKELY,  # 'ț'
    },
    57: {  # 'Ă'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.NEGATIVE,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        38: SequenceLikelihood.UNLIKELY,  # 'N'
        41: SequenceLikelihood.UNLIKELY,  # 'O'
        29: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.LIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        44: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.NEGATIVE,  # 'W'
        56: SequenceLikelihood.NEGATIVE,  # 'X'
        58: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        8: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.NEGATIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        19: SequenceLikelihood.UNLIKELY,  # 'g'
        24: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.UNLIKELY,  # 'i'
        33: SequenceLikelihood.NEGATIVE,  # 'j'
        46: SequenceLikelihood.NEGATIVE,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.NEGATIVE,  # 'q'
        4: SequenceLikelihood.UNLIKELY,  # 'r'
        11: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.NEGATIVE,  # 'v'
        49: SequenceLikelihood.NEGATIVE,  # 'w'
        36: SequenceLikelihood.NEGATIVE,  # 'x'
        48: SequenceLikelihood.NEGATIVE,  # 'y'
        20: SequenceLikelihood.NEGATIVE,  # 'z'
        62: SequenceLikelihood.NEGATIVE,  # 'Â'
        47: SequenceLikelihood.UNLIKELY,  # 'Î'
        27: SequenceLikelihood.NEGATIVE,  # 'â'
        21: SequenceLikelihood.NEGATIVE,  # 'î'
        57: SequenceLikelihood.UNLIKELY,  # 'Ă'
        15: SequenceLikelihood.UNLIKELY,  # 'ă'
        55: SequenceLikelihood.UNLIKELY,  # 'Ș'
        23: SequenceLikelihood.UNLIKELY,  # 'ș'
        59: SequenceLikelihood.UNLIKELY,  # 'Ț'
        22: SequenceLikelihood.UNLIKELY,  # 'ț'
    },
    15: {  # 'ă'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.UNLIKELY,  # 'G'
        50: SequenceLikelihood.UNLIKELY,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        38: SequenceLikelihood.UNLIKELY,  # 'N'
        41: SequenceLikelihood.UNLIKELY,  # 'O'
        29: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.UNLIKELY,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        44: SequenceLikelihood.UNLIKELY,  # 'V'
        54: SequenceLikelihood.UNLIKELY,  # 'W'
        56: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.LIKELY,  # 'b'
        8: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        19: SequenceLikelihood.LIKELY,  # 'g'
        24: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        33: SequenceLikelihood.LIKELY,  # 'j'
        46: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        6: SequenceLikelihood.POSITIVE,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.POSITIVE,  # 'p'
        60: SequenceLikelihood.NEGATIVE,  # 'q'
        4: SequenceLikelihood.POSITIVE,  # 'r'
        11: SequenceLikelihood.POSITIVE,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.LIKELY,  # 'v'
        49: SequenceLikelihood.NEGATIVE,  # 'w'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        48: SequenceLikelihood.UNLIKELY,  # 'y'
        20: SequenceLikelihood.POSITIVE,  # 'z'
        62: SequenceLikelihood.NEGATIVE,  # 'Â'
        47: SequenceLikelihood.UNLIKELY,  # 'Î'
        27: SequenceLikelihood.UNLIKELY,  # 'â'
        21: SequenceLikelihood.UNLIKELY,  # 'î'
        57: SequenceLikelihood.UNLIKELY,  # 'Ă'
        15: SequenceLikelihood.UNLIKELY,  # 'ă'
        55: SequenceLikelihood.UNLIKELY,  # 'Ș'
        23: SequenceLikelihood.POSITIVE,  # 'ș'
        59: SequenceLikelihood.UNLIKELY,  # 'Ț'
        22: SequenceLikelihood.POSITIVE,  # 'ț'
    },
    55: {  # 'Ș'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.NEGATIVE,  # 'F'
        45: SequenceLikelihood.NEGATIVE,  # 'G'
        50: SequenceLikelihood.NEGATIVE,  # 'H'
        31: SequenceLikelihood.LIKELY,  # 'I'
        51: SequenceLikelihood.UNLIKELY,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        38: SequenceLikelihood.UNLIKELY,  # 'N'
        41: SequenceLikelihood.UNLIKELY,  # 'O'
        29: SequenceLikelihood.UNLIKELY,  # 'P'
        61: SequenceLikelihood.NEGATIVE,  # 'Q'
        35: SequenceLikelihood.NEGATIVE,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.LIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        44: SequenceLikelihood.NEGATIVE,  # 'V'
        54: SequenceLikelihood.NEGATIVE,  # 'W'
        56: SequenceLikelihood.NEGATIVE,  # 'X'
        58: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.NEGATIVE,  # 'b'
        8: SequenceLikelihood.LIKELY,  # 'c'
        12: SequenceLikelihood.NEGATIVE,  # 'd'
        1: SequenceLikelihood.LIKELY,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        19: SequenceLikelihood.NEGATIVE,  # 'g'
        24: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        33: SequenceLikelihood.UNLIKELY,  # 'j'
        46: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.LIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.NEGATIVE,  # 'q'
        4: SequenceLikelihood.UNLIKELY,  # 'r'
        11: SequenceLikelihood.NEGATIVE,  # 's'
        5: SequenceLikelihood.LIKELY,  # 't'
        7: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.NEGATIVE,  # 'w'
        36: SequenceLikelihood.NEGATIVE,  # 'x'
        48: SequenceLikelihood.NEGATIVE,  # 'y'
        20: SequenceLikelihood.NEGATIVE,  # 'z'
        62: SequenceLikelihood.UNLIKELY,  # 'Â'
        47: SequenceLikelihood.UNLIKELY,  # 'Î'
        27: SequenceLikelihood.NEGATIVE,  # 'â'
        21: SequenceLikelihood.UNLIKELY,  # 'î'
        57: SequenceLikelihood.UNLIKELY,  # 'Ă'
        15: SequenceLikelihood.UNLIKELY,  # 'ă'
        55: SequenceLikelihood.UNLIKELY,  # 'Ș'
        23: SequenceLikelihood.UNLIKELY,  # 'ș'
        59: SequenceLikelihood.NEGATIVE,  # 'Ț'
        22: SequenceLikelihood.UNLIKELY,  # 'ț'
    },
    23: {  # 'ș'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.UNLIKELY,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.NEGATIVE,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.NEGATIVE,  # 'F'
        45: SequenceLikelihood.NEGATIVE,  # 'G'
        50: SequenceLikelihood.NEGATIVE,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.NEGATIVE,  # 'J'
        52: SequenceLikelihood.NEGATIVE,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.UNLIKELY,  # 'M'
        38: SequenceLikelihood.NEGATIVE,  # 'N'
        41: SequenceLikelihood.UNLIKELY,  # 'O'
        29: SequenceLikelihood.NEGATIVE,  # 'P'
        61: SequenceLikelihood.NEGATIVE,  # 'Q'
        35: SequenceLikelihood.NEGATIVE,  # 'R'
        28: SequenceLikelihood.NEGATIVE,  # 'S'
        37: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        44: SequenceLikelihood.NEGATIVE,  # 'V'
        54: SequenceLikelihood.NEGATIVE,  # 'W'
        56: SequenceLikelihood.NEGATIVE,  # 'X'
        58: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        8: SequenceLikelihood.POSITIVE,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        19: SequenceLikelihood.UNLIKELY,  # 'g'
        24: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        33: SequenceLikelihood.UNLIKELY,  # 'j'
        46: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.LIKELY,  # 'n'
        10: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.NEGATIVE,  # 'q'
        4: SequenceLikelihood.UNLIKELY,  # 'r'
        11: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.POSITIVE,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.NEGATIVE,  # 'w'
        36: SequenceLikelihood.NEGATIVE,  # 'x'
        48: SequenceLikelihood.NEGATIVE,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        62: SequenceLikelihood.NEGATIVE,  # 'Â'
        47: SequenceLikelihood.NEGATIVE,  # 'Î'
        27: SequenceLikelihood.UNLIKELY,  # 'â'
        21: SequenceLikelihood.UNLIKELY,  # 'î'
        57: SequenceLikelihood.NEGATIVE,  # 'Ă'
        15: SequenceLikelihood.LIKELY,  # 'ă'
        55: SequenceLikelihood.NEGATIVE,  # 'Ș'
        23: SequenceLikelihood.UNLIKELY,  # 'ș'
        59: SequenceLikelihood.NEGATIVE,  # 'Ț'
        22: SequenceLikelihood.UNLIKELY,  # 'ț'
    },
    59: {  # 'Ț'
        25: SequenceLikelihood.UNLIKELY,  # 'A'
        39: SequenceLikelihood.NEGATIVE,  # 'B'
        26: SequenceLikelihood.UNLIKELY,  # 'C'
        30: SequenceLikelihood.NEGATIVE,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.NEGATIVE,  # 'G'
        50: SequenceLikelihood.NEGATIVE,  # 'H'
        31: SequenceLikelihood.LIKELY,  # 'I'
        51: SequenceLikelihood.NEGATIVE,  # 'J'
        52: SequenceLikelihood.UNLIKELY,  # 'K'
        40: SequenceLikelihood.NEGATIVE,  # 'L'
        32: SequenceLikelihood.NEGATIVE,  # 'M'
        38: SequenceLikelihood.NEGATIVE,  # 'N'
        41: SequenceLikelihood.UNLIKELY,  # 'O'
        29: SequenceLikelihood.NEGATIVE,  # 'P'
        61: SequenceLikelihood.NEGATIVE,  # 'Q'
        35: SequenceLikelihood.UNLIKELY,  # 'R'
        28: SequenceLikelihood.UNLIKELY,  # 'S'
        37: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        44: SequenceLikelihood.NEGATIVE,  # 'V'
        54: SequenceLikelihood.NEGATIVE,  # 'W'
        56: SequenceLikelihood.NEGATIVE,  # 'X'
        58: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.NEGATIVE,  # 'b'
        8: SequenceLikelihood.NEGATIVE,  # 'c'
        12: SequenceLikelihood.NEGATIVE,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        19: SequenceLikelihood.NEGATIVE,  # 'g'
        24: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.LIKELY,  # 'i'
        33: SequenceLikelihood.NEGATIVE,  # 'j'
        46: SequenceLikelihood.NEGATIVE,  # 'k'
        9: SequenceLikelihood.NEGATIVE,  # 'l'
        14: SequenceLikelihood.NEGATIVE,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.NEGATIVE,  # 'q'
        4: SequenceLikelihood.NEGATIVE,  # 'r'
        11: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.NEGATIVE,  # 't'
        7: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        36: SequenceLikelihood.NEGATIVE,  # 'x'
        48: SequenceLikelihood.NEGATIVE,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        62: SequenceLikelihood.UNLIKELY,  # 'Â'
        47: SequenceLikelihood.UNLIKELY,  # 'Î'
        27: SequenceLikelihood.UNLIKELY,  # 'â'
        21: SequenceLikelihood.UNLIKELY,  # 'î'
        57: SequenceLikelihood.UNLIKELY,  # 'Ă'
        15: SequenceLikelihood.UNLIKELY,  # 'ă'
        55: SequenceLikelihood.UNLIKELY,  # 'Ș'
        23: SequenceLikelihood.NEGATIVE,  # 'ș'
        59: SequenceLikelihood.UNLIKELY,  # 'Ț'
        22: SequenceLikelihood.UNLIKELY,  # 'ț'
    },
    22: {  # 'ț'
        25: SequenceLikelihood.NEGATIVE,  # 'A'
        39: SequenceLikelihood.NEGATIVE,  # 'B'
        26: SequenceLikelihood.NEGATIVE,  # 'C'
        30: SequenceLikelihood.UNLIKELY,  # 'D'
        34: SequenceLikelihood.UNLIKELY,  # 'E'
        43: SequenceLikelihood.UNLIKELY,  # 'F'
        45: SequenceLikelihood.NEGATIVE,  # 'G'
        50: SequenceLikelihood.NEGATIVE,  # 'H'
        31: SequenceLikelihood.UNLIKELY,  # 'I'
        51: SequenceLikelihood.NEGATIVE,  # 'J'
        52: SequenceLikelihood.NEGATIVE,  # 'K'
        40: SequenceLikelihood.UNLIKELY,  # 'L'
        32: SequenceLikelihood.NEGATIVE,  # 'M'
        38: SequenceLikelihood.NEGATIVE,  # 'N'
        41: SequenceLikelihood.UNLIKELY,  # 'O'
        29: SequenceLikelihood.NEGATIVE,  # 'P'
        61: SequenceLikelihood.NEGATIVE,  # 'Q'
        35: SequenceLikelihood.NEGATIVE,  # 'R'
        28: SequenceLikelihood.NEGATIVE,  # 'S'
        37: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        44: SequenceLikelihood.NEGATIVE,  # 'V'
        54: SequenceLikelihood.NEGATIVE,  # 'W'
        56: SequenceLikelihood.NEGATIVE,  # 'X'
        58: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.NEGATIVE,  # 'b'
        8: SequenceLikelihood.UNLIKELY,  # 'c'
        12: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        17: SequenceLikelihood.UNLIKELY,  # 'f'
        19: SequenceLikelihood.UNLIKELY,  # 'g'
        24: SequenceLikelihood.UNLIKELY,  # 'h'
        2: SequenceLikelihood.POSITIVE,  # 'i'
        33: SequenceLikelihood.NEGATIVE,  # 'j'
        46: SequenceLikelihood.UNLIKELY,  # 'k'
        9: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        6: SequenceLikelihood.UNLIKELY,  # 'n'
        10: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        60: SequenceLikelihood.NEGATIVE,  # 'q'
        4: SequenceLikelihood.UNLIKELY,  # 'r'
        11: SequenceLikelihood.UNLIKELY,  # 's'
        5: SequenceLikelihood.UNLIKELY,  # 't'
        7: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        49: SequenceLikelihood.UNLIKELY,  # 'w'
        36: SequenceLikelihood.UNLIKELY,  # 'x'
        48: SequenceLikelihood.NEGATIVE,  # 'y'
        20: SequenceLikelihood.UNLIKELY,  # 'z'
        62: SequenceLikelihood.NEGATIVE,  # 'Â'
        47: SequenceLikelihood.UNLIKELY,  # 'Î'
        27: SequenceLikelihood.LIKELY,  # 'â'
        21: SequenceLikelihood.UNLIKELY,  # 'î'
        57: SequenceLikelihood.NEGATIVE,  # 'Ă'
        15: SequenceLikelihood.POSITIVE,  # 'ă'
        55: SequenceLikelihood.NEGATIVE,  # 'Ș'
        23: SequenceLikelihood.UNLIKELY,  # 'ș'
        59: SequenceLikelihood.NEGATIVE,  # 'Ț'
        22: SequenceLikelihood.UNLIKELY,  # 'ț'
    },
}

# Character Mapping Table(s):
CP852_ROMANIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 25,  # 'A'
    66: 39,  # 'B'
    67: 26,  # 'C'
    68: 30,  # 'D'
    69: 34,  # 'E'
    70: 43,  # 'F'
    71: 45,  # 'G'
    72: 50,  # 'H'
    73: 31,  # 'I'
    74: 51,  # 'J'
    75: 52,  # 'K'
    76: 40,  # 'L'
    77: 32,  # 'M'
    78: 38,  # 'N'
    79: 41,  # 'O'
    80: 29,  # 'P'
    81: 61,  # 'Q'
    82: 35,  # 'R'
    83: 28,  # 'S'
    84: 37,  # 'T'
    85: 42,  # 'U'
    86: 44,  # 'V'
    87: 54,  # 'W'
    88: 56,  # 'X'
    89: 58,  # 'Y'
    90: 53,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 3,  # 'a'
    98: 18,  # 'b'
    99: 8,  # 'c'
    100: 12,  # 'd'
    101: 1,  # 'e'
    102: 17,  # 'f'
    103: 19,  # 'g'
    104: 24,  # 'h'
    105: 2,  # 'i'
    106: 33,  # 'j'
    107: 46,  # 'k'
    108: 9,  # 'l'
    109: 14,  # 'm'
    110: 6,  # 'n'
    111: 10,  # 'o'
    112: 13,  # 'p'
    113: 60,  # 'q'
    114: 4,  # 'r'
    115: 11,  # 's'
    116: 5,  # 't'
    117: 7,  # 'u'
    118: 16,  # 'v'
    119: 49,  # 'w'
    120: 36,  # 'x'
    121: 48,  # 'y'
    122: 20,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'Ç'
    129: 0,  # 'ü'
    130: 0,  # 'é'
    131: 27,  # 'â'
    132: 0,  # 'ä'
    133: 0,  # 'ů'
    134: 0,  # 'ć'
    135: 0,  # 'ç'
    136: 0,  # 'ł'
    137: 0,  # 'ë'
    138: 0,  # 'Ő'
    139: 0,  # 'ő'
    140: 21,  # 'î'
    141: 0,  # 'Ź'
    142: 0,  # 'Ä'
    143: 0,  # 'Ć'
    144: 0,  # 'É'
    145: 0,  # 'Ĺ'
    146: 0,  # 'ĺ'
    147: 0,  # 'ô'
    148: 0,  # 'ö'
    149: 0,  # 'Ľ'
    150: 0,  # 'ľ'
    151: 0,  # 'Ś'
    152: 0,  # 'ś'
    153: 0,  # 'Ö'
    154: 0,  # 'Ü'
    155: 0,  # 'Ť'
    156: 0,  # 'ť'
    157: 0,  # 'Ł'
    158: CharacterCategory.SYMBOL,  # '×'
    159: 0,  # 'č'
    160: 0,  # 'á'
    161: 0,  # 'í'
    162: 0,  # 'ó'
    163: 0,  # 'ú'
    164: 0,  # 'Ą'
    165: 0,  # 'ą'
    166: 0,  # 'Ž'
    167: 0,  # 'ž'
    168: 0,  # 'Ę'
    169: 0,  # 'ę'
    170: CharacterCategory.SYMBOL,  # '¬'
    171: 0,  # 'ź'
    172: 0,  # 'Č'
    173: 23,  # 'ş'
    174: CharacterCategory.SYMBOL,  # '«'
    175: CharacterCategory.SYMBOL,  # '»'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: 0,  # 'Á'
    182: 62,  # 'Â'
    183: 0,  # 'Ě'
    184: 55,  # 'Ş'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: 0,  # 'Ż'
    190: 0,  # 'ż'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: 57,  # 'Ă'
    199: 15,  # 'ă'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: CharacterCategory.SYMBOL,  # '¤'
    208: 0,  # 'đ'
    209: 0,  # 'Đ'
    210: 0,  # 'Ď'
    211: 0,  # 'Ë'
    212: 0,  # 'ď'
    213: 0,  # 'Ň'
    214: 0,  # 'Í'
    215: 47,  # 'Î'
    216: 0,  # 'ě'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: 59,  # 'Ţ'
    222: 0,  # 'Ů'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 0,  # 'Ó'
    225: 0,  # 'ß'
    226: 0,  # 'Ô'
    227: 0,  # 'Ń'
    228: 0,  # 'ń'
    229: 0,  # 'ň'
    230: 0,  # 'Š'
    231: 0,  # 'š'
    232: 0,  # 'Ŕ'
    233: 0,  # 'Ú'
    234: 0,  # 'ŕ'
    235: 0,  # 'Ű'
    236: 0,  # 'ý'
    237: 0,  # 'Ý'
    238: 22,  # 'ţ'
    239: CharacterCategory.SYMBOL,  # '´'
    240: CharacterCategory.CONTROL,  # '\xad'
    241: CharacterCategory.SYMBOL,  # '˝'
    242: CharacterCategory.SYMBOL,  # '˛'
    243: 0,  # 'ˇ'
    244: CharacterCategory.SYMBOL,  # '˘'
    245: CharacterCategory.SYMBOL,  # '§'
    246: CharacterCategory.SYMBOL,  # '÷'
    247: CharacterCategory.SYMBOL,  # '¸'
    248: CharacterCategory.SYMBOL,  # '°'
    249: CharacterCategory.SYMBOL,  # '¨'
    250: CharacterCategory.SYMBOL,  # '˙'
    251: 0,  # 'ű'
    252: 0,  # 'Ř'
    253: 0,  # 'ř'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP852_ROMANIAN_MODEL = SingleByteCharSetModel(
    charset_name="CP852",
    language="Romanian",
    char_to_order_map=CP852_ROMANIAN_CHAR_TO_ORDER,
    language_model=ROMANIAN_LANG_MODEL,
    typical_positive_ratio=0.9820884516758617,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÂÎâîĂăȘșȚț",
)

ISO_8859_2_ROMANIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 25,  # 'A'
    66: 39,  # 'B'
    67: 26,  # 'C'
    68: 30,  # 'D'
    69: 34,  # 'E'
    70: 43,  # 'F'
    71: 45,  # 'G'
    72: 50,  # 'H'
    73: 31,  # 'I'
    74: 51,  # 'J'
    75: 52,  # 'K'
    76: 40,  # 'L'
    77: 32,  # 'M'
    78: 38,  # 'N'
    79: 41,  # 'O'
    80: 29,  # 'P'
    81: 61,  # 'Q'
    82: 35,  # 'R'
    83: 28,  # 'S'
    84: 37,  # 'T'
    85: 42,  # 'U'
    86: 44,  # 'V'
    87: 54,  # 'W'
    88: 56,  # 'X'
    89: 58,  # 'Y'
    90: 53,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 3,  # 'a'
    98: 18,  # 'b'
    99: 8,  # 'c'
    100: 12,  # 'd'
    101: 1,  # 'e'
    102: 17,  # 'f'
    103: 19,  # 'g'
    104: 24,  # 'h'
    105: 2,  # 'i'
    106: 33,  # 'j'
    107: 46,  # 'k'
    108: 9,  # 'l'
    109: 14,  # 'm'
    110: 6,  # 'n'
    111: 10,  # 'o'
    112: 13,  # 'p'
    113: 60,  # 'q'
    114: 4,  # 'r'
    115: 11,  # 's'
    116: 5,  # 't'
    117: 7,  # 'u'
    118: 16,  # 'v'
    119: 49,  # 'w'
    120: 36,  # 'x'
    121: 48,  # 'y'
    122: 20,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.CONTROL,  # '\x80'
    129: CharacterCategory.CONTROL,  # '\x81'
    130: CharacterCategory.CONTROL,  # '\x82'
    131: CharacterCategory.CONTROL,  # '\x83'
    132: CharacterCategory.CONTROL,  # '\x84'
    133: CharacterCategory.CONTROL,  # '\x85'
    134: CharacterCategory.CONTROL,  # '\x86'
    135: CharacterCategory.CONTROL,  # '\x87'
    136: CharacterCategory.CONTROL,  # '\x88'
    137: CharacterCategory.CONTROL,  # '\x89'
    138: CharacterCategory.CONTROL,  # '\x8a'
    139: CharacterCategory.CONTROL,  # '\x8b'
    140: CharacterCategory.CONTROL,  # '\x8c'
    141: CharacterCategory.CONTROL,  # '\x8d'
    142: CharacterCategory.CONTROL,  # '\x8e'
    143: CharacterCategory.CONTROL,  # '\x8f'
    144: CharacterCategory.CONTROL,  # '\x90'
    145: CharacterCategory.CONTROL,  # '\x91'
    146: CharacterCategory.CONTROL,  # '\x92'
    147: CharacterCategory.CONTROL,  # '\x93'
    148: CharacterCategory.CONTROL,  # '\x94'
    149: CharacterCategory.CONTROL,  # '\x95'
    150: CharacterCategory.CONTROL,  # '\x96'
    151: CharacterCategory.CONTROL,  # '\x97'
    152: CharacterCategory.CONTROL,  # '\x98'
    153: CharacterCategory.CONTROL,  # '\x99'
    154: CharacterCategory.CONTROL,  # '\x9a'
    155: CharacterCategory.CONTROL,  # '\x9b'
    156: CharacterCategory.CONTROL,  # '\x9c'
    157: CharacterCategory.CONTROL,  # '\x9d'
    158: CharacterCategory.CONTROL,  # '\x9e'
    159: CharacterCategory.CONTROL,  # '\x9f'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: 0,  # 'Ą'
    162: CharacterCategory.SYMBOL,  # '˘'
    163: 0,  # 'Ł'
    164: CharacterCategory.SYMBOL,  # '¤'
    165: 0,  # 'Ľ'
    166: 0,  # 'Ś'
    167: CharacterCategory.SYMBOL,  # '§'
    168: CharacterCategory.SYMBOL,  # '¨'
    169: 0,  # 'Š'
    170: 55,  # 'Ş'
    171: 0,  # 'Ť'
    172: 0,  # 'Ź'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: 0,  # 'Ž'
    175: 0,  # 'Ż'
    176: CharacterCategory.SYMBOL,  # '°'
    177: 0,  # 'ą'
    178: CharacterCategory.SYMBOL,  # '˛'
    179: 0,  # 'ł'
    180: CharacterCategory.SYMBOL,  # '´'
    181: 0,  # 'ľ'
    182: 0,  # 'ś'
    183: 0,  # 'ˇ'
    184: CharacterCategory.SYMBOL,  # '¸'
    185: 0,  # 'š'
    186: 23,  # 'ş'
    187: 0,  # 'ť'
    188: 0,  # 'ź'
    189: CharacterCategory.SYMBOL,  # '˝'
    190: 0,  # 'ž'
    191: 0,  # 'ż'
    192: 0,  # 'Ŕ'
    193: 0,  # 'Á'
    194: 62,  # 'Â'
    195: 57,  # 'Ă'
    196: 0,  # 'Ä'
    197: 0,  # 'Ĺ'
    198: 0,  # 'Ć'
    199: 0,  # 'Ç'
    200: 0,  # 'Č'
    201: 0,  # 'É'
    202: 0,  # 'Ę'
    203: 0,  # 'Ë'
    204: 0,  # 'Ě'
    205: 0,  # 'Í'
    206: 47,  # 'Î'
    207: 0,  # 'Ď'
    208: 0,  # 'Đ'
    209: 0,  # 'Ń'
    210: 0,  # 'Ň'
    211: 0,  # 'Ó'
    212: 0,  # 'Ô'
    213: 0,  # 'Ő'
    214: 0,  # 'Ö'
    215: CharacterCategory.SYMBOL,  # '×'
    216: 0,  # 'Ř'
    217: 0,  # 'Ů'
    218: 0,  # 'Ú'
    219: 0,  # 'Ű'
    220: 0,  # 'Ü'
    221: 0,  # 'Ý'
    222: 59,  # 'Ţ'
    223: 0,  # 'ß'
    224: 0,  # 'ŕ'
    225: 0,  # 'á'
    226: 27,  # 'â'
    227: 15,  # 'ă'
    228: 0,  # 'ä'
    229: 0,  # 'ĺ'
    230: 0,  # 'ć'
    231: 0,  # 'ç'
    232: 0,  # 'č'
    233: 0,  # 'é'
    234: 0,  # 'ę'
    235: 0,  # 'ë'
    236: 0,  # 'ě'
    237: 0,  # 'í'
    238: 21,  # 'î'
    239: 0,  # 'ď'
    240: 0,  # 'đ'
    241: 0,  # 'ń'
    242: 0,  # 'ň'
    243: 0,  # 'ó'
    244: 0,  # 'ô'
    245: 0,  # 'ő'
    246: 0,  # 'ö'
    247: CharacterCategory.SYMBOL,  # '÷'
    248: 0,  # 'ř'
    249: 0,  # 'ů'
    250: 0,  # 'ú'
    251: 0,  # 'ű'
    252: 0,  # 'ü'
    253: 0,  # 'ý'
    254: 22,  # 'ţ'
    255: CharacterCategory.SYMBOL,  # '˙'
}

ISO_8859_2_ROMANIAN_MODEL = SingleByteCharSetModel(
    charset_name="ISO-8859-2",
    language="Romanian",
    char_to_order_map=ISO_8859_2_ROMANIAN_CHAR_TO_ORDER,
    language_model=ROMANIAN_LANG_MODEL,
    typical_positive_ratio=0.9820884516758617,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÂÎâîĂăȘșȚț",
)

ISO_8859_16_ROMANIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 25,  # 'A'
    66: 39,  # 'B'
    67: 26,  # 'C'
    68: 30,  # 'D'
    69: 34,  # 'E'
    70: 43,  # 'F'
    71: 45,  # 'G'
    72: 50,  # 'H'
    73: 31,  # 'I'
    74: 51,  # 'J'
    75: 52,  # 'K'
    76: 40,  # 'L'
    77: 32,  # 'M'
    78: 38,  # 'N'
    79: 41,  # 'O'
    80: 29,  # 'P'
    81: 61,  # 'Q'
    82: 35,  # 'R'
    83: 28,  # 'S'
    84: 37,  # 'T'
    85: 42,  # 'U'
    86: 44,  # 'V'
    87: 54,  # 'W'
    88: 56,  # 'X'
    89: 58,  # 'Y'
    90: 53,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 3,  # 'a'
    98: 18,  # 'b'
    99: 8,  # 'c'
    100: 12,  # 'd'
    101: 1,  # 'e'
    102: 17,  # 'f'
    103: 19,  # 'g'
    104: 24,  # 'h'
    105: 2,  # 'i'
    106: 33,  # 'j'
    107: 46,  # 'k'
    108: 9,  # 'l'
    109: 14,  # 'm'
    110: 6,  # 'n'
    111: 10,  # 'o'
    112: 13,  # 'p'
    113: 60,  # 'q'
    114: 4,  # 'r'
    115: 11,  # 's'
    116: 5,  # 't'
    117: 7,  # 'u'
    118: 16,  # 'v'
    119: 49,  # 'w'
    120: 36,  # 'x'
    121: 48,  # 'y'
    122: 20,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.CONTROL,  # '\x80'
    129: CharacterCategory.CONTROL,  # '\x81'
    130: CharacterCategory.CONTROL,  # '\x82'
    131: CharacterCategory.CONTROL,  # '\x83'
    132: CharacterCategory.CONTROL,  # '\x84'
    133: CharacterCategory.CONTROL,  # '\x85'
    134: CharacterCategory.CONTROL,  # '\x86'
    135: CharacterCategory.CONTROL,  # '\x87'
    136: CharacterCategory.CONTROL,  # '\x88'
    137: CharacterCategory.CONTROL,  # '\x89'
    138: CharacterCategory.CONTROL,  # '\x8a'
    139: CharacterCategory.CONTROL,  # '\x8b'
    140: CharacterCategory.CONTROL,  # '\x8c'
    141: CharacterCategory.CONTROL,  # '\x8d'
    142: CharacterCategory.CONTROL,  # '\x8e'
    143: CharacterCategory.CONTROL,  # '\x8f'
    144: CharacterCategory.CONTROL,  # '\x90'
    145: CharacterCategory.CONTROL,  # '\x91'
    146: CharacterCategory.CONTROL,  # '\x92'
    147: CharacterCategory.CONTROL,  # '\x93'
    148: CharacterCategory.CONTROL,  # '\x94'
    149: CharacterCategory.CONTROL,  # '\x95'
    150: CharacterCategory.CONTROL,  # '\x96'
    151: CharacterCategory.CONTROL,  # '\x97'
    152: CharacterCategory.CONTROL,  # '\x98'
    153: CharacterCategory.CONTROL,  # '\x99'
    154: CharacterCategory.CONTROL,  # '\x9a'
    155: CharacterCategory.CONTROL,  # '\x9b'
    156: CharacterCategory.CONTROL,  # '\x9c'
    157: CharacterCategory.CONTROL,  # '\x9d'
    158: CharacterCategory.CONTROL,  # '\x9e'
    159: CharacterCategory.CONTROL,  # '\x9f'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: 0,  # 'Ą'
    162: 0,  # 'ą'
    163: 0,  # 'Ł'
    164: CharacterCategory.SYMBOL,  # '€'
    165: CharacterCategory.SYMBOL,  # '„'
    166: 0,  # 'Š'
    167: CharacterCategory.SYMBOL,  # '§'
    168: 0,  # 'š'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 55,  # 'Ș'
    171: CharacterCategory.SYMBOL,  # '«'
    172: 0,  # 'Ź'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: 0,  # 'ź'
    175: 0,  # 'Ż'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: 0,  # 'Č'
    179: 0,  # 'ł'
    180: 0,  # 'Ž'
    181: CharacterCategory.SYMBOL,  # '”'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: 0,  # 'ž'
    185: 0,  # 'č'
    186: 23,  # 'ș'
    187: CharacterCategory.SYMBOL,  # '»'
    188: 0,  # 'Œ'
    189: 0,  # 'œ'
    190: 0,  # 'Ÿ'
    191: 0,  # 'ż'
    192: 0,  # 'À'
    193: 0,  # 'Á'
    194: 62,  # 'Â'
    195: 57,  # 'Ă'
    196: 0,  # 'Ä'
    197: 0,  # 'Ć'
    198: 0,  # 'Æ'
    199: 0,  # 'Ç'
    200: 0,  # 'È'
    201: 0,  # 'É'
    202: 0,  # 'Ê'
    203: 0,  # 'Ë'
    204: 0,  # 'Ì'
    205: 0,  # 'Í'
    206: 47,  # 'Î'
    207: 0,  # 'Ï'
    208: 0,  # 'Đ'
    209: 0,  # 'Ń'
    210: 0,  # 'Ò'
    211: 0,  # 'Ó'
    212: 0,  # 'Ô'
    213: 0,  # 'Ő'
    214: 0,  # 'Ö'
    215: 0,  # 'Ś'
    216: 0,  # 'Ű'
    217: 0,  # 'Ù'
    218: 0,  # 'Ú'
    219: 0,  # 'Û'
    220: 0,  # 'Ü'
    221: 0,  # 'Ę'
    222: 59,  # 'Ț'
    223: 0,  # 'ß'
    224: 0,  # 'à'
    225: 0,  # 'á'
    226: 27,  # 'â'
    227: 15,  # 'ă'
    228: 0,  # 'ä'
    229: 0,  # 'ć'
    230: 0,  # 'æ'
    231: 0,  # 'ç'
    232: 0,  # 'è'
    233: 0,  # 'é'
    234: 0,  # 'ê'
    235: 0,  # 'ë'
    236: 0,  # 'ì'
    237: 0,  # 'í'
    238: 21,  # 'î'
    239: 0,  # 'ï'
    240: 0,  # 'đ'
    241: 0,  # 'ń'
    242: 0,  # 'ò'
    243: 0,  # 'ó'
    244: 0,  # 'ô'
    245: 0,  # 'ő'
    246: 0,  # 'ö'
    247: 0,  # 'ś'
    248: 0,  # 'ű'
    249: 0,  # 'ù'
    250: 0,  # 'ú'
    251: 0,  # 'û'
    252: 0,  # 'ü'
    253: 0,  # 'ę'
    254: 22,  # 'ț'
    255: 0,  # 'ÿ'
}

ISO_8859_16_ROMANIAN_MODEL = SingleByteCharSetModel(
    charset_name="ISO-8859-16",
    language="Romanian",
    char_to_order_map=ISO_8859_16_ROMANIAN_CHAR_TO_ORDER,
    language_model=ROMANIAN_LANG_MODEL,
    typical_positive_ratio=0.9816640105313749,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÂÎâîĂăȘșȚț",
)

MACLATIN2_ROMANIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 25,  # 'A'
    66: 39,  # 'B'
    67: 26,  # 'C'
    68: 30,  # 'D'
    69: 34,  # 'E'
    70: 43,  # 'F'
    71: 45,  # 'G'
    72: 50,  # 'H'
    73: 31,  # 'I'
    74: 51,  # 'J'
    75: 52,  # 'K'
    76: 40,  # 'L'
    77: 32,  # 'M'
    78: 38,  # 'N'
    79: 41,  # 'O'
    80: 29,  # 'P'
    81: 61,  # 'Q'
    82: 35,  # 'R'
    83: 28,  # 'S'
    84: 37,  # 'T'
    85: 42,  # 'U'
    86: 44,  # 'V'
    87: 54,  # 'W'
    88: 56,  # 'X'
    89: 58,  # 'Y'
    90: 53,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 3,  # 'a'
    98: 18,  # 'b'
    99: 8,  # 'c'
    100: 12,  # 'd'
    101: 1,  # 'e'
    102: 17,  # 'f'
    103: 19,  # 'g'
    104: 24,  # 'h'
    105: 2,  # 'i'
    106: 33,  # 'j'
    107: 46,  # 'k'
    108: 9,  # 'l'
    109: 14,  # 'm'
    110: 6,  # 'n'
    111: 10,  # 'o'
    112: 13,  # 'p'
    113: 60,  # 'q'
    114: 4,  # 'r'
    115: 11,  # 's'
    116: 5,  # 't'
    117: 7,  # 'u'
    118: 16,  # 'v'
    119: 49,  # 'w'
    120: 36,  # 'x'
    121: 48,  # 'y'
    122: 20,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'Ä'
    129: 0,  # 'Ā'
    130: 0,  # 'ā'
    131: 0,  # 'É'
    132: 0,  # 'Ą'
    133: 0,  # 'Ö'
    134: 0,  # 'Ü'
    135: 0,  # 'á'
    136: 0,  # 'ą'
    137: 0,  # 'Č'
    138: 0,  # 'ä'
    139: 0,  # 'č'
    140: 0,  # 'Ć'
    141: 0,  # 'ć'
    142: 0,  # 'é'
    143: 0,  # 'Ź'
    144: 0,  # 'ź'
    145: 0,  # 'Ď'
    146: 0,  # 'í'
    147: 0,  # 'ď'
    148: 0,  # 'Ē'
    149: 0,  # 'ē'
    150: 0,  # 'Ė'
    151: 0,  # 'ó'
    152: 0,  # 'ė'
    153: 0,  # 'ô'
    154: 0,  # 'ö'
    155: 0,  # 'õ'
    156: 0,  # 'ú'
    157: 0,  # 'Ě'
    158: 0,  # 'ě'
    159: 0,  # 'ü'
    160: CharacterCategory.SYMBOL,  # '†'
    161: CharacterCategory.SYMBOL,  # '°'
    162: 0,  # 'Ę'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '§'
    165: CharacterCategory.SYMBOL,  # '•'
    166: CharacterCategory.SYMBOL,  # '¶'
    167: 0,  # 'ß'
    168: CharacterCategory.SYMBOL,  # '®'
    169: CharacterCategory.SYMBOL,  # '©'
    170: CharacterCategory.SYMBOL,  # '™'
    171: 0,  # 'ę'
    172: CharacterCategory.SYMBOL,  # '¨'
    173: CharacterCategory.SYMBOL,  # '≠'
    174: 0,  # 'ģ'
    175: 0,  # 'Į'
    176: 0,  # 'į'
    177: 0,  # 'Ī'
    178: CharacterCategory.SYMBOL,  # '≤'
    179: CharacterCategory.SYMBOL,  # '≥'
    180: 0,  # 'ī'
    181: 0,  # 'Ķ'
    182: CharacterCategory.SYMBOL,  # '∂'
    183: CharacterCategory.SYMBOL,  # '∑'
    184: 0,  # 'ł'
    185: 0,  # 'Ļ'
    186: 0,  # 'ļ'
    187: 0,  # 'Ľ'
    188: 0,  # 'ľ'
    189: 0,  # 'Ĺ'
    190: 0,  # 'ĺ'
    191: 0,  # 'Ņ'
    192: 0,  # 'ņ'
    193: 0,  # 'Ń'
    194: CharacterCategory.SYMBOL,  # '¬'
    195: CharacterCategory.SYMBOL,  # '√'
    196: 0,  # 'ń'
    197: 0,  # 'Ň'
    198: CharacterCategory.SYMBOL,  # '∆'
    199: CharacterCategory.SYMBOL,  # '«'
    200: CharacterCategory.SYMBOL,  # '»'
    201: CharacterCategory.SYMBOL,  # '…'
    202: CharacterCategory.CONTROL,  # '\xa0'
    203: 0,  # 'ň'
    204: 0,  # 'Ő'
    205: 0,  # 'Õ'
    206: 0,  # 'ő'
    207: 0,  # 'Ō'
    208: CharacterCategory.SYMBOL,  # '–'
    209: CharacterCategory.SYMBOL,  # '—'
    210: CharacterCategory.SYMBOL,  # '“'
    211: CharacterCategory.SYMBOL,  # '”'
    212: CharacterCategory.SYMBOL,  # '‘'
    213: CharacterCategory.SYMBOL,  # '’'
    214: CharacterCategory.SYMBOL,  # '÷'
    215: CharacterCategory.SYMBOL,  # '◊'
    216: 0,  # 'ō'
    217: 0,  # 'Ŕ'
    218: 0,  # 'ŕ'
    219: 0,  # 'Ř'
    220: CharacterCategory.SYMBOL,  # '‹'
    221: CharacterCategory.SYMBOL,  # '›'
    222: 0,  # 'ř'
    223: 0,  # 'Ŗ'
    224: 0,  # 'ŗ'
    225: 0,  # 'Š'
    226: CharacterCategory.SYMBOL,  # '‚'
    227: CharacterCategory.SYMBOL,  # '„'
    228: 0,  # 'š'
    229: 0,  # 'Ś'
    230: 0,  # 'ś'
    231: 0,  # 'Á'
    232: 0,  # 'Ť'
    233: 0,  # 'ť'
    234: 0,  # 'Í'
    235: 0,  # 'Ž'
    236: 0,  # 'ž'
    237: 0,  # 'Ū'
    238: 0,  # 'Ó'
    239: 0,  # 'Ô'
    240: 0,  # 'ū'
    241: 0,  # 'Ů'
    242: 0,  # 'Ú'
    243: 0,  # 'ů'
    244: 0,  # 'Ű'
    245: 0,  # 'ű'
    246: 0,  # 'Ų'
    247: 0,  # 'ų'
    248: 0,  # 'Ý'
    249: 0,  # 'ý'
    250: 0,  # 'ķ'
    251: 0,  # 'Ż'
    252: 0,  # 'Ł'
    253: 0,  # 'ż'
    254: 0,  # 'Ģ'
    255: 0,  # 'ˇ'
}

MACLATIN2_ROMANIAN_MODEL = SingleByteCharSetModel(
    charset_name="MacLatin2",
    language="Romanian",
    char_to_order_map=MACLATIN2_ROMANIAN_CHAR_TO_ORDER,
    language_model=ROMANIAN_LANG_MODEL,
    typical_positive_ratio=0.9829459758152659,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÂÎâîĂăȘșȚț",
)

WINDOWS_1250_ROMANIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 25,  # 'A'
    66: 39,  # 'B'
    67: 26,  # 'C'
    68: 30,  # 'D'
    69: 34,  # 'E'
    70: 43,  # 'F'
    71: 45,  # 'G'
    72: 50,  # 'H'
    73: 31,  # 'I'
    74: 51,  # 'J'
    75: 52,  # 'K'
    76: 40,  # 'L'
    77: 32,  # 'M'
    78: 38,  # 'N'
    79: 41,  # 'O'
    80: 29,  # 'P'
    81: 61,  # 'Q'
    82: 35,  # 'R'
    83: 28,  # 'S'
    84: 37,  # 'T'
    85: 42,  # 'U'
    86: 44,  # 'V'
    87: 54,  # 'W'
    88: 56,  # 'X'
    89: 58,  # 'Y'
    90: 53,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 3,  # 'a'
    98: 18,  # 'b'
    99: 8,  # 'c'
    100: 12,  # 'd'
    101: 1,  # 'e'
    102: 17,  # 'f'
    103: 19,  # 'g'
    104: 24,  # 'h'
    105: 2,  # 'i'
    106: 33,  # 'j'
    107: 46,  # 'k'
    108: 9,  # 'l'
    109: 14,  # 'm'
    110: 6,  # 'n'
    111: 10,  # 'o'
    112: 13,  # 'p'
    113: 60,  # 'q'
    114: 4,  # 'r'
    115: 11,  # 's'
    116: 5,  # 't'
    117: 7,  # 'u'
    118: 16,  # 'v'
    119: 49,  # 'w'
    120: 36,  # 'x'
    121: 48,  # 'y'
    122: 20,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.SYMBOL,  # '€'
    129: CharacterCategory.UNDEFINED,  # None
    130: CharacterCategory.SYMBOL,  # '‚'
    131: CharacterCategory.UNDEFINED,  # None
    132: CharacterCategory.SYMBOL,  # '„'
    133: CharacterCategory.SYMBOL,  # '…'
    134: CharacterCategory.SYMBOL,  # '†'
    135: CharacterCategory.SYMBOL,  # '‡'
    136: CharacterCategory.UNDEFINED,  # None
    137: CharacterCategory.SYMBOL,  # '‰'
    138: 0,  # 'Š'
    139: CharacterCategory.SYMBOL,  # '‹'
    140: 0,  # 'Ś'
    141: 0,  # 'Ť'
    142: 0,  # 'Ž'
    143: 0,  # 'Ź'
    144: CharacterCategory.UNDEFINED,  # None
    145: CharacterCategory.SYMBOL,  # '‘'
    146: CharacterCategory.SYMBOL,  # '’'
    147: CharacterCategory.SYMBOL,  # '“'
    148: CharacterCategory.SYMBOL,  # '”'
    149: CharacterCategory.SYMBOL,  # '•'
    150: CharacterCategory.SYMBOL,  # '–'
    151: CharacterCategory.SYMBOL,  # '—'
    152: CharacterCategory.UNDEFINED,  # None
    153: CharacterCategory.SYMBOL,  # '™'
    154: 0,  # 'š'
    155: CharacterCategory.SYMBOL,  # '›'
    156: 0,  # 'ś'
    157: 0,  # 'ť'
    158: 0,  # 'ž'
    159: 0,  # 'ź'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: 0,  # 'ˇ'
    162: CharacterCategory.SYMBOL,  # '˘'
    163: 0,  # 'Ł'
    164: CharacterCategory.SYMBOL,  # '¤'
    165: 0,  # 'Ą'
    166: CharacterCategory.SYMBOL,  # '¦'
    167: CharacterCategory.SYMBOL,  # '§'
    168: CharacterCategory.SYMBOL,  # '¨'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 55,  # 'Ş'
    171: CharacterCategory.SYMBOL,  # '«'
    172: CharacterCategory.SYMBOL,  # '¬'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: 0,  # 'Ż'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.SYMBOL,  # '˛'
    179: 0,  # 'ł'
    180: CharacterCategory.SYMBOL,  # '´'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: CharacterCategory.SYMBOL,  # '¸'
    185: 0,  # 'ą'
    186: 23,  # 'ş'
    187: CharacterCategory.SYMBOL,  # '»'
    188: 0,  # 'Ľ'
    189: CharacterCategory.SYMBOL,  # '˝'
    190: 0,  # 'ľ'
    191: 0,  # 'ż'
    192: 0,  # 'Ŕ'
    193: 0,  # 'Á'
    194: 62,  # 'Â'
    195: 57,  # 'Ă'
    196: 0,  # 'Ä'
    197: 0,  # 'Ĺ'
    198: 0,  # 'Ć'
    199: 0,  # 'Ç'
    200: 0,  # 'Č'
    201: 0,  # 'É'
    202: 0,  # 'Ę'
    203: 0,  # 'Ë'
    204: 0,  # 'Ě'
    205: 0,  # 'Í'
    206: 47,  # 'Î'
    207: 0,  # 'Ď'
    208: 0,  # 'Đ'
    209: 0,  # 'Ń'
    210: 0,  # 'Ň'
    211: 0,  # 'Ó'
    212: 0,  # 'Ô'
    213: 0,  # 'Ő'
    214: 0,  # 'Ö'
    215: CharacterCategory.SYMBOL,  # '×'
    216: 0,  # 'Ř'
    217: 0,  # 'Ů'
    218: 0,  # 'Ú'
    219: 0,  # 'Ű'
    220: 0,  # 'Ü'
    221: 0,  # 'Ý'
    222: 59,  # 'Ţ'
    223: 0,  # 'ß'
    224: 0,  # 'ŕ'
    225: 0,  # 'á'
    226: 27,  # 'â'
    227: 15,  # 'ă'
    228: 0,  # 'ä'
    229: 0,  # 'ĺ'
    230: 0,  # 'ć'
    231: 0,  # 'ç'
    232: 0,  # 'č'
    233: 0,  # 'é'
    234: 0,  # 'ę'
    235: 0,  # 'ë'
    236: 0,  # 'ě'
    237: 0,  # 'í'
    238: 21,  # 'î'
    239: 0,  # 'ď'
    240: 0,  # 'đ'
    241: 0,  # 'ń'
    242: 0,  # 'ň'
    243: 0,  # 'ó'
    244: 0,  # 'ô'
    245: 0,  # 'ő'
    246: 0,  # 'ö'
    247: CharacterCategory.SYMBOL,  # '÷'
    248: 0,  # 'ř'
    249: 0,  # 'ů'
    250: 0,  # 'ú'
    251: 0,  # 'ű'
    252: 0,  # 'ü'
    253: 0,  # 'ý'
    254: 22,  # 'ţ'
    255: CharacterCategory.SYMBOL,  # '˙'
}

WINDOWS_1250_ROMANIAN_MODEL = SingleByteCharSetModel(
    charset_name="WINDOWS-1250",
    language="Romanian",
    char_to_order_map=WINDOWS_1250_ROMANIAN_CHAR_TO_ORDER,
    language_model=ROMANIAN_LANG_MODEL,
    typical_positive_ratio=0.9820884516758617,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÂÎâîĂăȘșȚț",
)
