\name{BSplineDecompositionImageFilter}
\alias{BSplineDecompositionImageFilter}
\title{BSplineDecompositionImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Calculates the B-Spline coefficients of an image. Spline order may be
from 0 to 5.
BSplineDecompositionImageFilter}
\details{
This class defines N-Dimension B-Spline transformation. It is based
on: [1] M. Unser, "Splines: A Perfect Fit for Signal and Image
Processing," IEEE Signal Processing Magazine, vol. 16, no. 6, pp.
22-38, November 1999. [2] M. Unser, A. Aldroubi and M. Eden,
"B-Spline Signal Processing: Part I--Theory," IEEE Transactions on
Signal Processing, vol. 41, no. 2, pp. 821-832, February 1993. [3] M.
Unser, A. Aldroubi and M. Eden, "B-Spline Signal Processing: Part II
--Efficient Design and Applications," IEEE Transactions on Signal
Processing, vol. 41, no. 2, pp. 834-848, February 1993. And code obtained from bigwww.epfl.ch by Philippe Thevenaz
Limitations: Spline order must be between 0 and 5. Spline order must
be set before setting the image. Uses mirror boundary conditions.
Requires the same order of Spline for each dimension. Can only process
LargestPossibleRegion
See:
BSplineResampleImageFunction
BSplineDecomposition for the procedural interface
itk::BSplineDecompositionImageFilter for the Doxygen on the original ITK class.
BSplineDecompositionImageFilter}
%C++ includes: sitkBSplineDecompositionImageFilter.h
\section{Methods}{
\describe{
\item{ BSplineDecompositionImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{std::string GetName() const:}{
Name of this class
}
\item{uint32_t GetSplineOrder() const:}{}
\item{std::vector< double > GetSplinePoles() const:}{
Get the poles calculated for a given spline order.
This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.
}
\item{Self SetSplineOrder(uint32_t SplineOrder):}{
Get/Sets the Spline Order, supports 0th - 5th order splines. The
default is a 3rd order spline.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~BSplineDecompositionImageFilter():}{
Destructor
}
}
}
