/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util.av;

import com.jogamp.common.av.AudioSink;
import com.jogamp.common.net.Uri;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.util.texture.TextureSequence;
import java.util.List;
import jogamp.opengl.Debug;

public interface GLMediaPlayer
extends TextureSequence {
    public static final boolean DEBUG = Debug.debug("GLMediaPlayer");
    public static final boolean DEBUG_AVSYNC = Debug.debug("GLMediaPlayer.AVSync");
    public static final boolean DEBUG_NATIVE = Debug.debug("GLMediaPlayer.Native");
    public static final int TEXTURE_COUNT_DEFAULT = 4;
    public static final int TEXTURE_COUNT_MIN = 1;
    public static final int STREAM_ID_NONE = -2;
    public static final int STREAM_ID_AUTO = -1;
    public static final Uri.Encoded CameraInputScheme = Uri.Encoded.cast((String)"camera");
    public static final String CameraPropSizeS = "size";
    public static final String CameraPropWidth = "width";
    public static final String CameraPropHeight = "height";
    public static final String CameraPropRate = "rate";
    public static final int MAXIMUM_VIDEO_ASYNC = 22;

    public int getTextureCount();

    public void setTextureUnit(int var1);

    public void setTextureMinMagFilter(int[] var1);

    public void setTextureWrapST(int[] var1);

    public void setAudioChannelLimit(int var1);

    public void playStream(Uri var1, int var2, int var3, int var4) throws IllegalStateException, IllegalArgumentException;

    public StreamException getStreamException();

    public void initGL(GL var1) throws IllegalStateException, StreamException, GLException;

    public AudioSink getAudioSink();

    public State destroy(GL var1);

    public State stop();

    public boolean setPlaySpeed(float var1);

    public float getPlaySpeed();

    public boolean setAudioVolume(float var1);

    public float getAudioVolume();

    public State resume();

    public State pause(boolean var1);

    public int seek(int var1);

    public State getState();

    public int getVID();

    public int getAID();

    public int getDecodedFrameCount();

    public int getPresentedFrameCount();

    public int getVideoPTS();

    public int getAudioPTS();

    @Override
    public TextureSequence.TextureFrame getLastTexture() throws IllegalStateException;

    @Override
    public TextureSequence.TextureFrame getNextTexture(GL var1) throws IllegalStateException;

    public Uri getUri();

    public String getVideoCodec();

    public String getAudioCodec();

    public int getVideoFrames();

    public int getAudioFrames();

    public int getDuration();

    public long getStreamBitrate();

    public int getVideoBitrate();

    public int getAudioBitrate();

    public float getFramerate();

    public boolean isGLOriented();

    public int getWidth();

    public int getHeight();

    public String toString();

    public String getPerfString();

    public void addEventListener(GLMediaEventListener var1);

    public void removeEventListener(GLMediaEventListener var1);

    public GLMediaEventListener[] getEventListeners();

    public Object getAttachedObject(String var1);

    public Object attachObject(String var1, Object var2);

    public Object detachObject(String var1);

    public static enum State {
        Uninitialized(0),
        Initialized(1),
        Playing(2),
        Paused(3);

        public final int id;

        private State(int n2) {
            this.id = n2;
        }
    }

    public static final class EventMask {
        public int mask;

        public static int getBits(List<Bit> list) {
            int n = 0;
            for (Bit bit : list) {
                n |= bit.value;
            }
            return n;
        }

        public EventMask(List<Bit> list) {
            this.mask = EventMask.getBits(list);
        }

        public EventMask(Bit bit) {
            this.mask = bit.value;
        }

        public EventMask(int n) {
            this.mask = n;
        }

        public EventMask() {
            this.mask = 0;
        }

        public boolean isSet(Bit bit) {
            return bit.value == (this.mask & bit.value);
        }

        public boolean isSet(List<Bit> list) {
            int n = EventMask.getBits(list);
            return n == (this.mask & n);
        }

        public boolean isSet(int n) {
            return n == (this.mask & n);
        }

        public boolean isZero() {
            return 0 == this.mask;
        }

        public EventMask setBit(Bit bit) {
            this.mask |= bit.value;
            return this;
        }

        public EventMask setBits(List<Bit> list) {
            for (Bit bit : list) {
                this.mask |= bit.value;
            }
            return this;
        }

        public String toString() {
            int n = 0;
            StringBuilder stringBuilder = new StringBuilder();
            for (Bit bit : Bit.values()) {
                if (!this.isSet(bit)) continue;
                if (0 < n) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(bit.name());
                ++n;
            }
            if (0 == n) {
                stringBuilder.append("None");
            } else if (1 < n) {
                stringBuilder.insert(0, "[");
                stringBuilder.append("]");
            }
            return stringBuilder.toString();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            return object instanceof EventMask && this.mask == ((EventMask)object).mask;
        }

        public static enum Bit {
            Init(1),
            Uninit(2),
            Play(4),
            Pause(8),
            EOS(16),
            Error(32),
            VID(65536),
            AID(131072),
            Size(262144),
            FPS(524288),
            BPS(0x100000),
            Length(0x200000),
            Codec(0x400000);

            public final int value;

            private Bit(int n2) {
                this.value = n2;
            }
        }
    }

    public static interface GLMediaEventListener
    extends TextureSequence.TexSeqEventListener<GLMediaPlayer> {
        public void attributesChanged(GLMediaPlayer var1, EventMask var2, long var3);
    }

    public static class StreamException
    extends Exception {
        public StreamException(Throwable throwable) {
            super(throwable);
        }

        public StreamException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }
}

