/* SPDX-License-Identifier: (LGPL-2.1 OR BSD-2-Clause) */

/* THIS FILE IS AUTOGENERATED BY BPFTOOL! */
#ifndef __CACHESTAT_BPF_SKEL_H__
#define __CACHESTAT_BPF_SKEL_H__

#include <errno.h>
#include <stdlib.h>
#include <bpf/libbpf.h>

struct cachestat_bpf {
	struct bpf_object_skeleton *skeleton;
	struct bpf_object *obj;
	struct {
		struct bpf_map *bss;
	} maps;
	struct {
		struct bpf_program *fentry_add_to_page_cache_lru;
		struct bpf_program *fentry_mark_page_accessed;
		struct bpf_program *fentry_account_page_dirtied;
		struct bpf_program *fentry_mark_buffer_dirty;
		struct bpf_program *kprobe_add_to_page_cache_lru;
		struct bpf_program *kprobe_mark_page_accessed;
		struct bpf_program *kprobe_account_page_dirtied;
		struct bpf_program *kprobe_folio_account_dirtied;
		struct bpf_program *kprobe_mark_buffer_dirty;
		struct bpf_program *tracepoint__writeback_dirty_folio;
		struct bpf_program *tracepoint__writeback_dirty_page;
	} progs;
	struct {
		struct bpf_link *fentry_add_to_page_cache_lru;
		struct bpf_link *fentry_mark_page_accessed;
		struct bpf_link *fentry_account_page_dirtied;
		struct bpf_link *fentry_mark_buffer_dirty;
		struct bpf_link *kprobe_add_to_page_cache_lru;
		struct bpf_link *kprobe_mark_page_accessed;
		struct bpf_link *kprobe_account_page_dirtied;
		struct bpf_link *kprobe_folio_account_dirtied;
		struct bpf_link *kprobe_mark_buffer_dirty;
		struct bpf_link *tracepoint__writeback_dirty_folio;
		struct bpf_link *tracepoint__writeback_dirty_page;
	} links;
	struct cachestat_bpf__bss {
		__s64 total;
		__s64 misses;
		__u64 mbd;
	} *bss;

#ifdef __cplusplus
	static inline struct cachestat_bpf *open(const struct bpf_object_open_opts *opts = nullptr);
	static inline struct cachestat_bpf *open_and_load();
	static inline int load(struct cachestat_bpf *skel);
	static inline int attach(struct cachestat_bpf *skel);
	static inline void detach(struct cachestat_bpf *skel);
	static inline void destroy(struct cachestat_bpf *skel);
	static inline const void *elf_bytes(size_t *sz);
#endif /* __cplusplus */
};

static void
cachestat_bpf__destroy(struct cachestat_bpf *obj)
{
	if (!obj)
		return;
	if (obj->skeleton)
		bpf_object__destroy_skeleton(obj->skeleton);
	free(obj);
}

static inline int
cachestat_bpf__create_skeleton(struct cachestat_bpf *obj);

static inline struct cachestat_bpf *
cachestat_bpf__open_opts(const struct bpf_object_open_opts *opts)
{
	struct cachestat_bpf *obj;
	int err;

	obj = (struct cachestat_bpf *)calloc(1, sizeof(*obj));
	if (!obj) {
		errno = ENOMEM;
		return NULL;
	}

	err = cachestat_bpf__create_skeleton(obj);
	if (err)
		goto err_out;

	err = bpf_object__open_skeleton(obj->skeleton, opts);
	if (err)
		goto err_out;

	return obj;
err_out:
	cachestat_bpf__destroy(obj);
	errno = -err;
	return NULL;
}

static inline struct cachestat_bpf *
cachestat_bpf__open(void)
{
	return cachestat_bpf__open_opts(NULL);
}

static inline int
cachestat_bpf__load(struct cachestat_bpf *obj)
{
	return bpf_object__load_skeleton(obj->skeleton);
}

static inline struct cachestat_bpf *
cachestat_bpf__open_and_load(void)
{
	struct cachestat_bpf *obj;
	int err;

	obj = cachestat_bpf__open();
	if (!obj)
		return NULL;
	err = cachestat_bpf__load(obj);
	if (err) {
		cachestat_bpf__destroy(obj);
		errno = -err;
		return NULL;
	}
	return obj;
}

static inline int
cachestat_bpf__attach(struct cachestat_bpf *obj)
{
	return bpf_object__attach_skeleton(obj->skeleton);
}

static inline void
cachestat_bpf__detach(struct cachestat_bpf *obj)
{
	bpf_object__detach_skeleton(obj->skeleton);
}

static inline const void *cachestat_bpf__elf_bytes(size_t *sz);

static inline int
cachestat_bpf__create_skeleton(struct cachestat_bpf *obj)
{
	struct bpf_object_skeleton *s;
	int err;

	s = (struct bpf_object_skeleton *)calloc(1, sizeof(*s));
	if (!s)	{
		err = -ENOMEM;
		goto err;
	}

	s->sz = sizeof(*s);
	s->name = "cachestat_bpf";
	s->obj = &obj->obj;

	/* maps */
	s->map_cnt = 1;
	s->map_skel_sz = sizeof(*s->maps);
	s->maps = (struct bpf_map_skeleton *)calloc(s->map_cnt, s->map_skel_sz);
	if (!s->maps) {
		err = -ENOMEM;
		goto err;
	}

	s->maps[0].name = "cachesta.bss";
	s->maps[0].map = &obj->maps.bss;
	s->maps[0].mmaped = (void **)&obj->bss;

	/* programs */
	s->prog_cnt = 11;
	s->prog_skel_sz = sizeof(*s->progs);
	s->progs = (struct bpf_prog_skeleton *)calloc(s->prog_cnt, s->prog_skel_sz);
	if (!s->progs) {
		err = -ENOMEM;
		goto err;
	}

	s->progs[0].name = "fentry_add_to_page_cache_lru";
	s->progs[0].prog = &obj->progs.fentry_add_to_page_cache_lru;
	s->progs[0].link = &obj->links.fentry_add_to_page_cache_lru;

	s->progs[1].name = "fentry_mark_page_accessed";
	s->progs[1].prog = &obj->progs.fentry_mark_page_accessed;
	s->progs[1].link = &obj->links.fentry_mark_page_accessed;

	s->progs[2].name = "fentry_account_page_dirtied";
	s->progs[2].prog = &obj->progs.fentry_account_page_dirtied;
	s->progs[2].link = &obj->links.fentry_account_page_dirtied;

	s->progs[3].name = "fentry_mark_buffer_dirty";
	s->progs[3].prog = &obj->progs.fentry_mark_buffer_dirty;
	s->progs[3].link = &obj->links.fentry_mark_buffer_dirty;

	s->progs[4].name = "kprobe_add_to_page_cache_lru";
	s->progs[4].prog = &obj->progs.kprobe_add_to_page_cache_lru;
	s->progs[4].link = &obj->links.kprobe_add_to_page_cache_lru;

	s->progs[5].name = "kprobe_mark_page_accessed";
	s->progs[5].prog = &obj->progs.kprobe_mark_page_accessed;
	s->progs[5].link = &obj->links.kprobe_mark_page_accessed;

	s->progs[6].name = "kprobe_account_page_dirtied";
	s->progs[6].prog = &obj->progs.kprobe_account_page_dirtied;
	s->progs[6].link = &obj->links.kprobe_account_page_dirtied;

	s->progs[7].name = "kprobe_folio_account_dirtied";
	s->progs[7].prog = &obj->progs.kprobe_folio_account_dirtied;
	s->progs[7].link = &obj->links.kprobe_folio_account_dirtied;

	s->progs[8].name = "kprobe_mark_buffer_dirty";
	s->progs[8].prog = &obj->progs.kprobe_mark_buffer_dirty;
	s->progs[8].link = &obj->links.kprobe_mark_buffer_dirty;

	s->progs[9].name = "tracepoint__writeback_dirty_folio";
	s->progs[9].prog = &obj->progs.tracepoint__writeback_dirty_folio;
	s->progs[9].link = &obj->links.tracepoint__writeback_dirty_folio;

	s->progs[10].name = "tracepoint__writeback_dirty_page";
	s->progs[10].prog = &obj->progs.tracepoint__writeback_dirty_page;
	s->progs[10].link = &obj->links.tracepoint__writeback_dirty_page;

	s->data = (void *)cachestat_bpf__elf_bytes(&s->data_sz);

	obj->skeleton = s;
	return 0;
err:
	bpf_object__destroy_skeleton(s);
	return err;
}

static inline const void *cachestat_bpf__elf_bytes(size_t *sz)
{
	*sz = 9408;
	return (const void *)"\
\x7f\x45\x4c\x46\x02\x01\x01\0\0\0\0\0\0\0\0\0\x01\0\xf7\0\x01\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\x80\x1c\0\0\0\0\0\0\0\0\0\0\x40\0\0\0\0\0\x40\0\x21\0\
\x01\0\xb7\x01\0\0\x01\0\0\0\x18\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xdb\x12\0\0\
\x01\0\0\0\xb4\0\0\0\0\0\0\0\x95\0\0\0\0\0\0\0\xb7\x01\0\0\x01\0\0\0\x18\x02\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\xdb\x12\0\0\x01\0\0\0\xb4\0\0\0\0\0\0\0\x95\0\0\0\0\
\0\0\0\xb7\x01\0\0\xff\xff\xff\xff\x18\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xdb\x12\
\0\0\x01\0\0\0\xb4\0\0\0\0\0\0\0\x95\0\0\0\0\0\0\0\xb7\x01\0\0\xff\xff\xff\xff\
\x18\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xdb\x12\0\0\x01\0\0\0\xb7\x01\0\0\x01\0\0\
\0\x18\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xdb\x12\0\0\x01\0\0\0\xb4\0\0\0\0\0\0\0\
\x95\0\0\0\0\0\0\0\xb7\x01\0\0\x01\0\0\0\x18\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\xdb\x12\0\0\x01\0\0\0\xb4\0\0\0\0\0\0\0\x95\0\0\0\0\0\0\0\xb7\x01\0\0\x01\0\0\
\0\x18\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xdb\x12\0\0\x01\0\0\0\xb4\0\0\0\0\0\0\0\
\x95\0\0\0\0\0\0\0\xb7\x01\0\0\xff\xff\xff\xff\x18\x02\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\xdb\x12\0\0\x01\0\0\0\xb4\0\0\0\0\0\0\0\x95\0\0\0\0\0\0\0\xb7\x01\0\0\xff\
\xff\xff\xff\x18\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xdb\x12\0\0\x01\0\0\0\xb4\0\0\
\0\0\0\0\0\x95\0\0\0\0\0\0\0\xb7\x01\0\0\xff\xff\xff\xff\x18\x02\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\xdb\x12\0\0\x01\0\0\0\xb7\x01\0\0\x01\0\0\0\x18\x02\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\xdb\x12\0\0\x01\0\0\0\xb4\0\0\0\0\0\0\0\x95\0\0\0\0\0\0\0\xb7\
\x01\0\0\xff\xff\xff\xff\x18\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xdb\x12\0\0\x01\0\
\0\0\xb4\0\0\0\0\0\0\0\x95\0\0\0\0\0\0\0\xb7\x01\0\0\xff\xff\xff\xff\x18\x02\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\xdb\x12\0\0\x01\0\0\0\xb4\0\0\0\0\0\0\0\x95\0\0\0\0\
\0\0\0\x47\x50\x4c\0\x9f\xeb\x01\0\x18\0\0\0\0\0\0\0\xb4\x05\0\0\xb4\x05\0\0\
\x23\x07\0\0\0\0\0\0\0\0\0\x02\x02\0\0\0\x01\0\0\0\0\0\0\x01\x08\0\0\0\x40\0\0\
\0\0\0\0\0\x01\0\0\x0d\x04\0\0\0\x14\0\0\0\x01\0\0\0\x18\0\0\0\0\0\0\x01\x04\0\
\0\0\x20\0\0\x01\x1c\0\0\0\x01\0\0\x0c\x03\0\0\0\0\0\0\0\x01\0\0\x0d\x04\0\0\0\
\x14\0\0\0\x01\0\0\0\xd4\0\0\0\x01\0\0\x0c\x06\0\0\0\0\0\0\0\x01\0\0\x0d\x04\0\
\0\0\x14\0\0\0\x01\0\0\0\x52\x01\0\0\x01\0\0\x0c\x08\0\0\0\0\0\0\0\x01\0\0\x0d\
\x04\0\0\0\x14\0\0\0\x01\0\0\0\xd8\x01\0\0\x01\0\0\x0c\x0a\0\0\0\0\0\0\0\0\0\0\
\x02\x0d\0\0\0\x74\x02\0\0\x15\0\0\x04\xa8\0\0\0\x7c\x02\0\0\x0e\0\0\0\0\0\0\0\
\x80\x02\0\0\x0e\0\0\0\x40\0\0\0\x84\x02\0\0\x0e\0\0\0\x80\0\0\0\x88\x02\0\0\
\x0e\0\0\0\xc0\0\0\0\x8c\x02\0\0\x0e\0\0\0\0\x01\0\0\x8f\x02\0\0\x0e\0\0\0\x40\
\x01\0\0\x92\x02\0\0\x0e\0\0\0\x80\x01\0\0\x96\x02\0\0\x0e\0\0\0\xc0\x01\0\0\
\x9a\x02\0\0\x0e\0\0\0\0\x02\0\0\x9d\x02\0\0\x0e\0\0\0\x40\x02\0\0\xa0\x02\0\0\
\x0e\0\0\0\x80\x02\0\0\xa3\x02\0\0\x0e\0\0\0\xc0\x02\0\0\xa6\x02\0\0\x0e\0\0\0\
\0\x03\0\0\xa9\x02\0\0\x0e\0\0\0\x40\x03\0\0\xac\x02\0\0\x0e\0\0\0\x80\x03\0\0\
\xaf\x02\0\0\x0e\0\0\0\xc0\x03\0\0\xb7\x02\0\0\x0e\0\0\0\0\x04\0\0\0\0\0\0\x0f\
\0\0\0\x40\x04\0\0\xba\x02\0\0\x0e\0\0\0\x80\x04\0\0\xc0\x02\0\0\x0e\0\0\0\xc0\
\x04\0\0\0\0\0\0\x16\0\0\0\0\x05\0\0\xc3\x02\0\0\0\0\0\x01\x08\0\0\0\x40\0\0\0\
\0\0\0\0\x03\0\0\x05\x08\0\0\0\xd1\x02\0\0\x10\0\0\0\0\0\0\0\xd4\x02\0\0\x13\0\
\0\0\0\0\0\0\xd8\x02\0\0\x15\0\0\0\0\0\0\0\xe0\x02\0\0\0\0\0\x08\x11\0\0\0\xe4\
\x02\0\0\0\0\0\x08\x12\0\0\0\xea\x02\0\0\0\0\0\x01\x02\0\0\0\x10\0\0\0\xf9\x02\
\0\0\0\0\0\x08\x14\0\0\0\xfd\x02\0\0\0\0\0\x08\x02\0\0\0\xd8\x02\0\0\x03\0\0\
\x84\x08\0\0\0\xd1\x02\0\0\x13\0\0\0\0\0\0\x10\x03\x03\0\0\x13\0\0\0\x10\0\0\
\x02\x06\x03\0\0\x13\0\0\0\x12\0\0\x01\0\0\0\0\x03\0\0\x05\x08\0\0\0\x0a\x03\0\
\0\x10\0\0\0\0\0\0\0\x0d\x03\0\0\x13\0\0\0\0\0\0\0\x11\x03\0\0\x17\0\0\0\0\0\0\
\0\x11\x03\0\0\x0a\0\0\x84\x08\0\0\0\x0a\x03\0\0\x13\0\0\0\0\0\0\x10\x19\x03\0\
\0\x13\0\0\0\x10\0\0\x01\x1d\x03\0\0\x13\0\0\0\x11\0\0\x01\x25\x03\0\0\x13\0\0\
\0\x12\0\0\x01\x29\x03\0\0\x13\0\0\0\x20\0\0\x08\x30\x03\0\0\x13\0\0\0\x30\0\0\
\x04\x35\x03\0\0\x13\0\0\0\x38\0\0\x01\x3d\x03\0\0\x13\0\0\0\x39\0\0\x01\x40\
\x03\0\0\x13\0\0\0\x3a\0\0\x01\x47\x03\0\0\x13\0\0\0\x3c\0\0\x04\0\0\0\0\x01\0\
\0\x0d\x04\0\0\0\x14\0\0\0\x0c\0\0\0\x4f\x03\0\0\x01\0\0\x0c\x18\0\0\0\0\0\0\0\
\x01\0\0\x0d\x04\0\0\0\x14\0\0\0\x0c\0\0\0\xb6\x03\0\0\x01\0\0\x0c\x1a\0\0\0\0\
\0\0\0\x01\0\0\x0d\x04\0\0\0\x14\0\0\0\x0c\0\0\0\x14\x04\0\0\x01\0\0\x0c\x1c\0\
\0\0\0\0\0\0\x01\0\0\x0d\x04\0\0\0\x14\0\0\0\x0c\0\0\0\x78\x04\0\0\x01\0\0\x0c\
\x1e\0\0\0\0\0\0\0\x01\0\0\x0d\x04\0\0\0\x14\0\0\0\x0c\0\0\0\xdf\x04\0\0\x01\0\
\0\x0c\x20\0\0\0\0\0\0\0\0\0\0\x02\x23\0\0\0\x3a\x05\0\0\x04\0\0\x04\x40\0\0\0\
\x54\x05\0\0\x24\0\0\0\0\0\0\0\x58\x05\0\0\x26\0\0\0\x40\0\0\0\x5b\x05\0\0\x27\
\0\0\0\x80\0\0\0\x60\x05\0\0\x2a\0\0\0\0\x02\0\0\x67\x05\0\0\x04\0\0\x04\x08\0\
\0\0\x30\x03\0\0\x12\0\0\0\0\0\0\0\xba\x02\0\0\x25\0\0\0\x10\0\0\0\x73\x05\0\0\
\x25\0\0\0\x18\0\0\0\x81\x05\0\0\x04\0\0\0\x20\0\0\0\x85\x05\0\0\0\0\0\x01\x01\
\0\0\0\x08\0\0\0\x93\x05\0\0\0\0\0\x01\x08\0\0\0\x40\0\0\x01\0\0\0\0\0\0\0\x03\
\0\0\0\0\x0e\0\0\0\x28\0\0\0\x06\0\0\0\x98\x05\0\0\0\0\0\x01\x04\0\0\0\x20\0\0\
\0\xac\x05\0\0\0\0\0\x01\x01\0\0\0\x08\0\0\x01\0\0\0\0\0\0\0\x03\0\0\0\0\x29\0\
\0\0\x28\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\x0d\x04\0\0\0\x14\0\0\0\x22\0\0\0\xb1\
\x05\0\0\x01\0\0\x0c\x2b\0\0\0\0\0\0\0\x01\0\0\x0d\x04\0\0\0\x14\0\0\0\x22\0\0\
\0\x56\x06\0\0\x01\0\0\x0c\x2d\0\0\0\xed\x06\0\0\0\0\0\x08\x30\0\0\0\xf3\x06\0\
\0\0\0\0\x01\x08\0\0\0\x40\0\0\x01\xfd\x06\0\0\0\0\0\x0e\x2f\0\0\0\x01\0\0\0\
\x03\x07\0\0\0\0\0\x0e\x2f\0\0\0\x01\0\0\0\x0a\x07\0\0\0\0\0\x0e\x14\0\0\0\x01\
\0\0\0\0\0\0\0\0\0\0\x03\0\0\0\0\x29\0\0\0\x28\0\0\0\x04\0\0\0\x0e\x07\0\0\0\0\
\0\x0e\x34\0\0\0\x01\0\0\0\x16\x07\0\0\x03\0\0\x0f\0\0\0\0\x31\0\0\0\0\0\0\0\
\x08\0\0\0\x32\0\0\0\0\0\0\0\x08\0\0\0\x33\0\0\0\0\0\0\0\x08\0\0\0\x1b\x07\0\0\
\x01\0\0\x0f\0\0\0\0\x35\0\0\0\0\0\0\0\x04\0\0\0\0\x75\x6e\x73\x69\x67\x6e\x65\
\x64\x20\x6c\x6f\x6e\x67\x20\x6c\x6f\x6e\x67\0\x63\x74\x78\0\x69\x6e\x74\0\x66\
\x65\x6e\x74\x72\x79\x5f\x61\x64\x64\x5f\x74\x6f\x5f\x70\x61\x67\x65\x5f\x63\
\x61\x63\x68\x65\x5f\x6c\x72\x75\0\x66\x65\x6e\x74\x72\x79\x2f\x61\x64\x64\x5f\
\x74\x6f\x5f\x70\x61\x67\x65\x5f\x63\x61\x63\x68\x65\x5f\x6c\x72\x75\0\x2f\x62\
\x75\x69\x6c\x64\x2f\x62\x63\x63\x2f\x73\x72\x63\x2f\x62\x63\x63\x2f\x6c\x69\
\x62\x62\x70\x66\x2d\x74\x6f\x6f\x6c\x73\x2f\x63\x61\x63\x68\x65\x73\x74\x61\
\x74\x2e\x62\x70\x66\x2e\x63\0\x69\x6e\x74\x20\x42\x50\x46\x5f\x50\x52\x4f\x47\
\x28\x66\x65\x6e\x74\x72\x79\x5f\x61\x64\x64\x5f\x74\x6f\x5f\x70\x61\x67\x65\
\x5f\x63\x61\x63\x68\x65\x5f\x6c\x72\x75\x29\0\x09\x5f\x5f\x73\x79\x6e\x63\x5f\
\x66\x65\x74\x63\x68\x5f\x61\x6e\x64\x5f\x61\x64\x64\x28\x26\x6d\x69\x73\x73\
\x65\x73\x2c\x20\x31\x29\x3b\0\x66\x65\x6e\x74\x72\x79\x5f\x6d\x61\x72\x6b\x5f\
\x70\x61\x67\x65\x5f\x61\x63\x63\x65\x73\x73\x65\x64\0\x66\x65\x6e\x74\x72\x79\
\x2f\x6d\x61\x72\x6b\x5f\x70\x61\x67\x65\x5f\x61\x63\x63\x65\x73\x73\x65\x64\0\
\x69\x6e\x74\x20\x42\x50\x46\x5f\x50\x52\x4f\x47\x28\x66\x65\x6e\x74\x72\x79\
\x5f\x6d\x61\x72\x6b\x5f\x70\x61\x67\x65\x5f\x61\x63\x63\x65\x73\x73\x65\x64\
\x29\0\x09\x5f\x5f\x73\x79\x6e\x63\x5f\x66\x65\x74\x63\x68\x5f\x61\x6e\x64\x5f\
\x61\x64\x64\x28\x26\x74\x6f\x74\x61\x6c\x2c\x20\x31\x29\x3b\0\x66\x65\x6e\x74\
\x72\x79\x5f\x61\x63\x63\x6f\x75\x6e\x74\x5f\x70\x61\x67\x65\x5f\x64\x69\x72\
\x74\x69\x65\x64\0\x66\x65\x6e\x74\x72\x79\x2f\x61\x63\x63\x6f\x75\x6e\x74\x5f\
\x70\x61\x67\x65\x5f\x64\x69\x72\x74\x69\x65\x64\0\x69\x6e\x74\x20\x42\x50\x46\
\x5f\x50\x52\x4f\x47\x28\x66\x65\x6e\x74\x72\x79\x5f\x61\x63\x63\x6f\x75\x6e\
\x74\x5f\x70\x61\x67\x65\x5f\x64\x69\x72\x74\x69\x65\x64\x29\0\x09\x5f\x5f\x73\
\x79\x6e\x63\x5f\x66\x65\x74\x63\x68\x5f\x61\x6e\x64\x5f\x61\x64\x64\x28\x26\
\x6d\x69\x73\x73\x65\x73\x2c\x20\x2d\x31\x29\x3b\0\x66\x65\x6e\x74\x72\x79\x5f\
\x6d\x61\x72\x6b\x5f\x62\x75\x66\x66\x65\x72\x5f\x64\x69\x72\x74\x79\0\x66\x65\
\x6e\x74\x72\x79\x2f\x6d\x61\x72\x6b\x5f\x62\x75\x66\x66\x65\x72\x5f\x64\x69\
\x72\x74\x79\0\x69\x6e\x74\x20\x42\x50\x46\x5f\x50\x52\x4f\x47\x28\x66\x65\x6e\
\x74\x72\x79\x5f\x6d\x61\x72\x6b\x5f\x62\x75\x66\x66\x65\x72\x5f\x64\x69\x72\
\x74\x79\x29\0\x09\x5f\x5f\x73\x79\x6e\x63\x5f\x66\x65\x74\x63\x68\x5f\x61\x6e\
\x64\x5f\x61\x64\x64\x28\x26\x74\x6f\x74\x61\x6c\x2c\x20\x2d\x31\x29\x3b\0\x09\
\x5f\x5f\x73\x79\x6e\x63\x5f\x66\x65\x74\x63\x68\x5f\x61\x6e\x64\x5f\x61\x64\
\x64\x28\x26\x6d\x62\x64\x2c\x20\x31\x29\x3b\0\x70\x74\x5f\x72\x65\x67\x73\0\
\x72\x31\x35\0\x72\x31\x34\0\x72\x31\x33\0\x72\x31\x32\0\x62\x70\0\x62\x78\0\
\x72\x31\x31\0\x72\x31\x30\0\x72\x39\0\x72\x38\0\x61\x78\0\x63\x78\0\x64\x78\0\
\x73\x69\0\x64\x69\0\x6f\x72\x69\x67\x5f\x61\x78\0\x69\x70\0\x66\x6c\x61\x67\
\x73\0\x73\x70\0\x75\x6e\x73\x69\x67\x6e\x65\x64\x20\x6c\x6f\x6e\x67\0\x63\x73\
\0\x63\x73\x78\0\x66\x72\x65\x64\x5f\x63\x73\0\x75\x31\x36\0\x5f\x5f\x75\x31\
\x36\0\x75\x6e\x73\x69\x67\x6e\x65\x64\x20\x73\x68\x6f\x72\x74\0\x75\x36\x34\0\
\x5f\x5f\x75\x36\x34\0\x73\x6c\0\x77\x66\x65\0\x73\x73\0\x73\x73\x78\0\x66\x72\
\x65\x64\x5f\x73\x73\0\x73\x74\x69\0\x73\x77\x65\x76\x65\x6e\x74\0\x6e\x6d\x69\
\0\x76\x65\x63\x74\x6f\x72\0\x74\x79\x70\x65\0\x65\x6e\x63\x6c\x61\x76\x65\0\
\x6c\x6d\0\x6e\x65\x73\x74\x65\x64\0\x69\x6e\x73\x6e\x6c\x65\x6e\0\x6b\x70\x72\
\x6f\x62\x65\x5f\x61\x64\x64\x5f\x74\x6f\x5f\x70\x61\x67\x65\x5f\x63\x61\x63\
\x68\x65\x5f\x6c\x72\x75\0\x6b\x70\x72\x6f\x62\x65\x2f\x61\x64\x64\x5f\x74\x6f\
\x5f\x70\x61\x67\x65\x5f\x63\x61\x63\x68\x65\x5f\x6c\x72\x75\0\x69\x6e\x74\x20\
\x42\x50\x46\x5f\x4b\x50\x52\x4f\x42\x45\x28\x6b\x70\x72\x6f\x62\x65\x5f\x61\
\x64\x64\x5f\x74\x6f\x5f\x70\x61\x67\x65\x5f\x63\x61\x63\x68\x65\x5f\x6c\x72\
\x75\x29\0\x6b\x70\x72\x6f\x62\x65\x5f\x6d\x61\x72\x6b\x5f\x70\x61\x67\x65\x5f\
\x61\x63\x63\x65\x73\x73\x65\x64\0\x6b\x70\x72\x6f\x62\x65\x2f\x6d\x61\x72\x6b\
\x5f\x70\x61\x67\x65\x5f\x61\x63\x63\x65\x73\x73\x65\x64\0\x69\x6e\x74\x20\x42\
\x50\x46\x5f\x4b\x50\x52\x4f\x42\x45\x28\x6b\x70\x72\x6f\x62\x65\x5f\x6d\x61\
\x72\x6b\x5f\x70\x61\x67\x65\x5f\x61\x63\x63\x65\x73\x73\x65\x64\x29\0\x6b\x70\
\x72\x6f\x62\x65\x5f\x61\x63\x63\x6f\x75\x6e\x74\x5f\x70\x61\x67\x65\x5f\x64\
\x69\x72\x74\x69\x65\x64\0\x6b\x70\x72\x6f\x62\x65\x2f\x61\x63\x63\x6f\x75\x6e\
\x74\x5f\x70\x61\x67\x65\x5f\x64\x69\x72\x74\x69\x65\x64\0\x69\x6e\x74\x20\x42\
\x50\x46\x5f\x4b\x50\x52\x4f\x42\x45\x28\x6b\x70\x72\x6f\x62\x65\x5f\x61\x63\
\x63\x6f\x75\x6e\x74\x5f\x70\x61\x67\x65\x5f\x64\x69\x72\x74\x69\x65\x64\x29\0\
\x6b\x70\x72\x6f\x62\x65\x5f\x66\x6f\x6c\x69\x6f\x5f\x61\x63\x63\x6f\x75\x6e\
\x74\x5f\x64\x69\x72\x74\x69\x65\x64\0\x6b\x70\x72\x6f\x62\x65\x2f\x66\x6f\x6c\
\x69\x6f\x5f\x61\x63\x63\x6f\x75\x6e\x74\x5f\x64\x69\x72\x74\x69\x65\x64\0\x69\
\x6e\x74\x20\x42\x50\x46\x5f\x4b\x50\x52\x4f\x42\x45\x28\x6b\x70\x72\x6f\x62\
\x65\x5f\x66\x6f\x6c\x69\x6f\x5f\x61\x63\x63\x6f\x75\x6e\x74\x5f\x64\x69\x72\
\x74\x69\x65\x64\x29\0\x6b\x70\x72\x6f\x62\x65\x5f\x6d\x61\x72\x6b\x5f\x62\x75\
\x66\x66\x65\x72\x5f\x64\x69\x72\x74\x79\0\x6b\x70\x72\x6f\x62\x65\x2f\x6d\x61\
\x72\x6b\x5f\x62\x75\x66\x66\x65\x72\x5f\x64\x69\x72\x74\x79\0\x69\x6e\x74\x20\
\x42\x50\x46\x5f\x4b\x50\x52\x4f\x42\x45\x28\x6b\x70\x72\x6f\x62\x65\x5f\x6d\
\x61\x72\x6b\x5f\x62\x75\x66\x66\x65\x72\x5f\x64\x69\x72\x74\x79\x29\0\x74\x72\
\x61\x63\x65\x5f\x65\x76\x65\x6e\x74\x5f\x72\x61\x77\x5f\x73\x79\x73\x5f\x65\
\x6e\x74\x65\x72\0\x65\x6e\x74\0\x69\x64\0\x61\x72\x67\x73\0\x5f\x5f\x64\x61\
\x74\x61\0\x74\x72\x61\x63\x65\x5f\x65\x6e\x74\x72\x79\0\x70\x72\x65\x65\x6d\
\x70\x74\x5f\x63\x6f\x75\x6e\x74\0\x70\x69\x64\0\x75\x6e\x73\x69\x67\x6e\x65\
\x64\x20\x63\x68\x61\x72\0\x6c\x6f\x6e\x67\0\x5f\x5f\x41\x52\x52\x41\x59\x5f\
\x53\x49\x5a\x45\x5f\x54\x59\x50\x45\x5f\x5f\0\x63\x68\x61\x72\0\x74\x72\x61\
\x63\x65\x70\x6f\x69\x6e\x74\x5f\x5f\x77\x72\x69\x74\x65\x62\x61\x63\x6b\x5f\
\x64\x69\x72\x74\x79\x5f\x66\x6f\x6c\x69\x6f\0\x74\x72\x61\x63\x65\x70\x6f\x69\
\x6e\x74\x2f\x77\x72\x69\x74\x65\x62\x61\x63\x6b\x2f\x77\x72\x69\x74\x65\x62\
\x61\x63\x6b\x5f\x64\x69\x72\x74\x79\x5f\x66\x6f\x6c\x69\x6f\0\x69\x6e\x74\x20\
\x74\x72\x61\x63\x65\x70\x6f\x69\x6e\x74\x5f\x5f\x77\x72\x69\x74\x65\x62\x61\
\x63\x6b\x5f\x64\x69\x72\x74\x79\x5f\x66\x6f\x6c\x69\x6f\x28\x73\x74\x72\x75\
\x63\x74\x20\x74\x72\x61\x63\x65\x5f\x65\x76\x65\x6e\x74\x5f\x72\x61\x77\x5f\
\x73\x79\x73\x5f\x65\x6e\x74\x65\x72\x2a\x20\x63\x74\x78\x29\0\x09\x72\x65\x74\
\x75\x72\x6e\x20\x30\x3b\0\x74\x72\x61\x63\x65\x70\x6f\x69\x6e\x74\x5f\x5f\x77\
\x72\x69\x74\x65\x62\x61\x63\x6b\x5f\x64\x69\x72\x74\x79\x5f\x70\x61\x67\x65\0\
\x74\x72\x61\x63\x65\x70\x6f\x69\x6e\x74\x2f\x77\x72\x69\x74\x65\x62\x61\x63\
\x6b\x2f\x77\x72\x69\x74\x65\x62\x61\x63\x6b\x5f\x64\x69\x72\x74\x79\x5f\x70\
\x61\x67\x65\0\x69\x6e\x74\x20\x74\x72\x61\x63\x65\x70\x6f\x69\x6e\x74\x5f\x5f\
\x77\x72\x69\x74\x65\x62\x61\x63\x6b\x5f\x64\x69\x72\x74\x79\x5f\x70\x61\x67\
\x65\x28\x73\x74\x72\x75\x63\x74\x20\x74\x72\x61\x63\x65\x5f\x65\x76\x65\x6e\
\x74\x5f\x72\x61\x77\x5f\x73\x79\x73\x5f\x65\x6e\x74\x65\x72\x2a\x20\x63\x74\
\x78\x29\0\x5f\x5f\x73\x36\x34\0\x6c\x6f\x6e\x67\x20\x6c\x6f\x6e\x67\0\x74\x6f\
\x74\x61\x6c\0\x6d\x69\x73\x73\x65\x73\0\x6d\x62\x64\0\x4c\x49\x43\x45\x4e\x53\
\x45\0\x2e\x62\x73\x73\0\x6c\x69\x63\x65\x6e\x73\x65\0\0\x9f\xeb\x01\0\x20\0\0\
\0\0\0\0\0\xb4\0\0\0\xb4\0\0\0\x8c\x02\0\0\x40\x03\0\0\0\0\0\0\x08\0\0\0\x39\0\
\0\0\x01\0\0\0\0\0\0\0\x05\0\0\0\xee\0\0\0\x01\0\0\0\0\0\0\0\x07\0\0\0\x6e\x01\
\0\0\x01\0\0\0\0\0\0\0\x09\0\0\0\xf1\x01\0\0\x01\0\0\0\0\0\0\0\x0b\0\0\0\x6c\
\x03\0\0\x01\0\0\0\0\0\0\0\x19\0\0\0\xd0\x03\0\0\x01\0\0\0\0\0\0\0\x1b\0\0\0\
\x30\x04\0\0\x01\0\0\0\0\0\0\0\x1d\0\0\0\x95\x04\0\0\x01\0\0\0\0\0\0\0\x1f\0\0\
\0\xf8\x04\0\0\x01\0\0\0\0\0\0\0\x21\0\0\0\xd3\x05\0\0\x01\0\0\0\0\0\0\0\x2c\0\
\0\0\x77\x06\0\0\x01\0\0\0\0\0\0\0\x2e\0\0\0\x10\0\0\0\x39\0\0\0\x03\0\0\0\0\0\
\0\0\x56\0\0\0\x86\0\0\0\0\x30\0\0\x08\0\0\0\x56\0\0\0\xb1\0\0\0\x02\x38\0\0\
\x20\0\0\0\x56\0\0\0\x86\0\0\0\x05\x30\0\0\xee\0\0\0\x03\0\0\0\0\0\0\0\x56\0\0\
\0\x08\x01\0\0\0\x4c\0\0\x08\0\0\0\x56\0\0\0\x30\x01\0\0\x02\x54\0\0\x20\0\0\0\
\x56\0\0\0\x08\x01\0\0\x05\x4c\0\0\x6e\x01\0\0\x03\0\0\0\0\0\0\0\x56\0\0\0\x8a\
\x01\0\0\0\x68\0\0\x08\0\0\0\x56\0\0\0\xb4\x01\0\0\x02\x70\0\0\x20\0\0\0\x56\0\
\0\0\x8a\x01\0\0\x05\x68\0\0\xf1\x01\0\0\x04\0\0\0\0\0\0\0\x56\0\0\0\x0a\x02\0\
\0\0\x84\0\0\x08\0\0\0\x56\0\0\0\x31\x02\0\0\x02\x8c\0\0\x28\0\0\0\x56\0\0\0\
\x54\x02\0\0\x02\x90\0\0\x40\0\0\0\x56\0\0\0\x0a\x02\0\0\x05\x84\0\0\x6c\x03\0\
\0\x03\0\0\0\0\0\0\0\x56\0\0\0\x89\x03\0\0\0\xa4\0\0\x08\0\0\0\x56\0\0\0\xb1\0\
\0\0\x02\xac\0\0\x20\0\0\0\x56\0\0\0\x89\x03\0\0\x05\xa4\0\0\xd0\x03\0\0\x03\0\
\0\0\0\0\0\0\x56\0\0\0\xea\x03\0\0\0\xc0\0\0\x08\0\0\0\x56\0\0\0\x30\x01\0\0\
\x02\xc8\0\0\x20\0\0\0\x56\0\0\0\xea\x03\0\0\x05\xc0\0\0\x30\x04\0\0\x03\0\0\0\
\0\0\0\0\x56\0\0\0\x4c\x04\0\0\0\xdc\0\0\x08\0\0\0\x56\0\0\0\xb4\x01\0\0\x02\
\xe4\0\0\x20\0\0\0\x56\0\0\0\x4c\x04\0\0\x05\xdc\0\0\x95\x04\0\0\x03\0\0\0\0\0\
\0\0\x56\0\0\0\xb2\x04\0\0\0\xf8\0\0\x08\0\0\0\x56\0\0\0\xb4\x01\0\0\x02\0\x01\
\0\x20\0\0\0\x56\0\0\0\xb2\x04\0\0\x05\xf8\0\0\xf8\x04\0\0\x04\0\0\0\0\0\0\0\
\x56\0\0\0\x11\x05\0\0\0\x14\x01\0\x08\0\0\0\x56\0\0\0\x31\x02\0\0\x02\x1c\x01\
\0\x28\0\0\0\x56\0\0\0\x54\x02\0\0\x02\x20\x01\0\x40\0\0\0\x56\0\0\0\x11\x05\0\
\0\x05\x14\x01\0\xd3\x05\0\0\x03\0\0\0\0\0\0\0\x56\0\0\0\xfe\x05\0\0\0\x34\x01\
\0\x08\0\0\0\x56\0\0\0\xb4\x01\0\0\x02\x3c\x01\0\x20\0\0\0\x56\0\0\0\x4b\x06\0\
\0\x02\x40\x01\0\x77\x06\0\0\x03\0\0\0\0\0\0\0\x56\0\0\0\xa1\x06\0\0\0\x50\x01\
\0\x08\0\0\0\x56\0\0\0\xb4\x01\0\0\x02\x58\x01\0\x20\0\0\0\x56\0\0\0\x4b\x06\0\
\0\x02\x5c\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\x03\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x03\0\x05\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x03\0\x07\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\x03\0\x09\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x03\0\x0b\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x03\0\x0d\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\x03\0\x0f\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x03\0\x11\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x03\0\x13\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\x03\0\x15\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x03\0\x17\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\x6d\0\0\0\x12\0\x03\0\0\0\0\0\0\0\0\0\x30\0\0\0\0\0\0\0\
\x01\x01\0\0\x11\0\x19\0\x08\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\xc4\x01\0\0\x12\0\
\x05\0\0\0\0\0\0\0\0\0\x30\0\0\0\0\0\0\0\x59\x01\0\0\x11\0\x19\0\0\0\0\0\0\0\0\
\0\x08\0\0\0\0\0\0\0\x72\x02\0\0\x12\0\x07\0\0\0\0\0\0\0\0\0\x30\0\0\0\0\0\0\0\
\x01\0\0\0\x12\0\x09\0\0\0\0\0\0\0\0\0\x50\0\0\0\0\0\0\0\xea\x02\0\0\x11\0\x19\
\0\x10\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\x8a\0\0\0\x12\0\x0b\0\0\0\0\0\0\0\0\0\
\x30\0\0\0\0\0\0\0\xde\x01\0\0\x12\0\x0d\0\0\0\0\0\0\0\0\0\x30\0\0\0\0\0\0\0\
\x8e\x02\0\0\x12\0\x0f\0\0\0\0\0\0\0\0\0\x30\0\0\0\0\0\0\0\x34\x02\0\0\x12\0\
\x11\0\0\0\0\0\0\0\0\0\x30\0\0\0\0\0\0\0\x1a\0\0\0\x12\0\x13\0\0\0\0\0\0\0\0\0\
\x50\0\0\0\0\0\0\0\x08\x01\0\0\x12\0\x15\0\0\0\0\0\0\0\0\0\x30\0\0\0\0\0\0\0\
\x75\x01\0\0\x12\0\x17\0\0\0\0\0\0\0\0\0\x30\0\0\0\0\0\0\0\x07\x03\0\0\x11\0\
\x1a\0\0\0\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\x01\0\0\0\x0d\0\0\0\
\x08\0\0\0\0\0\0\0\x01\0\0\0\x0f\0\0\0\x08\0\0\0\0\0\0\0\x01\0\0\0\x0d\0\0\0\
\x08\0\0\0\0\0\0\0\x01\0\0\0\x0f\0\0\0\x28\0\0\0\0\0\0\0\x01\0\0\0\x12\0\0\0\
\x08\0\0\0\0\0\0\0\x01\0\0\0\x0d\0\0\0\x08\0\0\0\0\0\0\0\x01\0\0\0\x0f\0\0\0\
\x08\0\0\0\0\0\0\0\x01\0\0\0\x0d\0\0\0\x08\0\0\0\0\0\0\0\x01\0\0\0\x0d\0\0\0\
\x08\0\0\0\0\0\0\0\x01\0\0\0\x0f\0\0\0\x28\0\0\0\0\0\0\0\x01\0\0\0\x12\0\0\0\
\x08\0\0\0\0\0\0\0\x01\0\0\0\x0d\0\0\0\x08\0\0\0\0\0\0\0\x01\0\0\0\x0d\0\0\0\
\x94\x05\0\0\0\0\0\0\x04\0\0\0\x0f\0\0\0\xa0\x05\0\0\0\0\0\0\x04\0\0\0\x0d\0\0\
\0\xac\x05\0\0\0\0\0\0\x04\0\0\0\x12\0\0\0\xc4\x05\0\0\0\0\0\0\x04\0\0\0\x1a\0\
\0\0\x2c\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x3c\0\0\0\0\0\0\0\x04\0\0\0\x02\0\0\
\0\x4c\0\0\0\0\0\0\0\x04\0\0\0\x03\0\0\0\x5c\0\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\
\x6c\0\0\0\0\0\0\0\x04\0\0\0\x05\0\0\0\x7c\0\0\0\0\0\0\0\x04\0\0\0\x06\0\0\0\
\x8c\0\0\0\0\0\0\0\x04\0\0\0\x07\0\0\0\x9c\0\0\0\0\0\0\0\x04\0\0\0\x08\0\0\0\
\xac\0\0\0\0\0\0\0\x04\0\0\0\x09\0\0\0\xbc\0\0\0\0\0\0\0\x04\0\0\0\x0a\0\0\0\
\xcc\0\0\0\0\0\0\0\x04\0\0\0\x0b\0\0\0\xe0\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\
\xf0\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\0\x01\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\
\x18\x01\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x28\x01\0\0\0\0\0\0\x04\0\0\0\x02\0\0\
\0\x38\x01\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x50\x01\0\0\0\0\0\0\x04\0\0\0\x03\0\
\0\0\x60\x01\0\0\0\0\0\0\x04\0\0\0\x03\0\0\0\x70\x01\0\0\0\0\0\0\x04\0\0\0\x03\
\0\0\0\x88\x01\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\x98\x01\0\0\0\0\0\0\x04\0\0\0\
\x04\0\0\0\xa8\x01\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\xb8\x01\0\0\0\0\0\0\x04\0\0\
\0\x04\0\0\0\xd0\x01\0\0\0\0\0\0\x04\0\0\0\x05\0\0\0\xe0\x01\0\0\0\0\0\0\x04\0\
\0\0\x05\0\0\0\xf0\x01\0\0\0\0\0\0\x04\0\0\0\x05\0\0\0\x08\x02\0\0\0\0\0\0\x04\
\0\0\0\x06\0\0\0\x18\x02\0\0\0\0\0\0\x04\0\0\0\x06\0\0\0\x28\x02\0\0\0\0\0\0\
\x04\0\0\0\x06\0\0\0\x40\x02\0\0\0\0\0\0\x04\0\0\0\x07\0\0\0\x50\x02\0\0\0\0\0\
\0\x04\0\0\0\x07\0\0\0\x60\x02\0\0\0\0\0\0\x04\0\0\0\x07\0\0\0\x78\x02\0\0\0\0\
\0\0\x04\0\0\0\x08\0\0\0\x88\x02\0\0\0\0\0\0\x04\0\0\0\x08\0\0\0\x98\x02\0\0\0\
\0\0\0\x04\0\0\0\x08\0\0\0\xb0\x02\0\0\0\0\0\0\x04\0\0\0\x09\0\0\0\xc0\x02\0\0\
\0\0\0\0\x04\0\0\0\x09\0\0\0\xd0\x02\0\0\0\0\0\0\x04\0\0\0\x09\0\0\0\xe0\x02\0\
\0\0\0\0\0\x04\0\0\0\x09\0\0\0\xf8\x02\0\0\0\0\0\0\x04\0\0\0\x0a\0\0\0\x08\x03\
\0\0\0\0\0\0\x04\0\0\0\x0a\0\0\0\x18\x03\0\0\0\0\0\0\x04\0\0\0\x0a\0\0\0\x30\
\x03\0\0\0\0\0\0\x04\0\0\0\x0b\0\0\0\x40\x03\0\0\0\0\0\0\x04\0\0\0\x0b\0\0\0\
\x50\x03\0\0\0\0\0\0\x04\0\0\0\x0b\0\0\0\x15\x17\x19\x1a\x1c\x1d\x1e\x1f\x20\
\x21\x22\x18\x16\x1b\x23\0\x66\x65\x6e\x74\x72\x79\x5f\x6d\x61\x72\x6b\x5f\x62\
\x75\x66\x66\x65\x72\x5f\x64\x69\x72\x74\x79\0\x6b\x70\x72\x6f\x62\x65\x5f\x6d\
\x61\x72\x6b\x5f\x62\x75\x66\x66\x65\x72\x5f\x64\x69\x72\x74\x79\0\x2e\x72\x65\
\x6c\x66\x65\x6e\x74\x72\x79\x2f\x6d\x61\x72\x6b\x5f\x62\x75\x66\x66\x65\x72\
\x5f\x64\x69\x72\x74\x79\0\x2e\x72\x65\x6c\x6b\x70\x72\x6f\x62\x65\x2f\x6d\x61\
\x72\x6b\x5f\x62\x75\x66\x66\x65\x72\x5f\x64\x69\x72\x74\x79\0\x66\x65\x6e\x74\
\x72\x79\x5f\x61\x64\x64\x5f\x74\x6f\x5f\x70\x61\x67\x65\x5f\x63\x61\x63\x68\
\x65\x5f\x6c\x72\x75\0\x6b\x70\x72\x6f\x62\x65\x5f\x61\x64\x64\x5f\x74\x6f\x5f\
\x70\x61\x67\x65\x5f\x63\x61\x63\x68\x65\x5f\x6c\x72\x75\0\x2e\x72\x65\x6c\x66\
\x65\x6e\x74\x72\x79\x2f\x61\x64\x64\x5f\x74\x6f\x5f\x70\x61\x67\x65\x5f\x63\
\x61\x63\x68\x65\x5f\x6c\x72\x75\0\x2e\x72\x65\x6c\x6b\x70\x72\x6f\x62\x65\x2f\
\x61\x64\x64\x5f\x74\x6f\x5f\x70\x61\x67\x65\x5f\x63\x61\x63\x68\x65\x5f\x6c\
\x72\x75\0\x2e\x74\x65\x78\x74\0\x2e\x72\x65\x6c\x2e\x42\x54\x46\x2e\x65\x78\
\x74\0\x2e\x62\x73\x73\0\x6d\x69\x73\x73\x65\x73\0\x74\x72\x61\x63\x65\x70\x6f\
\x69\x6e\x74\x5f\x5f\x77\x72\x69\x74\x65\x62\x61\x63\x6b\x5f\x64\x69\x72\x74\
\x79\x5f\x66\x6f\x6c\x69\x6f\0\x2e\x72\x65\x6c\x74\x72\x61\x63\x65\x70\x6f\x69\
\x6e\x74\x2f\x77\x72\x69\x74\x65\x62\x61\x63\x6b\x2f\x77\x72\x69\x74\x65\x62\
\x61\x63\x6b\x5f\x64\x69\x72\x74\x79\x5f\x66\x6f\x6c\x69\x6f\0\x74\x6f\x74\x61\
\x6c\0\x2e\x6c\x6c\x76\x6d\x5f\x61\x64\x64\x72\x73\x69\x67\0\x6c\x69\x63\x65\
\x6e\x73\x65\0\x74\x72\x61\x63\x65\x70\x6f\x69\x6e\x74\x5f\x5f\x77\x72\x69\x74\
\x65\x62\x61\x63\x6b\x5f\x64\x69\x72\x74\x79\x5f\x70\x61\x67\x65\0\x2e\x72\x65\
\x6c\x74\x72\x61\x63\x65\x70\x6f\x69\x6e\x74\x2f\x77\x72\x69\x74\x65\x62\x61\
\x63\x6b\x2f\x77\x72\x69\x74\x65\x62\x61\x63\x6b\x5f\x64\x69\x72\x74\x79\x5f\
\x70\x61\x67\x65\0\x66\x65\x6e\x74\x72\x79\x5f\x6d\x61\x72\x6b\x5f\x70\x61\x67\
\x65\x5f\x61\x63\x63\x65\x73\x73\x65\x64\0\x6b\x70\x72\x6f\x62\x65\x5f\x6d\x61\
\x72\x6b\x5f\x70\x61\x67\x65\x5f\x61\x63\x63\x65\x73\x73\x65\x64\0\x2e\x72\x65\
\x6c\x66\x65\x6e\x74\x72\x79\x2f\x6d\x61\x72\x6b\x5f\x70\x61\x67\x65\x5f\x61\
\x63\x63\x65\x73\x73\x65\x64\0\x2e\x72\x65\x6c\x6b\x70\x72\x6f\x62\x65\x2f\x6d\
\x61\x72\x6b\x5f\x70\x61\x67\x65\x5f\x61\x63\x63\x65\x73\x73\x65\x64\0\x6b\x70\
\x72\x6f\x62\x65\x5f\x66\x6f\x6c\x69\x6f\x5f\x61\x63\x63\x6f\x75\x6e\x74\x5f\
\x64\x69\x72\x74\x69\x65\x64\0\x2e\x72\x65\x6c\x6b\x70\x72\x6f\x62\x65\x2f\x66\
\x6f\x6c\x69\x6f\x5f\x61\x63\x63\x6f\x75\x6e\x74\x5f\x64\x69\x72\x74\x69\x65\
\x64\0\x66\x65\x6e\x74\x72\x79\x5f\x61\x63\x63\x6f\x75\x6e\x74\x5f\x70\x61\x67\
\x65\x5f\x64\x69\x72\x74\x69\x65\x64\0\x6b\x70\x72\x6f\x62\x65\x5f\x61\x63\x63\
\x6f\x75\x6e\x74\x5f\x70\x61\x67\x65\x5f\x64\x69\x72\x74\x69\x65\x64\0\x2e\x72\
\x65\x6c\x66\x65\x6e\x74\x72\x79\x2f\x61\x63\x63\x6f\x75\x6e\x74\x5f\x70\x61\
\x67\x65\x5f\x64\x69\x72\x74\x69\x65\x64\0\x2e\x72\x65\x6c\x6b\x70\x72\x6f\x62\
\x65\x2f\x61\x63\x63\x6f\x75\x6e\x74\x5f\x70\x61\x67\x65\x5f\x64\x69\x72\x74\
\x69\x65\x64\0\x6d\x62\x64\0\x2e\x73\x74\x72\x74\x61\x62\0\x2e\x73\x79\x6d\x74\
\x61\x62\0\x2e\x72\x65\x6c\x2e\x42\x54\x46\0\x4c\x49\x43\x45\x4e\x53\x45\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xee\x02\0\0\x03\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\x6f\x19\0\0\0\0\0\0\x0f\x03\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xe9\0\0\0\x01\0\0\0\x06\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x04\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\xab\0\0\0\x01\0\0\0\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x40\
\0\0\0\0\0\0\0\x30\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\xa7\0\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x70\x15\0\0\0\0\0\0\
\x10\0\0\0\0\0\0\0\x20\0\0\0\x03\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\xfc\
\x01\0\0\x01\0\0\0\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x70\0\0\0\0\0\0\0\x30\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xf8\x01\0\0\x09\0\
\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x80\x15\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\
\x20\0\0\0\x05\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\xae\x02\0\0\x01\0\0\0\
\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xa0\0\0\0\0\0\0\0\x30\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xaa\x02\0\0\x09\0\0\0\x40\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\x90\x15\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x20\0\0\0\x07\0\0\0\
\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x37\0\0\0\x01\0\0\0\x06\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\xd0\0\0\0\0\0\0\0\x50\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\x33\0\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xa0\
\x15\0\0\0\0\0\0\x20\0\0\0\0\0\0\0\x20\0\0\0\x09\0\0\0\x08\0\0\0\0\0\0\0\x10\0\
\0\0\0\0\0\0\xcc\0\0\0\x01\0\0\0\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x20\x01\0\0\
\0\0\0\0\x30\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\xc8\0\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xc0\x15\0\0\0\0\0\0\x10\
\0\0\0\0\0\0\0\x20\0\0\0\x0b\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x1a\x02\
\0\0\x01\0\0\0\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x50\x01\0\0\0\0\0\0\x30\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x16\x02\0\0\x09\0\0\
\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xd0\x15\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x20\
\0\0\0\x0d\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\xce\x02\0\0\x01\0\0\0\x06\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x80\x01\0\0\0\0\0\0\x30\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xca\x02\0\0\x09\0\0\0\x40\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\xe0\x15\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x20\0\0\0\x0f\0\0\0\
\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x55\x02\0\0\x01\0\0\0\x06\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\xb0\x01\0\0\0\0\0\0\x30\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\x51\x02\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\xf0\x15\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x20\0\0\0\x11\0\0\0\x08\0\0\0\0\0\0\0\
\x10\0\0\0\0\0\0\0\x54\0\0\0\x01\0\0\0\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xe0\
\x01\0\0\0\0\0\0\x50\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\x50\0\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x16\0\0\0\0\0\0\
\x20\0\0\0\0\0\0\0\x20\0\0\0\x13\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x2e\
\x01\0\0\x01\0\0\0\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x30\x02\0\0\0\0\0\0\x30\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x2a\x01\0\0\x09\
\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x20\x16\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\
\x20\0\0\0\x15\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x9a\x01\0\0\x01\0\0\0\
\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x60\x02\0\0\0\0\0\0\x30\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x96\x01\0\0\x09\0\0\0\x40\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\x30\x16\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x20\0\0\0\x17\0\0\
\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\xfc\0\0\0\x08\0\0\0\x03\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\x90\x02\0\0\0\0\0\0\x18\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\x6d\x01\0\0\x01\0\0\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\x90\x02\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\x02\x03\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x94\x02\0\0\
\0\0\0\0\xef\x0c\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\xfe\x02\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x40\x16\0\0\0\0\0\0\
\x40\0\0\0\0\0\0\0\x20\0\0\0\x1b\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\xf3\
\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x84\x0f\0\0\0\0\0\0\x60\x03\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xef\0\0\0\x09\0\0\
\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x80\x16\0\0\0\0\0\0\xe0\x02\0\0\0\0\0\0\
\x20\0\0\0\x1d\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x5f\x01\0\0\x03\x4c\
\xff\x6f\0\0\0\x80\0\0\0\0\0\0\0\0\0\0\0\0\x60\x19\0\0\0\0\0\0\x0f\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xf6\x02\0\0\x02\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xe8\x12\0\0\0\0\0\0\x88\x02\0\0\0\0\0\0\x01\0\0\0\
\x0c\0\0\0\x08\0\0\0\0\0\0\0\x18\0\0\0\0\0\0\0";
}

#ifdef __cplusplus
struct cachestat_bpf *cachestat_bpf::open(const struct bpf_object_open_opts *opts) { return cachestat_bpf__open_opts(opts); }
struct cachestat_bpf *cachestat_bpf::open_and_load() { return cachestat_bpf__open_and_load(); }
int cachestat_bpf::load(struct cachestat_bpf *skel) { return cachestat_bpf__load(skel); }
int cachestat_bpf::attach(struct cachestat_bpf *skel) { return cachestat_bpf__attach(skel); }
void cachestat_bpf::detach(struct cachestat_bpf *skel) { cachestat_bpf__detach(skel); }
void cachestat_bpf::destroy(struct cachestat_bpf *skel) { cachestat_bpf__destroy(skel); }
const void *cachestat_bpf::elf_bytes(size_t *sz) { return cachestat_bpf__elf_bytes(sz); }
#endif /* __cplusplus */

__attribute__((unused)) static void
cachestat_bpf__assert(struct cachestat_bpf *s __attribute__((unused)))
{
#ifdef __cplusplus
#define _Static_assert static_assert
#endif
	_Static_assert(sizeof(s->bss->total) == 8, "unexpected size of 'total'");
	_Static_assert(sizeof(s->bss->misses) == 8, "unexpected size of 'misses'");
	_Static_assert(sizeof(s->bss->mbd) == 8, "unexpected size of 'mbd'");
#ifdef __cplusplus
#undef _Static_assert
#endif
}

#endif /* __CACHESTAT_BPF_SKEL_H__ */
