/* Browser.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Browser.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*-
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: Michael Terry
 */

#include <adwaita.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include "deja.h"
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_BROWSER (browser_get_type ())
#define BROWSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BROWSER, Browser))
#define BROWSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BROWSER, BrowserClass))
#define IS_BROWSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BROWSER))
#define IS_BROWSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BROWSER))
#define BROWSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BROWSER, BrowserClass))

typedef struct _Browser Browser;
typedef struct _BrowserClass BrowserClass;
typedef struct _BrowserPrivate BrowserPrivate;

#define TYPE_FILE_STORE (file_store_get_type ())
#define FILE_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FILE_STORE, FileStore))
#define FILE_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FILE_STORE, FileStoreClass))
#define IS_FILE_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FILE_STORE))
#define IS_FILE_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FILE_STORE))
#define FILE_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FILE_STORE, FileStoreClass))

typedef struct _FileStore FileStore;
typedef struct _FileStoreClass FileStoreClass;
enum  {
	BROWSER_0_PROPERTY,
	BROWSER_HAS_CONTENT_PROPERTY,
	BROWSER_HAS_SELECTION_PROPERTY,
	BROWSER_CAN_GO_UP_PROPERTY,
	BROWSER_TAG_PROPERTY,
	BROWSER_FOLDER_NAME_PROPERTY,
	BROWSER_SEARCH_FILTER_PROPERTY,
	BROWSER_NUM_PROPERTIES
};
static GParamSpec* browser_properties[BROWSER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _gtk_bitset_unref0(var) ((var == NULL) ? NULL : (var = (gtk_bitset_unref (var), NULL)))
enum  {
	BROWSER_FOLDER_CHANGED_SIGNAL,
	BROWSER_NUM_SIGNALS
};
static guint browser_signals[BROWSER_NUM_SIGNALS] = {0};

struct _Browser {
	AdwBin parent_instance;
	BrowserPrivate * priv;
};

struct _BrowserClass {
	AdwBinClass parent_class;
};

struct _BrowserPrivate {
	gboolean _has_content;
	gboolean _has_selection;
	gboolean _can_go_up;
	gchar* _tag;
	gchar* _folder_name;
	gchar* _search_filter;
	GtkStack* view_stack;
	GtkStack* overlay_stack;
	GtkGridView* icon_view;
	GtkColumnView* list_view;
	FileStore* store;
	GtkMultiSelection* selection;
};

static gint Browser_private_offset;
static gpointer browser_parent_class = NULL;

VALA_EXTERN GType browser_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Browser, g_object_unref)
VALA_EXTERN GType file_store_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FileStore, g_object_unref)
static void browser_selection_changed (Browser* self);
static void browser_set_has_selection (Browser* self,
                                gboolean value);
static void browser_update_folder_name (Browser* self);
VALA_EXTERN DejaDupFileTreeNode* file_store_get_current (FileStore* self);
static void browser_set_folder_name (Browser* self,
                              const gchar* value);
static void browser_items_changed (Browser* self);
static void browser_update_content_view (Browser* self);
VALA_EXTERN void browser_select_all (Browser* self);
static void browser_update_can_go_up (Browser* self);
VALA_EXTERN gboolean file_store_get_can_go_up (FileStore* self);
VALA_EXTERN const gchar* browser_get_search_filter (Browser* self);
VALA_EXTERN void browser_set_can_go_up (Browser* self,
                            gboolean value);
VALA_EXTERN void browser_go_up (Browser* self);
VALA_EXTERN gboolean browser_get_can_go_up (Browser* self);
VALA_EXTERN gboolean file_store_go_up (FileStore* self);
static void browser_go_down (Browser* self,
                      guint position);
VALA_EXTERN gboolean file_store_go_down (FileStore* self,
                             guint position);
static void _browser_go_down_gtk_column_view_activate (GtkColumnView* _sender,
                                                guint position,
                                                gpointer self);
static void browser_switch_overlay_to_empty_search (Browser* self);
static void browser_switch_overlay_off (Browser* self);
static void browser_switch_overlay_to_empty_folder (Browser* self);
static void browser_update_search_filter (Browser* self);
VALA_EXTERN void file_store_set_search_filter (FileStore* self,
                                   const gchar* value);
static void browser_switch_overlay_to (Browser* self,
                                const gchar* name);
VALA_EXTERN GList* browser_get_selected_files (Browser* self);
VALA_EXTERN GFile* file_store_get_file (FileStore* self,
                            guint position);
VALA_EXTERN DejaDupFileTree* browser_get_tree (Browser* self);
VALA_EXTERN DejaDupFileTree* file_store_get_tree (FileStore* self);
static void browser_update_has_content (Browser* self);
VALA_EXTERN const gchar* browser_get_tag (Browser* self);
static void browser_set_has_content (Browser* self,
                              gboolean value);
VALA_EXTERN void browser_clear_tree (Browser* self);
VALA_EXTERN void file_store_clear (FileStore* self);
static void browser_set_tag (Browser* self,
                      const gchar* value);
VALA_EXTERN void browser_set_tree (Browser* self,
                       const gchar* tag,
                       DejaDupFileTree* tree);
VALA_EXTERN void file_store_set_file_tree (FileStore* self,
                               DejaDupFileTree* tree);
VALA_EXTERN Browser* browser_new (void);
VALA_EXTERN Browser* browser_construct (GType object_type);
VALA_EXTERN gboolean browser_get_has_content (Browser* self);
VALA_EXTERN gboolean browser_get_has_selection (Browser* self);
VALA_EXTERN const gchar* browser_get_folder_name (Browser* self);
VALA_EXTERN void browser_set_search_filter (Browser* self,
                                const gchar* value);
static GObject * browser_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties);
VALA_EXTERN FileStore* file_store_new (void);
VALA_EXTERN FileStore* file_store_construct (GType object_type);
static void _browser_selection_changed_gtk_selection_model_selection_changed (GtkSelectionModel* _sender,
                                                                       guint position,
                                                                       guint n_items,
                                                                       gpointer self);
static void _browser_items_changed_g_list_model_items_changed (GListModel* _sender,
                                                        guint position,
                                                        guint removed,
                                                        guint added,
                                                        gpointer self);
static void _browser_update_search_filter_g_object_notify (GObject* _sender,
                                                    GParamSpec* pspec,
                                                    gpointer self);
static void _browser_selection_changed_browser_folder_changed (Browser* _sender,
                                                        gpointer self);
static void _browser_update_folder_name_browser_folder_changed (Browser* _sender,
                                                         gpointer self);
static void _browser_update_can_go_up_g_object_notify (GObject* _sender,
                                                GParamSpec* pspec,
                                                gpointer self);
static void browser_finalize (GObject * obj);
static GType browser_get_type_once (void);
static void _vala_browser_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec);
static void _vala_browser_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec);

static inline gpointer
browser_get_instance_private (Browser* self)
{
	return G_STRUCT_MEMBER_P (self, Browser_private_offset);
}

static void
browser_selection_changed (Browser* self)
{
	GtkBitset* bitset = NULL;
	GtkMultiSelection* _tmp0_;
	GtkBitset* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->selection;
	_tmp1_ = gtk_selection_model_get_selection ((GtkSelectionModel*) _tmp0_);
	bitset = _tmp1_;
	browser_set_has_selection (self, !gtk_bitset_is_empty (bitset));
	_gtk_bitset_unref0 (bitset);
}

static void
browser_update_folder_name (Browser* self)
{
	FileStore* _tmp0_;
	DejaDupFileTreeNode* _tmp1_;
	DejaDupFileTreeNode* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->store;
	_tmp1_ = file_store_get_current (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = deja_dup_file_tree_node_get_filename (_tmp2_);
	_tmp4_ = _tmp3_;
	browser_set_folder_name (self, _tmp4_);
}

static void
browser_items_changed (Browser* self)
{
	g_return_if_fail (self != NULL);
	browser_update_content_view (self);
	browser_selection_changed (self);
}

void
browser_select_all (Browser* self)
{
	GtkMultiSelection* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->selection;
	gtk_selection_model_select_all ((GtkSelectionModel*) _tmp0_);
}

static void
browser_update_can_go_up (Browser* self)
{
	gboolean _tmp0_ = FALSE;
	FileStore* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->store;
	_tmp2_ = file_store_get_can_go_up (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		const gchar* _tmp4_;
		_tmp4_ = self->priv->_search_filter;
		_tmp0_ = g_strcmp0 (_tmp4_, "") == 0;
	} else {
		_tmp0_ = FALSE;
	}
	browser_set_can_go_up (self, _tmp0_);
}

void
browser_go_up (Browser* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_can_go_up;
	if (_tmp1_) {
		FileStore* _tmp2_;
		_tmp2_ = self->priv->store;
		_tmp0_ = file_store_go_up (_tmp2_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		g_signal_emit (self, browser_signals[BROWSER_FOLDER_CHANGED_SIGNAL], 0);
	}
}

static void
browser_go_down (Browser* self,
                 guint position)
{
	FileStore* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->store;
	if (file_store_go_down (_tmp0_, position)) {
		g_signal_emit (self, browser_signals[BROWSER_FOLDER_CHANGED_SIGNAL], 0);
	}
}

static void
_browser_go_down_gtk_column_view_activate (GtkColumnView* _sender,
                                           guint position,
                                           gpointer self)
{
	browser_go_down ((Browser*) self, position);
}

static void
browser_update_content_view (Browser* self)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_search_filter;
	if (g_strcmp0 (_tmp0_, "") != 0) {
		GtkStack* _tmp1_;
		GtkGridView* _tmp2_;
		GtkColumnView* _tmp3_;
		GtkMultiSelection* _tmp4_;
		GtkMultiSelection* _tmp5_;
		_tmp1_ = self->priv->view_stack;
		gtk_stack_set_visible_child_name (_tmp1_, "list");
		_tmp2_ = self->priv->icon_view;
		gtk_grid_view_set_model (_tmp2_, NULL);
		_tmp3_ = self->priv->list_view;
		_tmp4_ = self->priv->selection;
		gtk_column_view_set_model (_tmp3_, (GtkSelectionModel*) _tmp4_);
		_tmp5_ = self->priv->selection;
		if (g_list_model_get_n_items ((GListModel*) _tmp5_) == ((guint) 0)) {
			browser_switch_overlay_to_empty_search (self);
		} else {
			browser_switch_overlay_off (self);
		}
	} else {
		GtkStack* _tmp6_;
		GtkColumnView* _tmp7_;
		GtkGridView* _tmp8_;
		GtkMultiSelection* _tmp9_;
		GtkMultiSelection* _tmp10_;
		_tmp6_ = self->priv->view_stack;
		gtk_stack_set_visible_child_name (_tmp6_, "icons");
		_tmp7_ = self->priv->list_view;
		gtk_column_view_set_model (_tmp7_, NULL);
		_tmp8_ = self->priv->icon_view;
		_tmp9_ = self->priv->selection;
		gtk_grid_view_set_model (_tmp8_, (GtkSelectionModel*) _tmp9_);
		_tmp10_ = self->priv->selection;
		if (g_list_model_get_n_items ((GListModel*) _tmp10_) == ((guint) 0)) {
			browser_switch_overlay_to_empty_folder (self);
		} else {
			browser_switch_overlay_off (self);
		}
	}
}

static void
browser_update_search_filter (Browser* self)
{
	FileStore* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	browser_update_content_view (self);
	_tmp0_ = self->priv->store;
	_tmp1_ = self->priv->_search_filter;
	file_store_set_search_filter (_tmp0_, _tmp1_);
}

static void
browser_switch_overlay_to_empty_folder (Browser* self)
{
	g_return_if_fail (self != NULL);
	browser_switch_overlay_to (self, "empty-folder");
}

static void
browser_switch_overlay_to_empty_search (Browser* self)
{
	GtkStack* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->view_stack;
	gtk_stack_set_visible_child_name (_tmp0_, "icons");
	browser_switch_overlay_to (self, "empty-search");
}

static void
browser_switch_overlay_to (Browser* self,
                           const gchar* name)
{
	GtkStack* _tmp0_;
	GtkStack* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->overlay_stack;
	gtk_stack_set_visible_child_name (_tmp0_, name);
	_tmp1_ = self->priv->overlay_stack;
	gtk_widget_set_visible ((GtkWidget*) _tmp1_, TRUE);
}

static void
browser_switch_overlay_off (Browser* self)
{
	GtkStack* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->overlay_stack;
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, FALSE);
}

GList*
browser_get_selected_files (Browser* self)
{
	GtkBitset* bitset = NULL;
	GtkMultiSelection* _tmp0_;
	GtkBitset* _tmp1_;
	GtkBitsetIter iter = {0};
	guint position = 0U;
	GtkBitset* _tmp2_;
	guint _tmp3_ = 0U;
	gboolean _tmp4_;
	GList* files = NULL;
	FileStore* _tmp5_;
	GFile* _tmp6_;
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->selection;
	_tmp1_ = gtk_selection_model_get_selection ((GtkSelectionModel*) _tmp0_);
	bitset = _tmp1_;
	memset (&iter, 0, sizeof (GtkBitsetIter));
	_tmp2_ = bitset;
	_tmp4_ = gtk_bitset_iter_init_first (&iter, _tmp2_, &_tmp3_);
	position = _tmp3_;
	if (!_tmp4_) {
		result = NULL;
		_gtk_bitset_unref0 (bitset);
		return result;
	}
	files = NULL;
	_tmp5_ = self->priv->store;
	_tmp6_ = file_store_get_file (_tmp5_, position);
	files = g_list_append (files, _tmp6_);
	while (TRUE) {
		guint _tmp7_ = 0U;
		gboolean _tmp8_;
		FileStore* _tmp9_;
		GFile* _tmp10_;
		_tmp8_ = gtk_bitset_iter_next (&iter, &_tmp7_);
		position = _tmp7_;
		if (!_tmp8_) {
			break;
		}
		_tmp9_ = self->priv->store;
		_tmp10_ = file_store_get_file (_tmp9_, position);
		files = g_list_append (files, _tmp10_);
	}
	result = files;
	_gtk_bitset_unref0 (bitset);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

DejaDupFileTree*
browser_get_tree (Browser* self)
{
	FileStore* _tmp0_;
	DejaDupFileTree* _tmp1_;
	DejaDupFileTree* _tmp2_;
	DejaDupFileTree* _tmp3_;
	DejaDupFileTree* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->store;
	_tmp1_ = file_store_get_tree (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static void
browser_update_has_content (Browser* self)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_tag;
	browser_set_has_content (self, _tmp0_ != NULL);
}

void
browser_clear_tree (Browser* self)
{
	FileStore* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->store;
	file_store_clear (_tmp0_);
	browser_set_folder_name (self, "");
	browser_set_tag (self, NULL);
	browser_update_has_content (self);
}

void
browser_set_tree (Browser* self,
                  const gchar* tag,
                  DejaDupFileTree* tree)
{
	FileStore* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tag != NULL);
	g_return_if_fail (tree != NULL);
	browser_set_tag (self, tag);
	_tmp0_ = self->priv->store;
	file_store_set_file_tree (_tmp0_, tree);
	browser_items_changed (self);
	browser_update_folder_name (self);
	browser_update_has_content (self);
}

Browser*
browser_construct (GType object_type)
{
	Browser * self = NULL;
	self = (Browser*) g_object_new (object_type, NULL);
	return self;
}

Browser*
browser_new (void)
{
	return browser_construct (TYPE_BROWSER);
}

gboolean
browser_get_has_content (Browser* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_content;
	return result;
}

static void
browser_set_has_content (Browser* self,
                         gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = browser_get_has_content (self);
	if (old_value != value) {
		self->priv->_has_content = value;
		g_object_notify_by_pspec ((GObject *) self, browser_properties[BROWSER_HAS_CONTENT_PROPERTY]);
	}
}

gboolean
browser_get_has_selection (Browser* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_selection;
	return result;
}

static void
browser_set_has_selection (Browser* self,
                           gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = browser_get_has_selection (self);
	if (old_value != value) {
		self->priv->_has_selection = value;
		g_object_notify_by_pspec ((GObject *) self, browser_properties[BROWSER_HAS_SELECTION_PROPERTY]);
	}
}

gboolean
browser_get_can_go_up (Browser* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_can_go_up;
	return result;
}

void
browser_set_can_go_up (Browser* self,
                       gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = browser_get_can_go_up (self);
	if (old_value != value) {
		self->priv->_can_go_up = value;
		g_object_notify_by_pspec ((GObject *) self, browser_properties[BROWSER_CAN_GO_UP_PROPERTY]);
	}
}

const gchar*
browser_get_tag (Browser* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_tag;
	result = _tmp0_;
	return result;
}

static void
browser_set_tag (Browser* self,
                 const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = browser_get_tag (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_tag);
		self->priv->_tag = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, browser_properties[BROWSER_TAG_PROPERTY]);
	}
}

const gchar*
browser_get_folder_name (Browser* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_folder_name;
	result = _tmp0_;
	return result;
}

static void
browser_set_folder_name (Browser* self,
                         const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = browser_get_folder_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_folder_name);
		self->priv->_folder_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, browser_properties[BROWSER_FOLDER_NAME_PROPERTY]);
	}
}

const gchar*
browser_get_search_filter (Browser* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_search_filter;
	result = _tmp0_;
	return result;
}

void
browser_set_search_filter (Browser* self,
                           const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = browser_get_search_filter (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_search_filter);
		self->priv->_search_filter = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, browser_properties[BROWSER_SEARCH_FILTER_PROPERTY]);
	}
}

static void
_browser_selection_changed_gtk_selection_model_selection_changed (GtkSelectionModel* _sender,
                                                                  guint position,
                                                                  guint n_items,
                                                                  gpointer self)
{
	browser_selection_changed ((Browser*) self);
}

static void
_browser_items_changed_g_list_model_items_changed (GListModel* _sender,
                                                   guint position,
                                                   guint removed,
                                                   guint added,
                                                   gpointer self)
{
	browser_items_changed ((Browser*) self);
}

static void
_browser_update_search_filter_g_object_notify (GObject* _sender,
                                               GParamSpec* pspec,
                                               gpointer self)
{
	browser_update_search_filter ((Browser*) self);
}

static void
_browser_selection_changed_browser_folder_changed (Browser* _sender,
                                                   gpointer self)
{
	browser_selection_changed ((Browser*) self);
}

static void
_browser_update_folder_name_browser_folder_changed (Browser* _sender,
                                                    gpointer self)
{
	browser_update_folder_name ((Browser*) self);
}

static void
_browser_update_can_go_up_g_object_notify (GObject* _sender,
                                           GParamSpec* pspec,
                                           gpointer self)
{
	browser_update_can_go_up ((Browser*) self);
}

static GObject *
browser_constructor (GType type,
                     guint n_construct_properties,
                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	Browser * self;
	FileStore* _tmp0_;
	FileStore* _tmp1_;
	GListModel* _tmp2_;
	GtkMultiSelection* _tmp3_;
	GtkMultiSelection* _tmp4_;
	GtkMultiSelection* _tmp5_;
	GtkGridView* _tmp6_;
	GtkMultiSelection* _tmp7_;
	GtkGridView* _tmp8_;
	GtkBuilderListItemFactory* _tmp9_;
	GtkBuilderListItemFactory* _tmp10_;
	FileStore* _tmp11_;
	parent_class = G_OBJECT_CLASS (browser_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BROWSER, Browser);
	_tmp0_ = file_store_new ();
	_g_object_unref0 (self->priv->store);
	self->priv->store = _tmp0_;
	_tmp1_ = self->priv->store;
	_tmp2_ = _g_object_ref0 ((GListModel*) _tmp1_);
	_tmp3_ = gtk_multi_selection_new (_tmp2_);
	_g_object_unref0 (self->priv->selection);
	self->priv->selection = _tmp3_;
	_tmp4_ = self->priv->selection;
	g_signal_connect_object ((GtkSelectionModel*) _tmp4_, "selection-changed", (GCallback) _browser_selection_changed_gtk_selection_model_selection_changed, self, 0);
	_tmp5_ = self->priv->selection;
	g_signal_connect_object ((GListModel*) _tmp5_, "items-changed", (GCallback) _browser_items_changed_g_list_model_items_changed, self, 0);
	_tmp6_ = self->priv->icon_view;
	_tmp7_ = self->priv->selection;
	gtk_grid_view_set_model (_tmp6_, (GtkSelectionModel*) _tmp7_);
	_tmp8_ = self->priv->icon_view;
	_tmp9_ = (GtkBuilderListItemFactory*) gtk_builder_list_item_factory_new_from_resource (NULL, "/org/gnome/DejaDup/BrowserGridItem.ui");
	_tmp10_ = _tmp9_;
	gtk_grid_view_set_factory (_tmp8_, (GtkListItemFactory*) _tmp10_);
	_g_object_unref0 (_tmp10_);
	g_signal_connect_object ((GObject*) self, "notify::search-filter", (GCallback) _browser_update_search_filter_g_object_notify, self, 0);
	g_signal_connect_object (self, "folder-changed", (GCallback) _browser_selection_changed_browser_folder_changed, self, 0);
	g_signal_connect_object (self, "folder-changed", (GCallback) _browser_update_folder_name_browser_folder_changed, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::search-filter", (GCallback) _browser_update_can_go_up_g_object_notify, self, 0);
	_tmp11_ = self->priv->store;
	g_signal_connect_object ((GObject*) _tmp11_, "notify::can-go-up", (GCallback) _browser_update_can_go_up_g_object_notify, self, 0);
	return obj;
}

static void
browser_class_init (BrowserClass * klass,
                    gpointer klass_data)
{
	browser_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Browser_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_browser_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_browser_set_property;
	G_OBJECT_CLASS (klass)->constructor = browser_constructor;
	G_OBJECT_CLASS (klass)->finalize = browser_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BROWSER_HAS_CONTENT_PROPERTY, browser_properties[BROWSER_HAS_CONTENT_PROPERTY] = g_param_spec_boolean ("has-content", "has-content", "has-content", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BROWSER_HAS_SELECTION_PROPERTY, browser_properties[BROWSER_HAS_SELECTION_PROPERTY] = g_param_spec_boolean ("has-selection", "has-selection", "has-selection", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BROWSER_CAN_GO_UP_PROPERTY, browser_properties[BROWSER_CAN_GO_UP_PROPERTY] = g_param_spec_boolean ("can-go-up", "can-go-up", "can-go-up", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BROWSER_TAG_PROPERTY, browser_properties[BROWSER_TAG_PROPERTY] = g_param_spec_string ("tag", "tag", "tag", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BROWSER_FOLDER_NAME_PROPERTY, browser_properties[BROWSER_FOLDER_NAME_PROPERTY] = g_param_spec_string ("folder-name", "folder-name", "folder-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BROWSER_SEARCH_FILTER_PROPERTY, browser_properties[BROWSER_SEARCH_FILTER_PROPERTY] = g_param_spec_string ("search-filter", "search-filter", "search-filter", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/DejaDup/Browser.ui");
	browser_signals[BROWSER_FOLDER_CHANGED_SIGNAL] = g_signal_new ("folder-changed", TYPE_BROWSER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "view_stack", FALSE, Browser_private_offset + G_STRUCT_OFFSET (BrowserPrivate, view_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "overlay_stack", FALSE, Browser_private_offset + G_STRUCT_OFFSET (BrowserPrivate, overlay_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "icon_view", FALSE, Browser_private_offset + G_STRUCT_OFFSET (BrowserPrivate, icon_view));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "list_view", FALSE, Browser_private_offset + G_STRUCT_OFFSET (BrowserPrivate, list_view));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "go_down", G_CALLBACK(_browser_go_down_gtk_column_view_activate));
}

static void
browser_instance_init (Browser * self,
                       gpointer klass)
{
	gchar* _tmp0_;
	self->priv = browser_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->_search_filter = _tmp0_;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
browser_finalize (GObject * obj)
{
	Browser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BROWSER, Browser);
	_g_free0 (self->priv->_tag);
	_g_free0 (self->priv->_folder_name);
	_g_free0 (self->priv->_search_filter);
	_g_object_unref0 (self->priv->store);
	_g_object_unref0 (self->priv->selection);
	G_OBJECT_CLASS (browser_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
browser_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BrowserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) browser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Browser), 0, (GInstanceInitFunc) browser_instance_init, NULL };
	GType browser_type_id;
	browser_type_id = g_type_register_static (adw_bin_get_type (), "Browser", &g_define_type_info, 0);
	Browser_private_offset = g_type_add_instance_private (browser_type_id, sizeof (BrowserPrivate));
	return browser_type_id;
}

GType
browser_get_type (void)
{
	static gsize browser_type_id__once = 0;
	if (g_once_init_enter (&browser_type_id__once)) {
		GType browser_type_id;
		browser_type_id = browser_get_type_once ();
		g_once_init_leave (&browser_type_id__once, browser_type_id);
	}
	return browser_type_id__once;
}

static void
_vala_browser_get_property (GObject * object,
                            guint property_id,
                            GValue * value,
                            GParamSpec * pspec)
{
	Browser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BROWSER, Browser);
	switch (property_id) {
		case BROWSER_HAS_CONTENT_PROPERTY:
		g_value_set_boolean (value, browser_get_has_content (self));
		break;
		case BROWSER_HAS_SELECTION_PROPERTY:
		g_value_set_boolean (value, browser_get_has_selection (self));
		break;
		case BROWSER_CAN_GO_UP_PROPERTY:
		g_value_set_boolean (value, browser_get_can_go_up (self));
		break;
		case BROWSER_TAG_PROPERTY:
		g_value_set_string (value, browser_get_tag (self));
		break;
		case BROWSER_FOLDER_NAME_PROPERTY:
		g_value_set_string (value, browser_get_folder_name (self));
		break;
		case BROWSER_SEARCH_FILTER_PROPERTY:
		g_value_set_string (value, browser_get_search_filter (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_browser_set_property (GObject * object,
                            guint property_id,
                            const GValue * value,
                            GParamSpec * pspec)
{
	Browser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BROWSER, Browser);
	switch (property_id) {
		case BROWSER_HAS_CONTENT_PROPERTY:
		browser_set_has_content (self, g_value_get_boolean (value));
		break;
		case BROWSER_HAS_SELECTION_PROPERTY:
		browser_set_has_selection (self, g_value_get_boolean (value));
		break;
		case BROWSER_CAN_GO_UP_PROPERTY:
		browser_set_can_go_up (self, g_value_get_boolean (value));
		break;
		case BROWSER_TAG_PROPERTY:
		browser_set_tag (self, g_value_get_string (value));
		break;
		case BROWSER_FOLDER_NAME_PROPERTY:
		browser_set_folder_name (self, g_value_get_string (value));
		break;
		case BROWSER_SEARCH_FILTER_PROPERTY:
		browser_set_search_filter (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

