// Generated from libavcodec/vulkan/ffv1_enc_rct.comp
const char *ff_source_ffv1_enc_rct_comp =
"/*\n"
" * FFv1 codec\n"
" *\n"
" * Copyright (c) 2024 Lynne <dev@lynne.ee>\n"
" *\n"
" * This file is part of FFmpeg.\n"
" *\n"
" * FFmpeg is free software; you can redistribute it and/or\n"
" * modify it under the terms of the GNU Lesser General Public\n"
" * License as published by the Free Software Foundation; either\n"
" * version 2.1 of the License, or (at your option) any later version.\n"
" *\n"
" * FFmpeg is distributed in the hope that it will be useful,\n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU\n"
" * Lesser General Public License for more details.\n"
" *\n"
" * You should have received a copy of the GNU Lesser General Public\n"
" * License along with FFmpeg; if not, write to the Free Software\n"
" * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA\n"
" */\n"
"\n"
"ivec4 load_components(ivec2 pos)\n"
"{\n"
"    ivec4 pix = ivec4(imageLoad(src[0], pos));\n"
"    if (planar_rgb != 0) {\n"
"        for (int i = 1; i < (3 + transparency); i++)\n"
"            pix[i] = int(imageLoad(src[i], pos)[0]);\n"
"    }\n"
"\n"
"    return ivec4(pix[fmt_lut[0]], pix[fmt_lut[1]],\n"
"                 pix[fmt_lut[2]], pix[fmt_lut[3]]);\n"
"}\n"
"\n"
"void bypass_sample(ivec2 pos)\n"
"{\n"
"    imageStore(dst[0], pos, load_components(pos));\n"
"}\n"
"\n"
"void bypass_block(in SliceContext sc)\n"
"{\n"
"    ivec2 start = ivec2(gl_LocalInvocationID) + sc.slice_pos;\n"
"    ivec2 end = sc.slice_pos + sc.slice_dim;\n"
"    for (uint y = start.y; y < end.y; y += gl_WorkGroupSize.y)\n"
"        for (uint x = start.x; x < end.x; x += gl_WorkGroupSize.x)\n"
"            bypass_sample(ivec2(x, y));\n"
"}\n"
"\n"
"void transform_sample(ivec2 pos, ivec2 rct_coef)\n"
"{\n"
"    ivec4 pix = load_components(pos);\n"
"    pix.b -= pix.g;\n"
"    pix.r -= pix.g;\n"
"    pix.g += (pix.r*rct_coef.x + pix.b*rct_coef.y) >> 2;\n"
"    pix.b += offset;\n"
"    pix.r += offset;\n"
"    imageStore(dst[0], pos, pix);\n"
"}\n"
"\n"
"void transform_block(in SliceContext sc)\n"
"{\n"
"    const ivec2 rct_coef = sc.slice_rct_coef;\n"
"    const ivec2 start = ivec2(gl_LocalInvocationID) + sc.slice_pos;\n"
"    const ivec2 end = sc.slice_pos + sc.slice_dim;\n"
"\n"
"    for (uint y = start.y; y < end.y; y += gl_WorkGroupSize.y)\n"
"        for (uint x = start.x; x < end.x; x += gl_WorkGroupSize.x)\n"
"            transform_sample(ivec2(x, y), rct_coef);\n"
"}\n"
"\n"
"void main()\n"
"{\n"
"    const uint slice_idx = gl_WorkGroupID.y*gl_NumWorkGroups.x + gl_WorkGroupID.x;\n"
"\n"
"    if (slice_ctx[slice_idx].slice_coding_mode == 1)\n"
"        bypass_block(slice_ctx[slice_idx]);\n"
"    else\n"
"        transform_block(slice_ctx[slice_idx]);\n"
"}\n"
;
