/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* Generated with cbindgen:0.29.2 */

/* DO NOT MODIFY THIS MANUALLY! This file was generated using cbindgen.
 *
 * This file is generated based on the configuration in
 * `gfx/wgpu_bindings/moz.build`, which directs the build system module
 * `build/RunCbindgen.py` to run the following command at the top of
 * the object file directory:
 *
 *     $CBINDGEN $TOPSRCDIR --lockfile $TOPSRCDIR/Cargo.lock --crate wgpu_bindings --metadata config/cbindgen-metadata.json --cpp-compat > gfx/wgpu_bindings/wgpu_ffi_generated.h
 *
 * where:
 * - $TOPSRCDIR is the top of the Firefox source tree, and
 * - $CBINDGEN is the path to the cbindgen executable provided by mozbuild (the exact version often matters)
 */

#include "nsString.h"

struct WGPUByteBuf;
using WGPUNonZeroU64 = uint64_t;
using WGPUOption_BufferSize = uint64_t;
using WGPUOption_NonZeroU32 = uint32_t;
using WGPUOption_NonZeroU8 = uint8_t;
using WGPUOption_AdapterId = uint64_t;
using WGPUOption_BufferId = uint64_t;
using WGPUOption_PipelineLayoutId = uint64_t;
using WGPUOption_BindGroupId = uint64_t;
using WGPUOption_BindGroupLayoutId = uint64_t;
using WGPUOption_SamplerId = uint64_t;
using WGPUOption_SurfaceId = uint64_t;
using WGPUOption_TextureViewId = uint64_t;
using WGPUOption_ExternalTextureSourceId = uint64_t;
using WGPUOption_ExternalTextureId = uint64_t;
using WGPUOption_QuerySetId = uint64_t;
using WGPUOption_DeviceId = uint64_t;

using WGPUAdapterId = uint64_t;
using WGPUBindGroupId = uint64_t;
using WGPUBindGroupLayoutId = uint64_t;
using WGPUBufferId = uint64_t;
using WGPUCommandBufferId = uint64_t;
using WGPUCommandEncoderId = uint64_t;
using WGPURenderPassEncoderId = uint64_t;
using WGPUComputePassEncoderId = uint64_t;
using WGPURenderBundleEncoderId = uint64_t;
using WGPUComputePipelineId = uint64_t;
using WGPUDeviceId = uint64_t;
using WGPUFeaturesWebGPU = uint64_t;
using WGPUPipelineLayoutId = uint64_t;
using WGPUQuerySetId = uint64_t;
using WGPUQueueId = uint64_t;
using WGPURenderBundleId = uint64_t;
using WGPURenderPipelineId = uint64_t;
using WGPUSamplerId = uint64_t;
using WGPUShaderModuleId = uint64_t;
using WGPUStagingBufferId = uint64_t;
using WGPUSurfaceId = uint64_t;
using WGPUTextureId = uint64_t;
using WGPUTextureViewId = uint64_t;
using WGPUExternalTextureId = uint64_t;
using WGPUExternalTextureSourceId = uint64_t;


#include <stdarg.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdlib.h>



#define WGPUMAX_CONCURRENT_SHADER_STAGES 3

#define WGPUMAX_ANISOTROPY 16

#define WGPUMAX_BIND_GROUPS 8

#define WGPUMAX_VERTEX_BUFFERS 16

#define WGPUMAX_COLOR_ATTACHMENTS 8

#define WGPUMAX_MIP_LEVELS 16

/**
 * Maximum binding size for the shaders that only support `i32` indexing.
 * Interestingly, the index itself can't reach that high, because the minimum
 * element size is 4 bytes, but the compiler toolchain still computes the
 * offset at some intermediate point, internally, as i32.
 */
#define WGPUMAX_I32_BINDING_SIZE ((1 << 31) - 1)

#define WGPUDEVICE_KABY_LAKE_MASK 22784

#define WGPUDEVICE_SKY_LAKE_MASK 6400

/**
 * Buffer-texture copies must have [`bytes_per_row`] aligned to this number.
 *
 * This doesn't apply to [`Queue::write_texture`][Qwt], only to [`copy_buffer_to_texture()`]
 * and [`copy_texture_to_buffer()`].
 *
 * [`bytes_per_row`]: TexelCopyBufferLayout::bytes_per_row
 * [`copy_buffer_to_texture()`]: ../wgpu/struct.Queue.html#method.copy_buffer_to_texture
 * [`copy_texture_to_buffer()`]: ../wgpu/struct.Queue.html#method.copy_texture_to_buffer
 * [Qwt]: ../wgpu/struct.Queue.html#method.write_texture
 */
#define WGPUCOPY_BYTES_PER_ROW_ALIGNMENT 256

/**
 * Ranges of [writes to push constant storage] must be at least this aligned.
 *
 * [writes to push constant storage]: ../wgpu/struct.RenderPass.html#method.set_push_constants
 */
#define WGPUPUSH_CONSTANT_ALIGNMENT 4

/**
 * Maximum queries in a [`QuerySetDescriptor`].
 */
#define WGPUQUERY_SET_MAX_QUERIES 4096

/**
 * Size in bytes of a single piece of [query] data.
 *
 * [query]: ../wgpu/struct.QuerySet.html
 */
#define WGPUQUERY_SIZE 8

/**
 * The largest number that can be returned by [`Self::target_pixel_byte_cost`].
 */
#define WGPUTextureFormat_MAX_TARGET_PIXEL_BYTE_COST 16

#define WGPUWEBGPU_FEATURE_DEPTH_CLIP_CONTROL (1 << 0)

#define WGPUWEBGPU_FEATURE_DEPTH32FLOAT_STENCIL8 (1 << 1)

#define WGPUWEBGPU_FEATURE_TEXTURE_COMPRESSION_BC (1 << 2)

#define WGPUWEBGPU_FEATURE_TEXTURE_COMPRESSION_BC_SLICED_3D (1 << 3)

#define WGPUWEBGPU_FEATURE_TEXTURE_COMPRESSION_ETC2 (1 << 4)

#define WGPUWEBGPU_FEATURE_TEXTURE_COMPRESSION_ASTC (1 << 5)

#define WGPUWEBGPU_FEATURE_TEXTURE_COMPRESSION_ASTC_SLICED_3D (1 << 6)

#define WGPUWEBGPU_FEATURE_TIMESTAMP_QUERY (1 << 7)

#define WGPUWEBGPU_FEATURE_INDIRECT_FIRST_INSTANCE (1 << 8)

#define WGPUWEBGPU_FEATURE_SHADER_F16 (1 << 9)

#define WGPUWEBGPU_FEATURE_RG11B10UFLOAT_RENDERABLE (1 << 10)

#define WGPUWEBGPU_FEATURE_BGRA8UNORM_STORAGE (1 << 11)

#define WGPUWEBGPU_FEATURE_FLOAT32_FILTERABLE (1 << 12)

#define WGPUWEBGPU_FEATURE_DUAL_SOURCE_BLENDING (1 << 13)

#define WGPUWEBGPU_FEATURE_CLIP_DISTANCES (1 << 14)

/**
 * Supported physical device types.
 */
enum WGPUDeviceType
#ifdef __cplusplus
  : uint8_t
#endif // __cplusplus
 {
  /**
   * Other or Unknown.
   */
  WGPUDeviceType_Other,
  /**
   * Integrated GPU with shared CPU/GPU memory.
   */
  WGPUDeviceType_IntegratedGpu,
  /**
   * Discrete GPU with separate CPU/GPU memory.
   */
  WGPUDeviceType_DiscreteGpu,
  /**
   * Virtual / Hosted.
   */
  WGPUDeviceType_VirtualGpu,
  /**
   * Cpu / Software Rendering.
   */
  WGPUDeviceType_Cpu,
  /**
   * Must be last for serialization purposes
   */
  WGPUDeviceType_Sentinel,
};
#ifndef __cplusplus
typedef uint8_t WGPUDeviceType;
#endif // __cplusplus

/**
 * Backends supported by wgpu.
 *
 * See also [`Backends`].
 */
enum WGPUBackend
#ifdef __cplusplus
  : uint8_t
#endif // __cplusplus
 {
  /**
   * Dummy backend, which may be used for testing.
   *
   * It performs no rendering or computation, but allows creation of stub GPU resource types,
   * so that code which manages GPU resources can be tested without an available GPU.
   * Specifically, the following operations are implemented:
   *
   * * Enumerating adapters will always return one noop adapter, which can be used to create
   *   devices.
   * * Buffers may be created, written, mapped, and copied to other buffers.
   * * Command encoders may be created, but only buffer operations are useful.
   *
   * Other resources can be created but are nonfunctional; notably,
   *
   * * Render passes and compute passes are not executed.
   * * Textures may be created, but do not store any texels.
   * * There are no compatible surfaces.
   *
   * An adapter using the noop backend can only be obtained if [`NoopBackendOptions`]
   * enables it, in addition to the ordinary requirement of [`Backends::NOOP`] being set.
   * This ensures that applications not desiring a non-functional backend will not receive it.
   */
  WGPUBackend_Noop = 0,
  /**
   * Vulkan API (Windows, Linux, Android, MacOS via `vulkan-portability`/MoltenVK)
   */
  WGPUBackend_Vulkan = 1,
  /**
   * Metal API (Apple platforms)
   */
  WGPUBackend_Metal = 2,
  /**
   * Direct3D-12 (Windows)
   */
  WGPUBackend_Dx12 = 3,
  /**
   * OpenGL 3.3+ (Windows), OpenGL ES 3.0+ (Linux, Android, MacOS via Angle), and WebGL2
   */
  WGPUBackend_Gl = 4,
  /**
   * WebGPU in the browser
   */
  WGPUBackend_BrowserWebGpu = 5,
  /**
   * Must be last for serialization purposes
   */
  WGPUBackend_Sentinel,
};
#ifndef __cplusplus
typedef uint8_t WGPUBackend;
#endif // __cplusplus

/**
 * Power Preference when choosing a physical adapter.
 *
 * Corresponds to [WebGPU `GPUPowerPreference`](
 * https://gpuweb.github.io/gpuweb/#enumdef-gpupowerpreference).
 */
enum WGPUPowerPreference {
  /**
   * Power usage is not considered when choosing an adapter.
   */
  WGPUPowerPreference_None = 0,
  /**
   * Adapter that uses the least possible power. This is often an integrated GPU.
   */
  WGPUPowerPreference_LowPower = 1,
  /**
   * Adapter that has the highest performance. This is often a discrete GPU.
   */
  WGPUPowerPreference_HighPerformance = 2,
  /**
   * Must be last for serialization purposes
   */
  WGPUPowerPreference_Sentinel,
};

/**
 * Dimensionality of a texture.
 *
 * Corresponds to [WebGPU `GPUTextureDimension`](
 * https://gpuweb.github.io/gpuweb/#enumdef-gputexturedimension).
 */
enum WGPUTextureDimension {
  /**
   * 1D texture
   */
  WGPUTextureDimension_D1,
  /**
   * 2D texture
   */
  WGPUTextureDimension_D2,
  /**
   * 3D texture
   */
  WGPUTextureDimension_D3,
  /**
   * Must be last for serialization purposes
   */
  WGPUTextureDimension_Sentinel,
};

/**
 * ASTC block dimensions
 */
enum WGPUAstcBlock {
  /**
   * 4x4 block compressed texture. 16 bytes per block (8 bit/px).
   */
  WGPUAstcBlock_B4x4,
  /**
   * 5x4 block compressed texture. 16 bytes per block (6.4 bit/px).
   */
  WGPUAstcBlock_B5x4,
  /**
   * 5x5 block compressed texture. 16 bytes per block (5.12 bit/px).
   */
  WGPUAstcBlock_B5x5,
  /**
   * 6x5 block compressed texture. 16 bytes per block (4.27 bit/px).
   */
  WGPUAstcBlock_B6x5,
  /**
   * 6x6 block compressed texture. 16 bytes per block (3.56 bit/px).
   */
  WGPUAstcBlock_B6x6,
  /**
   * 8x5 block compressed texture. 16 bytes per block (3.2 bit/px).
   */
  WGPUAstcBlock_B8x5,
  /**
   * 8x6 block compressed texture. 16 bytes per block (2.67 bit/px).
   */
  WGPUAstcBlock_B8x6,
  /**
   * 8x8 block compressed texture. 16 bytes per block (2 bit/px).
   */
  WGPUAstcBlock_B8x8,
  /**
   * 10x5 block compressed texture. 16 bytes per block (2.56 bit/px).
   */
  WGPUAstcBlock_B10x5,
  /**
   * 10x6 block compressed texture. 16 bytes per block (2.13 bit/px).
   */
  WGPUAstcBlock_B10x6,
  /**
   * 10x8 block compressed texture. 16 bytes per block (1.6 bit/px).
   */
  WGPUAstcBlock_B10x8,
  /**
   * 10x10 block compressed texture. 16 bytes per block (1.28 bit/px).
   */
  WGPUAstcBlock_B10x10,
  /**
   * 12x10 block compressed texture. 16 bytes per block (1.07 bit/px).
   */
  WGPUAstcBlock_B12x10,
  /**
   * 12x12 block compressed texture. 16 bytes per block (0.89 bit/px).
   */
  WGPUAstcBlock_B12x12,
  /**
   * Must be last for serialization purposes
   */
  WGPUAstcBlock_Sentinel,
};

/**
 * ASTC RGBA channel
 */
enum WGPUAstcChannel {
  /**
   * 8 bit integer RGBA, [0, 255] converted to/from linear-color float [0, 1] in shader.
   *
   * [`Features::TEXTURE_COMPRESSION_ASTC`] must be enabled to use this channel.
   */
  WGPUAstcChannel_Unorm,
  /**
   * 8 bit integer RGBA, Srgb-color [0, 255] converted to/from linear-color float [0, 1] in shader.
   *
   * [`Features::TEXTURE_COMPRESSION_ASTC`] must be enabled to use this channel.
   */
  WGPUAstcChannel_UnormSrgb,
  /**
   * floating-point RGBA, linear-color float can be outside of the [0, 1] range.
   *
   * [`Features::TEXTURE_COMPRESSION_ASTC_HDR`] must be enabled to use this channel.
   */
  WGPUAstcChannel_Hdr,
  /**
   * Must be last for serialization purposes
   */
  WGPUAstcChannel_Sentinel,
};

/**
 * Dimensions of a particular texture view.
 *
 * Corresponds to [WebGPU `GPUTextureViewDimension`](
 * https://gpuweb.github.io/gpuweb/#enumdef-gputextureviewdimension).
 */
enum WGPUTextureViewDimension {
  /**
   * A one dimensional texture. `texture_1d` in WGSL and `texture1D` in GLSL.
   */
  WGPUTextureViewDimension_D1,
  /**
   * A two dimensional texture. `texture_2d` in WGSL and `texture2D` in GLSL.
   */
  WGPUTextureViewDimension_D2,
  /**
   * A two dimensional array texture. `texture_2d_array` in WGSL and `texture2DArray` in GLSL.
   */
  WGPUTextureViewDimension_D2Array,
  /**
   * A cubemap texture. `texture_cube` in WGSL and `textureCube` in GLSL.
   */
  WGPUTextureViewDimension_Cube,
  /**
   * A cubemap array texture. `texture_cube_array` in WGSL and `textureCubeArray` in GLSL.
   */
  WGPUTextureViewDimension_CubeArray,
  /**
   * A three dimensional texture. `texture_3d` in WGSL and `texture3D` in GLSL.
   */
  WGPUTextureViewDimension_D3,
  /**
   * Must be last for serialization purposes
   */
  WGPUTextureViewDimension_Sentinel,
};

/**
 * Selects a subset of the data a [`Texture`] holds.
 *
 * Used in [texture views](TextureViewDescriptor) and
 * [texture copy operations](TexelCopyTextureInfo).
 *
 * Corresponds to [WebGPU `GPUTextureAspect`](
 * https://gpuweb.github.io/gpuweb/#enumdef-gputextureaspect).
 *
 * [`Texture`]: ../wgpu/struct.Texture.html
 */
enum WGPUTextureAspect {
  /**
   * Depth, Stencil, and Color.
   */
  WGPUTextureAspect_All,
  /**
   * Stencil.
   */
  WGPUTextureAspect_StencilOnly,
  /**
   * Depth.
   */
  WGPUTextureAspect_DepthOnly,
  /**
   * Plane 0.
   */
  WGPUTextureAspect_Plane0,
  /**
   * Plane 1.
   */
  WGPUTextureAspect_Plane1,
  /**
   * Plane 2.
   */
  WGPUTextureAspect_Plane2,
  /**
   * Must be last for serialization purposes
   */
  WGPUTextureAspect_Sentinel,
};

enum WGPUPredefinedColorSpace {
  WGPUPredefinedColorSpace_Srgb,
  WGPUPredefinedColorSpace_DisplayP3,
  /**
   * Must be last for serialization purposes
   */
  WGPUPredefinedColorSpace_Sentinel,
};

/**
 * How edges should be handled in texture addressing.
 *
 * Corresponds to [WebGPU `GPUAddressMode`](
 * https://gpuweb.github.io/gpuweb/#enumdef-gpuaddressmode).
 */
enum WGPUAddressMode {
  /**
   * Clamp the value to the edge of the texture
   *
   * -0.25 -> 0.0
   * 1.25  -> 1.0
   */
  WGPUAddressMode_ClampToEdge = 0,
  /**
   * Repeat the texture in a tiling fashion
   *
   * -0.25 -> 0.75
   * 1.25 -> 0.25
   */
  WGPUAddressMode_Repeat = 1,
  /**
   * Repeat the texture, mirroring it every repeat
   *
   * -0.25 -> 0.25
   * 1.25 -> 0.75
   */
  WGPUAddressMode_MirrorRepeat = 2,
  /**
   * Clamp the value to the border of the texture
   * Requires feature [`Features::ADDRESS_MODE_CLAMP_TO_BORDER`]
   *
   * -0.25 -> border
   * 1.25 -> border
   */
  WGPUAddressMode_ClampToBorder = 3,
  /**
   * Must be last for serialization purposes
   */
  WGPUAddressMode_Sentinel,
};

/**
 * Texel mixing mode when sampling between texels.
 *
 * Corresponds to [WebGPU `GPUFilterMode`](
 * https://gpuweb.github.io/gpuweb/#enumdef-gpufiltermode).
 */
enum WGPUFilterMode {
  /**
   * Nearest neighbor sampling.
   *
   * This creates a pixelated effect when used as a mag filter
   */
  WGPUFilterMode_Nearest = 0,
  /**
   * Linear Interpolation
   *
   * This makes textures smooth but blurry when used as a mag filter.
   */
  WGPUFilterMode_Linear = 1,
  /**
   * Must be last for serialization purposes
   */
  WGPUFilterMode_Sentinel,
};

/**
 * Comparison function used for depth and stencil operations.
 *
 * Corresponds to [WebGPU `GPUCompareFunction`](
 * https://gpuweb.github.io/gpuweb/#enumdef-gpucomparefunction).
 */
enum WGPUCompareFunction {
  /**
   * Function never passes
   */
  WGPUCompareFunction_Never = 1,
  /**
   * Function passes if new value less than existing value
   */
  WGPUCompareFunction_Less = 2,
  /**
   * Function passes if new value is equal to existing value. When using
   * this compare function, make sure to mark your Vertex Shader's `@builtin(position)`
   * output as `@invariant` to prevent artifacting.
   */
  WGPUCompareFunction_Equal = 3,
  /**
   * Function passes if new value is less than or equal to existing value
   */
  WGPUCompareFunction_LessEqual = 4,
  /**
   * Function passes if new value is greater than existing value
   */
  WGPUCompareFunction_Greater = 5,
  /**
   * Function passes if new value is not equal to existing value. When using
   * this compare function, make sure to mark your Vertex Shader's `@builtin(position)`
   * output as `@invariant` to prevent artifacting.
   */
  WGPUCompareFunction_NotEqual = 6,
  /**
   * Function passes if new value is greater than or equal to existing value
   */
  WGPUCompareFunction_GreaterEqual = 7,
  /**
   * Function always passes
   */
  WGPUCompareFunction_Always = 8,
  /**
   * Must be last for serialization purposes
   */
  WGPUCompareFunction_Sentinel,
};

enum WGPURawQueryType {
  WGPURawQueryType_Occlusion,
  WGPURawQueryType_Timestamp,
  /**
   * Must be last for serialization purposes
   */
  WGPURawQueryType_Sentinel,
};

/**
 * Operation to perform to the output attachment at the end of a render pass.
 *
 * Corresponds to [WebGPU `GPUStoreOp`](https://gpuweb.github.io/gpuweb/#enumdef-gpustoreop).
 */
enum WGPUStoreOp {
  /**
   * Stores the resulting value of the render pass for this attachment.
   */
  WGPUStoreOp_Store = 0,
  /**
   * Discards the resulting value of the render pass for this attachment.
   *
   * The attachment will be treated as uninitialized afterwards.
   * (If only either Depth or Stencil texture-aspects is set to `Discard`,
   * the respective other texture-aspect will be preserved.)
   *
   * This can be significantly faster on tile-based render hardware.
   *
   * Prefer this if the attachment is not read by subsequent passes.
   */
  WGPUStoreOp_Discard = 1,
  /**
   * Must be last for serialization purposes
   */
  WGPUStoreOp_Sentinel,
};

enum WGPURawBindingType {
  WGPURawBindingType_UniformBuffer,
  WGPURawBindingType_StorageBuffer,
  WGPURawBindingType_ReadonlyStorageBuffer,
  WGPURawBindingType_Sampler,
  WGPURawBindingType_SampledTexture,
  WGPURawBindingType_ReadonlyStorageTexture,
  WGPURawBindingType_WriteonlyStorageTexture,
  WGPURawBindingType_ReadWriteStorageTexture,
  WGPURawBindingType_ExternalTexture,
  /**
   * Must be last for serialization purposes
   */
  WGPURawBindingType_Sentinel,
};

enum WGPURawTextureSampleType {
  WGPURawTextureSampleType_Float,
  WGPURawTextureSampleType_UnfilterableFloat,
  WGPURawTextureSampleType_Uint,
  WGPURawTextureSampleType_Sint,
  WGPURawTextureSampleType_Depth,
  /**
   * Must be last for serialization purposes
   */
  WGPURawTextureSampleType_Sentinel,
};

/**
 * Whether a vertex buffer is indexed by vertex or by instance.
 *
 * Consider a call to [`RenderPass::draw`] like this:
 *
 * ```ignore
 * render_pass.draw(vertices, instances)
 * ```
 *
 * where `vertices` is a `Range<u32>` of vertex indices, and
 * `instances` is a `Range<u32>` of instance indices.
 *
 * For this call, `wgpu` invokes the vertex shader entry point once
 * for every possible `(v, i)` pair, where `v` is drawn from
 * `vertices` and `i` is drawn from `instances`. These invocations
 * may happen in any order, and will usually run in parallel.
 *
 * Each vertex buffer has a step mode, established by the
 * [`step_mode`] field of its [`VertexBufferLayout`], given when the
 * pipeline was created. Buffers whose step mode is [`Vertex`] use
 * `v` as the index into their contents, whereas buffers whose step
 * mode is [`Instance`] use `i`. The indicated buffer element then
 * contributes zero or more attribute values for the `(v, i)` vertex
 * shader invocation to use, based on the [`VertexBufferLayout`]'s
 * [`attributes`] list.
 *
 * You can visualize the results from all these vertex shader
 * invocations as a matrix with a row for each `i` from `instances`,
 * and with a column for each `v` from `vertices`. In one sense, `v`
 * and `i` are symmetrical: both are used to index vertex buffers and
 * provide attribute values.  But the key difference between `v` and
 * `i` is that line and triangle primitives are built from the values
 * of each row, along which `i` is constant and `v` varies, not the
 * columns.
 *
 * An indexed draw call works similarly:
 *
 * ```ignore
 * render_pass.draw_indexed(indices, base_vertex, instances)
 * ```
 *
 * The only difference is that `v` values are drawn from the contents
 * of the index buffer&mdash;specifically, the subrange of the index
 * buffer given by `indices`&mdash;instead of simply being sequential
 * integers, as they are in a `draw` call.
 *
 * A non-instanced call, where `instances` is `0..1`, is simply a
 * matrix with only one row.
 *
 * Corresponds to [WebGPU `GPUVertexStepMode`](
 * https://gpuweb.github.io/gpuweb/#enumdef-gpuvertexstepmode).
 *
 * [`RenderPass::draw`]: ../wgpu/struct.RenderPass.html#method.draw
 * [`VertexBufferLayout`]: ../wgpu/struct.VertexBufferLayout.html
 * [`step_mode`]: ../wgpu/struct.VertexBufferLayout.html#structfield.step_mode
 * [`attributes`]: ../wgpu/struct.VertexBufferLayout.html#structfield.attributes
 * [`Vertex`]: VertexStepMode::Vertex
 * [`Instance`]: VertexStepMode::Instance
 */
enum WGPUVertexStepMode {
  /**
   * Vertex data is advanced every vertex.
   */
  WGPUVertexStepMode_Vertex = 0,
  /**
   * Vertex data is advanced every instance.
   */
  WGPUVertexStepMode_Instance = 1,
  /**
   * Must be last for serialization purposes
   */
  WGPUVertexStepMode_Sentinel,
};

/**
 * Vertex Format for a [`VertexAttribute`] (input).
 *
 * Corresponds to [WebGPU `GPUVertexFormat`](
 * https://gpuweb.github.io/gpuweb/#enumdef-gpuvertexformat).
 */
enum WGPUVertexFormat {
  /**
   * One unsigned byte (u8). `u32` in shaders.
   */
  WGPUVertexFormat_Uint8 = 0,
  /**
   * Two unsigned bytes (u8). `vec2<u32>` in shaders.
   */
  WGPUVertexFormat_Uint8x2 = 1,
  /**
   * Four unsigned bytes (u8). `vec4<u32>` in shaders.
   */
  WGPUVertexFormat_Uint8x4 = 2,
  /**
   * One signed byte (i8). `i32` in shaders.
   */
  WGPUVertexFormat_Sint8 = 3,
  /**
   * Two signed bytes (i8). `vec2<i32>` in shaders.
   */
  WGPUVertexFormat_Sint8x2 = 4,
  /**
   * Four signed bytes (i8). `vec4<i32>` in shaders.
   */
  WGPUVertexFormat_Sint8x4 = 5,
  /**
   * One unsigned byte (u8). [0, 255] converted to float [0, 1] `f32` in shaders.
   */
  WGPUVertexFormat_Unorm8 = 6,
  /**
   * Two unsigned bytes (u8). [0, 255] converted to float [0, 1] `vec2<f32>` in shaders.
   */
  WGPUVertexFormat_Unorm8x2 = 7,
  /**
   * Four unsigned bytes (u8). [0, 255] converted to float [0, 1] `vec4<f32>` in shaders.
   */
  WGPUVertexFormat_Unorm8x4 = 8,
  /**
   * One signed byte (i8). [&minus;127, 127] converted to float [&minus;1, 1] `f32` in shaders.
   */
  WGPUVertexFormat_Snorm8 = 9,
  /**
   * Two signed bytes (i8). [&minus;127, 127] converted to float [&minus;1, 1] `vec2<f32>` in shaders.
   */
  WGPUVertexFormat_Snorm8x2 = 10,
  /**
   * Four signed bytes (i8). [&minus;127, 127] converted to float [&minus;1, 1] `vec4<f32>` in shaders.
   */
  WGPUVertexFormat_Snorm8x4 = 11,
  /**
   * One unsigned short (u16). `u32` in shaders.
   */
  WGPUVertexFormat_Uint16 = 12,
  /**
   * Two unsigned shorts (u16). `vec2<u32>` in shaders.
   */
  WGPUVertexFormat_Uint16x2 = 13,
  /**
   * Four unsigned shorts (u16). `vec4<u32>` in shaders.
   */
  WGPUVertexFormat_Uint16x4 = 14,
  /**
   * One signed short (u16). `i32` in shaders.
   */
  WGPUVertexFormat_Sint16 = 15,
  /**
   * Two signed shorts (i16). `vec2<i32>` in shaders.
   */
  WGPUVertexFormat_Sint16x2 = 16,
  /**
   * Four signed shorts (i16). `vec4<i32>` in shaders.
   */
  WGPUVertexFormat_Sint16x4 = 17,
  /**
   * One unsigned short (u16). [0, 65535] converted to float [0, 1] `f32` in shaders.
   */
  WGPUVertexFormat_Unorm16 = 18,
  /**
   * Two unsigned shorts (u16). [0, 65535] converted to float [0, 1] `vec2<f32>` in shaders.
   */
  WGPUVertexFormat_Unorm16x2 = 19,
  /**
   * Four unsigned shorts (u16). [0, 65535] converted to float [0, 1] `vec4<f32>` in shaders.
   */
  WGPUVertexFormat_Unorm16x4 = 20,
  /**
   * One signed short (i16). [&minus;32767, 32767] converted to float [&minus;1, 1] `f32` in shaders.
   */
  WGPUVertexFormat_Snorm16 = 21,
  /**
   * Two signed shorts (i16). [&minus;32767, 32767] converted to float [&minus;1, 1] `vec2<f32>` in shaders.
   */
  WGPUVertexFormat_Snorm16x2 = 22,
  /**
   * Four signed shorts (i16). [&minus;32767, 32767] converted to float [&minus;1, 1] `vec4<f32>` in shaders.
   */
  WGPUVertexFormat_Snorm16x4 = 23,
  /**
   * One half-precision float (no Rust equiv). `f32` in shaders.
   */
  WGPUVertexFormat_Float16 = 24,
  /**
   * Two half-precision floats (no Rust equiv). `vec2<f32>` in shaders.
   */
  WGPUVertexFormat_Float16x2 = 25,
  /**
   * Four half-precision floats (no Rust equiv). `vec4<f32>` in shaders.
   */
  WGPUVertexFormat_Float16x4 = 26,
  /**
   * One single-precision float (f32). `f32` in shaders.
   */
  WGPUVertexFormat_Float32 = 27,
  /**
   * Two single-precision floats (f32). `vec2<f32>` in shaders.
   */
  WGPUVertexFormat_Float32x2 = 28,
  /**
   * Three single-precision floats (f32). `vec3<f32>` in shaders.
   */
  WGPUVertexFormat_Float32x3 = 29,
  /**
   * Four single-precision floats (f32). `vec4<f32>` in shaders.
   */
  WGPUVertexFormat_Float32x4 = 30,
  /**
   * One unsigned int (u32). `u32` in shaders.
   */
  WGPUVertexFormat_Uint32 = 31,
  /**
   * Two unsigned ints (u32). `vec2<u32>` in shaders.
   */
  WGPUVertexFormat_Uint32x2 = 32,
  /**
   * Three unsigned ints (u32). `vec3<u32>` in shaders.
   */
  WGPUVertexFormat_Uint32x3 = 33,
  /**
   * Four unsigned ints (u32). `vec4<u32>` in shaders.
   */
  WGPUVertexFormat_Uint32x4 = 34,
  /**
   * One signed int (i32). `i32` in shaders.
   */
  WGPUVertexFormat_Sint32 = 35,
  /**
   * Two signed ints (i32). `vec2<i32>` in shaders.
   */
  WGPUVertexFormat_Sint32x2 = 36,
  /**
   * Three signed ints (i32). `vec3<i32>` in shaders.
   */
  WGPUVertexFormat_Sint32x3 = 37,
  /**
   * Four signed ints (i32). `vec4<i32>` in shaders.
   */
  WGPUVertexFormat_Sint32x4 = 38,
  /**
   * One double-precision float (f64). `f32` in shaders. Requires [`Features::VERTEX_ATTRIBUTE_64BIT`].
   */
  WGPUVertexFormat_Float64 = 39,
  /**
   * Two double-precision floats (f64). `vec2<f32>` in shaders. Requires [`Features::VERTEX_ATTRIBUTE_64BIT`].
   */
  WGPUVertexFormat_Float64x2 = 40,
  /**
   * Three double-precision floats (f64). `vec3<f32>` in shaders. Requires [`Features::VERTEX_ATTRIBUTE_64BIT`].
   */
  WGPUVertexFormat_Float64x3 = 41,
  /**
   * Four double-precision floats (f64). `vec4<f32>` in shaders. Requires [`Features::VERTEX_ATTRIBUTE_64BIT`].
   */
  WGPUVertexFormat_Float64x4 = 42,
  /**
   * Three unsigned 10-bit integers and one 2-bit integer, packed into a 32-bit integer (u32). [0, 1024] converted to float [0, 1] `vec4<f32>` in shaders.
   */
  WGPUVertexFormat_Unorm10_10_10_2 = 43,
  /**
   * Four unsigned 8-bit integers, packed into a 32-bit integer (u32). [0, 255] converted to float [0, 1] `vec4<f32>` in shaders.
   */
  WGPUVertexFormat_Unorm8x4Bgra = 44,
  /**
   * Must be last for serialization purposes
   */
  WGPUVertexFormat_Sentinel,
};

/**
 * Primitive type the input mesh is composed of.
 *
 * Corresponds to [WebGPU `GPUPrimitiveTopology`](
 * https://gpuweb.github.io/gpuweb/#enumdef-gpuprimitivetopology).
 */
enum WGPUPrimitiveTopology {
  /**
   * Vertex data is a list of points. Each vertex is a new point.
   */
  WGPUPrimitiveTopology_PointList = 0,
  /**
   * Vertex data is a list of lines. Each pair of vertices composes a new line.
   *
   * Vertices `0 1 2 3` create two lines `0 1` and `2 3`
   */
  WGPUPrimitiveTopology_LineList = 1,
  /**
   * Vertex data is a strip of lines. Each set of two adjacent vertices form a line.
   *
   * Vertices `0 1 2 3` create three lines `0 1`, `1 2`, and `2 3`.
   */
  WGPUPrimitiveTopology_LineStrip = 2,
  /**
   * Vertex data is a list of triangles. Each set of 3 vertices composes a new triangle.
   *
   * Vertices `0 1 2 3 4 5` create two triangles `0 1 2` and `3 4 5`
   */
  WGPUPrimitiveTopology_TriangleList = 3,
  /**
   * Vertex data is a triangle strip. Each set of three adjacent vertices form a triangle.
   *
   * Vertices `0 1 2 3 4 5` create four triangles `0 1 2`, `2 1 3`, `2 3 4`, and `4 3 5`
   */
  WGPUPrimitiveTopology_TriangleStrip = 4,
  /**
   * Must be last for serialization purposes
   */
  WGPUPrimitiveTopology_Sentinel,
};

/**
 * Format of indices used with pipeline.
 *
 * Corresponds to [WebGPU `GPUIndexFormat`](
 * https://gpuweb.github.io/gpuweb/#enumdef-gpuindexformat).
 */
enum WGPUIndexFormat {
  /**
   * Indices are 16 bit unsigned integers.
   */
  WGPUIndexFormat_Uint16 = 0,
  /**
   * Indices are 32 bit unsigned integers.
   */
  WGPUIndexFormat_Uint32 = 1,
  /**
   * Must be last for serialization purposes
   */
  WGPUIndexFormat_Sentinel,
};

/**
 * Vertex winding order which classifies the "front" face of a triangle.
 *
 * Corresponds to [WebGPU `GPUFrontFace`](
 * https://gpuweb.github.io/gpuweb/#enumdef-gpufrontface).
 */
enum WGPUFrontFace {
  /**
   * Triangles with vertices in counter clockwise order are considered the front face.
   *
   * This is the default with right handed coordinate spaces.
   */
  WGPUFrontFace_Ccw = 0,
  /**
   * Triangles with vertices in clockwise order are considered the front face.
   *
   * This is the default with left handed coordinate spaces.
   */
  WGPUFrontFace_Cw = 1,
  /**
   * Must be last for serialization purposes
   */
  WGPUFrontFace_Sentinel,
};

/**
 * Face of a vertex.
 *
 * Corresponds to [WebGPU `GPUCullMode`](
 * https://gpuweb.github.io/gpuweb/#enumdef-gpucullmode),
 * except that the `"none"` value is represented using `Option<Face>` instead.
 */
enum WGPUFace {
  /**
   * Front face
   */
  WGPUFace_Front = 0,
  /**
   * Back face
   */
  WGPUFace_Back = 1,
  /**
   * Must be last for serialization purposes
   */
  WGPUFace_Sentinel,
};

/**
 * Type of drawing mode for polygons
 */
enum WGPUPolygonMode {
  /**
   * Polygons are filled
   */
  WGPUPolygonMode_Fill = 0,
  /**
   * Polygons are drawn as line segments
   */
  WGPUPolygonMode_Line = 1,
  /**
   * Polygons are drawn as points
   */
  WGPUPolygonMode_Point = 2,
  /**
   * Must be last for serialization purposes
   */
  WGPUPolygonMode_Sentinel,
};

/**
 * Alpha blend factor.
 *
 * Corresponds to [WebGPU `GPUBlendFactor`](
 * https://gpuweb.github.io/gpuweb/#enumdef-gpublendfactor). Values using `Src1`
 * require [`Features::DUAL_SOURCE_BLENDING`] and can only be used with the first
 * render target.
 *
 * For further details on how the blend factors are applied, see the analogous
 * functionality in OpenGL: <https://www.khronos.org/opengl/wiki/Blending#Blending_Parameters>.
 */
enum WGPUBlendFactor {
  /**
   * 0.0
   */
  WGPUBlendFactor_Zero = 0,
  /**
   * 1.0
   */
  WGPUBlendFactor_One = 1,
  /**
   * S.component
   */
  WGPUBlendFactor_Src = 2,
  /**
   * 1.0 - S.component
   */
  WGPUBlendFactor_OneMinusSrc = 3,
  /**
   * S.alpha
   */
  WGPUBlendFactor_SrcAlpha = 4,
  /**
   * 1.0 - S.alpha
   */
  WGPUBlendFactor_OneMinusSrcAlpha = 5,
  /**
   * D.component
   */
  WGPUBlendFactor_Dst = 6,
  /**
   * 1.0 - D.component
   */
  WGPUBlendFactor_OneMinusDst = 7,
  /**
   * D.alpha
   */
  WGPUBlendFactor_DstAlpha = 8,
  /**
   * 1.0 - D.alpha
   */
  WGPUBlendFactor_OneMinusDstAlpha = 9,
  /**
   * min(S.alpha, 1.0 - D.alpha)
   */
  WGPUBlendFactor_SrcAlphaSaturated = 10,
  /**
   * Constant
   */
  WGPUBlendFactor_Constant = 11,
  /**
   * 1.0 - Constant
   */
  WGPUBlendFactor_OneMinusConstant = 12,
  /**
   * S1.component
   */
  WGPUBlendFactor_Src1 = 13,
  /**
   * 1.0 - S1.component
   */
  WGPUBlendFactor_OneMinusSrc1 = 14,
  /**
   * S1.alpha
   */
  WGPUBlendFactor_Src1Alpha = 15,
  /**
   * 1.0 - S1.alpha
   */
  WGPUBlendFactor_OneMinusSrc1Alpha = 16,
  /**
   * Must be last for serialization purposes
   */
  WGPUBlendFactor_Sentinel,
};

/**
 * Alpha blend operation.
 *
 * Corresponds to [WebGPU `GPUBlendOperation`](
 * https://gpuweb.github.io/gpuweb/#enumdef-gpublendoperation).
 *
 * For further details on how the blend operations are applied, see
 * the analogous functionality in OpenGL: <https://www.khronos.org/opengl/wiki/Blending#Blend_Equations>.
 */
enum WGPUBlendOperation {
  /**
   * Src + Dst
   */
  WGPUBlendOperation_Add = 0,
  /**
   * Src - Dst
   */
  WGPUBlendOperation_Subtract = 1,
  /**
   * Dst - Src
   */
  WGPUBlendOperation_ReverseSubtract = 2,
  /**
   * min(Src, Dst)
   */
  WGPUBlendOperation_Min = 3,
  /**
   * max(Src, Dst)
   */
  WGPUBlendOperation_Max = 4,
  /**
   * Must be last for serialization purposes
   */
  WGPUBlendOperation_Sentinel,
};

/**
 * Operation to perform on the stencil value.
 *
 * Corresponds to [WebGPU `GPUStencilOperation`](
 * https://gpuweb.github.io/gpuweb/#enumdef-gpustenciloperation).
 */
enum WGPUStencilOperation {
  /**
   * Keep stencil value unchanged.
   */
  WGPUStencilOperation_Keep = 0,
  /**
   * Set stencil value to zero.
   */
  WGPUStencilOperation_Zero = 1,
  /**
   * Replace stencil value with value provided in most recent call to
   * [`RenderPass::set_stencil_reference`][RPssr].
   *
   * [RPssr]: ../wgpu/struct.RenderPass.html#method.set_stencil_reference
   */
  WGPUStencilOperation_Replace = 2,
  /**
   * Bitwise inverts stencil value.
   */
  WGPUStencilOperation_Invert = 3,
  /**
   * Increments stencil value by one, clamping on overflow.
   */
  WGPUStencilOperation_IncrementClamp = 4,
  /**
   * Decrements stencil value by one, clamping on underflow.
   */
  WGPUStencilOperation_DecrementClamp = 5,
  /**
   * Increments stencil value by one, wrapping on overflow.
   */
  WGPUStencilOperation_IncrementWrap = 6,
  /**
   * Decrements stencil value by one, wrapping on underflow.
   */
  WGPUStencilOperation_DecrementWrap = 7,
  /**
   * Must be last for serialization purposes
   */
  WGPUStencilOperation_Sentinel,
};

/**
 * Corresponds to an optional discriminant of [`GPUError`] type in the WebGPU API. Strongly
 * correlates to [`GPUErrorFilter`]s.
 *
 * [`GPUError`]: https://gpuweb.github.io/gpuweb/#gpuerror
 * [`GPUErrorFilter`]: https://gpuweb.github.io/gpuweb/#enumdef-gpuerrorfilter
 */
enum WGPUErrorBufferType
#ifdef __cplusplus
  : uint8_t
#endif // __cplusplus
 {
  WGPUErrorBufferType_None = 0,
  WGPUErrorBufferType_DeviceLost = 1,
  WGPUErrorBufferType_Internal = 2,
  WGPUErrorBufferType_OutOfMemory = 3,
  WGPUErrorBufferType_Validation = 4,
  /**
   * Must be last for serialization purposes
   */
  WGPUErrorBufferType_Sentinel,
};
#ifndef __cplusplus
typedef uint8_t WGPUErrorBufferType;
#endif // __cplusplus

enum WGPUHostMap {
  WGPUHostMap_Read,
  WGPUHostMap_Write,
  /**
   * Must be last for serialization purposes
   */
  WGPUHostMap_Sentinel,
};

/**
 * The status code provided to the buffer mapping closure.
 *
 * This is very similar to `BufferAccessResult`, except that this is FFI-friendly.
 */
enum WGPUBufferMapAsyncStatus {
  /**
   * The Buffer is successfully mapped, `get_mapped_range` can be called.
   *
   * All other variants of this enum represent failures to map the buffer.
   */
  WGPUBufferMapAsyncStatus_Success,
  /**
   * The buffer is already mapped.
   *
   * While this is treated as an error, it does not prevent mapped range from being accessed.
   */
  WGPUBufferMapAsyncStatus_AlreadyMapped,
  /**
   * Mapping was already requested.
   */
  WGPUBufferMapAsyncStatus_MapAlreadyPending,
  /**
   * An unknown error.
   */
  WGPUBufferMapAsyncStatus_Error,
  /**
   * The context is Lost.
   */
  WGPUBufferMapAsyncStatus_ContextLost,
  /**
   * The buffer is in an invalid state.
   */
  WGPUBufferMapAsyncStatus_Invalid,
  /**
   * The range isn't fully contained in the buffer.
   */
  WGPUBufferMapAsyncStatus_InvalidRange,
  /**
   * The range isn't properly aligned.
   */
  WGPUBufferMapAsyncStatus_InvalidAlignment,
  /**
   * Incompatible usage flags.
   */
  WGPUBufferMapAsyncStatus_InvalidUsageFlags,
  /**
   * Must be last for serialization purposes
   */
  WGPUBufferMapAsyncStatus_Sentinel,
};

/**
 * Format of an `ExternalTexture`. This indicates the number of underlying
 * planes used by the `ExternalTexture` as well as each plane's format.
 */
enum WGPUExternalTextureFormat {
  /**
   * Single [`TextureFormat::Rgba8Unorm`] or [`TextureFormat::Bgra8Unorm`] format plane.
   */
  WGPUExternalTextureFormat_Rgba,
  /**
   * [`TextureFormat::R8Unorm`] Y plane, and [`TextureFormat::Rg8Unorm`]
   * interleaved CbCr plane.
   */
  WGPUExternalTextureFormat_Nv12,
  /**
   * Separate [`TextureFormat::R8Unorm`] Y, Cb, and Cr planes.
   */
  WGPUExternalTextureFormat_Yu12,
  /**
   * Must be last for serialization purposes
   */
  WGPUExternalTextureFormat_Sentinel,
};

/**
 * Flags for acceleration structures
 */
struct WGPUAccelerationStructureFlags;

/**
 * Flags for acceleration structure geometries
 */
struct WGPUAccelerationStructureGeometryFlags;

struct WGPUAccelerationStructureUses;

struct WGPUAttachmentOps;

/**
 * Pipeline layout creation flags.
 */
struct WGPUBindGroupLayoutFlags;

/**
 * Similar to `BufferUsages`, but used only for `CommandEncoder::transition_resources`.
 */
struct WGPUBufferUses;

struct WGPUClient;

/**
 * Binary flags listing features that may or may not be present on downlevel adapters.
 *
 * A downlevel adapter is a GPU adapter that wgpu supports, but with potentially limited
 * features, due to the lack of hardware feature support.
 *
 * Flags that are **not** present for a downlevel adapter or device usually indicates
 * non-compliance with the WebGPU specification, but not always.
 *
 * You can check whether a set of flags is compliant through the
 * [`DownlevelCapabilities::is_webgpu_compliant()`] function.
 */
struct WGPUDownlevelFlags;

/**
 * Texture format capability flags.
 */
struct WGPUFormatAspects;

struct WGPUGlobal;

struct WGPUMemoryFlags;

#if defined(XP_MACOSX)
struct WGPUMetalSharedEventHandle;
#endif

#if !defined(XP_MACOSX)
struct WGPUMetalSharedEventHandle;
#endif

/**
 * Pipeline layout creation flags.
 */
struct WGPUPipelineLayoutFlags;

/**
 * Nanosecond timestamp used by the presentation engine.
 *
 * The specific clock depends on the window system integration (WSI) API used.
 *
 * <table>
 * <tr>
 *     <td>WSI</td>
 *     <td>Clock</td>
 * </tr>
 * <tr>
 *     <td>IDXGISwapchain</td>
 *     <td><a href="https://docs.microsoft.com/en-us/windows/win32/api/profileapi/nf-profileapi-queryperformancecounter">QueryPerformanceCounter</a></td>
 * </tr>
 * <tr>
 *     <td>IPresentationManager</td>
 *     <td><a href="https://docs.microsoft.com/en-us/windows/win32/api/realtimeapiset/nf-realtimeapiset-queryinterrupttimeprecise">QueryInterruptTimePrecise</a></td>
 * </tr>
 * <tr>
 *     <td>CAMetalLayer</td>
 *     <td><a href="https://developer.apple.com/documentation/kernel/1462446-mach_absolute_time">mach_absolute_time</a></td>
 * </tr>
 * <tr>
 *     <td>VK_GOOGLE_display_timing</td>
 *     <td><a href="https://linux.die.net/man/3/clock_gettime">clock_gettime(CLOCK_MONOTONIC)</a></td>
 * </tr>
 * </table>
 */
struct WGPUPresentationTimestamp;

struct WGPUPrivateCapabilities;

/**
 * Flags that affect internal code paths but do not
 * change the exposed feature set.
 */
struct WGPUPrivateCapabilities;

struct WGPUPrivateCapabilities;

/**
 * Set of internal capabilities, which don't show up in the exposed
 * device geometry, but affect the code paths taken internally.
 */
struct WGPUPrivateCapabilities;

struct WGPURecordedComputePass;

struct WGPURecordedRenderPass;

struct WGPURenderBundleEncoder;

struct WGPUTableTypes;

/**
 * Texture format capability flags.
 */
struct WGPUTextureFormatCapabilities;

/**
 * Similar to `TextureUsages`, but used only for `CommandEncoder::transition_resources`.
 */
struct WGPUTextureUses;

/**
 * Similar to `MTLCounterSamplingPoint`, but a bit higher abstracted for our purposes.
 */
struct WGPUTimestampQuerySupport;

struct WGPUVkImageHandle;

struct WGPUVkSemaphoreHandle;

struct WGPUWorkarounds;

/**
 * Flags that indicate necessary workarounds for specific devices or driver bugs
 */
struct WGPUWorkarounds;

/**
 * Workaround flags.
 */
struct WGPUWorkarounds;

struct WGPUByteBuf {
  uint8_t *data;
  uintptr_t len;
  uintptr_t capacity;
};

/**
 * Opaque pointer to `mozilla::webgpu::WebGPUChild`.
 */
typedef void *WGPUWebGPUChildPtr;

/**
 * Represents the sets of limits an adapter/device supports.
 *
 * We provide three different defaults.
 * - [`Limits::downlevel_defaults()`]. This is a set of limits that is guaranteed to work on almost
 *   all backends, including "downlevel" backends such as OpenGL and D3D11, other than WebGL. For
 *   most applications we recommend using these limits, assuming they are high enough for your
 *   application, and you do not intent to support WebGL.
 * - [`Limits::downlevel_webgl2_defaults()`] This is a set of limits that is lower even than the
 *   [`downlevel_defaults()`], configured to be low enough to support running in the browser using
 *   WebGL2.
 * - [`Limits::default()`]. This is the set of limits that is guaranteed to work on all modern
 *   backends and is guaranteed to be supported by WebGPU. Applications needing more modern
 *   features can use this as a reasonable set of limits if they are targeting only desktop and
 *   modern mobile devices.
 *
 * We recommend starting with the most restrictive limits you can and manually increasing the
 * limits you need boosted. This will let you stay running on all hardware that supports the limits
 * you need.
 *
 * Limits "better" than the default must be supported by the adapter and requested when requesting
 * a device. If limits "better" than the adapter supports are requested, requesting a device will
 * panic. Once a device is requested, you may only use resources up to the limits requested _even_
 * if the adapter supports "better" limits.
 *
 * Requesting limits that are "better" than you need may cause performance to decrease because the
 * implementation needs to support more than is needed. You should ideally only request exactly
 * what you need.
 *
 * Corresponds to [WebGPU `GPUSupportedLimits`](
 * https://gpuweb.github.io/gpuweb/#gpusupportedlimits).
 *
 * [`downlevel_defaults()`]: Limits::downlevel_defaults
 */
struct WGPULimits {
  /**
   * Maximum allowed value for the `size.width` of a texture created with `TextureDimension::D1`.
   * Defaults to 8192. Higher is "better".
   */
  uint32_t max_texture_dimension_1d;
  /**
   * Maximum allowed value for the `size.width` and `size.height` of a texture created with `TextureDimension::D2`.
   * Defaults to 8192. Higher is "better".
   */
  uint32_t max_texture_dimension_2d;
  /**
   * Maximum allowed value for the `size.width`, `size.height`, and `size.depth_or_array_layers`
   * of a texture created with `TextureDimension::D3`.
   * Defaults to 2048. Higher is "better".
   */
  uint32_t max_texture_dimension_3d;
  /**
   * Maximum allowed value for the `size.depth_or_array_layers` of a texture created with `TextureDimension::D2`.
   * Defaults to 256. Higher is "better".
   */
  uint32_t max_texture_array_layers;
  /**
   * Amount of bind groups that can be attached to a pipeline at the same time. Defaults to 4. Higher is "better".
   */
  uint32_t max_bind_groups;
  /**
   * Maximum binding index allowed in `create_bind_group_layout`. Defaults to 1000. Higher is "better".
   */
  uint32_t max_bindings_per_bind_group;
  /**
   * Amount of uniform buffer bindings that can be dynamic in a single pipeline. Defaults to 8. Higher is "better".
   */
  uint32_t max_dynamic_uniform_buffers_per_pipeline_layout;
  /**
   * Amount of storage buffer bindings that can be dynamic in a single pipeline. Defaults to 4. Higher is "better".
   */
  uint32_t max_dynamic_storage_buffers_per_pipeline_layout;
  /**
   * Amount of sampled textures visible in a single shader stage. Defaults to 16. Higher is "better".
   */
  uint32_t max_sampled_textures_per_shader_stage;
  /**
   * Amount of samplers visible in a single shader stage. Defaults to 16. Higher is "better".
   */
  uint32_t max_samplers_per_shader_stage;
  /**
   * Amount of storage buffers visible in a single shader stage. Defaults to 8. Higher is "better".
   */
  uint32_t max_storage_buffers_per_shader_stage;
  /**
   * Amount of storage textures visible in a single shader stage. Defaults to 4. Higher is "better".
   */
  uint32_t max_storage_textures_per_shader_stage;
  /**
   * Amount of uniform buffers visible in a single shader stage. Defaults to 12. Higher is "better".
   */
  uint32_t max_uniform_buffers_per_shader_stage;
  /**
   * Amount of individual resources within binding arrays that can be accessed in a single shader stage. Applies
   * to all types of bindings except samplers.
   *
   * This "defaults" to 0. However if binding arrays are supported, all devices can support 500,000. Higher is "better".
   */
  uint32_t max_binding_array_elements_per_shader_stage;
  /**
   * Amount of individual samplers within binding arrays that can be accessed in a single shader stage.
   *
   * This "defaults" to 0. However if binding arrays are supported, all devices can support 1,000. Higher is "better".
   */
  uint32_t max_binding_array_sampler_elements_per_shader_stage;
  /**
   * Maximum size in bytes of a binding to a uniform buffer. Defaults to 64 KiB. Higher is "better".
   */
  uint32_t max_uniform_buffer_binding_size;
  /**
   * Maximum size in bytes of a binding to a storage buffer. Defaults to 128 MiB. Higher is "better".
   */
  uint32_t max_storage_buffer_binding_size;
  /**
   * Maximum length of `VertexState::buffers` when creating a `RenderPipeline`.
   * Defaults to 8. Higher is "better".
   */
  uint32_t max_vertex_buffers;
  /**
   * A limit above which buffer allocations are guaranteed to fail.
   * Defaults to 256 MiB. Higher is "better".
   *
   * Buffer allocations below the maximum buffer size may not succeed depending on available memory,
   * fragmentation and other factors.
   */
  uint64_t max_buffer_size;
  /**
   * Maximum length of `VertexBufferLayout::attributes`, summed over all `VertexState::buffers`,
   * when creating a `RenderPipeline`.
   * Defaults to 16. Higher is "better".
   */
  uint32_t max_vertex_attributes;
  /**
   * Maximum value for `VertexBufferLayout::array_stride` when creating a `RenderPipeline`.
   * Defaults to 2048. Higher is "better".
   */
  uint32_t max_vertex_buffer_array_stride;
  /**
   * Required `BufferBindingType::Uniform` alignment for `BufferBinding::offset`
   * when creating a `BindGroup`, or for `set_bind_group` `dynamicOffsets`.
   * Defaults to 256. Lower is "better".
   */
  uint32_t min_uniform_buffer_offset_alignment;
  /**
   * Required `BufferBindingType::Storage` alignment for `BufferBinding::offset`
   * when creating a `BindGroup`, or for `set_bind_group` `dynamicOffsets`.
   * Defaults to 256. Lower is "better".
   */
  uint32_t min_storage_buffer_offset_alignment;
  /**
   * Maximum allowed number of components (scalars) of input or output locations for
   * inter-stage communication (vertex outputs to fragment inputs). Defaults to 60.
   * Higher is "better".
   */
  uint32_t max_inter_stage_shader_components;
  /**
   * The maximum allowed number of color attachments.
   */
  uint32_t max_color_attachments;
  /**
   * The maximum number of bytes necessary to hold one sample (pixel or subpixel) of render
   * pipeline output data, across all color attachments as described by [`TextureFormat::target_pixel_byte_cost`]
   * and [`TextureFormat::target_component_alignment`]. Defaults to 32. Higher is "better".
   *
   * ⚠️ `Rgba8Unorm`/`Rgba8Snorm`/`Bgra8Unorm`/`Bgra8Snorm` are deceptively 8 bytes per sample. ⚠️
   */
  uint32_t max_color_attachment_bytes_per_sample;
  /**
   * Maximum number of bytes used for workgroup memory in a compute entry point. Defaults to
   * 16384. Higher is "better".
   */
  uint32_t max_compute_workgroup_storage_size;
  /**
   * Maximum value of the product of the `workgroup_size` dimensions for a compute entry-point.
   * Defaults to 256. Higher is "better".
   */
  uint32_t max_compute_invocations_per_workgroup;
  /**
   * The maximum value of the `workgroup_size` X dimension for a compute stage `ShaderModule` entry-point.
   * Defaults to 256. Higher is "better".
   */
  uint32_t max_compute_workgroup_size_x;
  /**
   * The maximum value of the `workgroup_size` Y dimension for a compute stage `ShaderModule` entry-point.
   * Defaults to 256. Higher is "better".
   */
  uint32_t max_compute_workgroup_size_y;
  /**
   * The maximum value of the `workgroup_size` Z dimension for a compute stage `ShaderModule` entry-point.
   * Defaults to 64. Higher is "better".
   */
  uint32_t max_compute_workgroup_size_z;
  /**
   * The maximum value for each dimension of a `ComputePass::dispatch(x, y, z)` operation.
   * Defaults to 65535. Higher is "better".
   */
  uint32_t max_compute_workgroups_per_dimension;
  /**
   * Minimal number of invocations in a subgroup. Higher is "better".
   */
  uint32_t min_subgroup_size;
  /**
   * Maximal number of invocations in a subgroup. Lower is "better".
   */
  uint32_t max_subgroup_size;
  /**
   * Amount of storage available for push constants in bytes. Defaults to 0. Higher is "better".
   * Requesting more than 0 during device creation requires [`Features::PUSH_CONSTANTS`] to be enabled.
   *
   * Expect the size to be:
   * - Vulkan: 128-256 bytes
   * - DX12: 256 bytes
   * - Metal: 4096 bytes
   * - OpenGL doesn't natively support push constants, and are emulated with uniforms,
   *   so this number is less useful but likely 256.
   */
  uint32_t max_push_constant_size;
  /**
   * Maximum number of live non-sampler bindings.
   *
   * This limit only affects the d3d12 backend. Using a large number will allow the device
   * to create many bind groups at the cost of a large up-front allocation at device creation.
   */
  uint32_t max_non_sampler_bindings;
  /**
   * The maximum total value of x*y*z for a given `draw_mesh_tasks` command
   */
  uint32_t max_task_workgroup_total_count;
  /**
   * The maximum value for each dimension of a `RenderPass::draw_mesh_tasks(x, y, z)` operation.
   * Defaults to 65535. Higher is "better".
   */
  uint32_t max_task_workgroups_per_dimension;
  /**
   * The maximum number of layers that can be output from a mesh shader
   */
  uint32_t max_mesh_output_layers;
  /**
   * The maximum number of views that can be used by a mesh shader
   */
  uint32_t max_mesh_multiview_count;
  /**
   * The maximum number of primitive (ex: triangles, aabbs) a BLAS is allowed to have. Requesting
   * more than 0 during device creation only makes sense if [`Features::EXPERIMENTAL_RAY_QUERY`]
   * is enabled.
   */
  uint32_t max_blas_primitive_count;
  /**
   * The maximum number of geometry descriptors a BLAS is allowed to have. Requesting
   * more than 0 during device creation only makes sense if [`Features::EXPERIMENTAL_RAY_QUERY`]
   * is enabled.
   */
  uint32_t max_blas_geometry_count;
  /**
   * The maximum number of instances a TLAS is allowed to have. Requesting more than 0 during
   * device creation only makes sense if [`Features::EXPERIMENTAL_RAY_QUERY`]
   * is enabled.
   */
  uint32_t max_tlas_instance_count;
  /**
   * The maximum number of acceleration structures allowed to be used in a shader stage.
   * Requesting more than 0 during device creation only makes sense if [`Features::EXPERIMENTAL_RAY_QUERY`]
   * is enabled.
   */
  uint32_t max_acceleration_structures_per_shader_stage;
};

struct WGPUDeviceQueueId {
  WGPUDeviceId device;
  WGPUQueueId queue;
};

struct WGPUFfiDeviceDescriptor {
  const nsACString *label;
  WGPUFeaturesWebGPU required_features;
  struct WGPULimits required_limits;
};

struct WGPUAdapterInformation {
  WGPUAdapterId id;
  struct WGPULimits limits;
  WGPUFeaturesWebGPU features;
  nsString name;
  uint32_t vendor;
  uint32_t device;
  WGPUDeviceType device_type;
  nsString driver;
  nsString driver_info;
  WGPUBackend backend;
  bool support_use_shared_texture_in_swap_chain;
};

/**
 * The raw underlying representation of an identifier.
 */
typedef uint64_t WGPURawId;

struct WGPUFfiShaderModuleCompilationMessage {
  uint64_t line_number;
  uint64_t line_pos;
  uint64_t utf16_offset;
  uint64_t utf16_length;
  nsString message;
};

/**
 * An equivalent of `&[T]` for ffi structures and function parameters.
 */
struct WGPUFfiSlice_FfiShaderModuleCompilationMessage {
  const struct WGPUFfiShaderModuleCompilationMessage *data;
  uintptr_t length;
};

typedef int8_t WGPUSurfaceFormat;

/**
 * An equivalent of `&[T]` for ffi structures and function parameters.
 */
struct WGPUFfiSlice_BufferId {
  const WGPUBufferId *data;
  uintptr_t length;
};

typedef uint64_t WGPURemoteTextureOwnerId;

typedef uint64_t WGPURemoteTextureId;

typedef uint32_t WGPURemoteTextureTxnType;

typedef uint64_t WGPURemoteTextureTxnId;

/**
 * An equivalent of `&[T]` for ffi structures and function parameters.
 */
struct WGPUFfiSlice_CommandBufferId {
  const WGPUCommandBufferId *data;
  uintptr_t length;
};

/**
 * An equivalent of `&[T]` for ffi structures and function parameters.
 */
struct WGPUFfiSlice_TextureId {
  const WGPUTextureId *data;
  uintptr_t length;
};

/**
 * An identifier for a wgpu object.
 *
 * An `Id<T>` value identifies a value stored in a [`Global`]'s [`Hub`].
 *
 * ## Note on `Id` typing
 *
 * You might assume that an `Id<T>` can only be used to retrieve a resource of
 * type `T`, but that is not quite the case. The id types in `wgpu-core`'s
 * public API ([`TextureId`], for example) can refer to resources belonging to
 * any backend, but the corresponding resource types ([`Texture<A>`], for
 * example) are always parameterized by a specific backend `A`.
 *
 * So the `T` in `Id<T>` is usually a resource type like `Texture<Noop>`,
 * where [`Noop`] is the `wgpu_hal` dummy back end. These empty types are
 * never actually used, beyond just making sure you access each `Storage` with
 * the right kind of identifier. The members of [`Hub<A>`] pair up each
 * `X<Noop>` type with the resource type `X<A>`, for some specific backend
 * `A`.
 *
 * [`Global`]: crate::global::Global
 * [`Hub`]: crate::hub::Hub
 * [`Hub<A>`]: crate::hub::Hub
 * [`Texture<A>`]: crate::resource::Texture
 * [`Registry`]: crate::registry::Registry
 * [`Noop`]: hal::api::Noop
 */
typedef WGPURawId WGPUId_ExternalTextureSource;

typedef WGPUId_ExternalTextureSource WGPUExternalTextureSourceId;

/**
 * An equivalent of `&[T]` for ffi structures and function parameters.
 */
struct WGPUFfiSlice_ExternalTextureSourceId {
  const WGPUExternalTextureSourceId *data;
  uintptr_t length;
};

/**
 * Integral type used for [`Buffer`] offsets and sizes.
 *
 * [`Buffer`]: ../wgpu/struct.Buffer.html
 */
typedef uint64_t WGPUBufferAddress;

/**
 * Different ways that you can use a buffer.
 *
 * The usages determine what kind of memory the buffer is allocated from and what
 * actions the buffer can partake in.
 *
 * Specifying only usages the application will actually perform may increase performance.
 * Additionally, on the WebGL backend, there are restrictions on [`BufferUsages::INDEX`];
 * see [`DownlevelFlags::UNRESTRICTED_INDEX_BUFFER`] for more information.
 *
 * Corresponds to [WebGPU `GPUBufferUsageFlags`](
 * https://gpuweb.github.io/gpuweb/#typedefdef-gpubufferusageflags).
 */
typedef uint32_t WGPUBufferUsages;
/**
 * Allow a buffer to be mapped for reading using [`Buffer::map_async`] + [`Buffer::get_mapped_range`].
 * This does not include creating a buffer with [`BufferDescriptor::mapped_at_creation`] set.
 *
 * If [`Features::MAPPABLE_PRIMARY_BUFFERS`] isn't enabled, the only other usage a buffer
 * may have is COPY_DST.
 */
#define WGPUBufferUsages_MAP_READ (uint32_t)(1 << 0)
/**
 * Allow a buffer to be mapped for writing using [`Buffer::map_async`] + [`Buffer::get_mapped_range_mut`].
 * This does not include creating a buffer with [`BufferDescriptor::mapped_at_creation`] set.
 *
 * If [`Features::MAPPABLE_PRIMARY_BUFFERS`] feature isn't enabled, the only other usage a buffer
 * may have is COPY_SRC.
 */
#define WGPUBufferUsages_MAP_WRITE (uint32_t)(1 << 1)
/**
 * Allow a buffer to be the source buffer for a [`CommandEncoder::copy_buffer_to_buffer`] or [`CommandEncoder::copy_buffer_to_texture`]
 * operation.
 */
#define WGPUBufferUsages_COPY_SRC (uint32_t)(1 << 2)
/**
 * Allow a buffer to be the destination buffer for a [`CommandEncoder::copy_buffer_to_buffer`], [`CommandEncoder::copy_texture_to_buffer`],
 * [`CommandEncoder::clear_buffer`] or [`Queue::write_buffer`] operation.
 */
#define WGPUBufferUsages_COPY_DST (uint32_t)(1 << 3)
/**
 * Allow a buffer to be the index buffer in a draw operation.
 */
#define WGPUBufferUsages_INDEX (uint32_t)(1 << 4)
/**
 * Allow a buffer to be the vertex buffer in a draw operation.
 */
#define WGPUBufferUsages_VERTEX (uint32_t)(1 << 5)
/**
 * Allow a buffer to be a [`BufferBindingType::Uniform`] inside a bind group.
 */
#define WGPUBufferUsages_UNIFORM (uint32_t)(1 << 6)
/**
 * Allow a buffer to be a [`BufferBindingType::Storage`] inside a bind group.
 */
#define WGPUBufferUsages_STORAGE (uint32_t)(1 << 7)
/**
 * Allow a buffer to be the indirect buffer in an indirect draw call.
 */
#define WGPUBufferUsages_INDIRECT (uint32_t)(1 << 8)
/**
 * Allow a buffer to be the destination buffer for a [`CommandEncoder::resolve_query_set`] operation.
 */
#define WGPUBufferUsages_QUERY_RESOLVE (uint32_t)(1 << 9)
/**
 * Allows a buffer to be used as input for a bottom level acceleration structure build
 */
#define WGPUBufferUsages_BLAS_INPUT (uint32_t)(1 << 10)
/**
 * Allows a buffer to be used as input for a top level acceleration structure build
 */
#define WGPUBufferUsages_TLAS_INPUT (uint32_t)(1 << 11)

/**
 * Describes a [`Buffer`](../wgpu/struct.Buffer.html).
 *
 * Corresponds to [WebGPU `GPUBufferDescriptor`](
 * https://gpuweb.github.io/gpuweb/#dictdef-gpubufferdescriptor).
 */
struct WGPUBufferDescriptor {
  /**
   * Debug label of a buffer. This will show up in graphics debuggers for easy identification.
   */
  const nsACString *label;
  /**
   * Size of a buffer, in bytes.
   */
  WGPUBufferAddress size;
  /**
   * Usages of a buffer. If the buffer is used in any way that isn't specified here, the operation
   * will panic.
   *
   * Specifying only usages the application will actually perform may increase performance.
   * Additionally, on the WebGL backend, there are restrictions on [`BufferUsages::INDEX`];
   * see [`DownlevelFlags::UNRESTRICTED_INDEX_BUFFER`] for more information.
   */
  WGPUBufferUsages usage;
  /**
   * Allows a buffer to be mapped immediately after they are made. It does not have to be [`BufferUsages::MAP_READ`] or
   * [`BufferUsages::MAP_WRITE`], all buffers are allowed to be mapped at creation.
   *
   * If this is `true`, [`size`](#structfield.size) must be a multiple of
   * [`COPY_BUFFER_ALIGNMENT`].
   */
  bool mapped_at_creation;
};

/**
 * Extent of a texture related operation.
 *
 * Corresponds to [WebGPU `GPUExtent3D`](
 * https://gpuweb.github.io/gpuweb/#dictdef-gpuextent3ddict).
 */
struct WGPUExtent3d {
  /**
   * Width of the extent
   */
  uint32_t width;
  /**
   * Height of the extent
   */
  uint32_t height;
  /**
   * The depth of the extent or the number of array layers
   */
  uint32_t depth_or_array_layers;
};

/**
 * Format in which a texture’s texels are stored in GPU memory.
 *
 * Certain formats additionally specify a conversion.
 * When these formats are used in a shader, the conversion automatically takes place when loading
 * from or storing to the texture.
 *
 * * `Unorm` formats linearly scale the integer range of the storage format to a floating-point
 *   range of 0 to 1, inclusive.
 * * `Snorm` formats linearly scale the integer range of the storage format to a floating-point
 *   range of &minus;1 to 1, inclusive, except that the most negative value
 *   (&minus;128 for 8-bit, &minus;32768 for 16-bit) is excluded; on conversion,
 *   it is treated as identical to the second most negative
 *   (&minus;127 for 8-bit, &minus;32767 for 16-bit),
 *   so that the positive and negative ranges are symmetric.
 * * `UnormSrgb` formats apply the [sRGB transfer function] so that the storage is sRGB encoded
 *   while the shader works with linear intensity values.
 * * `Uint`, `Sint`, and `Float` formats perform no conversion.
 *
 * Corresponds to [WebGPU `GPUTextureFormat`](
 * https://gpuweb.github.io/gpuweb/#enumdef-gputextureformat).
 *
 * [sRGB transfer function]: https://en.wikipedia.org/wiki/SRGB#Transfer_function_(%22gamma%22)
 */
enum WGPUTextureFormat_Tag {
  /**
   * Red channel only. 8 bit integer per channel. [0, 255] converted to/from float [0, 1] in shader.
   */
  WGPUTextureFormat_R8Unorm,
  /**
   * Red channel only. 8 bit integer per channel. [&minus;127, 127] converted to/from float [&minus;1, 1] in shader.
   */
  WGPUTextureFormat_R8Snorm,
  /**
   * Red channel only. 8 bit integer per channel. Unsigned in shader.
   */
  WGPUTextureFormat_R8Uint,
  /**
   * Red channel only. 8 bit integer per channel. Signed in shader.
   */
  WGPUTextureFormat_R8Sint,
  /**
   * Red channel only. 16 bit integer per channel. Unsigned in shader.
   */
  WGPUTextureFormat_R16Uint,
  /**
   * Red channel only. 16 bit integer per channel. Signed in shader.
   */
  WGPUTextureFormat_R16Sint,
  /**
   * Red channel only. 16 bit integer per channel. [0, 65535] converted to/from float [0, 1] in shader.
   *
   * [`Features::TEXTURE_FORMAT_16BIT_NORM`] must be enabled to use this texture format.
   */
  WGPUTextureFormat_R16Unorm,
  /**
   * Red channel only. 16 bit integer per channel. [&minus;32767, 32767] converted to/from float [&minus;1, 1] in shader.
   *
   * [`Features::TEXTURE_FORMAT_16BIT_NORM`] must be enabled to use this texture format.
   */
  WGPUTextureFormat_R16Snorm,
  /**
   * Red channel only. 16 bit float per channel. Float in shader.
   */
  WGPUTextureFormat_R16Float,
  /**
   * Red and green channels. 8 bit integer per channel. [0, 255] converted to/from float [0, 1] in shader.
   */
  WGPUTextureFormat_Rg8Unorm,
  /**
   * Red and green channels. 8 bit integer per channel. [&minus;127, 127] converted to/from float [&minus;1, 1] in shader.
   */
  WGPUTextureFormat_Rg8Snorm,
  /**
   * Red and green channels. 8 bit integer per channel. Unsigned in shader.
   */
  WGPUTextureFormat_Rg8Uint,
  /**
   * Red and green channels. 8 bit integer per channel. Signed in shader.
   */
  WGPUTextureFormat_Rg8Sint,
  /**
   * Red channel only. 32 bit integer per channel. Unsigned in shader.
   */
  WGPUTextureFormat_R32Uint,
  /**
   * Red channel only. 32 bit integer per channel. Signed in shader.
   */
  WGPUTextureFormat_R32Sint,
  /**
   * Red channel only. 32 bit float per channel. Float in shader.
   */
  WGPUTextureFormat_R32Float,
  /**
   * Red and green channels. 16 bit integer per channel. Unsigned in shader.
   */
  WGPUTextureFormat_Rg16Uint,
  /**
   * Red and green channels. 16 bit integer per channel. Signed in shader.
   */
  WGPUTextureFormat_Rg16Sint,
  /**
   * Red and green channels. 16 bit integer per channel. [0, 65535] converted to/from float [0, 1] in shader.
   *
   * [`Features::TEXTURE_FORMAT_16BIT_NORM`] must be enabled to use this texture format.
   */
  WGPUTextureFormat_Rg16Unorm,
  /**
   * Red and green channels. 16 bit integer per channel. [&minus;32767, 32767] converted to/from float [&minus;1, 1] in shader.
   *
   * [`Features::TEXTURE_FORMAT_16BIT_NORM`] must be enabled to use this texture format.
   */
  WGPUTextureFormat_Rg16Snorm,
  /**
   * Red and green channels. 16 bit float per channel. Float in shader.
   */
  WGPUTextureFormat_Rg16Float,
  /**
   * Red, green, blue, and alpha channels. 8 bit integer per channel. [0, 255] converted to/from float [0, 1] in shader.
   */
  WGPUTextureFormat_Rgba8Unorm,
  /**
   * Red, green, blue, and alpha channels. 8 bit integer per channel. Srgb-color [0, 255] converted to/from linear-color float [0, 1] in shader.
   */
  WGPUTextureFormat_Rgba8UnormSrgb,
  /**
   * Red, green, blue, and alpha channels. 8 bit integer per channel. [&minus;127, 127] converted to/from float [&minus;1, 1] in shader.
   */
  WGPUTextureFormat_Rgba8Snorm,
  /**
   * Red, green, blue, and alpha channels. 8 bit integer per channel. Unsigned in shader.
   */
  WGPUTextureFormat_Rgba8Uint,
  /**
   * Red, green, blue, and alpha channels. 8 bit integer per channel. Signed in shader.
   */
  WGPUTextureFormat_Rgba8Sint,
  /**
   * Blue, green, red, and alpha channels. 8 bit integer per channel. [0, 255] converted to/from float [0, 1] in shader.
   */
  WGPUTextureFormat_Bgra8Unorm,
  /**
   * Blue, green, red, and alpha channels. 8 bit integer per channel. Srgb-color [0, 255] converted to/from linear-color float [0, 1] in shader.
   */
  WGPUTextureFormat_Bgra8UnormSrgb,
  /**
   * Packed unsigned float with 9 bits mantisa for each RGB component, then a common 5 bits exponent
   */
  WGPUTextureFormat_Rgb9e5Ufloat,
  /**
   * Red, green, blue, and alpha channels. 10 bit integer for RGB channels, 2 bit integer for alpha channel. Unsigned in shader.
   */
  WGPUTextureFormat_Rgb10a2Uint,
  /**
   * Red, green, blue, and alpha channels. 10 bit integer for RGB channels, 2 bit integer for alpha channel. [0, 1023] ([0, 3] for alpha) converted to/from float [0, 1] in shader.
   */
  WGPUTextureFormat_Rgb10a2Unorm,
  /**
   * Red, green, and blue channels. 11 bit float with no sign bit for RG channels. 10 bit float with no sign bit for blue channel. Float in shader.
   */
  WGPUTextureFormat_Rg11b10Ufloat,
  /**
   * Red channel only. 64 bit integer per channel. Unsigned in shader.
   *
   * [`Features::TEXTURE_INT64_ATOMIC`] must be enabled to use this texture format.
   */
  WGPUTextureFormat_R64Uint,
  /**
   * Red and green channels. 32 bit integer per channel. Unsigned in shader.
   */
  WGPUTextureFormat_Rg32Uint,
  /**
   * Red and green channels. 32 bit integer per channel. Signed in shader.
   */
  WGPUTextureFormat_Rg32Sint,
  /**
   * Red and green channels. 32 bit float per channel. Float in shader.
   */
  WGPUTextureFormat_Rg32Float,
  /**
   * Red, green, blue, and alpha channels. 16 bit integer per channel. Unsigned in shader.
   */
  WGPUTextureFormat_Rgba16Uint,
  /**
   * Red, green, blue, and alpha channels. 16 bit integer per channel. Signed in shader.
   */
  WGPUTextureFormat_Rgba16Sint,
  /**
   * Red, green, blue, and alpha channels. 16 bit integer per channel. [0, 65535] converted to/from float [0, 1] in shader.
   *
   * [`Features::TEXTURE_FORMAT_16BIT_NORM`] must be enabled to use this texture format.
   */
  WGPUTextureFormat_Rgba16Unorm,
  /**
   * Red, green, blue, and alpha. 16 bit integer per channel. [&minus;32767, 32767] converted to/from float [&minus;1, 1] in shader.
   *
   * [`Features::TEXTURE_FORMAT_16BIT_NORM`] must be enabled to use this texture format.
   */
  WGPUTextureFormat_Rgba16Snorm,
  /**
   * Red, green, blue, and alpha channels. 16 bit float per channel. Float in shader.
   */
  WGPUTextureFormat_Rgba16Float,
  /**
   * Red, green, blue, and alpha channels. 32 bit integer per channel. Unsigned in shader.
   */
  WGPUTextureFormat_Rgba32Uint,
  /**
   * Red, green, blue, and alpha channels. 32 bit integer per channel. Signed in shader.
   */
  WGPUTextureFormat_Rgba32Sint,
  /**
   * Red, green, blue, and alpha channels. 32 bit float per channel. Float in shader.
   */
  WGPUTextureFormat_Rgba32Float,
  /**
   * Stencil format with 8 bit integer stencil.
   */
  WGPUTextureFormat_Stencil8,
  /**
   * Special depth format with 16 bit integer depth.
   */
  WGPUTextureFormat_Depth16Unorm,
  /**
   * Special depth format with at least 24 bit integer depth.
   */
  WGPUTextureFormat_Depth24Plus,
  /**
   * Special depth/stencil format with at least 24 bit integer depth and 8 bits integer stencil.
   */
  WGPUTextureFormat_Depth24PlusStencil8,
  /**
   * Special depth format with 32 bit floating point depth.
   */
  WGPUTextureFormat_Depth32Float,
  /**
   * Special depth/stencil format with 32 bit floating point depth and 8 bits integer stencil.
   *
   * [`Features::DEPTH32FLOAT_STENCIL8`] must be enabled to use this texture format.
   */
  WGPUTextureFormat_Depth32FloatStencil8,
  /**
   * YUV 4:2:0 chroma subsampled format.
   *
   * Contains two planes:
   * - 0: Single 8 bit channel luminance.
   * - 1: Dual 8 bit channel chrominance at half width and half height.
   *
   * Valid view formats for luminance are [`TextureFormat::R8Unorm`].
   *
   * Valid view formats for chrominance are [`TextureFormat::Rg8Unorm`].
   *
   * Width and height must be even.
   *
   * [`Features::TEXTURE_FORMAT_NV12`] must be enabled to use this texture format.
   */
  WGPUTextureFormat_NV12,
  /**
   * YUV 4:2:0 chroma subsampled format.
   *
   * Contains two planes:
   * - 0: Single 16 bit channel luminance, of which only the high 10 bits
   *   are used.
   * - 1: Dual 16 bit channel chrominance at half width and half height, of
   *   which only the high 10 bits are used.
   *
   * Valid view formats for luminance are [`TextureFormat::R16Unorm`].
   *
   * Valid view formats for chrominance are [`TextureFormat::Rg16Unorm`].
   *
   * Width and height must be even.
   *
   * [`Features::TEXTURE_FORMAT_P010`] must be enabled to use this texture format.
   */
  WGPUTextureFormat_P010,
  /**
   * 4x4 block compressed texture. 8 bytes per block (4 bit/px). 4 color + alpha pallet. 5 bit R + 6 bit G + 5 bit B + 1 bit alpha.
   * [0, 63] ([0, 1] for alpha) converted to/from float [0, 1] in shader.
   *
   * Also known as DXT1.
   *
   * [`Features::TEXTURE_COMPRESSION_BC`] must be enabled to use this texture format.
   * [`Features::TEXTURE_COMPRESSION_BC_SLICED_3D`] must be enabled to use this texture format with 3D dimension.
   */
  WGPUTextureFormat_Bc1RgbaUnorm,
  /**
   * 4x4 block compressed texture. 8 bytes per block (4 bit/px). 4 color + alpha pallet. 5 bit R + 6 bit G + 5 bit B + 1 bit alpha.
   * Srgb-color [0, 63] ([0, 1] for alpha) converted to/from linear-color float [0, 1] in shader.
   *
   * Also known as DXT1.
   *
   * [`Features::TEXTURE_COMPRESSION_BC`] must be enabled to use this texture format.
   * [`Features::TEXTURE_COMPRESSION_BC_SLICED_3D`] must be enabled to use this texture format with 3D dimension.
   */
  WGPUTextureFormat_Bc1RgbaUnormSrgb,
  /**
   * 4x4 block compressed texture. 16 bytes per block (8 bit/px). 4 color pallet. 5 bit R + 6 bit G + 5 bit B + 4 bit alpha.
   * [0, 63] ([0, 15] for alpha) converted to/from float [0, 1] in shader.
   *
   * Also known as DXT3.
   *
   * [`Features::TEXTURE_COMPRESSION_BC`] must be enabled to use this texture format.
   * [`Features::TEXTURE_COMPRESSION_BC_SLICED_3D`] must be enabled to use this texture format with 3D dimension.
   */
  WGPUTextureFormat_Bc2RgbaUnorm,
  /**
   * 4x4 block compressed texture. 16 bytes per block (8 bit/px). 4 color pallet. 5 bit R + 6 bit G + 5 bit B + 4 bit alpha.
   * Srgb-color [0, 63] ([0, 255] for alpha) converted to/from linear-color float [0, 1] in shader.
   *
   * Also known as DXT3.
   *
   * [`Features::TEXTURE_COMPRESSION_BC`] must be enabled to use this texture format.
   * [`Features::TEXTURE_COMPRESSION_BC_SLICED_3D`] must be enabled to use this texture format with 3D dimension.
   */
  WGPUTextureFormat_Bc2RgbaUnormSrgb,
  /**
   * 4x4 block compressed texture. 16 bytes per block (8 bit/px). 4 color pallet + 8 alpha pallet. 5 bit R + 6 bit G + 5 bit B + 8 bit alpha.
   * [0, 63] ([0, 255] for alpha) converted to/from float [0, 1] in shader.
   *
   * Also known as DXT5.
   *
   * [`Features::TEXTURE_COMPRESSION_BC`] must be enabled to use this texture format.
   * [`Features::TEXTURE_COMPRESSION_BC_SLICED_3D`] must be enabled to use this texture format with 3D dimension.
   */
  WGPUTextureFormat_Bc3RgbaUnorm,
  /**
   * 4x4 block compressed texture. 16 bytes per block (8 bit/px). 4 color pallet + 8 alpha pallet. 5 bit R + 6 bit G + 5 bit B + 8 bit alpha.
   * Srgb-color [0, 63] ([0, 255] for alpha) converted to/from linear-color float [0, 1] in shader.
   *
   * Also known as DXT5.
   *
   * [`Features::TEXTURE_COMPRESSION_BC`] must be enabled to use this texture format.
   * [`Features::TEXTURE_COMPRESSION_BC_SLICED_3D`] must be enabled to use this texture format with 3D dimension.
   */
  WGPUTextureFormat_Bc3RgbaUnormSrgb,
  /**
   * 4x4 block compressed texture. 8 bytes per block (4 bit/px). 8 color pallet. 8 bit R.
   * [0, 255] converted to/from float [0, 1] in shader.
   *
   * Also known as RGTC1.
   *
   * [`Features::TEXTURE_COMPRESSION_BC`] must be enabled to use this texture format.
   * [`Features::TEXTURE_COMPRESSION_BC_SLICED_3D`] must be enabled to use this texture format with 3D dimension.
   */
  WGPUTextureFormat_Bc4RUnorm,
  /**
   * 4x4 block compressed texture. 8 bytes per block (4 bit/px). 8 color pallet. 8 bit R.
   * [&minus;127, 127] converted to/from float [&minus;1, 1] in shader.
   *
   * Also known as RGTC1.
   *
   * [`Features::TEXTURE_COMPRESSION_BC`] must be enabled to use this texture format.
   * [`Features::TEXTURE_COMPRESSION_BC_SLICED_3D`] must be enabled to use this texture format with 3D dimension.
   */
  WGPUTextureFormat_Bc4RSnorm,
  /**
   * 4x4 block compressed texture. 16 bytes per block (8 bit/px). 8 color red pallet + 8 color green pallet. 8 bit RG.
   * [0, 255] converted to/from float [0, 1] in shader.
   *
   * Also known as RGTC2.
   *
   * [`Features::TEXTURE_COMPRESSION_BC`] must be enabled to use this texture format.
   * [`Features::TEXTURE_COMPRESSION_BC_SLICED_3D`] must be enabled to use this texture format with 3D dimension.
   */
  WGPUTextureFormat_Bc5RgUnorm,
  /**
   * 4x4 block compressed texture. 16 bytes per block (8 bit/px). 8 color red pallet + 8 color green pallet. 8 bit RG.
   * [&minus;127, 127] converted to/from float [&minus;1, 1] in shader.
   *
   * Also known as RGTC2.
   *
   * [`Features::TEXTURE_COMPRESSION_BC`] must be enabled to use this texture format.
   * [`Features::TEXTURE_COMPRESSION_BC_SLICED_3D`] must be enabled to use this texture format with 3D dimension.
   */
  WGPUTextureFormat_Bc5RgSnorm,
  /**
   * 4x4 block compressed texture. 16 bytes per block (8 bit/px). Variable sized pallet. 16 bit unsigned float RGB. Float in shader.
   *
   * Also known as BPTC (float).
   *
   * [`Features::TEXTURE_COMPRESSION_BC`] must be enabled to use this texture format.
   * [`Features::TEXTURE_COMPRESSION_BC_SLICED_3D`] must be enabled to use this texture format with 3D dimension.
   */
  WGPUTextureFormat_Bc6hRgbUfloat,
  /**
   * 4x4 block compressed texture. 16 bytes per block (8 bit/px). Variable sized pallet. 16 bit signed float RGB. Float in shader.
   *
   * Also known as BPTC (float).
   *
   * [`Features::TEXTURE_COMPRESSION_BC`] must be enabled to use this texture format.
   * [`Features::TEXTURE_COMPRESSION_BC_SLICED_3D`] must be enabled to use this texture format with 3D dimension.
   */
  WGPUTextureFormat_Bc6hRgbFloat,
  /**
   * 4x4 block compressed texture. 16 bytes per block (8 bit/px). Variable sized pallet. 8 bit integer RGBA.
   * [0, 255] converted to/from float [0, 1] in shader.
   *
   * Also known as BPTC (unorm).
   *
   * [`Features::TEXTURE_COMPRESSION_BC`] must be enabled to use this texture format.
   * [`Features::TEXTURE_COMPRESSION_BC_SLICED_3D`] must be enabled to use this texture format with 3D dimension.
   */
  WGPUTextureFormat_Bc7RgbaUnorm,
  /**
   * 4x4 block compressed texture. 16 bytes per block (8 bit/px). Variable sized pallet. 8 bit integer RGBA.
   * Srgb-color [0, 255] converted to/from linear-color float [0, 1] in shader.
   *
   * Also known as BPTC (unorm).
   *
   * [`Features::TEXTURE_COMPRESSION_BC`] must be enabled to use this texture format.
   * [`Features::TEXTURE_COMPRESSION_BC_SLICED_3D`] must be enabled to use this texture format with 3D dimension.
   */
  WGPUTextureFormat_Bc7RgbaUnormSrgb,
  /**
   * 4x4 block compressed texture. 8 bytes per block (4 bit/px). Complex pallet. 8 bit integer RGB.
   * [0, 255] converted to/from float [0, 1] in shader.
   *
   * [`Features::TEXTURE_COMPRESSION_ETC2`] must be enabled to use this texture format.
   */
  WGPUTextureFormat_Etc2Rgb8Unorm,
  /**
   * 4x4 block compressed texture. 8 bytes per block (4 bit/px). Complex pallet. 8 bit integer RGB.
   * Srgb-color [0, 255] converted to/from linear-color float [0, 1] in shader.
   *
   * [`Features::TEXTURE_COMPRESSION_ETC2`] must be enabled to use this texture format.
   */
  WGPUTextureFormat_Etc2Rgb8UnormSrgb,
  /**
   * 4x4 block compressed texture. 8 bytes per block (4 bit/px). Complex pallet. 8 bit integer RGB + 1 bit alpha.
   * [0, 255] ([0, 1] for alpha) converted to/from float [0, 1] in shader.
   *
   * [`Features::TEXTURE_COMPRESSION_ETC2`] must be enabled to use this texture format.
   */
  WGPUTextureFormat_Etc2Rgb8A1Unorm,
  /**
   * 4x4 block compressed texture. 8 bytes per block (4 bit/px). Complex pallet. 8 bit integer RGB + 1 bit alpha.
   * Srgb-color [0, 255] ([0, 1] for alpha) converted to/from linear-color float [0, 1] in shader.
   *
   * [`Features::TEXTURE_COMPRESSION_ETC2`] must be enabled to use this texture format.
   */
  WGPUTextureFormat_Etc2Rgb8A1UnormSrgb,
  /**
   * 4x4 block compressed texture. 16 bytes per block (8 bit/px). Complex pallet. 8 bit integer RGB + 8 bit alpha.
   * [0, 255] converted to/from float [0, 1] in shader.
   *
   * [`Features::TEXTURE_COMPRESSION_ETC2`] must be enabled to use this texture format.
   */
  WGPUTextureFormat_Etc2Rgba8Unorm,
  /**
   * 4x4 block compressed texture. 16 bytes per block (8 bit/px). Complex pallet. 8 bit integer RGB + 8 bit alpha.
   * Srgb-color [0, 255] converted to/from linear-color float [0, 1] in shader.
   *
   * [`Features::TEXTURE_COMPRESSION_ETC2`] must be enabled to use this texture format.
   */
  WGPUTextureFormat_Etc2Rgba8UnormSrgb,
  /**
   * 4x4 block compressed texture. 8 bytes per block (4 bit/px). Complex pallet. 11 bit integer R.
   * [0, 255] converted to/from float [0, 1] in shader.
   *
   * [`Features::TEXTURE_COMPRESSION_ETC2`] must be enabled to use this texture format.
   */
  WGPUTextureFormat_EacR11Unorm,
  /**
   * 4x4 block compressed texture. 8 bytes per block (4 bit/px). Complex pallet. 11 bit integer R.
   * [&minus;127, 127] converted to/from float [&minus;1, 1] in shader.
   *
   * [`Features::TEXTURE_COMPRESSION_ETC2`] must be enabled to use this texture format.
   */
  WGPUTextureFormat_EacR11Snorm,
  /**
   * 4x4 block compressed texture. 16 bytes per block (8 bit/px). Complex pallet. 11 bit integer R + 11 bit integer G.
   * [0, 255] converted to/from float [0, 1] in shader.
   *
   * [`Features::TEXTURE_COMPRESSION_ETC2`] must be enabled to use this texture format.
   */
  WGPUTextureFormat_EacRg11Unorm,
  /**
   * 4x4 block compressed texture. 16 bytes per block (8 bit/px). Complex pallet. 11 bit integer R + 11 bit integer G.
   * [&minus;127, 127] converted to/from float [&minus;1, 1] in shader.
   *
   * [`Features::TEXTURE_COMPRESSION_ETC2`] must be enabled to use this texture format.
   */
  WGPUTextureFormat_EacRg11Snorm,
  /**
   * block compressed texture. 16 bytes per block.
   *
   * Features [`TEXTURE_COMPRESSION_ASTC`] or [`TEXTURE_COMPRESSION_ASTC_HDR`]
   * must be enabled to use this texture format.
   *
   * [`TEXTURE_COMPRESSION_ASTC`]: Features::TEXTURE_COMPRESSION_ASTC
   * [`TEXTURE_COMPRESSION_ASTC_HDR`]: Features::TEXTURE_COMPRESSION_ASTC_HDR
   */
  WGPUTextureFormat_Astc,
  /**
   * Must be last for serialization purposes
   */
  WGPUTextureFormat_Sentinel,
};

struct WGPUTextureFormat_WGPUAstc_Body {
  /**
   * compressed block dimensions
   */
  enum WGPUAstcBlock block;
  /**
   * ASTC RGBA channel
   */
  enum WGPUAstcChannel channel;
};

struct WGPUTextureFormat {
  enum WGPUTextureFormat_Tag tag;
  union {
    struct WGPUTextureFormat_WGPUAstc_Body astc;
  };
};

/**
 * Different ways that you can use a texture.
 *
 * The usages determine what kind of memory the texture is allocated from and what
 * actions the texture can partake in.
 *
 * Corresponds to [WebGPU `GPUTextureUsageFlags`](
 * https://gpuweb.github.io/gpuweb/#typedefdef-gputextureusageflags).
 */
typedef uint32_t WGPUTextureUsages;
/**
 * Allows a texture to be the source in a [`CommandEncoder::copy_texture_to_buffer`] or
 * [`CommandEncoder::copy_texture_to_texture`] operation.
 */
#define WGPUTextureUsages_COPY_SRC (uint32_t)(1 << 0)
/**
 * Allows a texture to be the destination in a  [`CommandEncoder::copy_buffer_to_texture`],
 * [`CommandEncoder::copy_texture_to_texture`], or [`Queue::write_texture`] operation.
 */
#define WGPUTextureUsages_COPY_DST (uint32_t)(1 << 1)
/**
 * Allows a texture to be a [`BindingType::Texture`] in a bind group.
 */
#define WGPUTextureUsages_TEXTURE_BINDING (uint32_t)(1 << 2)
/**
 * Allows a texture to be a [`BindingType::StorageTexture`] in a bind group.
 */
#define WGPUTextureUsages_STORAGE_BINDING (uint32_t)(1 << 3)
/**
 * Allows a texture to be an output attachment of a render pass.
 */
#define WGPUTextureUsages_RENDER_ATTACHMENT (uint32_t)(1 << 4)
/**
 * Allows a texture to be used with image atomics. Requires [`Features::TEXTURE_ATOMIC`].
 */
#define WGPUTextureUsages_STORAGE_ATOMIC (uint32_t)(1 << 16)

/**
 * An equivalent of `&[T]` for ffi structures and function parameters.
 */
struct WGPUFfiSlice_TextureFormat {
  const struct WGPUTextureFormat *data;
  uintptr_t length;
};

/**
 * Describes a [`Texture`](../wgpu/struct.Texture.html).
 *
 * Corresponds to [WebGPU `GPUTextureDescriptor`](
 * https://gpuweb.github.io/gpuweb/#dictdef-gputexturedescriptor).
 */
struct WGPUTextureDescriptor {
  /**
   * Debug label of the texture. This will show up in graphics debuggers for easy identification.
   */
  const nsACString *label;
  /**
   * Size of the texture. All components must be greater than zero. For a
   * regular 1D/2D texture, the unused sizes will be 1. For 2DArray textures,
   * Z is the number of 2D textures in that array.
   */
  struct WGPUExtent3d size;
  /**
   * Mip count of texture. For a texture with no extra mips, this must be 1.
   */
  uint32_t mip_level_count;
  /**
   * Sample count of texture. If this is not 1, texture must have [`BindingType::Texture::multisampled`] set to true.
   */
  uint32_t sample_count;
  /**
   * Dimensions of the texture.
   */
  enum WGPUTextureDimension dimension;
  /**
   * Format of the texture.
   */
  struct WGPUTextureFormat format;
  /**
   * Allowed usages of the texture. If used in other ways, the operation will panic.
   */
  WGPUTextureUsages usage;
  /**
   * Specifies what view formats will be allowed when calling `Texture::create_view` on this texture.
   *
   * View formats of the same format as the texture are always allowed.
   *
   * Note: currently, only the srgb-ness is allowed to change. (ex: `Rgba8Unorm` texture + `Rgba8UnormSrgb` view)
   */
  struct WGPUFfiSlice_TextureFormat view_formats;
};

struct WGPUSwapChainId {
  uint64_t _0;
};

struct WGPUTextureViewDescriptor {
  const nsACString *label;
  const struct WGPUTextureFormat *format;
  const enum WGPUTextureViewDimension *dimension;
  enum WGPUTextureAspect aspect;
  uint32_t base_mip_level;
  const uint32_t *mip_level_count;
  uint32_t base_array_layer;
  const uint32_t *array_layer_count;
};

struct WGPUExternalTextureDescriptor {
  const nsACString *label;
  WGPUOption_ExternalTextureSourceId source;
  enum WGPUPredefinedColorSpace color_space;
};

struct WGPUSamplerDescriptor {
  const nsACString *label;
  enum WGPUAddressMode address_modes[3];
  enum WGPUFilterMode mag_filter;
  enum WGPUFilterMode min_filter;
  enum WGPUFilterMode mipmap_filter;
  float lod_min_clamp;
  float lod_max_clamp;
  const enum WGPUCompareFunction *compare;
  uint16_t max_anisotropy;
};

/**
 * Describes a [`CommandEncoder`](../wgpu/struct.CommandEncoder.html).
 *
 * Corresponds to [WebGPU `GPUCommandEncoderDescriptor`](
 * https://gpuweb.github.io/gpuweb/#dictdef-gpucommandencoderdescriptor).
 */
struct WGPUCommandEncoderDescriptor {
  /**
   * Debug label for the command encoder. This will show up in graphics debuggers for easy identification.
   */
  const nsACString *label;
};

struct WGPURenderBundleEncoderDescriptor {
  const nsACString *label;
  struct WGPUFfiSlice_TextureFormat color_formats;
  const struct WGPUTextureFormat *depth_stencil_format;
  bool depth_read_only;
  bool stencil_read_only;
  uint32_t sample_count;
};

/**
 * Describes a [`RenderBundle`](../wgpu/struct.RenderBundle.html).
 *
 * Corresponds to [WebGPU `GPURenderBundleDescriptor`](
 * https://gpuweb.github.io/gpuweb/#dictdef-gpurenderbundledescriptor).
 */
struct WGPURenderBundleDescriptor {
  /**
   * Debug label of the render bundle encoder. This will show up in graphics debuggers for easy identification.
   */
  const nsACString *label;
};

struct WGPURawQuerySetDescriptor {
  const nsACString *label;
  enum WGPURawQueryType ty;
  uint32_t count;
};

struct WGPUPassTimestampWrites {
  WGPUQuerySetId query_set;
  const uint32_t *beginning_of_pass_write_index;
  const uint32_t *end_of_pass_write_index;
};

struct WGPUComputePassDescriptor {
  const nsACString *label;
  const struct WGPUPassTimestampWrites *timestamp_writes;
};

/**
 * FFI-friendly analogue of [`std::option::Option`].
 *
 * In some cases, Rust's standard `Option` type is FFI-friendly, in that `T` and `Option<T>` map
 * to the same C++ type. For example, both `&U` and `Option<&U>` can be represented as `U *` in
 * C++.
 *
 * For other types, `Option<T>` may not be FFI-safe. For such cases, this type is a `repr(u8)`
 * analog to the standard
 *
 * See also: <https://doc.rust-lang.org/nomicon/ffi.html#the-nullable-pointer-optimization>
 */
enum WGPUFfiOption_u32_Tag
#ifdef __cplusplus
  : uint8_t
#endif // __cplusplus
 {
  WGPUFfiOption_u32_Some_u32,
  WGPUFfiOption_u32_None_u32,
  /**
   * Must be last for serialization purposes
   */
  WGPUFfiOption_u32_Sentinel_u32,
};
#ifndef __cplusplus
typedef uint8_t WGPUFfiOption_u32_Tag;
#endif // __cplusplus

union WGPUFfiOption_u32 {
  WGPUFfiOption_u32_Tag tag;
  struct {
    WGPUFfiOption_u32_Tag some_tag;
    uint32_t some;
  };
};

/**
 * RGBA double precision color.
 *
 * This is not to be used as a generic color type, only for specific wgpu interfaces.
 */
struct WGPUColor {
  /**
   * Red component of the color
   */
  double r;
  /**
   * Green component of the color
   */
  double g;
  /**
   * Blue component of the color
   */
  double b;
  /**
   * Alpha component of the color
   */
  double a;
};
#define WGPUColor_TRANSPARENT (WGPUColor){ .r = 0.0, .g = 0.0, .b = 0.0, .a = 0.0 }
#define WGPUColor_BLACK (WGPUColor){ .r = 0.0, .g = 0.0, .b = 0.0, .a = 1.0 }
#define WGPUColor_WHITE (WGPUColor){ .r = 1.0, .g = 1.0, .b = 1.0, .a = 1.0 }
#define WGPUColor_RED (WGPUColor){ .r = 1.0, .g = 0.0, .b = 0.0, .a = 1.0 }
#define WGPUColor_GREEN (WGPUColor){ .r = 0.0, .g = 1.0, .b = 0.0, .a = 1.0 }
#define WGPUColor_BLUE (WGPUColor){ .r = 0.0, .g = 0.0, .b = 1.0, .a = 1.0 }

/**
 * Operation to perform to the output attachment at the start of a render pass.
 *
 * Corresponds to [WebGPU `GPULoadOp`](https://gpuweb.github.io/gpuweb/#enumdef-gpuloadop),
 * plus the corresponding clearValue.
 */
enum WGPULoadOp_Color_Tag
#ifdef __cplusplus
  : uint8_t
#endif // __cplusplus
 {
  /**
   * Loads the specified value for this attachment into the render pass.
   *
   * On some GPU hardware (primarily mobile), "clear" is significantly cheaper
   * because it avoids loading data from main memory into tile-local memory.
   *
   * On other GPU hardware, there isn’t a significant difference.
   *
   * As a result, it is recommended to use "clear" rather than "load" in cases
   * where the initial value doesn’t matter
   * (e.g. the render target will be cleared using a skybox).
   */
  WGPULoadOp_Color_Clear_Color = 0,
  /**
   * Loads the existing value for this attachment into the render pass.
   */
  WGPULoadOp_Color_Load_Color = 1,
  /**
   * Must be last for serialization purposes
   */
  WGPULoadOp_Color_Sentinel_Color,
};
#ifndef __cplusplus
typedef uint8_t WGPULoadOp_Color_Tag;
#endif // __cplusplus

union WGPULoadOp_Color {
  WGPULoadOp_Color_Tag tag;
  struct {
    WGPULoadOp_Color_Tag clear_tag;
    struct WGPUColor clear;
  };
};

/**
 * FFI-safe analogue of [`wgc::command::RenderPassColorAttachment`].
 */
struct WGPUFfiRenderPassColorAttachment {
  WGPUTextureViewId view;
  union WGPUFfiOption_u32 depth_slice;
  WGPUOption_TextureViewId resolve_target;
  union WGPULoadOp_Color load_op;
  enum WGPUStoreOp store_op;
};

/**
 * An equivalent of `&[T]` for ffi structures and function parameters.
 */
struct WGPUFfiSlice_FfiRenderPassColorAttachment {
  const struct WGPUFfiRenderPassColorAttachment *data;
  uintptr_t length;
};

/**
 * FFI-friendly analogue of [`std::option::Option`].
 *
 * In some cases, Rust's standard `Option` type is FFI-friendly, in that `T` and `Option<T>` map
 * to the same C++ type. For example, both `&U` and `Option<&U>` can be represented as `U *` in
 * C++.
 *
 * For other types, `Option<T>` may not be FFI-safe. For such cases, this type is a `repr(u8)`
 * analog to the standard
 *
 * See also: <https://doc.rust-lang.org/nomicon/ffi.html#the-nullable-pointer-optimization>
 */
enum WGPUFfiOption_f32_Tag
#ifdef __cplusplus
  : uint8_t
#endif // __cplusplus
 {
  WGPUFfiOption_f32_Some_f32,
  WGPUFfiOption_f32_None_f32,
  /**
   * Must be last for serialization purposes
   */
  WGPUFfiOption_f32_Sentinel_f32,
};
#ifndef __cplusplus
typedef uint8_t WGPUFfiOption_f32_Tag;
#endif // __cplusplus

union WGPUFfiOption_f32 {
  WGPUFfiOption_f32_Tag tag;
  struct {
    WGPUFfiOption_f32_Tag some_tag;
    float some;
  };
};

/**
 * Operation to perform to the output attachment at the start of a render pass.
 *
 * Corresponds to [WebGPU `GPULoadOp`](https://gpuweb.github.io/gpuweb/#enumdef-gpuloadop),
 * plus the corresponding clearValue.
 */
enum WGPULoadOp_FfiOption_f32_Tag
#ifdef __cplusplus
  : uint8_t
#endif // __cplusplus
 {
  /**
   * Loads the specified value for this attachment into the render pass.
   *
   * On some GPU hardware (primarily mobile), "clear" is significantly cheaper
   * because it avoids loading data from main memory into tile-local memory.
   *
   * On other GPU hardware, there isn’t a significant difference.
   *
   * As a result, it is recommended to use "clear" rather than "load" in cases
   * where the initial value doesn’t matter
   * (e.g. the render target will be cleared using a skybox).
   */
  WGPULoadOp_FfiOption_f32_Clear_FfiOption_f32 = 0,
  /**
   * Loads the existing value for this attachment into the render pass.
   */
  WGPULoadOp_FfiOption_f32_Load_FfiOption_f32 = 1,
  /**
   * Must be last for serialization purposes
   */
  WGPULoadOp_FfiOption_f32_Sentinel_FfiOption_f32,
};
#ifndef __cplusplus
typedef uint8_t WGPULoadOp_FfiOption_f32_Tag;
#endif // __cplusplus

union WGPULoadOp_FfiOption_f32 {
  WGPULoadOp_FfiOption_f32_Tag tag;
  struct {
    WGPULoadOp_FfiOption_f32_Tag clear_tag;
    union WGPUFfiOption_f32 clear;
  };
};

/**
 * FFI-friendly analogue of [`std::option::Option`].
 *
 * In some cases, Rust's standard `Option` type is FFI-friendly, in that `T` and `Option<T>` map
 * to the same C++ type. For example, both `&U` and `Option<&U>` can be represented as `U *` in
 * C++.
 *
 * For other types, `Option<T>` may not be FFI-safe. For such cases, this type is a `repr(u8)`
 * analog to the standard
 *
 * See also: <https://doc.rust-lang.org/nomicon/ffi.html#the-nullable-pointer-optimization>
 */
enum WGPUFfiOption_LoadOp_FfiOption_f32_Tag
#ifdef __cplusplus
  : uint8_t
#endif // __cplusplus
 {
  WGPUFfiOption_LoadOp_FfiOption_f32_Some_LoadOp_FfiOption_f32,
  WGPUFfiOption_LoadOp_FfiOption_f32_None_LoadOp_FfiOption_f32,
  /**
   * Must be last for serialization purposes
   */
  WGPUFfiOption_LoadOp_FfiOption_f32_Sentinel_LoadOp_FfiOption_f32,
};
#ifndef __cplusplus
typedef uint8_t WGPUFfiOption_LoadOp_FfiOption_f32_Tag;
#endif // __cplusplus

union WGPUFfiOption_LoadOp_FfiOption_f32 {
  WGPUFfiOption_LoadOp_FfiOption_f32_Tag tag;
  struct {
    WGPUFfiOption_LoadOp_FfiOption_f32_Tag some_tag;
    union WGPULoadOp_FfiOption_f32 some;
  };
};

/**
 * FFI-friendly analogue of [`std::option::Option`].
 *
 * In some cases, Rust's standard `Option` type is FFI-friendly, in that `T` and `Option<T>` map
 * to the same C++ type. For example, both `&U` and `Option<&U>` can be represented as `U *` in
 * C++.
 *
 * For other types, `Option<T>` may not be FFI-safe. For such cases, this type is a `repr(u8)`
 * analog to the standard
 *
 * See also: <https://doc.rust-lang.org/nomicon/ffi.html#the-nullable-pointer-optimization>
 */
enum WGPUFfiOption_StoreOp_Tag
#ifdef __cplusplus
  : uint8_t
#endif // __cplusplus
 {
  WGPUFfiOption_StoreOp_Some_StoreOp,
  WGPUFfiOption_StoreOp_None_StoreOp,
  /**
   * Must be last for serialization purposes
   */
  WGPUFfiOption_StoreOp_Sentinel_StoreOp,
};
#ifndef __cplusplus
typedef uint8_t WGPUFfiOption_StoreOp_Tag;
#endif // __cplusplus

union WGPUFfiOption_StoreOp {
  WGPUFfiOption_StoreOp_Tag tag;
  struct {
    WGPUFfiOption_StoreOp_Tag some_tag;
    enum WGPUStoreOp some;
  };
};

/**
 * FFI-safe analogue of [`wgc::command::PassChannel`].
 */
struct WGPUPassChannel_FfiOption_f32 {
  union WGPUFfiOption_LoadOp_FfiOption_f32 load_op;
  union WGPUFfiOption_StoreOp store_op;
  bool read_only;
};

/**
 * Operation to perform to the output attachment at the start of a render pass.
 *
 * Corresponds to [WebGPU `GPULoadOp`](https://gpuweb.github.io/gpuweb/#enumdef-gpuloadop),
 * plus the corresponding clearValue.
 */
enum WGPULoadOp_FfiOption_u32_Tag
#ifdef __cplusplus
  : uint8_t
#endif // __cplusplus
 {
  /**
   * Loads the specified value for this attachment into the render pass.
   *
   * On some GPU hardware (primarily mobile), "clear" is significantly cheaper
   * because it avoids loading data from main memory into tile-local memory.
   *
   * On other GPU hardware, there isn’t a significant difference.
   *
   * As a result, it is recommended to use "clear" rather than "load" in cases
   * where the initial value doesn’t matter
   * (e.g. the render target will be cleared using a skybox).
   */
  WGPULoadOp_FfiOption_u32_Clear_FfiOption_u32 = 0,
  /**
   * Loads the existing value for this attachment into the render pass.
   */
  WGPULoadOp_FfiOption_u32_Load_FfiOption_u32 = 1,
  /**
   * Must be last for serialization purposes
   */
  WGPULoadOp_FfiOption_u32_Sentinel_FfiOption_u32,
};
#ifndef __cplusplus
typedef uint8_t WGPULoadOp_FfiOption_u32_Tag;
#endif // __cplusplus

union WGPULoadOp_FfiOption_u32 {
  WGPULoadOp_FfiOption_u32_Tag tag;
  struct {
    WGPULoadOp_FfiOption_u32_Tag clear_tag;
    union WGPUFfiOption_u32 clear;
  };
};

/**
 * FFI-friendly analogue of [`std::option::Option`].
 *
 * In some cases, Rust's standard `Option` type is FFI-friendly, in that `T` and `Option<T>` map
 * to the same C++ type. For example, both `&U` and `Option<&U>` can be represented as `U *` in
 * C++.
 *
 * For other types, `Option<T>` may not be FFI-safe. For such cases, this type is a `repr(u8)`
 * analog to the standard
 *
 * See also: <https://doc.rust-lang.org/nomicon/ffi.html#the-nullable-pointer-optimization>
 */
enum WGPUFfiOption_LoadOp_FfiOption_u32_Tag
#ifdef __cplusplus
  : uint8_t
#endif // __cplusplus
 {
  WGPUFfiOption_LoadOp_FfiOption_u32_Some_LoadOp_FfiOption_u32,
  WGPUFfiOption_LoadOp_FfiOption_u32_None_LoadOp_FfiOption_u32,
  /**
   * Must be last for serialization purposes
   */
  WGPUFfiOption_LoadOp_FfiOption_u32_Sentinel_LoadOp_FfiOption_u32,
};
#ifndef __cplusplus
typedef uint8_t WGPUFfiOption_LoadOp_FfiOption_u32_Tag;
#endif // __cplusplus

union WGPUFfiOption_LoadOp_FfiOption_u32 {
  WGPUFfiOption_LoadOp_FfiOption_u32_Tag tag;
  struct {
    WGPUFfiOption_LoadOp_FfiOption_u32_Tag some_tag;
    union WGPULoadOp_FfiOption_u32 some;
  };
};

/**
 * FFI-safe analogue of [`wgc::command::PassChannel`].
 */
struct WGPUPassChannel_FfiOption_u32 {
  union WGPUFfiOption_LoadOp_FfiOption_u32 load_op;
  union WGPUFfiOption_StoreOp store_op;
  bool read_only;
};

/**
 * FFI-safe analogue of [`wgc::command::RenderPassDepthStencilAttachment`].
 */
struct WGPURenderPassDepthStencilAttachment {
  WGPUTextureViewId view;
  struct WGPUPassChannel_FfiOption_f32 depth;
  struct WGPUPassChannel_FfiOption_u32 stencil;
};

struct WGPURenderPassDescriptor {
  const nsACString *label;
  struct WGPUFfiSlice_FfiRenderPassColorAttachment color_attachments;
  const struct WGPURenderPassDepthStencilAttachment *depth_stencil_attachment;
  const struct WGPUPassTimestampWrites *timestamp_writes;
  WGPUOption_QuerySetId occlusion_query_set;
};

/**
 * Describes the shader stages that a binding will be visible from.
 *
 * These can be combined so something that is visible from both vertex and fragment shaders can be defined as:
 *
 * `ShaderStages::VERTEX | ShaderStages::FRAGMENT`
 *
 * Corresponds to [WebGPU `GPUShaderStageFlags`](
 * https://gpuweb.github.io/gpuweb/#typedefdef-gpushaderstageflags).
 */
typedef uint32_t WGPUShaderStages;
/**
 * Binding is not visible from any shader stage.
 */
#define WGPUShaderStages_NONE (uint32_t)0
/**
 * Binding is visible from the vertex shader of a render pipeline.
 */
#define WGPUShaderStages_VERTEX (uint32_t)(1 << 0)
/**
 * Binding is visible from the fragment shader of a render pipeline.
 */
#define WGPUShaderStages_FRAGMENT (uint32_t)(1 << 1)
/**
 * Binding is visible from the compute shader of a compute pipeline.
 */
#define WGPUShaderStages_COMPUTE (uint32_t)(1 << 2)
/**
 * Binding is visible from the vertex and fragment shaders of a render pipeline.
 */
#define WGPUShaderStages_VERTEX_FRAGMENT (uint32_t)((WGPUShaderStages_VERTEX).bits | (WGPUShaderStages_FRAGMENT).bits)
/**
 * Binding is visible from the task shader of a mesh pipeline.
 */
#define WGPUShaderStages_TASK (uint32_t)(1 << 3)
/**
 * Binding is visible from the mesh shader of a mesh pipeline.
 */
#define WGPUShaderStages_MESH (uint32_t)(1 << 4)

struct WGPUBindGroupLayoutEntry {
  uint32_t binding;
  WGPUShaderStages visibility;
  enum WGPURawBindingType ty;
  bool has_dynamic_offset;
  WGPUOption_BufferSize min_binding_size;
  const enum WGPUTextureViewDimension *view_dimension;
  const enum WGPURawTextureSampleType *texture_sample_type;
  bool multisampled;
  const struct WGPUTextureFormat *storage_texture_format;
  bool sampler_filter;
  bool sampler_compare;
};

/**
 * An equivalent of `&[T]` for ffi structures and function parameters.
 */
struct WGPUFfiSlice_BindGroupLayoutEntry {
  const struct WGPUBindGroupLayoutEntry *data;
  uintptr_t length;
};

struct WGPUBindGroupLayoutDescriptor {
  const nsACString *label;
  struct WGPUFfiSlice_BindGroupLayoutEntry entries;
};

/**
 * An equivalent of `&[T]` for ffi structures and function parameters.
 */
struct WGPUFfiSlice_BindGroupLayoutId {
  const WGPUBindGroupLayoutId *data;
  uintptr_t length;
};

struct WGPUPipelineLayoutDescriptor {
  const nsACString *label;
  struct WGPUFfiSlice_BindGroupLayoutId bind_group_layouts;
};

struct WGPUBindGroupEntry {
  uint32_t binding;
  WGPUOption_BufferId buffer;
  WGPUBufferAddress offset;
  WGPUOption_BufferSize size;
  WGPUOption_SamplerId sampler;
  WGPUOption_TextureViewId texture_view;
  WGPUOption_ExternalTextureId external_texture;
};

/**
 * An equivalent of `&[T]` for ffi structures and function parameters.
 */
struct WGPUFfiSlice_BindGroupEntry {
  const struct WGPUBindGroupEntry *data;
  uintptr_t length;
};

struct WGPUBindGroupDescriptor {
  const nsACString *label;
  WGPUBindGroupLayoutId layout;
  struct WGPUFfiSlice_BindGroupEntry entries;
};

typedef const char *WGPURawString;

struct WGPUConstantEntry {
  WGPURawString key;
  double value;
};

/**
 * An equivalent of `&[T]` for ffi structures and function parameters.
 */
struct WGPUFfiSlice_ConstantEntry {
  const struct WGPUConstantEntry *data;
  uintptr_t length;
};

struct WGPUProgrammableStageDescriptor {
  WGPUShaderModuleId module;
  WGPURawString entry_point;
  struct WGPUFfiSlice_ConstantEntry constants;
};

struct WGPUComputePipelineDescriptor {
  const nsACString *label;
  WGPUOption_PipelineLayoutId layout;
  struct WGPUProgrammableStageDescriptor stage;
};

/**
 * Integral type used for binding locations in shaders.
 *
 * Used in [`VertexAttribute`]s and errors.
 *
 * [`VertexAttribute`]: ../wgpu/struct.VertexAttribute.html
 */
typedef uint32_t WGPUShaderLocation;

/**
 * Vertex inputs (attributes) to shaders.
 *
 * These are used to specify the individual attributes within a [`VertexBufferLayout`].
 * See its documentation for an example.
 *
 * The [`vertex_attr_array!`] macro can help create these with appropriate offsets.
 *
 * Corresponds to [WebGPU `GPUVertexAttribute`](
 * https://gpuweb.github.io/gpuweb/#dictdef-gpuvertexattribute).
 *
 * [`vertex_attr_array!`]: ../wgpu/macro.vertex_attr_array.html
 * [`VertexBufferLayout`]: ../wgpu/struct.VertexBufferLayout.html
 */
struct WGPUVertexAttribute {
  /**
   * Format of the input
   */
  enum WGPUVertexFormat format;
  /**
   * Byte offset of the start of the input
   */
  WGPUBufferAddress offset;
  /**
   * Location for this input. Must match the location in the shader.
   */
  WGPUShaderLocation shader_location;
};

/**
 * An equivalent of `&[T]` for ffi structures and function parameters.
 */
struct WGPUFfiSlice_VertexAttribute {
  const struct WGPUVertexAttribute *data;
  uintptr_t length;
};

struct WGPUVertexBufferLayout {
  WGPUBufferAddress array_stride;
  enum WGPUVertexStepMode step_mode;
  struct WGPUFfiSlice_VertexAttribute attributes;
};

/**
 * An equivalent of `&[T]` for ffi structures and function parameters.
 */
struct WGPUFfiSlice_VertexBufferLayout {
  const struct WGPUVertexBufferLayout *data;
  uintptr_t length;
};

struct WGPUVertexState {
  struct WGPUProgrammableStageDescriptor stage;
  struct WGPUFfiSlice_VertexBufferLayout buffers;
};

struct WGPUPrimitiveState {
  enum WGPUPrimitiveTopology topology;
  const enum WGPUIndexFormat *strip_index_format;
  enum WGPUFrontFace front_face;
  const enum WGPUFace *cull_mode;
  enum WGPUPolygonMode polygon_mode;
  bool unclipped_depth;
};

/**
 * Describes a blend component of a [`BlendState`].
 *
 * Corresponds to [WebGPU `GPUBlendComponent`](
 * https://gpuweb.github.io/gpuweb/#dictdef-gpublendcomponent).
 */
struct WGPUBlendComponent {
  /**
   * Multiplier for the source, which is produced by the fragment shader.
   */
  enum WGPUBlendFactor src_factor;
  /**
   * Multiplier for the destination, which is stored in the target.
   */
  enum WGPUBlendFactor dst_factor;
  /**
   * The binary operation applied to the source and destination,
   * multiplied by their respective factors.
   */
  enum WGPUBlendOperation operation;
};
/**
 * Default blending state that replaces destination with the source.
 */
#define WGPUBlendComponent_REPLACE (WGPUBlendComponent){ .src_factor = WGPUBlendFactor_One, .dst_factor = WGPUBlendFactor_Zero, .operation = WGPUBlendOperation_Add }
/**
 * Blend state of `(1 * src) + ((1 - src_alpha) * dst)`.
 */
#define WGPUBlendComponent_OVER (WGPUBlendComponent){ .src_factor = WGPUBlendFactor_One, .dst_factor = WGPUBlendFactor_OneMinusSrcAlpha, .operation = WGPUBlendOperation_Add }

/**
 * Describe the blend state of a render pipeline,
 * within [`ColorTargetState`].
 *
 * Corresponds to [WebGPU `GPUBlendState`](
 * https://gpuweb.github.io/gpuweb/#dictdef-gpublendstate).
 */
struct WGPUBlendState {
  /**
   * Color equation.
   */
  struct WGPUBlendComponent color;
  /**
   * Alpha equation.
   */
  struct WGPUBlendComponent alpha;
};
/**
 * Blend mode that does no color blending, just overwrites the output with the contents of the shader.
 */
#define WGPUBlendState_REPLACE (WGPUBlendState){ .color = WGPUBlendComponent_REPLACE, .alpha = WGPUBlendComponent_REPLACE }
/**
 * Blend mode that does standard alpha blending with non-premultiplied alpha.
 */
#define WGPUBlendState_ALPHA_BLENDING (WGPUBlendState){ .color = (WGPUBlendComponent){ .src_factor = WGPUBlendFactor_SrcAlpha, .dst_factor = WGPUBlendFactor_OneMinusSrcAlpha, .operation = WGPUBlendOperation_Add }, .alpha = WGPUBlendComponent_OVER }
/**
 * Blend mode that does standard alpha blending with premultiplied alpha.
 */
#define WGPUBlendState_PREMULTIPLIED_ALPHA_BLENDING (WGPUBlendState){ .color = WGPUBlendComponent_OVER, .alpha = WGPUBlendComponent_OVER }

/**
 * Color write mask. Disabled color channels will not be written to.
 *
 * Corresponds to [WebGPU `GPUColorWriteFlags`](
 * https://gpuweb.github.io/gpuweb/#typedefdef-gpucolorwriteflags).
 */
typedef uint32_t WGPUColorWrites;
/**
 * Enable red channel writes
 */
#define WGPUColorWrites_RED (uint32_t)(1 << 0)
/**
 * Enable green channel writes
 */
#define WGPUColorWrites_GREEN (uint32_t)(1 << 1)
/**
 * Enable blue channel writes
 */
#define WGPUColorWrites_BLUE (uint32_t)(1 << 2)
/**
 * Enable alpha channel writes
 */
#define WGPUColorWrites_ALPHA (uint32_t)(1 << 3)
/**
 * Enable red, green, and blue channel writes
 */
#define WGPUColorWrites_COLOR (uint32_t)(((WGPUColorWrites_RED)._0 | (WGPUColorWrites_GREEN)._0) | (WGPUColorWrites_BLUE)._0)
/**
 * Enable writes to all channels.
 */
#define WGPUColorWrites_ALL (uint32_t)((((WGPUColorWrites_RED)._0 | (WGPUColorWrites_GREEN)._0) | (WGPUColorWrites_BLUE)._0) | (WGPUColorWrites_ALPHA)._0)

struct WGPUColorTargetState {
  struct WGPUTextureFormat format;
  const struct WGPUBlendState *blend;
  WGPUColorWrites write_mask;
};

/**
 * An equivalent of `&[T]` for ffi structures and function parameters.
 */
struct WGPUFfiSlice_ColorTargetState {
  const struct WGPUColorTargetState *data;
  uintptr_t length;
};

struct WGPUFragmentState {
  struct WGPUProgrammableStageDescriptor stage;
  struct WGPUFfiSlice_ColorTargetState targets;
};

/**
 * Describes stencil state in a render pipeline.
 *
 * If you are not using stencil state, set this to [`StencilFaceState::IGNORE`].
 *
 * Corresponds to [WebGPU `GPUStencilFaceState`](
 * https://gpuweb.github.io/gpuweb/#dictdef-gpustencilfacestate).
 */
struct WGPUStencilFaceState {
  /**
   * Comparison function that determines if the fail_op or pass_op is used on the stencil buffer.
   */
  enum WGPUCompareFunction compare;
  /**
   * Operation that is performed when stencil test fails.
   */
  enum WGPUStencilOperation fail_op;
  /**
   * Operation that is performed when depth test fails but stencil test succeeds.
   */
  enum WGPUStencilOperation depth_fail_op;
  /**
   * Operation that is performed when stencil test success.
   */
  enum WGPUStencilOperation pass_op;
};
/**
 * Ignore the stencil state for the face.
 */
#define WGPUStencilFaceState_IGNORE (WGPUStencilFaceState){ .compare = WGPUCompareFunction_Always, .fail_op = WGPUStencilOperation_Keep, .depth_fail_op = WGPUStencilOperation_Keep, .pass_op = WGPUStencilOperation_Keep }

/**
 * State of the stencil operation (fixed-pipeline stage).
 *
 * For use in [`DepthStencilState`].
 *
 * Corresponds to a portion of [WebGPU `GPUDepthStencilState`](
 * https://gpuweb.github.io/gpuweb/#dictdef-gpudepthstencilstate).
 */
struct WGPUStencilState {
  /**
   * Front face mode.
   */
  struct WGPUStencilFaceState front;
  /**
   * Back face mode.
   */
  struct WGPUStencilFaceState back;
  /**
   * Stencil values are AND'd with this mask when reading and writing from the stencil buffer. Only low 8 bits are used.
   */
  uint32_t read_mask;
  /**
   * Stencil values are AND'd with this mask when writing to the stencil buffer. Only low 8 bits are used.
   */
  uint32_t write_mask;
};

/**
 * Describes the biasing setting for the depth target.
 *
 * For use in [`DepthStencilState`].
 *
 * Corresponds to a portion of [WebGPU `GPUDepthStencilState`](
 * https://gpuweb.github.io/gpuweb/#dictdef-gpudepthstencilstate).
 */
struct WGPUDepthBiasState {
  /**
   * Constant depth biasing factor, in basic units of the depth format.
   */
  int32_t constant;
  /**
   * Slope depth biasing factor.
   */
  float slope_scale;
  /**
   * Depth bias clamp value (absolute).
   */
  float clamp;
};

/**
 * Describes the depth/stencil state in a render pipeline.
 *
 * Corresponds to [WebGPU `GPUDepthStencilState`](
 * https://gpuweb.github.io/gpuweb/#dictdef-gpudepthstencilstate).
 */
struct WGPUDepthStencilState {
  /**
   * Format of the depth/stencil buffer, must be special depth format. Must match the format
   * of the depth/stencil attachment in [`CommandEncoder::begin_render_pass`][CEbrp].
   *
   * [CEbrp]: ../wgpu/struct.CommandEncoder.html#method.begin_render_pass
   */
  struct WGPUTextureFormat format;
  /**
   * If disabled, depth will not be written to.
   */
  bool depth_write_enabled;
  /**
   * Comparison function used to compare depth values in the depth test.
   */
  enum WGPUCompareFunction depth_compare;
  /**
   * Stencil state.
   */
  struct WGPUStencilState stencil;
  /**
   * Depth bias state.
   */
  struct WGPUDepthBiasState bias;
};

/**
 * Describes the multi-sampling state of a render pipeline.
 *
 * Corresponds to [WebGPU `GPUMultisampleState`](
 * https://gpuweb.github.io/gpuweb/#dictdef-gpumultisamplestate).
 */
struct WGPUMultisampleState {
  /**
   * The number of samples calculated per pixel (for MSAA). For non-multisampled textures,
   * this should be `1`
   */
  uint32_t count;
  /**
   * Bitmask that restricts the samples of a pixel modified by this pipeline. All samples
   * can be enabled using the value `!0`
   */
  uint64_t mask;
  /**
   * When enabled, produces another sample mask per pixel based on the alpha output value, that
   * is ANDed with the sample mask and the primitive coverage to restrict the set of samples
   * affected by a primitive.
   *
   * The implicit mask produced for alpha of zero is guaranteed to be zero, and for alpha of one
   * is guaranteed to be all 1-s.
   */
  bool alpha_to_coverage_enabled;
};

struct WGPURenderPipelineDescriptor {
  const nsACString *label;
  WGPUOption_PipelineLayoutId layout;
  const struct WGPUVertexState *vertex;
  struct WGPUPrimitiveState primitive;
  const struct WGPUFragmentState *fragment;
  const struct WGPUDepthStencilState *depth_stencil;
  struct WGPUMultisampleState multisample;
};

/**
 * Origin of a copy to/from a texture.
 *
 * Corresponds to [WebGPU `GPUOrigin3D`](
 * https://gpuweb.github.io/gpuweb/#dictdef-gpuorigin3ddict).
 */
struct WGPUOrigin3d {
  /**
   * X position of the origin
   */
  uint32_t x;
  /**
   * Y position of the origin
   */
  uint32_t y;
  /**
   * Z position of the origin
   */
  uint32_t z;
};
/**
 * Zero origin.
 */
#define WGPUOrigin3d_ZERO (WGPUOrigin3d){ .x = 0, .y = 0, .z = 0 }

/**
 * View of a texture which can be used to copy to/from a buffer/texture.
 *
 * Corresponds to [WebGPU `GPUTexelCopyTextureInfo`](
 * https://gpuweb.github.io/gpuweb/#dictdef-gpuimagecopytexture).
 */
struct WGPUTexelCopyTextureInfo_TextureId {
  /**
   * The texture to be copied to/from.
   */
  WGPUTextureId texture;
  /**
   * The target mip level of the texture.
   */
  uint32_t mip_level;
  /**
   * The base texel of the texture in the selected `mip_level`. Together
   * with the `copy_size` argument to copy functions, defines the
   * sub-region of the texture to copy.
   */
  struct WGPUOrigin3d origin;
  /**
   * The copy aspect.
   */
  enum WGPUTextureAspect aspect;
};

typedef struct WGPUTexelCopyTextureInfo_TextureId WGPUTexelCopyTextureInfo;

struct WGPUTexelCopyBufferLayout {
  WGPUBufferAddress offset;
  const uint32_t *bytes_per_row;
  const uint32_t *rows_per_image;
};

/**
 * Describes a [`CommandBuffer`](../wgpu/struct.CommandBuffer.html).
 *
 * Corresponds to [WebGPU `GPUCommandBufferDescriptor`](
 * https://gpuweb.github.io/gpuweb/#dictdef-gpucommandbufferdescriptor).
 */
struct WGPUCommandBufferDescriptor {
  /**
   * Debug label of this command buffer.
   */
  const nsACString *label;
};

struct WGPUTextureFormatBlockInfo {
  uint32_t copy_size;
  uint32_t width;
  uint32_t height;
};

/**
 * Integral type used for
 * [dynamic bind group offsets](../wgpu/struct.RenderPass.html#method.set_bind_group).
 */
typedef uint32_t WGPUDynamicOffset;

/**
 * Integral type used for [`BufferSlice`] sizes.
 *
 * Note that while this type is non-zero, a [`Buffer`] *per se* can have a size of zero,
 * but no slice or mapping can be created from it.
 *
 * [`Buffer`]: ../wgpu/struct.Buffer.html
 * [`BufferSlice`]: ../wgpu/struct.BufferSlice.html
 */
typedef uint64_t WGPUBufferSize;

/**
 * An equivalent of `&[T]` for ffi structures and function parameters.
 */
struct WGPUFfiSlice_DynamicOffset {
  const WGPUDynamicOffset *data;
  uintptr_t length;
};

/**
 * An equivalent of `&[T]` for ffi structures and function parameters.
 */
struct WGPUFfiSlice_RenderBundleId {
  const WGPURenderBundleId *data;
  uintptr_t length;
};

/**
 * Opaque pointer to `mozilla::webgpu::WebGPUParent`.
 */
typedef void *WGPUWebGPUParentPtr;

struct WGPUDeviceLostClosure {
  void (*callback)(uint8_t *user_data,
                   uint8_t reason,
                   const char *message);
  void (*cleanup_callback)(uint8_t *user_data);
  uint8_t *user_data;
};

/**
 * A non-owning representation of `mozilla::webgpu::ErrorBuffer` in C++, passed as an argument to
 * other functions in [this module](self).
 *
 * C++ callers of Rust functions (presumably in `WebGPUParent.cpp`) that expect one of these
 * structs can create a `mozilla::webgpu::ErrorBuffer` object, and call its `ToFFI` method to
 * construct a value of this type, available to C++ as `mozilla::webgpu::ffi::WGPUErrorBuffer`. If
 * we catch a `Result::Err` in other functions of [this module](self), the error is converted to
 * this type.
 */
struct WGPUErrorBuffer {
  /**
   * The type of error that `string` is associated with. If this location is set to
   * [`ErrorBufferType::None`] after being passed as an argument to a function in [this module](self),
   * then the remaining fields are guaranteed to not have been altered by that function from
   * their original state.
   */
  WGPUErrorBufferType *type;
  /**
   * The (potentially truncated) message associated with this error. A fixed-capacity,
   * null-terminated UTF-8 string buffer owned by C++.
   *
   * When we convert WGPU errors to this type, we render the error as a string, copying into
   * `message` up to `capacity - 1`, and null-terminate it.
   */
  char *message;
  uintptr_t message_capacity;
  WGPUDeviceId *device_id;
};

struct WGPUBufferMapClosure {
  void (*callback)(uint8_t *user_data,
                   enum WGPUBufferMapAsyncStatus status);
  uint8_t *user_data;
};

struct WGPUMappedBufferSlice {
  uint8_t *ptr;
  uint64_t length;
};

struct WGPUDMABufInfo {
  bool is_valid;
  uint64_t modifier;
  uint32_t plane_count;
  uint64_t offsets[3];
  uint64_t strides[3];
};

/**
 * An equivalent of `&[T]` for ffi structures and function parameters.
 */
struct WGPUFfiSlice_TextureViewId {
  const WGPUTextureViewId *data;
  uintptr_t length;
};

/**
 * Parameters describing a gamma encoding transfer function in the form
 * tf = { k * linear                   | linear < b
 *      { a * pow(linear, 1/g) - (a-1) | linear >= b
 */
struct WGPUExternalTextureTransferFunction {
  float a;
  float b;
  float g;
  float k;
};

struct WGPUExternalTextureDescriptorFromSource {
  struct WGPUFfiSlice_TextureViewId planes;
  uint32_t width;
  uint32_t height;
  enum WGPUExternalTextureFormat format;
  float yuv_conversion_matrix[16];
  float gamut_conversion_matrix[9];
  struct WGPUExternalTextureTransferFunction src_transfer_function;
  struct WGPUExternalTextureTransferFunction dst_transfer_function;
  float sample_transform[6];
  float load_transform[6];
};

#if defined(XP_WIN)
struct WGPUFfiLUID {
  unsigned long low_part;
  long high_part;
};
#endif

struct WGPUSubmittedWorkDoneClosure {
  void (*callback)(uint8_t *user_data);
  uint8_t *user_data;
};

/**
 * An equivalent of `&[T]` for ffi structures and function parameters.
 */
struct WGPUFfiSlice_ByteBuf {
  const struct WGPUByteBuf *data;
  uintptr_t length;
};

/**
 * An equivalent of `&[T]` for ffi structures and function parameters.
 */
struct WGPUFfiSlice_u8 {
  const uint8_t *data;
  uintptr_t length;
};

/**
 * An equivalent of `&[T]` for ffi structures and function parameters.
 */
struct WGPUFfiSlice_FfiSlice_u8 {
  const struct WGPUFfiSlice_u8 *data;
  uintptr_t length;
};

typedef uint64_t WGPUFenceValue;

struct WGPUMachTimebaseInfo {
  uint32_t numerator;
  uint32_t denominator;
};

/**
 * We limit the size of buffer allocations for stability reason.
 * We can reconsider this limit in the future. Note that some drivers (mesa for example),
 * have issues when the size of a buffer, mapping or copy command does not fit into a
 * signed 32 bits integer, so beyond a certain size, large allocations will need some form
 * of driver allow/blocklist.
 */
#define WGPUMAX_BUFFER_SIZE (1ull << 30ull)





































































































































/**
 * An [offset into the query resolve buffer] has to be aligned to this.
 *
 * [offset into the query resolve buffer]: ../wgpu/struct.CommandEncoder.html#method.resolve_query_set
 */
#define WGPUQUERY_RESOLVE_BUFFER_ALIGNMENT 256

/**
 * Buffer to buffer copy as well as buffer clear offsets and sizes must be aligned to this number.
 */
#define WGPUCOPY_BUFFER_ALIGNMENT 4

/**
 * Minimum alignment of buffer mappings.
 *
 * The range passed to [`map_async()`] or [`get_mapped_range()`] must be at least this aligned.
 *
 * [`map_async()`]: ../wgpu/struct.Buffer.html#method.map_async
 * [`get_mapped_range()`]: ../wgpu/struct.Buffer.html#method.get_mapped_range
 */
#define WGPUMAP_ALIGNMENT 8

/**
 * [Vertex buffer offsets] and [strides] have to be a multiple of this number.
 *
 * [Vertex buffer offsets]: ../wgpu/util/trait.RenderEncoder.html#tymethod.set_vertex_buffer
 * [strides]: ../wgpu/struct.VertexBufferLayout.html#structfield.array_stride
 */
#define WGPUVERTEX_ALIGNMENT 4

/**
 * [Vertex buffer strides] have to be a multiple of this number.
 *
 * [Vertex buffer strides]: ../wgpu/struct.VertexBufferLayout.html#structfield.array_stride
 */
#define WGPUVERTEX_STRIDE_ALIGNMENT 4















































































































/**
 * Alignment requirement for transform buffers used in acceleration structure builds
 */
#define WGPUTRANSFORM_BUFFER_ALIGNMENT 16

/**
 * Alignment requirement for instance buffers used in acceleration structure builds (`build_acceleration_structures_unsafe_tlas`)
 */
#define WGPUINSTANCE_BUFFER_ALIGNMENT 16



#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

WGPU_INLINE
uint32_t wgpu_client_get_queued_messages(const struct WGPUClient *aClient,
                                         struct WGPUByteBuf *aSerializedMessagesBb)
WGPU_FUNC;

WGPU_INLINE
struct WGPUClient *wgpu_client_new(WGPUWebGPUChildPtr aOwner,
                                   void (*aOnMessageQueued)(WGPUWebGPUChildPtr))
WGPU_FUNC;

/**
 * # Safety
 *
 * This function is unsafe because improper use may lead to memory
 * problems. For example, a double-free may occur if the function is called
 * twice on the same raw pointer.
 */
WGPU_INLINE
void wgpu_client_delete(struct WGPUClient *aClient)
WGPU_FUNC;

WGPU_INLINE
void wgpu_client_fill_default_limits(struct WGPULimits *aLimits)
WGPU_FUNC;

/**
 * Writes the single `WGSLLanguageFeature` associated with `index`, appending its identifier to the
 * provided `buffer`. If `index` does not correspond to a valid feature index, then do nothing.
 *
 * This function enables an FFI consumer to extract all implemented features in a loop, like so:
 *
 * ```rust
 * let mut buffer = nsstring::nsCString::new();
 * for index in 0usize.. {
 *     buffer.truncate();
 *     wgpu_client_instance_get_wgsl_language_feature(&mut buffer, index);
 *     if buffer.is_empty() {
 *         break;
 *     }
 *     // Handle the identifier in `buffer`…
 * }
 * ```
 */
WGPU_INLINE
void wgpu_client_instance_get_wgsl_language_feature(nsCString *aBuffer,
                                                    uintptr_t aIndex)
WGPU_FUNC;

WGPU_INLINE
struct WGPUDeviceQueueId wgpu_client_request_device(const struct WGPUClient *aClient,
                                                    WGPUAdapterId aAdapterId,
                                                    const struct WGPUFfiDeviceDescriptor *aDesc)
WGPU_FUNC;

WGPU_INLINE
WGPUBufferId wgpu_client_make_buffer_id(const struct WGPUClient *aClient)
WGPU_FUNC;

WGPU_INLINE
void wgpu_client_free_buffer_id(const struct WGPUClient *aClient,
                                WGPUBufferId aId)
WGPU_FUNC;

WGPU_INLINE
WGPURenderPassEncoderId wgpu_client_make_render_pass_encoder_id(const struct WGPUClient *aClient)
WGPU_FUNC;

WGPU_INLINE
WGPUComputePassEncoderId wgpu_client_make_compute_pass_encoder_id(const struct WGPUClient *aClient)
WGPU_FUNC;

WGPU_INLINE
WGPURenderBundleEncoderId wgpu_client_make_render_bundle_encoder_id(const struct WGPUClient *aClient)
WGPU_FUNC;

extern void wgpu_child_send_messages(WGPUWebGPUChildPtr aChild,
                                     uint32_t aNrOfMessages,
                                     struct WGPUByteBuf aSerializedMessages);

extern void wgpu_child_resolve_request_adapter_promise(WGPUWebGPUChildPtr aChild,
                                                       WGPUAdapterId aAdapterId,
                                                       const struct WGPUAdapterInformation *aAdapterInfo);

extern void wgpu_child_resolve_request_device_promise(WGPUWebGPUChildPtr aChild,
                                                      WGPUDeviceId aDeviceId,
                                                      WGPUQueueId aQueueId,
                                                      const nsCString *aError);

extern void wgpu_child_resolve_pop_error_scope_promise(WGPUWebGPUChildPtr aChild,
                                                       WGPUDeviceId aDeviceId,
                                                       uint8_t aTy,
                                                       const nsCString *aMessage);

extern void wgpu_child_resolve_create_pipeline_promise(WGPUWebGPUChildPtr aChild,
                                                       WGPURawId aPipelineId,
                                                       bool aIsRenderPipeline,
                                                       bool aIsValidationError,
                                                       const nsCString *aError);

extern void wgpu_child_resolve_create_shader_module_promise(WGPUWebGPUChildPtr aChild,
                                                            WGPUShaderModuleId aShaderModuleId,
                                                            struct WGPUFfiSlice_FfiShaderModuleCompilationMessage aMessages);

extern void wgpu_child_resolve_buffer_map_promise(WGPUWebGPUChildPtr aChild,
                                                  WGPUBufferId aBufferId,
                                                  bool aIsWritable,
                                                  uint64_t aOffset,
                                                  uint64_t aSize,
                                                  const nsCString *aError);

extern void wgpu_child_resolve_on_submitted_work_done_promise(WGPUWebGPUChildPtr aChild,
                                                              WGPUQueueId aQueueId);

WGPU_INLINE
void wgpu_client_receive_server_message(const struct WGPUClient *aClient,
                                        const struct WGPUByteBuf *aByteBuf)
WGPU_FUNC;

WGPU_INLINE
WGPUAdapterId wgpu_client_request_adapter(const struct WGPUClient *aClient,
                                          enum WGPUPowerPreference aPowerPreference,
                                          bool aForceFallbackAdapter)
WGPU_FUNC;

WGPU_INLINE
void wgpu_client_pop_error_scope(const struct WGPUClient *aClient,
                                 WGPUDeviceId aDeviceId)
WGPU_FUNC;

WGPU_INLINE
WGPUShaderModuleId wgpu_client_create_shader_module(const struct WGPUClient *aClient,
                                                    WGPUDeviceId aDeviceId,
                                                    const nsACString *aLabel,
                                                    const nsACString *aCode)
WGPU_FUNC;

WGPU_INLINE
void wgpu_client_on_submitted_work_done(const struct WGPUClient *aClient,
                                        WGPUQueueId aQueueId)
WGPU_FUNC;

WGPU_INLINE
void wgpu_client_create_swap_chain(const struct WGPUClient *aClient,
                                   WGPUDeviceId aDeviceId,
                                   WGPUQueueId aQueueId,
                                   int32_t aWidth,
                                   int32_t aHeight,
                                   WGPUSurfaceFormat aFormat,
                                   struct WGPUFfiSlice_BufferId aBuffers,
                                   WGPURemoteTextureOwnerId aRemoteTextureOwnerId,
                                   bool aUseSharedTextureInSwapChain)
WGPU_FUNC;

WGPU_INLINE
void wgpu_client_swap_chain_present(const struct WGPUClient *aClient,
                                    WGPUTextureId aTextureId,
                                    WGPUCommandEncoderId aCommandEncoderId,
                                    WGPUCommandBufferId aCommandBufferId,
                                    WGPURemoteTextureId aRemoteTextureId,
                                    WGPURemoteTextureOwnerId aRemoteTextureOwnerId)
WGPU_FUNC;

WGPU_INLINE
void wgpu_client_swap_chain_drop(const struct WGPUClient *aClient,
                                 WGPURemoteTextureOwnerId aRemoteTextureOwnerId,
                                 WGPURemoteTextureTxnType aTxnType,
                                 WGPURemoteTextureTxnId aTxnId)
WGPU_FUNC;

WGPU_INLINE
void wgpu_client_queue_submit(const struct WGPUClient *aClient,
                              WGPUDeviceId aDeviceId,
                              WGPUQueueId aQueueId,
                              struct WGPUFfiSlice_CommandBufferId aCommandBuffers,
                              struct WGPUFfiSlice_TextureId aSwapChainTextures,
                              struct WGPUFfiSlice_ExternalTextureSourceId aExternalTextureSources)
WGPU_FUNC;

WGPU_INLINE
void wgpu_client_buffer_map(const struct WGPUClient *aClient,
                            WGPUDeviceId aDeviceId,
                            WGPUBufferId aBufferId,
                            uint32_t aMode,
                            uint64_t aOffset,
                            uint64_t aSize)
WGPU_FUNC;

WGPU_INLINE
void wgpu_client_buffer_unmap(const struct WGPUClient *aClient,
                              WGPUDeviceId aDeviceId,
                              WGPUBufferId aBufferId,
                              bool aFlush)
WGPU_FUNC;

WGPU_INLINE
void wgpu_client_push_error_scope(const struct WGPUClient *aClient,
                                  WGPUDeviceId aDeviceId,
                                  uint8_t aFilter)
WGPU_FUNC;

WGPU_INLINE
WGPUBufferId wgpu_client_create_buffer(const struct WGPUClient *aClient,
                                       WGPUDeviceId aDeviceId,
                                       const struct WGPUBufferDescriptor *aDesc,
                                       uintptr_t aShmemHandleIndex)
WGPU_FUNC;

WGPU_INLINE
WGPUTextureId wgpu_client_create_texture(const struct WGPUClient *aClient,
                                         WGPUDeviceId aDeviceId,
                                         const struct WGPUTextureDescriptor *aDesc,
                                         const struct WGPUSwapChainId *aSwapChainId)
WGPU_FUNC;

WGPU_INLINE
WGPUTextureId wgpu_client_make_texture_id(const struct WGPUClient *aClient)
WGPU_FUNC;

WGPU_INLINE
void wgpu_client_free_texture_id(const struct WGPUClient *aClient,
                                 WGPUTextureId aId)
WGPU_FUNC;

WGPU_INLINE
WGPUTextureViewId wgpu_client_create_texture_view(const struct WGPUClient *aClient,
                                                  WGPUDeviceId aDeviceId,
                                                  WGPUTextureId aTextureId,
                                                  const struct WGPUTextureViewDescriptor *aDesc)
WGPU_FUNC;

WGPU_INLINE
WGPUTextureViewId wgpu_client_make_texture_view_id(const struct WGPUClient *aClient)
WGPU_FUNC;

WGPU_INLINE
void wgpu_client_free_texture_view_id(const struct WGPUClient *aClient,
                                      WGPUTextureViewId aId)
WGPU_FUNC;

WGPU_INLINE
WGPUExternalTextureSourceId wgpu_client_make_external_texture_source_id(const struct WGPUClient *aClient)
WGPU_FUNC;

WGPU_INLINE
WGPUExternalTextureId wgpu_client_create_external_texture(const struct WGPUClient *aClient,
                                                          WGPUDeviceId aDeviceId,
                                                          const struct WGPUExternalTextureDescriptor *aDesc)
WGPU_FUNC;

WGPU_INLINE
WGPUSamplerId wgpu_client_create_sampler(const struct WGPUClient *aClient,
                                         WGPUDeviceId aDeviceId,
                                         const struct WGPUSamplerDescriptor *aDesc)
WGPU_FUNC;

WGPU_INLINE
WGPUCommandEncoderId wgpu_client_make_command_encoder_id(const struct WGPUClient *aClient)
WGPU_FUNC;

WGPU_INLINE
void wgpu_client_free_command_encoder_id(const struct WGPUClient *aClient,
                                         WGPUCommandEncoderId aId)
WGPU_FUNC;

WGPU_INLINE
WGPUCommandBufferId wgpu_client_make_command_buffer_id(const struct WGPUClient *aClient)
WGPU_FUNC;

WGPU_INLINE
void wgpu_client_free_command_buffer_id(const struct WGPUClient *aClient,
                                        WGPUCommandBufferId aId)
WGPU_FUNC;

WGPU_INLINE
WGPUCommandEncoderId wgpu_client_create_command_encoder(const struct WGPUClient *aClient,
                                                        WGPUDeviceId aDeviceId,
                                                        const struct WGPUCommandEncoderDescriptor *aDesc)
WGPU_FUNC;

WGPU_INLINE
struct WGPURenderBundleEncoder *wgpu_device_create_render_bundle_encoder(const struct WGPUClient *aClient,
                                                                         WGPUDeviceId aDeviceId,
                                                                         const struct WGPURenderBundleEncoderDescriptor *aDesc)
WGPU_FUNC;

WGPU_INLINE
void wgpu_render_bundle_encoder_destroy(struct WGPURenderBundleEncoder *aPass)
WGPU_FUNC;

WGPU_INLINE
WGPURenderBundleId wgpu_client_create_render_bundle(const struct WGPUClient *aClient,
                                                    WGPUDeviceId aDeviceId,
                                                    struct WGPURenderBundleEncoder *aEncoder,
                                                    const struct WGPURenderBundleDescriptor *aDesc)
WGPU_FUNC;

WGPU_INLINE
WGPURenderBundleId wgpu_client_create_render_bundle_error(const struct WGPUClient *aClient,
                                                          WGPUDeviceId aDeviceId,
                                                          const nsACString *aLabel)
WGPU_FUNC;

WGPU_INLINE
WGPUQuerySetId wgpu_client_create_query_set(const struct WGPUClient *aClient,
                                            WGPUDeviceId aDeviceId,
                                            const struct WGPURawQuerySetDescriptor *aDesc)
WGPU_FUNC;

WGPU_INLINE
struct WGPURecordedComputePass *wgpu_command_encoder_begin_compute_pass(const struct WGPUComputePassDescriptor *aDesc)
WGPU_FUNC;

WGPU_INLINE
void wgpu_compute_pass_finish(const struct WGPUClient *aClient,
                              WGPUDeviceId aDeviceId,
                              WGPUCommandEncoderId aEncoderId,
                              struct WGPURecordedComputePass *aPass)
WGPU_FUNC;

WGPU_INLINE
void wgpu_compute_pass_destroy(struct WGPURecordedComputePass *aPass)
WGPU_FUNC;

WGPU_INLINE
struct WGPURecordedRenderPass *wgpu_command_encoder_begin_render_pass(const struct WGPURenderPassDescriptor *aDesc)
WGPU_FUNC;

WGPU_INLINE
void wgpu_render_pass_finish(const struct WGPUClient *aClient,
                             WGPUDeviceId aDeviceId,
                             WGPUCommandEncoderId aEncoderId,
                             struct WGPURecordedRenderPass *aPass)
WGPU_FUNC;

WGPU_INLINE
void wgpu_render_pass_destroy(struct WGPURecordedRenderPass *aPass)
WGPU_FUNC;

WGPU_INLINE
WGPUBindGroupLayoutId wgpu_client_create_bind_group_layout(const struct WGPUClient *aClient,
                                                           WGPUDeviceId aDeviceId,
                                                           const struct WGPUBindGroupLayoutDescriptor *aDesc)
WGPU_FUNC;

WGPU_INLINE
WGPUBindGroupLayoutId wgpu_client_render_pipeline_get_bind_group_layout(const struct WGPUClient *aClient,
                                                                        WGPUDeviceId aDeviceId,
                                                                        WGPURenderPipelineId aPipelineId,
                                                                        uint32_t aIndex)
WGPU_FUNC;

WGPU_INLINE
WGPUBindGroupLayoutId wgpu_client_compute_pipeline_get_bind_group_layout(const struct WGPUClient *aClient,
                                                                         WGPUDeviceId aDeviceId,
                                                                         WGPUComputePipelineId aPipelineId,
                                                                         uint32_t aIndex)
WGPU_FUNC;

WGPU_INLINE
WGPUPipelineLayoutId wgpu_client_create_pipeline_layout(const struct WGPUClient *aClient,
                                                        WGPUDeviceId aDeviceId,
                                                        const struct WGPUPipelineLayoutDescriptor *aDesc)
WGPU_FUNC;

WGPU_INLINE
WGPUBindGroupId wgpu_client_create_bind_group(const struct WGPUClient *aClient,
                                              WGPUDeviceId aDeviceId,
                                              const struct WGPUBindGroupDescriptor *aDesc)
WGPU_FUNC;

WGPU_INLINE
WGPUComputePipelineId wgpu_client_create_compute_pipeline(const struct WGPUClient *aClient,
                                                          WGPUDeviceId aDeviceId,
                                                          const struct WGPUComputePipelineDescriptor *aDesc,
                                                          bool aIsAsync)
WGPU_FUNC;

WGPU_INLINE
WGPURenderPipelineId wgpu_client_create_render_pipeline(const struct WGPUClient *aClient,
                                                        WGPUDeviceId aDeviceId,
                                                        const struct WGPURenderPipelineDescriptor *aDesc,
                                                        bool aIsAsync)
WGPU_FUNC;

WGPU_INLINE
void wgpu_command_encoder_copy_buffer_to_buffer(const struct WGPUClient *aClient,
                                                WGPUDeviceId aDeviceId,
                                                WGPUCommandEncoderId aCommandEncoderId,
                                                WGPUBufferId aSrc,
                                                WGPUBufferAddress aSrcOffset,
                                                WGPUBufferId aDst,
                                                WGPUBufferAddress aDstOffset,
                                                WGPUBufferAddress aSize)
WGPU_FUNC;

WGPU_INLINE
void wgpu_command_encoder_copy_texture_to_buffer(const struct WGPUClient *aClient,
                                                 WGPUDeviceId aDeviceId,
                                                 WGPUCommandEncoderId aCommandEncoderId,
                                                 WGPUTexelCopyTextureInfo aSrc,
                                                 WGPUBufferId aDstBuffer,
                                                 const struct WGPUTexelCopyBufferLayout *aDstLayout,
                                                 struct WGPUExtent3d aSize)
WGPU_FUNC;

WGPU_INLINE
void wgpu_command_encoder_copy_buffer_to_texture(const struct WGPUClient *aClient,
                                                 WGPUDeviceId aDeviceId,
                                                 WGPUCommandEncoderId aCommandEncoderId,
                                                 WGPUBufferId aSrcBuffer,
                                                 const struct WGPUTexelCopyBufferLayout *aSrcLayout,
                                                 WGPUTexelCopyTextureInfo aDst,
                                                 struct WGPUExtent3d aSize)
WGPU_FUNC;

WGPU_INLINE
void wgpu_command_encoder_copy_texture_to_texture(const struct WGPUClient *aClient,
                                                  WGPUDeviceId aDeviceId,
                                                  WGPUCommandEncoderId aCommandEncoderId,
                                                  WGPUTexelCopyTextureInfo aSrc,
                                                  WGPUTexelCopyTextureInfo aDst,
                                                  struct WGPUExtent3d aSize)
WGPU_FUNC;

WGPU_INLINE
void wgpu_command_encoder_clear_buffer(const struct WGPUClient *aClient,
                                       WGPUDeviceId aDeviceId,
                                       WGPUCommandEncoderId aCommandEncoderId,
                                       WGPUBufferId aDst,
                                       uint64_t aOffset,
                                       const uint64_t *aSize)
WGPU_FUNC;

WGPU_INLINE
void wgpu_command_encoder_push_debug_group(const struct WGPUClient *aClient,
                                           WGPUDeviceId aDeviceId,
                                           WGPUCommandEncoderId aCommandEncoderId,
                                           const nsACString *aMarker)
WGPU_FUNC;

WGPU_INLINE
void wgpu_command_encoder_pop_debug_group(const struct WGPUClient *aClient,
                                          WGPUDeviceId aDeviceId,
                                          WGPUCommandEncoderId aCommandEncoderId)
WGPU_FUNC;

WGPU_INLINE
void wgpu_command_encoder_insert_debug_marker(const struct WGPUClient *aClient,
                                              WGPUDeviceId aDeviceId,
                                              WGPUCommandEncoderId aCommandEncoderId,
                                              const nsACString *aMarker)
WGPU_FUNC;

WGPU_INLINE
void wgpu_command_encoder_resolve_query_set(const struct WGPUClient *aClient,
                                            WGPUDeviceId aDeviceId,
                                            WGPUCommandEncoderId aCommandEncoderId,
                                            WGPUQuerySetId aQuerySetId,
                                            uint32_t aStartQuery,
                                            uint32_t aQueryCount,
                                            WGPUBufferId aDestination,
                                            WGPUBufferAddress aDestinationOffset)
WGPU_FUNC;

WGPU_INLINE
void wgpu_report_internal_error(const struct WGPUClient *aClient,
                                WGPUDeviceId aDeviceId,
                                const char *aMessage)
WGPU_FUNC;

WGPU_INLINE
void wgpu_report_validation_error(const struct WGPUClient *aClient,
                                  WGPUDeviceId aDeviceId,
                                  const char *aMessage)
WGPU_FUNC;

WGPU_INLINE
WGPUCommandBufferId wgpu_command_encoder_finish(const struct WGPUClient *aClient,
                                                WGPUDeviceId aDeviceId,
                                                WGPUCommandEncoderId aCommandEncoderId,
                                                const struct WGPUCommandBufferDescriptor *aDesc)
WGPU_FUNC;

WGPU_INLINE
void wgpu_queue_write_buffer_inline(const struct WGPUClient *aClient,
                                    WGPUDeviceId aDeviceId,
                                    WGPUQueueId aQueueId,
                                    WGPUBufferId aDst,
                                    WGPUBufferAddress aOffset,
                                    uintptr_t aDataBufferIndex)
WGPU_FUNC;

WGPU_INLINE
void wgpu_queue_write_buffer_via_shmem(const struct WGPUClient *aClient,
                                       WGPUDeviceId aDeviceId,
                                       WGPUQueueId aQueueId,
                                       WGPUBufferId aDst,
                                       WGPUBufferAddress aOffset,
                                       uintptr_t aShmemHandleIndex)
WGPU_FUNC;

WGPU_INLINE
void wgpu_queue_write_texture_via_shmem(const struct WGPUClient *aClient,
                                        WGPUDeviceId aDeviceId,
                                        WGPUQueueId aQueueId,
                                        struct WGPUTexelCopyTextureInfo_TextureId aDst,
                                        struct WGPUTexelCopyBufferLayout aLayout,
                                        struct WGPUExtent3d aSize,
                                        uintptr_t aShmemHandleIndex)
WGPU_FUNC;

/**
 * Obtain the block size and dimensions for a single aspect.
 *
 * Populates `info` and returns true on success. Returns false if `format` has
 * multiple aspects and `aspect` is `All`.
 */
WGPU_INLINE
bool wgpu_texture_format_get_block_info(struct WGPUTextureFormat aFormat,
                                        enum WGPUTextureAspect aAspect,
                                        struct WGPUTextureFormatBlockInfo *aInfo)
WGPU_FUNC;

WGPU_INLINE
bool wgpu_client_use_shared_texture_in_swapChain(struct WGPUTextureFormat aFormat)
WGPU_FUNC;

WGPU_INLINE
void wgpu_render_bundle_set_bind_group(struct WGPURenderBundleEncoder *aBundle,
                                       uint32_t aIndex,
                                       WGPUOption_BindGroupId aBindGroupId,
                                       const WGPUDynamicOffset *aOffsets,
                                       uintptr_t aOffsetLength)
WGPU_FUNC;

WGPU_INLINE
void wgpu_render_bundle_set_pipeline(struct WGPURenderBundleEncoder *aBundle,
                                     WGPURenderPipelineId aPipelineId)
WGPU_FUNC;

WGPU_INLINE
void wgpu_render_bundle_set_vertex_buffer(struct WGPURenderBundleEncoder *aBundle,
                                          uint32_t aSlot,
                                          WGPUBufferId aBufferId,
                                          WGPUBufferAddress aOffset,
                                          const WGPUBufferSize *aSize)
WGPU_FUNC;

WGPU_INLINE
void wgpu_render_bundle_set_index_buffer(struct WGPURenderBundleEncoder *aEncoder,
                                         WGPUBufferId aBuffer,
                                         enum WGPUIndexFormat aIndexFormat,
                                         WGPUBufferAddress aOffset,
                                         const WGPUBufferSize *aSize)
WGPU_FUNC;

WGPU_INLINE
void wgpu_render_bundle_set_push_constants(struct WGPURenderBundleEncoder *aPass,
                                           WGPUShaderStages aStages,
                                           uint32_t aOffset,
                                           uint32_t aSizeBytes,
                                           const uint8_t *aData)
WGPU_FUNC;

WGPU_INLINE
void wgpu_render_bundle_draw(struct WGPURenderBundleEncoder *aBundle,
                             uint32_t aVertexCount,
                             uint32_t aInstanceCount,
                             uint32_t aFirstVertex,
                             uint32_t aFirstInstance)
WGPU_FUNC;

WGPU_INLINE
void wgpu_render_bundle_draw_indexed(struct WGPURenderBundleEncoder *aBundle,
                                     uint32_t aIndexCount,
                                     uint32_t aInstanceCount,
                                     uint32_t aFirstIndex,
                                     int32_t aBaseVertex,
                                     uint32_t aFirstInstance)
WGPU_FUNC;

WGPU_INLINE
void wgpu_render_bundle_draw_indirect(struct WGPURenderBundleEncoder *aBundle,
                                      WGPUBufferId aBufferId,
                                      WGPUBufferAddress aOffset)
WGPU_FUNC;

WGPU_INLINE
void wgpu_render_bundle_draw_indexed_indirect(struct WGPURenderBundleEncoder *aBundle,
                                              WGPUBufferId aBufferId,
                                              WGPUBufferAddress aOffset)
WGPU_FUNC;

WGPU_INLINE
void wgpu_render_bundle_push_debug_group(struct WGPURenderBundleEncoder *aBundle,
                                         WGPURawString aLabel)
WGPU_FUNC;

WGPU_INLINE
void wgpu_render_bundle_pop_debug_group(struct WGPURenderBundleEncoder *aBundle)
WGPU_FUNC;

WGPU_INLINE
void wgpu_render_bundle_insert_debug_marker(struct WGPURenderBundleEncoder *aBundle,
                                            WGPURawString aLabel)
WGPU_FUNC;

WGPU_INLINE
void wgpu_client_destroy_buffer(const struct WGPUClient *aClient,
                                WGPUBufferId aId)
WGPU_FUNC;

WGPU_INLINE
void wgpu_client_destroy_texture(const struct WGPUClient *aClient,
                                 WGPUTextureId aId)
WGPU_FUNC;

WGPU_INLINE
void wgpu_client_destroy_external_texture(const struct WGPUClient *aClient,
                                          WGPUExternalTextureId aId)
WGPU_FUNC;

WGPU_INLINE
void wgpu_client_destroy_external_texture_source(const struct WGPUClient *aClient,
                                                 WGPUExternalTextureSourceId aId)
WGPU_FUNC;

WGPU_INLINE
void wgpu_client_destroy_device(const struct WGPUClient *aClient,
                                WGPUDeviceId aId)
WGPU_FUNC;

WGPU_INLINE
void wgpu_client_drop_adapter(const struct WGPUClient *aClient,
                              WGPUAdapterId aId)
WGPU_FUNC;

WGPU_INLINE
void wgpu_client_drop_device(const struct WGPUClient *aClient,
                             WGPUDeviceId aId)
WGPU_FUNC;

WGPU_INLINE
void wgpu_client_drop_queue(const struct WGPUClient *aClient,
                            WGPUQueueId aId)
WGPU_FUNC;

WGPU_INLINE
void wgpu_client_drop_buffer(const struct WGPUClient *aClient,
                             WGPUBufferId aId)
WGPU_FUNC;

WGPU_INLINE
void wgpu_client_drop_command_encoder(const struct WGPUClient *aClient,
                                      WGPUCommandEncoderId aId)
WGPU_FUNC;

WGPU_INLINE
void wgpu_client_drop_render_pass_encoder(const struct WGPUClient *aClient,
                                          WGPURenderPassEncoderId aId)
WGPU_FUNC;

WGPU_INLINE
void wgpu_client_drop_compute_pass_encoder(const struct WGPUClient *aClient,
                                           WGPUComputePassEncoderId aId)
WGPU_FUNC;

WGPU_INLINE
void wgpu_client_drop_render_bundle_encoder(const struct WGPUClient *aClient,
                                            WGPURenderBundleEncoderId aId)
WGPU_FUNC;

WGPU_INLINE
void wgpu_client_drop_command_buffer(const struct WGPUClient *aClient,
                                     WGPUCommandBufferId aId)
WGPU_FUNC;

WGPU_INLINE
void wgpu_client_drop_render_bundle(const struct WGPUClient *aClient,
                                    WGPURenderBundleId aId)
WGPU_FUNC;

WGPU_INLINE
void wgpu_client_drop_bind_group_layout(const struct WGPUClient *aClient,
                                        WGPUBindGroupLayoutId aId)
WGPU_FUNC;

WGPU_INLINE
void wgpu_client_drop_pipeline_layout(const struct WGPUClient *aClient,
                                      WGPUPipelineLayoutId aId)
WGPU_FUNC;

WGPU_INLINE
void wgpu_client_drop_bind_group(const struct WGPUClient *aClient,
                                 WGPUBindGroupId aId)
WGPU_FUNC;

WGPU_INLINE
void wgpu_client_drop_shader_module(const struct WGPUClient *aClient,
                                    WGPUShaderModuleId aId)
WGPU_FUNC;

WGPU_INLINE
void wgpu_client_drop_compute_pipeline(const struct WGPUClient *aClient,
                                       WGPUComputePipelineId aId)
WGPU_FUNC;

WGPU_INLINE
void wgpu_client_drop_render_pipeline(const struct WGPUClient *aClient,
                                      WGPURenderPipelineId aId)
WGPU_FUNC;

WGPU_INLINE
void wgpu_client_drop_texture(const struct WGPUClient *aClient,
                              WGPUTextureId aId)
WGPU_FUNC;

WGPU_INLINE
void wgpu_client_drop_texture_view(const struct WGPUClient *aClient,
                                   WGPUTextureViewId aId)
WGPU_FUNC;

WGPU_INLINE
void wgpu_client_drop_external_texture(const struct WGPUClient *aClient,
                                       WGPUExternalTextureId aId)
WGPU_FUNC;

WGPU_INLINE
void wgpu_client_drop_external_texture_source(const struct WGPUClient *aClient,
                                              WGPUExternalTextureSourceId aId)
WGPU_FUNC;

WGPU_INLINE
void wgpu_client_drop_sampler(const struct WGPUClient *aClient,
                              WGPUSamplerId aId)
WGPU_FUNC;

WGPU_INLINE
void wgpu_client_drop_query_set(const struct WGPUClient *aClient,
                                WGPUQuerySetId aId)
WGPU_FUNC;

WGPU_INLINE
void wgpu_recorded_render_pass_set_bind_group(struct WGPURecordedRenderPass *aPass,
                                              uint32_t aIndex,
                                              WGPUOption_BindGroupId aBindGroupId,
                                              struct WGPUFfiSlice_DynamicOffset aOffsets)
WGPU_FUNC;

WGPU_INLINE
void wgpu_recorded_render_pass_set_pipeline(struct WGPURecordedRenderPass *aPass,
                                            WGPURenderPipelineId aPipelineId)
WGPU_FUNC;

WGPU_INLINE
void wgpu_recorded_render_pass_set_vertex_buffer(struct WGPURecordedRenderPass *aPass,
                                                 uint32_t aSlot,
                                                 WGPUBufferId aBufferId,
                                                 WGPUBufferAddress aOffset,
                                                 const WGPUBufferSize *aSize)
WGPU_FUNC;

WGPU_INLINE
void wgpu_recorded_render_pass_set_index_buffer(struct WGPURecordedRenderPass *aPass,
                                                WGPUBufferId aBufferId,
                                                enum WGPUIndexFormat aIndexFormat,
                                                WGPUBufferAddress aOffset,
                                                const WGPUBufferSize *aSize)
WGPU_FUNC;

WGPU_INLINE
void wgpu_recorded_render_pass_set_blend_constant(struct WGPURecordedRenderPass *aPass,
                                                  const struct WGPUColor *aColor)
WGPU_FUNC;

WGPU_INLINE
void wgpu_recorded_render_pass_set_stencil_reference(struct WGPURecordedRenderPass *aPass,
                                                     uint32_t aValue)
WGPU_FUNC;

WGPU_INLINE
void wgpu_recorded_render_pass_set_viewport(struct WGPURecordedRenderPass *aPass,
                                            float aX,
                                            float aY,
                                            float aW,
                                            float aH,
                                            float aDepthMin,
                                            float aDepthMax)
WGPU_FUNC;

WGPU_INLINE
void wgpu_recorded_render_pass_set_scissor_rect(struct WGPURecordedRenderPass *aPass,
                                                uint32_t aX,
                                                uint32_t aY,
                                                uint32_t aW,
                                                uint32_t aH)
WGPU_FUNC;

WGPU_INLINE
void wgpu_recorded_render_pass_draw(struct WGPURecordedRenderPass *aPass,
                                    uint32_t aVertexCount,
                                    uint32_t aInstanceCount,
                                    uint32_t aFirstVertex,
                                    uint32_t aFirstInstance)
WGPU_FUNC;

WGPU_INLINE
void wgpu_recorded_render_pass_draw_indexed(struct WGPURecordedRenderPass *aPass,
                                            uint32_t aIndexCount,
                                            uint32_t aInstanceCount,
                                            uint32_t aFirstIndex,
                                            int32_t aBaseVertex,
                                            uint32_t aFirstInstance)
WGPU_FUNC;

WGPU_INLINE
void wgpu_recorded_render_pass_draw_indirect(struct WGPURecordedRenderPass *aPass,
                                             WGPUBufferId aBufferId,
                                             WGPUBufferAddress aOffset)
WGPU_FUNC;

WGPU_INLINE
void wgpu_recorded_render_pass_draw_indexed_indirect(struct WGPURecordedRenderPass *aPass,
                                                     WGPUBufferId aBufferId,
                                                     WGPUBufferAddress aOffset)
WGPU_FUNC;

WGPU_INLINE
void wgpu_recorded_render_pass_multi_draw_indirect(struct WGPURecordedRenderPass *aPass,
                                                   WGPUBufferId aBufferId,
                                                   WGPUBufferAddress aOffset,
                                                   uint32_t aCount)
WGPU_FUNC;

WGPU_INLINE
void wgpu_recorded_render_pass_multi_draw_indexed_indirect(struct WGPURecordedRenderPass *aPass,
                                                           WGPUBufferId aBufferId,
                                                           WGPUBufferAddress aOffset,
                                                           uint32_t aCount)
WGPU_FUNC;

WGPU_INLINE
void wgpu_recorded_render_pass_multi_draw_indirect_count(struct WGPURecordedRenderPass *aPass,
                                                         WGPUBufferId aBufferId,
                                                         WGPUBufferAddress aOffset,
                                                         WGPUBufferId aCountBufferId,
                                                         WGPUBufferAddress aCountBufferOffset,
                                                         uint32_t aMaxCount)
WGPU_FUNC;

WGPU_INLINE
void wgpu_recorded_render_pass_multi_draw_indexed_indirect_count(struct WGPURecordedRenderPass *aPass,
                                                                 WGPUBufferId aBufferId,
                                                                 WGPUBufferAddress aOffset,
                                                                 WGPUBufferId aCountBufferId,
                                                                 WGPUBufferAddress aCountBufferOffset,
                                                                 uint32_t aMaxCount)
WGPU_FUNC;

/**
 * # Safety
 *
 * This function is unsafe as there is no guarantee that the given `label`
 * is a valid null-terminated string.
 */
WGPU_INLINE
void wgpu_recorded_render_pass_push_debug_group(struct WGPURecordedRenderPass *aPass,
                                                WGPURawString aLabel,
                                                uint32_t aColor)
WGPU_FUNC;

WGPU_INLINE
void wgpu_recorded_render_pass_pop_debug_group(struct WGPURecordedRenderPass *aPass)
WGPU_FUNC;

/**
 * # Safety
 *
 * This function is unsafe as there is no guarantee that the given `label`
 * is a valid null-terminated string.
 */
WGPU_INLINE
void wgpu_recorded_render_pass_insert_debug_marker(struct WGPURecordedRenderPass *aPass,
                                                   WGPURawString aLabel,
                                                   uint32_t aColor)
WGPU_FUNC;

WGPU_INLINE
void wgpu_recorded_render_pass_write_timestamp(struct WGPURecordedRenderPass *aPass,
                                               WGPUQuerySetId aQuerySetId,
                                               uint32_t aQueryIndex)
WGPU_FUNC;

WGPU_INLINE
void wgpu_recorded_render_pass_begin_occlusion_query(struct WGPURecordedRenderPass *aPass,
                                                     uint32_t aQueryIndex)
WGPU_FUNC;

WGPU_INLINE
void wgpu_recorded_render_pass_end_occlusion_query(struct WGPURecordedRenderPass *aPass)
WGPU_FUNC;

WGPU_INLINE
void wgpu_recorded_render_pass_begin_pipeline_statistics_query(struct WGPURecordedRenderPass *aPass,
                                                               WGPUQuerySetId aQuerySetId,
                                                               uint32_t aQueryIndex)
WGPU_FUNC;

WGPU_INLINE
void wgpu_recorded_render_pass_end_pipeline_statistics_query(struct WGPURecordedRenderPass *aPass)
WGPU_FUNC;

WGPU_INLINE
void wgpu_recorded_render_pass_execute_bundles(struct WGPURecordedRenderPass *aPass,
                                               struct WGPUFfiSlice_RenderBundleId aRenderBundles)
WGPU_FUNC;

WGPU_INLINE
void wgpu_recorded_compute_pass_set_bind_group(struct WGPURecordedComputePass *aPass,
                                               uint32_t aIndex,
                                               WGPUOption_BindGroupId aBindGroupId,
                                               struct WGPUFfiSlice_DynamicOffset aOffsets)
WGPU_FUNC;

WGPU_INLINE
void wgpu_recorded_compute_pass_set_pipeline(struct WGPURecordedComputePass *aPass,
                                             WGPUComputePipelineId aPipelineId)
WGPU_FUNC;

WGPU_INLINE
void wgpu_recorded_compute_pass_dispatch_workgroups(struct WGPURecordedComputePass *aPass,
                                                    uint32_t aGroupsX,
                                                    uint32_t aGroupsY,
                                                    uint32_t aGroupsZ)
WGPU_FUNC;

WGPU_INLINE
void wgpu_recorded_compute_pass_dispatch_workgroups_indirect(struct WGPURecordedComputePass *aPass,
                                                             WGPUBufferId aBufferId,
                                                             WGPUBufferAddress aOffset)
WGPU_FUNC;

/**
 * # Safety
 *
 * This function is unsafe as there is no guarantee that the given `label`
 * is a valid null-terminated string.
 */
WGPU_INLINE
void wgpu_recorded_compute_pass_push_debug_group(struct WGPURecordedComputePass *aPass,
                                                 WGPURawString aLabel,
                                                 uint32_t aColor)
WGPU_FUNC;

WGPU_INLINE
void wgpu_recorded_compute_pass_pop_debug_group(struct WGPURecordedComputePass *aPass)
WGPU_FUNC;

/**
 * # Safety
 *
 * This function is unsafe as there is no guarantee that the given `label`
 * is a valid null-terminated string.
 */
WGPU_INLINE
void wgpu_recorded_compute_pass_insert_debug_marker(struct WGPURecordedComputePass *aPass,
                                                    WGPURawString aLabel,
                                                    uint32_t aColor)
WGPU_FUNC;

WGPU_INLINE
void wgpu_recorded_compute_pass_write_timestamp(struct WGPURecordedComputePass *aPass,
                                                WGPUQuerySetId aQuerySetId,
                                                uint32_t aQueryIndex)
WGPU_FUNC;

WGPU_INLINE
void wgpu_recorded_compute_pass_begin_pipeline_statistics_query(struct WGPURecordedComputePass *aPass,
                                                                WGPUQuerySetId aQuerySetId,
                                                                uint32_t aQueryIndex)
WGPU_FUNC;

WGPU_INLINE
void wgpu_recorded_compute_pass_end_pipeline_statistics_query(struct WGPURecordedComputePass *aPass)
WGPU_FUNC;

WGPU_INLINE
struct WGPUGlobal *wgpu_server_new(WGPUWebGPUParentPtr aOwner)
WGPU_FUNC;

/**
 * # Safety
 *
 * This function is unsafe because improper use may lead to memory
 * problems. For example, a double-free may occur if the function is called
 * twice on the same raw pointer.
 */
WGPU_INLINE
void wgpu_server_delete(struct WGPUGlobal *aGlobal)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_poll_all_devices(const struct WGPUGlobal *aGlobal,
                                  bool aForceWait)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_device_poll(const struct WGPUGlobal *aGlobal,
                             WGPUDeviceId aDeviceId,
                             bool aForceWait)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_set_device_lost_callback(const struct WGPUGlobal *aGlobal,
                                          WGPUDeviceId aSelfId,
                                          struct WGPUDeviceLostClosure aClosure)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_device_create_buffer(const struct WGPUGlobal *aGlobal,
                                      WGPUDeviceId aDeviceId,
                                      WGPUBufferId aBufferId,
                                      const nsACString *aLabel,
                                      WGPUBufferAddress aSize,
                                      uint32_t aUsage,
                                      bool aMappedAtCreation,
                                      struct WGPUErrorBuffer aErrorBuf)
WGPU_FUNC;

/**
 * # Safety
 *
 * Callers are responsible for ensuring `closure` is well-formed.
 */
WGPU_INLINE
void wgpu_server_buffer_map(const struct WGPUGlobal *aGlobal,
                            WGPUDeviceId aDeviceId,
                            WGPUBufferId aBufferId,
                            WGPUBufferAddress aStart,
                            WGPUBufferAddress aSize,
                            enum WGPUHostMap aMapMode,
                            struct WGPUBufferMapClosure aClosure,
                            struct WGPUErrorBuffer aErrorBuf)
WGPU_FUNC;

/**
 * # Safety
 *
 * This function is unsafe as there is no guarantee that the given pointer is
 * valid for `size` elements.
 */
WGPU_INLINE
struct WGPUMappedBufferSlice wgpu_server_buffer_get_mapped_range(const struct WGPUGlobal *aGlobal,
                                                                 WGPUDeviceId aDeviceId,
                                                                 WGPUBufferId aBufferId,
                                                                 WGPUBufferAddress aStart,
                                                                 WGPUBufferAddress aSize,
                                                                 struct WGPUErrorBuffer aErrorBuf)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_buffer_unmap(const struct WGPUGlobal *aGlobal,
                              WGPUDeviceId aDeviceId,
                              WGPUBufferId aBufferId,
                              struct WGPUErrorBuffer aErrorBuf)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_device_create_texture(const struct WGPUGlobal *aGlobal,
                                       WGPUDeviceId aDeviceId,
                                       WGPUTextureId aIdIn,
                                       const struct WGPUTextureDescriptor *aDesc,
                                       struct WGPUErrorBuffer aErrorBuf)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_texture_destroy(const struct WGPUGlobal *aGlobal,
                                 WGPUTextureId aId)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_texture_drop(const struct WGPUGlobal *aGlobal,
                              WGPUTextureId aId)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_texture_create_view(const struct WGPUGlobal *aGlobal,
                                     WGPUDeviceId aDeviceId,
                                     WGPUTextureId aTextureId,
                                     WGPUTextureViewId aIdIn,
                                     const struct WGPUTextureViewDescriptor *aDesc,
                                     struct WGPUErrorBuffer aErrorBuf)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_texture_view_drop(const struct WGPUGlobal *aGlobal,
                                   WGPUTextureViewId aId)
WGPU_FUNC;

#if defined(XP_WIN)
WGPU_INLINE
void *wgpu_server_get_device_fence_handle(const struct WGPUGlobal *aGlobal,
                                          WGPUDeviceId aDeviceId)
WGPU_FUNC;
#endif

WGPU_INLINE
struct WGPUVkImageHandle *wgpu_vkimage_create_with_dma_buf(const struct WGPUGlobal *aGlobal,
                                                           WGPUDeviceId aDeviceId,
                                                           uint32_t aWidth,
                                                           uint32_t aHeight,
                                                           uint64_t *aOutMemorySize)
WGPU_FUNC;

WGPU_INLINE
void wgpu_vkimage_destroy(const struct WGPUGlobal *aGlobal,
                          WGPUDeviceId aDeviceId,
                          const struct WGPUVkImageHandle *aHandle)
WGPU_FUNC;

WGPU_INLINE
void wgpu_vkimage_delete(struct WGPUVkImageHandle *aHandle)
WGPU_FUNC;

WGPU_INLINE
int32_t wgpu_vkimage_get_file_descriptor(const struct WGPUGlobal *aGlobal,
                                         WGPUDeviceId aDeviceId,
                                         const struct WGPUVkImageHandle *aHandle)
WGPU_FUNC;

WGPU_INLINE
struct WGPUDMABufInfo wgpu_vkimage_get_dma_buf_info(const struct WGPUVkImageHandle *aHandle)
WGPU_FUNC;

WGPU_INLINE
struct WGPUMetalSharedEventHandle *wgpu_server_get_device_fence_metal_shared_event(const struct WGPUGlobal *aGlobal,
                                                                                   WGPUDeviceId aDeviceId)
WGPU_FUNC;

WGPU_INLINE
uint64_t wgpu_server_metal_shared_event_signaled_value(struct WGPUMetalSharedEventHandle *aSharedEvent)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_delete_metal_shared_event(struct WGPUMetalSharedEventHandle *aSharedEvent)
WGPU_FUNC;

extern void gfx_critical_note(const char *aMsg);

extern bool wgpu_server_use_shared_texture_for_swap_chain(WGPUWebGPUParentPtr aParent,
                                                          struct WGPUSwapChainId aSwapChainId);

extern void wgpu_server_disable_shared_texture_for_swap_chain(WGPUWebGPUParentPtr aParent,
                                                              struct WGPUSwapChainId aSwapChainId);

extern bool wgpu_server_ensure_shared_texture_for_swap_chain(WGPUWebGPUParentPtr aParent,
                                                             struct WGPUSwapChainId aSwapChainId,
                                                             WGPUDeviceId aDeviceId,
                                                             WGPUTextureId aTextureId,
                                                             uint32_t aWidth,
                                                             uint32_t aHeight,
                                                             struct WGPUTextureFormat aFormat,
                                                             WGPUTextureUsages aUsage);

extern void wgpu_server_ensure_shared_texture_for_readback(WGPUWebGPUParentPtr aParent,
                                                           struct WGPUSwapChainId aSwapChainId,
                                                           WGPUDeviceId aDeviceId,
                                                           WGPUTextureId aTextureId,
                                                           uint32_t aWidth,
                                                           uint32_t aHeight,
                                                           struct WGPUTextureFormat aFormat,
                                                           WGPUTextureUsages aUsage);

#if defined(XP_WIN)
extern void *wgpu_server_get_shared_texture_handle(WGPUWebGPUParentPtr aParent,
                                                   WGPUTextureId aId);
#endif

extern const struct WGPUVkImageHandle *wgpu_server_get_vk_image_handle(WGPUWebGPUParentPtr aParent,
                                                                       WGPUTextureId aTextureId);

extern int32_t wgpu_server_get_dma_buf_fd(WGPUWebGPUParentPtr aParent,
                                          WGPUTextureId aId);

#if defined(XP_MACOSX)
extern uint32_t wgpu_server_get_external_io_surface_id(WGPUWebGPUParentPtr aParent,
                                                       WGPUTextureId aId);
#endif

extern void wgpu_server_remove_shared_texture(WGPUWebGPUParentPtr aParent,
                                              WGPUTextureId aId);

extern bool wgpu_parent_is_external_texture_enabled(void);

extern struct WGPUExternalTextureDescriptorFromSource wgpu_parent_external_texture_source_get_external_texture_descriptor(WGPUWebGPUParentPtr aParent,
                                                                                                                          WGPUExternalTextureSourceId aId,
                                                                                                                          enum WGPUPredefinedColorSpace aDestColorSpace);

extern void wgpu_parent_destroy_external_texture_source(WGPUWebGPUParentPtr aParent,
                                                        WGPUExternalTextureSourceId aId);

extern void wgpu_parent_drop_external_texture_source(WGPUWebGPUParentPtr aParent,
                                                     WGPUExternalTextureSourceId aId);

extern void wgpu_server_dealloc_buffer_shmem(WGPUWebGPUParentPtr aParent,
                                             WGPUBufferId aId);

extern void wgpu_server_pre_device_drop(WGPUWebGPUParentPtr aParent,
                                        WGPUDeviceId aId);

extern void wgpu_server_set_buffer_map_data(WGPUWebGPUParentPtr aParent,
                                            WGPUDeviceId aDeviceId,
                                            WGPUBufferId aBufferId,
                                            bool aHasMapFlags,
                                            uint64_t aMappedOffset,
                                            uint64_t aMappedSize,
                                            uintptr_t aShmemIndex);

extern void wgpu_server_device_push_error_scope(WGPUWebGPUParentPtr aParent,
                                                WGPUDeviceId aDeviceId,
                                                uint8_t aFilter);

extern void wgpu_server_device_pop_error_scope(WGPUWebGPUParentPtr aParent,
                                               WGPUDeviceId aDeviceId,
                                               uint8_t *aOutType,
                                               nsCString *aOutMessage);

extern void wgpu_parent_buffer_unmap(WGPUWebGPUParentPtr aParent,
                                     WGPUDeviceId aDeviceId,
                                     WGPUBufferId aBufferId,
                                     bool aFlush);

extern void wgpu_parent_queue_submit(WGPUWebGPUParentPtr aParent,
                                     WGPUDeviceId aDeviceId,
                                     WGPUQueueId aQueueId,
                                     const WGPUCommandBufferId *aCommandBufferIds,
                                     uintptr_t aCommandBufferIdsLength,
                                     const WGPUTextureId *aTextureIds,
                                     uintptr_t aTextureIdsLength,
                                     const WGPUExternalTextureSourceId *aExternalTextureSourceIds,
                                     uintptr_t aExternalTextureSourceIdsLength);

extern void wgpu_parent_create_swap_chain(WGPUWebGPUParentPtr aParent,
                                          WGPUDeviceId aDeviceId,
                                          WGPUQueueId aQueueId,
                                          int32_t aWidth,
                                          int32_t aHeight,
                                          WGPUSurfaceFormat aFormat,
                                          const WGPUBufferId *aBufferIds,
                                          uintptr_t aBufferIdsLength,
                                          WGPURemoteTextureOwnerId aRemoteTextureOwnerId,
                                          bool aUseSharedTextureInSwapChain);

extern void wgpu_parent_swap_chain_present(WGPUWebGPUParentPtr aParent,
                                           WGPUTextureId aTextureId,
                                           WGPUCommandEncoderId aCommandEncoderId,
                                           WGPUCommandBufferId aCommandBufferId,
                                           WGPURemoteTextureId aRemoteTextureId,
                                           WGPURemoteTextureOwnerId aRemoteTextureOwnerId);

extern void wgpu_parent_swap_chain_drop(WGPUWebGPUParentPtr aParent,
                                        WGPURemoteTextureOwnerId aRemoteTextureOwnerId,
                                        WGPURemoteTextureTxnType aTxnType,
                                        WGPURemoteTextureTxnId aTxnId);

#if defined(XP_WIN)
extern void wgpu_parent_get_compositor_device_luid(struct WGPUFfiLUID *aOutLuid);
#endif

extern void wgpu_parent_post_request_device(WGPUWebGPUParentPtr aParent,
                                            WGPUDeviceId aDeviceId);

extern struct WGPUBufferMapClosure wgpu_parent_build_buffer_map_closure(WGPUWebGPUParentPtr aParent,
                                                                        WGPUDeviceId aDeviceId,
                                                                        WGPUBufferId aBufferId,
                                                                        enum WGPUHostMap aMode,
                                                                        uint64_t aOffset,
                                                                        uint64_t aSize);

extern struct WGPUSubmittedWorkDoneClosure wgpu_parent_build_submitted_work_done_closure(WGPUWebGPUParentPtr aParent,
                                                                                         WGPUQueueId aQueueId);

extern void wgpu_parent_handle_error(WGPUWebGPUParentPtr aParent,
                                     WGPUDeviceId aDeviceId,
                                     WGPUErrorBufferType aTy,
                                     const nsCString *aMessage);

extern void wgpu_parent_send_server_message(WGPUWebGPUParentPtr aParent,
                                            struct WGPUByteBuf *aMessage);

WGPU_INLINE
void wgpu_server_pack_buffer_map_success(WGPUBufferId aBufferId,
                                         bool aIsWritable,
                                         uint64_t aOffset,
                                         uint64_t aSize,
                                         struct WGPUByteBuf *aBb)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_pack_buffer_map_error(WGPUBufferId aBufferId,
                                       const nsACString *aError,
                                       struct WGPUByteBuf *aBb)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_pack_work_done(struct WGPUByteBuf *aBb,
                                WGPUQueueId aQueueId)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_messages(const struct WGPUGlobal *aGlobal,
                          uint32_t aNrOfMessages,
                          const struct WGPUByteBuf *aSerializedMessages,
                          struct WGPUFfiSlice_ByteBuf aDataBuffers,
                          struct WGPUFfiSlice_FfiSlice_u8 aShmemMappings)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_device_create_encoder(const struct WGPUGlobal *aGlobal,
                                       WGPUDeviceId aDeviceId,
                                       const struct WGPUCommandEncoderDescriptor *aDesc,
                                       WGPUCommandEncoderId aNewId,
                                       struct WGPUErrorBuffer aErrorBuf)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_encoder_finish(const struct WGPUGlobal *aGlobal,
                                WGPUDeviceId aDeviceId,
                                WGPUCommandEncoderId aCommandEncoderId,
                                WGPUCommandBufferId aCommandBufferId,
                                const struct WGPUCommandBufferDescriptor *aDesc,
                                struct WGPUErrorBuffer aErrorBuf)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_encoder_copy_texture_to_buffer(const struct WGPUGlobal *aGlobal,
                                                WGPUDeviceId aDeviceId,
                                                WGPUCommandEncoderId aSelfId,
                                                const WGPUTexelCopyTextureInfo *aSource,
                                                WGPUBufferId aDstBuffer,
                                                const struct WGPUTexelCopyBufferLayout *aDstLayout,
                                                const struct WGPUExtent3d *aSize,
                                                struct WGPUErrorBuffer aErrorBuf)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_queue_write_texture(const struct WGPUGlobal *aGlobal,
                                     WGPUDeviceId aDeviceId,
                                     WGPUQueueId aQueueId,
                                     const struct WGPUTexelCopyTextureInfo_TextureId *aDestination,
                                     struct WGPUFfiSlice_u8 aData,
                                     const struct WGPUTexelCopyBufferLayout *aDataLayout,
                                     const struct WGPUExtent3d *aSize,
                                     struct WGPUErrorBuffer aErrorBuf)
WGPU_FUNC;

WGPU_INLINE
uint64_t wgpu_server_queue_submit(const struct WGPUGlobal *aGlobal,
                                  WGPUDeviceId aDeviceId,
                                  WGPUQueueId aSelfId,
                                  struct WGPUFfiSlice_CommandBufferId aCommandBuffers,
                                  struct WGPUErrorBuffer aErrorBuf)
WGPU_FUNC;

WGPU_INLINE
struct WGPUVkSemaphoreHandle *wgpu_vksemaphore_create_signal_semaphore(const struct WGPUGlobal *aGlobal,
                                                                       WGPUQueueId aQueueId)
WGPU_FUNC;

WGPU_INLINE
int32_t wgpu_vksemaphore_get_file_descriptor(const struct WGPUGlobal *aGlobal,
                                             WGPUDeviceId aDeviceId,
                                             const struct WGPUVkSemaphoreHandle *aHandle)
WGPU_FUNC;

WGPU_INLINE
void wgpu_vksemaphore_destroy(const struct WGPUGlobal *aGlobal,
                              WGPUDeviceId aDeviceId,
                              const struct WGPUVkSemaphoreHandle *aHandle)
WGPU_FUNC;

WGPU_INLINE
void wgpu_vksemaphore_delete(struct WGPUVkSemaphoreHandle *aHandle)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_buffer_drop(const struct WGPUGlobal *aGlobal,
                             WGPUBufferId aSelfId)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_command_encoder_drop(const struct WGPUGlobal *aGlobal,
                                      WGPUCommandEncoderId aSelfId)
WGPU_FUNC;

WGPU_INLINE
void wgpu_server_command_buffer_drop(const struct WGPUGlobal *aGlobal,
                                     WGPUCommandBufferId aSelfId)
WGPU_FUNC;

#if defined(XP_WIN)
/**
 * Imports a Direct3D texture from a shared handle.
 */
WGPU_INLINE
void wgpu_server_device_import_texture_from_shared_handle(const struct WGPUGlobal *aGlobal,
                                                          WGPUDeviceId aDeviceId,
                                                          WGPUTextureId aIdIn,
                                                          const struct WGPUTextureDescriptor *aDesc,
                                                          void *aHandle,
                                                          struct WGPUErrorBuffer aErrorBuf)
WGPU_FUNC;
#endif

#if defined(XP_WIN)
/**
 * Imports a fence from a shared handle and queues a GPU-side wait on the
 * specified queue for the fence to reach a specific value.
 */
WGPU_INLINE
bool wgpu_server_device_wait_fence_from_shared_handle(const struct WGPUGlobal *aGlobal,
                                                      WGPUDeviceId aDeviceId,
                                                      WGPUQueueId aQueueId,
                                                      void *aFenceHandle,
                                                      WGPUFenceValue aFenceValue)
WGPU_FUNC;
#endif

#if defined(XP_MACOSX)
/**
 * Imports a Metal texture from the specified plane of an IOSurface.
 */
WGPU_INLINE
void wgpu_server_device_import_texture_from_iosurface(const struct WGPUGlobal *aGlobal,
                                                      WGPUDeviceId aDeviceId,
                                                      WGPUTextureId aIdIn,
                                                      const struct WGPUTextureDescriptor *aDesc,
                                                      uint32_t aIoSurfaceId,
                                                      uintptr_t aPlane,
                                                      struct WGPUErrorBuffer aErrorBuf)
WGPU_FUNC;
#endif

/**
 * returns 1 if success. 0 if failure. extension name must be null terminated
 */
extern int emscripten_webgl_enable_extension(int aContext,
                                             const char *aExtension);

extern int emscripten_webgl_get_current_context(void);

extern uint32_t mach_timebase_info(struct WGPUMachTimebaseInfo *aOut);

extern uint64_t mach_absolute_time(void);

#ifdef __cplusplus
}  // extern "C"
#endif  // __cplusplus
