{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- t'GI.Gdk.Objects.DrawingContext.DrawingContext' is an object that represents the current drawing
-- state of a t'GI.Gdk.Objects.Window.Window'.
-- 
-- It\'s possible to use a t'GI.Gdk.Objects.DrawingContext.DrawingContext' to draw on a t'GI.Gdk.Objects.Window.Window'
-- via rendering API like Cairo or OpenGL.
-- 
-- A t'GI.Gdk.Objects.DrawingContext.DrawingContext' can only be created by calling 'GI.Gdk.Objects.Window.windowBeginDrawFrame'
-- and will be valid until a call to 'GI.Gdk.Objects.Window.windowEndDrawFrame'.
-- 
-- t'GI.Gdk.Objects.DrawingContext.DrawingContext' is available since GDK 3.22

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Objects.DrawingContext
    ( 

-- * Exported types
    DrawingContext(..)                      ,
    IsDrawingContext                        ,
    toDrawingContext                        ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isValid]("GI.Gdk.Objects.DrawingContext#g:method:isValid"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getCairoContext]("GI.Gdk.Objects.DrawingContext#g:method:getCairoContext"), [getClip]("GI.Gdk.Objects.DrawingContext#g:method:getClip"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getWindow]("GI.Gdk.Objects.DrawingContext#g:method:getWindow").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveDrawingContextMethod             ,
#endif

-- ** getCairoContext #method:getCairoContext#

#if defined(ENABLE_OVERLOADING)
    DrawingContextGetCairoContextMethodInfo ,
#endif
    drawingContextGetCairoContext           ,


-- ** getClip #method:getClip#

#if defined(ENABLE_OVERLOADING)
    DrawingContextGetClipMethodInfo         ,
#endif
    drawingContextGetClip                   ,


-- ** getWindow #method:getWindow#

#if defined(ENABLE_OVERLOADING)
    DrawingContextGetWindowMethodInfo       ,
#endif
    drawingContextGetWindow                 ,


-- ** isValid #method:isValid#

#if defined(ENABLE_OVERLOADING)
    DrawingContextIsValidMethodInfo         ,
#endif
    drawingContextIsValid                   ,




 -- * Properties


-- ** clip #attr:clip#
-- | The clip region applied to the drawing context.
-- 
-- /Since: 3.22/

#if defined(ENABLE_OVERLOADING)
    DrawingContextClipPropertyInfo          ,
#endif
    constructDrawingContextClip             ,
#if defined(ENABLE_OVERLOADING)
    drawingContextClip                      ,
#endif
    getDrawingContextClip                   ,


-- ** window #attr:window#
-- | The t'GI.Gdk.Objects.Window.Window' that created the drawing context.
-- 
-- /Since: 3.22/

#if defined(ENABLE_OVERLOADING)
    DrawingContextWindowPropertyInfo        ,
#endif
    constructDrawingContextWindow           ,
#if defined(ENABLE_OVERLOADING)
    drawingContextWindow                    ,
#endif
    getDrawingContextWindow                 ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Enums as Cairo.Enums
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.Cairo.Structs.Pattern as Cairo.Pattern
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Callbacks as Gdk.Callbacks
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Objects.AppLaunchContext as Gdk.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceManager as Gdk.DeviceManager
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceTool as Gdk.DeviceTool
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.DragContext as Gdk.DragContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import {-# SOURCE #-} qualified GI.Gdk.Objects.GLContext as Gdk.GLContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Screen as Gdk.Screen
import {-# SOURCE #-} qualified GI.Gdk.Objects.Seat as Gdk.Seat
import {-# SOURCE #-} qualified GI.Gdk.Objects.Visual as Gdk.Visual
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window
import {-# SOURCE #-} qualified GI.Gdk.Structs.Atom as Gdk.Atom
import {-# SOURCE #-} qualified GI.Gdk.Structs.Color as Gdk.Color
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventAny as Gdk.EventAny
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventButton as Gdk.EventButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventConfigure as Gdk.EventConfigure
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventCrossing as Gdk.EventCrossing
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventDND as Gdk.EventDND
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventExpose as Gdk.EventExpose
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventFocus as Gdk.EventFocus
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventGrabBroken as Gdk.EventGrabBroken
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventKey as Gdk.EventKey
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventMotion as Gdk.EventMotion
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventOwnerChange as Gdk.EventOwnerChange
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadAxis as Gdk.EventPadAxis
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadButton as Gdk.EventPadButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadGroupMode as Gdk.EventPadGroupMode
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProperty as Gdk.EventProperty
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProximity as Gdk.EventProximity
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventScroll as Gdk.EventScroll
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSelection as Gdk.EventSelection
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSetting as Gdk.EventSetting
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouch as Gdk.EventTouch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadPinch as Gdk.EventTouchpadPinch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadSwipe as Gdk.EventTouchpadSwipe
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventVisibility as Gdk.EventVisibility
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventWindowState as Gdk.EventWindowState
import {-# SOURCE #-} qualified GI.Gdk.Structs.FrameTimings as Gdk.FrameTimings
import {-# SOURCE #-} qualified GI.Gdk.Structs.Geometry as Gdk.Geometry
import {-# SOURCE #-} qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gdk.Structs.WindowAttr as Gdk.WindowAttr
import {-# SOURCE #-} qualified GI.Gdk.Unions.Event as Gdk.Event
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext

#else
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window

#endif

-- | Memory-managed wrapper type.
newtype DrawingContext = DrawingContext (SP.ManagedPtr DrawingContext)
    deriving (Eq)

instance SP.ManagedPtrNewtype DrawingContext where
    toManagedPtr (DrawingContext p) = p

foreign import ccall "gdk_drawing_context_get_type"
    c_gdk_drawing_context_get_type :: IO B.Types.GType

instance B.Types.TypedObject DrawingContext where
    glibType = c_gdk_drawing_context_get_type

instance B.Types.GObject DrawingContext

-- | Type class for types which can be safely cast to t'DrawingContext', for instance with `toDrawingContext`.
class (SP.GObject o, O.IsDescendantOf DrawingContext o) => IsDrawingContext o
instance (SP.GObject o, O.IsDescendantOf DrawingContext o) => IsDrawingContext o

instance O.HasParentTypes DrawingContext
type instance O.ParentTypes DrawingContext = '[GObject.Object.Object]

-- | Cast to t'DrawingContext', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toDrawingContext :: (MIO.MonadIO m, IsDrawingContext o) => o -> m DrawingContext
toDrawingContext = MIO.liftIO . B.ManagedPtr.unsafeCastTo DrawingContext

-- | Convert t'DrawingContext' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe DrawingContext) where
    gvalueGType_ = c_gdk_drawing_context_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr DrawingContext)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr DrawingContext)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject DrawingContext ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveDrawingContextMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveDrawingContextMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveDrawingContextMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveDrawingContextMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveDrawingContextMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveDrawingContextMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveDrawingContextMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveDrawingContextMethod "isValid" o = DrawingContextIsValidMethodInfo
    ResolveDrawingContextMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveDrawingContextMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveDrawingContextMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveDrawingContextMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveDrawingContextMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveDrawingContextMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveDrawingContextMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveDrawingContextMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveDrawingContextMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveDrawingContextMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveDrawingContextMethod "getCairoContext" o = DrawingContextGetCairoContextMethodInfo
    ResolveDrawingContextMethod "getClip" o = DrawingContextGetClipMethodInfo
    ResolveDrawingContextMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveDrawingContextMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveDrawingContextMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveDrawingContextMethod "getWindow" o = DrawingContextGetWindowMethodInfo
    ResolveDrawingContextMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveDrawingContextMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveDrawingContextMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveDrawingContextMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveDrawingContextMethod t DrawingContext, O.OverloadedMethod info DrawingContext p) => OL.IsLabel t (DrawingContext -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveDrawingContextMethod t DrawingContext, O.OverloadedMethod info DrawingContext p, R.HasField t DrawingContext p) => R.HasField t DrawingContext p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveDrawingContextMethod t DrawingContext, O.OverloadedMethodInfo info DrawingContext) => OL.IsLabel t (O.MethodProxy info DrawingContext) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "clip"
   -- Type: TInterface (Name {namespace = "cairo", name = "Region"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@clip@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' drawingContext #clip
-- @
getDrawingContextClip :: (MonadIO m, IsDrawingContext o) => o -> m (Maybe Cairo.Region.Region)
getDrawingContextClip obj = MIO.liftIO $ B.Properties.getObjectPropertyBoxed obj "clip" Cairo.Region.Region

-- | Construct a t'GValueConstruct' with valid value for the “@clip@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructDrawingContextClip :: (IsDrawingContext o, MIO.MonadIO m) => Cairo.Region.Region -> m (GValueConstruct o)
constructDrawingContextClip val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBoxed "clip" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data DrawingContextClipPropertyInfo
instance AttrInfo DrawingContextClipPropertyInfo where
    type AttrAllowedOps DrawingContextClipPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint DrawingContextClipPropertyInfo = IsDrawingContext
    type AttrSetTypeConstraint DrawingContextClipPropertyInfo = (~) Cairo.Region.Region
    type AttrTransferTypeConstraint DrawingContextClipPropertyInfo = (~) Cairo.Region.Region
    type AttrTransferType DrawingContextClipPropertyInfo = Cairo.Region.Region
    type AttrGetType DrawingContextClipPropertyInfo = (Maybe Cairo.Region.Region)
    type AttrLabel DrawingContextClipPropertyInfo = "clip"
    type AttrOrigin DrawingContextClipPropertyInfo = DrawingContext
    attrGet = getDrawingContextClip
    attrSet = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructDrawingContextClip
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.DrawingContext.clip"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-DrawingContext.html#g:attr:clip"
        })
#endif

-- VVV Prop "window"
   -- Type: TInterface (Name {namespace = "Gdk", name = "Window"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@window@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' drawingContext #window
-- @
getDrawingContextWindow :: (MonadIO m, IsDrawingContext o) => o -> m Gdk.Window.Window
getDrawingContextWindow obj = MIO.liftIO $ checkUnexpectedNothing "getDrawingContextWindow" $ B.Properties.getObjectPropertyObject obj "window" Gdk.Window.Window

-- | Construct a t'GValueConstruct' with valid value for the “@window@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructDrawingContextWindow :: (IsDrawingContext o, MIO.MonadIO m, Gdk.Window.IsWindow a) => a -> m (GValueConstruct o)
constructDrawingContextWindow val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "window" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data DrawingContextWindowPropertyInfo
instance AttrInfo DrawingContextWindowPropertyInfo where
    type AttrAllowedOps DrawingContextWindowPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint DrawingContextWindowPropertyInfo = IsDrawingContext
    type AttrSetTypeConstraint DrawingContextWindowPropertyInfo = Gdk.Window.IsWindow
    type AttrTransferTypeConstraint DrawingContextWindowPropertyInfo = Gdk.Window.IsWindow
    type AttrTransferType DrawingContextWindowPropertyInfo = Gdk.Window.Window
    type AttrGetType DrawingContextWindowPropertyInfo = Gdk.Window.Window
    type AttrLabel DrawingContextWindowPropertyInfo = "window"
    type AttrOrigin DrawingContextWindowPropertyInfo = DrawingContext
    attrGet = getDrawingContextWindow
    attrSet = undefined
    attrTransfer _ v = do
        unsafeCastTo Gdk.Window.Window v
    attrConstruct = constructDrawingContextWindow
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.DrawingContext.window"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-DrawingContext.html#g:attr:window"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList DrawingContext
type instance O.AttributeList DrawingContext = DrawingContextAttributeList
type DrawingContextAttributeList = ('[ '("clip", DrawingContextClipPropertyInfo), '("window", DrawingContextWindowPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
drawingContextClip :: AttrLabelProxy "clip"
drawingContextClip = AttrLabelProxy

drawingContextWindow :: AttrLabelProxy "window"
drawingContextWindow = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList DrawingContext = DrawingContextSignalList
type DrawingContextSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method DrawingContext::get_cairo_context
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "DrawingContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "cairo" , name = "Context" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_drawing_context_get_cairo_context" gdk_drawing_context_get_cairo_context :: 
    Ptr DrawingContext ->                   -- context : TInterface (Name {namespace = "Gdk", name = "DrawingContext"})
    IO (Ptr Cairo.Context.Context)

-- | Retrieves a Cairo context to be used to draw on the t'GI.Gdk.Objects.Window.Window'
-- that created the t'GI.Gdk.Objects.DrawingContext.DrawingContext'.
-- 
-- The returned context is guaranteed to be valid as long as the
-- t'GI.Gdk.Objects.DrawingContext.DrawingContext' is valid, that is between a call to
-- 'GI.Gdk.Objects.Window.windowBeginDrawFrame' and 'GI.Gdk.Objects.Window.windowEndDrawFrame'.
-- 
-- /Since: 3.22/
drawingContextGetCairoContext ::
    (B.CallStack.HasCallStack, MonadIO m, IsDrawingContext a) =>
    a
    -> m Cairo.Context.Context
    -- ^ __Returns:__ a Cairo context to be used to draw
    --   the contents of the t'GI.Gdk.Objects.Window.Window'. The context is owned by the
    --   t'GI.Gdk.Objects.DrawingContext.DrawingContext' and should not be destroyed
drawingContextGetCairoContext context = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    result <- gdk_drawing_context_get_cairo_context context'
    checkUnexpectedReturnNULL "drawingContextGetCairoContext" result
    result' <- (newBoxed Cairo.Context.Context) result
    touchManagedPtr context
    return result'

#if defined(ENABLE_OVERLOADING)
data DrawingContextGetCairoContextMethodInfo
instance (signature ~ (m Cairo.Context.Context), MonadIO m, IsDrawingContext a) => O.OverloadedMethod DrawingContextGetCairoContextMethodInfo a signature where
    overloadedMethod = drawingContextGetCairoContext

instance O.OverloadedMethodInfo DrawingContextGetCairoContextMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.DrawingContext.drawingContextGetCairoContext",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-DrawingContext.html#v:drawingContextGetCairoContext"
        })


#endif

-- method DrawingContext::get_clip
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "DrawingContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDrawingContext"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "cairo" , name = "Region" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_drawing_context_get_clip" gdk_drawing_context_get_clip :: 
    Ptr DrawingContext ->                   -- context : TInterface (Name {namespace = "Gdk", name = "DrawingContext"})
    IO (Ptr Cairo.Region.Region)

-- | Retrieves a copy of the clip region used when creating the /@context@/.
-- 
-- /Since: 3.22/
drawingContextGetClip ::
    (B.CallStack.HasCallStack, MonadIO m, IsDrawingContext a) =>
    a
    -- ^ /@context@/: a t'GI.Gdk.Objects.DrawingContext.DrawingContext'
    -> m (Maybe Cairo.Region.Region)
    -- ^ __Returns:__ a Cairo region
drawingContextGetClip context = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    result <- gdk_drawing_context_get_clip context'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapBoxed Cairo.Region.Region) result'
        return result''
    touchManagedPtr context
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data DrawingContextGetClipMethodInfo
instance (signature ~ (m (Maybe Cairo.Region.Region)), MonadIO m, IsDrawingContext a) => O.OverloadedMethod DrawingContextGetClipMethodInfo a signature where
    overloadedMethod = drawingContextGetClip

instance O.OverloadedMethodInfo DrawingContextGetClipMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.DrawingContext.drawingContextGetClip",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-DrawingContext.html#v:drawingContextGetClip"
        })


#endif

-- method DrawingContext::get_window
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "DrawingContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDrawingContext"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Window" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_drawing_context_get_window" gdk_drawing_context_get_window :: 
    Ptr DrawingContext ->                   -- context : TInterface (Name {namespace = "Gdk", name = "DrawingContext"})
    IO (Ptr Gdk.Window.Window)

-- | Retrieves the window that created the drawing /@context@/.
-- 
-- /Since: 3.22/
drawingContextGetWindow ::
    (B.CallStack.HasCallStack, MonadIO m, IsDrawingContext a) =>
    a
    -- ^ /@context@/: a t'GI.Gdk.Objects.DrawingContext.DrawingContext'
    -> m Gdk.Window.Window
    -- ^ __Returns:__ a t'GI.Gdk.Objects.Window.Window'
drawingContextGetWindow context = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    result <- gdk_drawing_context_get_window context'
    checkUnexpectedReturnNULL "drawingContextGetWindow" result
    result' <- (newObject Gdk.Window.Window) result
    touchManagedPtr context
    return result'

#if defined(ENABLE_OVERLOADING)
data DrawingContextGetWindowMethodInfo
instance (signature ~ (m Gdk.Window.Window), MonadIO m, IsDrawingContext a) => O.OverloadedMethod DrawingContextGetWindowMethodInfo a signature where
    overloadedMethod = drawingContextGetWindow

instance O.OverloadedMethodInfo DrawingContextGetWindowMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.DrawingContext.drawingContextGetWindow",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-DrawingContext.html#v:drawingContextGetWindow"
        })


#endif

-- method DrawingContext::is_valid
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "DrawingContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GdkDrawingContext"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_drawing_context_is_valid" gdk_drawing_context_is_valid :: 
    Ptr DrawingContext ->                   -- context : TInterface (Name {namespace = "Gdk", name = "DrawingContext"})
    IO CInt

-- | Checks whether the given t'GI.Gdk.Objects.DrawingContext.DrawingContext' is valid.
-- 
-- /Since: 3.22/
drawingContextIsValid ::
    (B.CallStack.HasCallStack, MonadIO m, IsDrawingContext a) =>
    a
    -- ^ /@context@/: a t'GI.Gdk.Objects.DrawingContext.DrawingContext'
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the context is valid
drawingContextIsValid context = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    result <- gdk_drawing_context_is_valid context'
    let result' = (/= 0) result
    touchManagedPtr context
    return result'

#if defined(ENABLE_OVERLOADING)
data DrawingContextIsValidMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsDrawingContext a) => O.OverloadedMethod DrawingContextIsValidMethodInfo a signature where
    overloadedMethod = drawingContextIsValid

instance O.OverloadedMethodInfo DrawingContextIsValidMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.DrawingContext.drawingContextIsValid",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Objects-DrawingContext.html#v:drawingContextIsValid"
        })


#endif


