// this file was auto-generated by internal/cmd/gentypes/main.go: DO NOT EDIT

package jwa

import (
	"fmt"
	"sort"
	"sync"

	"github.com/pkg/errors"
)

// ContentEncryptionAlgorithm represents the various encryption algorithms as described in https://tools.ietf.org/html/rfc7518#section-5
type ContentEncryptionAlgorithm string

// Supported values for ContentEncryptionAlgorithm
const (
	A128CBC_HS256 ContentEncryptionAlgorithm = "A128CBC-HS256" // AES-CBC + HMAC-SHA256 (128)
	A128GCM       ContentEncryptionAlgorithm = "A128GCM"       // AES-GCM (128)
	A192CBC_HS384 ContentEncryptionAlgorithm = "A192CBC-HS384" // AES-CBC + HMAC-SHA384 (192)
	A192GCM       ContentEncryptionAlgorithm = "A192GCM"       // AES-GCM (192)
	A256CBC_HS512 ContentEncryptionAlgorithm = "A256CBC-HS512" // AES-CBC + HMAC-SHA512 (256)
	A256GCM       ContentEncryptionAlgorithm = "A256GCM"       // AES-GCM (256)
)

var allContentEncryptionAlgorithms = map[ContentEncryptionAlgorithm]struct{}{
	A128CBC_HS256: {},
	A128GCM:       {},
	A192CBC_HS384: {},
	A192GCM:       {},
	A256CBC_HS512: {},
	A256GCM:       {},
}

var listContentEncryptionAlgorithmOnce sync.Once
var listContentEncryptionAlgorithm []ContentEncryptionAlgorithm

// ContentEncryptionAlgorithms returns a list of all available values for ContentEncryptionAlgorithm
func ContentEncryptionAlgorithms() []ContentEncryptionAlgorithm {
	listContentEncryptionAlgorithmOnce.Do(func() {
		listContentEncryptionAlgorithm = make([]ContentEncryptionAlgorithm, 0, len(allContentEncryptionAlgorithms))
		for v := range allContentEncryptionAlgorithms {
			listContentEncryptionAlgorithm = append(listContentEncryptionAlgorithm, v)
		}
		sort.Slice(listContentEncryptionAlgorithm, func(i, j int) bool {
			return string(listContentEncryptionAlgorithm[i]) < string(listContentEncryptionAlgorithm[j])
		})
	})
	return listContentEncryptionAlgorithm
}

// Accept is used when conversion from values given by
// outside sources (such as JSON payloads) is required
func (v *ContentEncryptionAlgorithm) Accept(value interface{}) error {
	var tmp ContentEncryptionAlgorithm
	if x, ok := value.(ContentEncryptionAlgorithm); ok {
		tmp = x
	} else {
		var s string
		switch x := value.(type) {
		case fmt.Stringer:
			s = x.String()
		case string:
			s = x
		default:
			return errors.Errorf(`invalid type for jwa.ContentEncryptionAlgorithm: %T`, value)
		}
		tmp = ContentEncryptionAlgorithm(s)
	}
	if _, ok := allContentEncryptionAlgorithms[tmp]; !ok {
		return errors.Errorf(`invalid jwa.ContentEncryptionAlgorithm value`)
	}

	*v = tmp
	return nil
}

// String returns the string representation of a ContentEncryptionAlgorithm
func (v ContentEncryptionAlgorithm) String() string {
	return string(v)
}
