
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kcoreaddons_python.h"

// main header
#include "kjobtrackerinterface_wrapper.h"

// Wrappers providing overrides
#include "kjobtrackerinterface_wrapper.h"
#include "ksignalhandler_wrapper.h"
#include "kjobuidelegate_wrapper.h"

// Argument includes
#include <QString>
#include <kjob.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <utility>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KJobTrackerInterface_Type = nullptr;
static PyTypeObject *Sbk_KJobTrackerInterface_TypeF(void)
{
    return _Sbk_KJobTrackerInterface_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KJobTrackerInterfaceWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KJobTrackerInterfaceWrapper::KJobTrackerInterfaceWrapper(::QObject * parent) : KJobTrackerInterface(parent)
{
}

void KJobTrackerInterfaceWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KJobTrackerInterface_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KSignalHandlerWrapper::sbk_o_childEvent("KJobTrackerInterface", funcName, gil, pyOverride, event);
}

void KJobTrackerInterfaceWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KJobTrackerInterface_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KSignalHandlerWrapper::sbk_o_connectNotify("KJobTrackerInterface", funcName, gil, pyOverride, signal);
}

void KJobTrackerInterfaceWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KJobTrackerInterface_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KSignalHandlerWrapper::sbk_o_customEvent("KJobTrackerInterface", funcName, gil, pyOverride, event);
}

void KJobTrackerInterfaceWrapper::description(::KJob * job, const ::QString & title, const ::std::pair<QString,QString> & field1, const ::std::pair<QString,QString> & field2)
{
    static const char *funcName = "description";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KJobTrackerInterface_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::KJobTrackerInterface::description(job, title, field1, field2);
    }
    sbk_o_description("KJobTrackerInterface", funcName, gil, pyOverride, job, title, field1, field2);
}

void KJobTrackerInterfaceWrapper::sbk_o_description(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::KJob * job, const ::QString & title, const ::std::pair<QString,QString> & field1, const ::std::pair<QString,QString> & field2)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[4] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), job),
        Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &title),
        Shiboken::Conversions::copyToPython(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_std_pair_QString_QString_IDX], &field1),
        Shiboken::Conversions::copyToPython(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_std_pair_QString_QString_IDX], &field2)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNNN)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), job),
        Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &title),
        Shiboken::Conversions::copyToPython(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_std_pair_QString_QString_IDX], &field1),
        Shiboken::Conversions::copyToPython(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_std_pair_QString_QString_IDX], &field2)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 4, nullptr));
    Py_DECREF(pyArgArray[0]);
    Py_DECREF(pyArgArray[1]);
    Py_DECREF(pyArgArray[2]);
    Py_DECREF(pyArgArray[3]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

void KJobTrackerInterfaceWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KJobTrackerInterface_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KSignalHandlerWrapper::sbk_o_connectNotify("KJobTrackerInterface", funcName, gil, pyOverride, signal);
}

bool KJobTrackerInterfaceWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KJobTrackerInterface_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::event(event);
    }
    return KSignalHandlerWrapper::sbk_o_event("KJobTrackerInterface", funcName, gil, pyOverride, event);
}

bool KJobTrackerInterfaceWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KJobTrackerInterface_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return KSignalHandlerWrapper::sbk_o_eventFilter("KJobTrackerInterface", funcName, gil, pyOverride, watched, event);
}

void KJobTrackerInterfaceWrapper::finished(::KJob * job)
{
    static const char *funcName = "finished";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KJobTrackerInterface_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::KJobTrackerInterface::finished(job);
    }
    sbk_o_finished("KJobTrackerInterface", funcName, gil, pyOverride, job);
}

void KJobTrackerInterfaceWrapper::sbk_o_finished(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::KJob * job)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), job)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), job)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

void KJobTrackerInterfaceWrapper::infoMessage(::KJob * job, const ::QString & message)
{
    static const char *funcName = "infoMessage";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KJobTrackerInterface_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::KJobTrackerInterface::infoMessage(job, message);
    }
    KJobUiDelegateWrapper::sbk_o_slotWarning("KJobTrackerInterface", funcName, gil, pyOverride, job, message);
}

void KJobTrackerInterfaceWrapper::percent(::KJob * job, unsigned long percent)
{
    static const char *funcName = "percent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KJobTrackerInterface_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::KJobTrackerInterface::percent(job, percent);
    }
    sbk_o_percent("KJobTrackerInterface", funcName, gil, pyOverride, job, percent);
}

void KJobTrackerInterfaceWrapper::sbk_o_percent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::KJob * job, unsigned long percent)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[2] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), job),
        Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), &percent)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), job),
        Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), &percent)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 2, nullptr));
    Py_DECREF(pyArgArray[0]);
    Py_DECREF(pyArgArray[1]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

void KJobTrackerInterfaceWrapper::processedAmount(::KJob * job, ::KJob::Unit unit, qulonglong amount)
{
    static const char *funcName = "processedAmount";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KJobTrackerInterface_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::KJobTrackerInterface::processedAmount(job, unit, amount);
    }
    sbk_o_processedAmount("KJobTrackerInterface", funcName, gil, pyOverride, job, unit, amount);
}

void KJobTrackerInterfaceWrapper::sbk_o_processedAmount(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::KJob * job, ::KJob::Unit unit, qulonglong amount)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[3] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), job),
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_Unit_IDX])))->converter, &unit),
        Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qulonglong>(), &amount)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNK)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), job),
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_Unit_IDX])))->converter, &unit),
        amount
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 3, nullptr));
    Py_DECREF(pyArgArray[0]);
    Py_DECREF(pyArgArray[1]);
    Py_DECREF(pyArgArray[2]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

void KJobTrackerInterfaceWrapper::registerJob(::KJob * job)
{
    static const char *funcName = "registerJob";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KJobTrackerInterface_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::KJobTrackerInterface::registerJob(job);
    }
    KJobTrackerInterfaceWrapper::sbk_o_finished("KJobTrackerInterface", funcName, gil, pyOverride, job);
}

void KJobTrackerInterfaceWrapper::resumed(::KJob * job)
{
    static const char *funcName = "resumed";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KJobTrackerInterface_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::KJobTrackerInterface::resumed(job);
    }
    KJobTrackerInterfaceWrapper::sbk_o_finished("KJobTrackerInterface", funcName, gil, pyOverride, job);
}

void KJobTrackerInterfaceWrapper::speed(::KJob * job, unsigned long value)
{
    static const char *funcName = "speed";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KJobTrackerInterface_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::KJobTrackerInterface::speed(job, value);
    }
    KJobTrackerInterfaceWrapper::sbk_o_percent("KJobTrackerInterface", funcName, gil, pyOverride, job, value);
}

void KJobTrackerInterfaceWrapper::suspended(::KJob * job)
{
    static const char *funcName = "suspended";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KJobTrackerInterface_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::KJobTrackerInterface::suspended(job);
    }
    KJobTrackerInterfaceWrapper::sbk_o_finished("KJobTrackerInterface", funcName, gil, pyOverride, job);
}

void KJobTrackerInterfaceWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KJobTrackerInterface_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KSignalHandlerWrapper::sbk_o_timerEvent("KJobTrackerInterface", funcName, gil, pyOverride, event);
}

void KJobTrackerInterfaceWrapper::totalAmount(::KJob * job, ::KJob::Unit unit, qulonglong amount)
{
    static const char *funcName = "totalAmount";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KJobTrackerInterface_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::KJobTrackerInterface::totalAmount(job, unit, amount);
    }
    KJobTrackerInterfaceWrapper::sbk_o_processedAmount("KJobTrackerInterface", funcName, gil, pyOverride, job, unit, amount);
}

void KJobTrackerInterfaceWrapper::unregisterJob(::KJob * job)
{
    static const char *funcName = "unregisterJob";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KJobTrackerInterface_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::KJobTrackerInterface::unregisterJob(job);
    }
    KJobTrackerInterfaceWrapper::sbk_o_finished("KJobTrackerInterface", funcName, gil, pyOverride, job);
}

void KJobTrackerInterfaceWrapper::warning(::KJob * job, const ::QString & message)
{
    static const char *funcName = "warning";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KJobTrackerInterface_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::KJobTrackerInterface::warning(job, message);
    }
    KJobUiDelegateWrapper::sbk_o_slotWarning("KJobTrackerInterface", funcName, gil, pyOverride, job, message);
}

const QMetaObject *KJobTrackerInterfaceWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KJobTrackerInterface::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KJobTrackerInterfaceWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KJobTrackerInterface::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KJobTrackerInterfaceWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KJobTrackerInterfaceWrapper *>(this));
    }
    return KJobTrackerInterface::qt_metacast(_clname);
}

KJobTrackerInterfaceWrapper::~KJobTrackerInterfaceWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KJobTrackerInterface_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KJobTrackerInterface_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KJobTrackerInterface >()))
        return -1;

    KJobTrackerInterfaceWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:KJobTrackerInterface", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KJobTrackerInterface::KJobTrackerInterface(QObject*=)
    if (numArgs == 0) {
        overloadId = 0; // KJobTrackerInterface(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KJobTrackerInterface(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KJobTrackerInterface_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKCoreAddonsTypeStructs[SBK_KJobTrackerInterface_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KJobTrackerInterface_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // KJobTrackerInterface(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) KJobTrackerInterfaceWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new KJobTrackerInterfaceWrapper(cppArg0);
            }

        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KJobTrackerInterface >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KJobTrackerInterface_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KJobTrackerInterface_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KJobTrackerInterfaceFunc_description(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KJobTrackerInterface *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJobTrackerInterface_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[4];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "description", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KJobTrackerInterface::description(KJob*,QString,std::pair<QString,QString>,std::pair<QString,QString>)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_std_pair_QString_QString_IDX], (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_std_pair_QString_QString_IDX], (pyArgs[3])))) {
        overloadId = 0; // description(KJob*,QString,std::pair<QString,QString>,std::pair<QString,QString>)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "description", errInfo, SbkKCoreAddonsTypeStructs[SBK_KJobTrackerInterface_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::KJob *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        std::pair<QString,QString> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        std::pair<QString,QString> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (Shiboken::Errors::occurred() == nullptr) {
            // description(KJob*,QString,std::pair<QString,QString>,std::pair<QString,QString>)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KJobTrackerInterface::description(cppArg0, cppArg1, cppArg2, cppArg3)
                : cppSelf->description(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KJobTrackerInterfaceFunc_finished(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KJobTrackerInterface *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJobTrackerInterface_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KJobTrackerInterface::finished(KJob*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArg)))) {
        overloadId = 0; // finished(KJob*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "finished", errInfo, SbkKCoreAddonsTypeStructs[SBK_KJobTrackerInterface_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::KJob *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // finished(KJob*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KJobTrackerInterface::finished(cppArg0)
                : cppSelf->finished(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KJobTrackerInterfaceFunc_infoMessage(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KJobTrackerInterface *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJobTrackerInterface_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "infoMessage", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KJobTrackerInterface::infoMessage(KJob*,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        overloadId = 0; // infoMessage(KJob*,QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "infoMessage", errInfo, SbkKCoreAddonsTypeStructs[SBK_KJobTrackerInterface_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::KJob *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // infoMessage(KJob*,QString)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KJobTrackerInterface::infoMessage(cppArg0, cppArg1)
                : cppSelf->infoMessage(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KJobTrackerInterfaceFunc_percent(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KJobTrackerInterface *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJobTrackerInterface_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "percent", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KJobTrackerInterface::percent(KJob*,ulong)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), (pyArgs[1])))) {
        overloadId = 0; // percent(KJob*,ulong)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "percent", errInfo, SbkKCoreAddonsTypeStructs[SBK_KJobTrackerInterface_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::KJob *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned long cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // percent(KJob*,ulong)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KJobTrackerInterface::percent(cppArg0, cppArg1)
                : cppSelf->percent(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KJobTrackerInterfaceFunc_processedAmount(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KJobTrackerInterface *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJobTrackerInterface_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "processedAmount", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KJobTrackerInterface::processedAmount(KJob*,KJob::Unit,qulonglong)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_Unit_IDX])))->converter, (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qulonglong>(), (pyArgs[2])))) {
        overloadId = 0; // processedAmount(KJob*,KJob::Unit,qulonglong)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "processedAmount", errInfo, SbkKCoreAddonsTypeStructs[SBK_KJobTrackerInterface_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::KJob *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::KJob::Unit cppArg1{KJob::Bytes};
        pythonToCpp[1](pyArgs[1], &cppArg1);
        qulonglong cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // processedAmount(KJob*,KJob::Unit,qulonglong)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KJobTrackerInterface::processedAmount(cppArg0, cppArg1, cppArg2)
                : cppSelf->processedAmount(cppArg0, cppArg1, cppArg2);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KJobTrackerInterfaceFunc_registerJob(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KJobTrackerInterface *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJobTrackerInterface_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KJobTrackerInterface::registerJob(KJob*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArg)))) {
        overloadId = 0; // registerJob(KJob*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "registerJob", errInfo, SbkKCoreAddonsTypeStructs[SBK_KJobTrackerInterface_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::KJob *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // registerJob(KJob*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KJobTrackerInterface::registerJob(cppArg0)
                : cppSelf->registerJob(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KJobTrackerInterfaceFunc_resumed(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KJobTrackerInterface *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJobTrackerInterface_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KJobTrackerInterface::resumed(KJob*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArg)))) {
        overloadId = 0; // resumed(KJob*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "resumed", errInfo, SbkKCoreAddonsTypeStructs[SBK_KJobTrackerInterface_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::KJob *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // resumed(KJob*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KJobTrackerInterface::resumed(cppArg0)
                : cppSelf->resumed(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KJobTrackerInterfaceFunc_speed(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KJobTrackerInterface *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJobTrackerInterface_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "speed", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KJobTrackerInterface::speed(KJob*,ulong)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long>(), (pyArgs[1])))) {
        overloadId = 0; // speed(KJob*,ulong)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "speed", errInfo, SbkKCoreAddonsTypeStructs[SBK_KJobTrackerInterface_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::KJob *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned long cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // speed(KJob*,ulong)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KJobTrackerInterface::speed(cppArg0, cppArg1)
                : cppSelf->speed(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KJobTrackerInterfaceFunc_suspended(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KJobTrackerInterface *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJobTrackerInterface_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KJobTrackerInterface::suspended(KJob*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArg)))) {
        overloadId = 0; // suspended(KJob*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "suspended", errInfo, SbkKCoreAddonsTypeStructs[SBK_KJobTrackerInterface_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::KJob *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // suspended(KJob*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KJobTrackerInterface::suspended(cppArg0)
                : cppSelf->suspended(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KJobTrackerInterfaceFunc_totalAmount(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KJobTrackerInterface *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJobTrackerInterface_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "totalAmount", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KJobTrackerInterface::totalAmount(KJob*,KJob::Unit,qulonglong)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_Unit_IDX])))->converter, (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qulonglong>(), (pyArgs[2])))) {
        overloadId = 0; // totalAmount(KJob*,KJob::Unit,qulonglong)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "totalAmount", errInfo, SbkKCoreAddonsTypeStructs[SBK_KJobTrackerInterface_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::KJob *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::KJob::Unit cppArg1{KJob::Bytes};
        pythonToCpp[1](pyArgs[1], &cppArg1);
        qulonglong cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // totalAmount(KJob*,KJob::Unit,qulonglong)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KJobTrackerInterface::totalAmount(cppArg0, cppArg1, cppArg2)
                : cppSelf->totalAmount(cppArg0, cppArg1, cppArg2);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KJobTrackerInterfaceFunc_unregisterJob(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KJobTrackerInterface *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJobTrackerInterface_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KJobTrackerInterface::unregisterJob(KJob*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArg)))) {
        overloadId = 0; // unregisterJob(KJob*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "unregisterJob", errInfo, SbkKCoreAddonsTypeStructs[SBK_KJobTrackerInterface_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::KJob *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // unregisterJob(KJob*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KJobTrackerInterface::unregisterJob(cppArg0)
                : cppSelf->unregisterJob(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KJobTrackerInterfaceFunc_warning(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KJobTrackerInterface *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJobTrackerInterface_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "warning", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KJobTrackerInterface::warning(KJob*,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        overloadId = 0; // warning(KJob*,QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "warning", errInfo, SbkKCoreAddonsTypeStructs[SBK_KJobTrackerInterface_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::KJob *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // warning(KJob*,QString)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KJobTrackerInterface::warning(cppArg0, cppArg1)
                : cppSelf->warning(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_KJobTrackerInterface_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KJobTrackerInterface_methods[] = {
    {"description", reinterpret_cast<PyCFunction>(Sbk_KJobTrackerInterfaceFunc_description), METH_VARARGS, nullptr},
    {"finished", reinterpret_cast<PyCFunction>(Sbk_KJobTrackerInterfaceFunc_finished), METH_O, nullptr},
    {"infoMessage", reinterpret_cast<PyCFunction>(Sbk_KJobTrackerInterfaceFunc_infoMessage), METH_VARARGS, nullptr},
    {"percent", reinterpret_cast<PyCFunction>(Sbk_KJobTrackerInterfaceFunc_percent), METH_VARARGS, nullptr},
    {"processedAmount", reinterpret_cast<PyCFunction>(Sbk_KJobTrackerInterfaceFunc_processedAmount), METH_VARARGS, nullptr},
    {"registerJob", reinterpret_cast<PyCFunction>(Sbk_KJobTrackerInterfaceFunc_registerJob), METH_O, nullptr},
    {"resumed", reinterpret_cast<PyCFunction>(Sbk_KJobTrackerInterfaceFunc_resumed), METH_O, nullptr},
    {"speed", reinterpret_cast<PyCFunction>(Sbk_KJobTrackerInterfaceFunc_speed), METH_VARARGS, nullptr},
    {"suspended", reinterpret_cast<PyCFunction>(Sbk_KJobTrackerInterfaceFunc_suspended), METH_O, nullptr},
    {"totalAmount", reinterpret_cast<PyCFunction>(Sbk_KJobTrackerInterfaceFunc_totalAmount), METH_VARARGS, nullptr},
    {"unregisterJob", reinterpret_cast<PyCFunction>(Sbk_KJobTrackerInterfaceFunc_unregisterJob), METH_O, nullptr},
    {"warning", reinterpret_cast<PyCFunction>(Sbk_KJobTrackerInterfaceFunc_warning), METH_VARARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KJobTrackerInterface_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KJobTrackerInterface *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJobTrackerInterface_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KJobTrackerInterfaceWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KJobTrackerInterface_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KJobTrackerInterface_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KJobTrackerInterface_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KJobTrackerInterface_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KJobTrackerInterface_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KJobTrackerInterface_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KJobTrackerInterface_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KJobTrackerInterface_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KJobTrackerInterface_spec = {
    "1:KCoreAddons.KJobTrackerInterface",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KJobTrackerInterface_slots
};

} //extern "C"

static void *Sbk_KJobTrackerInterface_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KJobTrackerInterface *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KJobTrackerInterface_PythonToCpp_KJobTrackerInterface_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KJobTrackerInterface_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KJobTrackerInterface_PythonToCpp_KJobTrackerInterface_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KJobTrackerInterface_TypeF()))
        return KJobTrackerInterface_PythonToCpp_KJobTrackerInterface_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KJobTrackerInterface_PTR_CppToPython_KJobTrackerInterface(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KJobTrackerInterface *>(const_cast<void *>(cppIn)), Sbk_KJobTrackerInterface_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KJobTrackerInterface_SignatureStrings[] = {
    "KCoreAddons.KJobTrackerInterface(self,parent:PySide6.QtCore.QObject=nullptr)",
    "KCoreAddons.KJobTrackerInterface.description(self,job:KCoreAddons.KJob,title:QString,field1:std.pair[QString, QString],field2:std.pair[QString, QString])",
    "KCoreAddons.KJobTrackerInterface.finished(self,job:KCoreAddons.KJob)",
    "KCoreAddons.KJobTrackerInterface.infoMessage(self,job:KCoreAddons.KJob,message:QString)",
    "KCoreAddons.KJobTrackerInterface.percent(self,job:KCoreAddons.KJob,percent:unsigned long)",
    "KCoreAddons.KJobTrackerInterface.processedAmount(self,job:KCoreAddons.KJob,unit:KCoreAddons.KJob.Unit,amount:qulonglong)",
    "KCoreAddons.KJobTrackerInterface.registerJob(self,job:KCoreAddons.KJob)",
    "KCoreAddons.KJobTrackerInterface.resumed(self,job:KCoreAddons.KJob)",
    "KCoreAddons.KJobTrackerInterface.speed(self,job:KCoreAddons.KJob,value:unsigned long)",
    "KCoreAddons.KJobTrackerInterface.suspended(self,job:KCoreAddons.KJob)",
    "KCoreAddons.KJobTrackerInterface.totalAmount(self,job:KCoreAddons.KJob,unit:KCoreAddons.KJob.Unit,amount:qulonglong)",
    "KCoreAddons.KJobTrackerInterface.unregisterJob(self,job:KCoreAddons.KJob)",
    "KCoreAddons.KJobTrackerInterface.warning(self,job:KCoreAddons.KJob,message:QString)",
    nullptr}; // Sentinel
#else
static constexpr size_t KJobTrackerInterface_SignatureByteSize = 278;
static constexpr uint8_t KJobTrackerInterface_SignatureBytes[278] = {
    0x78, 0xda, 0xbd, 0x93, 0xb1, 0x4e, 0xc4, 0x30, 0x0c, 0x86, 0x77, 0x9e, 0xe2, 0x46, 0x90, 0xaa,
    0x48, 0x30, 0x30, 0x44, 0x62, 0x38, 0x31, 0x41, 0x85, 0xa0, 0x3a, 0x98, 0x10, 0x43, 0xda, 0xb8,
    0xc5, 0x47, 0xea, 0x04, 0xc7, 0x01, 0xf1, 0xf6, 0xe4, 0xe8, 0xdd, 0x02, 0xa2, 0xf4, 0xd4, 0x13,
    0x5b, 0xe2, 0xfc, 0xfe, 0xfc, 0xc7, 0x4e, 0xca, 0x4b, 0xcf, 0xb0, 0xb4, 0xd6, 0x53, 0x54, 0xe5,
    0xb5, 0xaf, 0xef, 0xd9, 0x34, 0x2f, 0xc0, 0x57, 0x24, 0xc0, 0xad, 0x69, 0xe0, 0x38, 0x82, 0x6b,
    0x8b, 0x60, 0x18, 0x48, 0xf4, 0xdd, 0xc7, 0x0a, 0x2d, 0x9c, 0xab, 0x4a, 0x36, 0x59, 0xaa, 0xba,
    0xad, 0xd7, 0xd0, 0xc8, 0x05, 0x25, 0xe7, 0x82, 0xf0, 0xc9, 0x51, 0xf9, 0x07, 0x4c, 0x59, 0x88,
    0x0d, 0x63, 0x10, 0xf4, 0x34, 0x80, 0xd7, 0xbe, 0xd6, 0xdf, 0xb3, 0x0a, 0x41, 0x71, 0xa0, 0xab,
    0x95, 0x30, 0x52, 0x57, 0xb4, 0x08, 0xce, 0x9e, 0xea, 0x28, 0x56, 0x05, 0x83, 0xfc, 0xb8, 0x8b,
    0x2f, 0xb6, 0x8b, 0xa7, 0x41, 0x71, 0x36, 0xa2, 0x98, 0xe0, 0xac, 0x45, 0xc2, 0xf8, 0x0c, 0xf6,
    0x77, 0x5b, 0x13, 0x20, 0x48, 0xad, 0xbf, 0x81, 0x18, 0x4d, 0x07, 0x23, 0xd7, 0xeb, 0x07, 0xc5,
    0xee, 0x82, 0x13, 0xb8, 0x01, 0xb8, 0xc9, 0xfd, 0x1f, 0x61, 0x6e, 0x15, 0x3a, 0x51, 0xc4, 0x8e,
    0xc0, 0x2e, 0x9c, 0x9f, 0x46, 0x66, 0xdf, 0x64, 0x3b, 0x60, 0x97, 0xbd, 0x4f, 0xa3, 0x15, 0x12,
    0xa1, 0xfc, 0x88, 0xaa, 0x87, 0x1c, 0x2d, 0xcc, 0x57, 0xae, 0x7e, 0x4d, 0x9b, 0xa2, 0x13, 0x0b,
    0x33, 0x74, 0x18, 0xf3, 0x26, 0x9f, 0xcd, 0x6a, 0x39, 0x43, 0x4c, 0xfd, 0xcc, 0xb1, 0xc5, 0x00,
    0x63, 0x84, 0xe2, 0xcd, 0xb8, 0x04, 0x7b, 0xb7, 0x36, 0xa6, 0xcc, 0x25, 0x3b, 0xd3, 0x9b, 0x78,
    0x31, 0xee, 0xbf, 0x87, 0x93, 0xe8, 0x50, 0xe3, 0x79, 0x37, 0x4c, 0xf9, 0x8d, 0xef, 0xf3, 0x1b,
    0x3e, 0x01, 0x71, 0x52, 0xac, 0xb6
};
#endif

PyTypeObject *init_KJobTrackerInterface(PyObject *module)
{
    if (SbkKCoreAddonsTypeStructs[SBK_KJobTrackerInterface_IDX].type != nullptr)
        return SbkKCoreAddonsTypeStructs[SBK_KJobTrackerInterface_IDX].type;

    Shiboken::AutoDecRef Sbk_KJobTrackerInterface_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))));

    _Sbk_KJobTrackerInterface_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KJobTrackerInterface",
        "KJobTrackerInterface*",
        &Sbk_KJobTrackerInterface_spec,
        &Shiboken::callCppDestructor< KJobTrackerInterface >,
        Sbk_KJobTrackerInterface_Type_bases.object(),
        0);
    auto *pyType = Sbk_KJobTrackerInterface_TypeF(); // references _Sbk_KJobTrackerInterface_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KJobTrackerInterface_SignatureStrings);
#else
    InitSignatureBytes(pyType, KJobTrackerInterface_SignatureBytes, KJobTrackerInterface_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KJobTrackerInterface_PropertyStrings);
    SbkKCoreAddonsTypeStructs[SBK_KJobTrackerInterface_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KJobTrackerInterface_PythonToCpp_KJobTrackerInterface_PTR,
        is_KJobTrackerInterface_PythonToCpp_KJobTrackerInterface_PTR_Convertible,
        KJobTrackerInterface_PTR_CppToPython_KJobTrackerInterface);

    Shiboken::Conversions::registerConverterName(converter, "KJobTrackerInterface");
    Shiboken::Conversions::registerConverterName(converter, "KJobTrackerInterface*");
    Shiboken::Conversions::registerConverterName(converter, "KJobTrackerInterface&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KJobTrackerInterface).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KJobTrackerInterfaceWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KJobTrackerInterface_TypeF(), &Sbk_KJobTrackerInterface_typeDiscovery);

    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KJobTrackerInterface::staticMetaObject, sizeof(KJobTrackerInterfaceWrapper));

    return pyType;
}
