
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kxmlgui_python.h"

// main header
#include "kactioncollection_wrapper.h"

// Wrappers providing overrides
#include "kxmlguifactory_wrapper.h"
#include "kshortcutsdialog_wrapper.h"

// Argument includes
#include <QList>
#include <QString>
#include <kactioncollection.h>
#include <kxmlguiclient.h>
#include <qaction.h>
#include <qcoreevent.h>
#include <qkeysequence.h>
#include <qmetaobject.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qwidget.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KActionCollection_Type = nullptr;
static PyTypeObject *Sbk_KActionCollection_TypeF(void)
{
    return _Sbk_KActionCollection_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KActionCollectionWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KActionCollectionWrapper::KActionCollectionWrapper(::QObject * parent, const ::QString & cName) : KActionCollection(parent, cName)
{
}

void KActionCollectionWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionCollection_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KXMLGUIFactoryWrapper::sbk_o_childEvent("KActionCollection", funcName, gil, pyOverride, event);
}

void KActionCollectionWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionCollection_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::KActionCollection::connectNotify(signal);
    }
    KXMLGUIFactoryWrapper::sbk_o_connectNotify("KActionCollection", funcName, gil, pyOverride, signal);
}

void KActionCollectionWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionCollection_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KXMLGUIFactoryWrapper::sbk_o_customEvent("KActionCollection", funcName, gil, pyOverride, event);
}

void KActionCollectionWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionCollection_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXMLGUIFactoryWrapper::sbk_o_connectNotify("KActionCollection", funcName, gil, pyOverride, signal);
}

bool KActionCollectionWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionCollection_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::event(event);
    }
    return KXMLGUIFactoryWrapper::sbk_o_event("KActionCollection", funcName, gil, pyOverride, event);
}

bool KActionCollectionWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionCollection_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return KXMLGUIFactoryWrapper::sbk_o_eventFilter("KActionCollection", funcName, gil, pyOverride, watched, event);
}

void KActionCollectionWrapper::slotActionTriggered()
{
    static const char *funcName = "slotActionTriggered";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionCollection_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::KActionCollection::slotActionTriggered();
    }
    KShortcutsDialogWrapper::sbk_o_accept("KActionCollection", funcName, gil, pyOverride);
}

void KActionCollectionWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KActionCollection_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KXMLGUIFactoryWrapper::sbk_o_timerEvent("KActionCollection", funcName, gil, pyOverride, event);
}

const QMetaObject *KActionCollectionWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KActionCollection::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KActionCollectionWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KActionCollection::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KActionCollectionWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KActionCollectionWrapper *>(this));
    }
    return KActionCollection::qt_metacast(_clname);
}

KActionCollectionWrapper::~KActionCollectionWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KActionCollection_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KActionCollection_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KActionCollection >()))
        return -1;

    KActionCollectionWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|OO:KActionCollection", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KActionCollection::KActionCollection(QObject*,const QString&=)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // KActionCollection(QObject*,QString)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
            overloadId = 0; // KActionCollection(QObject*,QString)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"cName", 1}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1 = QString();
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // KActionCollection(QObject*,QString)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) KActionCollectionWrapper(cppArg0, cppArg1);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new KActionCollectionWrapper(cppArg0, cppArg1);
            }

        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KActionCollection >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KActionCollectionFunc_action(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KActionCollection *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KActionCollection::action(QString)const->QAction*
    // 1: KActionCollection::action(int)const->QAction*
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 1; // action(int)const
    } else if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // action(QString)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "action", errInfo, SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // action(const QString &name) const
        {
            ::QString cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // action(QString)const
                QAction * cppResult = const_cast<const ::KActionCollection *>(cppSelf)->action(cppArg0);
                pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), cppResult);
            }
            break;
        }
        case 1: // action(int index) const
        {
            int cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // action(int)const
                QAction * cppResult = const_cast<const ::KActionCollection *>(cppSelf)->action(cppArg0);
                pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), cppResult);
            }
            break;
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KActionCollectionFunc_actionGroups(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KActionCollection *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // actionGroups()const
        const QList<QActionGroup*> cppResult = const_cast<const ::KActionCollection *>(cppSelf)->actionGroups();
        pyResult = Shiboken::Conversions::copyToPython(SbkKXmlGuiTypeConverters[SBK_KXmlGui_QList_QActionGroupPTR_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KActionCollectionFunc_actions(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KActionCollection *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // actions()const
        QList<QAction*> cppResult = const_cast<const ::KActionCollection *>(cppSelf)->actions();
        pyResult = Shiboken::Conversions::copyToPython(SbkKXmlGuiTypeConverters[SBK_KXmlGui_QList_QActionPTR_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KActionCollectionFunc_actionsWithoutGroup(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KActionCollection *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // actionsWithoutGroup()const
        const QList<QAction*> cppResult = const_cast<const ::KActionCollection *>(cppSelf)->actionsWithoutGroup();
        pyResult = Shiboken::Conversions::copyToPython(SbkKXmlGuiTypeConverters[SBK_KXmlGui_QList_QActionPTR_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KActionCollectionFunc_addAction(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KActionCollection *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 3));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "addAction", errInfo, SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]);

    if (PyArg_ParseTuple(args, "|OOO:addAction", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KActionCollection::addAction(QString,QAction*)->QAction*
    // 1: KActionCollection::addAction(QString,const QObject*=,const char*=)->QAction*
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // addAction(QString,const QObject*,const char*)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), (pyArgs[1])))) {
            overloadId = 0; // addAction(QString,QAction*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 1; // addAction(QString,const QObject*,const char*)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[2])))) {
                overloadId = 1; // addAction(QString,const QObject*,const char*)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "addAction", errInfo, SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // addAction(const QString &name, QAction *action)
        {
            if (kwds != nullptr && PyDict_Size(kwds) > 0) {
                errInfo.reset(kwds);
                Py_INCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "addAction", errInfo, SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]);
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QAction *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // addAction(QString,QAction*)
                QAction * cppResult = cppSelf->addAction(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), cppResult);
            }
            break;
        }
        case 1: // addAction(const QString &name, const QObject *receiver, const char *member)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[2] = {{"receiver", 1}, {"member", 2}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 2, errInfo, pyArgs)
                    || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[1]))))
                    || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[2]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments(args, "addAction", errInfo, SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]);
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QObject *cppArg1 = nullptr;
            if (pythonToCpp[1])
                pythonToCpp[1](pyArgs[1], &cppArg1);
            const char* cppArg2 = nullptr;
            if (pythonToCpp[2])
                pythonToCpp[2](pyArgs[2], &cppArg2);

            if (Shiboken::Errors::occurred() == nullptr) {
                // addAction(QString,const QObject*,const char*)
                QAction * cppResult = cppSelf->addAction(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), cppResult);
            }
            break;
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KActionCollectionFunc_addActions(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KActionCollection *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KActionCollection::addActions(QList<QAction*>)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkKXmlGuiTypeConverters[SBK_KXmlGui_QList_QActionPTR_IDX], (pyArg)))) {
        overloadId = 0; // addActions(QList<QAction*>)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "addActions", errInfo, SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]);

    // Call function/method
    {
        ::QList<QAction*> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // addActions(QList<QAction*>)
            cppSelf->addActions(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KActionCollectionFunc_addAssociatedWidget(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KActionCollection *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KActionCollection::addAssociatedWidget(QWidget*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArg)))) {
        overloadId = 0; // addAssociatedWidget(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "addAssociatedWidget", errInfo, SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // addAssociatedWidget(QWidget*)
            cppSelf->addAssociatedWidget(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KActionCollectionFunc_allCollections(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // allCollections()
        const QList<KActionCollection*> & cppResult = ::KActionCollection::allCollections();
        pyResult = Shiboken::Conversions::copyToPython(SbkKXmlGuiTypeConverters[SBK_KXmlGui_QList_KActionCollectionPTR_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KActionCollectionFunc_associateWidget(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KActionCollection *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KActionCollection::associateWidget(QWidget*)const
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArg)))) {
        overloadId = 0; // associateWidget(QWidget*)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "associateWidget", errInfo, SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // associateWidget(QWidget*)const
            const_cast<const ::KActionCollection *>(cppSelf)->associateWidget(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KActionCollectionFunc_associatedWidgets(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KActionCollection *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // associatedWidgets()const
        QList<QWidget*> cppResult = const_cast<const ::KActionCollection *>(cppSelf)->associatedWidgets();
        pyResult = Shiboken::Conversions::copyToPython(SbkKXmlGuiTypeConverters[SBK_KXmlGui_QList_QWidgetPTR_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KActionCollectionFunc_clear(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KActionCollection *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // clear()
        cppSelf->clear();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KActionCollectionFunc_clearAssociatedWidgets(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KActionCollection *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // clearAssociatedWidgets()
        cppSelf->clearAssociatedWidgets();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KActionCollectionFunc_componentDisplayName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KActionCollection *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // componentDisplayName()const
        QString cppResult = const_cast<const ::KActionCollection *>(cppSelf)->componentDisplayName();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KActionCollectionFunc_componentName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KActionCollection *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // componentName()const
        QString cppResult = const_cast<const ::KActionCollection *>(cppSelf)->componentName();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KActionCollectionFunc_configGroup(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KActionCollection *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // configGroup()const
        QString cppResult = const_cast<const ::KActionCollection *>(cppSelf)->configGroup();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KActionCollectionFunc_configIsGlobal(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KActionCollection *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // configIsGlobal()const
        bool cppResult = const_cast<const ::KActionCollection *>(cppSelf)->configIsGlobal();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KActionCollectionFunc_connectNotify(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KActionCollection *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QObject::connectNotify(QMetaMethod)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QMetaMethod_IDX]), (pyArg)))) {
        overloadId = 0; // connectNotify(QMetaMethod)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "connectNotify", errInfo, SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMetaMethod cppArg0_local;
        ::QMetaMethod *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // connectNotify(QMetaMethod)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KActionCollection::connectNotify(*cppArg0)
                : cppSelf->connectNotify(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KActionCollectionFunc_count(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KActionCollection *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // count()const
        int cppResult = const_cast<const ::KActionCollection *>(cppSelf)->count();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KActionCollectionFunc_defaultShortcut(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static KActionCollection::defaultShortcut(QAction*)->QKeySequence
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), (pyArg)))) {
        overloadId = 0; // defaultShortcut(QAction*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "defaultShortcut", errInfo, SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QAction *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // defaultShortcut(QAction*)
            QKeySequence cppResult = ::KActionCollection::defaultShortcut(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QKeySequence_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KActionCollectionFunc_defaultShortcuts(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static KActionCollection::defaultShortcuts(QAction*)->QList<QKeySequence>
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), (pyArg)))) {
        overloadId = 0; // defaultShortcuts(QAction*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "defaultShortcuts", errInfo, SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QAction *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // defaultShortcuts(QAction*)
            QList<QKeySequence> cppResult = ::KActionCollection::defaultShortcuts(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkKXmlGuiTypeConverters[SBK_KXmlGui_QList_QKeySequence_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KActionCollectionFunc_isEmpty(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KActionCollection *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isEmpty()const
        bool cppResult = const_cast<const ::KActionCollection *>(cppSelf)->isEmpty();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KActionCollectionFunc_isShortcutsConfigurable(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static KActionCollection::isShortcutsConfigurable(QAction*)->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), (pyArg)))) {
        overloadId = 0; // isShortcutsConfigurable(QAction*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "isShortcutsConfigurable", errInfo, SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QAction *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // isShortcutsConfigurable(QAction*)
            bool cppResult = ::KActionCollection::isShortcutsConfigurable(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KActionCollectionFunc_parentGUIClient(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KActionCollection *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // parentGUIClient()const
        const KXMLGUIClient * cppResult = const_cast<const ::KActionCollection *>(cppSelf)->parentGUIClient();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KXMLGUIClient_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KActionCollectionFunc_readSettings(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KActionCollection *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // readSettings()
        cppSelf->readSettings();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KActionCollectionFunc_removeAction(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KActionCollection *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KActionCollection::removeAction(QAction*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), (pyArg)))) {
        overloadId = 0; // removeAction(QAction*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "removeAction", errInfo, SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QAction *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // removeAction(QAction*)
            cppSelf->removeAction(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KActionCollectionFunc_removeAssociatedWidget(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KActionCollection *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KActionCollection::removeAssociatedWidget(QWidget*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArg)))) {
        overloadId = 0; // removeAssociatedWidget(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "removeAssociatedWidget", errInfo, SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // removeAssociatedWidget(QWidget*)
            cppSelf->removeAssociatedWidget(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KActionCollectionFunc_setComponentDisplayName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KActionCollection *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KActionCollection::setComponentDisplayName(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setComponentDisplayName(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setComponentDisplayName", errInfo, SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setComponentDisplayName(QString)
            cppSelf->setComponentDisplayName(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KActionCollectionFunc_setComponentName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KActionCollection *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KActionCollection::setComponentName(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setComponentName(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setComponentName", errInfo, SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setComponentName(QString)
            cppSelf->setComponentName(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KActionCollectionFunc_setConfigGlobal(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KActionCollection *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KActionCollection::setConfigGlobal(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setConfigGlobal(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setConfigGlobal", errInfo, SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setConfigGlobal(bool)
            cppSelf->setConfigGlobal(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KActionCollectionFunc_setConfigGroup(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KActionCollection *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KActionCollection::setConfigGroup(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setConfigGroup(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setConfigGroup", errInfo, SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setConfigGroup(QString)
            cppSelf->setConfigGroup(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KActionCollectionFunc_setDefaultShortcut(PyObject *self, PyObject *args)
{
    SBK_UNUSED(self)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "setDefaultShortcut", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KActionCollection::setDefaultShortcut(QAction*,QKeySequence)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QKeySequence_IDX]), (pyArgs[1])))) {
        overloadId = 0; // setDefaultShortcut(QAction*,QKeySequence)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setDefaultShortcut", errInfo, SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QAction *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QKeySequence cppArg1_local;
        ::QKeySequence *cppArg1 = &cppArg1_local;
        if (pythonToCpp[1].isValue())
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setDefaultShortcut(QAction*,QKeySequence)
            ::KActionCollection::setDefaultShortcut(cppArg0, *cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KActionCollectionFunc_setDefaultShortcuts(PyObject *self, PyObject *args)
{
    SBK_UNUSED(self)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "setDefaultShortcuts", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KActionCollection::setDefaultShortcuts(QAction*,QList<QKeySequence>)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkKXmlGuiTypeConverters[SBK_KXmlGui_QList_QKeySequence_IDX], (pyArgs[1])))) {
        overloadId = 0; // setDefaultShortcuts(QAction*,QList<QKeySequence>)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setDefaultShortcuts", errInfo, SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QAction *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QList<QKeySequence> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setDefaultShortcuts(QAction*,QList<QKeySequence>)
            ::KActionCollection::setDefaultShortcuts(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KActionCollectionFunc_setShortcutsConfigurable(PyObject *self, PyObject *args)
{
    SBK_UNUSED(self)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "setShortcutsConfigurable", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KActionCollection::setShortcutsConfigurable(QAction*,bool)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
        overloadId = 0; // setShortcutsConfigurable(QAction*,bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setShortcutsConfigurable", errInfo, SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QAction *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        bool cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setShortcutsConfigurable(QAction*,bool)
            ::KActionCollection::setShortcutsConfigurable(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KActionCollectionFunc_slotActionTriggered(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KActionCollection *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // slotActionTriggered()
        Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? cppSelf->::KActionCollection::slotActionTriggered()
            : cppSelf->slotActionTriggered();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KActionCollectionFunc_takeAction(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KActionCollection *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KActionCollection::takeAction(QAction*)->QAction*
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), (pyArg)))) {
        overloadId = 0; // takeAction(QAction*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "takeAction", errInfo, SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QAction *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // takeAction(QAction*)
            QAction * cppResult = cppSelf->takeAction(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KActionCollectionFunc_writeSettings(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KActionCollection *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // writeSettings()const
        const_cast<const ::KActionCollection *>(cppSelf)->writeSettings();
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_KActionCollection_PropertyStrings[] = {
    "configGroup::",
    "configIsGlobal::setConfigGlobal",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KActionCollection_methods[] = {
    {"action", reinterpret_cast<PyCFunction>(Sbk_KActionCollectionFunc_action), METH_O, nullptr},
    {"actionGroups", reinterpret_cast<PyCFunction>(Sbk_KActionCollectionFunc_actionGroups), METH_NOARGS, nullptr},
    {"actions", reinterpret_cast<PyCFunction>(Sbk_KActionCollectionFunc_actions), METH_NOARGS, nullptr},
    {"actionsWithoutGroup", reinterpret_cast<PyCFunction>(Sbk_KActionCollectionFunc_actionsWithoutGroup), METH_NOARGS, nullptr},
    {"addAction", reinterpret_cast<PyCFunction>(Sbk_KActionCollectionFunc_addAction), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"addActions", reinterpret_cast<PyCFunction>(Sbk_KActionCollectionFunc_addActions), METH_O, nullptr},
    {"addAssociatedWidget", reinterpret_cast<PyCFunction>(Sbk_KActionCollectionFunc_addAssociatedWidget), METH_O, nullptr},
    {"allCollections", reinterpret_cast<PyCFunction>(Sbk_KActionCollectionFunc_allCollections), METH_NOARGS|METH_STATIC, nullptr},
    {"associateWidget", reinterpret_cast<PyCFunction>(Sbk_KActionCollectionFunc_associateWidget), METH_O, nullptr},
    {"associatedWidgets", reinterpret_cast<PyCFunction>(Sbk_KActionCollectionFunc_associatedWidgets), METH_NOARGS, nullptr},
    {"clear", reinterpret_cast<PyCFunction>(Sbk_KActionCollectionFunc_clear), METH_NOARGS, nullptr},
    {"clearAssociatedWidgets", reinterpret_cast<PyCFunction>(Sbk_KActionCollectionFunc_clearAssociatedWidgets), METH_NOARGS, nullptr},
    {"componentDisplayName", reinterpret_cast<PyCFunction>(Sbk_KActionCollectionFunc_componentDisplayName), METH_NOARGS, nullptr},
    {"componentName", reinterpret_cast<PyCFunction>(Sbk_KActionCollectionFunc_componentName), METH_NOARGS, nullptr},
    {"configGroup", reinterpret_cast<PyCFunction>(Sbk_KActionCollectionFunc_configGroup), METH_NOARGS, nullptr},
    {"configIsGlobal", reinterpret_cast<PyCFunction>(Sbk_KActionCollectionFunc_configIsGlobal), METH_NOARGS, nullptr},
    {"connectNotify", reinterpret_cast<PyCFunction>(Sbk_KActionCollectionFunc_connectNotify), METH_O, nullptr},
    {"count", reinterpret_cast<PyCFunction>(Sbk_KActionCollectionFunc_count), METH_NOARGS, nullptr},
    {"defaultShortcut", reinterpret_cast<PyCFunction>(Sbk_KActionCollectionFunc_defaultShortcut), METH_O|METH_STATIC, nullptr},
    {"defaultShortcuts", reinterpret_cast<PyCFunction>(Sbk_KActionCollectionFunc_defaultShortcuts), METH_O|METH_STATIC, nullptr},
    {"isEmpty", reinterpret_cast<PyCFunction>(Sbk_KActionCollectionFunc_isEmpty), METH_NOARGS, nullptr},
    {"isShortcutsConfigurable", reinterpret_cast<PyCFunction>(Sbk_KActionCollectionFunc_isShortcutsConfigurable), METH_O|METH_STATIC, nullptr},
    {"parentGUIClient", reinterpret_cast<PyCFunction>(Sbk_KActionCollectionFunc_parentGUIClient), METH_NOARGS, nullptr},
    {"readSettings", reinterpret_cast<PyCFunction>(Sbk_KActionCollectionFunc_readSettings), METH_NOARGS, nullptr},
    {"removeAction", reinterpret_cast<PyCFunction>(Sbk_KActionCollectionFunc_removeAction), METH_O, nullptr},
    {"removeAssociatedWidget", reinterpret_cast<PyCFunction>(Sbk_KActionCollectionFunc_removeAssociatedWidget), METH_O, nullptr},
    {"setComponentDisplayName", reinterpret_cast<PyCFunction>(Sbk_KActionCollectionFunc_setComponentDisplayName), METH_O, nullptr},
    {"setComponentName", reinterpret_cast<PyCFunction>(Sbk_KActionCollectionFunc_setComponentName), METH_O, nullptr},
    {"setConfigGlobal", reinterpret_cast<PyCFunction>(Sbk_KActionCollectionFunc_setConfigGlobal), METH_O, nullptr},
    {"setConfigGroup", reinterpret_cast<PyCFunction>(Sbk_KActionCollectionFunc_setConfigGroup), METH_O, nullptr},
    {"setDefaultShortcut", reinterpret_cast<PyCFunction>(Sbk_KActionCollectionFunc_setDefaultShortcut), METH_VARARGS|METH_STATIC, nullptr},
    {"setDefaultShortcuts", reinterpret_cast<PyCFunction>(Sbk_KActionCollectionFunc_setDefaultShortcuts), METH_VARARGS|METH_STATIC, nullptr},
    {"setShortcutsConfigurable", reinterpret_cast<PyCFunction>(Sbk_KActionCollectionFunc_setShortcutsConfigurable), METH_VARARGS|METH_STATIC, nullptr},
    {"slotActionTriggered", reinterpret_cast<PyCFunction>(Sbk_KActionCollectionFunc_slotActionTriggered), METH_NOARGS, nullptr},
    {"takeAction", reinterpret_cast<PyCFunction>(Sbk_KActionCollectionFunc_takeAction), METH_O, nullptr},
    {"writeSettings", reinterpret_cast<PyCFunction>(Sbk_KActionCollectionFunc_writeSettings), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KActionCollection_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KActionCollection *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KActionCollectionWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KActionCollection_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KActionCollection_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KActionCollection_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KActionCollection_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KActionCollection_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KActionCollection_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KActionCollection_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KActionCollection_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KActionCollection_spec = {
    "1:KXmlGui.KActionCollection",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KActionCollection_slots
};

} //extern "C"

static void *Sbk_KActionCollection_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KActionCollection *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KActionCollection_PythonToCpp_KActionCollection_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KActionCollection_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KActionCollection_PythonToCpp_KActionCollection_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KActionCollection_TypeF()))
        return KActionCollection_PythonToCpp_KActionCollection_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KActionCollection_PTR_CppToPython_KActionCollection(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KActionCollection *>(const_cast<void *>(cppIn)), Sbk_KActionCollection_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KActionCollection_SignatureStrings[] = {
    "KXmlGui.KActionCollection(self,parent:PySide6.QtCore.QObject,cName:QString=QString(),*:KeywordOnly=None,configGroup:QString=None,configIsGlobal:bool=None)",
    "1:KXmlGui.KActionCollection.action(self,name:QString)->PySide6.QtGui.QAction",
    "0:KXmlGui.KActionCollection.action(self,index:int)->PySide6.QtGui.QAction",
    "KXmlGui.KActionCollection.actionGroups(self)->QList[PySide6.QtGui.QActionGroup]",
    "KXmlGui.KActionCollection.actions(self)->QList[PySide6.QtGui.QAction]",
    "KXmlGui.KActionCollection.actionsWithoutGroup(self)->QList[PySide6.QtGui.QAction]",
    "1:KXmlGui.KActionCollection.addAction(self,name:QString,action:PySide6.QtGui.QAction)->PySide6.QtGui.QAction",
    "0:KXmlGui.KActionCollection.addAction(self,name:QString,receiver:PySide6.QtCore.QObject=nullptr,member:char*=nullptr)->PySide6.QtGui.QAction",
    "KXmlGui.KActionCollection.addActions(self,actions:QList[PySide6.QtGui.QAction])",
    "KXmlGui.KActionCollection.addAssociatedWidget(self,widget:PySide6.QtWidgets.QWidget)",
    "KXmlGui.KActionCollection.allCollections()->QList[KXmlGui.KActionCollection]",
    "KXmlGui.KActionCollection.associateWidget(self,widget:PySide6.QtWidgets.QWidget)",
    "KXmlGui.KActionCollection.associatedWidgets(self)->QList[PySide6.QtWidgets.QWidget]",
    "KXmlGui.KActionCollection.clear(self)",
    "KXmlGui.KActionCollection.clearAssociatedWidgets(self)",
    "KXmlGui.KActionCollection.componentDisplayName(self)->QString",
    "KXmlGui.KActionCollection.componentName(self)->QString",
    "KXmlGui.KActionCollection.configGroup(self)->QString",
    "KXmlGui.KActionCollection.configIsGlobal(self)->bool",
    "KXmlGui.KActionCollection.connectNotify(self,signal:PySide6.QtCore.QMetaMethod)",
    "KXmlGui.KActionCollection.count(self)->int",
    "KXmlGui.KActionCollection.defaultShortcut(action:PySide6.QtGui.QAction)->PySide6.QtGui.QKeySequence",
    "KXmlGui.KActionCollection.defaultShortcuts(action:PySide6.QtGui.QAction)->QList[PySide6.QtGui.QKeySequence]",
    "KXmlGui.KActionCollection.isEmpty(self)->bool",
    "KXmlGui.KActionCollection.isShortcutsConfigurable(action:PySide6.QtGui.QAction)->bool",
    "KXmlGui.KActionCollection.parentGUIClient(self)->KXmlGui.KXMLGUIClient",
    "KXmlGui.KActionCollection.readSettings(self)",
    "KXmlGui.KActionCollection.removeAction(self,action:PySide6.QtGui.QAction)",
    "KXmlGui.KActionCollection.removeAssociatedWidget(self,widget:PySide6.QtWidgets.QWidget)",
    "KXmlGui.KActionCollection.setComponentDisplayName(self,displayName:QString)",
    "KXmlGui.KActionCollection.setComponentName(self,componentName:QString)",
    "KXmlGui.KActionCollection.setConfigGlobal(self,global:bool)",
    "KXmlGui.KActionCollection.setConfigGroup(self,group:QString)",
    "KXmlGui.KActionCollection.setDefaultShortcut(action:PySide6.QtGui.QAction,shortcut:typing.Union[PySide6.QtGui.QKeySequence, PySide6.QtCore.QKeyCombination, PySide6.QtGui.QKeySequence.StandardKey, QString, int])",
    "KXmlGui.KActionCollection.setDefaultShortcuts(action:PySide6.QtGui.QAction,shortcuts:QList[PySide6.QtGui.QKeySequence])",
    "KXmlGui.KActionCollection.setShortcutsConfigurable(action:PySide6.QtGui.QAction,configurable:bool)",
    "KXmlGui.KActionCollection.slotActionTriggered(self)",
    "KXmlGui.KActionCollection.takeAction(self,action:PySide6.QtGui.QAction)->PySide6.QtGui.QAction",
    "KXmlGui.KActionCollection.writeSettings(self)",
    nullptr}; // Sentinel
#else
static constexpr size_t KActionCollection_SignatureByteSize = 639;
static constexpr uint8_t KActionCollection_SignatureBytes[639] = {
    0x78, 0xda, 0xad, 0x56, 0x4d, 0x6f, 0xdb, 0x30, 0x0c, 0xbd, 0xf7, 0x57, 0xe4, 0x98, 0x14, 0x9e,
    0xb1, 0x5d, 0x76, 0x30, 0x90, 0x01, 0x41, 0x3a, 0x04, 0x45, 0xda, 0x74, 0x86, 0x57, 0xb4, 0x40,
    0xd1, 0x83, 0x62, 0x31, 0x8e, 0x36, 0x59, 0xf2, 0x24, 0xba, 0x99, 0xff, 0xfd, 0x14, 0x3b, 0xfe,
    0x58, 0x10, 0x4b, 0x76, 0xd1, 0x43, 0x10, 0x59, 0xd2, 0x7b, 0x24, 0x45, 0xf2, 0x49, 0xeb, 0xe7,
    0x94, 0xaf, 0x72, 0xe6, 0xaf, 0x17, 0x31, 0x32, 0x29, 0x96, 0x92, 0x73, 0x28, 0x47, 0x53, 0x0d,
    0x7c, 0xe7, 0x65, 0x44, 0x81, 0xc0, 0xe0, 0x47, 0x11, 0x31, 0x0a, 0x5f, 0xfd, 0x10, 0x97, 0x52,
    0x81, 0x1f, 0x3e, 0x6c, 0x7f, 0x99, 0x5d, 0x5e, 0xbc, 0x21, 0x29, 0x04, 0x61, 0x84, 0x8a, 0x89,
    0x64, 0x7e, 0xfa, 0x9f, 0xce, 0xbc, 0xeb, 0x60, 0x0d, 0xc5, 0x41, 0x2a, 0xfa, 0x20, 0x78, 0x31,
    0xdf, 0x48, 0x01, 0x5e, 0x2c, 0xc5, 0x8e, 0x25, 0x2b, 0x25, 0xf3, 0xac, 0x01, 0x74, 0x16, 0x6e,
    0xf5, 0x8a, 0xcb, 0x2d, 0xe1, 0xc1, 0x56, 0x4a, 0x5e, 0x2e, 0xcc, 0xae, 0xbe, 0x04, 0xeb, 0x3e,
    0xe7, 0x7c, 0xd2, 0xf1, 0x51, 0x74, 0x9c, 0x98, 0x7d, 0xfa, 0xd6, 0xfa, 0x7a, 0x84, 0x86, 0x15,
    0xf4, 0xea, 0xf3, 0x40, 0x32, 0x26, 0x28, 0xfc, 0x0d, 0x98, 0xc0, 0x5e, 0x26, 0x17, 0x4f, 0x19,
    0xa3, 0x2e, 0xd9, 0x0c, 0x47, 0x78, 0xc7, 0x34, 0xbe, 0x5c, 0x64, 0x2a, 0x37, 0xbe, 0x3a, 0xf9,
    0x86, 0x50, 0x0d, 0x60, 0x79, 0x62, 0xb8, 0x97, 0x39, 0x96, 0x46, 0x07, 0x31, 0x5a, 0x8f, 0x9f,
    0xd2, 0x45, 0x4f, 0x06, 0xbc, 0xca, 0x5e, 0x70, 0x91, 0xf5, 0x7d, 0xe9, 0xb1, 0x18, 0x53, 0x10,
    0x03, 0x7b, 0x03, 0xd5, 0x53, 0xa1, 0x73, 0x91, 0x73, 0x9e, 0xa1, 0xf2, 0x52, 0x48, 0xb7, 0x66,
    0x57, 0xbc, 0x27, 0xea, 0xba, 0x9e, 0x7c, 0x4f, 0x86, 0x6b, 0x57, 0xaa, 0xa4, 0x9c, 0x62, 0xd5,
    0x81, 0xed, 0x20, 0x67, 0x0e, 0x3e, 0xad, 0x65, 0xcc, 0x08, 0x02, 0x7d, 0x62, 0x34, 0x01, 0xac,
    0x88, 0x0f, 0xe5, 0xb8, 0x13, 0x55, 0xb5, 0xa8, 0xfd, 0xb0, 0x1a, 0x58, 0x49, 0x39, 0x6f, 0xbf,
    0xf4, 0xb4, 0xc9, 0x73, 0x2f, 0xc2, 0x5a, 0x3d, 0xb5, 0x7b, 0x1f, 0xe6, 0xdd, 0x59, 0xbc, 0xbd,
    0xe5, 0x7d, 0xc6, 0x69, 0x73, 0x32, 0xe6, 0x40, 0x54, 0xc5, 0xe3, 0xda, 0xb5, 0xb8, 0x6c, 0xde,
    0x06, 0x93, 0x69, 0x66, 0xf4, 0x48, 0xe0, 0x0d, 0xd3, 0x19, 0x27, 0xc5, 0x51, 0xf3, 0x1a, 0x9f,
    0xab, 0x32, 0x1c, 0x82, 0x1e, 0x0b, 0x6b, 0xe4, 0x72, 0x2c, 0xa8, 0x96, 0xd2, 0x1a, 0x77, 0x54,
    0x54, 0x3b, 0x48, 0x98, 0xe1, 0x46, 0x22, 0xdb, 0x15, 0x55, 0x7a, 0x35, 0x4b, 0x84, 0x91, 0xe2,
    0xf3, 0x96, 0xba, 0x07, 0x24, 0xe6, 0xb7, 0x97, 0xd4, 0x7e, 0x5c, 0xb9, 0xc0, 0xda, 0xb6, 0xd1,
    0x51, 0xcb, 0x56, 0x0a, 0x3b, 0x92, 0x73, 0x8c, 0xf6, 0x52, 0x61, 0x9c, 0xe3, 0x74, 0x9c, 0x72,
    0x98, 0x2b, 0x26, 0x82, 0x3f, 0x39, 0x88, 0x18, 0x86, 0xdb, 0xd0, 0x2e, 0x23, 0x17, 0x3b, 0xb9,
    0x63, 0xca, 0x56, 0x86, 0x4c, 0x7f, 0x4f, 0x33, 0x2c, 0x06, 0x1e, 0x3c, 0xd3, 0x8d, 0x53, 0xcb,
    0x32, 0x71, 0xb9, 0x22, 0x5b, 0x0e, 0x2e, 0x07, 0x1d, 0xac, 0xd5, 0x85, 0xbd, 0x7a, 0xbc, 0x5d,
    0x72, 0x06, 0x6d, 0x22, 0x1a, 0xc0, 0xf3, 0xfd, 0x5d, 0xb3, 0x68, 0xa1, 0x51, 0x40, 0x68, 0x04,
    0x88, 0xa6, 0xe0, 0xdc, 0x1d, 0xa2, 0x20, 0x95, 0x6f, 0xd0, 0xd5, 0x68, 0x6b, 0x0c, 0x6e, 0xa6,
    0x0f, 0x97, 0x44, 0x0d, 0xa6, 0x86, 0x7b, 0xda, 0xd8, 0xa3, 0xed, 0x44, 0xf3, 0x8c, 0x18, 0xc8,
    0xd5, 0x92, 0xfc, 0xd7, 0xe7, 0x83, 0x69, 0xca, 0x26, 0x6f, 0xbb, 0xd5, 0x4b, 0xda, 0x47, 0xd0,
    0x30, 0x6c, 0x23, 0x10, 0x5e, 0xd2, 0x7d, 0x5a, 0x39, 0xc0, 0x37, 0x23, 0x1a, 0xcf, 0xd3, 0xa7,
    0x5d, 0x01, 0x16, 0x99, 0xa1, 0xf6, 0x1f, 0x85, 0x99, 0xb5, 0x74, 0x88, 0x37, 0x39, 0x17, 0x0e,
    0xb3, 0x68, 0x4e, 0x6c, 0xcb, 0x04, 0x29, 0x09, 0x27, 0xfd, 0x58, 0x3f, 0x42, 0x22, 0x28, 0x51,
    0xd4, 0xcc, 0x79, 0x93, 0xfa, 0x92, 0x9f, 0x18, 0x19, 0x79, 0x1d, 0x17, 0x92, 0x1e, 0x16, 0x53,
    0xcf, 0xcd, 0xdd, 0xed, 0x77, 0x87, 0xdd, 0xf1, 0x3d, 0x7c, 0x7a, 0xf1, 0x56, 0x3b, 0xdd, 0xa9,
    0xe6, 0x12, 0xab, 0xc9, 0x9f, 0x8a, 0x25, 0x09, 0x28, 0xa0, 0xce, 0x7e, 0x44, 0xf2, 0x7b, 0x78,
    0x37, 0x8e, 0x7f, 0x04, 0x1d, 0x14, 0x43, 0x38, 0x13, 0x87, 0x7f, 0x82, 0xa6, 0x7f, 0xd4
};
#endif

PyTypeObject *init_KActionCollection(PyObject *module)
{
    if (SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX].type != nullptr)
        return SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX].type;

    Shiboken::AutoDecRef Sbk_KActionCollection_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))));

    _Sbk_KActionCollection_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KActionCollection",
        "KActionCollection*",
        &Sbk_KActionCollection_spec,
        &Shiboken::callCppDestructor< KActionCollection >,
        Sbk_KActionCollection_Type_bases.object(),
        0);
    auto *pyType = Sbk_KActionCollection_TypeF(); // references _Sbk_KActionCollection_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KActionCollection_SignatureStrings);
#else
    InitSignatureBytes(pyType, KActionCollection_SignatureBytes, KActionCollection_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KActionCollection_PropertyStrings);
    SbkKXmlGuiTypeStructs[SBK_KActionCollection_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KActionCollection_PythonToCpp_KActionCollection_PTR,
        is_KActionCollection_PythonToCpp_KActionCollection_PTR_Convertible,
        KActionCollection_PTR_CppToPython_KActionCollection);

    Shiboken::Conversions::registerConverterName(converter, "KActionCollection");
    Shiboken::Conversions::registerConverterName(converter, "KActionCollection*");
    Shiboken::Conversions::registerConverterName(converter, "KActionCollection&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KActionCollection).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KActionCollectionWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KActionCollection_TypeF(), &Sbk_KActionCollection_typeDiscovery);

    PySide::Signal::registerSignals(pyType, &::KActionCollection::staticMetaObject);
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KActionCollection::staticMetaObject, sizeof(KActionCollectionWrapper));

    return pyType;
}
