#include "device.h"

// The key for the ncclDevFuncNameToId map is a 64-bit unsigned integer.
// Each field (coll, algo, proto, redop, ty, pipeline) is packed into 4 bits,
// Each field (coll, algo, proto, redop, ty) is packed into 4 bits,
// This allows up to 16 unique values per field. The layout is:
//   bits  0-3:   coll index
//   bits  4-7:   algo index
//   bits  8-11:  proto index
//   bits 12-15:  redop index
//   bits 16-19:  ty index
//   bits 20-23:  pipeline index
#include <unordered_map>
std::unordered_map<uint64_t, int> ncclDevFuncNameToId = {
  {0, 0},  // Broadcast RING LL Sum i8 0 0
  {256, 1},  // Broadcast RING LL128 Sum i8 0 0
  {512, 2},  // Broadcast RING SIMPLE Sum i8 0 0
  {17, 3},  // Reduce RING LL Sum i8 0 0
  {65553, 3},  // Reduce RING LL Sum u8 0 0
  {131089, 4},  // Reduce RING LL Sum i32 0 0
  {196625, 4},  // Reduce RING LL Sum u32 0 0
  {262161, 5},  // Reduce RING LL Sum i64 0 0
  {327697, 5},  // Reduce RING LL Sum u64 0 0
  {393233, 6},  // Reduce RING LL Sum f16 0 0
  {458769, 7},  // Reduce RING LL Sum f32 0 0
  {524305, 8},  // Reduce RING LL Sum f64 0 0
  {589841, 9},  // Reduce RING LL Sum bf16 0 0
  {1638417, 9},  // Reduce RING LL Sum bf16 0 1
  {655377, 10},  // Reduce RING LL Sum f8e4m3 0 0
  {720913, 11},  // Reduce RING LL Sum f8e5m2 0 0
  {4113, 12},  // Reduce RING LL Prod i8 0 0
  {69649, 12},  // Reduce RING LL Prod u8 0 0
  {135185, 13},  // Reduce RING LL Prod i32 0 0
  {200721, 13},  // Reduce RING LL Prod u32 0 0
  {266257, 14},  // Reduce RING LL Prod i64 0 0
  {331793, 14},  // Reduce RING LL Prod u64 0 0
  {397329, 15},  // Reduce RING LL Prod f16 0 0
  {462865, 16},  // Reduce RING LL Prod f32 0 0
  {528401, 17},  // Reduce RING LL Prod f64 0 0
  {593937, 18},  // Reduce RING LL Prod bf16 0 0
  {1642513, 18},  // Reduce RING LL Prod bf16 0 1
  {659473, 19},  // Reduce RING LL Prod f8e4m3 0 0
  {725009, 20},  // Reduce RING LL Prod f8e5m2 0 0
  {8209, 21},  // Reduce RING LL MinMax i8 0 0
  {73745, 21},  // Reduce RING LL MinMax u8 0 0
  {139281, 22},  // Reduce RING LL MinMax i32 0 0
  {204817, 22},  // Reduce RING LL MinMax u32 0 0
  {270353, 23},  // Reduce RING LL MinMax i64 0 0
  {335889, 23},  // Reduce RING LL MinMax u64 0 0
  {401425, 24},  // Reduce RING LL MinMax f16 0 0
  {466961, 25},  // Reduce RING LL MinMax f32 0 0
  {532497, 26},  // Reduce RING LL MinMax f64 0 0
  {598033, 27},  // Reduce RING LL MinMax bf16 0 0
  {1646609, 27},  // Reduce RING LL MinMax bf16 0 1
  {663569, 28},  // Reduce RING LL MinMax f8e4m3 0 0
  {729105, 29},  // Reduce RING LL MinMax f8e5m2 0 0
  {12305, 30},  // Reduce RING LL PreMulSum i8 0 0
  {77841, 30},  // Reduce RING LL PreMulSum u8 0 0
  {143377, 31},  // Reduce RING LL PreMulSum i32 0 0
  {208913, 31},  // Reduce RING LL PreMulSum u32 0 0
  {274449, 32},  // Reduce RING LL PreMulSum i64 0 0
  {339985, 32},  // Reduce RING LL PreMulSum u64 0 0
  {405521, 33},  // Reduce RING LL PreMulSum f16 0 0
  {471057, 34},  // Reduce RING LL PreMulSum f32 0 0
  {536593, 35},  // Reduce RING LL PreMulSum f64 0 0
  {602129, 36},  // Reduce RING LL PreMulSum bf16 0 0
  {1650705, 36},  // Reduce RING LL PreMulSum bf16 0 1
  {667665, 37},  // Reduce RING LL PreMulSum f8e4m3 0 0
  {733201, 38},  // Reduce RING LL PreMulSum f8e5m2 0 0
  {16401, 39},  // Reduce RING LL SumPostDiv i8 0 0
  {81937, 39},  // Reduce RING LL SumPostDiv u8 0 0
  {147473, 40},  // Reduce RING LL SumPostDiv i32 0 0
  {213009, 40},  // Reduce RING LL SumPostDiv u32 0 0
  {278545, 41},  // Reduce RING LL SumPostDiv i64 0 0
  {344081, 41},  // Reduce RING LL SumPostDiv u64 0 0
  {273, 42},  // Reduce RING LL128 Sum i8 0 0
  {65809, 42},  // Reduce RING LL128 Sum u8 0 0
  {131345, 43},  // Reduce RING LL128 Sum i32 0 0
  {196881, 43},  // Reduce RING LL128 Sum u32 0 0
  {262417, 44},  // Reduce RING LL128 Sum i64 0 0
  {327953, 44},  // Reduce RING LL128 Sum u64 0 0
  {393489, 45},  // Reduce RING LL128 Sum f16 0 0
  {459025, 46},  // Reduce RING LL128 Sum f32 0 0
  {524561, 47},  // Reduce RING LL128 Sum f64 0 0
  {590097, 48},  // Reduce RING LL128 Sum bf16 0 0
  {1638673, 48},  // Reduce RING LL128 Sum bf16 0 1
  {655633, 49},  // Reduce RING LL128 Sum f8e4m3 0 0
  {721169, 50},  // Reduce RING LL128 Sum f8e5m2 0 0
  {4369, 51},  // Reduce RING LL128 Prod i8 0 0
  {69905, 51},  // Reduce RING LL128 Prod u8 0 0
  {135441, 52},  // Reduce RING LL128 Prod i32 0 0
  {200977, 52},  // Reduce RING LL128 Prod u32 0 0
  {266513, 53},  // Reduce RING LL128 Prod i64 0 0
  {332049, 53},  // Reduce RING LL128 Prod u64 0 0
  {397585, 54},  // Reduce RING LL128 Prod f16 0 0
  {463121, 55},  // Reduce RING LL128 Prod f32 0 0
  {528657, 56},  // Reduce RING LL128 Prod f64 0 0
  {594193, 57},  // Reduce RING LL128 Prod bf16 0 0
  {1642769, 57},  // Reduce RING LL128 Prod bf16 0 1
  {659729, 58},  // Reduce RING LL128 Prod f8e4m3 0 0
  {725265, 59},  // Reduce RING LL128 Prod f8e5m2 0 0
  {8465, 60},  // Reduce RING LL128 MinMax i8 0 0
  {74001, 60},  // Reduce RING LL128 MinMax u8 0 0
  {139537, 61},  // Reduce RING LL128 MinMax i32 0 0
  {205073, 61},  // Reduce RING LL128 MinMax u32 0 0
  {270609, 62},  // Reduce RING LL128 MinMax i64 0 0
  {336145, 62},  // Reduce RING LL128 MinMax u64 0 0
  {401681, 63},  // Reduce RING LL128 MinMax f16 0 0
  {467217, 64},  // Reduce RING LL128 MinMax f32 0 0
  {532753, 65},  // Reduce RING LL128 MinMax f64 0 0
  {598289, 66},  // Reduce RING LL128 MinMax bf16 0 0
  {1646865, 66},  // Reduce RING LL128 MinMax bf16 0 1
  {663825, 67},  // Reduce RING LL128 MinMax f8e4m3 0 0
  {729361, 68},  // Reduce RING LL128 MinMax f8e5m2 0 0
  {12561, 69},  // Reduce RING LL128 PreMulSum i8 0 0
  {78097, 69},  // Reduce RING LL128 PreMulSum u8 0 0
  {143633, 70},  // Reduce RING LL128 PreMulSum i32 0 0
  {209169, 70},  // Reduce RING LL128 PreMulSum u32 0 0
  {274705, 71},  // Reduce RING LL128 PreMulSum i64 0 0
  {340241, 71},  // Reduce RING LL128 PreMulSum u64 0 0
  {405777, 72},  // Reduce RING LL128 PreMulSum f16 0 0
  {471313, 73},  // Reduce RING LL128 PreMulSum f32 0 0
  {536849, 74},  // Reduce RING LL128 PreMulSum f64 0 0
  {602385, 75},  // Reduce RING LL128 PreMulSum bf16 0 0
  {1650961, 75},  // Reduce RING LL128 PreMulSum bf16 0 1
  {667921, 76},  // Reduce RING LL128 PreMulSum f8e4m3 0 0
  {733457, 77},  // Reduce RING LL128 PreMulSum f8e5m2 0 0
  {16657, 78},  // Reduce RING LL128 SumPostDiv i8 0 0
  {82193, 78},  // Reduce RING LL128 SumPostDiv u8 0 0
  {147729, 79},  // Reduce RING LL128 SumPostDiv i32 0 0
  {213265, 79},  // Reduce RING LL128 SumPostDiv u32 0 0
  {278801, 80},  // Reduce RING LL128 SumPostDiv i64 0 0
  {344337, 80},  // Reduce RING LL128 SumPostDiv u64 0 0
  {529, 81},  // Reduce RING SIMPLE Sum i8 0 0
  {66065, 81},  // Reduce RING SIMPLE Sum u8 0 0
  {131601, 82},  // Reduce RING SIMPLE Sum i32 0 0
  {197137, 82},  // Reduce RING SIMPLE Sum u32 0 0
  {262673, 83},  // Reduce RING SIMPLE Sum i64 0 0
  {328209, 83},  // Reduce RING SIMPLE Sum u64 0 0
  {393745, 84},  // Reduce RING SIMPLE Sum f16 0 0
  {459281, 85},  // Reduce RING SIMPLE Sum f32 0 0
  {524817, 86},  // Reduce RING SIMPLE Sum f64 0 0
  {590353, 87},  // Reduce RING SIMPLE Sum bf16 0 0
  {1638929, 88},  // Reduce RING SIMPLE Sum bf16 0 1
  {655889, 89},  // Reduce RING SIMPLE Sum f8e4m3 0 0
  {721425, 90},  // Reduce RING SIMPLE Sum f8e5m2 0 0
  {4625, 91},  // Reduce RING SIMPLE Prod i8 0 0
  {70161, 91},  // Reduce RING SIMPLE Prod u8 0 0
  {135697, 92},  // Reduce RING SIMPLE Prod i32 0 0
  {201233, 92},  // Reduce RING SIMPLE Prod u32 0 0
  {266769, 93},  // Reduce RING SIMPLE Prod i64 0 0
  {332305, 93},  // Reduce RING SIMPLE Prod u64 0 0
  {397841, 94},  // Reduce RING SIMPLE Prod f16 0 0
  {463377, 95},  // Reduce RING SIMPLE Prod f32 0 0
  {528913, 96},  // Reduce RING SIMPLE Prod f64 0 0
  {594449, 97},  // Reduce RING SIMPLE Prod bf16 0 0
  {1643025, 98},  // Reduce RING SIMPLE Prod bf16 0 1
  {659985, 99},  // Reduce RING SIMPLE Prod f8e4m3 0 0
  {725521, 100},  // Reduce RING SIMPLE Prod f8e5m2 0 0
  {8721, 101},  // Reduce RING SIMPLE MinMax i8 0 0
  {74257, 101},  // Reduce RING SIMPLE MinMax u8 0 0
  {139793, 102},  // Reduce RING SIMPLE MinMax i32 0 0
  {205329, 102},  // Reduce RING SIMPLE MinMax u32 0 0
  {270865, 103},  // Reduce RING SIMPLE MinMax i64 0 0
  {336401, 103},  // Reduce RING SIMPLE MinMax u64 0 0
  {401937, 104},  // Reduce RING SIMPLE MinMax f16 0 0
  {467473, 105},  // Reduce RING SIMPLE MinMax f32 0 0
  {533009, 106},  // Reduce RING SIMPLE MinMax f64 0 0
  {598545, 107},  // Reduce RING SIMPLE MinMax bf16 0 0
  {1647121, 108},  // Reduce RING SIMPLE MinMax bf16 0 1
  {664081, 109},  // Reduce RING SIMPLE MinMax f8e4m3 0 0
  {729617, 110},  // Reduce RING SIMPLE MinMax f8e5m2 0 0
  {12817, 111},  // Reduce RING SIMPLE PreMulSum i8 0 0
  {78353, 111},  // Reduce RING SIMPLE PreMulSum u8 0 0
  {143889, 112},  // Reduce RING SIMPLE PreMulSum i32 0 0
  {209425, 112},  // Reduce RING SIMPLE PreMulSum u32 0 0
  {274961, 113},  // Reduce RING SIMPLE PreMulSum i64 0 0
  {340497, 113},  // Reduce RING SIMPLE PreMulSum u64 0 0
  {406033, 114},  // Reduce RING SIMPLE PreMulSum f16 0 0
  {471569, 115},  // Reduce RING SIMPLE PreMulSum f32 0 0
  {537105, 116},  // Reduce RING SIMPLE PreMulSum f64 0 0
  {602641, 117},  // Reduce RING SIMPLE PreMulSum bf16 0 0
  {1651217, 118},  // Reduce RING SIMPLE PreMulSum bf16 0 1
  {668177, 119},  // Reduce RING SIMPLE PreMulSum f8e4m3 0 0
  {733713, 120},  // Reduce RING SIMPLE PreMulSum f8e5m2 0 0
  {16913, 121},  // Reduce RING SIMPLE SumPostDiv i8 0 0
  {82449, 121},  // Reduce RING SIMPLE SumPostDiv u8 0 0
  {147985, 122},  // Reduce RING SIMPLE SumPostDiv i32 0 0
  {213521, 122},  // Reduce RING SIMPLE SumPostDiv u32 0 0
  {279057, 123},  // Reduce RING SIMPLE SumPostDiv i64 0 0
  {344593, 123},  // Reduce RING SIMPLE SumPostDiv u64 0 0
  {18, 124},  // AllGather RING LL Sum i8 0 0
  {274, 125},  // AllGather RING LL128 Sum i8 0 0
  {530, 126},  // AllGather RING SIMPLE Sum i8 0 0
  {98, 127},  // AllGather PAT LL Sum i8 0 0
  {354, 128},  // AllGather PAT LL128 Sum i8 0 0
  {610, 129},  // AllGather PAT SIMPLE Sum i8 0 0
  {19, 130},  // ReduceScatter RING LL Sum i8 0 0
  {65555, 130},  // ReduceScatter RING LL Sum u8 0 0
  {131091, 131},  // ReduceScatter RING LL Sum i32 0 0
  {196627, 131},  // ReduceScatter RING LL Sum u32 0 0
  {262163, 132},  // ReduceScatter RING LL Sum i64 0 0
  {327699, 132},  // ReduceScatter RING LL Sum u64 0 0
  {393235, 133},  // ReduceScatter RING LL Sum f16 0 0
  {458771, 134},  // ReduceScatter RING LL Sum f32 0 0
  {524307, 135},  // ReduceScatter RING LL Sum f64 0 0
  {589843, 136},  // ReduceScatter RING LL Sum bf16 0 0
  {1638419, 136},  // ReduceScatter RING LL Sum bf16 0 1
  {655379, 137},  // ReduceScatter RING LL Sum f8e4m3 0 0
  {720915, 138},  // ReduceScatter RING LL Sum f8e5m2 0 0
  {4115, 139},  // ReduceScatter RING LL Prod i8 0 0
  {69651, 139},  // ReduceScatter RING LL Prod u8 0 0
  {135187, 140},  // ReduceScatter RING LL Prod i32 0 0
  {200723, 140},  // ReduceScatter RING LL Prod u32 0 0
  {266259, 141},  // ReduceScatter RING LL Prod i64 0 0
  {331795, 141},  // ReduceScatter RING LL Prod u64 0 0
  {397331, 142},  // ReduceScatter RING LL Prod f16 0 0
  {462867, 143},  // ReduceScatter RING LL Prod f32 0 0
  {528403, 144},  // ReduceScatter RING LL Prod f64 0 0
  {593939, 145},  // ReduceScatter RING LL Prod bf16 0 0
  {1642515, 145},  // ReduceScatter RING LL Prod bf16 0 1
  {659475, 146},  // ReduceScatter RING LL Prod f8e4m3 0 0
  {725011, 147},  // ReduceScatter RING LL Prod f8e5m2 0 0
  {8211, 148},  // ReduceScatter RING LL MinMax i8 0 0
  {73747, 148},  // ReduceScatter RING LL MinMax u8 0 0
  {139283, 149},  // ReduceScatter RING LL MinMax i32 0 0
  {204819, 149},  // ReduceScatter RING LL MinMax u32 0 0
  {270355, 150},  // ReduceScatter RING LL MinMax i64 0 0
  {335891, 150},  // ReduceScatter RING LL MinMax u64 0 0
  {401427, 151},  // ReduceScatter RING LL MinMax f16 0 0
  {466963, 152},  // ReduceScatter RING LL MinMax f32 0 0
  {532499, 153},  // ReduceScatter RING LL MinMax f64 0 0
  {598035, 154},  // ReduceScatter RING LL MinMax bf16 0 0
  {1646611, 154},  // ReduceScatter RING LL MinMax bf16 0 1
  {663571, 155},  // ReduceScatter RING LL MinMax f8e4m3 0 0
  {729107, 156},  // ReduceScatter RING LL MinMax f8e5m2 0 0
  {12307, 157},  // ReduceScatter RING LL PreMulSum i8 0 0
  {77843, 157},  // ReduceScatter RING LL PreMulSum u8 0 0
  {143379, 158},  // ReduceScatter RING LL PreMulSum i32 0 0
  {208915, 158},  // ReduceScatter RING LL PreMulSum u32 0 0
  {274451, 159},  // ReduceScatter RING LL PreMulSum i64 0 0
  {339987, 159},  // ReduceScatter RING LL PreMulSum u64 0 0
  {405523, 160},  // ReduceScatter RING LL PreMulSum f16 0 0
  {471059, 161},  // ReduceScatter RING LL PreMulSum f32 0 0
  {536595, 162},  // ReduceScatter RING LL PreMulSum f64 0 0
  {602131, 163},  // ReduceScatter RING LL PreMulSum bf16 0 0
  {1650707, 163},  // ReduceScatter RING LL PreMulSum bf16 0 1
  {667667, 164},  // ReduceScatter RING LL PreMulSum f8e4m3 0 0
  {733203, 165},  // ReduceScatter RING LL PreMulSum f8e5m2 0 0
  {16403, 166},  // ReduceScatter RING LL SumPostDiv i8 0 0
  {81939, 166},  // ReduceScatter RING LL SumPostDiv u8 0 0
  {147475, 167},  // ReduceScatter RING LL SumPostDiv i32 0 0
  {213011, 167},  // ReduceScatter RING LL SumPostDiv u32 0 0
  {278547, 168},  // ReduceScatter RING LL SumPostDiv i64 0 0
  {344083, 168},  // ReduceScatter RING LL SumPostDiv u64 0 0
  {275, 169},  // ReduceScatter RING LL128 Sum i8 0 0
  {65811, 169},  // ReduceScatter RING LL128 Sum u8 0 0
  {131347, 170},  // ReduceScatter RING LL128 Sum i32 0 0
  {196883, 170},  // ReduceScatter RING LL128 Sum u32 0 0
  {262419, 171},  // ReduceScatter RING LL128 Sum i64 0 0
  {327955, 171},  // ReduceScatter RING LL128 Sum u64 0 0
  {393491, 172},  // ReduceScatter RING LL128 Sum f16 0 0
  {459027, 173},  // ReduceScatter RING LL128 Sum f32 0 0
  {524563, 174},  // ReduceScatter RING LL128 Sum f64 0 0
  {590099, 175},  // ReduceScatter RING LL128 Sum bf16 0 0
  {1638675, 175},  // ReduceScatter RING LL128 Sum bf16 0 1
  {655635, 176},  // ReduceScatter RING LL128 Sum f8e4m3 0 0
  {721171, 177},  // ReduceScatter RING LL128 Sum f8e5m2 0 0
  {4371, 178},  // ReduceScatter RING LL128 Prod i8 0 0
  {69907, 178},  // ReduceScatter RING LL128 Prod u8 0 0
  {135443, 179},  // ReduceScatter RING LL128 Prod i32 0 0
  {200979, 179},  // ReduceScatter RING LL128 Prod u32 0 0
  {266515, 180},  // ReduceScatter RING LL128 Prod i64 0 0
  {332051, 180},  // ReduceScatter RING LL128 Prod u64 0 0
  {397587, 181},  // ReduceScatter RING LL128 Prod f16 0 0
  {463123, 182},  // ReduceScatter RING LL128 Prod f32 0 0
  {528659, 183},  // ReduceScatter RING LL128 Prod f64 0 0
  {594195, 184},  // ReduceScatter RING LL128 Prod bf16 0 0
  {1642771, 184},  // ReduceScatter RING LL128 Prod bf16 0 1
  {659731, 185},  // ReduceScatter RING LL128 Prod f8e4m3 0 0
  {725267, 186},  // ReduceScatter RING LL128 Prod f8e5m2 0 0
  {8467, 187},  // ReduceScatter RING LL128 MinMax i8 0 0
  {74003, 187},  // ReduceScatter RING LL128 MinMax u8 0 0
  {139539, 188},  // ReduceScatter RING LL128 MinMax i32 0 0
  {205075, 188},  // ReduceScatter RING LL128 MinMax u32 0 0
  {270611, 189},  // ReduceScatter RING LL128 MinMax i64 0 0
  {336147, 189},  // ReduceScatter RING LL128 MinMax u64 0 0
  {401683, 190},  // ReduceScatter RING LL128 MinMax f16 0 0
  {467219, 191},  // ReduceScatter RING LL128 MinMax f32 0 0
  {532755, 192},  // ReduceScatter RING LL128 MinMax f64 0 0
  {598291, 193},  // ReduceScatter RING LL128 MinMax bf16 0 0
  {1646867, 193},  // ReduceScatter RING LL128 MinMax bf16 0 1
  {663827, 194},  // ReduceScatter RING LL128 MinMax f8e4m3 0 0
  {729363, 195},  // ReduceScatter RING LL128 MinMax f8e5m2 0 0
  {12563, 196},  // ReduceScatter RING LL128 PreMulSum i8 0 0
  {78099, 196},  // ReduceScatter RING LL128 PreMulSum u8 0 0
  {143635, 197},  // ReduceScatter RING LL128 PreMulSum i32 0 0
  {209171, 197},  // ReduceScatter RING LL128 PreMulSum u32 0 0
  {274707, 198},  // ReduceScatter RING LL128 PreMulSum i64 0 0
  {340243, 198},  // ReduceScatter RING LL128 PreMulSum u64 0 0
  {405779, 199},  // ReduceScatter RING LL128 PreMulSum f16 0 0
  {471315, 200},  // ReduceScatter RING LL128 PreMulSum f32 0 0
  {536851, 201},  // ReduceScatter RING LL128 PreMulSum f64 0 0
  {602387, 202},  // ReduceScatter RING LL128 PreMulSum bf16 0 0
  {1650963, 202},  // ReduceScatter RING LL128 PreMulSum bf16 0 1
  {667923, 203},  // ReduceScatter RING LL128 PreMulSum f8e4m3 0 0
  {733459, 204},  // ReduceScatter RING LL128 PreMulSum f8e5m2 0 0
  {16659, 205},  // ReduceScatter RING LL128 SumPostDiv i8 0 0
  {82195, 205},  // ReduceScatter RING LL128 SumPostDiv u8 0 0
  {147731, 206},  // ReduceScatter RING LL128 SumPostDiv i32 0 0
  {213267, 206},  // ReduceScatter RING LL128 SumPostDiv u32 0 0
  {278803, 207},  // ReduceScatter RING LL128 SumPostDiv i64 0 0
  {344339, 207},  // ReduceScatter RING LL128 SumPostDiv u64 0 0
  {531, 208},  // ReduceScatter RING SIMPLE Sum i8 0 0
  {66067, 208},  // ReduceScatter RING SIMPLE Sum u8 0 0
  {131603, 209},  // ReduceScatter RING SIMPLE Sum i32 0 0
  {197139, 209},  // ReduceScatter RING SIMPLE Sum u32 0 0
  {262675, 210},  // ReduceScatter RING SIMPLE Sum i64 0 0
  {328211, 210},  // ReduceScatter RING SIMPLE Sum u64 0 0
  {393747, 211},  // ReduceScatter RING SIMPLE Sum f16 0 0
  {459283, 212},  // ReduceScatter RING SIMPLE Sum f32 0 0
  {524819, 213},  // ReduceScatter RING SIMPLE Sum f64 0 0
  {590355, 214},  // ReduceScatter RING SIMPLE Sum bf16 0 0
  {1638931, 215},  // ReduceScatter RING SIMPLE Sum bf16 0 1
  {655891, 216},  // ReduceScatter RING SIMPLE Sum f8e4m3 0 0
  {721427, 217},  // ReduceScatter RING SIMPLE Sum f8e5m2 0 0
  {4627, 218},  // ReduceScatter RING SIMPLE Prod i8 0 0
  {70163, 218},  // ReduceScatter RING SIMPLE Prod u8 0 0
  {135699, 219},  // ReduceScatter RING SIMPLE Prod i32 0 0
  {201235, 219},  // ReduceScatter RING SIMPLE Prod u32 0 0
  {266771, 220},  // ReduceScatter RING SIMPLE Prod i64 0 0
  {332307, 220},  // ReduceScatter RING SIMPLE Prod u64 0 0
  {397843, 221},  // ReduceScatter RING SIMPLE Prod f16 0 0
  {463379, 222},  // ReduceScatter RING SIMPLE Prod f32 0 0
  {528915, 223},  // ReduceScatter RING SIMPLE Prod f64 0 0
  {594451, 224},  // ReduceScatter RING SIMPLE Prod bf16 0 0
  {1643027, 225},  // ReduceScatter RING SIMPLE Prod bf16 0 1
  {659987, 226},  // ReduceScatter RING SIMPLE Prod f8e4m3 0 0
  {725523, 227},  // ReduceScatter RING SIMPLE Prod f8e5m2 0 0
  {8723, 228},  // ReduceScatter RING SIMPLE MinMax i8 0 0
  {74259, 228},  // ReduceScatter RING SIMPLE MinMax u8 0 0
  {139795, 229},  // ReduceScatter RING SIMPLE MinMax i32 0 0
  {205331, 229},  // ReduceScatter RING SIMPLE MinMax u32 0 0
  {270867, 230},  // ReduceScatter RING SIMPLE MinMax i64 0 0
  {336403, 230},  // ReduceScatter RING SIMPLE MinMax u64 0 0
  {401939, 231},  // ReduceScatter RING SIMPLE MinMax f16 0 0
  {467475, 232},  // ReduceScatter RING SIMPLE MinMax f32 0 0
  {533011, 233},  // ReduceScatter RING SIMPLE MinMax f64 0 0
  {598547, 234},  // ReduceScatter RING SIMPLE MinMax bf16 0 0
  {1647123, 235},  // ReduceScatter RING SIMPLE MinMax bf16 0 1
  {664083, 236},  // ReduceScatter RING SIMPLE MinMax f8e4m3 0 0
  {729619, 237},  // ReduceScatter RING SIMPLE MinMax f8e5m2 0 0
  {12819, 238},  // ReduceScatter RING SIMPLE PreMulSum i8 0 0
  {78355, 238},  // ReduceScatter RING SIMPLE PreMulSum u8 0 0
  {143891, 239},  // ReduceScatter RING SIMPLE PreMulSum i32 0 0
  {209427, 239},  // ReduceScatter RING SIMPLE PreMulSum u32 0 0
  {274963, 240},  // ReduceScatter RING SIMPLE PreMulSum i64 0 0
  {340499, 240},  // ReduceScatter RING SIMPLE PreMulSum u64 0 0
  {406035, 241},  // ReduceScatter RING SIMPLE PreMulSum f16 0 0
  {471571, 242},  // ReduceScatter RING SIMPLE PreMulSum f32 0 0
  {537107, 243},  // ReduceScatter RING SIMPLE PreMulSum f64 0 0
  {602643, 244},  // ReduceScatter RING SIMPLE PreMulSum bf16 0 0
  {1651219, 245},  // ReduceScatter RING SIMPLE PreMulSum bf16 0 1
  {668179, 246},  // ReduceScatter RING SIMPLE PreMulSum f8e4m3 0 0
  {733715, 247},  // ReduceScatter RING SIMPLE PreMulSum f8e5m2 0 0
  {16915, 248},  // ReduceScatter RING SIMPLE SumPostDiv i8 0 0
  {82451, 248},  // ReduceScatter RING SIMPLE SumPostDiv u8 0 0
  {147987, 249},  // ReduceScatter RING SIMPLE SumPostDiv i32 0 0
  {213523, 249},  // ReduceScatter RING SIMPLE SumPostDiv u32 0 0
  {279059, 250},  // ReduceScatter RING SIMPLE SumPostDiv i64 0 0
  {344595, 250},  // ReduceScatter RING SIMPLE SumPostDiv u64 0 0
  {99, 251},  // ReduceScatter PAT LL Sum i8 0 0
  {65635, 251},  // ReduceScatter PAT LL Sum u8 0 0
  {131171, 252},  // ReduceScatter PAT LL Sum i32 0 0
  {196707, 252},  // ReduceScatter PAT LL Sum u32 0 0
  {262243, 253},  // ReduceScatter PAT LL Sum i64 0 0
  {327779, 253},  // ReduceScatter PAT LL Sum u64 0 0
  {393315, 254},  // ReduceScatter PAT LL Sum f16 0 0
  {458851, 255},  // ReduceScatter PAT LL Sum f32 0 0
  {524387, 256},  // ReduceScatter PAT LL Sum f64 0 0
  {589923, 257},  // ReduceScatter PAT LL Sum bf16 0 0
  {1638499, 257},  // ReduceScatter PAT LL Sum bf16 0 1
  {655459, 258},  // ReduceScatter PAT LL Sum f8e4m3 0 0
  {720995, 259},  // ReduceScatter PAT LL Sum f8e5m2 0 0
  {4195, 260},  // ReduceScatter PAT LL Prod i8 0 0
  {69731, 260},  // ReduceScatter PAT LL Prod u8 0 0
  {135267, 261},  // ReduceScatter PAT LL Prod i32 0 0
  {200803, 261},  // ReduceScatter PAT LL Prod u32 0 0
  {266339, 262},  // ReduceScatter PAT LL Prod i64 0 0
  {331875, 262},  // ReduceScatter PAT LL Prod u64 0 0
  {397411, 263},  // ReduceScatter PAT LL Prod f16 0 0
  {462947, 264},  // ReduceScatter PAT LL Prod f32 0 0
  {528483, 265},  // ReduceScatter PAT LL Prod f64 0 0
  {594019, 266},  // ReduceScatter PAT LL Prod bf16 0 0
  {1642595, 266},  // ReduceScatter PAT LL Prod bf16 0 1
  {659555, 267},  // ReduceScatter PAT LL Prod f8e4m3 0 0
  {725091, 268},  // ReduceScatter PAT LL Prod f8e5m2 0 0
  {8291, 269},  // ReduceScatter PAT LL MinMax i8 0 0
  {73827, 269},  // ReduceScatter PAT LL MinMax u8 0 0
  {139363, 270},  // ReduceScatter PAT LL MinMax i32 0 0
  {204899, 270},  // ReduceScatter PAT LL MinMax u32 0 0
  {270435, 271},  // ReduceScatter PAT LL MinMax i64 0 0
  {335971, 271},  // ReduceScatter PAT LL MinMax u64 0 0
  {401507, 272},  // ReduceScatter PAT LL MinMax f16 0 0
  {467043, 273},  // ReduceScatter PAT LL MinMax f32 0 0
  {532579, 274},  // ReduceScatter PAT LL MinMax f64 0 0
  {598115, 275},  // ReduceScatter PAT LL MinMax bf16 0 0
  {1646691, 275},  // ReduceScatter PAT LL MinMax bf16 0 1
  {663651, 276},  // ReduceScatter PAT LL MinMax f8e4m3 0 0
  {729187, 277},  // ReduceScatter PAT LL MinMax f8e5m2 0 0
  {12387, 278},  // ReduceScatter PAT LL PreMulSum i8 0 0
  {77923, 278},  // ReduceScatter PAT LL PreMulSum u8 0 0
  {143459, 279},  // ReduceScatter PAT LL PreMulSum i32 0 0
  {208995, 279},  // ReduceScatter PAT LL PreMulSum u32 0 0
  {274531, 280},  // ReduceScatter PAT LL PreMulSum i64 0 0
  {340067, 280},  // ReduceScatter PAT LL PreMulSum u64 0 0
  {405603, 281},  // ReduceScatter PAT LL PreMulSum f16 0 0
  {471139, 282},  // ReduceScatter PAT LL PreMulSum f32 0 0
  {536675, 283},  // ReduceScatter PAT LL PreMulSum f64 0 0
  {602211, 284},  // ReduceScatter PAT LL PreMulSum bf16 0 0
  {1650787, 284},  // ReduceScatter PAT LL PreMulSum bf16 0 1
  {667747, 285},  // ReduceScatter PAT LL PreMulSum f8e4m3 0 0
  {733283, 286},  // ReduceScatter PAT LL PreMulSum f8e5m2 0 0
  {16483, 287},  // ReduceScatter PAT LL SumPostDiv i8 0 0
  {82019, 287},  // ReduceScatter PAT LL SumPostDiv u8 0 0
  {147555, 288},  // ReduceScatter PAT LL SumPostDiv i32 0 0
  {213091, 288},  // ReduceScatter PAT LL SumPostDiv u32 0 0
  {278627, 289},  // ReduceScatter PAT LL SumPostDiv i64 0 0
  {344163, 289},  // ReduceScatter PAT LL SumPostDiv u64 0 0
  {355, 290},  // ReduceScatter PAT LL128 Sum i8 0 0
  {65891, 290},  // ReduceScatter PAT LL128 Sum u8 0 0
  {131427, 291},  // ReduceScatter PAT LL128 Sum i32 0 0
  {196963, 291},  // ReduceScatter PAT LL128 Sum u32 0 0
  {262499, 292},  // ReduceScatter PAT LL128 Sum i64 0 0
  {328035, 292},  // ReduceScatter PAT LL128 Sum u64 0 0
  {393571, 293},  // ReduceScatter PAT LL128 Sum f16 0 0
  {459107, 294},  // ReduceScatter PAT LL128 Sum f32 0 0
  {524643, 295},  // ReduceScatter PAT LL128 Sum f64 0 0
  {590179, 296},  // ReduceScatter PAT LL128 Sum bf16 0 0
  {1638755, 296},  // ReduceScatter PAT LL128 Sum bf16 0 1
  {655715, 297},  // ReduceScatter PAT LL128 Sum f8e4m3 0 0
  {721251, 298},  // ReduceScatter PAT LL128 Sum f8e5m2 0 0
  {4451, 299},  // ReduceScatter PAT LL128 Prod i8 0 0
  {69987, 299},  // ReduceScatter PAT LL128 Prod u8 0 0
  {135523, 300},  // ReduceScatter PAT LL128 Prod i32 0 0
  {201059, 300},  // ReduceScatter PAT LL128 Prod u32 0 0
  {266595, 301},  // ReduceScatter PAT LL128 Prod i64 0 0
  {332131, 301},  // ReduceScatter PAT LL128 Prod u64 0 0
  {397667, 302},  // ReduceScatter PAT LL128 Prod f16 0 0
  {463203, 303},  // ReduceScatter PAT LL128 Prod f32 0 0
  {528739, 304},  // ReduceScatter PAT LL128 Prod f64 0 0
  {594275, 305},  // ReduceScatter PAT LL128 Prod bf16 0 0
  {1642851, 305},  // ReduceScatter PAT LL128 Prod bf16 0 1
  {659811, 306},  // ReduceScatter PAT LL128 Prod f8e4m3 0 0
  {725347, 307},  // ReduceScatter PAT LL128 Prod f8e5m2 0 0
  {8547, 308},  // ReduceScatter PAT LL128 MinMax i8 0 0
  {74083, 308},  // ReduceScatter PAT LL128 MinMax u8 0 0
  {139619, 309},  // ReduceScatter PAT LL128 MinMax i32 0 0
  {205155, 309},  // ReduceScatter PAT LL128 MinMax u32 0 0
  {270691, 310},  // ReduceScatter PAT LL128 MinMax i64 0 0
  {336227, 310},  // ReduceScatter PAT LL128 MinMax u64 0 0
  {401763, 311},  // ReduceScatter PAT LL128 MinMax f16 0 0
  {467299, 312},  // ReduceScatter PAT LL128 MinMax f32 0 0
  {532835, 313},  // ReduceScatter PAT LL128 MinMax f64 0 0
  {598371, 314},  // ReduceScatter PAT LL128 MinMax bf16 0 0
  {1646947, 314},  // ReduceScatter PAT LL128 MinMax bf16 0 1
  {663907, 315},  // ReduceScatter PAT LL128 MinMax f8e4m3 0 0
  {729443, 316},  // ReduceScatter PAT LL128 MinMax f8e5m2 0 0
  {12643, 317},  // ReduceScatter PAT LL128 PreMulSum i8 0 0
  {78179, 317},  // ReduceScatter PAT LL128 PreMulSum u8 0 0
  {143715, 318},  // ReduceScatter PAT LL128 PreMulSum i32 0 0
  {209251, 318},  // ReduceScatter PAT LL128 PreMulSum u32 0 0
  {274787, 319},  // ReduceScatter PAT LL128 PreMulSum i64 0 0
  {340323, 319},  // ReduceScatter PAT LL128 PreMulSum u64 0 0
  {405859, 320},  // ReduceScatter PAT LL128 PreMulSum f16 0 0
  {471395, 321},  // ReduceScatter PAT LL128 PreMulSum f32 0 0
  {536931, 322},  // ReduceScatter PAT LL128 PreMulSum f64 0 0
  {602467, 323},  // ReduceScatter PAT LL128 PreMulSum bf16 0 0
  {1651043, 323},  // ReduceScatter PAT LL128 PreMulSum bf16 0 1
  {668003, 324},  // ReduceScatter PAT LL128 PreMulSum f8e4m3 0 0
  {733539, 325},  // ReduceScatter PAT LL128 PreMulSum f8e5m2 0 0
  {16739, 326},  // ReduceScatter PAT LL128 SumPostDiv i8 0 0
  {82275, 326},  // ReduceScatter PAT LL128 SumPostDiv u8 0 0
  {147811, 327},  // ReduceScatter PAT LL128 SumPostDiv i32 0 0
  {213347, 327},  // ReduceScatter PAT LL128 SumPostDiv u32 0 0
  {278883, 328},  // ReduceScatter PAT LL128 SumPostDiv i64 0 0
  {344419, 328},  // ReduceScatter PAT LL128 SumPostDiv u64 0 0
  {611, 329},  // ReduceScatter PAT SIMPLE Sum i8 0 0
  {66147, 329},  // ReduceScatter PAT SIMPLE Sum u8 0 0
  {131683, 330},  // ReduceScatter PAT SIMPLE Sum i32 0 0
  {197219, 330},  // ReduceScatter PAT SIMPLE Sum u32 0 0
  {262755, 331},  // ReduceScatter PAT SIMPLE Sum i64 0 0
  {328291, 331},  // ReduceScatter PAT SIMPLE Sum u64 0 0
  {393827, 332},  // ReduceScatter PAT SIMPLE Sum f16 0 0
  {459363, 333},  // ReduceScatter PAT SIMPLE Sum f32 0 0
  {524899, 334},  // ReduceScatter PAT SIMPLE Sum f64 0 0
  {590435, 335},  // ReduceScatter PAT SIMPLE Sum bf16 0 0
  {1639011, 336},  // ReduceScatter PAT SIMPLE Sum bf16 0 1
  {655971, 337},  // ReduceScatter PAT SIMPLE Sum f8e4m3 0 0
  {721507, 338},  // ReduceScatter PAT SIMPLE Sum f8e5m2 0 0
  {4707, 339},  // ReduceScatter PAT SIMPLE Prod i8 0 0
  {70243, 339},  // ReduceScatter PAT SIMPLE Prod u8 0 0
  {135779, 340},  // ReduceScatter PAT SIMPLE Prod i32 0 0
  {201315, 340},  // ReduceScatter PAT SIMPLE Prod u32 0 0
  {266851, 341},  // ReduceScatter PAT SIMPLE Prod i64 0 0
  {332387, 341},  // ReduceScatter PAT SIMPLE Prod u64 0 0
  {397923, 342},  // ReduceScatter PAT SIMPLE Prod f16 0 0
  {463459, 343},  // ReduceScatter PAT SIMPLE Prod f32 0 0
  {528995, 344},  // ReduceScatter PAT SIMPLE Prod f64 0 0
  {594531, 345},  // ReduceScatter PAT SIMPLE Prod bf16 0 0
  {1643107, 346},  // ReduceScatter PAT SIMPLE Prod bf16 0 1
  {660067, 347},  // ReduceScatter PAT SIMPLE Prod f8e4m3 0 0
  {725603, 348},  // ReduceScatter PAT SIMPLE Prod f8e5m2 0 0
  {8803, 349},  // ReduceScatter PAT SIMPLE MinMax i8 0 0
  {74339, 349},  // ReduceScatter PAT SIMPLE MinMax u8 0 0
  {139875, 350},  // ReduceScatter PAT SIMPLE MinMax i32 0 0
  {205411, 350},  // ReduceScatter PAT SIMPLE MinMax u32 0 0
  {270947, 351},  // ReduceScatter PAT SIMPLE MinMax i64 0 0
  {336483, 351},  // ReduceScatter PAT SIMPLE MinMax u64 0 0
  {402019, 352},  // ReduceScatter PAT SIMPLE MinMax f16 0 0
  {467555, 353},  // ReduceScatter PAT SIMPLE MinMax f32 0 0
  {533091, 354},  // ReduceScatter PAT SIMPLE MinMax f64 0 0
  {598627, 355},  // ReduceScatter PAT SIMPLE MinMax bf16 0 0
  {1647203, 356},  // ReduceScatter PAT SIMPLE MinMax bf16 0 1
  {664163, 357},  // ReduceScatter PAT SIMPLE MinMax f8e4m3 0 0
  {729699, 358},  // ReduceScatter PAT SIMPLE MinMax f8e5m2 0 0
  {12899, 359},  // ReduceScatter PAT SIMPLE PreMulSum i8 0 0
  {78435, 359},  // ReduceScatter PAT SIMPLE PreMulSum u8 0 0
  {143971, 360},  // ReduceScatter PAT SIMPLE PreMulSum i32 0 0
  {209507, 360},  // ReduceScatter PAT SIMPLE PreMulSum u32 0 0
  {275043, 361},  // ReduceScatter PAT SIMPLE PreMulSum i64 0 0
  {340579, 361},  // ReduceScatter PAT SIMPLE PreMulSum u64 0 0
  {406115, 362},  // ReduceScatter PAT SIMPLE PreMulSum f16 0 0
  {471651, 363},  // ReduceScatter PAT SIMPLE PreMulSum f32 0 0
  {537187, 364},  // ReduceScatter PAT SIMPLE PreMulSum f64 0 0
  {602723, 365},  // ReduceScatter PAT SIMPLE PreMulSum bf16 0 0
  {1651299, 366},  // ReduceScatter PAT SIMPLE PreMulSum bf16 0 1
  {668259, 367},  // ReduceScatter PAT SIMPLE PreMulSum f8e4m3 0 0
  {733795, 368},  // ReduceScatter PAT SIMPLE PreMulSum f8e5m2 0 0
  {16995, 369},  // ReduceScatter PAT SIMPLE SumPostDiv i8 0 0
  {82531, 369},  // ReduceScatter PAT SIMPLE SumPostDiv u8 0 0
  {148067, 370},  // ReduceScatter PAT SIMPLE SumPostDiv i32 0 0
  {213603, 370},  // ReduceScatter PAT SIMPLE SumPostDiv u32 0 0
  {279139, 371},  // ReduceScatter PAT SIMPLE SumPostDiv i64 0 0
  {344675, 371},  // ReduceScatter PAT SIMPLE SumPostDiv u64 0 0
  {4, 372},  // AllReduce TREE LL Sum i8 0 0
  {65540, 372},  // AllReduce TREE LL Sum u8 0 0
  {131076, 373},  // AllReduce TREE LL Sum i32 0 0
  {196612, 373},  // AllReduce TREE LL Sum u32 0 0
  {262148, 374},  // AllReduce TREE LL Sum i64 0 0
  {327684, 374},  // AllReduce TREE LL Sum u64 0 0
  {393220, 375},  // AllReduce TREE LL Sum f16 0 0
  {458756, 376},  // AllReduce TREE LL Sum f32 0 0
  {524292, 377},  // AllReduce TREE LL Sum f64 0 0
  {589828, 378},  // AllReduce TREE LL Sum bf16 0 0
  {1638404, 378},  // AllReduce TREE LL Sum bf16 0 1
  {655364, 379},  // AllReduce TREE LL Sum f8e4m3 0 0
  {720900, 380},  // AllReduce TREE LL Sum f8e5m2 0 0
  {4100, 381},  // AllReduce TREE LL Prod i8 0 0
  {69636, 381},  // AllReduce TREE LL Prod u8 0 0
  {135172, 382},  // AllReduce TREE LL Prod i32 0 0
  {200708, 382},  // AllReduce TREE LL Prod u32 0 0
  {266244, 383},  // AllReduce TREE LL Prod i64 0 0
  {331780, 383},  // AllReduce TREE LL Prod u64 0 0
  {397316, 384},  // AllReduce TREE LL Prod f16 0 0
  {462852, 385},  // AllReduce TREE LL Prod f32 0 0
  {528388, 386},  // AllReduce TREE LL Prod f64 0 0
  {593924, 387},  // AllReduce TREE LL Prod bf16 0 0
  {1642500, 387},  // AllReduce TREE LL Prod bf16 0 1
  {659460, 388},  // AllReduce TREE LL Prod f8e4m3 0 0
  {724996, 389},  // AllReduce TREE LL Prod f8e5m2 0 0
  {8196, 390},  // AllReduce TREE LL MinMax i8 0 0
  {73732, 390},  // AllReduce TREE LL MinMax u8 0 0
  {139268, 391},  // AllReduce TREE LL MinMax i32 0 0
  {204804, 391},  // AllReduce TREE LL MinMax u32 0 0
  {270340, 392},  // AllReduce TREE LL MinMax i64 0 0
  {335876, 392},  // AllReduce TREE LL MinMax u64 0 0
  {401412, 393},  // AllReduce TREE LL MinMax f16 0 0
  {466948, 394},  // AllReduce TREE LL MinMax f32 0 0
  {532484, 395},  // AllReduce TREE LL MinMax f64 0 0
  {598020, 396},  // AllReduce TREE LL MinMax bf16 0 0
  {1646596, 396},  // AllReduce TREE LL MinMax bf16 0 1
  {663556, 397},  // AllReduce TREE LL MinMax f8e4m3 0 0
  {729092, 398},  // AllReduce TREE LL MinMax f8e5m2 0 0
  {12292, 399},  // AllReduce TREE LL PreMulSum i8 0 0
  {77828, 399},  // AllReduce TREE LL PreMulSum u8 0 0
  {143364, 400},  // AllReduce TREE LL PreMulSum i32 0 0
  {208900, 400},  // AllReduce TREE LL PreMulSum u32 0 0
  {274436, 401},  // AllReduce TREE LL PreMulSum i64 0 0
  {339972, 401},  // AllReduce TREE LL PreMulSum u64 0 0
  {405508, 402},  // AllReduce TREE LL PreMulSum f16 0 0
  {471044, 403},  // AllReduce TREE LL PreMulSum f32 0 0
  {536580, 404},  // AllReduce TREE LL PreMulSum f64 0 0
  {602116, 405},  // AllReduce TREE LL PreMulSum bf16 0 0
  {1650692, 405},  // AllReduce TREE LL PreMulSum bf16 0 1
  {667652, 406},  // AllReduce TREE LL PreMulSum f8e4m3 0 0
  {733188, 407},  // AllReduce TREE LL PreMulSum f8e5m2 0 0
  {16388, 408},  // AllReduce TREE LL SumPostDiv i8 0 0
  {81924, 408},  // AllReduce TREE LL SumPostDiv u8 0 0
  {147460, 409},  // AllReduce TREE LL SumPostDiv i32 0 0
  {212996, 409},  // AllReduce TREE LL SumPostDiv u32 0 0
  {278532, 410},  // AllReduce TREE LL SumPostDiv i64 0 0
  {344068, 410},  // AllReduce TREE LL SumPostDiv u64 0 0
  {260, 411},  // AllReduce TREE LL128 Sum i8 0 0
  {65796, 411},  // AllReduce TREE LL128 Sum u8 0 0
  {131332, 412},  // AllReduce TREE LL128 Sum i32 0 0
  {196868, 412},  // AllReduce TREE LL128 Sum u32 0 0
  {262404, 413},  // AllReduce TREE LL128 Sum i64 0 0
  {327940, 413},  // AllReduce TREE LL128 Sum u64 0 0
  {393476, 414},  // AllReduce TREE LL128 Sum f16 0 0
  {459012, 415},  // AllReduce TREE LL128 Sum f32 0 0
  {524548, 416},  // AllReduce TREE LL128 Sum f64 0 0
  {590084, 417},  // AllReduce TREE LL128 Sum bf16 0 0
  {1638660, 417},  // AllReduce TREE LL128 Sum bf16 0 1
  {655620, 418},  // AllReduce TREE LL128 Sum f8e4m3 0 0
  {721156, 419},  // AllReduce TREE LL128 Sum f8e5m2 0 0
  {4356, 420},  // AllReduce TREE LL128 Prod i8 0 0
  {69892, 420},  // AllReduce TREE LL128 Prod u8 0 0
  {135428, 421},  // AllReduce TREE LL128 Prod i32 0 0
  {200964, 421},  // AllReduce TREE LL128 Prod u32 0 0
  {266500, 422},  // AllReduce TREE LL128 Prod i64 0 0
  {332036, 422},  // AllReduce TREE LL128 Prod u64 0 0
  {397572, 423},  // AllReduce TREE LL128 Prod f16 0 0
  {463108, 424},  // AllReduce TREE LL128 Prod f32 0 0
  {528644, 425},  // AllReduce TREE LL128 Prod f64 0 0
  {594180, 426},  // AllReduce TREE LL128 Prod bf16 0 0
  {1642756, 426},  // AllReduce TREE LL128 Prod bf16 0 1
  {659716, 427},  // AllReduce TREE LL128 Prod f8e4m3 0 0
  {725252, 428},  // AllReduce TREE LL128 Prod f8e5m2 0 0
  {8452, 429},  // AllReduce TREE LL128 MinMax i8 0 0
  {73988, 429},  // AllReduce TREE LL128 MinMax u8 0 0
  {139524, 430},  // AllReduce TREE LL128 MinMax i32 0 0
  {205060, 430},  // AllReduce TREE LL128 MinMax u32 0 0
  {270596, 431},  // AllReduce TREE LL128 MinMax i64 0 0
  {336132, 431},  // AllReduce TREE LL128 MinMax u64 0 0
  {401668, 432},  // AllReduce TREE LL128 MinMax f16 0 0
  {467204, 433},  // AllReduce TREE LL128 MinMax f32 0 0
  {532740, 434},  // AllReduce TREE LL128 MinMax f64 0 0
  {598276, 435},  // AllReduce TREE LL128 MinMax bf16 0 0
  {1646852, 435},  // AllReduce TREE LL128 MinMax bf16 0 1
  {663812, 436},  // AllReduce TREE LL128 MinMax f8e4m3 0 0
  {729348, 437},  // AllReduce TREE LL128 MinMax f8e5m2 0 0
  {12548, 438},  // AllReduce TREE LL128 PreMulSum i8 0 0
  {78084, 438},  // AllReduce TREE LL128 PreMulSum u8 0 0
  {143620, 439},  // AllReduce TREE LL128 PreMulSum i32 0 0
  {209156, 439},  // AllReduce TREE LL128 PreMulSum u32 0 0
  {274692, 440},  // AllReduce TREE LL128 PreMulSum i64 0 0
  {340228, 440},  // AllReduce TREE LL128 PreMulSum u64 0 0
  {405764, 441},  // AllReduce TREE LL128 PreMulSum f16 0 0
  {471300, 442},  // AllReduce TREE LL128 PreMulSum f32 0 0
  {536836, 443},  // AllReduce TREE LL128 PreMulSum f64 0 0
  {602372, 444},  // AllReduce TREE LL128 PreMulSum bf16 0 0
  {1650948, 444},  // AllReduce TREE LL128 PreMulSum bf16 0 1
  {667908, 445},  // AllReduce TREE LL128 PreMulSum f8e4m3 0 0
  {733444, 446},  // AllReduce TREE LL128 PreMulSum f8e5m2 0 0
  {16644, 447},  // AllReduce TREE LL128 SumPostDiv i8 0 0
  {82180, 447},  // AllReduce TREE LL128 SumPostDiv u8 0 0
  {147716, 448},  // AllReduce TREE LL128 SumPostDiv i32 0 0
  {213252, 448},  // AllReduce TREE LL128 SumPostDiv u32 0 0
  {278788, 449},  // AllReduce TREE LL128 SumPostDiv i64 0 0
  {344324, 449},  // AllReduce TREE LL128 SumPostDiv u64 0 0
  {516, 450},  // AllReduce TREE SIMPLE Sum i8 0 0
  {66052, 450},  // AllReduce TREE SIMPLE Sum u8 0 0
  {131588, 451},  // AllReduce TREE SIMPLE Sum i32 0 0
  {197124, 451},  // AllReduce TREE SIMPLE Sum u32 0 0
  {262660, 452},  // AllReduce TREE SIMPLE Sum i64 0 0
  {328196, 452},  // AllReduce TREE SIMPLE Sum u64 0 0
  {393732, 453},  // AllReduce TREE SIMPLE Sum f16 0 0
  {459268, 454},  // AllReduce TREE SIMPLE Sum f32 0 0
  {524804, 455},  // AllReduce TREE SIMPLE Sum f64 0 0
  {590340, 456},  // AllReduce TREE SIMPLE Sum bf16 0 0
  {1638916, 457},  // AllReduce TREE SIMPLE Sum bf16 0 1
  {655876, 458},  // AllReduce TREE SIMPLE Sum f8e4m3 0 0
  {721412, 459},  // AllReduce TREE SIMPLE Sum f8e5m2 0 0
  {4612, 460},  // AllReduce TREE SIMPLE Prod i8 0 0
  {70148, 460},  // AllReduce TREE SIMPLE Prod u8 0 0
  {135684, 461},  // AllReduce TREE SIMPLE Prod i32 0 0
  {201220, 461},  // AllReduce TREE SIMPLE Prod u32 0 0
  {266756, 462},  // AllReduce TREE SIMPLE Prod i64 0 0
  {332292, 462},  // AllReduce TREE SIMPLE Prod u64 0 0
  {397828, 463},  // AllReduce TREE SIMPLE Prod f16 0 0
  {463364, 464},  // AllReduce TREE SIMPLE Prod f32 0 0
  {528900, 465},  // AllReduce TREE SIMPLE Prod f64 0 0
  {594436, 466},  // AllReduce TREE SIMPLE Prod bf16 0 0
  {1643012, 467},  // AllReduce TREE SIMPLE Prod bf16 0 1
  {659972, 468},  // AllReduce TREE SIMPLE Prod f8e4m3 0 0
  {725508, 469},  // AllReduce TREE SIMPLE Prod f8e5m2 0 0
  {8708, 470},  // AllReduce TREE SIMPLE MinMax i8 0 0
  {74244, 470},  // AllReduce TREE SIMPLE MinMax u8 0 0
  {139780, 471},  // AllReduce TREE SIMPLE MinMax i32 0 0
  {205316, 471},  // AllReduce TREE SIMPLE MinMax u32 0 0
  {270852, 472},  // AllReduce TREE SIMPLE MinMax i64 0 0
  {336388, 472},  // AllReduce TREE SIMPLE MinMax u64 0 0
  {401924, 473},  // AllReduce TREE SIMPLE MinMax f16 0 0
  {467460, 474},  // AllReduce TREE SIMPLE MinMax f32 0 0
  {532996, 475},  // AllReduce TREE SIMPLE MinMax f64 0 0
  {598532, 476},  // AllReduce TREE SIMPLE MinMax bf16 0 0
  {1647108, 477},  // AllReduce TREE SIMPLE MinMax bf16 0 1
  {664068, 478},  // AllReduce TREE SIMPLE MinMax f8e4m3 0 0
  {729604, 479},  // AllReduce TREE SIMPLE MinMax f8e5m2 0 0
  {12804, 480},  // AllReduce TREE SIMPLE PreMulSum i8 0 0
  {78340, 480},  // AllReduce TREE SIMPLE PreMulSum u8 0 0
  {143876, 481},  // AllReduce TREE SIMPLE PreMulSum i32 0 0
  {209412, 481},  // AllReduce TREE SIMPLE PreMulSum u32 0 0
  {274948, 482},  // AllReduce TREE SIMPLE PreMulSum i64 0 0
  {340484, 482},  // AllReduce TREE SIMPLE PreMulSum u64 0 0
  {406020, 483},  // AllReduce TREE SIMPLE PreMulSum f16 0 0
  {471556, 484},  // AllReduce TREE SIMPLE PreMulSum f32 0 0
  {537092, 485},  // AllReduce TREE SIMPLE PreMulSum f64 0 0
  {602628, 486},  // AllReduce TREE SIMPLE PreMulSum bf16 0 0
  {1651204, 487},  // AllReduce TREE SIMPLE PreMulSum bf16 0 1
  {668164, 488},  // AllReduce TREE SIMPLE PreMulSum f8e4m3 0 0
  {733700, 489},  // AllReduce TREE SIMPLE PreMulSum f8e5m2 0 0
  {16900, 490},  // AllReduce TREE SIMPLE SumPostDiv i8 0 0
  {82436, 490},  // AllReduce TREE SIMPLE SumPostDiv u8 0 0
  {147972, 491},  // AllReduce TREE SIMPLE SumPostDiv i32 0 0
  {213508, 491},  // AllReduce TREE SIMPLE SumPostDiv u32 0 0
  {279044, 492},  // AllReduce TREE SIMPLE SumPostDiv i64 0 0
  {344580, 492},  // AllReduce TREE SIMPLE SumPostDiv u64 0 0
  {20, 493},  // AllReduce RING LL Sum i8 0 0
  {65556, 493},  // AllReduce RING LL Sum u8 0 0
  {131092, 494},  // AllReduce RING LL Sum i32 0 0
  {196628, 494},  // AllReduce RING LL Sum u32 0 0
  {262164, 495},  // AllReduce RING LL Sum i64 0 0
  {327700, 495},  // AllReduce RING LL Sum u64 0 0
  {393236, 496},  // AllReduce RING LL Sum f16 0 0
  {458772, 497},  // AllReduce RING LL Sum f32 0 0
  {524308, 498},  // AllReduce RING LL Sum f64 0 0
  {589844, 499},  // AllReduce RING LL Sum bf16 0 0
  {1638420, 499},  // AllReduce RING LL Sum bf16 0 1
  {655380, 500},  // AllReduce RING LL Sum f8e4m3 0 0
  {720916, 501},  // AllReduce RING LL Sum f8e5m2 0 0
  {4116, 502},  // AllReduce RING LL Prod i8 0 0
  {69652, 502},  // AllReduce RING LL Prod u8 0 0
  {135188, 503},  // AllReduce RING LL Prod i32 0 0
  {200724, 503},  // AllReduce RING LL Prod u32 0 0
  {266260, 504},  // AllReduce RING LL Prod i64 0 0
  {331796, 504},  // AllReduce RING LL Prod u64 0 0
  {397332, 505},  // AllReduce RING LL Prod f16 0 0
  {462868, 506},  // AllReduce RING LL Prod f32 0 0
  {528404, 507},  // AllReduce RING LL Prod f64 0 0
  {593940, 508},  // AllReduce RING LL Prod bf16 0 0
  {1642516, 508},  // AllReduce RING LL Prod bf16 0 1
  {659476, 509},  // AllReduce RING LL Prod f8e4m3 0 0
  {725012, 510},  // AllReduce RING LL Prod f8e5m2 0 0
  {8212, 511},  // AllReduce RING LL MinMax i8 0 0
  {73748, 511},  // AllReduce RING LL MinMax u8 0 0
  {139284, 512},  // AllReduce RING LL MinMax i32 0 0
  {204820, 512},  // AllReduce RING LL MinMax u32 0 0
  {270356, 513},  // AllReduce RING LL MinMax i64 0 0
  {335892, 513},  // AllReduce RING LL MinMax u64 0 0
  {401428, 514},  // AllReduce RING LL MinMax f16 0 0
  {466964, 515},  // AllReduce RING LL MinMax f32 0 0
  {532500, 516},  // AllReduce RING LL MinMax f64 0 0
  {598036, 517},  // AllReduce RING LL MinMax bf16 0 0
  {1646612, 517},  // AllReduce RING LL MinMax bf16 0 1
  {663572, 518},  // AllReduce RING LL MinMax f8e4m3 0 0
  {729108, 519},  // AllReduce RING LL MinMax f8e5m2 0 0
  {12308, 520},  // AllReduce RING LL PreMulSum i8 0 0
  {77844, 520},  // AllReduce RING LL PreMulSum u8 0 0
  {143380, 521},  // AllReduce RING LL PreMulSum i32 0 0
  {208916, 521},  // AllReduce RING LL PreMulSum u32 0 0
  {274452, 522},  // AllReduce RING LL PreMulSum i64 0 0
  {339988, 522},  // AllReduce RING LL PreMulSum u64 0 0
  {405524, 523},  // AllReduce RING LL PreMulSum f16 0 0
  {471060, 524},  // AllReduce RING LL PreMulSum f32 0 0
  {536596, 525},  // AllReduce RING LL PreMulSum f64 0 0
  {602132, 526},  // AllReduce RING LL PreMulSum bf16 0 0
  {1650708, 526},  // AllReduce RING LL PreMulSum bf16 0 1
  {667668, 527},  // AllReduce RING LL PreMulSum f8e4m3 0 0
  {733204, 528},  // AllReduce RING LL PreMulSum f8e5m2 0 0
  {16404, 529},  // AllReduce RING LL SumPostDiv i8 0 0
  {81940, 529},  // AllReduce RING LL SumPostDiv u8 0 0
  {147476, 530},  // AllReduce RING LL SumPostDiv i32 0 0
  {213012, 530},  // AllReduce RING LL SumPostDiv u32 0 0
  {278548, 531},  // AllReduce RING LL SumPostDiv i64 0 0
  {344084, 531},  // AllReduce RING LL SumPostDiv u64 0 0
  {276, 532},  // AllReduce RING LL128 Sum i8 0 0
  {65812, 532},  // AllReduce RING LL128 Sum u8 0 0
  {131348, 533},  // AllReduce RING LL128 Sum i32 0 0
  {196884, 533},  // AllReduce RING LL128 Sum u32 0 0
  {262420, 534},  // AllReduce RING LL128 Sum i64 0 0
  {327956, 534},  // AllReduce RING LL128 Sum u64 0 0
  {393492, 535},  // AllReduce RING LL128 Sum f16 0 0
  {459028, 536},  // AllReduce RING LL128 Sum f32 0 0
  {524564, 537},  // AllReduce RING LL128 Sum f64 0 0
  {590100, 538},  // AllReduce RING LL128 Sum bf16 0 0
  {1638676, 538},  // AllReduce RING LL128 Sum bf16 0 1
  {655636, 539},  // AllReduce RING LL128 Sum f8e4m3 0 0
  {721172, 540},  // AllReduce RING LL128 Sum f8e5m2 0 0
  {4372, 541},  // AllReduce RING LL128 Prod i8 0 0
  {69908, 541},  // AllReduce RING LL128 Prod u8 0 0
  {135444, 542},  // AllReduce RING LL128 Prod i32 0 0
  {200980, 542},  // AllReduce RING LL128 Prod u32 0 0
  {266516, 543},  // AllReduce RING LL128 Prod i64 0 0
  {332052, 543},  // AllReduce RING LL128 Prod u64 0 0
  {397588, 544},  // AllReduce RING LL128 Prod f16 0 0
  {463124, 545},  // AllReduce RING LL128 Prod f32 0 0
  {528660, 546},  // AllReduce RING LL128 Prod f64 0 0
  {594196, 547},  // AllReduce RING LL128 Prod bf16 0 0
  {1642772, 547},  // AllReduce RING LL128 Prod bf16 0 1
  {659732, 548},  // AllReduce RING LL128 Prod f8e4m3 0 0
  {725268, 549},  // AllReduce RING LL128 Prod f8e5m2 0 0
  {8468, 550},  // AllReduce RING LL128 MinMax i8 0 0
  {74004, 550},  // AllReduce RING LL128 MinMax u8 0 0
  {139540, 551},  // AllReduce RING LL128 MinMax i32 0 0
  {205076, 551},  // AllReduce RING LL128 MinMax u32 0 0
  {270612, 552},  // AllReduce RING LL128 MinMax i64 0 0
  {336148, 552},  // AllReduce RING LL128 MinMax u64 0 0
  {401684, 553},  // AllReduce RING LL128 MinMax f16 0 0
  {467220, 554},  // AllReduce RING LL128 MinMax f32 0 0
  {532756, 555},  // AllReduce RING LL128 MinMax f64 0 0
  {598292, 556},  // AllReduce RING LL128 MinMax bf16 0 0
  {1646868, 556},  // AllReduce RING LL128 MinMax bf16 0 1
  {663828, 557},  // AllReduce RING LL128 MinMax f8e4m3 0 0
  {729364, 558},  // AllReduce RING LL128 MinMax f8e5m2 0 0
  {12564, 559},  // AllReduce RING LL128 PreMulSum i8 0 0
  {78100, 559},  // AllReduce RING LL128 PreMulSum u8 0 0
  {143636, 560},  // AllReduce RING LL128 PreMulSum i32 0 0
  {209172, 560},  // AllReduce RING LL128 PreMulSum u32 0 0
  {274708, 561},  // AllReduce RING LL128 PreMulSum i64 0 0
  {340244, 561},  // AllReduce RING LL128 PreMulSum u64 0 0
  {405780, 562},  // AllReduce RING LL128 PreMulSum f16 0 0
  {471316, 563},  // AllReduce RING LL128 PreMulSum f32 0 0
  {536852, 564},  // AllReduce RING LL128 PreMulSum f64 0 0
  {602388, 565},  // AllReduce RING LL128 PreMulSum bf16 0 0
  {1650964, 565},  // AllReduce RING LL128 PreMulSum bf16 0 1
  {667924, 566},  // AllReduce RING LL128 PreMulSum f8e4m3 0 0
  {733460, 567},  // AllReduce RING LL128 PreMulSum f8e5m2 0 0
  {16660, 568},  // AllReduce RING LL128 SumPostDiv i8 0 0
  {82196, 568},  // AllReduce RING LL128 SumPostDiv u8 0 0
  {147732, 569},  // AllReduce RING LL128 SumPostDiv i32 0 0
  {213268, 569},  // AllReduce RING LL128 SumPostDiv u32 0 0
  {278804, 570},  // AllReduce RING LL128 SumPostDiv i64 0 0
  {344340, 570},  // AllReduce RING LL128 SumPostDiv u64 0 0
  {532, 571},  // AllReduce RING SIMPLE Sum i8 0 0
  {66068, 571},  // AllReduce RING SIMPLE Sum u8 0 0
  {131604, 572},  // AllReduce RING SIMPLE Sum i32 0 0
  {197140, 572},  // AllReduce RING SIMPLE Sum u32 0 0
  {262676, 573},  // AllReduce RING SIMPLE Sum i64 0 0
  {328212, 573},  // AllReduce RING SIMPLE Sum u64 0 0
  {393748, 574},  // AllReduce RING SIMPLE Sum f16 0 0
  {459284, 575},  // AllReduce RING SIMPLE Sum f32 0 0
  {524820, 576},  // AllReduce RING SIMPLE Sum f64 0 0
  {590356, 577},  // AllReduce RING SIMPLE Sum bf16 0 0
  {1638932, 578},  // AllReduce RING SIMPLE Sum bf16 0 1
  {655892, 579},  // AllReduce RING SIMPLE Sum f8e4m3 0 0
  {721428, 580},  // AllReduce RING SIMPLE Sum f8e5m2 0 0
  {4628, 581},  // AllReduce RING SIMPLE Prod i8 0 0
  {70164, 581},  // AllReduce RING SIMPLE Prod u8 0 0
  {135700, 582},  // AllReduce RING SIMPLE Prod i32 0 0
  {201236, 582},  // AllReduce RING SIMPLE Prod u32 0 0
  {266772, 583},  // AllReduce RING SIMPLE Prod i64 0 0
  {332308, 583},  // AllReduce RING SIMPLE Prod u64 0 0
  {397844, 584},  // AllReduce RING SIMPLE Prod f16 0 0
  {463380, 585},  // AllReduce RING SIMPLE Prod f32 0 0
  {528916, 586},  // AllReduce RING SIMPLE Prod f64 0 0
  {594452, 587},  // AllReduce RING SIMPLE Prod bf16 0 0
  {1643028, 588},  // AllReduce RING SIMPLE Prod bf16 0 1
  {659988, 589},  // AllReduce RING SIMPLE Prod f8e4m3 0 0
  {725524, 590},  // AllReduce RING SIMPLE Prod f8e5m2 0 0
  {8724, 591},  // AllReduce RING SIMPLE MinMax i8 0 0
  {74260, 591},  // AllReduce RING SIMPLE MinMax u8 0 0
  {139796, 592},  // AllReduce RING SIMPLE MinMax i32 0 0
  {205332, 592},  // AllReduce RING SIMPLE MinMax u32 0 0
  {270868, 593},  // AllReduce RING SIMPLE MinMax i64 0 0
  {336404, 593},  // AllReduce RING SIMPLE MinMax u64 0 0
  {401940, 594},  // AllReduce RING SIMPLE MinMax f16 0 0
  {467476, 595},  // AllReduce RING SIMPLE MinMax f32 0 0
  {533012, 596},  // AllReduce RING SIMPLE MinMax f64 0 0
  {598548, 597},  // AllReduce RING SIMPLE MinMax bf16 0 0
  {1647124, 598},  // AllReduce RING SIMPLE MinMax bf16 0 1
  {664084, 599},  // AllReduce RING SIMPLE MinMax f8e4m3 0 0
  {729620, 600},  // AllReduce RING SIMPLE MinMax f8e5m2 0 0
  {12820, 601},  // AllReduce RING SIMPLE PreMulSum i8 0 0
  {78356, 601},  // AllReduce RING SIMPLE PreMulSum u8 0 0
  {143892, 602},  // AllReduce RING SIMPLE PreMulSum i32 0 0
  {209428, 602},  // AllReduce RING SIMPLE PreMulSum u32 0 0
  {274964, 603},  // AllReduce RING SIMPLE PreMulSum i64 0 0
  {340500, 603},  // AllReduce RING SIMPLE PreMulSum u64 0 0
  {406036, 604},  // AllReduce RING SIMPLE PreMulSum f16 0 0
  {471572, 605},  // AllReduce RING SIMPLE PreMulSum f32 0 0
  {537108, 606},  // AllReduce RING SIMPLE PreMulSum f64 0 0
  {602644, 607},  // AllReduce RING SIMPLE PreMulSum bf16 0 0
  {1651220, 608},  // AllReduce RING SIMPLE PreMulSum bf16 0 1
  {668180, 609},  // AllReduce RING SIMPLE PreMulSum f8e4m3 0 0
  {733716, 610},  // AllReduce RING SIMPLE PreMulSum f8e5m2 0 0
  {16916, 611},  // AllReduce RING SIMPLE SumPostDiv i8 0 0
  {82452, 611},  // AllReduce RING SIMPLE SumPostDiv u8 0 0
  {147988, 612},  // AllReduce RING SIMPLE SumPostDiv i32 0 0
  {213524, 612},  // AllReduce RING SIMPLE SumPostDiv u32 0 0
  {279060, 613},  // AllReduce RING SIMPLE SumPostDiv i64 0 0
  {344596, 613},  // AllReduce RING SIMPLE SumPostDiv u64 0 0
  {6, 614},  // SendRecv RING SIMPLE Sum i8 0 0
  {9, 615},  // AllToAllPivot RING SIMPLE Sum i8 0 0
  {5, 616},  // AllReduceWithBias TREE LL Sum i8 1 0
  {65541, 616},  // AllReduceWithBias TREE LL Sum u8 1 0
  {131077, 617},  // AllReduceWithBias TREE LL Sum i32 1 0
  {196613, 617},  // AllReduceWithBias TREE LL Sum u32 1 0
  {262149, 618},  // AllReduceWithBias TREE LL Sum i64 1 0
  {327685, 618},  // AllReduceWithBias TREE LL Sum u64 1 0
  {393221, 619},  // AllReduceWithBias TREE LL Sum f16 1 0
  {458757, 620},  // AllReduceWithBias TREE LL Sum f32 1 0
  {524293, 621},  // AllReduceWithBias TREE LL Sum f64 1 0
  {589829, 622},  // AllReduceWithBias TREE LL Sum bf16 1 0
  {655365, 623},  // AllReduceWithBias TREE LL Sum f8e4m3 1 0
  {720901, 624},  // AllReduceWithBias TREE LL Sum f8e5m2 1 0
  {4101, 625},  // AllReduceWithBias TREE LL Prod i8 1 0
  {69637, 625},  // AllReduceWithBias TREE LL Prod u8 1 0
  {135173, 626},  // AllReduceWithBias TREE LL Prod i32 1 0
  {200709, 626},  // AllReduceWithBias TREE LL Prod u32 1 0
  {266245, 627},  // AllReduceWithBias TREE LL Prod i64 1 0
  {331781, 627},  // AllReduceWithBias TREE LL Prod u64 1 0
  {397317, 628},  // AllReduceWithBias TREE LL Prod f16 1 0
  {462853, 629},  // AllReduceWithBias TREE LL Prod f32 1 0
  {528389, 630},  // AllReduceWithBias TREE LL Prod f64 1 0
  {593925, 631},  // AllReduceWithBias TREE LL Prod bf16 1 0
  {659461, 632},  // AllReduceWithBias TREE LL Prod f8e4m3 1 0
  {724997, 633},  // AllReduceWithBias TREE LL Prod f8e5m2 1 0
  {8197, 634},  // AllReduceWithBias TREE LL MinMax i8 1 0
  {73733, 634},  // AllReduceWithBias TREE LL MinMax u8 1 0
  {139269, 635},  // AllReduceWithBias TREE LL MinMax i32 1 0
  {204805, 635},  // AllReduceWithBias TREE LL MinMax u32 1 0
  {270341, 636},  // AllReduceWithBias TREE LL MinMax i64 1 0
  {335877, 636},  // AllReduceWithBias TREE LL MinMax u64 1 0
  {401413, 637},  // AllReduceWithBias TREE LL MinMax f16 1 0
  {466949, 638},  // AllReduceWithBias TREE LL MinMax f32 1 0
  {532485, 639},  // AllReduceWithBias TREE LL MinMax f64 1 0
  {598021, 640},  // AllReduceWithBias TREE LL MinMax bf16 1 0
  {663557, 641},  // AllReduceWithBias TREE LL MinMax f8e4m3 1 0
  {729093, 642},  // AllReduceWithBias TREE LL MinMax f8e5m2 1 0
  {12293, 643},  // AllReduceWithBias TREE LL PreMulSum i8 1 0
  {77829, 643},  // AllReduceWithBias TREE LL PreMulSum u8 1 0
  {143365, 644},  // AllReduceWithBias TREE LL PreMulSum i32 1 0
  {208901, 644},  // AllReduceWithBias TREE LL PreMulSum u32 1 0
  {274437, 645},  // AllReduceWithBias TREE LL PreMulSum i64 1 0
  {339973, 645},  // AllReduceWithBias TREE LL PreMulSum u64 1 0
  {405509, 646},  // AllReduceWithBias TREE LL PreMulSum f16 1 0
  {471045, 647},  // AllReduceWithBias TREE LL PreMulSum f32 1 0
  {536581, 648},  // AllReduceWithBias TREE LL PreMulSum f64 1 0
  {602117, 649},  // AllReduceWithBias TREE LL PreMulSum bf16 1 0
  {667653, 650},  // AllReduceWithBias TREE LL PreMulSum f8e4m3 1 0
  {733189, 651},  // AllReduceWithBias TREE LL PreMulSum f8e5m2 1 0
  {16389, 652},  // AllReduceWithBias TREE LL SumPostDiv i8 1 0
  {81925, 652},  // AllReduceWithBias TREE LL SumPostDiv u8 1 0
  {147461, 653},  // AllReduceWithBias TREE LL SumPostDiv i32 1 0
  {212997, 653},  // AllReduceWithBias TREE LL SumPostDiv u32 1 0
  {278533, 654},  // AllReduceWithBias TREE LL SumPostDiv i64 1 0
  {344069, 654},  // AllReduceWithBias TREE LL SumPostDiv u64 1 0
  {261, 655},  // AllReduceWithBias TREE LL128 Sum i8 1 0
  {65797, 655},  // AllReduceWithBias TREE LL128 Sum u8 1 0
  {131333, 656},  // AllReduceWithBias TREE LL128 Sum i32 1 0
  {196869, 656},  // AllReduceWithBias TREE LL128 Sum u32 1 0
  {262405, 657},  // AllReduceWithBias TREE LL128 Sum i64 1 0
  {327941, 657},  // AllReduceWithBias TREE LL128 Sum u64 1 0
  {393477, 658},  // AllReduceWithBias TREE LL128 Sum f16 1 0
  {459013, 659},  // AllReduceWithBias TREE LL128 Sum f32 1 0
  {524549, 660},  // AllReduceWithBias TREE LL128 Sum f64 1 0
  {590085, 661},  // AllReduceWithBias TREE LL128 Sum bf16 1 0
  {655621, 662},  // AllReduceWithBias TREE LL128 Sum f8e4m3 1 0
  {721157, 663},  // AllReduceWithBias TREE LL128 Sum f8e5m2 1 0
  {4357, 664},  // AllReduceWithBias TREE LL128 Prod i8 1 0
  {69893, 664},  // AllReduceWithBias TREE LL128 Prod u8 1 0
  {135429, 665},  // AllReduceWithBias TREE LL128 Prod i32 1 0
  {200965, 665},  // AllReduceWithBias TREE LL128 Prod u32 1 0
  {266501, 666},  // AllReduceWithBias TREE LL128 Prod i64 1 0
  {332037, 666},  // AllReduceWithBias TREE LL128 Prod u64 1 0
  {397573, 667},  // AllReduceWithBias TREE LL128 Prod f16 1 0
  {463109, 668},  // AllReduceWithBias TREE LL128 Prod f32 1 0
  {528645, 669},  // AllReduceWithBias TREE LL128 Prod f64 1 0
  {594181, 670},  // AllReduceWithBias TREE LL128 Prod bf16 1 0
  {659717, 671},  // AllReduceWithBias TREE LL128 Prod f8e4m3 1 0
  {725253, 672},  // AllReduceWithBias TREE LL128 Prod f8e5m2 1 0
  {8453, 673},  // AllReduceWithBias TREE LL128 MinMax i8 1 0
  {73989, 673},  // AllReduceWithBias TREE LL128 MinMax u8 1 0
  {139525, 674},  // AllReduceWithBias TREE LL128 MinMax i32 1 0
  {205061, 674},  // AllReduceWithBias TREE LL128 MinMax u32 1 0
  {270597, 675},  // AllReduceWithBias TREE LL128 MinMax i64 1 0
  {336133, 675},  // AllReduceWithBias TREE LL128 MinMax u64 1 0
  {401669, 676},  // AllReduceWithBias TREE LL128 MinMax f16 1 0
  {467205, 677},  // AllReduceWithBias TREE LL128 MinMax f32 1 0
  {532741, 678},  // AllReduceWithBias TREE LL128 MinMax f64 1 0
  {598277, 679},  // AllReduceWithBias TREE LL128 MinMax bf16 1 0
  {663813, 680},  // AllReduceWithBias TREE LL128 MinMax f8e4m3 1 0
  {729349, 681},  // AllReduceWithBias TREE LL128 MinMax f8e5m2 1 0
  {12549, 682},  // AllReduceWithBias TREE LL128 PreMulSum i8 1 0
  {78085, 682},  // AllReduceWithBias TREE LL128 PreMulSum u8 1 0
  {143621, 683},  // AllReduceWithBias TREE LL128 PreMulSum i32 1 0
  {209157, 683},  // AllReduceWithBias TREE LL128 PreMulSum u32 1 0
  {274693, 684},  // AllReduceWithBias TREE LL128 PreMulSum i64 1 0
  {340229, 684},  // AllReduceWithBias TREE LL128 PreMulSum u64 1 0
  {405765, 685},  // AllReduceWithBias TREE LL128 PreMulSum f16 1 0
  {471301, 686},  // AllReduceWithBias TREE LL128 PreMulSum f32 1 0
  {536837, 687},  // AllReduceWithBias TREE LL128 PreMulSum f64 1 0
  {602373, 688},  // AllReduceWithBias TREE LL128 PreMulSum bf16 1 0
  {667909, 689},  // AllReduceWithBias TREE LL128 PreMulSum f8e4m3 1 0
  {733445, 690},  // AllReduceWithBias TREE LL128 PreMulSum f8e5m2 1 0
  {16645, 691},  // AllReduceWithBias TREE LL128 SumPostDiv i8 1 0
  {82181, 691},  // AllReduceWithBias TREE LL128 SumPostDiv u8 1 0
  {147717, 692},  // AllReduceWithBias TREE LL128 SumPostDiv i32 1 0
  {213253, 692},  // AllReduceWithBias TREE LL128 SumPostDiv u32 1 0
  {278789, 693},  // AllReduceWithBias TREE LL128 SumPostDiv i64 1 0
  {344325, 693},  // AllReduceWithBias TREE LL128 SumPostDiv u64 1 0
  {517, 694},  // AllReduceWithBias TREE SIMPLE Sum i8 1 0
  {66053, 694},  // AllReduceWithBias TREE SIMPLE Sum u8 1 0
  {131589, 695},  // AllReduceWithBias TREE SIMPLE Sum i32 1 0
  {197125, 695},  // AllReduceWithBias TREE SIMPLE Sum u32 1 0
  {262661, 696},  // AllReduceWithBias TREE SIMPLE Sum i64 1 0
  {328197, 696},  // AllReduceWithBias TREE SIMPLE Sum u64 1 0
  {393733, 697},  // AllReduceWithBias TREE SIMPLE Sum f16 1 0
  {459269, 698},  // AllReduceWithBias TREE SIMPLE Sum f32 1 0
  {524805, 699},  // AllReduceWithBias TREE SIMPLE Sum f64 1 0
  {590341, 700},  // AllReduceWithBias TREE SIMPLE Sum bf16 1 0
  {655877, 701},  // AllReduceWithBias TREE SIMPLE Sum f8e4m3 1 0
  {721413, 702},  // AllReduceWithBias TREE SIMPLE Sum f8e5m2 1 0
  {4613, 703},  // AllReduceWithBias TREE SIMPLE Prod i8 1 0
  {70149, 703},  // AllReduceWithBias TREE SIMPLE Prod u8 1 0
  {135685, 704},  // AllReduceWithBias TREE SIMPLE Prod i32 1 0
  {201221, 704},  // AllReduceWithBias TREE SIMPLE Prod u32 1 0
  {266757, 705},  // AllReduceWithBias TREE SIMPLE Prod i64 1 0
  {332293, 705},  // AllReduceWithBias TREE SIMPLE Prod u64 1 0
  {397829, 706},  // AllReduceWithBias TREE SIMPLE Prod f16 1 0
  {463365, 707},  // AllReduceWithBias TREE SIMPLE Prod f32 1 0
  {528901, 708},  // AllReduceWithBias TREE SIMPLE Prod f64 1 0
  {594437, 709},  // AllReduceWithBias TREE SIMPLE Prod bf16 1 0
  {659973, 710},  // AllReduceWithBias TREE SIMPLE Prod f8e4m3 1 0
  {725509, 711},  // AllReduceWithBias TREE SIMPLE Prod f8e5m2 1 0
  {8709, 712},  // AllReduceWithBias TREE SIMPLE MinMax i8 1 0
  {74245, 712},  // AllReduceWithBias TREE SIMPLE MinMax u8 1 0
  {139781, 713},  // AllReduceWithBias TREE SIMPLE MinMax i32 1 0
  {205317, 713},  // AllReduceWithBias TREE SIMPLE MinMax u32 1 0
  {270853, 714},  // AllReduceWithBias TREE SIMPLE MinMax i64 1 0
  {336389, 714},  // AllReduceWithBias TREE SIMPLE MinMax u64 1 0
  {401925, 715},  // AllReduceWithBias TREE SIMPLE MinMax f16 1 0
  {467461, 716},  // AllReduceWithBias TREE SIMPLE MinMax f32 1 0
  {532997, 717},  // AllReduceWithBias TREE SIMPLE MinMax f64 1 0
  {598533, 718},  // AllReduceWithBias TREE SIMPLE MinMax bf16 1 0
  {664069, 719},  // AllReduceWithBias TREE SIMPLE MinMax f8e4m3 1 0
  {729605, 720},  // AllReduceWithBias TREE SIMPLE MinMax f8e5m2 1 0
  {12805, 721},  // AllReduceWithBias TREE SIMPLE PreMulSum i8 1 0
  {78341, 721},  // AllReduceWithBias TREE SIMPLE PreMulSum u8 1 0
  {143877, 722},  // AllReduceWithBias TREE SIMPLE PreMulSum i32 1 0
  {209413, 722},  // AllReduceWithBias TREE SIMPLE PreMulSum u32 1 0
  {274949, 723},  // AllReduceWithBias TREE SIMPLE PreMulSum i64 1 0
  {340485, 723},  // AllReduceWithBias TREE SIMPLE PreMulSum u64 1 0
  {406021, 724},  // AllReduceWithBias TREE SIMPLE PreMulSum f16 1 0
  {471557, 725},  // AllReduceWithBias TREE SIMPLE PreMulSum f32 1 0
  {537093, 726},  // AllReduceWithBias TREE SIMPLE PreMulSum f64 1 0
  {602629, 727},  // AllReduceWithBias TREE SIMPLE PreMulSum bf16 1 0
  {668165, 728},  // AllReduceWithBias TREE SIMPLE PreMulSum f8e4m3 1 0
  {733701, 729},  // AllReduceWithBias TREE SIMPLE PreMulSum f8e5m2 1 0
  {16901, 730},  // AllReduceWithBias TREE SIMPLE SumPostDiv i8 1 0
  {82437, 730},  // AllReduceWithBias TREE SIMPLE SumPostDiv u8 1 0
  {147973, 731},  // AllReduceWithBias TREE SIMPLE SumPostDiv i32 1 0
  {213509, 731},  // AllReduceWithBias TREE SIMPLE SumPostDiv u32 1 0
  {279045, 732},  // AllReduceWithBias TREE SIMPLE SumPostDiv i64 1 0
  {344581, 732},  // AllReduceWithBias TREE SIMPLE SumPostDiv u64 1 0
  {21, 733},  // AllReduceWithBias RING LL Sum i8 1 0
  {65557, 733},  // AllReduceWithBias RING LL Sum u8 1 0
  {131093, 734},  // AllReduceWithBias RING LL Sum i32 1 0
  {196629, 734},  // AllReduceWithBias RING LL Sum u32 1 0
  {262165, 735},  // AllReduceWithBias RING LL Sum i64 1 0
  {327701, 735},  // AllReduceWithBias RING LL Sum u64 1 0
  {393237, 736},  // AllReduceWithBias RING LL Sum f16 1 0
  {458773, 737},  // AllReduceWithBias RING LL Sum f32 1 0
  {524309, 738},  // AllReduceWithBias RING LL Sum f64 1 0
  {589845, 739},  // AllReduceWithBias RING LL Sum bf16 1 0
  {655381, 740},  // AllReduceWithBias RING LL Sum f8e4m3 1 0
  {720917, 741},  // AllReduceWithBias RING LL Sum f8e5m2 1 0
  {4117, 742},  // AllReduceWithBias RING LL Prod i8 1 0
  {69653, 742},  // AllReduceWithBias RING LL Prod u8 1 0
  {135189, 743},  // AllReduceWithBias RING LL Prod i32 1 0
  {200725, 743},  // AllReduceWithBias RING LL Prod u32 1 0
  {266261, 744},  // AllReduceWithBias RING LL Prod i64 1 0
  {331797, 744},  // AllReduceWithBias RING LL Prod u64 1 0
  {397333, 745},  // AllReduceWithBias RING LL Prod f16 1 0
  {462869, 746},  // AllReduceWithBias RING LL Prod f32 1 0
  {528405, 747},  // AllReduceWithBias RING LL Prod f64 1 0
  {593941, 748},  // AllReduceWithBias RING LL Prod bf16 1 0
  {659477, 749},  // AllReduceWithBias RING LL Prod f8e4m3 1 0
  {725013, 750},  // AllReduceWithBias RING LL Prod f8e5m2 1 0
  {8213, 751},  // AllReduceWithBias RING LL MinMax i8 1 0
  {73749, 751},  // AllReduceWithBias RING LL MinMax u8 1 0
  {139285, 752},  // AllReduceWithBias RING LL MinMax i32 1 0
  {204821, 752},  // AllReduceWithBias RING LL MinMax u32 1 0
  {270357, 753},  // AllReduceWithBias RING LL MinMax i64 1 0
  {335893, 753},  // AllReduceWithBias RING LL MinMax u64 1 0
  {401429, 754},  // AllReduceWithBias RING LL MinMax f16 1 0
  {466965, 755},  // AllReduceWithBias RING LL MinMax f32 1 0
  {532501, 756},  // AllReduceWithBias RING LL MinMax f64 1 0
  {598037, 757},  // AllReduceWithBias RING LL MinMax bf16 1 0
  {663573, 758},  // AllReduceWithBias RING LL MinMax f8e4m3 1 0
  {729109, 759},  // AllReduceWithBias RING LL MinMax f8e5m2 1 0
  {12309, 760},  // AllReduceWithBias RING LL PreMulSum i8 1 0
  {77845, 760},  // AllReduceWithBias RING LL PreMulSum u8 1 0
  {143381, 761},  // AllReduceWithBias RING LL PreMulSum i32 1 0
  {208917, 761},  // AllReduceWithBias RING LL PreMulSum u32 1 0
  {274453, 762},  // AllReduceWithBias RING LL PreMulSum i64 1 0
  {339989, 762},  // AllReduceWithBias RING LL PreMulSum u64 1 0
  {405525, 763},  // AllReduceWithBias RING LL PreMulSum f16 1 0
  {471061, 764},  // AllReduceWithBias RING LL PreMulSum f32 1 0
  {536597, 765},  // AllReduceWithBias RING LL PreMulSum f64 1 0
  {602133, 766},  // AllReduceWithBias RING LL PreMulSum bf16 1 0
  {667669, 767},  // AllReduceWithBias RING LL PreMulSum f8e4m3 1 0
  {733205, 768},  // AllReduceWithBias RING LL PreMulSum f8e5m2 1 0
  {16405, 769},  // AllReduceWithBias RING LL SumPostDiv i8 1 0
  {81941, 769},  // AllReduceWithBias RING LL SumPostDiv u8 1 0
  {147477, 770},  // AllReduceWithBias RING LL SumPostDiv i32 1 0
  {213013, 770},  // AllReduceWithBias RING LL SumPostDiv u32 1 0
  {278549, 771},  // AllReduceWithBias RING LL SumPostDiv i64 1 0
  {344085, 771},  // AllReduceWithBias RING LL SumPostDiv u64 1 0
  {277, 772},  // AllReduceWithBias RING LL128 Sum i8 1 0
  {65813, 772},  // AllReduceWithBias RING LL128 Sum u8 1 0
  {131349, 773},  // AllReduceWithBias RING LL128 Sum i32 1 0
  {196885, 773},  // AllReduceWithBias RING LL128 Sum u32 1 0
  {262421, 774},  // AllReduceWithBias RING LL128 Sum i64 1 0
  {327957, 774},  // AllReduceWithBias RING LL128 Sum u64 1 0
  {393493, 775},  // AllReduceWithBias RING LL128 Sum f16 1 0
  {459029, 776},  // AllReduceWithBias RING LL128 Sum f32 1 0
  {524565, 777},  // AllReduceWithBias RING LL128 Sum f64 1 0
  {590101, 778},  // AllReduceWithBias RING LL128 Sum bf16 1 0
  {655637, 779},  // AllReduceWithBias RING LL128 Sum f8e4m3 1 0
  {721173, 780},  // AllReduceWithBias RING LL128 Sum f8e5m2 1 0
  {4373, 781},  // AllReduceWithBias RING LL128 Prod i8 1 0
  {69909, 781},  // AllReduceWithBias RING LL128 Prod u8 1 0
  {135445, 782},  // AllReduceWithBias RING LL128 Prod i32 1 0
  {200981, 782},  // AllReduceWithBias RING LL128 Prod u32 1 0
  {266517, 783},  // AllReduceWithBias RING LL128 Prod i64 1 0
  {332053, 783},  // AllReduceWithBias RING LL128 Prod u64 1 0
  {397589, 784},  // AllReduceWithBias RING LL128 Prod f16 1 0
  {463125, 785},  // AllReduceWithBias RING LL128 Prod f32 1 0
  {528661, 786},  // AllReduceWithBias RING LL128 Prod f64 1 0
  {594197, 787},  // AllReduceWithBias RING LL128 Prod bf16 1 0
  {659733, 788},  // AllReduceWithBias RING LL128 Prod f8e4m3 1 0
  {725269, 789},  // AllReduceWithBias RING LL128 Prod f8e5m2 1 0
  {8469, 790},  // AllReduceWithBias RING LL128 MinMax i8 1 0
  {74005, 790},  // AllReduceWithBias RING LL128 MinMax u8 1 0
  {139541, 791},  // AllReduceWithBias RING LL128 MinMax i32 1 0
  {205077, 791},  // AllReduceWithBias RING LL128 MinMax u32 1 0
  {270613, 792},  // AllReduceWithBias RING LL128 MinMax i64 1 0
  {336149, 792},  // AllReduceWithBias RING LL128 MinMax u64 1 0
  {401685, 793},  // AllReduceWithBias RING LL128 MinMax f16 1 0
  {467221, 794},  // AllReduceWithBias RING LL128 MinMax f32 1 0
  {532757, 795},  // AllReduceWithBias RING LL128 MinMax f64 1 0
  {598293, 796},  // AllReduceWithBias RING LL128 MinMax bf16 1 0
  {663829, 797},  // AllReduceWithBias RING LL128 MinMax f8e4m3 1 0
  {729365, 798},  // AllReduceWithBias RING LL128 MinMax f8e5m2 1 0
  {12565, 799},  // AllReduceWithBias RING LL128 PreMulSum i8 1 0
  {78101, 799},  // AllReduceWithBias RING LL128 PreMulSum u8 1 0
  {143637, 800},  // AllReduceWithBias RING LL128 PreMulSum i32 1 0
  {209173, 800},  // AllReduceWithBias RING LL128 PreMulSum u32 1 0
  {274709, 801},  // AllReduceWithBias RING LL128 PreMulSum i64 1 0
  {340245, 801},  // AllReduceWithBias RING LL128 PreMulSum u64 1 0
  {405781, 802},  // AllReduceWithBias RING LL128 PreMulSum f16 1 0
  {471317, 803},  // AllReduceWithBias RING LL128 PreMulSum f32 1 0
  {536853, 804},  // AllReduceWithBias RING LL128 PreMulSum f64 1 0
  {602389, 805},  // AllReduceWithBias RING LL128 PreMulSum bf16 1 0
  {667925, 806},  // AllReduceWithBias RING LL128 PreMulSum f8e4m3 1 0
  {733461, 807},  // AllReduceWithBias RING LL128 PreMulSum f8e5m2 1 0
  {16661, 808},  // AllReduceWithBias RING LL128 SumPostDiv i8 1 0
  {82197, 808},  // AllReduceWithBias RING LL128 SumPostDiv u8 1 0
  {147733, 809},  // AllReduceWithBias RING LL128 SumPostDiv i32 1 0
  {213269, 809},  // AllReduceWithBias RING LL128 SumPostDiv u32 1 0
  {278805, 810},  // AllReduceWithBias RING LL128 SumPostDiv i64 1 0
  {344341, 810},  // AllReduceWithBias RING LL128 SumPostDiv u64 1 0
  {533, 811},  // AllReduceWithBias RING SIMPLE Sum i8 1 0
  {66069, 811},  // AllReduceWithBias RING SIMPLE Sum u8 1 0
  {131605, 812},  // AllReduceWithBias RING SIMPLE Sum i32 1 0
  {197141, 812},  // AllReduceWithBias RING SIMPLE Sum u32 1 0
  {262677, 813},  // AllReduceWithBias RING SIMPLE Sum i64 1 0
  {328213, 813},  // AllReduceWithBias RING SIMPLE Sum u64 1 0
  {393749, 814},  // AllReduceWithBias RING SIMPLE Sum f16 1 0
  {459285, 815},  // AllReduceWithBias RING SIMPLE Sum f32 1 0
  {524821, 816},  // AllReduceWithBias RING SIMPLE Sum f64 1 0
  {590357, 817},  // AllReduceWithBias RING SIMPLE Sum bf16 1 0
  {655893, 818},  // AllReduceWithBias RING SIMPLE Sum f8e4m3 1 0
  {721429, 819},  // AllReduceWithBias RING SIMPLE Sum f8e5m2 1 0
  {4629, 820},  // AllReduceWithBias RING SIMPLE Prod i8 1 0
  {70165, 820},  // AllReduceWithBias RING SIMPLE Prod u8 1 0
  {135701, 821},  // AllReduceWithBias RING SIMPLE Prod i32 1 0
  {201237, 821},  // AllReduceWithBias RING SIMPLE Prod u32 1 0
  {266773, 822},  // AllReduceWithBias RING SIMPLE Prod i64 1 0
  {332309, 822},  // AllReduceWithBias RING SIMPLE Prod u64 1 0
  {397845, 823},  // AllReduceWithBias RING SIMPLE Prod f16 1 0
  {463381, 824},  // AllReduceWithBias RING SIMPLE Prod f32 1 0
  {528917, 825},  // AllReduceWithBias RING SIMPLE Prod f64 1 0
  {594453, 826},  // AllReduceWithBias RING SIMPLE Prod bf16 1 0
  {659989, 827},  // AllReduceWithBias RING SIMPLE Prod f8e4m3 1 0
  {725525, 828},  // AllReduceWithBias RING SIMPLE Prod f8e5m2 1 0
  {8725, 829},  // AllReduceWithBias RING SIMPLE MinMax i8 1 0
  {74261, 829},  // AllReduceWithBias RING SIMPLE MinMax u8 1 0
  {139797, 830},  // AllReduceWithBias RING SIMPLE MinMax i32 1 0
  {205333, 830},  // AllReduceWithBias RING SIMPLE MinMax u32 1 0
  {270869, 831},  // AllReduceWithBias RING SIMPLE MinMax i64 1 0
  {336405, 831},  // AllReduceWithBias RING SIMPLE MinMax u64 1 0
  {401941, 832},  // AllReduceWithBias RING SIMPLE MinMax f16 1 0
  {467477, 833},  // AllReduceWithBias RING SIMPLE MinMax f32 1 0
  {533013, 834},  // AllReduceWithBias RING SIMPLE MinMax f64 1 0
  {598549, 835},  // AllReduceWithBias RING SIMPLE MinMax bf16 1 0
  {664085, 836},  // AllReduceWithBias RING SIMPLE MinMax f8e4m3 1 0
  {729621, 837},  // AllReduceWithBias RING SIMPLE MinMax f8e5m2 1 0
  {12821, 838},  // AllReduceWithBias RING SIMPLE PreMulSum i8 1 0
  {78357, 838},  // AllReduceWithBias RING SIMPLE PreMulSum u8 1 0
  {143893, 839},  // AllReduceWithBias RING SIMPLE PreMulSum i32 1 0
  {209429, 839},  // AllReduceWithBias RING SIMPLE PreMulSum u32 1 0
  {274965, 840},  // AllReduceWithBias RING SIMPLE PreMulSum i64 1 0
  {340501, 840},  // AllReduceWithBias RING SIMPLE PreMulSum u64 1 0
  {406037, 841},  // AllReduceWithBias RING SIMPLE PreMulSum f16 1 0
  {471573, 842},  // AllReduceWithBias RING SIMPLE PreMulSum f32 1 0
  {537109, 843},  // AllReduceWithBias RING SIMPLE PreMulSum f64 1 0
  {602645, 844},  // AllReduceWithBias RING SIMPLE PreMulSum bf16 1 0
  {668181, 845},  // AllReduceWithBias RING SIMPLE PreMulSum f8e4m3 1 0
  {733717, 846},  // AllReduceWithBias RING SIMPLE PreMulSum f8e5m2 1 0
  {16917, 847},  // AllReduceWithBias RING SIMPLE SumPostDiv i8 1 0
  {82453, 847},  // AllReduceWithBias RING SIMPLE SumPostDiv u8 1 0
  {147989, 848},  // AllReduceWithBias RING SIMPLE SumPostDiv i32 1 0
  {213525, 848},  // AllReduceWithBias RING SIMPLE SumPostDiv u32 1 0
  {279061, 849},  // AllReduceWithBias RING SIMPLE SumPostDiv i64 1 0
  {344597, 849},  // AllReduceWithBias RING SIMPLE SumPostDiv u64 1 0
};
