//! DO NOT EDIT
//! GENERATED BY src/tools/config_gen.zig

const std = @import("std");

pub const Builtin = struct {
    signature: []const u8,
    return_type: []const u8,
    snippet: []const u8,
    documentation: []const u8,
    parameters: []const Parameter,

    pub const Parameter = struct {
        signature: []const u8,
        type: ?[]const u8,
    };
};

pub const builtins: std.StaticStringMap(Builtin) = .initComptime(&.{
    .{
        "@addrSpaceCast",
        Builtin{
            .signature = "@addrSpaceCast(ptr: anytype) anytype",
            .return_type = "anytype",
            .snippet = "@addrSpaceCast(${1:ptr: anytype})",
            .documentation =
            \\Converts a pointer from one address space to another. The new address space is inferred based on the result type. Depending on the current target and address spaces, this cast may be a no-op, a complex operation, or illegal. If the cast is legal, then the resulting pointer points to the same memory location as the pointer operand. It is always valid to cast a pointer between the same address spaces.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "ptr: anytype",
                    .type = "anytype",
                },
            },
        },
    },
    .{
        "@addWithOverflow",
        Builtin{
            .signature = "@addWithOverflow(a: anytype, b: anytype) struct { @TypeOf(a, b), u1 }",
            .return_type = "struct { @TypeOf(a, b), u1 }",
            .snippet = "@addWithOverflow(${1:a: anytype}, ${2:b: anytype})",
            .documentation =
            \\Performs `a + b` and returns a tuple with the result and a possible overflow bit.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "a: anytype",
                    .type = "anytype",
                },
                .{
                    .signature = "b: anytype",
                    .type = "anytype",
                },
            },
        },
    },
    .{
        "@alignCast",
        Builtin{
            .signature = "@alignCast(ptr: anytype) anytype",
            .return_type = "anytype",
            .snippet = "@alignCast(${1:ptr: anytype})",
            .documentation =
            \\`ptr` can be `*T`, `?*T`, or `[]T`. Changes the alignment of a pointer. The alignment to use is inferred based on the result type.
            \\
            \\A [pointer alignment safety check](https://ziglang.org/documentation/0.15.0/#Incorrect-Pointer-Alignment) is added to the generated code to make sure the pointer is aligned as promised.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "ptr: anytype",
                    .type = "anytype",
                },
            },
        },
    },
    .{
        "@alignOf",
        Builtin{
            .signature = "@alignOf(comptime T: type) comptime_int",
            .return_type = "comptime_int",
            .snippet = "@alignOf(${1:comptime T: type})",
            .documentation =
            \\This function returns the number of bytes that this type should be aligned to for the current target to match the C ABI. When the child type of a pointer has this alignment, the alignment can be omitted from the type.
            \\
            \\```zig
            \\const assert = @import("std").debug.assert;
            \\comptime {
            \\    assert(*u32 == *align(@alignOf(u32)) u32);
            \\}
            \\```
            \\The result is a target-specific compile time constant. It is guaranteed to be less than or equal to [@sizeOf(T)](https://ziglang.org/documentation/0.15.0/#sizeOf).
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "comptime T: type",
                    .type = "type",
                },
            },
        },
    },
    .{
        "@as",
        Builtin{
            .signature = "@as(comptime T: type, expression) T",
            .return_type = "T",
            .snippet = "@as(${1:comptime T: type}, ${2:expression})",
            .documentation =
            \\Performs [Type Coercion](https://ziglang.org/documentation/0.15.0/#Type-Coercion). This cast is allowed when the conversion is unambiguous and safe, and is the preferred way to convert between types, whenever possible.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "comptime T: type",
                    .type = "type",
                },
                .{
                    .signature = "expression",
                    .type = null,
                },
            },
        },
    },
    .{
        "@atomicLoad",
        Builtin{
            .signature = "@atomicLoad(comptime T: type, ptr: *const T, comptime ordering: AtomicOrder) T",
            .return_type = "T",
            .snippet = "@atomicLoad(${1:comptime T: type}, ${2:ptr: *const T}, ${3:comptime ordering: AtomicOrder})",
            .documentation =
            \\This builtin function atomically dereferences a pointer to a `T` and returns the value.
            \\
            \\`T` must be a pointer, a `bool`, a float, an integer, an enum, or a packed struct.
            \\
            \\`AtomicOrder` can be found with `@import("std").builtin.AtomicOrder`.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "comptime T: type",
                    .type = "type",
                },
                .{
                    .signature = "ptr: *const T",
                    .type = "*const T",
                },
                .{
                    .signature = "comptime ordering: AtomicOrder",
                    .type = "AtomicOrder",
                },
            },
        },
    },
    .{
        "@atomicRmw",
        Builtin{
            .signature = "@atomicRmw(comptime T: type, ptr: *T, comptime op: AtomicRmwOp, operand: T, comptime ordering: AtomicOrder) T",
            .return_type = "T",
            .snippet = "@atomicRmw(${1:comptime T: type}, ${2:ptr: *T}, ${3:comptime op: AtomicRmwOp}, ${4:operand: T}, ${5:comptime ordering: AtomicOrder})",
            .documentation =
            \\This builtin function dereferences a pointer to a `T` and atomically modifies the value and returns the previous value.
            \\
            \\`T` must be a pointer, a `bool`, a float, an integer, an enum, or a packed struct.
            \\
            \\`AtomicOrder` can be found with `@import("std").builtin.AtomicOrder`.
            \\
            \\`AtomicRmwOp` can be found with `@import("std").builtin.AtomicRmwOp`.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "comptime T: type",
                    .type = "type",
                },
                .{
                    .signature = "ptr: *T",
                    .type = "*T",
                },
                .{
                    .signature = "comptime op: AtomicRmwOp",
                    .type = "AtomicRmwOp",
                },
                .{
                    .signature = "operand: T",
                    .type = "T",
                },
                .{
                    .signature = "comptime ordering: AtomicOrder",
                    .type = "AtomicOrder",
                },
            },
        },
    },
    .{
        "@atomicStore",
        Builtin{
            .signature = "@atomicStore(comptime T: type, ptr: *T, value: T, comptime ordering: AtomicOrder) void",
            .return_type = "void",
            .snippet = "@atomicStore(${1:comptime T: type}, ${2:ptr: *T}, ${3:value: T}, ${4:comptime ordering: AtomicOrder})",
            .documentation =
            \\This builtin function dereferences a pointer to a `T` and atomically stores the given value.
            \\
            \\`T` must be a pointer, a `bool`, a float, an integer, an enum, or a packed struct.
            \\
            \\`AtomicOrder` can be found with `@import("std").builtin.AtomicOrder`.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "comptime T: type",
                    .type = "type",
                },
                .{
                    .signature = "ptr: *T",
                    .type = "*T",
                },
                .{
                    .signature = "value: T",
                    .type = "T",
                },
                .{
                    .signature = "comptime ordering: AtomicOrder",
                    .type = "AtomicOrder",
                },
            },
        },
    },
    .{
        "@bitCast",
        Builtin{
            .signature = "@bitCast(value: anytype) anytype",
            .return_type = "anytype",
            .snippet = "@bitCast(${1:value: anytype})",
            .documentation =
            \\Converts a value of one type to another type. The return type is the inferred result type.
            \\
            \\Asserts that `@sizeOf(@TypeOf(value)) == @sizeOf(DestType)`.
            \\
            \\Asserts that `@typeInfo(DestType) != .pointer`. Use `@ptrCast` or `@ptrFromInt` if you need this.
            \\
            \\Can be used for these things for example:
            \\
            \\ - Convert `f32` to `u32` bits
            \\ - Convert `i32` to `u32` preserving twos complement
            \\Works at compile-time if `value` is known at compile time. It's a compile error to bitcast a value of undefined layout; this means that, besides the restriction from types which possess dedicated casting builtins (enums, pointers, error sets), bare structs, error unions, slices, optionals, and any other type without a well-defined memory layout, also cannot be used in this operation.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "value: anytype",
                    .type = "anytype",
                },
            },
        },
    },
    .{
        "@bitOffsetOf",
        Builtin{
            .signature = "@bitOffsetOf(comptime T: type, comptime field_name: []const u8) comptime_int",
            .return_type = "comptime_int",
            .snippet = "@bitOffsetOf(${1:comptime T: type}, ${2:comptime field_name: []const u8})",
            .documentation =
            \\Returns the bit offset of a field relative to its containing struct.
            \\
            \\For non [packed structs](https://ziglang.org/documentation/0.15.0/#packed-struct), this will always be divisible by `8`. For packed structs, non-byte-aligned fields will share a byte offset, but they will have different bit offsets.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "comptime T: type",
                    .type = "type",
                },
                .{
                    .signature = "comptime field_name: []const u8",
                    .type = "[]const u8",
                },
            },
        },
    },
    .{
        "@bitSizeOf",
        Builtin{
            .signature = "@bitSizeOf(comptime T: type) comptime_int",
            .return_type = "comptime_int",
            .snippet = "@bitSizeOf(${1:comptime T: type})",
            .documentation =
            \\This function returns the number of bits it takes to store `T` in memory if the type were a field in a packed struct/union. The result is a target-specific compile time constant.
            \\
            \\This function measures the size at runtime. For types that are disallowed at runtime, such as `comptime_int` and `type`, the result is `0`.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "comptime T: type",
                    .type = "type",
                },
            },
        },
    },
    .{
        "@branchHint",
        Builtin{
            .signature = "@branchHint(hint: BranchHint) void",
            .return_type = "void",
            .snippet = "@branchHint(${1:hint: BranchHint})",
            .documentation =
            \\Hints to the optimizer how likely a given branch of control flow is to be reached.
            \\
            \\`BranchHint` can be found with `@import("std").builtin.BranchHint`.
            \\
            \\This function is only valid as the first statement in a control flow branch, or the first statement in a function.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "hint: BranchHint",
                    .type = "BranchHint",
                },
            },
        },
    },
    .{
        "@breakpoint",
        Builtin{
            .signature = "@breakpoint() void",
            .return_type = "void",
            .snippet = "@breakpoint()",
            .documentation =
            \\This function inserts a platform-specific debug trap instruction which causes debuggers to break there. Unlike for `@trap()`, execution may continue after this point if the program is resumed.
            \\
            \\This function is only valid within function scope.
            ,
            .parameters = &[_]Builtin.Parameter{},
        },
    },
    .{
        "@mulAdd",
        Builtin{
            .signature = "@mulAdd(comptime T: type, a: T, b: T, c: T) T",
            .return_type = "T",
            .snippet = "@mulAdd(${1:comptime T: type}, ${2:a: T}, ${3:b: T}, ${4:c: T})",
            .documentation =
            \\Fused multiply-add, similar to `(a * b) + c`, except only rounds once, and is thus more accurate.
            \\
            \\Supports [Floats](https://ziglang.org/documentation/0.15.0/#Floats) and [Vectors](https://ziglang.org/documentation/0.15.0/#Vectors) of floats.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "comptime T: type",
                    .type = "type",
                },
                .{
                    .signature = "a: T",
                    .type = "T",
                },
                .{
                    .signature = "b: T",
                    .type = "T",
                },
                .{
                    .signature = "c: T",
                    .type = "T",
                },
            },
        },
    },
    .{
        "@byteSwap",
        Builtin{
            .signature = "@byteSwap(operand: anytype) T",
            .return_type = "T",
            .snippet = "@byteSwap(${1:operand: anytype})",
            .documentation =
            \\`@TypeOf(operand)` must be an integer type or an integer vector type with bit count evenly divisible by 8.
            \\
            \\`operand` may be an [integer](https://ziglang.org/documentation/0.15.0/#Integers) or [vector](https://ziglang.org/documentation/0.15.0/#Vectors).
            \\
            \\Swaps the byte order of the integer. This converts a big endian integer to a little endian integer, and converts a little endian integer to a big endian integer.
            \\
            \\Note that for the purposes of memory layout with respect to endianness, the integer type should be related to the number of bytes reported by [@sizeOf](https://ziglang.org/documentation/0.15.0/#sizeOf) bytes. This is demonstrated with `u24`. `@sizeOf(u24) == 4`, which means that a `u24` stored in memory takes 4 bytes, and those 4 bytes are what are swapped on a little vs big endian system. On the other hand, if `T` is specified to be `u24`, then only 3 bytes are reversed.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "operand: anytype",
                    .type = "anytype",
                },
            },
        },
    },
    .{
        "@bitReverse",
        Builtin{
            .signature = "@bitReverse(integer: anytype) T",
            .return_type = "T",
            .snippet = "@bitReverse(${1:integer: anytype})",
            .documentation =
            \\`@TypeOf(anytype)` accepts any integer type or integer vector type.
            \\
            \\Reverses the bitpattern of an integer value, including the sign bit if applicable.
            \\
            \\For example 0b10110110 (`u8 = 182`, `i8 = -74`) becomes 0b01101101 (`u8 = 109`, `i8 = 109`).
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "integer: anytype",
                    .type = "anytype",
                },
            },
        },
    },
    .{
        "@offsetOf",
        Builtin{
            .signature = "@offsetOf(comptime T: type, comptime field_name: []const u8) comptime_int",
            .return_type = "comptime_int",
            .snippet = "@offsetOf(${1:comptime T: type}, ${2:comptime field_name: []const u8})",
            .documentation =
            \\Returns the byte offset of a field relative to its containing struct.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "comptime T: type",
                    .type = "type",
                },
                .{
                    .signature = "comptime field_name: []const u8",
                    .type = "[]const u8",
                },
            },
        },
    },
    .{
        "@call",
        Builtin{
            .signature = "@call(modifier: std.builtin.CallModifier, function: anytype, args: anytype) anytype",
            .return_type = "anytype",
            .snippet = "@call(${1:modifier: std.builtin.CallModifier}, ${2:function: anytype}, ${3:args: anytype})",
            .documentation =
            \\Calls a function, in the same way that invoking an expression with parentheses does:
            \\
            \\`@call` allows more flexibility than normal function call syntax does. The `CallModifier` enum is reproduced here:
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "modifier: std.builtin.CallModifier",
                    .type = "CallModifier",
                },
                .{
                    .signature = "function: anytype",
                    .type = "anytype",
                },
                .{
                    .signature = "args: anytype",
                    .type = "anytype",
                },
            },
        },
    },
    .{
        "@cDefine",
        Builtin{
            .signature = "@cDefine(comptime name: []const u8, value) void",
            .return_type = "void",
            .snippet = "@cDefine(${1:comptime name: []const u8}, ${2:value})",
            .documentation =
            \\This function can only occur inside `@cImport`.
            \\
            \\This appends
            \\`#define $name $value`to the `@cImport` temporary buffer.
            \\
            \\To define without a value, like this:
            \\
            \\`#define _GNU_SOURCE`Use the void value, like this:
            \\
            \\`@cDefine("_GNU_SOURCE", {})`
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "comptime name: []const u8",
                    .type = "[]const u8",
                },
                .{
                    .signature = "value",
                    .type = null,
                },
            },
        },
    },
    .{
        "@cImport",
        Builtin{
            .signature = "@cImport(expression) type",
            .return_type = "type",
            .snippet = "@cImport(${1:expression})",
            .documentation =
            \\This function parses C code and imports the functions, types, variables, and compatible macro definitions into a new empty struct type, and then returns that type.
            \\
            \\`expression` is interpreted at compile time. The builtin functions `@cInclude`, `@cDefine`, and `@cUndef` work within this expression, appending to a temporary buffer which is then parsed as C code.
            \\
            \\Usually you should only have one `@cImport` in your entire application, because it saves the compiler from invoking clang multiple times, and prevents inline functions from being duplicated.
            \\
            \\Reasons for having multiple `@cImport` expressions would be:
            \\
            \\ - To avoid a symbol collision, for example if foo.h and bar.h both
            \\`#define CONNECTION_COUNT` - To analyze the C code with different preprocessor defines
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "expression",
                    .type = null,
                },
            },
        },
    },
    .{
        "@cInclude",
        Builtin{
            .signature = "@cInclude(comptime path: []const u8) void",
            .return_type = "void",
            .snippet = "@cInclude(${1:comptime path: []const u8})",
            .documentation =
            \\This function can only occur inside `@cImport`.
            \\
            \\This appends
            \\`#include &lt;$path&gt;\n`to the `c_import` temporary buffer.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "comptime path: []const u8",
                    .type = "[]const u8",
                },
            },
        },
    },
    .{
        "@clz",
        Builtin{
            .signature = "@clz(operand: anytype) anytype",
            .return_type = "anytype",
            .snippet = "@clz(${1:operand: anytype})",
            .documentation =
            \\`@TypeOf(operand)` must be an integer type or an integer vector type.
            \\
            \\`operand` may be an [integer](https://ziglang.org/documentation/0.15.0/#Integers) or [vector](https://ziglang.org/documentation/0.15.0/#Vectors).
            \\
            \\Counts the number of most-significant (leading in a big-endian sense) zeroes in an integer - "count leading zeroes".
            \\
            \\The return type is an unsigned integer or vector of unsigned integers with the minimum number of bits that can represent the bit count of the integer type.
            \\
            \\If `operand` is zero, `@clz` returns the bit width of integer type `T`.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "operand: anytype",
                    .type = "anytype",
                },
            },
        },
    },
    .{
        "@cmpxchgStrong",
        Builtin{
            .signature = "@cmpxchgStrong(comptime T: type, ptr: *T, expected_value: T, new_value: T, success_order: AtomicOrder, fail_order: AtomicOrder) ?T",
            .return_type = "?T",
            .snippet = "@cmpxchgStrong(${1:comptime T: type}, ${2:ptr: *T}, ${3:expected_value: T}, ${4:new_value: T}, ${5:success_order: AtomicOrder}, ${6:fail_order: AtomicOrder})",
            .documentation =
            \\This function performs a strong atomic compare-and-exchange operation, returning `null` if the current value is the given expected value. It's the equivalent of this code, except atomic:
            \\
            \\If you are using cmpxchg in a retry loop, [@cmpxchgWeak](https://ziglang.org/documentation/0.15.0/#cmpxchgWeak) is the better choice, because it can be implemented more efficiently in machine instructions.
            \\
            \\`T` must be a pointer, a `bool`, an integer, an enum, or a packed struct.
            \\
            \\`@typeInfo(@TypeOf(ptr)).pointer.alignment` must be `>= @sizeOf(T).`
            \\
            \\`AtomicOrder` can be found with `@import("std").builtin.AtomicOrder`.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "comptime T: type",
                    .type = "type",
                },
                .{
                    .signature = "ptr: *T",
                    .type = "*T",
                },
                .{
                    .signature = "expected_value: T",
                    .type = "T",
                },
                .{
                    .signature = "new_value: T",
                    .type = "T",
                },
                .{
                    .signature = "success_order: AtomicOrder",
                    .type = "AtomicOrder",
                },
                .{
                    .signature = "fail_order: AtomicOrder",
                    .type = "AtomicOrder",
                },
            },
        },
    },
    .{
        "@cmpxchgWeak",
        Builtin{
            .signature = "@cmpxchgWeak(comptime T: type, ptr: *T, expected_value: T, new_value: T, success_order: AtomicOrder, fail_order: AtomicOrder) ?T",
            .return_type = "?T",
            .snippet = "@cmpxchgWeak(${1:comptime T: type}, ${2:ptr: *T}, ${3:expected_value: T}, ${4:new_value: T}, ${5:success_order: AtomicOrder}, ${6:fail_order: AtomicOrder})",
            .documentation =
            \\This function performs a weak atomic compare-and-exchange operation, returning `null` if the current value is the given expected value. It's the equivalent of this code, except atomic:
            \\
            \\```zig
            \\fn cmpxchgWeakButNotAtomic(comptime T: type, ptr: *T, expected_value: T, new_value: T) ?T {
            \\    const old_value = ptr.*;
            \\    if (old_value == expected_value and usuallyTrueButSometimesFalse()) {
            \\        ptr.* = new_value;
            \\        return null;
            \\    } else {
            \\        return old_value;
            \\    }
            \\}
            \\```
            \\If you are using cmpxchg in a retry loop, the sporadic failure will be no problem, and `cmpxchgWeak` is the better choice, because it can be implemented more efficiently in machine instructions. However if you need a stronger guarantee, use [@cmpxchgStrong](https://ziglang.org/documentation/0.15.0/#cmpxchgStrong).
            \\
            \\`T` must be a pointer, a `bool`, an integer, an enum, or a packed struct.
            \\
            \\`@typeInfo(@TypeOf(ptr)).pointer.alignment` must be `>= @sizeOf(T).`
            \\
            \\`AtomicOrder` can be found with `@import("std").builtin.AtomicOrder`.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "comptime T: type",
                    .type = "type",
                },
                .{
                    .signature = "ptr: *T",
                    .type = "*T",
                },
                .{
                    .signature = "expected_value: T",
                    .type = "T",
                },
                .{
                    .signature = "new_value: T",
                    .type = "T",
                },
                .{
                    .signature = "success_order: AtomicOrder",
                    .type = "AtomicOrder",
                },
                .{
                    .signature = "fail_order: AtomicOrder",
                    .type = "AtomicOrder",
                },
            },
        },
    },
    .{
        "@compileError",
        Builtin{
            .signature = "@compileError(comptime msg: []const u8) noreturn",
            .return_type = "noreturn",
            .snippet = "@compileError(${1:comptime msg: []const u8})",
            .documentation =
            \\This function, when semantically analyzed, causes a compile error with the message `msg`.
            \\
            \\There are several ways that code avoids being semantically checked, such as using `if` or `switch` with compile time constants, and `comptime` functions.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "comptime msg: []const u8",
                    .type = "[]const u8",
                },
            },
        },
    },
    .{
        "@compileLog",
        Builtin{
            .signature = "@compileLog(...) void",
            .return_type = "void",
            .snippet = "@compileLog(${1:...})",
            .documentation =
            \\This function prints the arguments passed to it at compile-time.
            \\
            \\To prevent accidentally leaving compile log statements in a codebase, a compilation error is added to the build, pointing to the compile log statement. This error prevents code from being generated, but does not otherwise interfere with analysis.
            \\
            \\This function can be used to do "printf debugging" on compile-time executing code.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "...",
                    .type = null,
                },
            },
        },
    },
    .{
        "@constCast",
        Builtin{
            .signature = "@constCast(value: anytype) DestType",
            .return_type = "DestType",
            .snippet = "@constCast(${1:value: anytype})",
            .documentation =
            \\Remove `const` qualifier from a pointer.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "value: anytype",
                    .type = "anytype",
                },
            },
        },
    },
    .{
        "@ctz",
        Builtin{
            .signature = "@ctz(operand: anytype) anytype",
            .return_type = "anytype",
            .snippet = "@ctz(${1:operand: anytype})",
            .documentation =
            \\`@TypeOf(operand)` must be an integer type or an integer vector type.
            \\
            \\`operand` may be an [integer](https://ziglang.org/documentation/0.15.0/#Integers) or [vector](https://ziglang.org/documentation/0.15.0/#Vectors).
            \\
            \\Counts the number of least-significant (trailing in a big-endian sense) zeroes in an integer - "count trailing zeroes".
            \\
            \\The return type is an unsigned integer or vector of unsigned integers with the minimum number of bits that can represent the bit count of the integer type.
            \\
            \\If `operand` is zero, `@ctz` returns the bit width of integer type `T`.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "operand: anytype",
                    .type = "anytype",
                },
            },
        },
    },
    .{
        "@cUndef",
        Builtin{
            .signature = "@cUndef(comptime name: []const u8) void",
            .return_type = "void",
            .snippet = "@cUndef(${1:comptime name: []const u8})",
            .documentation =
            \\This function can only occur inside `@cImport`.
            \\
            \\This appends
            \\`#undef $name`to the `@cImport` temporary buffer.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "comptime name: []const u8",
                    .type = "[]const u8",
                },
            },
        },
    },
    .{
        "@cVaArg",
        Builtin{
            .signature = "@cVaArg(operand: *std.builtin.VaList, comptime T: type) T",
            .return_type = "T",
            .snippet = "@cVaArg(${1:operand: *std.builtin.VaList}, ${2:comptime T: type})",
            .documentation =
            \\Implements the C macro `va_arg`.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "operand: *std.builtin.VaList",
                    .type = "*std.builtin.VaList",
                },
                .{
                    .signature = "comptime T: type",
                    .type = "type",
                },
            },
        },
    },
    .{
        "@cVaCopy",
        Builtin{
            .signature = "@cVaCopy(src: *std.builtin.VaList) std.builtin.VaList",
            .return_type = "VaList",
            .snippet = "@cVaCopy(${1:src: *std.builtin.VaList})",
            .documentation =
            \\Implements the C macro `va_copy`.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "src: *std.builtin.VaList",
                    .type = "*std.builtin.VaList",
                },
            },
        },
    },
    .{
        "@cVaEnd",
        Builtin{
            .signature = "@cVaEnd(src: *std.builtin.VaList) void",
            .return_type = "void",
            .snippet = "@cVaEnd(${1:src: *std.builtin.VaList})",
            .documentation =
            \\Implements the C macro `va_end`.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "src: *std.builtin.VaList",
                    .type = "*std.builtin.VaList",
                },
            },
        },
    },
    .{
        "@cVaStart",
        Builtin{
            .signature = "@cVaStart() std.builtin.VaList",
            .return_type = "VaList",
            .snippet = "@cVaStart()",
            .documentation =
            \\Implements the C macro `va_start`. Only valid inside a variadic function.
            ,
            .parameters = &[_]Builtin.Parameter{},
        },
    },
    .{
        "@divExact",
        Builtin{
            .signature = "@divExact(numerator: T, denominator: T) T",
            .return_type = "T",
            .snippet = "@divExact(${1:numerator: T}, ${2:denominator: T})",
            .documentation =
            \\Exact division. Caller guarantees `denominator != 0` and `@divTrunc(numerator, denominator) * denominator == numerator`.
            \\
            \\ - `@divExact(6, 3) == 2`
            \\ - `@divExact(a, b) * b == a`
            \\For a function that returns a possible error code, use `@import("std").math.divExact`.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "numerator: T",
                    .type = "T",
                },
                .{
                    .signature = "denominator: T",
                    .type = "T",
                },
            },
        },
    },
    .{
        "@divFloor",
        Builtin{
            .signature = "@divFloor(numerator: T, denominator: T) T",
            .return_type = "T",
            .snippet = "@divFloor(${1:numerator: T}, ${2:denominator: T})",
            .documentation =
            \\Floored division. Rounds toward negative infinity. For unsigned integers it is the same as `numerator / denominator`. Caller guarantees `denominator != 0` and `!(@typeInfo(T) == .int and T.is_signed and numerator == std.math.minInt(T) and denominator == -1)`.
            \\
            \\ - `@divFloor(-5, 3) == -2`
            \\ - `(@divFloor(a, b) * b) + @mod(a, b) == a`
            \\For a function that returns a possible error code, use `@import("std").math.divFloor`.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "numerator: T",
                    .type = "T",
                },
                .{
                    .signature = "denominator: T",
                    .type = "T",
                },
            },
        },
    },
    .{
        "@divTrunc",
        Builtin{
            .signature = "@divTrunc(numerator: T, denominator: T) T",
            .return_type = "T",
            .snippet = "@divTrunc(${1:numerator: T}, ${2:denominator: T})",
            .documentation =
            \\Truncated division. Rounds toward zero. For unsigned integers it is the same as `numerator / denominator`. Caller guarantees `denominator != 0` and `!(@typeInfo(T) == .int and T.is_signed and numerator == std.math.minInt(T) and denominator == -1)`.
            \\
            \\ - `@divTrunc(-5, 3) == -1`
            \\ - `(@divTrunc(a, b) * b) + @rem(a, b) == a`
            \\For a function that returns a possible error code, use `@import("std").math.divTrunc`.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "numerator: T",
                    .type = "T",
                },
                .{
                    .signature = "denominator: T",
                    .type = "T",
                },
            },
        },
    },
    .{
        "@embedFile",
        Builtin{
            .signature = "@embedFile(comptime path: []const u8) *const [N:0]u8",
            .return_type = "*const [N:0]u8",
            .snippet = "@embedFile(${1:comptime path: []const u8})",
            .documentation =
            \\This function returns a compile time constant pointer to null-terminated, fixed-size array with length equal to the byte count of the file given by `path`. The contents of the array are the contents of the file. This is equivalent to a [string literal](https://ziglang.org/documentation/0.15.0/#String-Literals-and-Unicode-Code-Point-Literals) with the file contents.
            \\
            \\`path` is absolute or relative to the current file, just like `@import`.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "comptime path: []const u8",
                    .type = "[]const u8",
                },
            },
        },
    },
    .{
        "@enumFromInt",
        Builtin{
            .signature = "@enumFromInt(integer: anytype) anytype",
            .return_type = "anytype",
            .snippet = "@enumFromInt(${1:integer: anytype})",
            .documentation =
            \\Converts an integer into an [enum](https://ziglang.org/documentation/0.15.0/#enum) value. The return type is the inferred result type.
            \\
            \\Attempting to convert an integer with no corresponding value in the enum invokes safety-checked [Illegal Behavior](https://ziglang.org/documentation/0.15.0/#Illegal-Behavior). Note that a [non-exhaustive enum](https://ziglang.org/documentation/0.15.0/#Non-exhaustive-enum) has corresponding values for all integers in the enum's integer tag type: the `_` value represents all the remaining unnamed integers in the enum's tag type.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "integer: anytype",
                    .type = "anytype",
                },
            },
        },
    },
    .{
        "@errorFromInt",
        Builtin{
            .signature = "@errorFromInt(value: std.meta.Int(.unsigned, @bitSizeOf(anyerror))) anyerror",
            .return_type = "anyerror",
            .snippet = "@errorFromInt(${1:value: std.meta.Int(.unsigned, @bitSizeOf(anyerror))})",
            .documentation =
            \\Converts from the integer representation of an error into [The Global Error Set](https://ziglang.org/documentation/0.15.0/#The-Global-Error-Set) type.
            \\
            \\It is generally recommended to avoid this cast, as the integer representation of an error is not stable across source code changes.
            \\
            \\Attempting to convert an integer that does not correspond to any error results in safety-checked [Illegal Behavior](https://ziglang.org/documentation/0.15.0/#Illegal-Behavior).
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "value: std.meta.Int(.unsigned, @bitSizeOf(anyerror))",
                    .type = "std.meta.Int(.unsigned, @bitSizeOf(anyerror))",
                },
            },
        },
    },
    .{
        "@errorName",
        Builtin{
            .signature = "@errorName(err: anyerror) [:0]const u8",
            .return_type = "[:0]const u8",
            .snippet = "@errorName(${1:err: anyerror})",
            .documentation =
            \\This function returns the string representation of an error. The string representation of `error.OutOfMem` is `"OutOfMem"`.
            \\
            \\If there are no calls to `@errorName` in an entire application, or all calls have a compile-time known value for `err`, then no error name table will be generated.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "err: anyerror",
                    .type = "anyerror",
                },
            },
        },
    },
    .{
        "@errorReturnTrace",
        Builtin{
            .signature = "@errorReturnTrace() ?*builtin.StackTrace",
            .return_type = "?*builtin.StackTrace",
            .snippet = "@errorReturnTrace()",
            .documentation =
            \\If the binary is built with error return tracing, and this function is invoked in a function that calls a function with an error or error union return type, returns a stack trace object. Otherwise returns [null](https://ziglang.org/documentation/0.15.0/#null).
            ,
            .parameters = &[_]Builtin.Parameter{},
        },
    },
    .{
        "@errorCast",
        Builtin{
            .signature = "@errorCast(value: anytype) anytype",
            .return_type = "anytype",
            .snippet = "@errorCast(${1:value: anytype})",
            .documentation =
            \\Converts an error set or error union value from one error set to another error set. The return type is the inferred result type. Attempting to convert an error which is not in the destination error set results in safety-checked [Illegal Behavior](https://ziglang.org/documentation/0.15.0/#Illegal-Behavior).
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "value: anytype",
                    .type = "anytype",
                },
            },
        },
    },
    .{
        "@export",
        Builtin{
            .signature = "@export(comptime ptr: *const anyopaque, comptime options: std.builtin.ExportOptions) void",
            .return_type = "void",
            .snippet = "@export(${1:comptime ptr: *const anyopaque}, ${2:comptime options: std.builtin.ExportOptions})",
            .documentation =
            \\Creates a symbol in the output object file which refers to the target of
            \\`ptr`.
            \\
            \\`ptr`must point to a global variable or a comptime-known constant.
            \\
            \\This builtin can be called from a [comptime](https://ziglang.org/documentation/0.15.0/#comptime) block to conditionally export symbols. When
            \\`ptr`points to a function with the C calling convention and `options.linkage` is `.strong`, this is equivalent to the `export` keyword used on a function:
            \\
            \\This is equivalent to:
            \\
            \\Note that even when using `export`, the `@"foo"` syntax for [identifiers](https://ziglang.org/documentation/0.15.0/#Identifiers) can be used to choose any string for the symbol name:
            \\
            \\When looking at the resulting object, you can see the symbol is used verbatim:
            \\
            \\`00000000000001f0 T A function name that is a complete sentence.`
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "comptime ptr: *const anyopaque",
                    .type = "*const anyopaque",
                },
                .{
                    .signature = "comptime options: std.builtin.ExportOptions",
                    .type = "ExportOptions",
                },
            },
        },
    },
    .{
        "@extern",
        Builtin{
            .signature = "@extern(T: type, comptime options: std.builtin.ExternOptions) T",
            .return_type = "T",
            .snippet = "@extern(${1:T: type}, ${2:comptime options: std.builtin.ExternOptions})",
            .documentation =
            \\Creates a reference to an external symbol in the output object file. T must be a pointer type.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "T: type",
                    .type = "type",
                },
                .{
                    .signature = "comptime options: std.builtin.ExternOptions",
                    .type = "ExternOptions",
                },
            },
        },
    },
    .{
        "@field",
        Builtin{
            .signature = "@field(lhs: anytype, comptime field_name: []const u8) (field)",
            .return_type = "(field)",
            .snippet = "@field(${1:lhs: anytype}, ${2:comptime field_name: []const u8})",
            .documentation =
            \\Performs field access by a compile-time string. Works on both fields and declarations.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "lhs: anytype",
                    .type = "anytype",
                },
                .{
                    .signature = "comptime field_name: []const u8",
                    .type = "[]const u8",
                },
            },
        },
    },
    .{
        "@fieldParentPtr",
        Builtin{
            .signature = "@fieldParentPtr(comptime field_name: []const u8, field_ptr: *T) anytype",
            .return_type = "anytype",
            .snippet = "@fieldParentPtr(${1:comptime field_name: []const u8}, ${2:field_ptr: *T})",
            .documentation =
            \\Given a pointer to a struct field, returns a pointer to the struct containing that field. The return type (and struct in question) is the inferred result type.
            \\
            \\If `field_ptr` does not point to the `field_name` field of an instance of the result type, and the result type has ill-defined layout, invokes unchecked [Illegal Behavior](https://ziglang.org/documentation/0.15.0/#Illegal-Behavior).
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "comptime field_name: []const u8",
                    .type = "[]const u8",
                },
                .{
                    .signature = "field_ptr: *T",
                    .type = "*T",
                },
            },
        },
    },
    .{
        "@FieldType",
        Builtin{
            .signature = "@FieldType(comptime Type: type, comptime field_name: []const u8) type",
            .return_type = "type",
            .snippet = "@FieldType(${1:comptime Type: type}, ${2:comptime field_name: []const u8})",
            .documentation =
            \\Given a type and the name of one of its fields, returns the type of that field.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "comptime Type: type",
                    .type = "type",
                },
                .{
                    .signature = "comptime field_name: []const u8",
                    .type = "[]const u8",
                },
            },
        },
    },
    .{
        "@floatCast",
        Builtin{
            .signature = "@floatCast(value: anytype) anytype",
            .return_type = "anytype",
            .snippet = "@floatCast(${1:value: anytype})",
            .documentation =
            \\Convert from one float type to another. This cast is safe, but may cause the numeric value to lose precision. The return type is the inferred result type.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "value: anytype",
                    .type = "anytype",
                },
            },
        },
    },
    .{
        "@floatFromInt",
        Builtin{
            .signature = "@floatFromInt(int: anytype) anytype",
            .return_type = "anytype",
            .snippet = "@floatFromInt(${1:int: anytype})",
            .documentation =
            \\Converts an integer to the closest floating point representation. The return type is the inferred result type. To convert the other way, use [@intFromFloat](https://ziglang.org/documentation/0.15.0/#intFromFloat). This operation is legal for all values of all integer types.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "int: anytype",
                    .type = "anytype",
                },
            },
        },
    },
    .{
        "@frameAddress",
        Builtin{
            .signature = "@frameAddress() usize",
            .return_type = "usize",
            .snippet = "@frameAddress()",
            .documentation =
            \\This function returns the base pointer of the current stack frame.
            \\
            \\The implications of this are target-specific and not consistent across all platforms. The frame address may not be available in release mode due to aggressive optimizations.
            \\
            \\This function is only valid within function scope.
            ,
            .parameters = &[_]Builtin.Parameter{},
        },
    },
    .{
        "@hasDecl",
        Builtin{
            .signature = "@hasDecl(comptime Container: type, comptime name: []const u8) bool",
            .return_type = "bool",
            .snippet = "@hasDecl(${1:comptime Container: type}, ${2:comptime name: []const u8})",
            .documentation =
            \\Returns whether or not a [container](https://ziglang.org/documentation/0.15.0/#Containers) has a declaration matching `name`.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "comptime Container: type",
                    .type = "type",
                },
                .{
                    .signature = "comptime name: []const u8",
                    .type = "[]const u8",
                },
            },
        },
    },
    .{
        "@hasField",
        Builtin{
            .signature = "@hasField(comptime Container: type, comptime name: []const u8) bool",
            .return_type = "bool",
            .snippet = "@hasField(${1:comptime Container: type}, ${2:comptime name: []const u8})",
            .documentation =
            \\Returns whether the field name of a struct, union, or enum exists.
            \\
            \\The result is a compile time constant.
            \\
            \\It does not include functions, variables, or constants.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "comptime Container: type",
                    .type = "type",
                },
                .{
                    .signature = "comptime name: []const u8",
                    .type = "[]const u8",
                },
            },
        },
    },
    .{
        "@import",
        Builtin{
            .signature = "@import(comptime target: []const u8) anytype",
            .return_type = "anytype",
            .snippet = "@import(${1:comptime target: []const u8})",
            .documentation =
            \\Imports the file at `target`, adding it to the compilation if it is not already added. `target` is either a relative path to another file from the file containing the `@import` call, or it is the name of a [module](https://ziglang.org/documentation/0.15.0/#Compilation-Model), with the import referring to the root source file of that module. Either way, the file path must end in either
            \\`.zig`(for a Zig source file) or
            \\`.zon`(for a ZON data file).
            \\
            \\If `target` refers to a Zig source file, then `@import` returns that file's [corresponding struct type](https://ziglang.org/documentation/0.15.0/#Source-File-Structs), essentially as if the builtin call was replaced by `struct { FILE_CONTENTS }`. The return type is `type`.
            \\
            \\If `target` refers to a ZON file, then `@import` returns the value of the literal in the file. If there is an inferred [result type](https://ziglang.org/documentation/0.15.0/#Result-Types), then the return type is that type, and the ZON literal is interpreted as that type ([Result Types](https://ziglang.org/documentation/0.15.0/#Result-Types) are propagated through the ZON expression). Otherwise, the return type is the type of the equivalent Zig expression, essentially as if the builtin call was replaced by the ZON file contents.
            \\
            \\The following modules are always available for import:
            \\
            \\ - `@import("std")` - Zig Standard Library
            \\ - `@import("builtin")` - Target-specific information. The command
            \\`zig build-exe --show-builtin`outputs the source to stdout for reference.
            \\ - `@import("root")` - Alias for the root module. In typical project structures, this means it refers back to
            \\`src/main.zig`.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "comptime target: []const u8",
                    .type = "[]const u8",
                },
            },
        },
    },
    .{
        "@inComptime",
        Builtin{
            .signature = "@inComptime() bool",
            .return_type = "bool",
            .snippet = "@inComptime()",
            .documentation =
            \\Returns whether the builtin was run in a `comptime` context. The result is a compile-time constant.
            \\
            \\This can be used to provide alternative, comptime-friendly implementations of functions. It should not be used, for instance, to exclude certain functions from being evaluated at comptime.
            ,
            .parameters = &[_]Builtin.Parameter{},
        },
    },
    .{
        "@intCast",
        Builtin{
            .signature = "@intCast(int: anytype) anytype",
            .return_type = "anytype",
            .snippet = "@intCast(${1:int: anytype})",
            .documentation =
            \\Converts an integer to another integer while keeping the same numerical value. The return type is the inferred result type. Attempting to convert a number which is out of range of the destination type results in safety-checked [Illegal Behavior](https://ziglang.org/documentation/0.15.0/#Illegal-Behavior).
            \\
            \\To truncate the significant bits of a number out of range of the destination type, use [@truncate](https://ziglang.org/documentation/0.15.0/#truncate).
            \\
            \\If `T` is `comptime_int`, then this is semantically equivalent to [Type Coercion](https://ziglang.org/documentation/0.15.0/#Type-Coercion).
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "int: anytype",
                    .type = "anytype",
                },
            },
        },
    },
    .{
        "@intFromBool",
        Builtin{
            .signature = "@intFromBool(value: bool) u1",
            .return_type = "u1",
            .snippet = "@intFromBool(${1:value: bool})",
            .documentation =
            \\Converts `true` to `@as(u1, 1)` and `false` to `@as(u1, 0)`.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "value: bool",
                    .type = "bool",
                },
            },
        },
    },
    .{
        "@intFromEnum",
        Builtin{
            .signature = "@intFromEnum(enum_or_tagged_union: anytype) anytype",
            .return_type = "anytype",
            .snippet = "@intFromEnum(${1:enum_or_tagged_union: anytype})",
            .documentation =
            \\Converts an enumeration value into its integer tag type. When a tagged union is passed, the tag value is used as the enumeration value.
            \\
            \\If there is only one possible enum value, the result is a `comptime_int` known at [comptime](https://ziglang.org/documentation/0.15.0/#comptime).
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "enum_or_tagged_union: anytype",
                    .type = "anytype",
                },
            },
        },
    },
    .{
        "@intFromError",
        Builtin{
            .signature = "@intFromError(err: anytype) std.meta.Int(.unsigned, @bitSizeOf(anyerror))",
            .return_type = "std.meta.Int(.unsigned, @bitSizeOf(anyerror))",
            .snippet = "@intFromError(${1:err: anytype})",
            .documentation =
            \\Supports the following types:
            \\
            \\ - [The Global Error Set](https://ziglang.org/documentation/0.15.0/#The-Global-Error-Set)
            \\ - [Error Set Type](https://ziglang.org/documentation/0.15.0/#Error-Set-Type)
            \\ - [Error Union Type](https://ziglang.org/documentation/0.15.0/#Error-Union-Type)
            \\Converts an error to the integer representation of an error.
            \\
            \\It is generally recommended to avoid this cast, as the integer representation of an error is not stable across source code changes.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "err: anytype",
                    .type = "anytype",
                },
            },
        },
    },
    .{
        "@intFromFloat",
        Builtin{
            .signature = "@intFromFloat(float: anytype) anytype",
            .return_type = "anytype",
            .snippet = "@intFromFloat(${1:float: anytype})",
            .documentation =
            \\Converts the integer part of a floating point number to the inferred result type.
            \\
            \\If the integer part of the floating point number cannot fit in the destination type, it invokes safety-checked [Illegal Behavior](https://ziglang.org/documentation/0.15.0/#Illegal-Behavior).
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "float: anytype",
                    .type = "anytype",
                },
            },
        },
    },
    .{
        "@intFromPtr",
        Builtin{
            .signature = "@intFromPtr(value: anytype) usize",
            .return_type = "usize",
            .snippet = "@intFromPtr(${1:value: anytype})",
            .documentation =
            \\Converts `value` to a `usize` which is the address of the pointer. `value` can be `*T` or `?*T`.
            \\
            \\To convert the other way, use [@ptrFromInt](https://ziglang.org/documentation/0.15.0/#ptrFromInt)
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "value: anytype",
                    .type = "anytype",
                },
            },
        },
    },
    .{
        "@max",
        Builtin{
            .signature = "@max(...) T",
            .return_type = "T",
            .snippet = "@max(${1:...})",
            .documentation =
            \\Takes two or more arguments and returns the biggest value included (the maximum). This builtin accepts integers, floats, and vectors of either. In the latter case, the operation is performed element wise.
            \\
            \\NaNs are handled as follows: return the biggest non-NaN value included. If all operands are NaN, return NaN.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "...",
                    .type = null,
                },
            },
        },
    },
    .{
        "@memcpy",
        Builtin{
            .signature = "@memcpy(noalias dest, noalias source) void",
            .return_type = "void",
            .snippet = "@memcpy(${1:noalias dest}, ${2:noalias source})",
            .documentation =
            \\This function copies bytes from one region of memory to another.
            \\
            \\`dest` must be a mutable slice, a mutable pointer to an array, or a mutable many-item [pointer](https://ziglang.org/documentation/0.15.0/#Pointers). It may have any alignment, and it may have any element type.
            \\
            \\`source` must be a slice, a pointer to an array, or a many-item [pointer](https://ziglang.org/documentation/0.15.0/#Pointers). It may have any alignment, and it may have any element type.
            \\
            \\The `source` element type must have the same in-memory representation as the `dest` element type.
            \\
            \\Similar to [for](https://ziglang.org/documentation/0.15.0/#for) loops, at least one of `source` and `dest` must provide a length, and if two lengths are provided, they must be equal.
            \\
            \\Finally, the two memory regions must not overlap.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "noalias dest",
                    .type = null,
                },
                .{
                    .signature = "noalias source",
                    .type = null,
                },
            },
        },
    },
    .{
        "@memset",
        Builtin{
            .signature = "@memset(dest, elem) void",
            .return_type = "void",
            .snippet = "@memset(${1:dest}, ${2:elem})",
            .documentation =
            \\This function sets all the elements of a memory region to `elem`.
            \\
            \\`dest` must be a mutable slice or a mutable pointer to an array. It may have any alignment, and it may have any element type.
            \\
            \\`elem` is coerced to the element type of `dest`.
            \\
            \\For securely zeroing out sensitive contents from memory, you should use `std.crypto.secureZero`
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "dest",
                    .type = null,
                },
                .{
                    .signature = "elem",
                    .type = null,
                },
            },
        },
    },
    .{
        "@memmove",
        Builtin{
            .signature = "@memmove(dest, source) void",
            .return_type = "void",
            .snippet = "@memmove(${1:dest}, ${2:source})",
            .documentation =
            \\This function copies bytes from one region of memory to another, but unlike [@memcpy](https://ziglang.org/documentation/0.15.0/#memcpy) the regions may overlap.
            \\
            \\`dest` must be a mutable slice, a mutable pointer to an array, or a mutable many-item [pointer](https://ziglang.org/documentation/0.15.0/#Pointers). It may have any alignment, and it may have any element type.
            \\
            \\`source` must be a slice, a pointer to an array, or a many-item [pointer](https://ziglang.org/documentation/0.15.0/#Pointers). It may have any alignment, and it may have any element type.
            \\
            \\The `source` element type must have the same in-memory representation as the `dest` element type.
            \\
            \\Similar to [for](https://ziglang.org/documentation/0.15.0/#for) loops, at least one of `source` and `dest` must provide a length, and if two lengths are provided, they must be equal.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "dest",
                    .type = null,
                },
                .{
                    .signature = "source",
                    .type = null,
                },
            },
        },
    },
    .{
        "@min",
        Builtin{
            .signature = "@min(...) T",
            .return_type = "T",
            .snippet = "@min(${1:...})",
            .documentation =
            \\Takes two or more arguments and returns the smallest value included (the minimum). This builtin accepts integers, floats, and vectors of either. In the latter case, the operation is performed element wise.
            \\
            \\NaNs are handled as follows: return the smallest non-NaN value included. If all operands are NaN, return NaN.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "...",
                    .type = null,
                },
            },
        },
    },
    .{
        "@wasmMemorySize",
        Builtin{
            .signature = "@wasmMemorySize(index: u32) usize",
            .return_type = "usize",
            .snippet = "@wasmMemorySize(${1:index: u32})",
            .documentation =
            \\This function returns the size of the Wasm memory identified by `index` as an unsigned value in units of Wasm pages. Note that each Wasm page is 64KB in size.
            \\
            \\This function is a low level intrinsic with no safety mechanisms usually useful for allocator designers targeting Wasm. So unless you are writing a new allocator from scratch, you should use something like `@import("std").heap.WasmPageAllocator`.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "index: u32",
                    .type = "u32",
                },
            },
        },
    },
    .{
        "@wasmMemoryGrow",
        Builtin{
            .signature = "@wasmMemoryGrow(index: u32, delta: usize) isize",
            .return_type = "isize",
            .snippet = "@wasmMemoryGrow(${1:index: u32}, ${2:delta: usize})",
            .documentation =
            \\This function increases the size of the Wasm memory identified by `index` by `delta` in units of unsigned number of Wasm pages. Note that each Wasm page is 64KB in size. On success, returns previous memory size; on failure, if the allocation fails, returns -1.
            \\
            \\This function is a low level intrinsic with no safety mechanisms usually useful for allocator designers targeting Wasm. So unless you are writing a new allocator from scratch, you should use something like `@import("std").heap.WasmPageAllocator`.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "index: u32",
                    .type = "u32",
                },
                .{
                    .signature = "delta: usize",
                    .type = "usize",
                },
            },
        },
    },
    .{
        "@mod",
        Builtin{
            .signature = "@mod(numerator: T, denominator: T) T",
            .return_type = "T",
            .snippet = "@mod(${1:numerator: T}, ${2:denominator: T})",
            .documentation =
            \\Modulus division. For unsigned integers this is the same as `numerator % denominator`. Caller guarantees `denominator != 0`, otherwise the operation will result in a [Remainder Division by Zero](https://ziglang.org/documentation/0.15.0/#Remainder-Division-by-Zero) when runtime safety checks are enabled.
            \\
            \\ - `@mod(-5, 3) == 1`
            \\ - `(@divFloor(a, b) * b) + @mod(a, b) == a`
            \\For a function that returns an error code, see `@import("std").math.mod`.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "numerator: T",
                    .type = "T",
                },
                .{
                    .signature = "denominator: T",
                    .type = "T",
                },
            },
        },
    },
    .{
        "@mulWithOverflow",
        Builtin{
            .signature = "@mulWithOverflow(a: anytype, b: anytype) struct { @TypeOf(a, b), u1 }",
            .return_type = "struct { @TypeOf(a, b), u1 }",
            .snippet = "@mulWithOverflow(${1:a: anytype}, ${2:b: anytype})",
            .documentation =
            \\Performs `a * b` and returns a tuple with the result and a possible overflow bit.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "a: anytype",
                    .type = "anytype",
                },
                .{
                    .signature = "b: anytype",
                    .type = "anytype",
                },
            },
        },
    },
    .{
        "@panic",
        Builtin{
            .signature = "@panic(message: []const u8) noreturn",
            .return_type = "noreturn",
            .snippet = "@panic(${1:message: []const u8})",
            .documentation =
            \\Invokes the panic handler function. By default the panic handler function calls the public `panic` function exposed in the root source file, or if there is not one specified, the `std.builtin.default_panic` function from `std/builtin.zig`.
            \\
            \\Generally it is better to use `@import("std").debug.panic`. However, `@panic` can be useful for 2 scenarios:
            \\
            \\ - From library code, calling the programmer's panic function if they exposed one in the root source file.
            \\ - When mixing C and Zig code, calling the canonical panic implementation across multiple .o files.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "message: []const u8",
                    .type = "[]const u8",
                },
            },
        },
    },
    .{
        "@popCount",
        Builtin{
            .signature = "@popCount(operand: anytype) anytype",
            .return_type = "anytype",
            .snippet = "@popCount(${1:operand: anytype})",
            .documentation =
            \\`@TypeOf(operand)` must be an integer type.
            \\
            \\`operand` may be an [integer](https://ziglang.org/documentation/0.15.0/#Integers) or [vector](https://ziglang.org/documentation/0.15.0/#Vectors).
            \\
            \\Counts the number of bits set in an integer - "population count".
            \\
            \\The return type is an unsigned integer or vector of unsigned integers with the minimum number of bits that can represent the bit count of the integer type.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "operand: anytype",
                    .type = "anytype",
                },
            },
        },
    },
    .{
        "@prefetch",
        Builtin{
            .signature = "@prefetch(ptr: anytype, comptime options: PrefetchOptions) void",
            .return_type = "void",
            .snippet = "@prefetch(${1:ptr: anytype}, ${2:comptime options: PrefetchOptions})",
            .documentation =
            \\This builtin tells the compiler to emit a prefetch instruction if supported by the target CPU. If the target CPU does not support the requested prefetch instruction, this builtin is a no-op. This function has no effect on the behavior of the program, only on the performance characteristics.
            \\
            \\The `ptr` argument may be any pointer type and determines the memory address to prefetch. This function does not dereference the pointer, it is perfectly legal to pass a pointer to invalid memory to this function and no Illegal Behavior will result.
            \\
            \\`PrefetchOptions` can be found with `@import("std").builtin.PrefetchOptions`.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "ptr: anytype",
                    .type = "anytype",
                },
                .{
                    .signature = "comptime options: PrefetchOptions",
                    .type = "PrefetchOptions",
                },
            },
        },
    },
    .{
        "@ptrCast",
        Builtin{
            .signature = "@ptrCast(value: anytype) anytype",
            .return_type = "anytype",
            .snippet = "@ptrCast(${1:value: anytype})",
            .documentation =
            \\Converts a pointer of one type to a pointer of another type. The return type is the inferred result type.
            \\
            \\[Optional Pointers](https://ziglang.org/documentation/0.15.0/#Optional-Pointers) are allowed. Casting an optional pointer which is [null](https://ziglang.org/documentation/0.15.0/#null) to a non-optional pointer invokes safety-checked [Illegal Behavior](https://ziglang.org/documentation/0.15.0/#Illegal-Behavior).
            \\
            \\`@ptrCast` cannot be used for:
            \\
            \\ - Removing `const` qualifier, use [@constCast](https://ziglang.org/documentation/0.15.0/#constCast).
            \\ - Removing `volatile` qualifier, use [@volatileCast](https://ziglang.org/documentation/0.15.0/#volatileCast).
            \\ - Changing pointer address space, use [@addrSpaceCast](https://ziglang.org/documentation/0.15.0/#addrSpaceCast).
            \\ - Increasing pointer alignment, use [@alignCast](https://ziglang.org/documentation/0.15.0/#alignCast).
            \\ - Casting a non-slice pointer to a slice, use slicing syntax `ptr[start..end]`.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "value: anytype",
                    .type = "anytype",
                },
            },
        },
    },
    .{
        "@ptrFromInt",
        Builtin{
            .signature = "@ptrFromInt(address: usize) anytype",
            .return_type = "anytype",
            .snippet = "@ptrFromInt(${1:address: usize})",
            .documentation =
            \\Converts an integer to a [pointer](https://ziglang.org/documentation/0.15.0/#Pointers). The return type is the inferred result type. To convert the other way, use [@intFromPtr](https://ziglang.org/documentation/0.15.0/#intFromPtr). Casting an address of 0 to a destination type which in not [optional](https://ziglang.org/documentation/0.15.0/#Optional-Pointers) and does not have the `allowzero` attribute will result in a [Pointer Cast Invalid Null](https://ziglang.org/documentation/0.15.0/#Pointer-Cast-Invalid-Null) panic when runtime safety checks are enabled.
            \\
            \\If the destination pointer type does not allow address zero and `address` is zero, this invokes safety-checked [Illegal Behavior](https://ziglang.org/documentation/0.15.0/#Illegal-Behavior).
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "address: usize",
                    .type = "usize",
                },
            },
        },
    },
    .{
        "@rem",
        Builtin{
            .signature = "@rem(numerator: T, denominator: T) T",
            .return_type = "T",
            .snippet = "@rem(${1:numerator: T}, ${2:denominator: T})",
            .documentation =
            \\Remainder division. For unsigned integers this is the same as `numerator % denominator`. Caller guarantees `denominator != 0`, otherwise the operation will result in a [Remainder Division by Zero](https://ziglang.org/documentation/0.15.0/#Remainder-Division-by-Zero) when runtime safety checks are enabled.
            \\
            \\ - `@rem(-5, 3) == -2`
            \\ - `(@divTrunc(a, b) * b) + @rem(a, b) == a`
            \\For a function that returns an error code, see `@import("std").math.rem`.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "numerator: T",
                    .type = "T",
                },
                .{
                    .signature = "denominator: T",
                    .type = "T",
                },
            },
        },
    },
    .{
        "@returnAddress",
        Builtin{
            .signature = "@returnAddress() usize",
            .return_type = "usize",
            .snippet = "@returnAddress()",
            .documentation =
            \\This function returns the address of the next machine code instruction that will be executed when the current function returns.
            \\
            \\The implications of this are target-specific and not consistent across all platforms.
            \\
            \\This function is only valid within function scope. If the function gets inlined into a calling function, the returned address will apply to the calling function.
            ,
            .parameters = &[_]Builtin.Parameter{},
        },
    },
    .{
        "@select",
        Builtin{
            .signature = "@select(comptime T: type, pred: @Vector(len, bool), a: @Vector(len, T), b: @Vector(len, T)) @Vector(len, T)",
            .return_type = "@Vector(len, T)",
            .snippet = "@select(${1:comptime T: type}, ${2:pred: @Vector(len, bool)}, ${3:a: @Vector(len, T)}, ${4:b: @Vector(len, T)})",
            .documentation =
            \\Selects values element-wise from `a` or `b` based on `pred`. If `pred[i]` is `true`, the corresponding element in the result will be `a[i]` and otherwise `b[i]`.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "comptime T: type",
                    .type = "type",
                },
                .{
                    .signature = "pred: @Vector(len, bool)",
                    .type = "@Vector(len, bool)",
                },
                .{
                    .signature = "a: @Vector(len, T)",
                    .type = "@Vector(len, T)",
                },
                .{
                    .signature = "b: @Vector(len, T)",
                    .type = "@Vector(len, T)",
                },
            },
        },
    },
    .{
        "@setEvalBranchQuota",
        Builtin{
            .signature = "@setEvalBranchQuota(comptime new_quota: u32) void",
            .return_type = "void",
            .snippet = "@setEvalBranchQuota(${1:comptime new_quota: u32})",
            .documentation =
            \\Increase the maximum number of backwards branches that compile-time code execution can use before giving up and making a compile error.
            \\
            \\If the `new_quota` is smaller than the default quota (`1000`) or a previously explicitly set quota, it is ignored.
            \\
            \\Example:
            \\
            \\Now we use `@setEvalBranchQuota`:
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "comptime new_quota: u32",
                    .type = "u32",
                },
            },
        },
    },
    .{
        "@setFloatMode",
        Builtin{
            .signature = "@setFloatMode(comptime mode: FloatMode) void",
            .return_type = "void",
            .snippet = "@setFloatMode(${1:comptime mode: FloatMode})",
            .documentation =
            \\Changes the current scope's rules about how floating point operations are defined.
            \\
            \\ - `Strict` (default) - Floating point operations follow strict IEEE compliance.
            \\ - `Optimized` - Floating point operations may do all of the following:
            \\   - Assume the arguments and result are not NaN. Optimizations are required to retain legal behavior over NaNs, but the value of the result is undefined.
            \\   - Assume the arguments and result are not +/-Inf. Optimizations are required to retain legal behavior over +/-Inf, but the value of the result is undefined.
            \\   - Treat the sign of a zero argument or result as insignificant.
            \\   - Use the reciprocal of an argument rather than perform division.
            \\   - Perform floating-point contraction (e.g. fusing a multiply followed by an addition into a fused multiply-add).
            \\   - Perform algebraically equivalent transformations that may change results in floating point (e.g. reassociate).
            \\This is equivalent to
            \\`-ffast-math`in GCC.
            \\The floating point mode is inherited by child scopes, and can be overridden in any scope. You can set the floating point mode in a struct or module scope by using a comptime block.
            \\
            \\`FloatMode` can be found with `@import("std").builtin.FloatMode`.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "comptime mode: FloatMode",
                    .type = "FloatMode",
                },
            },
        },
    },
    .{
        "@setRuntimeSafety",
        Builtin{
            .signature = "@setRuntimeSafety(comptime safety_on: bool) void",
            .return_type = "void",
            .snippet = "@setRuntimeSafety(${1:comptime safety_on: bool})",
            .documentation =
            \\Sets whether runtime safety checks are enabled for the scope that contains the function call.
            \\
            \\Note: it is
            \\[planned](https://github.com/ziglang/zig/issues/978)to replace `@setRuntimeSafety` with
            \\`@optimizeFor`
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "comptime safety_on: bool",
                    .type = "bool",
                },
            },
        },
    },
    .{
        "@shlExact",
        Builtin{
            .signature = "@shlExact(value: T, shift_amt: Log2T) T",
            .return_type = "T",
            .snippet = "@shlExact(${1:value: T}, ${2:shift_amt: Log2T})",
            .documentation =
            \\`). For unsigned integers, the result is [undefined](https://ziglang.org/documentation/0.15.0/#undefined) if any 1 bits are shifted out. For signed integers, the result is [undefined](https://ziglang.org/documentation/0.15.0/#undefined) if any bits that disagree with the resultant sign bit are shifted out.
            \\
            \\The type of `shift_amt` is an unsigned integer with `log2(@typeInfo(T).int.bits)` bits. This is because `shift_amt >= @typeInfo(T).int.bits` triggers safety-checked [Illegal Behavior](https://ziglang.org/documentation/0.15.0/#Illegal-Behavior).
            \\
            \\`comptime_int` is modeled as an integer with an infinite number of bits, meaning that in such case, `@shlExact` always produces a result and cannot produce a compile error.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "value: T",
                    .type = "T",
                },
                .{
                    .signature = "shift_amt: Log2T",
                    .type = "Log2T",
                },
            },
        },
    },
    .{
        "@shlWithOverflow",
        Builtin{
            .signature = "@shlWithOverflow(a: anytype, shift_amt: Log2T) struct { @TypeOf(a), u1 }",
            .return_type = "struct { @TypeOf(a), u1 }",
            .snippet = "@shlWithOverflow(${1:a: anytype}, ${2:shift_amt: Log2T})",
            .documentation =
            \\b` and returns a tuple with the result and a possible overflow bit.
            \\
            \\The type of `shift_amt` is an unsigned integer with `log2(@typeInfo(@TypeOf(a)).int.bits)` bits. This is because `shift_amt >= @typeInfo(@TypeOf(a)).int.bits` triggers safety-checked [Illegal Behavior](https://ziglang.org/documentation/0.15.0/#Illegal-Behavior).
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "a: anytype",
                    .type = "anytype",
                },
                .{
                    .signature = "shift_amt: Log2T",
                    .type = "Log2T",
                },
            },
        },
    },
    .{
        "@shrExact",
        Builtin{
            .signature = "@shrExact(value: T, shift_amt: Log2T) T",
            .return_type = "T",
            .snippet = "@shrExact(${1:value: T}, ${2:shift_amt: Log2T})",
            .documentation =
            \\Performs the right shift operation (`>>`). Caller guarantees that the shift will not shift any 1 bits out.
            \\
            \\The type of `shift_amt` is an unsigned integer with `log2(@typeInfo(T).int.bits)` bits. This is because `shift_amt >= @typeInfo(T).int.bits` triggers safety-checked [Illegal Behavior](https://ziglang.org/documentation/0.15.0/#Illegal-Behavior).
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "value: T",
                    .type = "T",
                },
                .{
                    .signature = "shift_amt: Log2T",
                    .type = "Log2T",
                },
            },
        },
    },
    .{
        "@shuffle",
        Builtin{
            .signature = "@shuffle(comptime E: type, a: @Vector(a_len, E), b: @Vector(b_len, E), comptime mask: @Vector(mask_len, i32)) @Vector(mask_len, E)",
            .return_type = "@Vector(mask_len, E)",
            .snippet = "@shuffle(${1:comptime E: type}, ${2:a: @Vector(a_len, E)}, ${3:b: @Vector(b_len, E)}, ${4:comptime mask: @Vector(mask_len, i32)})",
            .documentation =
            \\Constructs a new [vector](https://ziglang.org/documentation/0.15.0/#Vectors) by selecting elements from `a` and `b` based on `mask`.
            \\
            \\Each element in `mask` selects an element from either `a` or `b`. Positive numbers select from `a` starting at 0. Negative values select from `b`, starting at `-1` and going down. It is recommended to use the `~` operator for indexes from `b` so that both indexes can start from `0` (i.e. `~@as(i32, 0)` is `-1`).
            \\
            \\For each element of `mask`, if it or the selected value from `a` or `b` is `undefined`, then the resulting element is `undefined`.
            \\
            \\`a_len` and `b_len` may differ in length. Out-of-bounds element indexes in `mask` result in compile errors.
            \\
            \\If `a` or `b` is `undefined`, it is equivalent to a vector of all `undefined` with the same length as the other vector. If both vectors are `undefined`, `@shuffle` returns a vector with all elements `undefined`.
            \\
            \\`E` must be an [integer](https://ziglang.org/documentation/0.15.0/#Integers), [float](https://ziglang.org/documentation/0.15.0/#Floats), [pointer](https://ziglang.org/documentation/0.15.0/#Pointers), or `bool`. The mask may be any vector length, and its length determines the result length.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "comptime E: type",
                    .type = "type",
                },
                .{
                    .signature = "a: @Vector(a_len, E)",
                    .type = "@Vector(a_len, E)",
                },
                .{
                    .signature = "b: @Vector(b_len, E)",
                    .type = "@Vector(b_len, E)",
                },
                .{
                    .signature = "comptime mask: @Vector(mask_len, i32)",
                    .type = "@Vector(mask_len, i32)",
                },
            },
        },
    },
    .{
        "@sizeOf",
        Builtin{
            .signature = "@sizeOf(comptime T: type) comptime_int",
            .return_type = "comptime_int",
            .snippet = "@sizeOf(${1:comptime T: type})",
            .documentation =
            \\This function returns the number of bytes it takes to store `T` in memory. The result is a target-specific compile time constant.
            \\
            \\This size may contain padding bytes. If there were two consecutive T in memory, the padding would be the offset in bytes between element at index 0 and the element at index 1. For [integer](https://ziglang.org/documentation/0.15.0/#Integers), consider whether you want to use `@sizeOf(T)` or `@typeInfo(T).int.bits`.
            \\
            \\This function measures the size at runtime. For types that are disallowed at runtime, such as `comptime_int` and `type`, the result is `0`.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "comptime T: type",
                    .type = "type",
                },
            },
        },
    },
    .{
        "@splat",
        Builtin{
            .signature = "@splat(scalar: anytype) anytype",
            .return_type = "anytype",
            .snippet = "@splat(${1:scalar: anytype})",
            .documentation =
            \\Produces an array or vector where each element is the value `scalar`. The return type and thus the length of the vector is inferred.
            \\
            \\`scalar` must be an [integer](https://ziglang.org/documentation/0.15.0/#Integers), [bool](https://ziglang.org/documentation/0.15.0/#Primitive-Types), [float](https://ziglang.org/documentation/0.15.0/#Floats), or [pointer](https://ziglang.org/documentation/0.15.0/#Pointers).
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "scalar: anytype",
                    .type = "anytype",
                },
            },
        },
    },
    .{
        "@reduce",
        Builtin{
            .signature = "@reduce(comptime op: std.builtin.ReduceOp, value: anytype) E",
            .return_type = "E",
            .snippet = "@reduce(${1:comptime op: std.builtin.ReduceOp}, ${2:value: anytype})",
            .documentation =
            \\Transforms a [vector](https://ziglang.org/documentation/0.15.0/#Vectors) into a scalar value (of type
            \\`E`) by performing a sequential horizontal reduction of its elements using the specified operator `op`.
            \\
            \\Not every operator is available for every vector element type:
            \\
            \\ - Every operator is available for [integer](https://ziglang.org/documentation/0.15.0/#Integers) vectors.
            \\ - `.And`, `.Or`, `.Xor` are additionally available for `bool` vectors,
            \\ - `.Min`, `.Max`, `.Add`, `.Mul` are additionally available for [floating point](https://ziglang.org/documentation/0.15.0/#Floats) vectors,
            \\Note that `.Add` and `.Mul` reductions on integral types are wrapping; when applied on floating point types the operation associativity is preserved, unless the float mode is set to `Optimized`.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "comptime op: std.builtin.ReduceOp",
                    .type = "ReduceOp",
                },
                .{
                    .signature = "value: anytype",
                    .type = "anytype",
                },
            },
        },
    },
    .{
        "@src",
        Builtin{
            .signature = "@src() std.builtin.SourceLocation",
            .return_type = "SourceLocation",
            .snippet = "@src()",
            .documentation =
            \\Returns a `SourceLocation` struct representing the function's name and location in the source code. This must be called in a function.
            ,
            .parameters = &[_]Builtin.Parameter{},
        },
    },
    .{
        "@sqrt",
        Builtin{
            .signature = "@sqrt(value: anytype) @TypeOf(value)",
            .return_type = "@TypeOf(value)",
            .snippet = "@sqrt(${1:value: anytype})",
            .documentation =
            \\Performs the square root of a floating point number. Uses a dedicated hardware instruction when available.
            \\
            \\Supports [Floats](https://ziglang.org/documentation/0.15.0/#Floats) and [Vectors](https://ziglang.org/documentation/0.15.0/#Vectors) of floats.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "value: anytype",
                    .type = "anytype",
                },
            },
        },
    },
    .{
        "@sin",
        Builtin{
            .signature = "@sin(value: anytype) @TypeOf(value)",
            .return_type = "@TypeOf(value)",
            .snippet = "@sin(${1:value: anytype})",
            .documentation =
            \\Sine trigonometric function on a floating point number in radians. Uses a dedicated hardware instruction when available.
            \\
            \\Supports [Floats](https://ziglang.org/documentation/0.15.0/#Floats) and [Vectors](https://ziglang.org/documentation/0.15.0/#Vectors) of floats.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "value: anytype",
                    .type = "anytype",
                },
            },
        },
    },
    .{
        "@cos",
        Builtin{
            .signature = "@cos(value: anytype) @TypeOf(value)",
            .return_type = "@TypeOf(value)",
            .snippet = "@cos(${1:value: anytype})",
            .documentation =
            \\Cosine trigonometric function on a floating point number in radians. Uses a dedicated hardware instruction when available.
            \\
            \\Supports [Floats](https://ziglang.org/documentation/0.15.0/#Floats) and [Vectors](https://ziglang.org/documentation/0.15.0/#Vectors) of floats.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "value: anytype",
                    .type = "anytype",
                },
            },
        },
    },
    .{
        "@tan",
        Builtin{
            .signature = "@tan(value: anytype) @TypeOf(value)",
            .return_type = "@TypeOf(value)",
            .snippet = "@tan(${1:value: anytype})",
            .documentation =
            \\Tangent trigonometric function on a floating point number in radians. Uses a dedicated hardware instruction when available.
            \\
            \\Supports [Floats](https://ziglang.org/documentation/0.15.0/#Floats) and [Vectors](https://ziglang.org/documentation/0.15.0/#Vectors) of floats.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "value: anytype",
                    .type = "anytype",
                },
            },
        },
    },
    .{
        "@exp",
        Builtin{
            .signature = "@exp(value: anytype) @TypeOf(value)",
            .return_type = "@TypeOf(value)",
            .snippet = "@exp(${1:value: anytype})",
            .documentation =
            \\Base-e exponential function on a floating point number. Uses a dedicated hardware instruction when available.
            \\
            \\Supports [Floats](https://ziglang.org/documentation/0.15.0/#Floats) and [Vectors](https://ziglang.org/documentation/0.15.0/#Vectors) of floats.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "value: anytype",
                    .type = "anytype",
                },
            },
        },
    },
    .{
        "@exp2",
        Builtin{
            .signature = "@exp2(value: anytype) @TypeOf(value)",
            .return_type = "@TypeOf(value)",
            .snippet = "@exp2(${1:value: anytype})",
            .documentation =
            \\Base-2 exponential function on a floating point number. Uses a dedicated hardware instruction when available.
            \\
            \\Supports [Floats](https://ziglang.org/documentation/0.15.0/#Floats) and [Vectors](https://ziglang.org/documentation/0.15.0/#Vectors) of floats.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "value: anytype",
                    .type = "anytype",
                },
            },
        },
    },
    .{
        "@log",
        Builtin{
            .signature = "@log(value: anytype) @TypeOf(value)",
            .return_type = "@TypeOf(value)",
            .snippet = "@log(${1:value: anytype})",
            .documentation =
            \\Returns the natural logarithm of a floating point number. Uses a dedicated hardware instruction when available.
            \\
            \\Supports [Floats](https://ziglang.org/documentation/0.15.0/#Floats) and [Vectors](https://ziglang.org/documentation/0.15.0/#Vectors) of floats.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "value: anytype",
                    .type = "anytype",
                },
            },
        },
    },
    .{
        "@log2",
        Builtin{
            .signature = "@log2(value: anytype) @TypeOf(value)",
            .return_type = "@TypeOf(value)",
            .snippet = "@log2(${1:value: anytype})",
            .documentation =
            \\Returns the logarithm to the base 2 of a floating point number. Uses a dedicated hardware instruction when available.
            \\
            \\Supports [Floats](https://ziglang.org/documentation/0.15.0/#Floats) and [Vectors](https://ziglang.org/documentation/0.15.0/#Vectors) of floats.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "value: anytype",
                    .type = "anytype",
                },
            },
        },
    },
    .{
        "@log10",
        Builtin{
            .signature = "@log10(value: anytype) @TypeOf(value)",
            .return_type = "@TypeOf(value)",
            .snippet = "@log10(${1:value: anytype})",
            .documentation =
            \\Returns the logarithm to the base 10 of a floating point number. Uses a dedicated hardware instruction when available.
            \\
            \\Supports [Floats](https://ziglang.org/documentation/0.15.0/#Floats) and [Vectors](https://ziglang.org/documentation/0.15.0/#Vectors) of floats.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "value: anytype",
                    .type = "anytype",
                },
            },
        },
    },
    .{
        "@abs",
        Builtin{
            .signature = "@abs(value: anytype) anytype",
            .return_type = "anytype",
            .snippet = "@abs(${1:value: anytype})",
            .documentation =
            \\Returns the absolute value of an integer or a floating point number. Uses a dedicated hardware instruction when available.  The return type is always an unsigned integer of the same bit width as the operand if the operand is an integer. Unsigned integer operands are supported. The builtin cannot overflow for signed integer operands.
            \\
            \\Supports [Floats](https://ziglang.org/documentation/0.15.0/#Floats), [Integers](https://ziglang.org/documentation/0.15.0/#Integers) and [Vectors](https://ziglang.org/documentation/0.15.0/#Vectors) of floats or integers.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "value: anytype",
                    .type = "anytype",
                },
            },
        },
    },
    .{
        "@floor",
        Builtin{
            .signature = "@floor(value: anytype) @TypeOf(value)",
            .return_type = "@TypeOf(value)",
            .snippet = "@floor(${1:value: anytype})",
            .documentation =
            \\Returns the largest integral value not greater than the given floating point number. Uses a dedicated hardware instruction when available.
            \\
            \\Supports [Floats](https://ziglang.org/documentation/0.15.0/#Floats) and [Vectors](https://ziglang.org/documentation/0.15.0/#Vectors) of floats.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "value: anytype",
                    .type = "anytype",
                },
            },
        },
    },
    .{
        "@ceil",
        Builtin{
            .signature = "@ceil(value: anytype) @TypeOf(value)",
            .return_type = "@TypeOf(value)",
            .snippet = "@ceil(${1:value: anytype})",
            .documentation =
            \\Returns the smallest integral value not less than the given floating point number. Uses a dedicated hardware instruction when available.
            \\
            \\Supports [Floats](https://ziglang.org/documentation/0.15.0/#Floats) and [Vectors](https://ziglang.org/documentation/0.15.0/#Vectors) of floats.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "value: anytype",
                    .type = "anytype",
                },
            },
        },
    },
    .{
        "@trunc",
        Builtin{
            .signature = "@trunc(value: anytype) @TypeOf(value)",
            .return_type = "@TypeOf(value)",
            .snippet = "@trunc(${1:value: anytype})",
            .documentation =
            \\Rounds the given floating point number to an integer, towards zero. Uses a dedicated hardware instruction when available.
            \\
            \\Supports [Floats](https://ziglang.org/documentation/0.15.0/#Floats) and [Vectors](https://ziglang.org/documentation/0.15.0/#Vectors) of floats.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "value: anytype",
                    .type = "anytype",
                },
            },
        },
    },
    .{
        "@round",
        Builtin{
            .signature = "@round(value: anytype) @TypeOf(value)",
            .return_type = "@TypeOf(value)",
            .snippet = "@round(${1:value: anytype})",
            .documentation =
            \\Rounds the given floating point number to the nearest integer. If two integers are equally close, rounds away from zero. Uses a dedicated hardware instruction when available.
            \\
            \\Supports [Floats](https://ziglang.org/documentation/0.15.0/#Floats) and [Vectors](https://ziglang.org/documentation/0.15.0/#Vectors) of floats.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "value: anytype",
                    .type = "anytype",
                },
            },
        },
    },
    .{
        "@subWithOverflow",
        Builtin{
            .signature = "@subWithOverflow(a: anytype, b: anytype) struct { @TypeOf(a, b), u1 }",
            .return_type = "struct { @TypeOf(a, b), u1 }",
            .snippet = "@subWithOverflow(${1:a: anytype}, ${2:b: anytype})",
            .documentation =
            \\Performs `a - b` and returns a tuple with the result and a possible overflow bit.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "a: anytype",
                    .type = "anytype",
                },
                .{
                    .signature = "b: anytype",
                    .type = "anytype",
                },
            },
        },
    },
    .{
        "@tagName",
        Builtin{
            .signature = "@tagName(value: anytype) [:0]const u8",
            .return_type = "[:0]const u8",
            .snippet = "@tagName(${1:value: anytype})",
            .documentation =
            \\Converts an enum value or union value to a string literal representing the name.
            \\
            \\If the enum is non-exhaustive and the tag value does not map to a name, it invokes safety-checked [Illegal Behavior](https://ziglang.org/documentation/0.15.0/#Illegal-Behavior).
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "value: anytype",
                    .type = "anytype",
                },
            },
        },
    },
    .{
        "@This",
        Builtin{
            .signature = "@This() type",
            .return_type = "type",
            .snippet = "@This()",
            .documentation =
            \\Returns the innermost struct, enum, or union that this function call is inside. This can be useful for an anonymous struct that needs to refer to itself:
            \\
            \\When `@This()` is used at file scope, it returns a reference to the struct that corresponds to the current file.
            ,
            .parameters = &[_]Builtin.Parameter{},
        },
    },
    .{
        "@trap",
        Builtin{
            .signature = "@trap() noreturn",
            .return_type = "noreturn",
            .snippet = "@trap()",
            .documentation =
            \\This function inserts a platform-specific trap/jam instruction which can be used to exit the program abnormally. This may be implemented by explicitly emitting an invalid instruction which may cause an illegal instruction exception of some sort. Unlike for `@breakpoint()`, execution does not continue after this point.
            \\
            \\Outside function scope, this builtin causes a compile error.
            ,
            .parameters = &[_]Builtin.Parameter{},
        },
    },
    .{
        "@truncate",
        Builtin{
            .signature = "@truncate(integer: anytype) anytype",
            .return_type = "anytype",
            .snippet = "@truncate(${1:integer: anytype})",
            .documentation =
            \\This function truncates bits from an integer type, resulting in a smaller or same-sized integer type. The return type is the inferred result type.
            \\
            \\This function always truncates the significant bits of the integer, regardless of endianness on the target platform.
            \\
            \\Calling `@truncate` on a number out of range of the destination type is well defined and working code:
            \\
            \\Use [@intCast](https://ziglang.org/documentation/0.15.0/#intCast) to convert numbers guaranteed to fit the destination type.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "integer: anytype",
                    .type = "anytype",
                },
            },
        },
    },
    .{
        "@Type",
        Builtin{
            .signature = "@Type(comptime info: std.builtin.Type) type",
            .return_type = "type",
            .snippet = "@Type(${1:comptime info: std.builtin.Type})",
            .documentation =
            \\This function is the inverse of [@typeInfo](https://ziglang.org/documentation/0.15.0/#typeInfo). It reifies type information into a `type`.
            \\
            \\It is available for the following types:
            \\
            \\ - `type`
            \\ - `noreturn`
            \\ - `void`
            \\ - `bool`
            \\ - [Integers](https://ziglang.org/documentation/0.15.0/#Integers) - The maximum bit count for an integer type is `65535`.
            \\ - [Floats](https://ziglang.org/documentation/0.15.0/#Floats)
            \\ - [Pointers](https://ziglang.org/documentation/0.15.0/#Pointers)
            \\ - `comptime_int`
            \\ - `comptime_float`
            \\ - `@TypeOf(undefined)`
            \\ - `@TypeOf(null)`
            \\ - [Arrays](https://ziglang.org/documentation/0.15.0/#Arrays)
            \\ - [Optionals](https://ziglang.org/documentation/0.15.0/#Optionals)
            \\ - [Error Set Type](https://ziglang.org/documentation/0.15.0/#Error-Set-Type)
            \\ - [Error Union Type](https://ziglang.org/documentation/0.15.0/#Error-Union-Type)
            \\ - [Vectors](https://ziglang.org/documentation/0.15.0/#Vectors)
            \\ - [opaque](https://ziglang.org/documentation/0.15.0/#opaque)
            \\ - `anyframe`
            \\ - [struct](https://ziglang.org/documentation/0.15.0/#struct)
            \\ - [enum](https://ziglang.org/documentation/0.15.0/#enum)
            \\ - [Enum Literals](https://ziglang.org/documentation/0.15.0/#Enum-Literals)
            \\ - [union](https://ziglang.org/documentation/0.15.0/#union)
            \\ - [Functions](https://ziglang.org/documentation/0.15.0/#Functions)
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "comptime info: std.builtin.Type",
                    .type = "Type",
                },
            },
        },
    },
    .{
        "@typeInfo",
        Builtin{
            .signature = "@typeInfo(comptime T: type) std.builtin.Type",
            .return_type = "Type",
            .snippet = "@typeInfo(${1:comptime T: type})",
            .documentation =
            \\Provides type reflection.
            \\
            \\Type information of [structs](https://ziglang.org/documentation/0.15.0/#struct), [unions](https://ziglang.org/documentation/0.15.0/#union), [enums](https://ziglang.org/documentation/0.15.0/#enum), and [error sets](https://ziglang.org/documentation/0.15.0/#Error-Set-Type) has fields which are guaranteed to be in the same order as appearance in the source file.
            \\
            \\Type information of [structs](https://ziglang.org/documentation/0.15.0/#struct), [unions](https://ziglang.org/documentation/0.15.0/#union), [enums](https://ziglang.org/documentation/0.15.0/#enum), and [opaques](https://ziglang.org/documentation/0.15.0/#opaque) has declarations, which are also guaranteed to be in the same order as appearance in the source file.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "comptime T: type",
                    .type = "type",
                },
            },
        },
    },
    .{
        "@typeName",
        Builtin{
            .signature = "@typeName(T: type) *const [N:0]u8",
            .return_type = "*const [N:0]u8",
            .snippet = "@typeName(${1:T: type})",
            .documentation =
            \\This function returns the string representation of a type, as an array. It is equivalent to a string literal of the type name. The returned type name is fully qualified with the parent namespace included as part of the type name with a series of dots.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "T: type",
                    .type = "type",
                },
            },
        },
    },
    .{
        "@TypeOf",
        Builtin{
            .signature = "@TypeOf(...) type",
            .return_type = "type",
            .snippet = "@TypeOf(${1:...})",
            .documentation =
            \\`@TypeOf` is a special builtin function that takes any (non-zero) number of expressions as parameters and returns the type of the result, using [Peer Type Resolution](https://ziglang.org/documentation/0.15.0/#Peer-Type-Resolution).
            \\
            \\The expressions are evaluated, however they are guaranteed to have no
            \\**runtime** side-effects:
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "...",
                    .type = null,
                },
            },
        },
    },
    .{
        "@unionInit",
        Builtin{
            .signature = "@unionInit(comptime Union: type, comptime active_field_name: []const u8, init_expr) Union",
            .return_type = "Union",
            .snippet = "@unionInit(${1:comptime Union: type}, ${2:comptime active_field_name: []const u8}, ${3:init_expr})",
            .documentation =
            \\This is the same thing as [union](https://ziglang.org/documentation/0.15.0/#union) initialization syntax, except that the field name is a [comptime](https://ziglang.org/documentation/0.15.0/#comptime)-known value rather than an identifier token.
            \\
            \\`@unionInit` forwards its [result location](https://ziglang.org/documentation/0.15.0/#Result-Location-Semantics) to `init_expr`.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "comptime Union: type",
                    .type = "type",
                },
                .{
                    .signature = "comptime active_field_name: []const u8",
                    .type = "[]const u8",
                },
                .{
                    .signature = "init_expr",
                    .type = null,
                },
            },
        },
    },
    .{
        "@Vector",
        Builtin{
            .signature = "@Vector(len: comptime_int, Element: type) type",
            .return_type = "type",
            .snippet = "@Vector(${1:len: comptime_int}, ${2:Element: type})",
            .documentation =
            \\Creates [Vectors](https://ziglang.org/documentation/0.15.0/#Vectors).
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "len: comptime_int",
                    .type = "comptime_int",
                },
                .{
                    .signature = "Element: type",
                    .type = "type",
                },
            },
        },
    },
    .{
        "@volatileCast",
        Builtin{
            .signature = "@volatileCast(value: anytype) DestType",
            .return_type = "DestType",
            .snippet = "@volatileCast(${1:value: anytype})",
            .documentation =
            \\Remove `volatile` qualifier from a pointer.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "value: anytype",
                    .type = "anytype",
                },
            },
        },
    },
    .{
        "@workGroupId",
        Builtin{
            .signature = "@workGroupId(comptime dimension: u32) u32",
            .return_type = "u32",
            .snippet = "@workGroupId(${1:comptime dimension: u32})",
            .documentation =
            \\Returns the index of the work group in the current kernel invocation in dimension `dimension`.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "comptime dimension: u32",
                    .type = "u32",
                },
            },
        },
    },
    .{
        "@workGroupSize",
        Builtin{
            .signature = "@workGroupSize(comptime dimension: u32) u32",
            .return_type = "u32",
            .snippet = "@workGroupSize(${1:comptime dimension: u32})",
            .documentation =
            \\Returns the number of work items that a work group has in dimension `dimension`.
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "comptime dimension: u32",
                    .type = "u32",
                },
            },
        },
    },
    .{
        "@workItemId",
        Builtin{
            .signature = "@workItemId(comptime dimension: u32) u32",
            .return_type = "u32",
            .snippet = "@workItemId(${1:comptime dimension: u32})",
            .documentation =
            \\Returns the index of the work item in the work group in dimension `dimension`. This function returns values between `0` (inclusive) and `@workGroupSize(dimension)` (exclusive).
            ,
            .parameters = &[_]Builtin.Parameter{
                .{
                    .signature = "comptime dimension: u32",
                    .type = "u32",
                },
            },
        },
    },
});

// DO NOT EDIT
