﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/ecr/ECR_EXPORTS.h>

namespace Aws {
namespace ECR {
namespace Model {
enum class RepositoryFilterType { NOT_SET, PREFIX_MATCH };

namespace RepositoryFilterTypeMapper {
AWS_ECR_API RepositoryFilterType GetRepositoryFilterTypeForName(const Aws::String& name);

AWS_ECR_API Aws::String GetNameForRepositoryFilterType(RepositoryFilterType value);
}  // namespace RepositoryFilterTypeMapper
}  // namespace Model
}  // namespace ECR
}  // namespace Aws
