﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/securityhub/SecurityHub_EXPORTS.h>
#include <aws/securityhub/model/AwsGuardDutyDetectorDataSourcesMalwareProtectionScanEc2InstanceWithFindingsDetails.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace SecurityHub {
namespace Model {

/**
 * <p> An object that contains information on the status of Malware Protection as a
 * data source for the detector. </p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails">AWS
 * API Reference</a></p>
 */
class AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails {
 public:
  AWS_SECURITYHUB_API AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails() = default;
  AWS_SECURITYHUB_API AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails(Aws::Utils::Json::JsonView jsonValue);
  AWS_SECURITYHUB_API AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_SECURITYHUB_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p> Describes the configuration of Malware Protection for EC2 instances with
   * findings. </p>
   */
  inline const AwsGuardDutyDetectorDataSourcesMalwareProtectionScanEc2InstanceWithFindingsDetails& GetScanEc2InstanceWithFindings() const {
    return m_scanEc2InstanceWithFindings;
  }
  inline bool ScanEc2InstanceWithFindingsHasBeenSet() const { return m_scanEc2InstanceWithFindingsHasBeenSet; }
  template <typename ScanEc2InstanceWithFindingsT = AwsGuardDutyDetectorDataSourcesMalwareProtectionScanEc2InstanceWithFindingsDetails>
  void SetScanEc2InstanceWithFindings(ScanEc2InstanceWithFindingsT&& value) {
    m_scanEc2InstanceWithFindingsHasBeenSet = true;
    m_scanEc2InstanceWithFindings = std::forward<ScanEc2InstanceWithFindingsT>(value);
  }
  template <typename ScanEc2InstanceWithFindingsT = AwsGuardDutyDetectorDataSourcesMalwareProtectionScanEc2InstanceWithFindingsDetails>
  AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails& WithScanEc2InstanceWithFindings(ScanEc2InstanceWithFindingsT&& value) {
    SetScanEc2InstanceWithFindings(std::forward<ScanEc2InstanceWithFindingsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The GuardDuty Malware Protection service role. </p>
   */
  inline const Aws::String& GetServiceRole() const { return m_serviceRole; }
  inline bool ServiceRoleHasBeenSet() const { return m_serviceRoleHasBeenSet; }
  template <typename ServiceRoleT = Aws::String>
  void SetServiceRole(ServiceRoleT&& value) {
    m_serviceRoleHasBeenSet = true;
    m_serviceRole = std::forward<ServiceRoleT>(value);
  }
  template <typename ServiceRoleT = Aws::String>
  AwsGuardDutyDetectorDataSourcesMalwareProtectionDetails& WithServiceRole(ServiceRoleT&& value) {
    SetServiceRole(std::forward<ServiceRoleT>(value));
    return *this;
  }
  ///@}
 private:
  AwsGuardDutyDetectorDataSourcesMalwareProtectionScanEc2InstanceWithFindingsDetails m_scanEc2InstanceWithFindings;

  Aws::String m_serviceRole;
  bool m_scanEc2InstanceWithFindingsHasBeenSet = false;
  bool m_serviceRoleHasBeenSet = false;
};

}  // namespace Model
}  // namespace SecurityHub
}  // namespace Aws
