/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.components;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.freeplane.core.ui.AntiAliasingConfigurator;

public class IconListComponent
extends JComponent
implements Accessible {
    private static final long serialVersionUID = 1L;
    private final List<Icon> icons;
    private final String description;
    private int horizontalAlignment;
    private int verticalAlignment;
    private boolean wrapsIcons;
    private Icon removedIcon;
    private Color removalColor = Color.RED;
    private IconBounds iconBoundsCache;
    private float currentZoom = 1.0f;

    public IconListComponent() {
        this(Collections.emptyList(), null);
    }

    public IconListComponent(List<? extends Icon> icons, String description) {
        this.description = description;
        this.icons = new ArrayList<Icon>(icons);
        this.horizontalAlignment = 2;
        this.verticalAlignment = 0;
        this.wrapsIcons = false;
        this.iconBoundsCache = null;
    }

    public List<Icon> getIcons() {
        return Collections.unmodifiableList(this.icons);
    }

    public String getDescription() {
        return this.description;
    }

    public void setIcons(List<? extends Icon> icons) {
        this.icons.clear();
        this.icons.addAll(icons);
        this.invalidateIconBoundsCache();
        this.revalidate();
        this.repaint();
    }

    public int getIconCount() {
        return this.icons.size();
    }

    public Icon removeIcon(int index) {
        Icon removed = this.icons.remove(index);
        this.invalidateIconBoundsCache();
        this.revalidate();
        this.repaint();
        return removed;
    }

    public void setHorizontalAlignment(int alignment) {
        if (alignment == this.horizontalAlignment) {
            return;
        }
        int oldValue = this.horizontalAlignment;
        this.horizontalAlignment = alignment;
        this.firePropertyChange("horizontalAlignment", oldValue, this.horizontalAlignment);
        this.invalidateIconBoundsCache();
        this.revalidate();
        this.repaint();
    }

    public void setVerticalAlignment(int alignment) {
        if (alignment == this.verticalAlignment) {
            return;
        }
        int oldValue = this.verticalAlignment;
        this.verticalAlignment = alignment;
        this.firePropertyChange("verticalAlignment", oldValue, this.verticalAlignment);
        this.invalidateIconBoundsCache();
        this.revalidate();
        this.repaint();
    }

    @Override
    public void invalidate() {
        this.invalidateIconBoundsCache();
        super.invalidate();
    }

    public void setWrapIcons(boolean wrapsIcons) {
        if (this.wrapsIcons != wrapsIcons) {
            this.wrapsIcons = wrapsIcons;
            this.invalidateIconBoundsCache();
            this.revalidate();
            this.repaint();
        }
    }

    public void setRemovalColor(Color color) {
        if (color != null && !color.equals(this.removalColor)) {
            this.removalColor = color;
            this.repaint();
        }
    }

    public void highlightRemovedIcon(Icon icon) {
        this.removedIcon = icon;
        this.repaint();
    }

    protected float getZoom() {
        return this.currentZoom;
    }

    protected boolean useFractionalMetrics() {
        return false;
    }

    private void invalidateIconBoundsCache() {
        this.iconBoundsCache = null;
    }

    private IconBounds calculateIconBounds() {
        if (this.iconBoundsCache == null) {
            Insets insets = this.getInsets();
            float zoom = this.getZoom();
            int width = this.getWidth();
            int availableWidth = (int)((float)((width > 0 ? width : Integer.MAX_VALUE) - insets.left - insets.right) / zoom);
            this.iconBoundsCache = this.calculateIconBounds((int)((float)insets.left / zoom), (int)((float)insets.top / zoom), availableWidth);
        }
        return this.iconBoundsCache;
    }

    private IconBounds calculateIconBounds(int leftInset, int topInset, int availableWidth) {
        ArrayList<IconLayout> iconLayouts = new ArrayList<IconLayout>();
        int currentY = topInset;
        List<Row> rows = this.organizeIconsIntoRows(availableWidth);
        int maximumRowWidth = IconBounds.calculateMaximumRowWidth(rows);
        int panelLeftInset = leftInset;
        for (Row row : rows) {
            int rowWidth = row.getTotalWidth();
            int rowHeight = row.getMaxHeight();
            int startingX = this.determineStartingX(rowWidth, availableWidth);
            boolean isLeftToRight = this.getComponentOrientation().isLeftToRight();
            int currentX = isLeftToRight ? panelLeftInset + startingX : panelLeftInset + availableWidth - startingX;
            for (Icon icon : row.getIcons()) {
                int iconWidth = icon.getIconWidth();
                int iconHeight = icon.getIconHeight();
                int paintX = isLeftToRight ? currentX : currentX - iconWidth;
                int paintY = this.calculatePaintY(currentY, rowHeight, iconHeight);
                iconLayouts.add(new IconLayout(icon, paintX, paintY));
                currentX += isLeftToRight ? iconWidth : -iconWidth;
            }
            currentY += rowHeight;
        }
        int totalHeight = currentY - topInset;
        return new IconBounds(iconLayouts, totalHeight, maximumRowWidth);
    }

    private List<Row> organizeIconsIntoRows(int availableWidth) {
        ArrayList<Row> rows = new ArrayList<Row>();
        Row currentRow = new Row();
        for (Icon icon : this.icons) {
            int iconWidth = icon.getIconWidth();
            if (this.wrapsIcons && !currentRow.isEmpty() && currentRow.getTotalWidth() + iconWidth > availableWidth) {
                rows.add(currentRow);
                currentRow = new Row();
            }
            currentRow.addIcon(icon);
        }
        if (!currentRow.isEmpty()) {
            rows.add(currentRow);
        }
        return rows;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        AntiAliasingConfigurator.setAntialiasing(g2);
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        super.paintComponent(g);
        IconBounds iconBounds = this.calculateIconBounds();
        if (!this.useFractionalMetrics()) {
            this.renderIcons(g, iconBounds.getIconLayouts());
            return;
        }
        if (!(g instanceof Graphics2D)) {
            this.renderIcons(g, iconBounds.getIconLayouts());
            return;
        }
        AffineTransform originalTransform = g2.getTransform();
        float factor = 0.97f;
        float zoom = this.getZoom() * factor;
        g2.scale(zoom, zoom);
        this.renderIcons(g2, iconBounds.getIconLayouts());
        g2.setTransform(originalTransform);
    }

    private void renderIcons(Graphics g, List<IconLayout> iconLayouts) {
        for (IconLayout layout : iconLayouts) {
            this.paintIcon(g, layout.getIcon(), layout.getX(), layout.getY());
        }
    }

    private void paintIcon(Graphics g, Icon icon, int paintX, int paintY) {
        icon.paintIcon(this, g, paintX, paintY);
        if (this.removedIcon == icon) {
            g.setColor(this.removalColor);
            g.drawLine(paintX, paintY, paintX + icon.getIconWidth(), paintY + icon.getIconHeight());
            g.drawLine(paintX + icon.getIconWidth(), paintY, paintX, paintY + icon.getIconHeight());
        }
    }

    public Icon getIconAt(Point point) {
        IconBounds iconBounds = this.calculateIconBounds();
        float zoom = this.getZoom();
        return this.findIconAtPoint(zoom == 1.0f ? point : new Point((int)((float)point.x / zoom), (int)((float)point.y / zoom)), iconBounds.getIconLayouts());
    }

    private Icon findIconAtPoint(Point point, List<IconLayout> iconLayouts) {
        for (IconLayout layout : iconLayouts) {
            if (!layout.contains(point)) continue;
            return layout.getIcon();
        }
        return null;
    }

    @Override
    public Dimension getPreferredSize() {
        IconBounds iconBounds = this.calculateIconBounds();
        int preferredWidth = iconBounds.getMaximumRowWidth();
        int preferredHeight = iconBounds.getTotalHeight();
        Insets insets = this.getInsets();
        float zoom = this.getZoom();
        int scaledWidth = (int)Math.ceil((float)preferredWidth * zoom) + insets.left + insets.right;
        int scaledHeight = (int)Math.ceil((float)preferredHeight * zoom) + insets.top + insets.bottom;
        return new Dimension(scaledWidth, scaledHeight);
    }

    private int determineStartingX(int rowWidth, int availableWidth) {
        int dx = availableWidth - rowWidth;
        switch (this.horizontalAlignment) {
            case 0: {
                return dx / 2;
            }
            case 4: {
                return this.getComponentOrientation().isLeftToRight() ? dx : 0;
            }
        }
        return this.getComponentOrientation().isLeftToRight() ? 0 : dx;
    }

    private int calculatePaintY(int rowY, int rowHeight, int iconHeight) {
        switch (this.verticalAlignment) {
            case 0: {
                return rowY + (rowHeight - iconHeight) / 2;
            }
            case 1: {
                return rowY;
            }
            case 3: {
                return rowY + rowHeight - iconHeight;
            }
        }
        return rowY;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleIconListComponent();
        }
        return this.accessibleContext;
    }

    private static class IconBounds {
        private final List<IconLayout> iconLayouts;
        private final int totalHeight;
        private final int maximumRowWidth;

        public IconBounds(List<IconLayout> iconLayouts, int totalHeight, int maximumRowWidth) {
            this.iconLayouts = iconLayouts;
            this.totalHeight = totalHeight;
            this.maximumRowWidth = maximumRowWidth;
        }

        static int calculateMaximumRowWidth(List<Row> rows) {
            int max = 0;
            for (Row row : rows) {
                max = Math.max(max, row.getTotalWidth());
            }
            return max;
        }

        public List<IconLayout> getIconLayouts() {
            return this.iconLayouts;
        }

        public int getTotalHeight() {
            return this.totalHeight;
        }

        public int getMaximumRowWidth() {
            return this.maximumRowWidth;
        }

        public String toString() {
            return "IconBounds [iconLayouts=" + this.iconLayouts + ", totalHeight=" + this.totalHeight + ", maximumRowWidth=" + this.maximumRowWidth + "]";
        }
    }

    private static class Row {
        private final List<Icon> icons = new ArrayList<Icon>();
        private int totalWidth = 0;
        private int maxHeight = 0;

        public void addIcon(Icon icon) {
            this.icons.add(icon);
            this.totalWidth += icon.getIconWidth();
            this.maxHeight = Math.max(this.maxHeight, icon.getIconHeight());
        }

        public List<Icon> getIcons() {
            return this.icons;
        }

        public int getTotalWidth() {
            return this.totalWidth;
        }

        public int getMaxHeight() {
            return this.maxHeight;
        }

        public boolean isEmpty() {
            return this.icons.isEmpty();
        }
    }

    private static class IconLayout {
        private final Icon icon;
        private final int x;
        private final int y;

        public IconLayout(Icon icon, int x, int y) {
            this.icon = icon;
            this.x = x;
            this.y = y;
        }

        public boolean contains(Point point) {
            return this.x <= point.x && this.y <= point.y && point.x < this.x + this.icon.getIconWidth() && point.y < this.y + this.icon.getIconHeight();
        }

        public Icon getIcon() {
            return this.icon;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public String toString() {
            return "IconLayout [icon=" + this.icon + ", x=" + this.x + ", y=" + this.y + "]";
        }
    }

    protected class AccessibleIconListComponent
    extends JComponent.AccessibleJComponent {
        private static final long serialVersionUID = 1L;

        protected AccessibleIconListComponent() {
            super(IconListComponent.this);
        }

        @Override
        public String getAccessibleName() {
            return IconListComponent.this.description != null ? IconListComponent.this.description : super.getAccessibleName();
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LABEL;
        }
    }
}

