/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.googleai;

import com.fasterxml.jackson.core.type.TypeReference;
import dev.langchain4j.Experimental;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.googleai.BaseGeminiChatModel;
import dev.langchain4j.model.googleai.BatchRequestResponse;
import dev.langchain4j.model.googleai.GeminiBatchProcessor;
import dev.langchain4j.model.googleai.GeminiFiles;
import dev.langchain4j.model.googleai.GeminiGenerateContentRequest;
import dev.langchain4j.model.googleai.GeminiGenerateContentResponse;
import dev.langchain4j.model.googleai.GeminiService;
import dev.langchain4j.model.googleai.Json;
import dev.langchain4j.model.googleai.jsonl.JsonLinesWriter;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;

@Experimental
public final class GoogleAiGeminiBatchChatModel {
    private final GeminiBatchProcessor<ChatRequest, ChatResponse, GeminiGenerateContentRequest, GeminiGenerateContentResponse> batchProcessor;
    private final BaseGeminiChatModel chatModel;
    private final String modelName;
    private final ChatRequestPreparer preparer = new ChatRequestPreparer();

    GoogleAiGeminiBatchChatModel(Builder builder) {
        this(builder, BaseGeminiChatModel.buildGeminiService(builder));
    }

    GoogleAiGeminiBatchChatModel(Builder builder, GeminiService geminiService) {
        this.batchProcessor = new GeminiBatchProcessor<ChatRequest, ChatResponse, GeminiGenerateContentRequest, GeminiGenerateContentResponse>(geminiService, this.preparer);
        this.chatModel = new BaseGeminiChatModel(builder, geminiService);
        this.modelName = builder.modelName;
    }

    public BatchRequestResponse.BatchResponse<ChatResponse> createBatchInline(String displayName, @Nullable Long priority, List<ChatRequest> requests) {
        GoogleAiGeminiBatchChatModel.validateModelInChatRequests(this.modelName, requests);
        return this.batchProcessor.createBatchInline(displayName, priority, requests, this.modelName, GeminiService.BatchOperationType.BATCH_GENERATE_CONTENT);
    }

    public BatchRequestResponse.BatchResponse<ChatResponse> createBatchFromFile(String displayName, GeminiFiles.GeminiFile file) {
        return this.batchProcessor.createBatchFromFile(displayName, file, this.modelName, GeminiService.BatchOperationType.BATCH_GENERATE_CONTENT);
    }

    public void writeBatchToFile(JsonLinesWriter writer, Iterable<BatchRequestResponse.BatchFileRequest<ChatRequest>> requests) throws IOException {
        for (BatchRequestResponse.BatchFileRequest<ChatRequest> request : requests) {
            GeminiGenerateContentRequest inlinedRequest = this.preparer.createInlinedRequest(request.request());
            writer.write(new BatchRequestResponse.BatchFileRequest<GeminiGenerateContentRequest>(request.key(), inlinedRequest));
        }
    }

    public BatchRequestResponse.BatchResponse<ChatResponse> retrieveBatchResults(BatchRequestResponse.BatchName name) {
        return this.batchProcessor.retrieveBatchResults(name);
    }

    public void cancelBatchJob(BatchRequestResponse.BatchName name) {
        this.batchProcessor.cancelBatchJob(name);
    }

    public void deleteBatchJob(BatchRequestResponse.BatchName name) {
        this.batchProcessor.deleteBatchJob(name);
    }

    public BatchRequestResponse.BatchList<ChatResponse> listBatchJobs(@Nullable Integer pageSize, @Nullable String pageToken) {
        return this.batchProcessor.listBatchJobs(pageSize, pageToken);
    }

    private static void validateModelInChatRequests(String modelName, List<ChatRequest> requests) {
        Set modelNames = Stream.concat(requests.stream().map(ChatRequest::modelName), Stream.of(modelName)).filter(Objects::nonNull).collect(Collectors.toSet());
        if (modelNames.size() != 1) {
            throw new IllegalArgumentException("Batch requests cannot contain ChatRequest objects with different models; all requests must use the same model: " + String.valueOf(modelNames));
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends BaseGeminiChatModel.GoogleAiGeminiChatModelBaseBuilder<Builder> {
        private Builder() {
        }

        public GoogleAiGeminiBatchChatModel build() {
            return new GoogleAiGeminiBatchChatModel(this);
        }
    }

    private class ChatRequestPreparer
    implements GeminiBatchProcessor.RequestPreparer<ChatRequest, GeminiGenerateContentRequest, GeminiGenerateContentResponse, ChatResponse> {
        private static final TypeReference<BatchRequestResponse.BatchCreateResponse.InlinedResponseWrapper<GeminiGenerateContentResponse>> responseWrapperType = new TypeReference<BatchRequestResponse.BatchCreateResponse.InlinedResponseWrapper<GeminiGenerateContentResponse>>(){};

        private ChatRequestPreparer() {
        }

        @Override
        public ChatRequest prepareRequest(ChatRequest request) {
            return ChatRequest.builder().messages(request.messages()).parameters(GoogleAiGeminiBatchChatModel.this.chatModel.defaultRequestParameters.overrideWith(request.parameters())).build();
        }

        @Override
        public GeminiGenerateContentRequest createInlinedRequest(ChatRequest request) {
            return GoogleAiGeminiBatchChatModel.this.chatModel.createGenerateContentRequest(request);
        }

        @Override
        public List<ChatResponse> extractResponses(BatchRequestResponse.BatchCreateResponse<GeminiGenerateContentResponse> response) {
            if (response == null || response.inlinedResponses() == null) {
                return List.of();
            }
            return response.inlinedResponses().inlinedResponses().stream().map(wrapper -> Json.convertValue(wrapper, responseWrapperType)).map(BatchRequestResponse.BatchCreateResponse.InlinedResponseWrapper::response).map(GoogleAiGeminiBatchChatModel.this.chatModel::processResponse).toList();
        }
    }
}

