/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.image.node.AclsImageNode;
import org.apache.kafka.image.writer.ImageWriter;
import org.apache.kafka.metadata.authorizer.StandardAcl;
import org.apache.kafka.metadata.authorizer.StandardAclWithId;

public record AclsImage(Map<Uuid, StandardAcl> acls) {
    public static final AclsImage EMPTY = new AclsImage(Map.of());

    public AclsImage(Map<Uuid, StandardAcl> acls) {
        this.acls = Collections.unmodifiableMap(acls);
    }

    public boolean isEmpty() {
        return this.acls.isEmpty();
    }

    public void write(ImageWriter writer) {
        for (Map.Entry<Uuid, StandardAcl> entry : this.acls.entrySet()) {
            StandardAclWithId aclWithId = new StandardAclWithId(entry.getKey(), entry.getValue());
            writer.write(0, aclWithId.toRecord());
        }
    }

    @Override
    public String toString() {
        return new AclsImageNode(this).stringify();
    }
}

