/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.cache;

import java.time.Duration;
import java.util.Objects;
import java.util.function.Function;

public record LocalCacheConfiguration<K, V>(String name, int maxSize, Duration expiration, Function<K, V> loader) {
    public LocalCacheConfiguration {
        Objects.requireNonNull(name, "A cache name must be configured");
    }

    public boolean hasExpiration() {
        return this.expiration != null;
    }

    public boolean hasLoader() {
        return this.loader != null;
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    public static class Builder<K, V> {
        private String name;
        private int maxSize = -1;
        private Duration expiration;
        private Function<K, V> loader;

        public Builder<K, V> name(String name) {
            this.name = name;
            return this;
        }

        public Builder<K, V> maxSize(int maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public Builder<K, V> expiration(Duration duration) {
            this.expiration = duration;
            return this;
        }

        public Builder<K, V> loader(Function<K, V> loader) {
            this.loader = loader;
            return this;
        }

        public LocalCacheConfiguration<K, V> build() {
            return new LocalCacheConfiguration<K, V>(this.name, this.maxSize, this.expiration, this.loader);
        }
    }
}

