/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin.fgap;

import java.util.Map;
import java.util.Set;
import org.keycloak.Config;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.resources.admin.fgap.FineGrainedAdminPermissionEvaluator;
import org.keycloak.services.resources.admin.fgap.MgmtPermissions;
import org.keycloak.services.resources.admin.fgap.ModelRecord;
import org.keycloak.services.resources.admin.fgap.RolePermissions;

class RolePermissionsV2
extends RolePermissions {
    private final FineGrainedAdminPermissionEvaluator eval;

    RolePermissionsV2(KeycloakSession session, RealmModel realm, AuthorizationProvider authz, MgmtPermissions root) {
        super(session, realm, authz, root);
        this.eval = new FineGrainedAdminPermissionEvaluator(session, root, this.resourceStore, this.policyStore);
    }

    private boolean isRealmAdmin() {
        RoleModel masterAdminRole;
        RealmModel masterRealm = this.getMasterRealm();
        UserModel admin = this.root.admin();
        if (admin.hasRole(masterAdminRole = masterRealm.getRole("admin"))) {
            return true;
        }
        ClientModel realmManagementClient = this.getRealmManagementClient();
        if (realmManagementClient != null) {
            RoleModel realmAdminRole = realmManagementClient.getRole("realm-admin");
            return realmAdminRole != null && admin.hasRole(realmAdminRole);
        }
        return false;
    }

    @Override
    public boolean canMapRole(RoleModel role) {
        if (this.isRealmAdminRole(role)) {
            if ("view-system".equals(role.getName()) && !this.root.isAdmin(this.getMasterRealm())) {
                return false;
            }
            if (this.realm.isAdminPermissionsEnabled()) {
                return this.isRealmAdmin();
            }
            return this.root.hasOneAdminRole("manage-users") && this.checkAdminRoles(role);
        }
        if (this.root.hasOneAdminRole("manage-users")) {
            return true;
        }
        RoleContainerModel roleContainerModel = role.getContainer();
        if (roleContainerModel instanceof ClientModel) {
            ClientModel clientModel = (ClientModel)roleContainerModel;
            if (this.root.clients().canMapRoles(clientModel)) {
                return true;
            }
        }
        return this.eval.hasPermission(new ModelRecord.RoleModelRecord(role), null, "map-role");
    }

    @Override
    public boolean canMapComposite(RoleModel role) {
        if (this.isRealmAdminRole(role)) {
            if ("view-system".equals(role.getName()) && !this.root.isAdmin(this.getMasterRealm())) {
                return false;
            }
            if (this.realm.isAdminPermissionsEnabled()) {
                return this.isRealmAdmin();
            }
            return this.canManageDefault(role) && this.checkAdminRoles(role);
        }
        if (this.canManageDefault(role)) {
            return this.checkAdminRoles(role);
        }
        RoleContainerModel roleContainerModel = role.getContainer();
        if (roleContainerModel instanceof ClientModel) {
            ClientModel clientModel = (ClientModel)roleContainerModel;
            if (this.root.hasOneAdminRole("manage-clients")) {
                return true;
            }
            if (this.root.clients().canMapCompositeRoles(clientModel)) {
                return true;
            }
        } else if (this.root.hasOneAdminRole("manage-realm")) {
            return true;
        }
        return this.eval.hasPermission(new ModelRecord.RoleModelRecord(role), null, "map-role-composite");
    }

    @Override
    public boolean canMapClientScope(RoleModel role) {
        RoleContainerModel roleContainerModel = role.getContainer();
        if (roleContainerModel instanceof ClientModel) {
            ClientModel clientModel = (ClientModel)roleContainerModel;
            if (this.root.hasOneAdminRole("manage-clients")) {
                return true;
            }
            if (this.root.clients().canMapClientScopeRoles(clientModel)) {
                return true;
            }
        } else if (this.root.hasOneAdminRole("manage-realm")) {
            return true;
        }
        return this.eval.hasPermission(new ModelRecord.RoleModelRecord(role), null, "map-role-client-scope");
    }

    @Override
    public Set<String> getRoleIdsByScope(String scope) {
        return this.eval.getIdsByScope("Roles", scope);
    }

    @Override
    public boolean isPermissionsEnabled(RoleModel role) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public void setPermissionsEnabled(RoleModel role, boolean enable) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public Map<String, String> getPermissions(RoleModel role) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public Policy mapRolePermission(RoleModel role) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public Policy mapCompositePermission(RoleModel role) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public Policy mapClientScopePermission(RoleModel role) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public Resource resource(RoleModel role) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public ResourceServer resourceServer(RoleModel role) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public Policy manageUsersPolicy(ResourceServer server) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public Policy viewUsersPolicy(ResourceServer server) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    @Override
    public Policy rolePolicy(ResourceServer server, RoleModel role) {
        throw new UnsupportedOperationException("Not supported in V2");
    }

    private boolean isRealmAdminRole(RoleModel role) {
        ClientModel c;
        RoleContainerModel container = role.getContainer();
        boolean isMasterRealmRole = container.equals((Object)this.getMasterRealm());
        boolean isMasterRealmManagementAdminRole = container instanceof ClientModel && (c = (ClientModel)container).getRealm().getName().equals(Config.getAdminRealm()) && c.getClientId().endsWith("-realm");
        boolean isRealmManagementAdminRole = container.equals((Object)this.getRealmManagementClient());
        if (isMasterRealmRole || isRealmManagementAdminRole || isMasterRealmManagementAdminRole) {
            return AdminRoles.ALL_ROLES.contains(role.getName());
        }
        return false;
    }

    private RealmModel getMasterRealm() {
        return this.root.adminsRealm().getName().equals(Config.getAdminRealm()) ? this.root.adminsRealm() : this.session.realms().getRealmByName(Config.getAdminRealm());
    }
}

