# Fourth-generation NZXT liquid coolers protocol

## Generic Operations

### Get firmware info

- Request: 
  - Header: `0x10 0x01`
- Response: 
  - Header: `0x11 0x01`
  - Data:
      - Byte 3: Firmware major version
      - Byte 4: Firmware minor version
      - Byte 5: Firmware patch version

## RGB Operations

### Get RGB info

- Request: 
  - Header: `0x20 0x01`
- Response: 
  - Header: `0x21 0x01`
  - Data:
      - Byte 14: Number of rgb channels
      - Byte 21: `0x10` IF device has ring rgb (Kraken X3 Only)
      - Byte 27: `0x11` IF device has logo rgb (Kraken X3 Only)

## Cooling Operations

### Get cooling info

- Request: 
  - Header: `0x74 0x01`
- Response: 
  - Header: `0x75 0x01`
  - Data:
      - Byte 15: Liquid temperature (integer digits)
      - Byte 16: Liquid temperature (decimal digits)
      - Byte 17-18: Pump rpm (little endian)
      - Byte 19: Pump duty %
      - Byte 23-24: Fan rpm (little endian)
      - Byte 25: Fan duty %

### Set speed profile

- Request: 
  - Header: `0x72`
  - Data:
    - Byte 2-4: Channel to configure. Possible values are:
      - `0x01 0x00 0x00`: Pump control (Kraken X3 and Z3)
      - `0x01 0x01 0x00`: Pump control (Kraken 2023)
      - `0x02 0x00 0x00`: Fan control (Kraken X3 and Z3)
      - `0x02 0x01 0x01`: Fan control (Kraken 2023)
    - Byte 5-44 (40 bytes): the representation of a cooling curve where every byte is a value 0-100 setting the speed of the channel at the specific temperature (temperature 20 to 60degree). This is almost always set as a flat curve with all identical values.
- Response: 
  - Header: `0x73`
 

## LCD Operations

### Get lcd info

- Request: 
  - Header: `0x30 0x01`
- Response: 
  - Header: `0x31 0x01`
  - Data:
      - Byte 18: lcd brightness % 
      - Byte 26: lcd orientation (as index of [0, 90, 180, 270])

### Set lcd brightness/orientation

- Request: 
  - Header: `0x30 0x02`
  - Data:
    - Byte 3: `0x01`
    - Byte 4: lcd brightness % 
    - Byte 7: `0x01`
    - Byte 8: lcd orientation (as index of [0, 90, 180, 270])
- Response: 
  - Header: `0x31 0x02`

### Set lcd mode

- Request: 
  - Header: `0x38 0x01`
  - Data:
    - Byte 3: Lcd mode. Valid modes are:
      - `0x02`: show liquid temperature
      - `0x04`: show image/gif stored in selected bucket 
      - `0x05`: fast rendering (only Kraken 2023 elite)
    - Byte 4: selected bucket (only needed for mode 4 )
    
- Response: 
  - Header: `0x39 0x01`
  - Data:
    - Byte 14: `0x01` if the operation has been execute successfully

### Get memory bucket info

- Request: 
  - Header: `0x30 0x04`
  - Data:
    - Byte 3: Bucket index (0 to 15)
    
- Response: 
  - Header: `0x31 0x04`
  - Data:
    - Byte 15: Bucket index (0 to 15)
    > The following are all 0 if the bucket does not exist
    - Byte 16: asset index (typically bucket index + 1)
    - Byte 17: `0x02`
    - Byte 18-19: starting memory address in kilobytes (little endian) 
    - Byte 20-21: memory size in kilobytes (little endian)

### Create memory bucket

- Request: 
  - Header: `0x32 0x01`
  - Data:
    - Byte 3: Bucket index (0 to 15)
    - Byte 4: Asset index (typically bucket index + 1)
    - Byte 5-6: starting memory address in kilobytes (little endian) 
    - Byte 7-8: memory size in kilobytes (little endian)
    - `0x01`

- Response: 
  - Header: `0x33 0x02`
  - Data:
    - Byte 14: `0x01` if the operation has been execute successfully

### Delete memory bucket

- Request: 
  - Header: `0x32 0x02`
  - Data:
    - Byte 3: Bucket index (0 to 15)
    
- Response: 
  - Header: `0x33 0x02`
  - Data:
    - Byte 14: `0x01` if the operation has been execute successfully


### Start data transfer

- Request: 
  - Header: `0x36 0x01`
  - Data:
    - Byte 3: Bucket index to write to (0 to 15)
- Response: 
  - Header: `0x37 0x01`
  - Data:
    - Byte 14: `0x01` if the operation has been execute successfully

### End data transfer

- Request: 
  - Header: `0x36 0x02`
  - Data:
    - Byte 3: Bucket index to write to (0 to 15)
- Response: 
  - Header: `0x37 0x02`
  - Data:
    - Byte 14: `0x01` if the operation has been execute successfully
  
### Cancel all data transfers

- Request: 
  - Header: `0x36 0x03`
    
- Response: 
  - Header: `0x37 0x03`


### Transfer data
> the following data is sent to the bulk_transfer endpoint of the device

- Transfer 1: 
  - Header: `0x12 0xFA 0x01 0xE8 0xAB 0xCD 0xEF 0x98 0x76 0x54 0x32 0x10`
  - Data:
    - Byte 13: data type. Possible values are:
      - `0x01`: GIF data
      - `0x02`: Static RGBA data
      - `0x06`: Q565 Image data (only kraken 2023 with firmware >= v2.0.0)
      - `0x08`: Q565 Image data (only kraken 2023 elit with firmware > v2.0.0)
- Transfer 2: 
  - Data: The binary data of the image you want to send to the device